/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.starter;

import java.awt.Taskbar;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryController;
import mediathek.controller.starter.DirectHttpDownload;
import mediathek.controller.starter.ExternalProgramDownload;
import mediathek.controller.starter.Start;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.gui.messages.BaseEvent;
import mediathek.gui.messages.ButtonStartEvent;
import mediathek.gui.messages.DownloadProgressChangedEvent;
import mediathek.gui.messages.StartEvent;
import mediathek.mac.SpotlightCommentWriter;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.Datum;
import mediathek.tool.notification.thrift.MessageType;
import mediathek.tool.notification.thrift.NotificationMessage;
import net.engio.mbassy.bus.MBassador;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StarterClass {
    private static final Logger logger = LogManager.getLogger(StarterClass.class);
    private final Daten daten;
    private final Starten starten;
    private boolean pause = false;
    private static final FastDateFormat formatter = FastDateFormat.getInstance("HH:mm:ss");

    public StarterClass(Daten daten) {
        this.daten = daten;
        this.starten = new Starten();
        this.starten.start();
    }

    static boolean pruefen(Daten daten, DatenDownload datenDownload, Start start) {
        boolean ret = false;
        if (start != null && start.percent > -1 && start.percent < 995) {
            logger.error("Download fehlgeschlagen: 99,5% wurden nicht erreicht: {}", (Object)datenDownload.arr[31]);
            return false;
        }
        File file = new File(datenDownload.arr[31]);
        if (!file.exists()) {
            logger.error("Download fehlgeschlagen, Datei existiert nicht: {}", (Object)datenDownload.arr[31]);
        } else if (file.length() < 262144L) {
            logger.error("Download fehlgeschlagen, Datei zu klein:{}", (Object)datenDownload.arr[31]);
        } else {
            if (datenDownload.isFromAbo()) {
                daten.getAboHistoryController().zeileSchreiben(datenDownload.arr[4], datenDownload.arr[5], datenDownload.arr[20]);
            }
            ret = true;
        }
        return ret;
    }

    static void deleteIfEmpty(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0]) && Files.size(path) < 262144L) {
                Files.delete(path);
            }
        }
        catch (IOException ex) {
            logger.error("Fehler beim L\u00f6schen: {}", (Object)path.toAbsolutePath().toString());
        }
    }

    static void startmeldung(DatenDownload datenDownload, Start start) {
        boolean abspielen;
        ArrayList<Object> text = new ArrayList<Object>();
        boolean bl = abspielen = datenDownload.quelle == 1;
        if (abspielen) {
            text.add("Film abspielen");
        } else {
            if (start.startcounter > 1) {
                text.add("Download starten - Restart (Summe Starts: " + start.startcounter + ")");
            } else {
                text.add("Download starten");
            }
            text.add("Programmset: " + datenDownload.arr[24]);
            text.add("Ziel: " + datenDownload.arr[31]);
        }
        text.add("URL: " + datenDownload.arr[21]);
        text.add("Startzeit: " + formatter.format(start.startZeit));
        if (datenDownload.art == 1) {
            text.add("direkter Download");
        } else {
            text.add("Programmaufruf: " + datenDownload.arr[26]);
            text.add("Programmaufruf[]: " + datenDownload.arr[27]);
        }
        logger.info(text);
    }

    private static void makeBeep() {
        if (ApplicationConfiguration.getConfiguration().getBoolean("download.sound.beep", false)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private static void fertigmeldung(DatenDownload datenDownload, Start start, boolean abgebrochen) {
        StarterClass.makeBeep();
        ArrayList<Object> text = new ArrayList<Object>();
        if (abgebrochen) {
            text.add("Download wurde abgebrochen");
        } else if (datenDownload.quelle == 1) {
            text.add("Film fertig");
        } else {
            if (start.stoppen) {
                text.add("Download abgebrochen");
            } else if (start.status == 3) {
                text.add("Download ist fertig und hat geklappt");
            } else if (start.status == 4) {
                text.add("Download ist fertig und war fehlerhaft");
            }
            if (datenDownload.isDownloadManager()) {
                text.add("Programm ist ein Downloadmanager");
            }
            text.add("Programmset: " + datenDownload.arr[24]);
            text.add("Ziel: " + datenDownload.arr[31]);
        }
        text.add("Startzeit: " + formatter.format(start.startZeit));
        text.add("Endzeit: " + formatter.format(new Date().getTime()));
        text.add("Restarts: " + start.countRestarted);
        text.add("Dauer: " + start.startZeit.diffInSekunden() + " s");
        long dauer = start.startZeit.diffInMinuten();
        if (dauer == 0L) {
            text.add("Dauer: <1 Min.");
        } else {
            text.add("Dauer: " + start.startZeit.diffInMinuten() + " Min");
        }
        if (datenDownload.art == 1 && start.mVBandwidthCountingInputStream != null) {
            text.add("Bytes gelesen: " + FileUtils.byteCountToDisplaySize(start.mVBandwidthCountingInputStream.getSumByte()));
            text.add("Bandbreite: " + DatenDownload.getTextBandbreite(start.mVBandwidthCountingInputStream.getSumBandwidth()));
        }
        text.add("URL: " + datenDownload.arr[21]);
        if (datenDownload.art == 1) {
            text.add("direkter Download");
        } else {
            text.add("Programmaufruf: " + datenDownload.arr[26]);
            text.add("Programmaufruf[]: " + datenDownload.arr[27]);
        }
        logger.info(text);
        if (!start.stoppen && !abgebrochen && datenDownload.quelle != 1) {
            StarterClass.addNotification(datenDownload, start.status != 4);
        }
    }

    private static void addNotification(DatenDownload datenDownload, boolean erfolgreich) {
        String[] m3 = new String[]{"Film:   " + datenDownload.arr[5], "Sender: " + datenDownload.arr[3], "Gr\u00f6\u00dfe:  " + FileUtils.byteCountToDisplaySize(datenDownload.mVFilmSize.getSize())};
        StringBuilder meldung = new StringBuilder();
        for (String s2 : m3) {
            meldung.append(s2).append('\n');
        }
        NotificationMessage msg = new NotificationMessage();
        msg.setMessage(meldung.toString());
        if (erfolgreich) {
            msg.setType(MessageType.INFO);
            msg.setTitle("Download war erfolgreich");
        } else {
            msg.setType(MessageType.ERROR);
            msg.setTitle("Download war fehlerhaft");
        }
        Daten.getInstance().notificationCenter().displayNotification(msg);
    }

    private static void writeSpotlightComment(DatenDownload datenDownload, DirectHttpDownload.HttpDownloadState state) {
        if (state != DirectHttpDownload.HttpDownloadState.CANCEL && Boolean.parseBoolean(datenDownload.arr[36])) {
            SpotlightCommentWriter writer = new SpotlightCommentWriter();
            writer.writeComment(datenDownload);
        }
    }

    public static void finalizeDownload(DatenDownload datenDownload, Start start, DirectHttpDownload.HttpDownloadState state) {
        StarterClass.deleteIfEmpty(Paths.get(datenDownload.arr[31], new String[0]));
        StarterClass.setFileSize(datenDownload);
        if (SystemUtils.IS_OS_MAC_OSX) {
            StarterClass.writeSpotlightComment(datenDownload, state);
        }
        StarterClass.fertigmeldung(datenDownload, start, state == DirectHttpDownload.HttpDownloadState.CANCEL);
        if (state == DirectHttpDownload.HttpDownloadState.CANCEL) {
            datenDownload.resetDownload();
        } else {
            start.restSekunden = -1L;
            start.percent = 1000;
            datenDownload.mVFilmSize.setAktSize(-1L);
        }
        StarterClass.notifyStartEvent(datenDownload);
        if (SystemUtils.IS_OS_MAC_OSX) {
            Taskbar.getTaskbar().requestUserAttention(true, false);
        }
    }

    private static void setFileSize(DatenDownload datenDownload) {
        try {
            long length;
            File testFile = new File(datenDownload.arr[31]);
            if (testFile.exists() && (length = testFile.length()) > 0L) {
                datenDownload.mVFilmSize.setSize(length);
            }
        }
        catch (Exception ex) {
            logger.error("Fehler beim Ermitteln der Dateigr\u00f6\u00dfe: {}", (Object)datenDownload.arr[31]);
        }
    }

    static void notifyStartEvent(DatenDownload datenDownload) {
        MBassador<BaseEvent> messageBus = Daten.getInstance().getMessageBus();
        messageBus.publishAsync(new StartEvent());
        if (datenDownload != null && datenDownload.quelle == 1) {
            messageBus.publishAsync(new ButtonStartEvent());
        }
    }

    public synchronized void urlMitProgrammStarten(DatenPset pSet, DatenFilm ersterFilm, String aufloesung) {
        String url = ersterFilm.getUrl();
        if (!url.isEmpty()) {
            DatenDownload d = new DatenDownload(pSet, ersterFilm, 1, null, "", "", aufloesung);
            d.start = new Start();
            this.starten.launchDownloadThread(d);
            try (SeenHistoryController historyController = new SeenHistoryController();){
                historyController.writeManualEntry(ersterFilm.getThema(), ersterFilm.getTitle(), d.arr[20]);
            }
            if (ersterFilm.isBookmarked()) {
                ersterFilm.getBookmark().setSeen(true);
            }
            this.daten.getListeDownloadsButton().addMitNummer(d);
        }
    }

    public void pause() {
        this.pause = true;
    }

    private void reStartmeldung(DatenDownload datenDownload) {
        ArrayList<CallSite> text = new ArrayList<CallSite>();
        text.add((CallSite)((Object)("Fehlerhaften Download neu starten - Restart (Summe Starts: " + datenDownload.start.countRestarted + ")")));
        text.add((CallSite)((Object)("Ziel: " + datenDownload.arr[31])));
        text.add((CallSite)((Object)("URL: " + datenDownload.arr[21])));
        logger.info(text);
    }

    private class Starten
    extends Thread {
        public Starten() {
            this.setName("StarterClass.Starten Thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    DatenDownload datenDownload;
                    while ((datenDownload = this.getNextStart()) != null) {
                        this.launchDownloadThread(datenDownload);
                        TimeUnit.SECONDS.sleep(3L);
                    }
                    StarterClass.this.daten.getListeDownloadsButton().buttonStartsPutzen();
                    TimeUnit.SECONDS.sleep(3L);
                }
                catch (Exception ex) {
                    logger.error("Fehler in Starten Thread:", (Throwable)ex);
                }
            }
        }

        private synchronized DatenDownload getNextStart() throws InterruptedException {
            DatenDownload download;
            if (StarterClass.this.pause) {
                TimeUnit.SECONDS.sleep(5L);
                StarterClass.this.pause = false;
            }
            if ((download = StarterClass.this.daten.getListeDownloads().getNextStart()) == null && (download = StarterClass.this.daten.getListeDownloads().getRestartDownload()) != null) {
                StarterClass.this.reStartmeldung(download);
            }
            return download;
        }

        private void launchDownloadThread(DatenDownload datenDownload) {
            datenDownload.start.startZeit = new Datum();
            StarterClass.this.daten.getMessageBus().publishAsync(new DownloadProgressChangedEvent());
            switch (datenDownload.art) {
                case 2: {
                    ExternalProgramDownload downloadThread = new ExternalProgramDownload(StarterClass.this.daten, datenDownload);
                    downloadThread.start();
                    break;
                }
                case 1: {
                    DirectHttpDownload downloadThread = new DirectHttpDownload(StarterClass.this.daten, datenDownload);
                    downloadThread.start();
                    break;
                }
                default: {
                    logger.error("StarterClass.Starten - Switch-default");
                }
            }
        }
    }
}

