/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import com.zaxxer.hikari.HikariDataSource;
import java.lang.ref.Cleaner;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import mediathek.config.Daten;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenFilmCleanupTask;
import mediathek.daten.DatenFilmFlags;
import mediathek.daten.FilmResolution;
import mediathek.daten.PooledDatabaseConnection;
import mediathek.javafx.bookmark.BookmarkData;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.DatumFilm;
import mediathek.tool.FileSize;
import mediathek.tool.FilmSize;
import mediathek.tool.GermanStringSorter;
import mediathek.tool.MemoryUtils;
import mediathek.tool.sql.SqlAutoRollback;
import mediathek.tool.sql.SqlAutoSetAutoCommit;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DatenFilm
implements AutoCloseable,
Comparable<DatenFilm>,
Cloneable {
    public static final int FILM_NR = 0;
    public static final int FILM_SENDER = 1;
    public static final int FILM_THEMA = 2;
    public static final int FILM_TITEL = 3;
    public static final int FILM_ABSPIELEN = 4;
    public static final int FILM_AUFZEICHNEN = 5;
    public static final int FILM_MERKEN = 6;
    public static final int FILM_DATUM = 7;
    public static final int FILM_ZEIT = 8;
    public static final int FILM_DAUER = 9;
    public static final int FILM_GROESSE = 10;
    public static final int FILM_HD = 11;
    public static final int FILM_UT = 12;
    public static final int FILM_GEO = 13;
    public static final int FILM_URL = 14;
    public static final int FILM_DATUM_LONG = 15;
    public static final int FILM_REF = 16;
    public static final int MAX_ELEM = 17;
    private static final AtomicInteger FILM_COUNTER = new AtomicInteger(0);
    private static final GermanStringSorter sorter = GermanStringSorter.getInstance();
    private static final Logger logger = LogManager.getLogger(DatenFilm.class);
    private final EnumSet<DatenFilmFlags> flags = EnumSet.noneOf(DatenFilmFlags.class);
    private DatenAbo abo;
    private BookmarkData bookmark;
    private DatumFilm datumFilm = DatumFilm.UNDEFINED_FILM_DATE;
    private FilmSize filmSize;
    private long filmLength;
    private int databaseFilmNumber;
    private Cleaner.Cleanable cleaner;
    private String websiteLink;
    private String description;
    private String urlKlein = "";
    private Optional<String> highQuality_url = Optional.empty();
    private String aboName = "";
    private String datumLong = "";
    private String sender = "";
    private String thema = "";
    private String titel = "";
    private Optional<String> availableInCountries = Optional.empty();
    private Optional<String> subtitle_url = Optional.empty();
    private String datum = "";
    private String sendeZeit = "";
    private String dauer = "";
    private String groesse = "";
    private String url = "";
    private int duration;

    public DatenFilm() {
        this.filmSize = new FilmSize(0);
        this.databaseFilmNumber = FILM_COUNTER.getAndIncrement();
        this.setupDatabaseCleanup();
    }

    public int getDuration() {
        return this.duration;
    }

    public DatenAbo getAbo() {
        return this.abo;
    }

    public void setAbo(DatenAbo abo) {
        this.abo = abo;
    }

    public DatumFilm getDatumFilm() {
        return this.datumFilm;
    }

    public String getUrlKlein() {
        return this.urlKlein;
    }

    public void setUrlKlein(String urlKlein) {
        this.urlKlein = urlKlein;
    }

    public String getUrlHighQuality() {
        return this.highQuality_url.orElse("");
    }

    public void setUrlHighQuality(String urlHd) {
        this.highQuality_url = !urlHd.isEmpty() ? Optional.of(urlHd) : Optional.empty();
    }

    public String getAboName() {
        return this.aboName;
    }

    public void setAboName(String aboName) {
        this.aboName = aboName;
    }

    public String getDatumLong() {
        return this.datumLong;
    }

    public void setDatumLong(String datumLong) {
        this.datumLong = datumLong;
    }

    public boolean isTrailerTeaser() {
        return this.flags.contains((Object)DatenFilmFlags.TRAILER_TEASER);
    }

    public void setTrailerTeaser(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.TRAILER_TEASER);
        } else {
            this.flags.remove((Object)DatenFilmFlags.TRAILER_TEASER);
        }
    }

    public boolean isAudioVersion() {
        return this.flags.contains((Object)DatenFilmFlags.AUDIO_VERSION);
    }

    public void setAudioVersion(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.AUDIO_VERSION);
        } else {
            this.flags.remove((Object)DatenFilmFlags.AUDIO_VERSION);
        }
    }

    public boolean isPlayList() {
        return this.flags.contains((Object)DatenFilmFlags.PLAYLIST);
    }

    public void setPlayList(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.PLAYLIST);
        } else {
            this.flags.remove((Object)DatenFilmFlags.PLAYLIST);
        }
    }

    public boolean isSignLanguage() {
        return this.flags.contains((Object)DatenFilmFlags.SIGN_LANGUAGE);
    }

    public void setSignLanguage(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.SIGN_LANGUAGE);
        } else {
            this.flags.remove((Object)DatenFilmFlags.SIGN_LANGUAGE);
        }
    }

    public int getFilmNr() {
        return this.databaseFilmNumber;
    }

    private void setupDatabaseCleanup() {
        boolean useCleaner;
        if (MemoryUtils.isLowMemoryEnvironment() && (useCleaner = ApplicationConfiguration.getConfiguration().getBoolean("database.cleanup.use_cleaner", false))) {
            this.installCleanupTask();
        }
    }

    private void installCleanupTask() {
        DatenFilmCleanupTask task = new DatenFilmCleanupTask(this.databaseFilmNumber);
        this.cleaner = Daten.getInstance().getCleaner().register(this, task);
    }

    public FilmSize getFilmSize() {
        return this.filmSize;
    }

    @Override
    public void close() {
        if (this.cleaner != null) {
            this.cleaner.clean();
        }
    }

    /*
     * Exception decompiling
     */
    public String getDescription() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setDescription(String desc) {
        if (desc != null && !desc.isEmpty()) {
            if (MemoryUtils.isLowMemoryEnvironment()) {
                try (Connection connection = PooledDatabaseConnection.INSTANCE.getDataSource().getConnection();
                     SqlAutoSetAutoCommit ignored = new SqlAutoSetAutoCommit(connection, false);
                     SqlAutoRollback tm = new SqlAutoRollback(connection);
                     PreparedStatement mergeStatement = connection.prepareStatement("MERGE INTO mediathekview.description KEY(ID) VALUES (?,?)");){
                    mergeStatement.setInt(1, this.databaseFilmNumber);
                    mergeStatement.setString(2, desc);
                    mergeStatement.executeUpdate();
                    tm.commit();
                }
                catch (SQLException ex) {
                    logger.error(ex);
                }
            } else {
                this.description = desc;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public String getWebsiteLink() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setWebsiteLink(String link) {
        if (link != null && !link.isEmpty()) {
            if (MemoryUtils.isLowMemoryEnvironment()) {
                try (Connection connection = PooledDatabaseConnection.INSTANCE.getDataSource().getConnection();
                     SqlAutoSetAutoCommit ignored = new SqlAutoSetAutoCommit(connection, false);
                     SqlAutoRollback tm = new SqlAutoRollback(connection);
                     PreparedStatement mergeStatement = connection.prepareStatement("MERGE INTO mediathekview.website_links KEY(ID) VALUES (?,?)");){
                    mergeStatement.setInt(1, this.databaseFilmNumber);
                    mergeStatement.setString(2, link);
                    mergeStatement.executeUpdate();
                    tm.commit();
                }
                catch (SQLException ex) {
                    logger.error(ex);
                }
            } else {
                this.websiteLink = link;
            }
        }
    }

    public boolean isNew() {
        return this.flags.contains((Object)DatenFilmFlags.NEW_ENTRY);
    }

    public void setNew(boolean newFilm) {
        if (newFilm) {
            this.flags.add(DatenFilmFlags.NEW_ENTRY);
        } else {
            this.flags.remove((Object)DatenFilmFlags.NEW_ENTRY);
        }
    }

    public boolean isLivestream() {
        return this.flags.contains((Object)DatenFilmFlags.LIVESTREAM);
    }

    public void setLivestream(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.LIVESTREAM);
        } else {
            this.flags.remove((Object)DatenFilmFlags.LIVESTREAM);
        }
    }

    public void setBurnedInSubtitles(boolean val) {
        if (val) {
            this.flags.add(DatenFilmFlags.BURNED_IN_SUBTITLES);
        } else {
            this.flags.remove((Object)DatenFilmFlags.BURNED_IN_SUBTITLES);
        }
    }

    public boolean hasBurnedInSubtitles() {
        return this.flags.contains((Object)DatenFilmFlags.BURNED_IN_SUBTITLES);
    }

    public boolean hasSubtitle() {
        return this.subtitle_url.isPresent();
    }

    public String getUrlFuerAufloesung(FilmResolution.Enum resolution) {
        return switch (resolution) {
            case FilmResolution.Enum.LOW, FilmResolution.Enum.HIGH_QUALITY -> this.getUrlNormalOrRequested(resolution);
            default -> this.getUrl();
        };
    }

    public String getDateigroesse(String url) {
        if (url.equalsIgnoreCase(this.getUrl())) {
            return this.getSize();
        }
        return FileSize.getFileLengthFromUrl(url);
    }

    public String getUniqueHash() {
        return (this.getSender() + this.getThema()).toLowerCase() + this.getUrl() + this.getWebsiteLink();
    }

    public boolean isHighQuality() {
        return this.highQuality_url.isPresent();
    }

    public Object clone() throws CloneNotSupportedException {
        DatenFilm ret = (DatenFilm)super.clone();
        ret.datumFilm = this.datumFilm;
        ret.databaseFilmNumber = this.databaseFilmNumber;
        ret.filmSize = this.filmSize;
        ret.filmLength = this.filmLength;
        ret.abo = this.abo;
        ret.highQuality_url = this.highQuality_url;
        ret.urlKlein = this.urlKlein;
        ret.aboName = this.aboName;
        ret.datumLong = this.datumLong;
        ret.sender = this.sender;
        ret.thema = this.thema;
        ret.titel = this.titel;
        ret.availableInCountries = this.availableInCountries;
        ret.datum = this.datum;
        ret.sendeZeit = this.sendeZeit;
        ret.dauer = this.dauer;
        ret.groesse = this.groesse;
        ret.url = this.url;
        ret.subtitle_url = this.subtitle_url;
        return ret;
    }

    @Override
    public int compareTo(@NotNull DatenFilm other) {
        int ret = sorter.compare(this.getSender(), other.getSender());
        if (ret == 0) {
            return sorter.compare(this.getThema(), other.getThema());
        }
        return ret;
    }

    public long getFilmLength() {
        return this.filmLength;
    }

    private long parseTimeToSeconds() {
        long seconds = 0L;
        String[] split = StringUtils.split(this.getDauer(), ':');
        try {
            seconds += Long.parseLong(split[0]) * 3600L;
            seconds += Long.parseLong(split[1]) * 60L;
            seconds += Long.parseLong(split[2]);
        }
        catch (Exception e) {
            seconds = 0L;
        }
        return seconds;
    }

    private void setDatum() {
        if (!this.getSendeDatum().isEmpty()) {
            try {
                long l = Long.parseLong(this.getDatumLong());
                this.datumFilm = new DatumFilm(l * 1000L);
            }
            catch (Exception ex) {
                logger.error("Datum: {}, Zeit: {}, Datum_LONG: {}", (Object)this.getSendeDatum(), (Object)this.getSendeZeit(), (Object)this.getDatumLong(), (Object)ex);
                this.datumFilm = new DatumFilm(0L);
                this.setSendeDatum("");
                this.setSendeZeit("");
            }
        }
    }

    public void init() {
        this.filmSize = new FilmSize(this);
        this.filmLength = this.parseTimeToSeconds();
        this.setDatum();
    }

    private String getUrlNormalOrRequested(@NotNull FilmResolution.Enum aufloesung) {
        String ret;
        String requestedUrl = this.getUrlByAufloesung(aufloesung);
        if (requestedUrl.isEmpty()) {
            ret = this.getUrl();
        } else {
            try {
                int indexPipe = requestedUrl.indexOf(124);
                ret = indexPipe == -1 ? requestedUrl : this.decompressUrl(requestedUrl, indexPipe);
            }
            catch (Exception e) {
                ret = "";
                logger.error("getUrlNormalOrRequested(aufl\u00f6sung: {}, requestedUrl: {})", (Object)aufloesung, (Object)requestedUrl, (Object)e);
            }
        }
        return ret;
    }

    private String decompressUrl(@NotNull String requestedUrl, int indexPipe) {
        int i = Integer.parseInt(requestedUrl.substring(0, indexPipe));
        return this.getUrl().substring(0, i) + requestedUrl.substring(indexPipe + 1);
    }

    private String getUrlByAufloesung(@NotNull FilmResolution.Enum aufloesung) {
        return switch (aufloesung) {
            case FilmResolution.Enum.HIGH_QUALITY -> this.getUrlHighQuality();
            case FilmResolution.Enum.LOW -> this.getUrlKlein();
            default -> this.getUrl();
        };
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getThema() {
        return this.thema;
    }

    public void setThema(String thema) {
        this.thema = thema;
    }

    public String getTitle() {
        return this.titel;
    }

    public void setTitle(String title) {
        this.titel = title;
    }

    public String getSendeDatum() {
        return this.datum;
    }

    public void setSendeDatum(String sendeDatum) {
        this.datum = sendeDatum;
    }

    public String getSendeZeit() {
        return this.sendeZeit;
    }

    public void setSendeZeit(String sendeZeit) {
        this.sendeZeit = sendeZeit;
    }

    public String getDauer() {
        return this.dauer;
    }

    public void setDauer(String dauer) {
        this.dauer = dauer;
        String[] split = StringUtils.split(this.getDauer(), ':');
        try {
            this.duration += Integer.parseInt(split[0]) * 3600;
            this.duration += Integer.parseInt(split[1]) * 60;
            this.duration += Integer.parseInt(split[2]);
        }
        catch (Exception e) {
            this.duration = 0;
        }
    }

    public String getSize() {
        return this.groesse;
    }

    public void setSize(String size) {
        this.groesse = size;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrlSubtitle() {
        return this.subtitle_url.orElse("");
    }

    public void setUrlSubtitle(String urlSubtitle) {
        this.subtitle_url = !urlSubtitle.isEmpty() ? Optional.of(urlSubtitle) : Optional.empty();
    }

    public Optional<String> getGeo() {
        return this.availableInCountries;
    }

    public void setGeo(Optional<String> availableInCountries) {
        this.availableInCountries = availableInCountries;
    }

    public BookmarkData getBookmark() {
        return this.bookmark;
    }

    public void setBookmark(BookmarkData bookmark) {
        this.bookmark = bookmark;
    }

    public boolean isBookmarked() {
        return this.bookmark != null;
    }

    public static class Database {
        private Database() {
        }

        public static void closeDatabase() {
            HikariDataSource ds = PooledDatabaseConnection.INSTANCE.getDataSource();
            ds.close();
        }

        public static void createIndices() {
            logger.trace("Creating SQL indices");
            try (Connection connection = PooledDatabaseConnection.INSTANCE.getDataSource().getConnection();
                 SqlAutoSetAutoCommit ignored = new SqlAutoSetAutoCommit(connection, false);
                 SqlAutoRollback tm = new SqlAutoRollback(connection);
                 Statement statement = connection.createStatement();){
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS IDX_DESC_ID ON mediathekview.description (id)");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS IDX_WEBSITE_LINKS_ID ON mediathekview.website_links (id)");
                tm.commit();
            }
            catch (SQLException ex) {
                logger.error(ex);
            }
            logger.trace("Finished creating SQL indices");
        }

        public static void initializeDatabase() {
            logger.debug("initializeDatabase()");
            try (Connection connection = PooledDatabaseConnection.INSTANCE.getDataSource().getConnection();
                 SqlAutoSetAutoCommit ignored = new SqlAutoSetAutoCommit(connection, false);
                 SqlAutoRollback tm = new SqlAutoRollback(connection);
                 Statement statement = connection.createStatement();){
                statement.executeUpdate("SET WRITE_DELAY 5000");
                statement.executeUpdate("CREATE SCHEMA IF NOT EXISTS mediathekview");
                statement.executeUpdate("SET SCHEMA mediathekview");
                statement.executeUpdate("DROP INDEX IF EXISTS IDX_DESC_ID");
                statement.executeUpdate("DROP INDEX IF EXISTS IDX_WEBSITE_LINKS_ID");
                statement.executeUpdate("DROP TABLE IF EXISTS mediathekview.description");
                statement.executeUpdate("DROP TABLE IF EXISTS mediathekview.website_links");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS description (id INTEGER NOT NULL PRIMARY KEY, desc VARCHAR(1024))");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS website_links (id INTEGER NOT NULL PRIMARY KEY, link VARCHAR(2048))");
                tm.commit();
            }
            catch (SQLException ex) {
                logger.error(ex);
            }
            logger.debug("initializeDatabase() done.");
        }
    }
}

