/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathManager {
    private static final String PATHS_SELECTOR = System.getProperty("idea.paths.selector");
    private static final String IDE_VENDOR_NAME = System.getProperty("idea.vendor.name", "JetBrains");
    private static volatile String ourHomePath;
    private static volatile List<Path> ourBinDirectories;
    private static String ourConfigPath;
    private static String ourSystemPath;

    @NotNull
    public static String getHomePath() {
        String string2 = PathManager.getHomePath(true);
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(0);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="true -> !null")
    public static String getHomePath(boolean insideIde) {
        String result2 = ourHomePath;
        if (result2 != null) {
            return result2;
        }
        Class<PathManager> clazz = PathManager.class;
        synchronized (PathManager.class) {
            result2 = ourHomePath;
            if (result2 != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return result2;
            }
            String explicit = PathManager.getExplicitPath("idea.home.path");
            if (explicit == null) {
                explicit = PathManager.getExplicitPath("idea.home");
            }
            if (explicit != null) {
                result2 = explicit;
                if (!Files.isDirectory(Paths.get(result2, new String[0]), new LinkOption[0])) {
                    ourHomePath = result2;
                    throw new RuntimeException("Invalid home path '" + result2 + "'");
                }
            } else if (insideIde && (result2 = PathManager.getHomePathFor(PathManager.class)) == null) {
                String advice = SystemInfoRt.isMac ? "reinstall the software." : "make sure bin/idea.properties is present in the installation directory.";
                throw new RuntimeException("Could not find installation home path. Please " + advice);
            }
            if (result2 != null && SystemInfoRt.isWindows) {
                try {
                    result2 = Paths.get(result2, new String[0]).toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ourBinDirectories = result2 == null ? Collections.emptyList() : PathManager.getBinDirectories(Paths.get(result2, new String[0]));
            ourHomePath = result2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result2;
        }
    }

    private static List<Path> getBinDirectories() {
        List<Path> result2 = ourBinDirectories;
        if (result2 == null) {
            PathManager.getHomePath(true);
            result2 = ourBinDirectories;
        }
        return result2;
    }

    @Nullable
    public static String getHomePathFor(@NotNull Class<?> aClass2) {
        String rootPath;
        if (aClass2 == null) {
            PathManager.$$$reportNull$$$0(2);
        }
        if ((rootPath = PathManager.getResourceRoot(aClass2, '/' + aClass2.getName().replace('.', '/') + ".class")) == null) {
            return null;
        }
        Path root2 = Paths.get(rootPath, new String[0]).toAbsolutePath();
        while ((root2 = root2.getParent()) != null && !PathManager.isIdeaHome(root2)) {
        }
        return root2 != null ? root2.toString() : null;
    }

    private static boolean isIdeaHome(Path root2) {
        for (Path binDir : PathManager.getBinDirectories(root2)) {
            if (!Files.isRegularFile(binDir.resolve("idea.properties"), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static List<Path> getBinDirectories(Path root2) {
        ArrayList<Path> binDirs = new ArrayList<Path>();
        String[] subDirs = new String[]{"bin", "community/bin", "ultimate/community/bin"};
        String osSuffix = SystemInfoRt.isWindows ? "win" : (SystemInfoRt.isMac ? "mac" : "linux");
        for (String subDir : subDirs) {
            Path dir = root2.resolve(subDir);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
            dir = dir.resolve(osSuffix);
            if (!Files.isDirectory(dir, new LinkOption[0])) continue;
            binDirs.add(dir);
        }
        return binDirs;
    }

    @NotNull
    public static String getBinPath() {
        String string2 = PathManager.getHomePath() + '/' + "bin";
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Nullable
    public static File findBinFile(@NotNull String fileName) {
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(4);
        }
        for (Path binDir : PathManager.getBinDirectories()) {
            Path candidate2 = binDir.resolve(fileName);
            if (!Files.isRegularFile(candidate2, new LinkOption[0])) continue;
            return candidate2.toFile();
        }
        return null;
    }

    @NotNull
    public static File findBinFileWithException(@NotNull String fileName) throws FileNotFoundException {
        File file2;
        if (fileName == null) {
            PathManager.$$$reportNull$$$0(5);
        }
        if ((file2 = PathManager.findBinFile(fileName)) != null) {
            File file3 = file2;
            if (file3 == null) {
                PathManager.$$$reportNull$$$0(6);
            }
            return file3;
        }
        StringBuilder message2 = new StringBuilder();
        message2.append('\'').append(fileName).append("' not found in directories:");
        for (Path directory : PathManager.getBinDirectories()) {
            message2.append('\n').append(directory);
        }
        throw new FileNotFoundException(message2.toString());
    }

    @NotNull
    public static String getConfigPath() {
        if (ourConfigPath != null) {
            String string2 = ourConfigPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(10);
            }
            return string2;
        }
        String explicit = PathManager.getExplicitPath("idea.config.path");
        ourConfigPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultConfigPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + "config");
        String string3 = ourConfigPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(11);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultConfigPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(14);
        }
        String string2 = PathManager.platformPath(selector, "Application Support", "", "APPDATA", "", "XDG_CONFIG_HOME", ".config", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @NotNull
    public static String getSystemPath() {
        if (ourSystemPath != null) {
            String string2 = ourSystemPath;
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(23);
            }
            return string2;
        }
        String explicit = PathManager.getExplicitPath("idea.system.path");
        ourSystemPath = explicit != null ? explicit : (PATHS_SELECTOR != null ? PathManager.getDefaultSystemPathFor(PATHS_SELECTOR) : PathManager.getHomePath() + '/' + "system");
        String string3 = ourSystemPath;
        if (string3 == null) {
            PathManager.$$$reportNull$$$0(24);
        }
        return string3;
    }

    @NotNull
    public static String getDefaultSystemPathFor(@NotNull String selector) {
        if (selector == null) {
            PathManager.$$$reportNull$$$0(25);
        }
        String string2 = PathManager.platformPath(selector, "Caches", "", "LOCALAPPDATA", "", "XDG_CACHE_HOME", ".cache", "");
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(26);
        }
        return string2;
    }

    @NotNull
    public static File getIndexRoot() {
        String indexRootPath = PathManager.getExplicitPath("index_root_path");
        if (indexRootPath == null) {
            indexRootPath = PathManager.getSystemPath() + "/index";
        }
        File file2 = Paths.get(indexRootPath, new String[0]).toFile();
        if (file2 == null) {
            PathManager.$$$reportNull$$$0(28);
        }
        return file2;
    }

    @Nullable
    public static String getResourceRoot(@NotNull Class<?> context2, @NotNull String path2) {
        URL url;
        if (context2 == null) {
            PathManager.$$$reportNull$$$0(32);
        }
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(33);
        }
        if ((url = context2.getResource(path2)) == null) {
            url = ClassLoader.getSystemResource(path2.substring(1));
        }
        return url != null ? PathManager.extractRoot(url, path2) : null;
    }

    @Nullable
    public static String getResourceRoot(@NotNull ClassLoader cl, @NotNull String resourcePath) {
        URL url;
        if (cl == null) {
            PathManager.$$$reportNull$$$0(34);
        }
        if (resourcePath == null) {
            PathManager.$$$reportNull$$$0(35);
        }
        return (url = cl.getResource(resourcePath)) != null ? PathManager.extractRoot(url, resourcePath) : null;
    }

    @Nullable
    private static String extractRoot(URL resourceURL, String resourcePath) {
        if (resourcePath.length() == 0 || resourcePath.charAt(0) != '/' && resourcePath.charAt(0) != '\\') {
            PathManager.log("precondition failed: " + resourcePath);
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String testResourcePath;
            String path2 = URLUtil.urlToFile(resourceURL).getPath();
            String testPath = path2.replace('\\', '/');
            if (StringUtilRt.endsWithIgnoreCase(testPath, testResourcePath = resourcePath.replace('\\', '/'))) {
                resultPath = path2.substring(0, path2.length() - resourcePath.length());
            }
        } else if ("jar".equals(protocol)) {
            Pair<String, String> paths = URLUtil.splitJarUrl(resourceURL.getFile());
            if (paths != null && paths.first != null) {
                resultPath = (String)paths.first;
            }
        } else if ("jrt".equals(protocol)) {
            return null;
        }
        if (resultPath == null) {
            PathManager.log("cannot extract '" + resourcePath + "' from '" + resourceURL + "'");
            return null;
        }
        return Paths.get(resultPath, new String[0]).normalize().toString();
    }

    @NotNull
    public static String getCommunityHomePath() {
        String path2 = PathManager.getHomePath();
        if (Files.isDirectory(Paths.get(path2, "community/.idea"), new LinkOption[0])) {
            String string2 = path2 + "/community";
            if (string2 == null) {
                PathManager.$$$reportNull$$$0(39);
            }
            return string2;
        }
        if (Files.isDirectory(Paths.get(path2, "ultimate/community/.idea"), new LinkOption[0])) {
            String string3 = path2 + "/ultimate/community";
            if (string3 == null) {
                PathManager.$$$reportNull$$$0(40);
            }
            return string3;
        }
        String string4 = path2;
        if (string4 == null) {
            PathManager.$$$reportNull$$$0(41);
        }
        return string4;
    }

    @Nullable
    public static String getJarPathForClass(@NotNull Class<?> aClass2) {
        String resourceRoot;
        if (aClass2 == null) {
            PathManager.$$$reportNull$$$0(42);
        }
        return (resourceRoot = PathManager.getResourceRoot(aClass2, '/' + aClass2.getName().replace('.', '/') + ".class")) != null ? Paths.get(resourceRoot, new String[0]).toAbsolutePath().toString() : null;
    }

    private static void log(String x) {
        System.err.println(x);
    }

    @NotNull
    public static String getAbsolutePath(@NotNull String path2) {
        if (path2 == null) {
            PathManager.$$$reportNull$$$0(44);
        }
        if (path2.startsWith("~/") || path2.startsWith("~\\")) {
            path2 = SystemProperties.getUserHome() + path2.substring(1);
        }
        String string2 = Paths.get(path2, new String[0]).toAbsolutePath().normalize().toString();
        if (string2 == null) {
            PathManager.$$$reportNull$$$0(45);
        }
        return string2;
    }

    @Nullable
    private static String getExplicitPath(String property2) {
        String path2 = System.getProperty(property2);
        return path2 != null ? PathManager.getAbsolutePath(StringUtilRt.unquoteString(path2, '\"')) : null;
    }

    private static String platformPath(String selector, String macDir, String macSub, String winVar, String winSub, String xdgVar, String xdgDfl, String xdgSub) {
        String userHome = SystemProperties.getUserHome();
        if (SystemInfoRt.isMac) {
            String dir = userHome + "/Library/" + macDir + '/' + IDE_VENDOR_NAME + '/' + selector;
            if (!macSub.isEmpty()) {
                dir = dir + '/' + macSub;
            }
            return dir;
        }
        if (SystemInfoRt.isWindows) {
            String dir = System.getenv(winVar);
            if (dir == null || dir.isEmpty()) {
                dir = userHome + "\\AppData\\" + (winVar.startsWith("LOCAL") ? "Local" : "Roaming");
            }
            dir = dir + '\\' + IDE_VENDOR_NAME + '\\' + selector;
            if (!winSub.isEmpty()) {
                dir = dir + '\\' + winSub;
            }
            return dir;
        }
        if (SystemInfoRt.isUnix) {
            String dir = System.getenv(xdgVar);
            if (dir == null || dir.isEmpty()) {
                dir = userHome + '/' + xdgDfl;
            }
            dir = dir + '/' + IDE_VENDOR_NAME + '/' + selector;
            if (!xdgSub.isEmpty()) {
                dir = dir + '/' + xdgSub;
            }
            return dir;
        }
        throw new UnsupportedOperationException("Unsupported OS: " + SystemInfoRt.OS_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 21: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 21: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 1: 
            case 33: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 14: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaHomePath";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 21: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/PathManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinFileWithException";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreInstalledPluginsPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDir";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getScratchPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConfigPathFor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginsPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPluginPathFor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSystemPathFor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempPath";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexRoot";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogPath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginTempPath";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "findFileInLibDirectory";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommunityHomePath";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getUtilClassPath";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbsolutePath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnderHomeDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHomePathFor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findBinFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBinFileWithException";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultConfigPathFor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOptionsFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPluginPathFor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSystemPathFor";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getResourceRoot";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "substituteVars";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLibDirectory";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getAbsolutePath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 17: 
            case 21: 
            case 25: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 44: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

