/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.SamEqualsHashCodeMethodsGenerator;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\n\u0010&\u001a\u0004\u0018\u00010'H\u0014J \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u00020\u000bH\u0002J\u0010\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000bH&J\u001e\u00103\u001a\u00020#2\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u0002070.H&J\u0010\u00108\u001a\u00020)2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\fH\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u00104\u001a\u000205H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000eR\u0016\u0010\u001d\u001a\u00020\u0018*\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SingleAbstractMethodLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "FUNCTION_FIELD_NAME", "", "SAM_WRAPPER_SUFFIX", "cachedImplementations", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getCachedImplementations", "()Ljava/util/Map;", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "enclosingContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "getEnclosingContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "setEnclosingContainer", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;)V", "inInlineFunctionScope", "", "getInInlineFunctionScope", "()Z", "inlineCachedImplementations", "getInlineCachedImplementations", "needEqualsHashCodeMethods", "getNeedEqualsHashCodeMethods", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "createObjectProxy", "superType", "wrapperVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "createFor", "Lorg/jetbrains/kotlin/ir/IrElement;", "currentScopeSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "generateEqualsHashCode", "", "klass", "functionDelegateField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getAdditionalSupertypes", "", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "supertype", "getSuperTypeForWrapper", "typeOperand", "getWrapperVisibility", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "scopes", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.backend.common"})
public abstract class SingleAbstractMethodLowering
extends IrElementTransformerVoidWithContext
implements FileLoweringPass {
    private final Map<IrType, IrClass> cachedImplementations;
    private final Map<IrType, IrClass> inlineCachedImplementations;
    private IrDeclarationContainer enclosingContainer;
    private final String SAM_WRAPPER_SUFFIX;
    private final String FUNCTION_FIELD_NAME;
    private final CommonBackendContext context;

    @NotNull
    protected final Map<IrType, IrClass> getCachedImplementations() {
        return this.cachedImplementations;
    }

    @NotNull
    protected final Map<IrType, IrClass> getInlineCachedImplementations() {
        return this.inlineCachedImplementations;
    }

    @Nullable
    protected final IrDeclarationContainer getEnclosingContainer() {
        return this.enclosingContainer;
    }

    protected final void setEnclosingContainer(@Nullable IrDeclarationContainer irDeclarationContainer) {
        this.enclosingContainer = irDeclarationContainer;
    }

    @NotNull
    public abstract DescriptorVisibility getWrapperVisibility(@NotNull IrTypeOperatorCall var1, @NotNull List<? extends ScopeWithIr> var2);

    @NotNull
    public abstract IrType getSuperTypeForWrapper(@NotNull IrType var1);

    public abstract boolean getNeedEqualsHashCodeMethods(@NotNull IrType var1);

    public boolean getInInlineFunctionScope() {
        boolean bl;
        block4: {
            Iterable $this$any$iv = this.getAllScopes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScopeWithIr scope2 = (ScopeWithIr)element$iv;
                    boolean bl2 = false;
                    IrElement irElement = scope2.getIrElement();
                    if (!(irElement instanceof IrFunction)) {
                        irElement = null;
                    }
                    IrFunction irFunction2 = (IrFunction)irElement;
                    if (!(irFunction2 != null ? irFunction2.isInline() : false)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Iterator iterator2;
        List list2;
        block4: {
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter(irFile, "irFile");
            this.cachedImplementations.clear();
            this.inlineCachedImplementations.clear();
            Iterable iterable = irFile.getDeclarations();
            SingleAbstractMethodLowering singleAbstractMethodLowering = this;
            boolean $i$f$filterIsInstance = false;
            void var4_6 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            $this$filterIsInstance$iv = list2;
            boolean bl = false;
            $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
            boolean bl2 = false;
            for (Iterator iterator3 : $this$filterIsInstanceTo$iv$iv) {
                IrClass it = (IrClass)((Object)iterator3);
                boolean bl3 = false;
                if (!IrUtilsKt.isFileClass(it)) continue;
                iterator2 = iterator3;
                break block4;
            }
            iterator2 = null;
        }
        list2 = iterator2;
        IrClass irClass2 = (IrClass)((Object)list2);
        singleAbstractMethodLowering.enclosingContainer = irClass2 != null ? (IrDeclarationContainer)irClass2 : (IrDeclarationContainer)irFile;
        this.transformChildrenVoid(irFile);
        for (IrClass wrapper : CollectionsKt.plus(this.cachedImplementations.values(), (Iterable)this.inlineCachedImplementations.values())) {
            IrDeclarationParent irDeclarationParent = wrapper.getParent();
            if (irDeclarationParent == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
            }
            IrDeclarationContainer parentClass = (IrDeclarationContainer)irDeclarationParent;
            Collection collection = parentClass.getDeclarations();
            boolean bl = false;
            collection.add(wrapper);
        }
    }

    @Nullable
    protected IrSymbol currentScopeSymbol() {
        Object object = this.getCurrentScope();
        return object != null && (object = ((ScopeWithIr)object).getScope()) != null ? ((Scope)object).getScopeOwnerSymbol() : null;
    }

    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        IrDeclarationContainer prevContainer = this.enclosingContainer;
        if (prevContainer == null || prevContainer instanceof IrFile) {
            this.enclosingContainer = declaration2;
        }
        super.visitClassNew(declaration2);
        this.enclosingContainer = prevContainer;
        return declaration2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        IrElement expression$iv;
        IrGeneratorWithScope $this$irBlock$iv;
        IrType resultType$iv;
        Object object;
        IrGeneratorWithScope $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (expression2.getOperator() != IrTypeOperator.SAM_CONVERSION) {
            return super.visitTypeOperator(expression2);
        }
        IrType erasedSuperType = this.getSuperTypeForWrapper(expression2.getTypeOperand());
        IrType superType = IrTypeUtilsKt.isNullable(expression2.getTypeOperand()) ? IrTypesKt.makeNullable(erasedSuperType) : erasedSuperType;
        IrElement invokable = expression2.getArgument().transform((IrElementTransformer)this, (Object)null);
        BackendContext backendContext = this.context;
        IrSymbol irSymbol = this.currentScopeSymbol();
        Intrinsics.checkNotNull(irSymbol);
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder$default(backendContext, irSymbol, 0, 0, 6, null);
        boolean bl = false;
        boolean bl2 = false;
        DeclarationIrBuilder $this$apply = declarationIrBuilder;
        boolean bl3 = false;
        if (IrUtilsKt.isNullConst((IrExpression)invokable)) {
            return invokable;
        }
        Map<IrType, IrClass> cache2 = this.getInInlineFunctionScope() ? this.inlineCachedImplementations : this.cachedImplementations;
        Object object2 = cache2;
        Object key$iv = erasedSuperType;
        boolean $i$f$getOrPut2 = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl4 = false;
            IrClass answer$iv = this.createObjectProxy(erasedSuperType, this.getWrapperVisibility(expression2, this.getAllScopes()), expression2);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        IrClass implementation2 = (IrClass)object;
        if (IrTypeUtilsKt.isNullable(superType) && IrTypeUtilsKt.isNullable(((IrExpression)invokable).getType())) {
            void origin$iv;
            void startOffset$iv$iv;
            void $this$irBlock$iv$iv;
            $this$getOrPut$iv = $this$apply;
            key$iv = invokable;
            Object $i$f$getOrPut2 = null;
            resultType$iv = superType;
            boolean $i$f$irBlock = false;
            IrGeneratorWithScope irGeneratorWithScope = $this$irBlock$iv;
            int n = expression$iv.getStartOffset();
            int endOffset$iv$iv = expression$iv.getEndOffset();
            boolean $i$f$irBlock2 = false;
            IrBlockBuilder this_$iv$iv$iv = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, (IrStatementOrigin)origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            IrBlockBuilder $this$irBlock = this_$iv$iv$iv;
            boolean bl5 = false;
            IrVariable invokableVariable = IrBuildersKt.createTmpVariable$default($this$irBlock, (IrExpression)invokable, null, false, null, null, 30, null);
            IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlock, SequencesKt.single(IrUtilsKt.getConstructors(implementation2)));
            boolean bl6 = false;
            boolean bl7 = false;
            IrFunctionAccessExpression $this$apply2 = irFunctionAccessExpression;
            boolean bl8 = false;
            $this$apply2.putValueArgument(0, ExpressionHelpersKt.irGet($this$irBlock, invokableVariable));
            IrFunctionAccessExpression instance = irFunctionAccessExpression;
            $this$irBlock.unaryPlus(ExpressionHelpersKt.irIfNull($this$irBlock, superType, ExpressionHelpersKt.irGet($this$irBlock, invokableVariable), ExpressionHelpersKt.irNull($this$irBlock), instance));
            irExpression = this_$iv$iv$iv.doBuild();
        } else if (!(invokable instanceof IrGetValue)) {
            $this$irBlock$iv = $this$apply;
            expression$iv = invokable;
            IrStatementOrigin origin$iv = null;
            resultType$iv = superType;
            boolean $i$f$irBlock = false;
            IrGeneratorWithScope $this$irBlock$iv$iv = $this$irBlock$iv;
            int startOffset$iv$iv = expression$iv.getStartOffset();
            int endOffset$iv$iv = expression$iv.getEndOffset();
            boolean $i$f$irBlock3 = false;
            IrBlockBuilder this_$iv$iv$iv = new IrBlockBuilder($this$irBlock$iv$iv.getContext(), $this$irBlock$iv$iv.getScope(), startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            IrBlockBuilder $this$irBlock = this_$iv$iv$iv;
            boolean bl9 = false;
            IrVariable invokableVariable = IrBuildersKt.createTmpVariable$default($this$irBlock, (IrExpression)invokable, null, false, null, null, 30, null);
            IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$irBlock, SequencesKt.single(IrUtilsKt.getConstructors(implementation2)));
            boolean bl10 = false;
            boolean bl11 = false;
            IrFunctionAccessExpression $this$apply2 = irFunctionAccessExpression;
            IrBlockBuilder irBlockBuilder = $this$irBlock;
            boolean bl12 = false;
            $this$apply2.putValueArgument(0, ExpressionHelpersKt.irGet($this$irBlock, invokableVariable));
            Unit unit = Unit.INSTANCE;
            irBlockBuilder.unaryPlus(irFunctionAccessExpression);
            irExpression = this_$iv$iv$iv.doBuild();
        } else {
            object2 = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$apply, SequencesKt.single(IrUtilsKt.getConstructors(implementation2)));
            boolean bl13 = false;
            boolean bl14 = false;
            Object $this$apply3 = object2;
            boolean bl15 = false;
            ((IrFunctionAccessExpression)$this$apply3).putValueArgument(0, (IrExpression)invokable);
            irExpression = (IrExpression)object2;
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrClass createObjectProxy(IrType superType, DescriptorVisibility wrapperVisibility, IrElement createFor) {
        Unit unit;
        void $this$apply;
        boolean bl;
        void $this$single$iv;
        void $this$irBlockBody;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$irBlockBody2;
        void startOffset$iv;
        void $this$irBlockBody$iv;
        Object subclass;
        boolean bl2;
        Object it22;
        IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(superType).getOwner();
        if (irSymbolOwner == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        }
        IrClass superClass = (IrClass)irSymbolOwner;
        boolean bl3 = superClass.getKind() == ClassKind.INTERFACE;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl3) {
            boolean $i$a$-assert-SingleAbstractMethodLowering$createObjectProxy$22 = false;
            String $i$a$-assert-SingleAbstractMethodLowering$createObjectProxy$22 = "SAM conversion to an abstract class not allowed";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-SingleAbstractMethodLowering$createObjectProxy$22));
        }
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(superClass);
        Intrinsics.checkNotNull(fqName2);
        String string2 = fqName2.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "superClass.fqNameWhenAvailable!!.asString()");
        String superFqName = StringsKt.replace$default(string2, '.', '_', false, 4, null);
        String inlinePrefix = Intrinsics.areEqual(wrapperVisibility, DescriptorVisibilities.PUBLIC) ? "$i" : "";
        Name name = Name.identifier("sam" + inlinePrefix + '$' + superFqName + this.SAM_WRAPPER_SUFFIX);
        Intrinsics.checkNotNullExpressionValue(name, "Name.identifier(\"sam$inl\u2026Name$SAM_WRAPPER_SUFFIX\")");
        Name wrapperName = name;
        Sequence<IrSimpleFunction> $this$single$iv2 = IrUtilsKt.getFunctions(superClass);
        boolean $i$f$single = false;
        IrSimpleFunction single$iv = null;
        boolean found$iv = false;
        Iterator<IrSimpleFunction> iterator2 = $this$single$iv2.iterator();
        while (iterator2.hasNext()) {
            IrSimpleFunction element$iv = iterator2.next();
            it22 = element$iv;
            bl2 = false;
            if (!(it22.getModality() == Modality.ABSTRACT)) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction superMethod = single$iv;
        int extensionReceiversCount = superMethod.getExtensionReceiverParameter() == null ? 0 : 1;
        IrClass wrappedFunctionClass = superMethod.isSuspend() ? (IrClass)this.context.getIr().getSymbols().suspendFunctionN(superMethod.getValueParameters().size() + extensionReceiversCount).getOwner() : (IrClass)this.context.getIr().getSymbols().functionN(superMethod.getValueParameters().size() + extensionReceiversCount).getOwner();
        IrSimpleType wrappedFunctionType = IrUtilsKt.getDefaultType(wrappedFunctionClass);
        Object $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        it22 = new IrClassBuilder();
        bl2 = false;
        boolean bl5 = false;
        Object $this$run$iv4222 = it22;
        boolean bl6 = false;
        Object $this$buildClass22 = $this$run$iv4222;
        boolean bl7 = false;
        ((IrDeclarationBuilder)$this$buildClass22).setName(wrapperName);
        ((IrDeclarationBuilder)$this$buildClass22).setOrigin(IrDeclarationOrigin.GENERATED_SAM_IMPLEMENTATION.INSTANCE);
        ((IrDeclarationBuilder)$this$buildClass22).setVisibility(wrapperVisibility);
        IrElementBuilderKt.setSourceRange((IrElementBuilder)$this$buildClass22, createFor);
        $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$run$iv4222);
        $i$f$buildClass = false;
        boolean it22 = false;
        Object $this$apply2 = $this$buildClass$iv;
        boolean bl8 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$apply2);
        ((IrClass)$this$apply2).setSuperTypes(CollectionsKt.plus((Collection)CollectionsKt.listOf(superType), (Iterable)this.getAdditionalSupertypes(superType)));
        IrDeclarationContainer irDeclarationContainer = this.enclosingContainer;
        Intrinsics.checkNotNull(irDeclarationContainer);
        $this$apply2.setParent(irDeclarationContainer);
        Object $this$addField$iv = subclass = $this$buildClass$iv;
        boolean $i$f$addField = false;
        Object $this$buildField$iv$iv = $this$addField$iv.getFactory();
        boolean $i$f$buildField = false;
        $this$run$iv4222 = new IrFieldBuilder();
        bl6 = false;
        boolean $this$buildClass22 = false;
        Object $this$run$iv$iv = $this$run$iv4222;
        boolean bl9 = false;
        Object $this$addField = $this$run$iv$iv;
        boolean bl10 = false;
        Name name2 = Name.identifier(this.FUNCTION_FIELD_NAME);
        Intrinsics.checkNotNullExpressionValue(name2, "Name.identifier(FUNCTION_FIELD_NAME)");
        ((IrDeclarationBuilder)$this$addField).setName(name2);
        ((IrFieldBuilder)$this$addField).setType(wrappedFunctionType);
        ((IrDeclarationBuilder)$this$addField).setOrigin(subclass.getOrigin());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "DescriptorVisibilities.PRIVATE");
        ((IrDeclarationBuilder)$this$addField).setVisibility(descriptorVisibility);
        IrElementBuilderKt.setSourceRange((IrElementBuilder)$this$addField, createFor);
        $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, (IrFieldBuilder)$this$run$iv$iv);
        $i$f$buildField = false;
        boolean $this$run$iv4222 = false;
        Object field$iv22 = $this$buildField$iv$iv;
        boolean bl11 = false;
        field$iv22.setParent((IrDeclarationParent)$this$addField$iv);
        $this$addField$iv.getDeclarations().add((IrDeclaration)field$iv22);
        Object field = $this$buildField$iv$iv;
        Object $this$addConstructor$iv = subclass;
        boolean $i$f$addConstructor = false;
        Object $this$buildConstructor$iv$iv22 = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$run$iv4222 = new IrFunctionBuilder();
        boolean field$iv22 = false;
        bl11 = false;
        $this$run$iv$iv = $this$run$iv4222;
        boolean bl12 = false;
        Object $this$buildConstructor$iv22 = $this$run$iv$iv;
        boolean bl13 = false;
        Object $this$addConstructor = $this$buildConstructor$iv22;
        boolean bl14 = false;
        ((IrDeclarationBuilder)$this$addConstructor).setOrigin(subclass.getOrigin());
        ((IrFunctionBuilder)$this$addConstructor).setPrimary(true);
        ((IrDeclarationBuilder)$this$addConstructor).setVisibility(wrapperVisibility);
        IrElementBuilderKt.setSourceRange((IrElementBuilder)$this$addConstructor, createFor);
        ((IrFunctionBuilder)$this$buildConstructor$iv22).setReturnType(IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        $this$buildConstructor$iv$iv22 = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv22, (IrFunctionBuilder)$this$run$iv$iv);
        $i$f$buildConstructor = false;
        boolean $this$run$iv4222 = false;
        Object constructor$iv = $this$buildConstructor$iv$iv22;
        boolean bl15 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
        $this$addConstructor$iv = $this$buildConstructor$iv$iv22;
        $i$f$addConstructor = false;
        boolean $this$buildConstructor$iv$iv22 = false;
        Object $this$apply3 = $this$addConstructor$iv;
        boolean bl16 = false;
        Object $this$addValueParameter$iv = (IrFunction)$this$apply3;
        int $i$f$addValueParameter = 0;
        $this$run$iv$iv = new IrValueParameterBuilder();
        bl12 = false;
        boolean $this$buildConstructor$iv22 = false;
        Object $this$run$iv = $this$run$iv$iv;
        boolean $i$a$-run-DeclarationBuildersKt$addValueParameter$1$iv22 = false;
        Object $this$addValueParameter = $this$run$iv;
        boolean bl172 = false;
        ((IrDeclarationBuilder)$this$addValueParameter).setName(field.getName());
        ((IrValueParameterBuilder)$this$addValueParameter).setType(((IrField)field).getType());
        ((IrDeclarationBuilder)$this$addValueParameter).setOrigin(subclass.getOrigin());
        if (((IrValueParameterBuilder)$this$run$iv).getIndex() == -1) {
            ((IrValueParameterBuilder)$this$run$iv).setIndex(((IrFunction)$this$addValueParameter$iv).getValueParameters().size());
        }
        Object object = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), (IrValueParameterBuilder)$this$run$iv, (IrDeclarationParent)$this$addValueParameter$iv);
        boolean bl18 = false;
        boolean bl19 = false;
        IrValueParameter valueParameter$iv = object;
        boolean bl20 = false;
        ((IrFunction)$this$addValueParameter$iv).setValueParameters(CollectionsKt.plus((Collection)((IrFunction)$this$addValueParameter$iv).getValueParameters(), valueParameter$iv));
        IrValueParameter parameter = object;
        $this$addValueParameter$iv = LowerUtilsKt.createIrBuilder$default(this.context, ((IrFunction)$this$apply3).getSymbol(), 0, 0, 6, null);
        $i$f$addValueParameter = $this$apply3.getStartOffset();
        int endOffset$iv = $this$apply3.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder this_$iv$iv = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        IrBlockBodyBuilder $i$a$-run-DeclarationBuildersKt$addValueParameter$1$iv22 = this_$iv$iv;
        Object object2 = $this$apply3;
        boolean bl21 = false;
        $this$irBlockBody2.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$irBlockBody2, SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$irBlockBody2.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$irBlockBody2;
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$irBlockBody2;
        IrValueParameter irValueParameter = ((IrClass)subclass).getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        $this$irBlockBody2.unaryPlus(ExpressionHelpersKt.irSetField(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter), (IrField)field, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$irBlockBody2, parameter)));
        $this$irBlockBody2.unaryPlus(new IrInstanceInitializerCallImpl($this$irBlockBody2.getStartOffset(), $this$irBlockBody2.getEndOffset(), (IrClassSymbol)subclass.getSymbol(), $this$irBlockBody2.getContext().getIrBuiltIns().getUnitType()));
        Unit unit2 = Unit.INSTANCE;
        ((IrFunction)object2).setBody(this_$iv$iv.doBuild());
        Object $this$addFunction$iv = subclass;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        Object $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun22 = false;
        IrFunctionBuilder irFunctionBuilder = new IrFunctionBuilder();
        endOffset$iv = 0;
        $i$f$irBlockBody = false;
        IrFunctionBuilder $this$run$iv$iv$iv = irFunctionBuilder;
        boolean bl22 = false;
        IrFunctionBuilder $this$addFunction = $this$run$iv$iv$iv;
        boolean bl23 = false;
        $this$addFunction.setName(superMethod.getName());
        $this$addFunction.setReturnType(superMethod.getReturnType());
        $this$addFunction.setVisibility(superMethod.getVisibility());
        $this$addFunction.setOrigin(subclass.getOrigin());
        $this$addFunction.setSuspend(superMethod.isSuspend());
        IrElementBuilderKt.setSourceRange($this$addFunction, createFor);
        $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, $this$run$iv$iv$iv);
        $i$f$buildFun22 = false;
        boolean bl24 = false;
        Object function$iv$iv = $this$buildFun$iv$iv$iv;
        boolean $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
        function$iv$iv.setParent((IrDeclarationContainer)$this$addFunction$iv);
        Object object3 = $this$buildFun$iv$iv$iv;
        boolean bl25 = false;
        boolean bl26 = false;
        $this$apply = object3;
        boolean bl27 = false;
        $this$apply.setOverriddenSymbols(CollectionsKt.listOf(superMethod.getSymbol()));
        IrValueParameter irValueParameter2 = ((IrClass)subclass).getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter2);
        ((IrFunction)$this$apply).setDispatchReceiverParameter(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(irValueParameter2, (IrFunction)$this$apply, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null));
        IrValueParameter irValueParameter3 = superMethod.getExtensionReceiverParameter();
        ((IrFunction)$this$apply).setExtensionReceiverParameter(irValueParameter3 != null ? org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(irValueParameter3, (IrFunction)$this$apply, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null) : null);
        Iterable $i$f$buildFun22 = superMethod.getValueParameters();
        Object object4 = $this$apply;
        boolean $i$f$map = false;
        void $i$a$-also-DeclarationBuildersKt$addFunction$1$iv$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter bl172 = (IrValueParameter)item$iv$iv;
            object = destination$iv$iv;
            boolean bl28 = false;
            IrValueParameter irValueParameter4 = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default((IrValueParameter)it, (IrFunction)$this$apply, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null);
            object.add(irValueParameter4);
        }
        object = (List)destination$iv$iv;
        ((IrFunction)object4).setValueParameters((List<? extends IrValueParameter>)object);
        IrBuilderWithScope $this$irBlockBody$iv2 = LowerUtilsKt.createIrBuilder$default(this.context, ((IrFunction)$this$apply).getSymbol(), 0, 0, 6, null);
        int startOffset$iv2 = $this$irBlockBody$iv2.getStartOffset();
        int endOffset$iv2 = $this$irBlockBody$iv2.getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder this_$iv$iv2 = new IrBlockBodyBuilder($this$irBlockBody$iv2.getContext(), $this$irBlockBody$iv2.getScope(), startOffset$iv2, endOffset$iv2);
        boolean $i$f$blockBody2 = false;
        IrBlockBodyBuilder item$iv$iv = this_$iv$iv2;
        object4 = $this$apply;
        boolean bl29 = false;
        Sequence<IrSimpleFunction> bl28 = IrUtilsKt.getFunctions(wrappedFunctionClass);
        Object object5 = (IrBuilderWithScope)$this$irBlockBody;
        IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$irBlockBody;
        void var33_87 = $this$irBlockBody;
        boolean $i$f$single2 = false;
        Object single$iv2 = null;
        boolean found$iv22 = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            bl = false;
            if (!Intrinsics.areEqual(it.getName(), OperatorNameConventions.INVOKE)) continue;
            if (found$iv22) {
                throw (Throwable)new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv2 = element$iv;
            found$iv22 = true;
        }
        if (!found$iv22) {
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Object var41_101 = single$iv2;
        IrFunctionAccessExpression irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)object5, var41_101);
        boolean bl30 = false;
        boolean bl31 = false;
        IrFunctionAccessExpression found$iv22 = irFunctionAccessExpression;
        boolean bl32 = false;
        IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$irBlockBody;
        IrBuilderWithScope irBuilderWithScope5 = (IrBuilderWithScope)$this$irBlockBody;
        IrValueParameter irValueParameter5 = ((IrFunction)$this$apply).getDispatchReceiverParameter();
        Intrinsics.checkNotNull(irValueParameter5);
        $this$apply.setDispatchReceiver(ExpressionHelpersKt.irGetField(irBuilderWithScope4, ExpressionHelpersKt.irGet(irBuilderWithScope5, irValueParameter5), (IrField)field));
        IrValueParameter irValueParameter6 = ((IrFunction)$this$apply).getExtensionReceiverParameter();
        if (irValueParameter6 != null) {
            Object element$iv;
            element$iv = irValueParameter6;
            boolean it = false;
            bl = false;
            Object it3 = element$iv;
            boolean bl33 = false;
            $this$apply.putValueArgument(0, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$irBlockBody, (IrValueDeclaration)it3));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        Iterable $this$forEachIndexed$iv = ((IrFunction)$this$apply).getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameter2;
            int n = index$iv++;
            boolean bl34 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter7 = (IrValueParameter)item$iv;
            int i = n;
            boolean bl35 = false;
            $this$apply.putValueArgument(extensionReceiversCount + i, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$irBlockBody, (IrValueDeclaration)parameter2));
        }
        object5 = Unit.INSTANCE;
        var33_87.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope3, irFunctionAccessExpression));
        object = Unit.INSTANCE;
        ((IrFunction)object4).setBody(this_$iv$iv2.doBuild());
        if (this.getNeedEqualsHashCodeMethods(superType)) {
            this.generateEqualsHashCode((IrClass)subclass, superType, (IrField)field);
        }
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.addFakeOverridesViaIncorrectHeuristic$default((IrClass)subclass, null, 1, null);
        return subclass;
    }

    private final void generateEqualsHashCode(IrClass klass, IrType superType, IrField functionDelegateField) {
        new SamEqualsHashCodeMethodsGenerator(this.context, klass, superType, (Function2<? super IrBuilderWithScope, ? super IrExpression, ? extends IrExpression>)new Function2<IrBuilderWithScope, IrExpression, IrExpression>(functionDelegateField){
            final /* synthetic */ IrField $functionDelegateField;

            @NotNull
            public final IrExpression invoke(@NotNull IrBuilderWithScope $receiver, @NotNull IrExpression receiver) {
                Intrinsics.checkNotNullParameter($receiver, "$receiver");
                Intrinsics.checkNotNullParameter(receiver, "receiver");
                return ExpressionHelpersKt.irGetField($receiver, receiver, this.$functionDelegateField);
            }
            {
                this.$functionDelegateField = irField;
                super(2);
            }
        }).generate();
    }

    private final List<IrSimpleType> getAdditionalSupertypes(IrType supertype2) {
        return this.getNeedEqualsHashCodeMethods(supertype2) ? CollectionsKt.listOf(IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIr().getSymbols().getFunctionAdapter(), new IrType[0])) : CollectionsKt.emptyList();
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public SingleAbstractMethodLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        boolean bl = false;
        this.cachedImplementations = new LinkedHashMap();
        bl = false;
        this.inlineCachedImplementations = new LinkedHashMap();
        this.SAM_WRAPPER_SUFFIX = "$0";
        this.FUNCTION_FIELD_NAME = "function";
    }
}

