/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.Color;
import java.awt.Container;
import java.io.File;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import mediathek.config.Icons;
import mediathek.config.MVColor;
import mediathek.config.MVConfig;
import mediathek.daten.DatenPset;
import mediathek.gui.dialog.DialogAddDownload;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.FileDialogs;
import mediathek.tool.FilenameUtils;
import org.apache.commons.configuration2.Configuration;
import org.jdesktop.swingx.VerticalLayout;

public class DialogAddMoreDownload
extends JDialog {
    public boolean addAll;
    public boolean cancel;
    public boolean info;
    public boolean subtitle;
    private final DatenPset pSet;
    private final String orgPfad;
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private JComboBox<String> jComboBoxPath;
    private JButton jButtonDelPath;
    private JButton jButtonPath;
    private JCheckBox chkInfo;
    private JCheckBox jCheckBoxPfadSpeichern;
    private JCheckBox chkSubtitle;
    private JCheckBox chkStart;
    private JButton btnChange;
    private JButton btnCancel;
    private JButton btnOk;

    public DialogAddMoreDownload(JFrame parent, DatenPset pSet) {
        super(parent);
        this.pSet = pSet;
        this.initComponents();
        this.chkSubtitle.setSelected(Boolean.parseBoolean(pSet.arr[21]));
        this.subtitle = this.chkSubtitle.isSelected();
        this.chkSubtitle.addActionListener(l -> {
            this.subtitle = this.chkSubtitle.isSelected();
        });
        this.chkInfo.setSelected(Boolean.parseBoolean(pSet.arr[19]));
        this.info = this.chkInfo.isSelected();
        this.chkInfo.addActionListener(l -> {
            this.info = this.chkInfo.isSelected();
        });
        this.chkStart.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN)));
        this.chkStart.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN, String.valueOf(this.chkStart.isSelected())));
        this.jCheckBoxPfadSpeichern.setSelected(this.config.getBoolean("download.path.last_used.show", true));
        this.jCheckBoxPfadSpeichern.addActionListener(e -> this.config.setProperty("download.path.last_used.show", this.jCheckBoxPfadSpeichern.isSelected()));
        this.btnChange.addActionListener(l -> this.beenden());
        this.btnOk.addActionListener(e -> {
            this.addAll = true;
            this.beenden();
        });
        this.btnCancel.addActionListener(l -> {
            this.cancel = true;
            this.beenden();
        });
        this.jButtonPath.setIcon(Icons.ICON_BUTTON_FILE_OPEN);
        this.jButtonPath.addActionListener(l -> {
            File selectedDirectory;
            String initialDirectory = "";
            String cbItem = Objects.requireNonNull(this.jComboBoxPath.getSelectedItem()).toString();
            if (!cbItem.isEmpty()) {
                initialDirectory = cbItem;
            }
            if ((selectedDirectory = FileDialogs.chooseDirectoryLocation(MediathekGui.ui(), "Film speichern", initialDirectory)) != null) {
                String absolutePath = selectedDirectory.getAbsolutePath();
                this.jComboBoxPath.addItem(absolutePath);
                this.jComboBoxPath.setSelectedItem(absolutePath);
            }
        });
        this.jButtonDelPath.setIcon(Icons.ICON_BUTTON_DEL);
        this.jButtonDelPath.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN, "");
            this.jComboBoxPath.setModel(new DefaultComboBoxModel<String>(new String[]{pSet.getZielPfad()}));
        });
        DialogAddDownload.setModelPfad(pSet.getZielPfad(), this.jComboBoxPath);
        this.orgPfad = pSet.getZielPfad();
        ((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).setOpaque(true);
        ((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                String s2 = ((JTextComponent)DialogAddMoreDownload.this.jComboBoxPath.getEditor().getEditorComponent()).getText();
                if (!s2.equals(FilenameUtils.checkDateiname(s2, true))) {
                    DialogAddMoreDownload.this.jComboBoxPath.getEditor().getEditorComponent().setBackground(MVColor.DOWNLOAD_FEHLER.color);
                } else {
                    DialogAddMoreDownload.this.jComboBoxPath.getEditor().getEditorComponent().setBackground(Color.WHITE);
                }
            }
        });
        EscapeKeyHandler.installHandler(this, () -> {
            this.cancel = true;
            this.beenden();
        });
        this.pack();
    }

    public String getPath() {
        String path = this.jComboBoxPath.getModel().getSelectedItem().toString();
        if (path.isEmpty()) {
            path = this.pSet.getZielPfad();
        }
        return path;
    }

    private void beenden() {
        DialogAddDownload.saveComboPfad(this.jComboBoxPath, this.orgPfad);
        this.dispose();
    }

    private void initComponents() {
        JPanel jPanelExtra = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jComboBoxPath = new JComboBox();
        this.jButtonDelPath = new JButton();
        this.jButtonPath = new JButton();
        JPanel jPanel1 = new JPanel();
        this.chkInfo = new JCheckBox();
        this.jCheckBoxPfadSpeichern = new JCheckBox();
        this.chkSubtitle = new JCheckBox();
        this.chkStart = new JCheckBox();
        this.btnChange = new JButton();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Alle Downloads starten");
        this.setModal(true);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        jPanelExtra.setBorder(new EtchedBorder());
        jLabel1.setText("Speicherpfad:");
        this.jComboBoxPath.setEditable(true);
        this.jComboBoxPath.setModel(new DefaultComboBoxModel<String>(new String[0]));
        this.jButtonDelPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-del.png")));
        this.jButtonDelPath.setToolTipText("History l\u00f6schen");
        this.jButtonPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonPath.setToolTipText("Zielpfad ausw\u00e4hlen");
        jPanel1.setLayout(new VerticalLayout(5));
        this.chkInfo.setText("Infodatei anlegen: \"Filmname.txt\"");
        jPanel1.add(this.chkInfo);
        this.jCheckBoxPfadSpeichern.setText("Zielpfad speichern");
        jPanel1.add(this.jCheckBoxPfadSpeichern);
        this.chkSubtitle.setText("Untertitel speichern: \"Filmname.xxx\"");
        jPanel1.add(this.chkSubtitle);
        this.chkStart.setText("Download sofort starten");
        jPanel1.add(this.chkStart);
        GroupLayout jPanelExtraLayout = new GroupLayout(jPanelExtra);
        jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup().addGroup(jPanelExtraLayout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelExtraLayout.createParallelGroup().addGroup(jPanelExtraLayout.createSequentialGroup().addComponent(this.jComboBoxPath, -2, 450, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonDelPath)).addComponent(jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup().addGroup(jPanelExtraLayout.createSequentialGroup().addContainerGap().addGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jComboBoxPath, -2, -1, -2).addComponent(this.jButtonDelPath).addComponent(this.jButtonPath)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnChange.setText("Einzeln anlegen");
        this.btnChange.setToolTipText("Die Sammelaktion wird abgebrochen und Sie k\u00f6nnen im Anschlu\u00df die Einstellungen f\u00fcr jeden Download einzeln festlegen.");
        this.btnCancel.setText("Abbrechen");
        this.btnOk.setText("Speichern");
        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addGroup(contentPaneLayout.createParallelGroup().addComponent(jPanelExtra, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, contentPaneLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addGap(18, 18, 18).addComponent(this.btnChange))).addContainerGap()));
        contentPaneLayout.setVerticalGroup(contentPaneLayout.createParallelGroup().addGroup(contentPaneLayout.createSequentialGroup().addContainerGap().addComponent(jPanelExtra, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(contentPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnChange).addComponent(this.btnCancel).addComponent(this.btnOk)).addContainerGap(2, Short.MAX_VALUE)));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

