/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextParticipant
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextParticipant(ComponentType type, Display stringsToDisplay, FileFormat fileFormat) {
        this.type = type;
        this.stringsToDisplay = stringsToDisplay;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int height = (int)dimensionToUse.getHeight();
        charArea.fillRect(' ', 0, 0, width, height);
        if (this.fileFormat == FileFormat.UTXT) {
            charArea.drawBoxSimpleUnicode(0, 0, width, height);
            if (this.type == ComponentType.PARTICIPANT_TAIL) {
                charArea.drawChar('\u2534', (width - 1) / 2, 0);
            }
            if (this.type == ComponentType.PARTICIPANT_HEAD) {
                charArea.drawChar('\u252c', (width - 1) / 2, height - 1);
            }
        } else {
            charArea.drawBoxSimple(0, 0, width, height);
            if (this.type == ComponentType.PARTICIPANT_TAIL) {
                charArea.drawChar('+', (width - 1) / 2, 0);
            }
            if (this.type == ComponentType.PARTICIPANT_HEAD) {
                charArea.drawChar('+', (width - 1) / 2, height - 1);
            }
        }
        if (this.fileFormat == FileFormat.UTXT) {
            charArea.drawStringsLRUnicode(this.stringsToDisplay.as(), 1, 1);
        } else {
            charArea.drawStringsLRSimple(this.stringsToDisplay.as(), 1, 1);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 2;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWcWidth(this.stringsToDisplay) + 2;
    }
}

