/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;

public class SolrMetricsContext {
    public final String registry;
    public final SolrMetricManager metricManager;
    public final String tag;

    public SolrMetricsContext(SolrMetricManager metricManager, String registry, String tag) {
        this.registry = registry;
        this.metricManager = metricManager;
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public void unregister() {
        this.metricManager.unregisterGauges(this.registry, this.tag);
    }

    public SolrMetricsContext getChildContext(Object child) {
        SolrMetricsContext childContext = new SolrMetricsContext(this.metricManager, this.registry, SolrMetricProducer.getUniqueMetricTag(child, this.tag));
        return childContext;
    }

    public Meter meter(SolrInfoBean info, String metricName, String ... metricPath) {
        return this.metricManager.meter(info, this.registry, metricName, metricPath);
    }

    public Counter counter(SolrInfoBean info, String metricName, String ... metricPath) {
        return this.metricManager.counter(info, this.registry, metricName, metricPath);
    }

    public void gauge(SolrInfoBean info, Gauge<?> gauge, boolean force, String metricName, String ... metricPath) {
        this.metricManager.registerGauge(info, this.registry, gauge, this.tag, force, metricName, metricPath);
    }

    public Timer timer(SolrInfoBean info, String metricName, String ... metricPath) {
        return this.metricManager.timer(info, this.registry, metricName, metricPath);
    }

    public Histogram histogram(SolrInfoBean info, String metricName, String ... metricPath) {
        return this.metricManager.histogram(info, this.registry, metricName, metricPath);
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricManager.registry(this.registry);
    }
}

