/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.rrd;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.solr.metrics.rrd.SolrRrdBackendFactory;
import org.rrd4j.core.RrdByteArrayBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrRrdBackend
extends RrdByteArrayBackend
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrRrdBackendFactory factory;
    private final boolean readOnly;
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean dirty = false;
    private volatile boolean closed = false;
    private volatile long lastModifiedTime;

    public SolrRrdBackend(String path, boolean readOnly, SolrRrdBackendFactory factory) {
        super(path);
        this.factory = factory;
        this.lastModifiedTime = TimeUnit.MILLISECONDS.convert(factory.getTimeSource().getEpochTimeNs(), TimeUnit.NANOSECONDS);
        try {
            SyncData syncData = factory.getData(path);
            if (syncData != null) {
                this.setBuffer(syncData.data);
                this.lastModifiedTime = syncData.timestamp;
            }
        }
        catch (IOException e) {
            log.warn("Exception retrieving data from {}, store will be readOnly", (Object)path, (Object)e);
            readOnly = true;
        }
        this.readOnly = readOnly;
    }

    public SolrRrdBackend(SolrRrdBackend other) {
        super(other.getPath());
        this.readOnly = true;
        this.factory = null;
        this.lastModifiedTime = other.lastModifiedTime;
        byte[] otherBuffer = other.getBuffer();
        byte[] newBuffer = new byte[otherBuffer.length];
        System.arraycopy(otherBuffer, 0, newBuffer, 0, otherBuffer.length);
        super.setBuffer(newBuffer);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    private void markDirty() {
        this.lastModifiedTime = TimeUnit.MILLISECONDS.convert(this.factory.getTimeSource().getEpochTimeNs(), TimeUnit.NANOSECONDS);
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(long offset, byte[] bytes) throws IOException {
        if (this.readOnly || this.closed) {
            return;
        }
        this.lock.lock();
        try {
            super.write(offset, bytes);
            this.markDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeShort(long offset, short value) throws IOException {
        if (this.readOnly || this.closed) {
            return;
        }
        this.lock.lock();
        try {
            super.writeShort(offset, value);
            this.markDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInt(long offset, int value) throws IOException {
        if (this.readOnly || this.closed) {
            return;
        }
        this.lock.lock();
        try {
            super.writeInt(offset, value);
            this.markDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLong(long offset, long value) throws IOException {
        if (this.readOnly || this.closed) {
            return;
        }
        this.lock.lock();
        try {
            super.writeLong(offset, value);
            this.markDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDouble(long offset, double value) throws IOException {
        if (this.readOnly || this.closed) {
            return;
        }
        this.lock.lock();
        try {
            super.writeDouble(offset, value);
            this.markDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDouble(long offset, double value, int count) throws IOException {
        if (this.readOnly || this.closed) {
            return;
        }
        this.lock.lock();
        try {
            super.writeDouble(offset, value, count);
            this.markDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDouble(long offset, double[] values) throws IOException {
        if (this.readOnly || this.closed) {
            return;
        }
        this.lock.lock();
        try {
            super.writeDouble(offset, values);
            this.markDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeString(long offset, String value, int length) throws IOException {
        if (this.readOnly || this.closed) {
            return;
        }
        this.lock.lock();
        try {
            super.writeString(offset, value, length);
            this.markDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void setBuffer(byte[] buffer) {
        if (this.readOnly || this.closed) {
            return;
        }
        this.lock.lock();
        try {
            super.setBuffer(buffer);
            this.markDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setLength(long length) throws IOException {
        if (this.readOnly || this.closed) {
            return;
        }
        this.lock.lock();
        try {
            super.setLength(length);
            this.markDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncData getSyncDataAndMarkClean() {
        if (this.readOnly || this.closed) {
            return null;
        }
        if (!this.dirty) {
            return null;
        }
        this.lock.lock();
        try {
            byte[] oldBuffer = this.getBuffer();
            byte[] bufferCopy = new byte[oldBuffer.length];
            System.arraycopy(oldBuffer, 0, bufferCopy, 0, oldBuffer.length);
            SyncData syncData = new SyncData(bufferCopy, this.lastModifiedTime);
            return syncData;
        }
        finally {
            this.dirty = false;
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
        if (this.factory != null) {
            this.factory.unregisterBackend(this.getPath());
        }
    }

    public static final class SyncData {
        public byte[] data;
        public long timestamp;

        public SyncData(byte[] data, long timestamp) {
            this.data = data;
            this.timestamp = timestamp;
        }
    }
}

