/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolrZkServerProps
extends QuorumPeerConfig {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern MISSING_MYID_FILE_PATTERN = Pattern.compile(".*myid file is missing$");
    String solrPort;
    String zkRun;

    SolrZkServerProps() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String path) throws QuorumPeerConfig.ConfigException {
        File configFile = new File(path);
        log.info("Reading configuration from: {}", (Object)configFile);
        try {
            if (!configFile.exists()) {
                throw new IllegalArgumentException(configFile.toString() + " file is missing");
            }
            Properties cfg = new Properties();
            try (FileInputStream in = new FileInputStream(configFile);){
                cfg.load(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8));
            }
            return cfg;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + path, e);
        }
    }

    public static void injectServers(Properties props, String zkRun, String zkHost) {
        boolean hasServers;
        int portIdx;
        if (zkRun != null && props.getProperty("clientPort") == null && (portIdx = zkRun.lastIndexOf(58)) > 0) {
            String portStr = zkRun.substring(portIdx + 1);
            props.setProperty("clientPort", portStr);
        }
        if (!(hasServers = SolrZkServerProps.hasServers(props)) && zkHost != null) {
            int alg = Integer.parseInt(props.getProperty("electionAlg", "3").trim());
            String[] hosts = zkHost.split(",");
            int serverNum = 0;
            for (String hostAndPort : hosts) {
                hostAndPort = hostAndPort.trim();
                int portIdx2 = hostAndPort.lastIndexOf(58);
                String clientPortStr = hostAndPort.substring(portIdx2 + 1);
                int clientPort = Integer.parseInt(clientPortStr);
                String host = hostAndPort.substring(0, portIdx2);
                String serverStr = host + ':' + (clientPort + 1);
                if (alg != 0) {
                    serverStr = serverStr + ':' + (clientPort + 2);
                }
                props.setProperty("server." + serverNum, serverStr);
                ++serverNum;
            }
        }
    }

    public static boolean hasServers(Properties props) {
        for (Object key : props.keySet()) {
            if (!((String)key).startsWith("server.")) continue;
            return true;
        }
        return false;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public void setClientPort(int clientPort) {
        if (this.clientPortAddress != null) {
            try {
                this.clientPortAddress = new InetSocketAddress(InetAddress.getByName(this.clientPortAddress.getHostName()), clientPort);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.clientPortAddress = new InetSocketAddress(clientPort);
        }
    }

    public void parseProperties(Properties zkProp) throws IOException, QuorumPeerConfig.ConfigException {
        super.parseProperties(zkProp);
    }
}

