/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermFrequencyAttribute;
import org.apache.lucene.document.FeatureDoubleValuesSource;
import org.apache.lucene.document.FeatureQuery;
import org.apache.lucene.document.FeatureSortField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.similarities.Similarity;

public final class FeatureField
extends Field {
    private static final FieldType FIELD_TYPE = new FieldType();
    private float featureValue;
    static final int MAX_FREQ;
    private static final float MAX_WEIGHT = 64.0f;

    public FeatureField(String fieldName, String featureName, float featureValue) {
        super(fieldName, featureName, (IndexableFieldType)FIELD_TYPE);
        this.setFeatureValue(featureValue);
    }

    public void setFeatureValue(float featureValue) {
        if (!Float.isFinite(featureValue)) {
            throw new IllegalArgumentException("featureValue must be finite, got: " + featureValue + " for feature " + this.fieldsData + " on field " + this.name);
        }
        if (featureValue < Float.MIN_NORMAL) {
            throw new IllegalArgumentException("featureValue must be a positive normal float, got: " + featureValue + " for feature " + this.fieldsData + " on field " + this.name + " which is less than the minimum positive normal float: " + Float.MIN_NORMAL);
        }
        this.featureValue = featureValue;
    }

    @Override
    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        FeatureTokenStream stream = reuse instanceof FeatureTokenStream ? (FeatureTokenStream)reuse : new FeatureTokenStream();
        int freqBits = Float.floatToIntBits(this.featureValue);
        stream.setValues((String)this.fieldsData, freqBits >>> 15);
        return stream;
    }

    static float decodeFeatureValue(float freq) {
        if (freq > (float)MAX_FREQ) {
            return Float.MAX_VALUE;
        }
        int tf = (int)freq;
        int featureBits = tf << 15;
        return Float.intBitsToFloat(featureBits);
    }

    public static Query newLogQuery(String fieldName, String featureName, float weight, float scalingFactor) {
        if (weight <= 0.0f || weight > 64.0f) {
            throw new IllegalArgumentException("weight must be in (0, 64.0], got: " + weight);
        }
        if (scalingFactor < 1.0f || !Float.isFinite(scalingFactor)) {
            throw new IllegalArgumentException("scalingFactor must be >= 1, got: " + scalingFactor);
        }
        Query q = new FeatureQuery(fieldName, featureName, new LogFunction(scalingFactor));
        if (weight != 1.0f) {
            q = new BoostQuery(q, weight);
        }
        return q;
    }

    public static Query newSaturationQuery(String fieldName, String featureName, float weight, float pivot) {
        return FeatureField.newSaturationQuery(fieldName, featureName, weight, Float.valueOf(pivot));
    }

    public static Query newSaturationQuery(String fieldName, String featureName) {
        return FeatureField.newSaturationQuery(fieldName, featureName, 1.0f, null);
    }

    private static Query newSaturationQuery(String fieldName, String featureName, float weight, Float pivot) {
        if (weight <= 0.0f || weight > 64.0f) {
            throw new IllegalArgumentException("weight must be in (0, 64.0], got: " + weight);
        }
        if (pivot != null && (pivot.floatValue() <= 0.0f || !Float.isFinite(pivot.floatValue()))) {
            throw new IllegalArgumentException("pivot must be > 0, got: " + pivot);
        }
        Query q = new FeatureQuery(fieldName, featureName, new SaturationFunction(fieldName, featureName, pivot));
        if (weight != 1.0f) {
            q = new BoostQuery(q, weight);
        }
        return q;
    }

    public static Query newSigmoidQuery(String fieldName, String featureName, float weight, float pivot, float exp) {
        if (weight <= 0.0f || weight > 64.0f) {
            throw new IllegalArgumentException("weight must be in (0, 64.0], got: " + weight);
        }
        if (pivot <= 0.0f || !Float.isFinite(pivot)) {
            throw new IllegalArgumentException("pivot must be > 0, got: " + pivot);
        }
        if (exp <= 0.0f || !Float.isFinite(exp)) {
            throw new IllegalArgumentException("exp must be > 0, got: " + exp);
        }
        Query q = new FeatureQuery(fieldName, featureName, new SigmoidFunction(pivot, exp));
        if (weight != 1.0f) {
            q = new BoostQuery(q, weight);
        }
        return q;
    }

    static float computePivotFeatureValue(IndexReader reader, String featureField, String featureName) throws IOException {
        Term term = new Term(featureField, featureName);
        TermStates states = TermStates.build(reader.getContext(), term, true);
        if (states.docFreq() == 0) {
            return 1.0f;
        }
        float avgFreq = (float)((double)states.totalTermFreq() / (double)states.docFreq());
        return FeatureField.decodeFeatureValue(avgFreq);
    }

    public static SortField newFeatureSort(String field, String featureName) {
        return new FeatureSortField(field, featureName);
    }

    public static DoubleValuesSource newDoubleValues(String field, String featureName) {
        return new FeatureDoubleValuesSource(field, featureName);
    }

    static {
        FIELD_TYPE.setTokenized(false);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS);
        MAX_FREQ = Float.floatToIntBits(Float.MAX_VALUE) >>> 15;
    }

    private static final class FeatureTokenStream
    extends TokenStream {
        private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
        private final TermFrequencyAttribute freqAttribute = this.addAttribute(TermFrequencyAttribute.class);
        private boolean used = true;
        private String value = null;
        private int freq = 0;

        private FeatureTokenStream() {
        }

        void setValues(String value, int freq) {
            this.value = value;
            this.freq = freq;
        }

        @Override
        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.termAttribute.append(this.value);
            this.freqAttribute.setTermFrequency(this.freq);
            this.used = true;
            return true;
        }

        @Override
        public void reset() {
            this.used = false;
        }

        @Override
        public void close() {
            this.value = null;
        }
    }

    static final class LogFunction
    extends FeatureFunction {
        private final float scalingFactor;

        LogFunction(float a) {
            this.scalingFactor = a;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LogFunction that = (LogFunction)obj;
            return this.scalingFactor == that.scalingFactor;
        }

        public int hashCode() {
            return Float.hashCode(this.scalingFactor);
        }

        public String toString() {
            return "LogFunction(scalingFactor=" + this.scalingFactor + ")";
        }

        @Override
        Similarity.SimScorer scorer(final float weight) {
            return new Similarity.SimScorer(){

                @Override
                public float score(float freq, long norm) {
                    return (float)((double)weight * Math.log(scalingFactor + FeatureField.decodeFeatureValue(freq)));
                }
            };
        }

        @Override
        Explanation explain(String field, String feature, float w, int freq) {
            float featureValue = FeatureField.decodeFeatureValue(freq);
            float score = this.scorer(w).score(freq, 1L);
            return Explanation.match((Number)Float.valueOf(score), "Log function on the " + field + " field for the " + feature + " feature, computed as w * log(a + S) from:", Explanation.match((Number)Float.valueOf(w), "w, weight of this function", new Explanation[0]), Explanation.match((Number)Float.valueOf(this.scalingFactor), "a, scaling factor", new Explanation[0]), Explanation.match((Number)Float.valueOf(featureValue), "S, feature value", new Explanation[0]));
        }
    }

    static abstract class FeatureFunction {
        FeatureFunction() {
        }

        abstract Similarity.SimScorer scorer(float var1);

        abstract Explanation explain(String var1, String var2, float var3, int var4);

        FeatureFunction rewrite(IndexReader reader) throws IOException {
            return this;
        }
    }

    static final class SaturationFunction
    extends FeatureFunction {
        private final String field;
        private final String feature;
        private final Float pivot;

        SaturationFunction(String field, String feature, Float pivot) {
            this.field = field;
            this.feature = feature;
            this.pivot = pivot;
        }

        @Override
        public FeatureFunction rewrite(IndexReader reader) throws IOException {
            if (this.pivot != null) {
                return super.rewrite(reader);
            }
            float newPivot = FeatureField.computePivotFeatureValue(reader, this.field, this.feature);
            return new SaturationFunction(this.field, this.feature, Float.valueOf(newPivot));
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SaturationFunction that = (SaturationFunction)obj;
            return Objects.equals(this.field, that.field) && Objects.equals(this.feature, that.feature) && Objects.equals(this.pivot, that.pivot);
        }

        public int hashCode() {
            return Objects.hash(this.field, this.feature, this.pivot);
        }

        public String toString() {
            return "SaturationFunction(pivot=" + this.pivot + ")";
        }

        @Override
        Similarity.SimScorer scorer(final float weight) {
            if (this.pivot == null) {
                throw new IllegalStateException("Rewrite first");
            }
            final float pivot = this.pivot.floatValue();
            return new Similarity.SimScorer(){

                @Override
                public float score(float freq, long norm) {
                    float f = FeatureField.decodeFeatureValue(freq);
                    return weight * (1.0f - pivot / (f + pivot));
                }
            };
        }

        @Override
        Explanation explain(String field, String feature, float weight, int freq) {
            float featureValue = FeatureField.decodeFeatureValue(freq);
            float score = this.scorer(weight).score(freq, 1L);
            return Explanation.match((Number)Float.valueOf(score), "Saturation function on the " + field + " field for the " + feature + " feature, computed as w * S / (S + k) from:", Explanation.match((Number)Float.valueOf(weight), "w, weight of this function", new Explanation[0]), Explanation.match((Number)this.pivot, "k, pivot feature value that would give a score contribution equal to w/2", new Explanation[0]), Explanation.match((Number)Float.valueOf(featureValue), "S, feature value", new Explanation[0]));
        }
    }

    static final class SigmoidFunction
    extends FeatureFunction {
        private final float pivot;
        private final float a;
        private final double pivotPa;

        SigmoidFunction(float pivot, float a) {
            this.pivot = pivot;
            this.a = a;
            this.pivotPa = Math.pow(pivot, a);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SigmoidFunction that = (SigmoidFunction)obj;
            return this.pivot == that.pivot && this.a == that.a;
        }

        public int hashCode() {
            int h = Float.hashCode(this.pivot);
            h = 31 * h + Float.hashCode(this.a);
            return h;
        }

        public String toString() {
            return "SigmoidFunction(pivot=" + this.pivot + ", a=" + this.a + ")";
        }

        @Override
        Similarity.SimScorer scorer(final float weight) {
            return new Similarity.SimScorer(){

                @Override
                public float score(float freq, long norm) {
                    float f = FeatureField.decodeFeatureValue(freq);
                    return (float)((double)weight * (1.0 - pivotPa / (Math.pow(f, a) + pivotPa)));
                }
            };
        }

        @Override
        Explanation explain(String field, String feature, float weight, int freq) {
            float featureValue = FeatureField.decodeFeatureValue(freq);
            float score = this.scorer(weight).score(freq, 1L);
            return Explanation.match((Number)Float.valueOf(score), "Sigmoid function on the " + field + " field for the " + feature + " feature, computed as w * S^a / (S^a + k^a) from:", Explanation.match((Number)Float.valueOf(weight), "w, weight of this function", new Explanation[0]), Explanation.match((Number)Float.valueOf(this.pivot), "k, pivot feature value that would give a score contribution equal to w/2", new Explanation[0]), Explanation.match((Number)Float.valueOf(this.pivot), "a, exponent, higher values make the function grow slower before k and faster after k", new Explanation[0]), Explanation.match((Number)Float.valueOf(featureValue), "S, feature value", new Explanation[0]));
        }
    }
}

