/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.Ground3D;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.OBJMaterial;
import com.eteks.sweethome3d.j3d.Object3DBranchFactory;
import com.eteks.sweethome3d.j3d.Room3D;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.Transformation;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.Object3DFactory;
import java.awt.AlphaComposite;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import org.sunflow.PluginRegistry;
import org.sunflow.SunflowAPI;
import org.sunflow.core.Display;
import org.sunflow.core.Instance;
import org.sunflow.core.ParameterList;
import org.sunflow.core.light.SphereLight;
import org.sunflow.core.light.SunSkyLight;
import org.sunflow.core.primitive.TriangleMesh;
import org.sunflow.image.Color;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.UI;
import org.sunflow.system.UserInterface;
import org.sunflow.system.ui.SilentInterface;

public class PhotoRenderer {
    private final Home home;
    private final Object3DFactory object3dFactory;
    private final Quality quality;
    private final Compass compass;
    private final int homeLightColor;
    private final SunflowAPI sunflow;
    private boolean useSunSky;
    private boolean useSunskyLight;
    private String sunSkyLightName;
    private String sunLightName;
    private final Map<Selectable, String[]> homeItemsNames = new HashMap<Selectable, String[]>();
    private final Map<TransparentTextureKey, String> textureImagesCache = new HashMap<TransparentTextureKey, String>();
    private Thread renderingThread;

    public PhotoRenderer(Home home, Quality quality) throws IOException {
        this(home, new PhotoObject3DFactory(), quality);
    }

    public PhotoRenderer(Home home, Object3DFactory object3DFactory, Quality quality) throws IOException {
        Serializable serializable;
        Iterator<Room> iterator;
        Node node;
        Object object;
        Selectable selectable22;
        this.home = home;
        this.compass = home.getCompass();
        this.quality = quality;
        this.sunflow = new SunflowAPI();
        this.useSunskyLight = !(home.getCamera() instanceof ObserverCamera);
        boolean bl = this.isSilkShaderUsed(quality);
        if (object3DFactory == null) {
            object3DFactory = new PhotoObject3DFactory();
        }
        this.object3dFactory = object3DFactory;
        HomeEnvironment homeEnvironment = home.getEnvironment();
        float f = homeEnvironment.getSubpartSizeUnderLight();
        homeEnvironment.setSubpartSizeUnderLight(0.0f);
        ArrayList<HomeLight> arrayList = new ArrayList<HomeLight>();
        for (Selectable selectable22 : home.getSelectableViewableItems()) {
            if (selectable22 instanceof HomeFurnitureGroup) {
                for (HomePieceOfFurniture homePieceOfFurniture : ((HomeFurnitureGroup)selectable22).getAllFurniture()) {
                    if (homePieceOfFurniture instanceof HomeFurnitureGroup || (object = (Node)object3DFactory.createObject3D(home, homePieceOfFurniture, true)) == null) continue;
                    this.homeItemsNames.put(homePieceOfFurniture, this.exportNode((Node)object, false, bl));
                    if (!(homePieceOfFurniture instanceof HomeLight)) continue;
                    arrayList.add((HomeLight)homePieceOfFurniture);
                }
                continue;
            }
            node = (Node)object3DFactory.createObject3D(home, selectable22, true);
            if (node == null) continue;
            String[] stringArray = this.exportNode(node, selectable22 instanceof Wall || selectable22 instanceof Room, bl);
            this.homeItemsNames.put(selectable22, stringArray);
            if (!(selectable22 instanceof HomeLight)) continue;
            arrayList.add((HomeLight)selectable22);
        }
        Object object5 = new Ground3D(home, -5000000.0f, -5000000.0f, 1.0E7f, 1.0E7f, true);
        selectable22 = new Transform3D();
        selectable22.setTranslation(new Vector3f(0.0f, -0.1f, 0.0f));
        node = new TransformGroup((Transform3D)selectable22);
        node.addChild(object5);
        this.exportNode(node, true, bl);
        homeEnvironment.setSubpartSizeUnderLight(f);
        HomeTexture homeTexture = homeEnvironment.getSkyTexture();
        boolean bl2 = this.useSunSky = homeTexture == null || this.useSunskyLight;
        if (!this.useSunSky) {
            object = homeTexture.getImage().openStream();
            iterator = ImageIO.read((InputStream)object);
            ((InputStream)object).close();
            BufferedImage bufferedImage = new BufferedImage(((BufferedImage)((Object)iterator)).getWidth(), ((BufferedImage)((Object)iterator)).getHeight() * 2, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.drawRenderedImage((RenderedImage)((Object)iterator), AffineTransform.getTranslateInstance((float)((BufferedImage)((Object)iterator)).getWidth() * homeTexture.getXOffset(), 0.0));
            graphics2D.drawRenderedImage((RenderedImage)((Object)iterator), AffineTransform.getTranslateInstance((float)((BufferedImage)((Object)iterator)).getWidth() * (homeTexture.getXOffset() - 1.0f), 0.0));
            graphics2D.dispose();
            serializable = OperatingSystem.createTemporaryFile("ibl", ".png");
            ImageIO.write((RenderedImage)bufferedImage, "png", (File)serializable);
            this.textureImagesCache.put(null, ((File)serializable).getAbsolutePath());
            this.sunflow.parameter("texture", ((File)serializable).getAbsolutePath());
            this.sunflow.parameter("center", new Vector3(-1.0f, 0.0f, 0.0f));
            this.sunflow.parameter("up", new Vector3(0.0f, 1.0f, 0.0f));
            this.sunflow.parameter("fixed", true);
            this.sunflow.parameter("samples", 0);
            this.sunflow.light(UUID.randomUUID().toString(), "ibl");
        }
        int n = homeEnvironment.getCeillingLightColor();
        this.homeLightColor = homeEnvironment.getLightColor();
        if (n > 0) {
            for (Room room : home.getRooms()) {
                Level level = room.getLevel();
                if (!room.isCeilingVisible() || level != null && !level.isViewableAndVisible()) continue;
                float f2 = room.getXCenter();
                float f3 = room.getYCenter();
                double d = Double.POSITIVE_INFINITY;
                float f4 = level != null ? level.getElevation() : 0.0f;
                float f5 = f4 + (level == null ? home.getWallHeight() : level.getHeight());
                List<Level> list = home.getLevels();
                if (level == null || list.indexOf(level) == list.size() - 1) {
                    for (Wall wall : home.getWalls()) {
                        if (wall.getLevel() != null && !wall.getLevel().isViewable() || !wall.isAtLevel(level)) continue;
                        float f6 = wall.getLevel() == null ? 0.0f : wall.getLevel().getElevation();
                        Float f7 = wall.getHeight();
                        float[][] fArray = wall.getPoints();
                        for (int i = 0; i < fArray.length; ++i) {
                            double d2 = Point2D.distanceSq(fArray[i][0], fArray[i][1], f2, f3);
                            if (!(d2 < d)) continue;
                            d = d2;
                            f5 = i == 0 || i == fArray.length - 1 ? (f7 != null ? f7.floatValue() : home.getWallHeight()) : (wall.isTrapezoidal() ? wall.getHeightAtEnd().floatValue() : (f7 != null ? f7.floatValue() : home.getWallHeight()));
                            f5 += f6;
                        }
                    }
                }
                float f8 = (float)Math.sqrt(room.getArea()) / 3.0f;
                this.sunflow.parameter("radiance", null, new float[]{f8 * (float)(n >> 16) / 208.0f * (float)(this.homeLightColor >> 16) / 255.0f, f8 * (float)(n >> 8 & 0xFF) / 208.0f * (float)(this.homeLightColor >> 8 & 0xFF) / 255.0f, f8 * (float)(n & 0xFF) / 208.0f * (float)(this.homeLightColor & 0xFF) / 255.0f});
                this.sunflow.parameter("center", new Point3(f2, f5 - 25.0f, f3));
                this.sunflow.parameter("radius", 20.0f);
                this.sunflow.parameter("samples", 4);
                this.sunflow.light(UUID.randomUUID().toString(), "sphere");
            }
        }
        iterator = ModelManager.getInstance();
        for (final HomeLight homeLight : arrayList) {
            serializable = homeLight.getLevel();
            if (!(homeLight.getPower() > 0.0f) || serializable != null && !((Level)serializable).isViewableAndVisible()) continue;
            if (homeLight.isHorizontallyRotated() || homeLight.getModelTransformations() != null) {
                ((ModelManager)((Object)iterator)).loadModel(homeLight.getModel(), true, new ModelManager.ModelObserver(){
                    final /* synthetic */ ModelManager val$modelManager;
                    {
                        this.val$modelManager = modelManager;
                    }

                    @Override
                    public void modelUpdated(BranchGroup branchGroup) {
                        float[][] fArray = homeLight.getModelRotation();
                        Transformation[] transformationArray = homeLight.getModelTransformations();
                        Transform3D transform3D = null;
                        Node node = null;
                        if (transformationArray != null) {
                            node = this.val$modelManager.cloneNode((Node)branchGroup);
                            transform3D = this.val$modelManager.getNormalizedTransform((Node)branchGroup, fArray, 1.0f, homeLight.isModelCenteredAtOrigin());
                            transform3D.invert();
                            PhotoRenderer.this.updateModelTransformations((Node)branchGroup, transformationArray);
                        }
                        Transform3D transform3D2 = this.val$modelManager.getNormalizedTransform((Node)branchGroup, fArray, 1.0f, homeLight.isModelCenteredAtOrigin());
                        TransformGroup transformGroup = new TransformGroup(transform3D2);
                        transformGroup.addChild((Node)branchGroup);
                        Transform3D transform3D3 = this.val$modelManager.getPieceOfFurnitureNormalizedModelTransformation(homeLight, (Node)transformGroup);
                        if (transformationArray != null) {
                            for (LightSource lightSource : homeLight.getLightSources()) {
                                int n;
                                for (n = 0; n < transformationArray.length; ++n) {
                                    Transformation transformation = transformationArray[n];
                                    Point3f point3f = PhotoRenderer.this.getNormalizedLightSourceLocation(lightSource);
                                    transform3D.transform(point3f);
                                    BoundingSphere boundingSphere = new BoundingSphere(new Point3d(point3f), (double)PhotoRenderer.this.getLightSourceRadius(homeLight, lightSource));
                                    String string = transformation.getName() + "_transformation";
                                    if (!PhotoRenderer.this.intersectsDeformedNode(node, (Bounds)boundingSphere, string)) continue;
                                    Transform3D transform3D4 = new Transform3D(transform3D3);
                                    transform3D4.mul(transform3D2);
                                    Transform3D transform3D5 = PhotoRenderer.this.getDeformation((Node)branchGroup, new Transform3D(), string);
                                    transform3D4.mul(transform3D5);
                                    transform3D4.mul(transform3D);
                                    PhotoRenderer.this.exportLightSource(homeLight, lightSource, transform3D4);
                                    break;
                                }
                                if (n != transformationArray.length) continue;
                                PhotoRenderer.this.exportLightSource(homeLight, lightSource, transform3D3);
                            }
                        } else {
                            PhotoRenderer.this.exportLightSources(homeLight, transform3D3);
                        }
                    }

                    @Override
                    public void modelError(Exception exception) {
                    }
                });
                continue;
            }
            Transform3D transform3D = ((ModelManager)((Object)iterator)).getPieceOfFurnitureNormalizedModelTransformation(homeLight, null);
            this.exportLightSources(homeLight, transform3D);
        }
        this.sunflow.parameter("depths.diffuse", Integer.parseInt(this.getRenderingParameterValue("diffusedBounces")));
        this.sunflow.parameter("depths.reflection", 4);
        this.sunflow.parameter("depths.refraction", 16);
        this.sunflow.options("::options");
        Integer n2 = new Integer(this.getRenderingParameterValue("causticsPhotons"));
        if (n2 > 0) {
            this.sunflow.parameter("caustics.emit", n2.intValue());
            this.sunflow.parameter("caustics", "kd");
            this.sunflow.parameter("caustics.gather", 64);
            this.sunflow.parameter("caustics.radius", 0.5f);
            this.sunflow.options("::options");
        }
        this.sunflow.parameter("bucket.size", 64);
        this.sunflow.parameter("bucket.order", "spiral");
        this.sunflow.options("::options");
    }

    private void updateModelTransformations(Node node, Transformation[] transformationArray) {
        for (Transformation transformation : transformationArray) {
            String string = transformation.getName() + "_transformation";
            this.updateTransformation(node, string, transformation.getMatrix());
        }
    }

    private void updateTransformation(Node node, String string, float[][] fArray) {
        if (node instanceof Group) {
            if (node instanceof TransformGroup && string.equals(node.getUserData())) {
                Matrix4f matrix4f = new Matrix4f();
                matrix4f.setRow(0, fArray[0]);
                matrix4f.setRow(1, fArray[1]);
                matrix4f.setRow(2, fArray[2]);
                matrix4f.setRow(3, new float[]{0.0f, 0.0f, 0.0f, 1.0f});
                ((TransformGroup)node).setTransform(new Transform3D(matrix4f));
            } else {
                Enumeration enumeration = ((Group)node).getAllChildren();
                while (enumeration.hasMoreElements()) {
                    this.updateTransformation((Node)enumeration.nextElement(), string, fArray);
                }
            }
        }
    }

    private boolean intersectsDeformedNode(Node node, Bounds bounds, String string) {
        if (node instanceof Group) {
            if (node instanceof TransformGroup && string.equals(node.getUserData()) && ModelManager.getInstance().getBounds(node).intersect(bounds)) {
                return true;
            }
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                if (!this.intersectsDeformedNode((Node)enumeration.nextElement(), bounds, string)) continue;
                return true;
            }
        }
        return false;
    }

    private Transform3D getDeformation(Node node, Transform3D transform3D, String string) {
        if (node instanceof Group) {
            Enumeration enumeration;
            if (node instanceof TransformGroup) {
                transform3D = new Transform3D(transform3D);
                enumeration = new Transform3D();
                ((TransformGroup)node).getTransform((Transform3D)enumeration);
                transform3D.mul((Transform3D)enumeration);
                if (string.equals(node.getUserData())) {
                    return transform3D;
                }
            }
            enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                Transform3D transform3D2 = this.getDeformation((Node)enumeration.nextElement(), transform3D, string);
                if (transform3D2 == null) continue;
                return transform3D2;
            }
        }
        return null;
    }

    public void render(BufferedImage bufferedImage, Camera camera, ImageObserver imageObserver) {
        try {
            this.render(bufferedImage, camera, null, imageObserver);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void render(BufferedImage bufferedImage, Camera camera, List<? extends Selectable> list, ImageObserver imageObserver) throws IOException {
        int n;
        Object object;
        Matrix4 matrix4;
        this.renderingThread = Thread.currentThread();
        if (list != null) {
            boolean bl = this.isSilkShaderUsed(this.quality);
            for (Selectable selectable2 : list) {
                matrix4 = this.homeItemsNames.get(selectable2);
                if (matrix4 != null) {
                    object = matrix4;
                    n = ((String[])object).length;
                    for (int i = 0; i < n; ++i) {
                        Node node = object[i];
                        this.sunflow.remove((String)node);
                    }
                }
                if ((object = (Matrix4)this.object3dFactory.createObject3D(this.home, selectable2, true)) == null) continue;
                matrix4 = this.exportNode((Node)object, selectable2 instanceof Wall || selectable2 instanceof Room, bl);
                this.homeItemsNames.put(selectable2, (String[])matrix4);
            }
        }
        if (this.sunSkyLightName != null) {
            this.sunflow.remove(this.sunSkyLightName);
            this.sunSkyLightName = null;
        }
        if (this.sunLightName != null) {
            this.sunflow.remove(this.sunLightName);
            this.sunLightName = null;
        }
        String string = this.getRenderingParameterValue("globalIllumination");
        Object object2 = this.getSunDirection(this.compass, Camera.convertTimeToTimeZone(camera.getTime(), this.compass.getTimeZone()));
        if (object2[1] > -0.075f) {
            if (this.useSunSky) {
                this.sunflow.parameter("up", new Vector3(0.0f, 1.0f, 0.0f));
                this.sunflow.parameter("east", new Vector3((float)Math.sin(this.compass.getNorthDirection()), 0.0f, (float)Math.cos(this.compass.getNorthDirection())));
                this.sunflow.parameter("sundir", new Vector3((float)object2[0], (float)object2[1], (float)object2[2]));
                this.sunflow.parameter("turbidity", 6.0f);
                this.sunflow.parameter("samples", this.useSunskyLight ? 12 : 0);
                this.sunSkyLightName = UUID.randomUUID().toString();
                this.sunflow.light(this.sunSkyLightName, "sunsky");
            }
            SunSkyLight sunSkyLight = new SunSkyLight();
            matrix4 = new ParameterList();
            matrix4.addVectors("up", ParameterList.InterpolationType.NONE, new float[]{0.0f, 1.0f, 0.0f});
            matrix4.addVectors("east", ParameterList.InterpolationType.NONE, new float[]{(float)Math.sin(this.compass.getNorthDirection()), 0.0f, (float)Math.cos(this.compass.getNorthDirection())});
            matrix4.addVectors("sundir", ParameterList.InterpolationType.NONE, new float[]{(float)object2[0], (float)object2[1], (float)object2[2]});
            sunSkyLight.update((ParameterList)matrix4, this.sunflow);
            object = sunSkyLight.getSunColor().getRGB();
            n = this.useSunskyLight ? 10 : 40;
            this.sunflow.parameter("radiance", null, new float[]{(float)((this.homeLightColor >> 16) * n) * (float)Math.sqrt((double)object[0]), (float)((this.homeLightColor >> 8 & 0xFF) * n) * (float)Math.sqrt((double)object[1]), (float)((this.homeLightColor & 0xFF) * n) * (float)Math.sqrt((double)object[2])});
            this.sunflow.parameter("center", new Point3(1000000.0f * object2[0], 1000000.0f * object2[1], 1000000.0f * object2[2]));
            this.sunflow.parameter("radius", 10000.0f);
            this.sunflow.parameter("samples", 4);
            this.sunLightName = UUID.randomUUID().toString();
            this.sunflow.light(this.sunLightName, "sphere");
            if (!this.useSunskyLight && "default".equals(string)) {
                this.sunflow.parameter("gi.engine", "ambocc");
                this.sunflow.parameter("gi.ambocc.bright", null, new float[]{1.0f, 1.0f, 1.0f});
                this.sunflow.parameter("gi.ambocc.dark", null, new float[]{(float)((object[1] + object[2]) / 200.0f), (float)((object[0] + object[2]) / 200.0f), (float)((object[0] + object[1]) / 200.0f)});
                this.sunflow.parameter("gi.ambocc.samples", 1);
                this.sunflow.options("::options");
            }
        }
        if ("path".equals(string)) {
            this.sunflow.parameter("gi.engine", "path");
            this.sunflow.parameter("gi.path.samples", 64);
            this.sunflow.options("::options");
        }
        switch (camera.getLens()) {
            case SPHERICAL: {
                this.sunflow.camera("camera", "spherical");
                break;
            }
            case FISHEYE: {
                this.sunflow.camera("camera", "fisheye");
                break;
            }
            case NORMAL: {
                this.sunflow.parameter("focus.distance", new Float(this.getRenderingParameterValue("normalLens.focusDistance")).floatValue());
                this.sunflow.parameter("lens.radius", new Float(this.getRenderingParameterValue("normalLens.radius")).floatValue());
                this.sunflow.camera("camera", "thinlens");
                break;
            }
            default: {
                this.sunflow.camera("camera", "pinhole");
            }
        }
        Point3 point3 = new Point3(camera.getX(), camera.getZ(), camera.getY());
        float f = camera.getYaw();
        float f2 = camera.getLens() == Camera.Lens.SPHERICAL ? 0.0f : camera.getPitch();
        double d = Math.cos(f2);
        if (Math.abs(d) > 1.0E-6) {
            Point3 point32 = new Point3(camera.getX() - (float)(Math.sin(f) * d), camera.getZ() - (float)Math.sin(f2), camera.getY() + (float)(Math.cos(f) * d));
            Vector3 vector3 = new Vector3(0.0f, 1.0f, 0.0f);
            matrix4 = Matrix4.lookAt((Point3)point3, (Point3)point32, (Vector3)vector3);
        } else {
            matrix4 = new Matrix4((float)(-Math.cos(f)), (float)(-Math.sin(f)), 0.0f, camera.getX(), 0.0f, 0.0f, (float)Math.signum(Math.sin(f2)), camera.getZ(), (float)(-Math.sin(f)), (float)Math.cos(f), 0.0f, camera.getY());
        }
        this.sunflow.parameter("transform", matrix4);
        this.sunflow.parameter("fov", (float)Math.toDegrees(camera.getFieldOfView()));
        this.sunflow.parameter("aspect", (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight());
        this.sunflow.camera("camera", null);
        this.sunflow.parameter("resolutionX", bufferedImage.getWidth());
        this.sunflow.parameter("resolutionY", bufferedImage.getHeight());
        int n2 = Integer.parseInt(this.getRenderingParameterValue("antiAliasing.min"));
        int n3 = Integer.parseInt(this.getRenderingParameterValue("antiAliasing.max"));
        String string2 = this.getRenderingParameterValue("filter");
        this.sunflow.parameter("filter", string2);
        this.sunflow.parameter("aa.min", n2);
        this.sunflow.parameter("aa.max", n3);
        String string3 = this.getRenderingParameterValue("samplerAlgorithm");
        this.sunflow.parameter("sampler", string3);
        this.sunflow.parameter("camera", "camera");
        this.sunflow.options("::options");
        this.sunflow.render("::options", (Display)new BufferedImageDisplay(bufferedImage, imageObserver));
    }

    public void stop() {
        if (this.renderingThread != null) {
            if (!this.renderingThread.isInterrupted()) {
                this.renderingThread.interrupt();
            }
            this.renderingThread = null;
        }
    }

    public void dispose() {
        for (String string : this.textureImagesCache.values()) {
            new File(string).delete();
        }
        this.textureImagesCache.clear();
    }

    private String getRenderingParameterValue(String string) {
        String string2 = this.quality.name().toLowerCase(Locale.ENGLISH) + "Quality." + string;
        String string3 = PhotoRenderer.class.getName();
        String string4 = System.getProperty(string3 + '.' + string2);
        if (string4 != null) {
            return string4;
        }
        return ResourceBundle.getBundle(string3).getString(string2);
    }

    private float[] getSunDirection(Compass compass, long l) {
        float f = compass.getSunElevation(l);
        float f2 = compass.getSunAzimuth(l);
        f2 = (float)((double)f2 + ((double)compass.getNorthDirection() - 1.5707963267948966));
        return new float[]{(float)(Math.cos(f2) * Math.cos(f)), (float)Math.sin(f), (float)(Math.sin(f2) * Math.cos(f))};
    }

    private boolean isSilkShaderUsed(Quality quality) {
        boolean bl = !this.useSunskyLight && quality == Quality.HIGH;
        String string = this.getRenderingParameterValue("shininessShader");
        if ("glossy".equals(string)) {
            bl = false;
        } else if ("silk".equals(string)) {
            bl = true;
        }
        return bl;
    }

    private String[] exportNode(Node node, boolean bl, boolean bl2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.exportNode(node, bl, bl2, arrayList, new Transform3D());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void exportNode(Node node, boolean bl, boolean bl2, List<String> list, Transform3D transform3D) throws IOException {
        block10: {
            TransparencyAttributes transparencyAttributes;
            block11: {
                block9: {
                    Enumeration enumeration;
                    if (!(node instanceof Group)) break block9;
                    if (node instanceof TransformGroup) {
                        transform3D = new Transform3D(transform3D);
                        enumeration = new Transform3D();
                        ((TransformGroup)node).getTransform((Transform3D)enumeration);
                        transform3D.mul((Transform3D)enumeration);
                    }
                    enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        this.exportNode((Node)enumeration.nextElement(), bl, bl2, list, transform3D);
                    }
                    break block10;
                }
                if (!(node instanceof Link)) break block11;
                this.exportNode((Node)((Link)node).getSharedGroup(), bl, bl2, list, transform3D);
                break block10;
            }
            if (!(node instanceof Shape3D)) break block10;
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            RenderingAttributes renderingAttributes = appearance != null ? appearance.getRenderingAttributes() : null;
            TransparencyAttributes transparencyAttributes2 = transparencyAttributes = appearance != null ? appearance.getTransparencyAttributes() : null;
            if (!(renderingAttributes != null && !renderingAttributes.getVisible() || transparencyAttributes != null && transparencyAttributes.getTransparency() == 1.0f)) {
                String string = (String)shape3D.getUserData();
                String string2 = UUID.randomUUID().toString();
                String string3 = null;
                TexCoordGeneration texCoordGeneration = null;
                Transform3D transform3D2 = new Transform3D();
                int n = 1;
                boolean bl3 = false;
                if (appearance != null) {
                    PolygonAttributes polygonAttributes = appearance.getPolygonAttributes();
                    if (polygonAttributes != null) {
                        n = polygonAttributes.getCullFace();
                        bl3 = polygonAttributes.getBackFaceNormalFlip();
                    }
                    texCoordGeneration = appearance.getTexCoordGeneration();
                    TextureAttributes textureAttributes = appearance.getTextureAttributes();
                    if (textureAttributes != null) {
                        textureAttributes.getTextureTransform(transform3D2);
                    }
                    string3 = "shader" + string2;
                    boolean bl4 = string != null && string.startsWith("sweethome3d_window_mirror");
                    this.exportAppearance(appearance, string3, bl4, bl, bl2);
                    list.add(string3);
                }
                int n2 = shape3D.numGeometries();
                for (int i = 0; i < n2; ++i) {
                    String string4 = "object" + string2 + "-" + i;
                    String[] stringArray = this.exportNodeGeometry(shape3D.getGeometry(i), transform3D, texCoordGeneration, transform3D2, n, bl3, string4);
                    if (stringArray == null) continue;
                    for (String string5 : stringArray) {
                        if (string3 != null) {
                            this.sunflow.parameter("shaders", new String[]{string3});
                        }
                        String string6 = string5 + ".instance";
                        this.sunflow.instance(string6, string5);
                        list.add(string6);
                        list.add(string5);
                    }
                }
            }
        }
    }

    private String[] exportNodeGeometry(Geometry geometry, Transform3D transform3D, TexCoordGeneration texCoordGeneration, Transform3D transform3D2, int n, boolean bl, String string) {
        if (geometry instanceof GeometryArray) {
            IndexedTriangleStripArray indexedTriangleStripArray;
            GeometryArray geometryArray = (GeometryArray)geometry;
            int[] nArray = null;
            int[] nArray2 = null;
            if (geometryArray instanceof IndexedGeometryArray) {
                if (geometryArray instanceof IndexedLineArray) {
                    nArray = new int[((IndexedGeometryArray)geometryArray).getIndexCount()];
                } else if (geometryArray instanceof IndexedTriangleArray) {
                    nArray = new int[((IndexedGeometryArray)geometryArray).getIndexCount()];
                } else if (geometryArray instanceof IndexedQuadArray) {
                    nArray = new int[((IndexedQuadArray)geometryArray).getIndexCount() * 3 / 2];
                } else if (geometryArray instanceof IndexedGeometryStripArray) {
                    indexedTriangleStripArray = (IndexedTriangleStripArray)geometryArray;
                    nArray2 = new int[indexedTriangleStripArray.getNumStrips()];
                    indexedTriangleStripArray.getStripIndexCounts(nArray2);
                    nArray = geometryArray instanceof IndexedLineStripArray ? new int[this.getLineCount(nArray2) * 2] : new int[this.getTriangleCount(nArray2) * 3];
                }
            } else if (geometryArray instanceof LineArray) {
                nArray = new int[geometryArray.getVertexCount()];
            } else if (geometryArray instanceof TriangleArray) {
                nArray = new int[geometryArray.getVertexCount()];
            } else if (geometryArray instanceof QuadArray) {
                nArray = new int[((QuadArray)geometryArray).getVertexCount() * 3 / 2];
            } else if (geometryArray instanceof GeometryStripArray) {
                indexedTriangleStripArray = (GeometryStripArray)geometryArray;
                nArray2 = new int[indexedTriangleStripArray.getNumStrips()];
                indexedTriangleStripArray.getStripVertexCounts(nArray2);
                nArray = geometryArray instanceof LineStripArray ? new int[this.getLineCount(nArray2) * 2] : new int[this.getTriangleCount(nArray2) * 3];
            }
            if (nArray != null) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                boolean bl2 = geometryArray instanceof IndexedLineArray || geometryArray instanceof IndexedLineStripArray || geometryArray instanceof LineArray || geometryArray instanceof LineStripArray;
                float[] fArray = new float[geometryArray.getVertexCount() * 3];
                float[] fArray2 = !bl2 && (geometryArray.getVertexFormat() & 2) != 0 ? new float[geometryArray.getVertexCount() * 3] : null;
                HashSet<Triangle> hashSet = bl2 ? null : new HashSet<Triangle>(geometryArray.getVertexCount());
                boolean bl3 = false;
                Vector4f vector4f = null;
                Vector4f vector4f2 = null;
                if (!bl2 && texCoordGeneration != null) {
                    boolean bl4 = bl3 = texCoordGeneration.getGenMode() == 0 && texCoordGeneration.getEnable();
                    if (bl3) {
                        vector4f = new Vector4f();
                        vector4f2 = new Vector4f();
                        texCoordGeneration.getPlaneS(vector4f);
                        texCoordGeneration.getPlaneT(vector4f2);
                    }
                }
                Object object = bl3 || (geometryArray.getVertexFormat() & 0x20) != 0 ? new float[geometryArray.getVertexCount() * 2] : null;
                if ((geometryArray.getVertexFormat() & 0x80) != 0) {
                    Point3f point3f;
                    if ((geometryArray.getVertexFormat() & 0x100) != 0) {
                        float[] fArray3 = geometryArray.getInterleavedVertices();
                        n6 = fArray3.length / geometryArray.getVertexCount();
                        n5 = 0;
                        n4 = n6 - 3;
                        n3 = geometryArray.getVertexCount();
                        while (n5 < n3) {
                            point3f = new Point3f(fArray3[n4], fArray3[n4 + 1], fArray3[n4 + 2]);
                            this.exportVertex(transform3D, point3f, n5, fArray);
                            ++n5;
                            n4 += n6;
                        }
                        if (fArray2 != null) {
                            n5 = 0;
                            n4 = n6 - 6;
                            n3 = geometryArray.getVertexCount();
                            while (n5 < n3) {
                                point3f = new Vector3f(fArray3[n4], fArray3[n4 + 1], fArray3[n4 + 2]);
                                this.exportNormal(transform3D, (Vector3f)point3f, n5, fArray2, bl);
                                ++n5;
                                n4 += n6;
                            }
                        }
                        if (texCoordGeneration != null) {
                            if (bl3) {
                                n5 = 0;
                                n4 = n6 - 3;
                                n3 = geometryArray.getVertexCount();
                                while (n5 < n3) {
                                    point3f = this.generateTextureCoordinates(fArray3[n4], fArray3[n4 + 1], fArray3[n4 + 2], vector4f, vector4f2);
                                    this.exportTextureCoordinates((TexCoord2f)point3f, transform3D2, n5, (float[])object);
                                    ++n5;
                                    n4 += n6;
                                }
                            }
                        } else if (object != null) {
                            n5 = 0;
                            n4 = 0;
                            n3 = geometryArray.getVertexCount();
                            while (n5 < n3) {
                                point3f = new TexCoord2f(fArray3[n4], fArray3[n4 + 1]);
                                this.exportTextureCoordinates((TexCoord2f)point3f, transform3D2, n5, (float[])object);
                                ++n5;
                                n4 += n6;
                            }
                        }
                    } else {
                        float[] fArray4 = geometryArray.getCoordRefFloat();
                        int n7 = 0;
                        int n8 = 0;
                        int n9 = geometryArray.getVertexCount();
                        while (n7 < n9) {
                            Point3f point3f2 = new Point3f(fArray4[n8], fArray4[n8 + 1], fArray4[n8 + 2]);
                            this.exportVertex(transform3D, point3f2, n7, fArray);
                            ++n7;
                            n8 += 3;
                        }
                        if (fArray2 != null) {
                            float[] fArray5 = geometryArray.getNormalRefFloat();
                            n8 = 0;
                            n9 = 0;
                            int n10 = geometryArray.getVertexCount();
                            while (n8 < n10) {
                                point3f = new Vector3f(fArray5[n9], fArray5[n9 + 1], fArray5[n9 + 2]);
                                this.exportNormal(transform3D, (Vector3f)point3f, n8, fArray2, bl);
                                ++n8;
                                n9 += 3;
                            }
                        }
                        if (texCoordGeneration != null) {
                            if (bl3) {
                                int n11 = 0;
                                n8 = 0;
                                n9 = geometryArray.getVertexCount();
                                while (n11 < n9) {
                                    TexCoord2f texCoord2f = this.generateTextureCoordinates(fArray4[n8], fArray4[n8 + 1], fArray4[n8 + 2], vector4f, vector4f2);
                                    this.exportTextureCoordinates(texCoord2f, transform3D2, n11, (float[])object);
                                    ++n11;
                                    n8 += 3;
                                }
                            }
                        } else if (object != null) {
                            float[] fArray6 = geometryArray.getTexCoordRefFloat(0);
                            n8 = 0;
                            n9 = 0;
                            int n12 = geometryArray.getVertexCount();
                            while (n8 < n12) {
                                point3f = new TexCoord2f(fArray6[n9], fArray6[n9 + 1]);
                                this.exportTextureCoordinates((TexCoord2f)point3f, transform3D2, n8, (float[])object);
                                ++n8;
                                n9 += 2;
                            }
                        }
                    }
                } else {
                    Point3f point3f;
                    int n13;
                    int n14 = geometryArray.getVertexCount();
                    for (n13 = 0; n13 < n14; ++n13) {
                        point3f = new Point3f();
                        geometryArray.getCoordinate(n13, point3f);
                        this.exportVertex(transform3D, point3f, n13, fArray);
                    }
                    if (fArray2 != null) {
                        n14 = geometryArray.getVertexCount();
                        for (n13 = 0; n13 < n14; ++n13) {
                            point3f = new Vector3f();
                            geometryArray.getNormal(n13, (Vector3f)point3f);
                            this.exportNormal(transform3D, (Vector3f)point3f, n13, fArray2, bl);
                        }
                    }
                    if (texCoordGeneration != null) {
                        if (bl3) {
                            n14 = geometryArray.getVertexCount();
                            for (n13 = 0; n13 < n14; ++n13) {
                                point3f = new Point3f();
                                geometryArray.getCoordinate(n13, point3f);
                                TexCoord2f texCoord2f = this.generateTextureCoordinates(point3f.x, point3f.y, point3f.z, vector4f, vector4f2);
                                this.exportTextureCoordinates(texCoord2f, transform3D2, n13, (float[])object);
                            }
                        }
                    } else if (object != null) {
                        n14 = geometryArray.getVertexCount();
                        for (n13 = 0; n13 < n14; ++n13) {
                            point3f = new TexCoord2f();
                            geometryArray.getTextureCoordinate(0, n13, (TexCoord2f)point3f);
                            this.exportTextureCoordinates((TexCoord2f)point3f, transform3D2, n13, (float[])object);
                        }
                    }
                }
                if (geometryArray instanceof IndexedGeometryArray) {
                    int n15;
                    int n16;
                    int[] nArray3;
                    int[] nArray4 = fArray2 != null ? new int[nArray.length] : null;
                    int[] nArray5 = nArray3 = object != null ? new int[nArray.length] : null;
                    if (geometryArray instanceof IndexedLineArray) {
                        IndexedLineArray indexedLineArray = (IndexedLineArray)geometryArray;
                        n3 = indexedLineArray.getIndexCount();
                        for (n4 = 0; n4 < n3; n4 += 2) {
                            this.exportIndexedLine((IndexedGeometryArray)indexedLineArray, n4, n4 + 1, nArray, n4);
                        }
                    } else if (geometryArray instanceof IndexedTriangleArray) {
                        IndexedTriangleArray indexedTriangleArray = (IndexedTriangleArray)geometryArray;
                        n3 = indexedTriangleArray.getIndexCount();
                        int n17 = 0;
                        for (n4 = 0; n4 < n3; n4 += 3) {
                            n17 = this.exportIndexedTriangle((IndexedGeometryArray)indexedTriangleArray, n4, n4 + 1, n4 + 2, nArray, nArray4, nArray3, n17, fArray, hashSet, n);
                        }
                    } else if (geometryArray instanceof IndexedQuadArray) {
                        IndexedQuadArray indexedQuadArray = (IndexedQuadArray)geometryArray;
                        n3 = indexedQuadArray.getIndexCount();
                        int n18 = 0;
                        for (n4 = 0; n4 < n3; n4 += 4) {
                            n18 = this.exportIndexedTriangle((IndexedGeometryArray)indexedQuadArray, n4, n4 + 1, n4 + 2, nArray, nArray4, nArray3, n18, fArray, hashSet, n);
                            n18 = this.exportIndexedTriangle((IndexedGeometryArray)indexedQuadArray, n4, n4 + 2, n4 + 3, nArray, nArray4, nArray3, n18, fArray, hashSet, n);
                        }
                    } else if (geometryArray instanceof IndexedLineStripArray) {
                        IndexedLineStripArray indexedLineStripArray = (IndexedLineStripArray)geometryArray;
                        n4 = 0;
                        n3 = 0;
                        for (int i = 0; i < nArray2.length; ++i) {
                            n2 = n4;
                            n16 = n4 + nArray2[i] - 1;
                            while (n2 < n16) {
                                this.exportIndexedLine((IndexedGeometryArray)indexedLineStripArray, n2, n2 + 1, nArray, n3);
                                ++n2;
                                n3 += 2;
                            }
                            n4 += nArray2[i];
                        }
                    } else if (geometryArray instanceof IndexedTriangleStripArray) {
                        IndexedTriangleStripArray indexedTriangleStripArray2 = (IndexedTriangleStripArray)geometryArray;
                        n4 = 0;
                        n3 = 0;
                        for (int i = 0; i < nArray2.length; ++i) {
                            n2 = n4;
                            n16 = n4 + nArray2[i] - 2;
                            n15 = 0;
                            while (n2 < n16) {
                                n3 = n15 % 2 == 0 ? this.exportIndexedTriangle((IndexedGeometryArray)indexedTriangleStripArray2, n2, n2 + 1, n2 + 2, nArray, nArray4, nArray3, n3, fArray, hashSet, n) : this.exportIndexedTriangle((IndexedGeometryArray)indexedTriangleStripArray2, n2, n2 + 2, n2 + 1, nArray, nArray4, nArray3, n3, fArray, hashSet, n);
                                ++n2;
                                ++n15;
                            }
                            n4 += nArray2[i];
                        }
                    } else if (geometryArray instanceof IndexedTriangleFanArray) {
                        IndexedTriangleFanArray indexedTriangleFanArray = (IndexedTriangleFanArray)geometryArray;
                        n4 = 0;
                        n3 = 0;
                        for (int i = 0; i < nArray2.length; ++i) {
                            n16 = n4 + nArray2[i] - 2;
                            for (n2 = n4; n2 < n16; ++n2) {
                                n3 = this.exportIndexedTriangle((IndexedGeometryArray)indexedTriangleFanArray, n4, n2 + 1, n2 + 2, nArray, nArray4, nArray3, n3, fArray, hashSet, n);
                            }
                            n4 += nArray2[i];
                        }
                    }
                    if (nArray4 != null && !Arrays.equals(nArray, nArray4) || nArray3 != null && !Arrays.equals(nArray, nArray3)) {
                        float[] fArray7 = new float[nArray.length * 3];
                        float[] fArray8 = nArray4 != null ? new float[nArray.length * 3] : null;
                        float[] fArray9 = nArray3 != null ? new float[nArray.length * 2] : null;
                        int n19 = 0;
                        n2 = 0;
                        n16 = 0;
                        for (n15 = 0; n15 < nArray.length; ++n15) {
                            int n20 = nArray[n15] * 3;
                            fArray7[n19++] = fArray[n20++];
                            fArray7[n19++] = fArray[n20++];
                            fArray7[n19++] = fArray[n20++];
                            if (nArray4 != null) {
                                n20 = nArray4[n15] * 3;
                                fArray8[n2++] = fArray2[n20++];
                                fArray8[n2++] = fArray2[n20++];
                                fArray8[n2++] = fArray2[n20++];
                            }
                            if (nArray3 != null) {
                                n20 = nArray3[n15] * 2;
                                fArray9[n16++] = object[n20++];
                                fArray9[n16++] = object[n20++];
                            }
                            nArray[n15] = n15;
                        }
                        fArray = fArray7;
                        fArray2 = fArray8;
                        object = fArray9;
                    }
                } else if (geometryArray instanceof LineArray) {
                    LineArray lineArray = (LineArray)geometryArray;
                    n5 = lineArray.getVertexCount();
                    for (n6 = 0; n6 < n5; n6 += 2) {
                        this.exportLine((GeometryArray)lineArray, n6, n6 + 1, nArray, n6);
                    }
                } else if (geometryArray instanceof TriangleArray) {
                    TriangleArray triangleArray = (TriangleArray)geometryArray;
                    n5 = triangleArray.getVertexCount();
                    n4 = 0;
                    for (n6 = 0; n6 < n5; n6 += 3) {
                        n4 = this.exportTriangle((GeometryArray)triangleArray, n6, n6 + 1, n6 + 2, nArray, n4, fArray, hashSet, n);
                    }
                } else if (geometryArray instanceof QuadArray) {
                    QuadArray quadArray = (QuadArray)geometryArray;
                    n5 = quadArray.getVertexCount();
                    n4 = 0;
                    for (n6 = 0; n6 < n5; n6 += 4) {
                        n4 = this.exportTriangle((GeometryArray)quadArray, n6, n6 + 1, n6 + 2, nArray, n4, fArray, hashSet, n);
                        n4 = this.exportTriangle((GeometryArray)quadArray, n6 + 2, n6 + 3, n6, nArray, n4, fArray, hashSet, n);
                    }
                } else if (geometryArray instanceof LineStripArray) {
                    LineStripArray lineStripArray = (LineStripArray)geometryArray;
                    n6 = 0;
                    n5 = 0;
                    for (n4 = 0; n4 < nArray2.length; ++n4) {
                        n3 = n6;
                        int n21 = n6 + nArray2[n4] - 1;
                        while (n3 < n21) {
                            this.exportLine((GeometryArray)lineStripArray, n3, n3 + 1, nArray, n5);
                            ++n3;
                            n5 += 2;
                        }
                        n6 += nArray2[n4];
                    }
                } else if (geometryArray instanceof TriangleStripArray) {
                    TriangleStripArray triangleStripArray = (TriangleStripArray)geometryArray;
                    n6 = 0;
                    n5 = 0;
                    for (n4 = 0; n4 < nArray2.length; ++n4) {
                        n3 = n6;
                        int n22 = n6 + nArray2[n4] - 2;
                        n2 = 0;
                        while (n3 < n22) {
                            n5 = n2 % 2 == 0 ? this.exportTriangle((GeometryArray)triangleStripArray, n3, n3 + 1, n3 + 2, nArray, n5, fArray, hashSet, n) : this.exportTriangle((GeometryArray)triangleStripArray, n3, n3 + 2, n3 + 1, nArray, n5, fArray, hashSet, n);
                            ++n3;
                            ++n2;
                        }
                        n6 += nArray2[n4];
                    }
                } else if (geometryArray instanceof TriangleFanArray) {
                    TriangleFanArray triangleFanArray = (TriangleFanArray)geometryArray;
                    n6 = 0;
                    n5 = 0;
                    for (n4 = 0; n4 < nArray2.length; ++n4) {
                        int n23 = n6 + nArray2[n4] - 2;
                        for (n3 = n6; n3 < n23; ++n3) {
                            n5 = this.exportTriangle((GeometryArray)triangleFanArray, n6, n3 + 1, n3 + 2, nArray, n5, fArray, hashSet, n);
                        }
                        n6 += nArray2[n4];
                    }
                }
                if (bl2) {
                    String[] stringArray = new String[nArray.length / 2];
                    for (int i = 0; i < nArray.length; i += 2) {
                        String string2;
                        stringArray[i / 2] = string2 = string + "-" + i;
                        float[] fArray10 = new float[6];
                        int n24 = 0;
                        for (int j = i; j <= i + 1; ++j) {
                            n2 = nArray[j] * 3;
                            fArray10[n24++] = fArray[n2++];
                            fArray10[n24++] = fArray[n2++];
                            fArray10[n24++] = fArray[n2];
                        }
                        this.sunflow.parameter("segments", 1);
                        this.sunflow.parameter("widths", 0.15f);
                        this.sunflow.parameter("points", "point", "vertex", fArray10);
                        this.sunflow.geometry(string2, "hair");
                    }
                    return stringArray;
                }
                int n25 = hashSet.size() * 3;
                if (n25 < nArray.length) {
                    int[] nArray6 = new int[n25];
                    System.arraycopy(nArray, 0, nArray6, 0, nArray6.length);
                    nArray = nArray6;
                }
                this.sunflow.parameter("triangles", nArray);
                this.sunflow.parameter("points", "point", "vertex", fArray);
                if (fArray2 != null) {
                    boolean bl5 = true;
                    for (float f : fArray2) {
                        if (!Float.isNaN(f)) continue;
                        bl5 = false;
                        break;
                    }
                    if (bl5) {
                        this.sunflow.parameter("normals", "vector", "vertex", fArray2);
                    }
                }
                if (object != null) {
                    boolean bl6 = true;
                    for (float f : object) {
                        if (!((double)Math.abs(f) > 1.0E9)) continue;
                        bl6 = false;
                        break;
                    }
                    if (bl6) {
                        this.sunflow.parameter("uvs", "texcoord", "vertex", object);
                    }
                }
                this.sunflow.geometry(string, "triangle_mesh");
                return new String[]{string};
            }
        }
        return null;
    }

    private TexCoord2f generateTextureCoordinates(float f, float f2, float f3, Vector4f vector4f, Vector4f vector4f2) {
        return new TexCoord2f(f * vector4f.x + f2 * vector4f.y + f3 * vector4f.z + vector4f.w, f * vector4f2.x + f2 * vector4f2.y + f3 * vector4f2.z + vector4f2.w);
    }

    private int getLineCount(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] - 1;
        }
        return n;
    }

    private int getTriangleCount(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i] - 2;
        }
        return n;
    }

    private void exportVertex(Transform3D transform3D, Point3f point3f, int n, float[] fArray) {
        transform3D.transform(point3f);
        n *= 3;
        fArray[n++] = point3f.x;
        fArray[n++] = point3f.y;
        fArray[n] = point3f.z;
    }

    private void exportNormal(Transform3D transform3D, Vector3f vector3f, int n, float[] fArray, boolean bl) {
        if (bl) {
            vector3f.negate();
        }
        transform3D.transform(vector3f);
        int n2 = n * 3;
        fArray[n2++] = vector3f.x;
        fArray[n2++] = vector3f.y;
        fArray[n2] = vector3f.z;
    }

    private void exportTextureCoordinates(TexCoord2f texCoord2f, Transform3D transform3D, int n, float[] fArray) {
        n *= 2;
        if (transform3D.getBestType() != 2) {
            Point3f point3f = new Point3f(texCoord2f.x, texCoord2f.y, 0.0f);
            transform3D.transform(point3f);
            fArray[n++] = point3f.x;
            fArray[n] = point3f.y;
        } else {
            fArray[n++] = texCoord2f.x;
            fArray[n] = texCoord2f.y;
        }
    }

    private void exportIndexedLine(IndexedGeometryArray indexedGeometryArray, int n, int n2, int[] nArray, int n3) {
        nArray[n3++] = indexedGeometryArray.getCoordinateIndex(n);
        nArray[n3] = indexedGeometryArray.getCoordinateIndex(n2);
    }

    private int exportIndexedTriangle(IndexedGeometryArray indexedGeometryArray, int n, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, int n4, float[] fArray, Set<Triangle> set, int n5) {
        int n6;
        int n7;
        Triangle triangle;
        int n8;
        if (n5 == 2) {
            n8 = n;
            n = n3;
            n3 = n8;
        }
        if (!set.contains(triangle = new Triangle(fArray, n8 = indexedGeometryArray.getCoordinateIndex(n), n7 = indexedGeometryArray.getCoordinateIndex(n2), n6 = indexedGeometryArray.getCoordinateIndex(n3)))) {
            set.add(triangle);
            nArray[n4] = n8;
            nArray[n4 + 1] = n7;
            nArray[n4 + 2] = n6;
            if (nArray2 != null) {
                nArray2[n4] = indexedGeometryArray.getNormalIndex(n);
                nArray2[n4 + 1] = indexedGeometryArray.getNormalIndex(n2);
                nArray2[n4 + 2] = indexedGeometryArray.getNormalIndex(n3);
            }
            if (nArray3 != null) {
                nArray3[n4] = indexedGeometryArray.getTextureCoordinateIndex(0, n);
                nArray3[n4 + 1] = indexedGeometryArray.getTextureCoordinateIndex(0, n2);
                nArray3[n4 + 2] = indexedGeometryArray.getTextureCoordinateIndex(0, n3);
            }
            return n4 + 3;
        }
        return n4;
    }

    private void exportLine(GeometryArray geometryArray, int n, int n2, int[] nArray, int n3) {
        nArray[n3++] = n;
        nArray[n3] = n2;
    }

    private int exportTriangle(GeometryArray geometryArray, int n, int n2, int n3, int[] nArray, int n4, float[] fArray, Set<Triangle> set, int n5) {
        Triangle triangle;
        if (n5 == 2) {
            int n6 = n;
            n = n3;
            n3 = n6;
        }
        if (!set.contains(triangle = new Triangle(fArray, n, n2, n3))) {
            set.add(triangle);
            nArray[n4++] = n;
            nArray[n4++] = n2;
            nArray[n4++] = n3;
        }
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void exportAppearance(Appearance appearance, String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        Texture texture = appearance.getTexture();
        if (bl) {
            Material material = appearance.getMaterial();
            if (material != null) {
                Color3f color3f = new Color3f();
                material.getDiffuseColor(color3f);
                this.sunflow.parameter("color", null, new float[]{color3f.x, color3f.y, color3f.z});
            }
            this.sunflow.shader(string, "mirror");
            return;
        }
        if (texture != null) {
            Object object;
            Object object2;
            Material material;
            TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
            float f = transparencyAttributes != null && transparencyAttributes.getTransparency() > 0.0f && !bl2 ? 1.0f - transparencyAttributes.getTransparency() : 1.0f;
            TransparentTextureKey transparentTextureKey = new TransparentTextureKey(texture, f);
            String string2 = this.textureImagesCache.get(transparentTextureKey);
            if (string2 == null) {
                if (texture.getUserData() instanceof URL && f == 1.0f) {
                    string2 = texture.getUserData().toString();
                } else {
                    material = (ImageComponent2D)texture.getImage(0);
                    Object object3 = material.getRenderedImage();
                    if (f < 1.0f) {
                        object2 = new BufferedImage(object3.getWidth(), object3.getHeight(), 2);
                        object = (Graphics2D)((BufferedImage)object2).getGraphics();
                        ((Graphics2D)object).setComposite(AlphaComposite.getInstance(3, f));
                        ((Graphics2D)object).drawRenderedImage((RenderedImage)object3, null);
                        ((Graphics)object).dispose();
                        object3 = object2;
                    }
                    object2 = OperatingSystem.createTemporaryFile("texture", ".png");
                    ImageIO.write((RenderedImage)object3, "png", (File)object2);
                    string2 = ((File)object2).getAbsolutePath();
                }
                this.textureImagesCache.put(transparentTextureKey, string2);
            }
            if ((material = appearance.getMaterial()) != null) {
                float f2;
                float f3 = material.getShininess();
                if (f2 > 1.0f) {
                    if (bl3) {
                        this.sunflow.parameter("diffuse.texture", string2);
                        object2 = new Color3f();
                        material.getSpecularColor((Color3f)object2);
                        object = new float[]{(float)Math.sqrt(((Color3f)object2).x) / 2.0f, (float)Math.sqrt(((Color3f)object2).y) / 2.0f, (float)Math.sqrt(((Color3f)object2).z) / 2.0f};
                        this.sunflow.parameter("specular", null, (float[])object);
                        this.sunflow.parameter("glossyness", (float)Math.pow(10.0, -Math.log(f3) / Math.log(5.0)));
                        this.sunflow.parameter("samples", 1);
                        this.sunflow.shader(string, "uber");
                        return;
                    }
                    this.sunflow.parameter("texture", string2);
                    this.sunflow.parameter("shiny", f3 / 512.0f);
                    this.sunflow.shader(string, "textured_shiny_diffuse");
                    return;
                }
            }
            this.sunflow.parameter("texture", string2);
            this.sunflow.shader(string, "textured_diffuse");
            return;
        }
        Material material = appearance.getMaterial();
        if (material == null) {
            ColoringAttributes coloringAttributes = appearance.getColoringAttributes();
            if (coloringAttributes == null) return;
            Color3f color3f = new Color3f();
            coloringAttributes.getColor(color3f);
            this.sunflow.parameter("color", null, new float[]{color3f.x, color3f.y, color3f.z});
            this.sunflow.shader(string, "constant");
            return;
        }
        Color3f color3f = new Color3f();
        material.getDiffuseColor(color3f);
        float[] fArray = new float[]{color3f.x, color3f.y, color3f.z};
        TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
        if (transparencyAttributes != null && transparencyAttributes.getTransparency() > 0.0f && !bl2) {
            float f;
            if (material instanceof OBJMaterial && ((OBJMaterial)material).isOpticalDensitySet()) {
                f = ((OBJMaterial)material).getOpticalDensity();
                this.sunflow.parameter("eta", f <= 1.0f ? 1.55f : f);
            } else {
                this.sunflow.parameter("eta", 1.55f);
            }
            f = 1.0f - transparencyAttributes.getTransparency();
            this.sunflow.parameter("color", null, new float[]{1.0f - f + f * fArray[0], 1.0f - f + f * fArray[1], 1.0f - f + f * fArray[2]});
            this.sunflow.parameter("absorption.color", null, new float[]{f * (1.0f - fArray[0]), f * (1.0f - fArray[1]), f * (1.0f - fArray[2])});
            this.sunflow.shader(string, "glass");
            return;
        }
        if (!material.getLightingEnable()) {
            this.sunflow.parameter("color", null, fArray);
            this.sunflow.shader(string, "constant");
            return;
        }
        this.sunflow.parameter("diffuse", null, fArray);
        float f = material.getShininess();
        if (!(f > 1.0f)) {
            this.sunflow.shader(string, "diffuse");
            return;
        }
        if (bl3) {
            material.getSpecularColor(color3f);
            float[] fArray2 = new float[]{(float)Math.sqrt(color3f.x) / 2.0f, (float)Math.sqrt(color3f.y) / 2.0f, (float)Math.sqrt(color3f.z) / 2.0f};
            this.sunflow.parameter("specular", null, fArray2);
            this.sunflow.parameter("glossyness", (float)Math.pow(10.0, -Math.log(f) / Math.log(5.0)));
            this.sunflow.parameter("samples", 1);
            this.sunflow.shader(string, "uber");
            return;
        }
        this.sunflow.parameter("shiny", f / 512.0f);
        this.sunflow.shader(string, "shiny_diffuse");
    }

    private void exportLightSources(HomeLight homeLight, Transform3D transform3D) {
        for (LightSource lightSource : homeLight.getLightSources()) {
            this.exportLightSource(homeLight, lightSource, transform3D);
        }
    }

    private void exportLightSource(HomeLight homeLight, LightSource lightSource, Transform3D transform3D) {
        float f = homeLight.getPower();
        float f2 = this.getLightSourceRadius(homeLight, lightSource);
        float f3 = 5.0f * f * f / (f2 * f2);
        int n = lightSource.getColor();
        this.sunflow.parameter("radiance", null, new float[]{f3 * (float)(n >> 16) * (float)(this.homeLightColor >> 16), f3 * (float)(n >> 8 & 0xFF) * (float)(this.homeLightColor >> 8 & 0xFF), f3 * (float)(n & 0xFF) * (float)(this.homeLightColor & 0xFF)});
        Point3f point3f = this.getNormalizedLightSourceLocation(lightSource);
        transform3D.transform(point3f);
        this.sunflow.parameter("center", new Point3(point3f.getX(), point3f.getY(), point3f.getZ()));
        this.sunflow.parameter("radius", f2);
        this.sunflow.parameter("samples", 4);
        this.sunflow.light(UUID.randomUUID().toString(), "sphere");
    }

    private float getLightSourceRadius(HomeLight homeLight, LightSource lightSource) {
        return lightSource.getDiameter() != null ? lightSource.getDiameter().floatValue() * homeLight.getWidth() / 2.0f : 3.25f;
    }

    private Point3f getNormalizedLightSourceLocation(LightSource lightSource) {
        return new Point3f(lightSource.getX() - 0.5f, lightSource.getZ() - 0.5f, 0.5f - lightSource.getY());
    }

    static {
        UI.set((UserInterface)new SilentInterface());
        TriangleMesh.setSmallTriangles((boolean)true);
        PluginRegistry.lightSourcePlugins.registerPlugin("sphere", SphereLightWithNoRepresentation.class);
    }

    private static class PhotoObject3DFactory
    extends Object3DBranchFactory {
        private PhotoObject3DFactory() {
        }

        @Override
        public boolean isDrawingModeEnabled() {
            return false;
        }

        @Override
        public Object createObject3D(Home home, Selectable selectable, boolean bl) {
            if (selectable instanceof Room) {
                return new Room3D((Room)selectable, home, !(home.getCamera() instanceof ObserverCamera), bl);
            }
            return super.createObject3D(home, selectable, bl);
        }
    }

    public static enum Quality {
        LOW,
        HIGH;

    }

    private static final class BufferedImageDisplay
    implements Display {
        private static final int BASE_INFO_FLAGS = 7;
        private static final int[] BORDERS = new int[]{Color.RED.toRGB(), Color.GREEN.toRGB(), Color.BLUE.toRGB(), Color.YELLOW.toRGB(), Color.CYAN.toRGB(), Color.MAGENTA.toRGB(), new Color(1.0f, 0.5f, 0.0f).toRGB(), new Color(0.5f, 1.0f, 0.0f).toRGB()};
        private final ImageObserver observer;
        private final BufferedImage image;

        private BufferedImageDisplay(BufferedImage bufferedImage, ImageObserver imageObserver) {
            this.observer = imageObserver;
            this.image = bufferedImage;
        }

        public synchronized void imageBegin(int n, int n2, int n3) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n4 = this.image.getRGB(j, i);
                    this.image.setRGB(j, i, ((n4 & 0xFEFEFEFE) >>> 1) + ((n4 & 0xFCFCFCFC) >>> 2));
                }
            }
            this.notifyObserver(23, 0, 0, n, n2);
        }

        public synchronized void imagePrepare(int n, int n2, int n3, int n4, int n5) {
            int n6 = BORDERS[n5 % BORDERS.length] | 0xFF000000;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    if (j < 2 || j > n3 - 3) {
                        if (5 * i >= n4 && 5 * (n4 - i - 1) >= n4) continue;
                        this.image.setRGB(n + j, n2 + i, n6);
                        continue;
                    }
                    if (i >= 2 && i <= n4 - 3 || 5 * j >= n3 && 5 * (n3 - j - 1) >= n3) continue;
                    this.image.setRGB(n + j, n2 + i, n6);
                }
            }
            this.notifyObserver(15, n, n2, n3, n4);
        }

        public synchronized void imageUpdate(int n, int n2, int n3, int n4, Color[] colorArray, float[] fArray) {
            int n5 = 0;
            for (int i = 0; i < n4; ++i) {
                int n6 = 0;
                while (n6 < n3) {
                    this.image.setRGB(n + n6, n2 + i, colorArray[n5].copy().mul(1.0f / fArray[n5]).toNonLinear().toRGBA(fArray[n5]));
                    ++n6;
                    ++n5;
                }
            }
            this.notifyObserver(15, n, n2, n3, n4);
        }

        public synchronized void imageFill(int n, int n2, int n3, int n4, Color color, float f) {
            int n5 = color.copy().mul(1.0f / f).toNonLinear().toRGBA(f);
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    this.image.setRGB(n + j, n2 + i, n5);
                }
            }
            this.notifyObserver(15, n, n2, n3, n4);
        }

        public void imageEnd() {
            this.notifyObserver(23, 0, 0, this.image.getWidth(), this.image.getHeight());
        }

        private void notifyObserver(final int n, final int n2, final int n3, final int n4, final int n5) {
            if (this.observer != null) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        observer.imageUpdate(image, n, n2, n3, n4, n5);
                    }
                });
            }
        }
    }

    private static class Triangle {
        private float[] point1;
        private float[] point2;
        private float[] point3;
        private int hashCode;
        private boolean hashCodeSet;

        public Triangle(float[] fArray, int n, int n2, int n3) {
            this.point1 = new float[]{fArray[n * 3], fArray[n * 3 + 1], fArray[n * 3 + 2]};
            this.point2 = new float[]{fArray[n2 * 3], fArray[n2 * 3 + 1], fArray[n2 * 3 + 2]};
            this.point3 = new float[]{fArray[n3 * 3], fArray[n3 * 3 + 1], fArray[n3 * 3 + 2]};
        }

        public int hashCode() {
            if (!this.hashCodeSet) {
                this.hashCode = 31 * Arrays.hashCode(this.point1) + 31 * Arrays.hashCode(this.point2) + 31 * Arrays.hashCode(this.point3);
                this.hashCodeSet = true;
            }
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Triangle) {
                Triangle triangle = (Triangle)object;
                return Arrays.equals(this.point1, triangle.point3) && Arrays.equals(this.point2, triangle.point2) && Arrays.equals(this.point3, triangle.point1) || Arrays.equals(this.point1, triangle.point2) && Arrays.equals(this.point2, triangle.point1) && Arrays.equals(this.point3, triangle.point3) || Arrays.equals(this.point1, triangle.point1) && Arrays.equals(this.point2, triangle.point3) && Arrays.equals(this.point3, triangle.point2) || Arrays.equals(this.point1, triangle.point1) && Arrays.equals(this.point2, triangle.point2) && Arrays.equals(this.point3, triangle.point3);
            }
            return false;
        }
    }

    private static class TransparentTextureKey {
        private Texture texture;
        private float transparency;

        public TransparentTextureKey(Texture texture, float f) {
            this.texture = texture;
            this.transparency = f;
        }

        public boolean equals(Object object) {
            return ((TransparentTextureKey)object).texture.equals(this.texture) && ((TransparentTextureKey)object).transparency == this.transparency;
        }

        public int hashCode() {
            return this.texture.hashCode() + Float.floatToIntBits(this.transparency);
        }
    }

    public static class SphereLightWithNoRepresentation
    extends SphereLight {
        public Instance createInstance() {
            return null;
        }
    }
}

