/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.ImageIcon;

public abstract class ImageUtils {
    private static final float SMOOTH_FACTOR = 0.008f;
    private static ConvolveOp CONVOLVER = null;

    static {
        float[] fArray = new float[]{0.0f, 0.008f, 0.0f, 0.008f, 0.968f, 0.008f, 0.0f, 0.008f, 0.0f};
        CONVOLVER = new ConvolveOp(new Kernel(3, 3, fArray));
    }

    public static BufferedImage createScaledImage(Image image, int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        Image image2 = image.getScaledInstance(n, n2, 4);
        Image image3 = new ImageIcon(image2).getImage();
        image3.getWidth(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image2, 0, 0, n, n2, null);
        graphics.dispose();
        image2 = null;
        image3 = null;
        bufferedImage = CONVOLVER.filter(bufferedImage, null);
        return bufferedImage;
    }

    public static Dimension getThumbnailSize(int n, int n2, int n3, int n4) {
        double d;
        if (n3 <= 0 || n4 <= 0) {
            return new Dimension(1, 1);
        }
        double d2 = (double)n3 * 1.0 / (double)n;
        double d3 = (double)n4 * 1.0 / (double)n2;
        double d4 = d = d2 > d3 ? d3 : d2;
        if (d > 1.0) {
            return new Dimension(n, n2);
        }
        int n5 = (int)(d * (double)n);
        int n6 = (int)(d * (double)n2);
        if (n5 <= 0 || n6 <= 0) {
            return new Dimension(1, 1);
        }
        return new Dimension(n5, n6);
    }

    public static BufferedImage rotateImage(Image image, int n, int n2, int n3) {
        boolean bl = n3 % 180 != 0;
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        int n6 = bl ? n5 : n4;
        int n7 = bl ? n4 : n5;
        Dimension dimension = ImageUtils.getThumbnailSize(n6, n7, n, n2);
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
        if (n3 == 0) {
            bufferedImage.getGraphics().drawImage(image, 0, 0, dimension.width, dimension.height, null);
        } else {
            Graphics2D graphics2D = bufferedImage.createGraphics();
            switch (n3) {
                case 90: {
                    graphics2D.rotate(1.5707963267948966, 0.0, 0.0);
                    graphics2D.drawImage(image, 0, -dimension.width, dimension.height, dimension.width, null);
                    break;
                }
                case 180: {
                    graphics2D.rotate(Math.PI, (double)dimension.width / 2.0, (double)dimension.height / 2.0);
                    graphics2D.drawImage(image, 0, 0, dimension.width, dimension.height, null);
                    break;
                }
                case 270: {
                    graphics2D.rotate(4.71238898038469, 0.0, 0.0);
                    graphics2D.drawImage(image, -dimension.height, 0, dimension.height, dimension.width, null);
                }
            }
            graphics2D.dispose();
        }
        return bufferedImage;
    }
}

