/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Localizer;
import org.apache.tomcat.Jar;

public class JavacErrorDetail {
    private final String javaFileName;
    private final int javaLineNum;
    private String jspFileName;
    private int jspBeginLineNum;
    private final StringBuilder errMsg;
    private String jspExtract = null;

    public JavacErrorDetail(String string, int n, StringBuilder stringBuilder) {
        this(string, n, null, -1, stringBuilder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavacErrorDetail(String string, int n, String string2, int n2, StringBuilder stringBuilder, JspCompilationContext jspCompilationContext) {
        this.javaFileName = string;
        this.javaLineNum = n;
        this.errMsg = stringBuilder;
        this.jspFileName = string2;
        if (n2 > 0 && jspCompilationContext != null) {
            InputStream inputStream = null;
            try {
                String[] stringArray;
                Jar jar = jspCompilationContext.getTagFileJar();
                if (jar != null) {
                    stringArray = string2.substring(1);
                    inputStream = jar.getInputStream((String)stringArray);
                    this.jspFileName = jar.getURL((String)stringArray);
                } else {
                    inputStream = jspCompilationContext.getResourceAsStream(string2);
                }
                stringArray = this.readFile(inputStream);
                try (FileInputStream fileInputStream = new FileInputStream(jspCompilationContext.getServletJavaFileName());){
                    int n3;
                    CharSequence charSequence;
                    String[] stringArray2 = this.readFile(fileInputStream);
                    if (stringArray.length < n2) {
                        this.jspExtract = Localizer.getMessage("jsp.error.bug48498");
                        return;
                    }
                    if (stringArray[n2 - 1].lastIndexOf("<%") > stringArray[n2 - 1].lastIndexOf("%>")) {
                        charSequence = stringArray2[n - 1].trim();
                        for (n3 = n2 - 1; n3 < stringArray.length; ++n3) {
                            if (stringArray[n3].indexOf((String)charSequence) == -1) continue;
                            n2 = n3 + 1;
                            break;
                        }
                    }
                    charSequence = new StringBuilder(1024);
                    n3 = Math.max(0, n2 - 1 - 3);
                    int n4 = Math.min(stringArray.length - 1, n2 - 1 + 3);
                    for (int i = n3; i <= n4; ++i) {
                        ((StringBuilder)charSequence).append(i + 1);
                        ((StringBuilder)charSequence).append(": ");
                        ((StringBuilder)charSequence).append(stringArray[i]);
                        ((StringBuilder)charSequence).append(System.lineSeparator());
                    }
                    this.jspExtract = ((StringBuilder)charSequence).toString();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.jspBeginLineNum = n2;
    }

    public String getJavaFileName() {
        return this.javaFileName;
    }

    public int getJavaLineNumber() {
        return this.javaLineNum;
    }

    public String getJspFileName() {
        return this.jspFileName;
    }

    public int getJspBeginLineNumber() {
        return this.jspBeginLineNum;
    }

    public String getErrorMessage() {
        return this.errMsg.toString();
    }

    public String getJspExtract() {
        return this.jspExtract;
    }

    private String[] readFile(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }
}

