/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.track;

import com.google.earth.kml._2.KmlType;
import com.google.earth.kml._2.ObjectFactory;
import com.topografix.gpx._1._0.Gpx;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import org.fibs.geotag.track.KmlTransformer;
import org.fibs.geotag.track.TrackWriter;

public class KmlWriter
implements TrackWriter {
    @Override
    public void write(Gpx gpx, File file) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.write(gpx, fileOutputStream);
        fileOutputStream.close();
    }

    @Override
    public void write(Gpx gpx, OutputStream outputStream) throws Exception {
        KmlType kmlType = new KmlTransformer().transform(gpx);
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBElement<KmlType> kml = objectFactory.createKml(kmlType);
        JAXBContext jaxbContext = JAXBContext.newInstance((String)KmlType.class.getPackage().getName());
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.schemaLocation", (Object)"http://earth.google.com/kml/2.1 http://code.google.com/apis/kml/schema/kml21.xsd");
        marshaller.marshal(kml, outputStream);
        outputStream.close();
    }
}

