/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile.builtin;

import java.util.concurrent.ConcurrentMap;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.RubyWarnings;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.profile.builtin.ProfiledMethod;
import org.jruby.util.collections.NonBlockingHashMapLong;

public class ProfiledMethods {
    private final NonBlockingHashMapLong<ProfiledMethod> methods;
    private final Ruby runtime;

    public ProfiledMethods(Ruby runtime2) {
        if (runtime2 == null) {
            throw new IllegalArgumentException("Given runtime must not be null.");
        }
        this.runtime = runtime2;
        this.methods = new NonBlockingHashMapLong(10000);
    }

    private Ruby getRuntime() {
        return this.runtime;
    }

    private RubyInstanceConfig getConfig() {
        return this.getRuntime().getInstanceConfig();
    }

    private RubyWarnings getWarnings() {
        return this.getRuntime().getWarnings();
    }

    private int getProfileMaxMethods() {
        return this.getConfig().getProfileMaxMethods();
    }

    private ConcurrentMap<Long, ProfiledMethod> getMethods() {
        return this.methods;
    }

    public void addProfiledMethod(String name2, DynamicMethod method2) {
        long serial = method2.getSerialNumber();
        if (this.getMethods().size() >= this.getProfileMaxMethods()) {
            this.getWarnings().warnOnce(IRubyWarnings.ID.PROFILE_MAX_METHODS_EXCEEDED, "method count exceeds max of " + this.getConfig().getProfileMaxMethods() + "; no new methods will be profiled");
            return;
        }
        this.getMethods().putIfAbsent(serial, new ProfiledMethod(name2, method2));
    }

    public ProfiledMethod getProfiledMethod(long serial) {
        return (ProfiledMethod)this.getMethods().get(serial);
    }
}

