/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.diagnostic;

import com.intellij.openapi.util.io.JarUtil;
import java.io.File;
import java.util.jar.Attributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.jetbrains.kotlin.util.slicedMap.Slices;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SearchUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\rJ\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/VersionReader;", "", "()V", "CLASS_SUFFIX", "", "MINIMAL_SUPPORTED_VERSION", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getMINIMAL_SUPPORTED_VERSION", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "REQUIRE_KOTLIN_VERSION", "Ljava/util/jar/Attributes$Name;", "VERSIONS_SLICE", "Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/VersionReader$RuntimeVersions;", "getVersionsForCurrentModule", "module", "getVersionsForCurrentModuleFromTrace", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getVersionsFromManifest", "runtimeLibraryPath", "Ljava/io/File;", "RuntimeVersions", "kotlinx-serialization-compiler-plugin"})
public final class VersionReader {
    private static final ApiVersion MINIMAL_SUPPORTED_VERSION;
    private static final Attributes.Name REQUIRE_KOTLIN_VERSION;
    private static final String CLASS_SUFFIX = "!/kotlinx/serialization/KSerializer.class";
    private static final WritableSlice<ModuleDescriptor, RuntimeVersions> VERSIONS_SLICE;
    @NotNull
    public static final VersionReader INSTANCE;

    @NotNull
    public final RuntimeVersions getVersionsFromManifest(@NotNull File runtimeLibraryPath) {
        ApiVersion apiVersion;
        ApiVersion apiVersion2;
        boolean bl;
        Object object;
        Intrinsics.checkNotNullParameter((Object)runtimeLibraryPath, (String)"runtimeLibraryPath");
        String string = JarUtil.getJarAttribute((File)runtimeLibraryPath, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (string != null) {
            String string2 = string;
            object = ApiVersion.Companion;
            boolean bl2 = false;
            bl = false;
            String p1 = string2;
            boolean bl3 = false;
            apiVersion2 = object.parse(p1);
        } else {
            apiVersion2 = null;
        }
        ApiVersion version = apiVersion2;
        String string3 = JarUtil.getJarAttribute((File)runtimeLibraryPath, (Attributes.Name)REQUIRE_KOTLIN_VERSION);
        if (string3 != null) {
            object = string3;
            ApiVersion.Companion companion = ApiVersion.Companion;
            bl = false;
            boolean bl4 = false;
            Object p1 = object;
            boolean bl5 = false;
            apiVersion = companion.parse((String)p1);
        } else {
            apiVersion = null;
        }
        ApiVersion kotlinVersion = apiVersion;
        return new RuntimeVersions(version, kotlinVersion);
    }

    @NotNull
    public final ApiVersion getMINIMAL_SUPPORTED_VERSION() {
        return MINIMAL_SUPPORTED_VERSION;
    }

    @Nullable
    public final RuntimeVersions getVersionsForCurrentModuleFromTrace(@NotNull ModuleDescriptor module, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        RuntimeVersions runtimeVersions = (RuntimeVersions)trace.get((ReadOnlySlice)VERSIONS_SLICE, (Object)module);
        if (runtimeVersions != null) {
            RuntimeVersions runtimeVersions2 = runtimeVersions;
            boolean bl = false;
            boolean bl2 = false;
            RuntimeVersions it = runtimeVersions2;
            boolean bl3 = false;
            return it;
        }
        RuntimeVersions runtimeVersions3 = this.getVersionsForCurrentModule(module);
        if (runtimeVersions3 == null) {
            return null;
        }
        RuntimeVersions versions = runtimeVersions3;
        trace.record(VERSIONS_SLICE, (Object)module, (Object)versions);
        return versions;
    }

    @Nullable
    public final RuntimeVersions getVersionsForCurrentModule(@NotNull ModuleDescriptor module) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ClassDescriptor markerClass = SearchUtilsKt.getClassFromSerializationPackage(module, "KSerializer");
        SourceElement sourceElement = markerClass.getSource();
        if (!(sourceElement instanceof KotlinJvmBinarySourceElement)) {
            sourceElement = null;
        }
        if ((object = (KotlinJvmBinarySourceElement)sourceElement) == null || (object = object.getBinaryClass()) == null || (object = object.getLocation()) == null) {
            return null;
        }
        Object location = object;
        String jarFile = StringsKt.removeSuffix((String)location, (CharSequence)CLASS_SUFFIX);
        if (!StringsKt.endsWith$default((String)jarFile, (String)".jar", (boolean)false, (int)2, null)) {
            return null;
        }
        File file = new File(jarFile);
        if (!file.exists()) {
            return null;
        }
        return this.getVersionsFromManifest(file);
    }

    private VersionReader() {
    }

    static {
        VersionReader versionReader;
        INSTANCE = versionReader = new VersionReader();
        ApiVersion apiVersion = ApiVersion.Companion.parse("1.0-M1-SNAPSHOT");
        Intrinsics.checkNotNull((Object)apiVersion);
        MINIMAL_SUPPORTED_VERSION = apiVersion;
        REQUIRE_KOTLIN_VERSION = new Attributes.Name("Require-Kotlin-Version");
        WritableSlice writableSlice = Slices.createSimpleSlice();
        Intrinsics.checkNotNullExpressionValue((Object)writableSlice, (String)"Slices.createSimpleSlice()");
        VERSIONS_SLICE = writableSlice;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0006\u0010\f\u001a\u00020\rJ\u0013\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\rJ\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/VersionReader$RuntimeVersions;", "", "implementationVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "requireKotlinVersion", "(Lorg/jetbrains/kotlin/config/ApiVersion;Lorg/jetbrains/kotlin/config/ApiVersion;)V", "getImplementationVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "getRequireKotlinVersion", "component1", "component2", "copy", "currentCompilerMatchRequired", "", "equals", "other", "hashCode", "", "implementationVersionMatchSupported", "toString", "", "kotlinx-serialization-compiler-plugin"})
    public static final class RuntimeVersions {
        private final ApiVersion implementationVersion;
        private final ApiVersion requireKotlinVersion;

        public final boolean currentCompilerMatchRequired() {
            ApiVersion apiVersion;
            boolean bl;
            boolean bl2;
            String string;
            String string2 = KotlinCompilerVersion.getVersion();
            if (string2 != null) {
                string = string2;
                ApiVersion.Companion companion = ApiVersion.Companion;
                bl2 = false;
                bl = false;
                String p1 = string;
                boolean bl3 = false;
                apiVersion = companion.parse(p1);
            } else {
                apiVersion = null;
            }
            string = apiVersion;
            boolean bl4 = false;
            bl2 = false;
            bl2 = false;
            bl = false;
            if (string == null) {
                boolean bl5 = false;
                String string3 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            String current = string;
            return this.requireKotlinVersion == null || this.requireKotlinVersion.compareTo((ApiVersion)current) <= 0;
        }

        public final boolean implementationVersionMatchSupported() {
            return this.implementationVersion != null && this.implementationVersion.compareTo(INSTANCE.getMINIMAL_SUPPORTED_VERSION()) >= 0;
        }

        @Nullable
        public final ApiVersion getImplementationVersion() {
            return this.implementationVersion;
        }

        @Nullable
        public final ApiVersion getRequireKotlinVersion() {
            return this.requireKotlinVersion;
        }

        public RuntimeVersions(@Nullable ApiVersion implementationVersion, @Nullable ApiVersion requireKotlinVersion) {
            this.implementationVersion = implementationVersion;
            this.requireKotlinVersion = requireKotlinVersion;
        }

        @Nullable
        public final ApiVersion component1() {
            return this.implementationVersion;
        }

        @Nullable
        public final ApiVersion component2() {
            return this.requireKotlinVersion;
        }

        @NotNull
        public final RuntimeVersions copy(@Nullable ApiVersion implementationVersion, @Nullable ApiVersion requireKotlinVersion) {
            return new RuntimeVersions(implementationVersion, requireKotlinVersion);
        }

        public static /* synthetic */ RuntimeVersions copy$default(RuntimeVersions runtimeVersions, ApiVersion apiVersion, ApiVersion apiVersion2, int n, Object object) {
            if ((n & 1) != 0) {
                apiVersion = runtimeVersions.implementationVersion;
            }
            if ((n & 2) != 0) {
                apiVersion2 = runtimeVersions.requireKotlinVersion;
            }
            return runtimeVersions.copy(apiVersion, apiVersion2);
        }

        @NotNull
        public String toString() {
            return "RuntimeVersions(implementationVersion=" + this.implementationVersion + ", requireKotlinVersion=" + this.requireKotlinVersion + ")";
        }

        public int hashCode() {
            ApiVersion apiVersion = this.implementationVersion;
            ApiVersion apiVersion2 = this.requireKotlinVersion;
            return (apiVersion != null ? apiVersion.hashCode() : 0) * 31 + (apiVersion2 != null ? apiVersion2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RuntimeVersions)) break block3;
                    RuntimeVersions runtimeVersions = (RuntimeVersions)object;
                    if (!Intrinsics.areEqual((Object)this.implementationVersion, (Object)runtimeVersions.implementationVersion) || !Intrinsics.areEqual((Object)this.requireKotlinVersion, (Object)runtimeVersions.requireKotlinVersion)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

