/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtensionsAreaImpl
implements ExtensionsArea {
    private static final Logger LOG = Logger.getInstance(ExtensionsAreaImpl.class);
    private static final boolean DEBUG_REGISTRATION = Boolean.FALSE;
    private final ComponentManager myComponentManager;
    private final Map<String, ExtensionPointImpl<?>> myExtensionPoints;
    private final Map<String, Throwable> myEPTraces;

    public ExtensionsAreaImpl(@NotNull ComponentManager componentManager) {
        if (componentManager == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(0);
        }
        this.myExtensionPoints = ContainerUtil.newConcurrentMap();
        this.myEPTraces = DEBUG_REGISTRATION ? new THashMap() : null;
        this.myComponentManager = componentManager;
    }

    public final void notifyAreaReplaced(@Nullable ExtensionsAreaImpl newArea) {
        THashSet processedEPs = new THashSet();
        for (ExtensionPointImpl<?> point : this.myExtensionPoints.values()) {
            point.notifyAreaReplaced(this);
            processedEPs.add(point.getName());
        }
        if (newArea == null) {
            return;
        }
        for (ExtensionPointImpl<?> point : newArea.myExtensionPoints.values()) {
            if (processedEPs.contains(point.getName())) continue;
            point.notifyAreaReplaced(this);
        }
    }

    @NotNull
    public static String extractPointName(@NotNull Element extensionElement, @Nullable String ns) {
        String epName;
        if (extensionElement == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(13);
        }
        if ((epName = extensionElement.getAttributeValue("point")) == null) {
            if (ns == null) {
                Namespace namespace = extensionElement.getNamespace();
                epName = namespace.getURI() + '.' + extensionElement.getName();
            } else {
                epName = ns + '.' + extensionElement.getName();
            }
        }
        String string2 = epName;
        if (string2 == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(14);
        }
        return string2;
    }

    @Override
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(15);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(16);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(17);
        }
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, kind);
    }

    void doRegisterExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(22);
        }
        if (extensionPointBeanClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(23);
        }
        if (kind == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(24);
        }
        DefaultPluginDescriptor pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId("FakeIdForTests"));
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, pluginDescriptor, kind == ExtensionPoint.Kind.INTERFACE, false);
    }

    @NotNull
    private <T> ExtensionPointImpl<T> doRegisterExtensionPoint(@NotNull String name, @NotNull String extensionClass, @NotNull PluginDescriptor pluginDescriptor, boolean isInterface, boolean dynamic) {
        if (name == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(28);
        }
        if (extensionClass == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(29);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(30);
        }
        ExtensionPointImpl point = isInterface ? new InterfaceExtensionPoint(name, extensionClass, pluginDescriptor, dynamic) : new BeanExtensionPoint(name, extensionClass, pluginDescriptor, dynamic);
        point.setComponentManager(this.myComponentManager);
        this.registerExtensionPoint(point);
        ExtensionPointImpl extensionPointImpl = point;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(31);
        }
        return extensionPointImpl;
    }

    private void checkThatPointNotDuplicated(@NotNull String pointName, @NotNull PluginDescriptor pluginDescriptor) {
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(34);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(35);
        }
        if (!this.hasExtensionPoint(pointName)) {
            return;
        }
        PluginId id1 = ((ExtensionPointImpl)this.getExtensionPoint(pointName)).getDescriptor().getPluginId();
        PluginId id2 = pluginDescriptor.getPluginId();
        String message2 = "Duplicate registration for EP '" + pointName + "': first in " + id1 + ", second in " + id2;
        if (DEBUG_REGISTRATION) {
            LOG.error(message2, this.myEPTraces.get(pointName));
        }
        throw this.myComponentManager.createError(message2, pluginDescriptor.getPluginId());
    }

    private void registerExtensionPoint(@NotNull ExtensionPointImpl<?> point) {
        if (point == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(36);
        }
        String name = point.getName();
        this.checkThatPointNotDuplicated(name, point.getDescriptor());
        this.myExtensionPoints.put(name, point);
        if (DEBUG_REGISTRATION) {
            this.myEPTraces.put(name, new Throwable("Original registration for " + name));
        }
    }

    @ApiStatus.Internal
    public void registerExtensionPoints(@NotNull List<? extends ExtensionPointImpl<?>> points, boolean clonePoint) {
        if (points == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(37);
        }
        ComponentManager componentManager = this.myComponentManager;
        Map<String, ExtensionPointImpl<?>> map2 = this.myExtensionPoints;
        for (ExtensionPointImpl<?> point : points) {
            ExtensionPointImpl<?> old;
            if (clonePoint) {
                point = point.cloneFor(componentManager);
            } else {
                point.setComponentManager(componentManager);
            }
            if ((old = map2.put(point.getName(), point)) == null) continue;
            map2.put(point.getName(), old);
            throw this.myComponentManager.createError("Duplicate registration for EP '" + point.getName() + "': first in " + old.getDescriptor() + ", second in " + point.getDescriptor(), point.getDescriptor().getPluginId());
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        ExtensionPointImpl<?> extensionPoint;
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(38);
        }
        if ((extensionPoint = this.myExtensionPoints.get(extensionPointName)) == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in container " + this.myComponentManager);
        }
        ExtensionPointImpl<?> extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(39);
        }
        return extensionPointImpl;
    }

    @ApiStatus.Internal
    public boolean registerExtensions(@NotNull String pointName, @NotNull List<? extends Element> extensions, @NotNull IdeaPluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, @Nullable List<Runnable> listenerCallbacks) {
        ExtensionPointImpl<?> point;
        if (pointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(40);
        }
        if (extensions == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(41);
        }
        if (pluginDescriptor == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(42);
        }
        if (componentManager == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(43);
        }
        if ((point = this.myExtensionPoints.get(pointName)) == null) {
            return false;
        }
        point.registerExtensions(extensions, pluginDescriptor, componentManager, listenerCallbacks);
        return true;
    }

    @Override
    @Nullable
    public <T> ExtensionPoint<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(44);
        }
        ExtensionPointImpl<?> extensionPoint = this.myExtensionPoints.get(extensionPointName);
        return extensionPoint;
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(45);
        }
        ExtensionPoint extensionPoint = this.getExtensionPoint(extensionPointName.getName());
        if (extensionPoint == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(46);
        }
        return extensionPoint;
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(50);
        }
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        if (extensionPointName == null) {
            ExtensionsAreaImpl.$$$reportNull$$$0(51);
        }
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    public String toString() {
        return this.myComponentManager.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 14: 
            case 31: 
            case 39: 
            case 46: 
            case 47: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 14: 
            case 31: 
            case 39: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 27: 
            case 30: 
            case 33: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElements";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointElement";
                break;
            }
            case 7: 
            case 14: 
            case 31: 
            case 39: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 15: 
            case 22: 
            case 38: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointBeanClass";
                break;
            }
            case 17: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 25: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "points";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionsAreaImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPointName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPointName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "doRegisterExtensionPoint";
                break;
            }
            case 39: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoint";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoints";
                break;
            }
            case 3: 
            case 4: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointName";
                break;
            }
            case 7: 
            case 14: 
            case 31: 
            case 39: 
            case 46: 
            case 47: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractPointName";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtensionPoint";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerPoint";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "registerFakeBeanPoint";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkThatPointNotDuplicated";
                break;
            }
            case 38: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPoint";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPointIfRegistered";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionByClass";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensionPoint";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "hasExtensionPoint";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 14: 
            case 31: 
            case 39: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

