/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt$sam$org_jetbrains_kotlin_utils_DFS_Neighbors$0;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012\u001a\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0019\u001a\u00020\u0014*\u00020\u0015\u001a\n\u0010\u0019\u001a\u00020\u0014*\u00020\u0012\u001a\n\u0010\u001a\u001a\u00020\u0014*\u00020\u0012\u001a\n\u0010\u001b\u001a\u00020\u0014*\u00020\u0012\u001a\n\u0010\u001c\u001a\u00020\u0014*\u00020\u0012\u001a\n\u0010\u001d\u001a\u00020\u0014*\u00020\u0015\u001a\n\u0010\u001d\u001a\u00020\u0014*\u00020\u0012\u001a\n\u0010\u001e\u001a\u00020\u0014*\u00020\u0015\u001a\n\u0010\u001e\u001a\u00020\u0014*\u00020\u0012\u001a\n\u0010\u001f\u001a\u00020\u0014*\u00020\u0012\u001a\n\u0010 \u001a\u00020\u0014*\u00020\u0012\u001a\n\u0010!\u001a\u00020\u0014*\u00020\u0012\u001a\n\u0010\"\u001a\u00020\u0014*\u00020\u0012\u001a\n\u0010#\u001a\u00020\u0014*\u00020\u0012\u001a!\u0010$\u001a\u00020\u0014*\u00020\u00122\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00140&H\u0082\b\u001a\n\u0010(\u001a\u00020\u0014*\u00020\u0012\u001a\n\u0010)\u001a\u00020\u0014*\u00020\u0012\u001a&\u0010*\u001a\u00020\u0012*\u00020\u00122\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u000f2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u001a\u001e\u0010*\u001a\u00020\u0012*\u00020\u00122\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00120/\u001a\u0010\u00101\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f*\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"kotlinCoroutinesPackageFqn", "Lorg/jetbrains/kotlin/name/FqName;", "kotlinPackageFqn", "getKotlinPackageFqn", "()Lorg/jetbrains/kotlin/name/FqName;", "kotlinReflectionPackageFqn", "collectAllSupertypes", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "result", "", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "getAllSupertypes", "getImmediateSupertypes", "", "getPrimitiveArrayElementType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isClassWithNamePrefix", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "prefix", "", "packageFqName", "isFunction", "isFunctionOrKFunction", "isFunctionTypeOrSubtype", "isInterface", "isKFunction", "isKSuspendFunction", "isPrimitiveArray", "isSuspendFunction", "isSuspendFunctionOrKFunction", "isSuspendFunctionTypeOrSubtype", "isThrowable", "isTypeFromKotlinPackage", "namePredicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "isTypeParameter", "isUnsigned", "substitute", "params", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "arguments", "substitutionMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "superTypes", "ir.backend.common"})
public final class IrTypeUtilsKt {
    private static final FqName kotlinPackageFqn;
    private static final FqName kotlinReflectionPackageFqn;
    private static final FqName kotlinCoroutinesPackageFqn;

    @NotNull
    public static final FqName getKotlinPackageFqn() {
        return kotlinPackageFqn;
    }

    public static final boolean isFunction(@NotNull IrType $this$isFunction) {
        Intrinsics.checkNotNullParameter($this$isFunction, "$this$isFunction");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isFunction);
        return irClassifierSymbol != null && IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "Function", kotlinPackageFqn);
    }

    public static final boolean isKFunction(@NotNull IrType $this$isKFunction) {
        Intrinsics.checkNotNullParameter($this$isKFunction, "$this$isKFunction");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKFunction);
        return irClassifierSymbol != null && IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "KFunction", kotlinReflectionPackageFqn);
    }

    public static final boolean isSuspendFunction(@NotNull IrType $this$isSuspendFunction) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunction, "$this$isSuspendFunction");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isSuspendFunction);
        return irClassifierSymbol != null && IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "SuspendFunction", kotlinCoroutinesPackageFqn);
    }

    public static final boolean isKSuspendFunction(@NotNull IrType $this$isKSuspendFunction) {
        Intrinsics.checkNotNullParameter($this$isKSuspendFunction, "$this$isKSuspendFunction");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKSuspendFunction);
        return irClassifierSymbol != null && IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "KSuspendFunction", kotlinReflectionPackageFqn);
    }

    public static final boolean isFunction(@NotNull IrClassifierSymbol $this$isFunction) {
        Intrinsics.checkNotNullParameter($this$isFunction, "$this$isFunction");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isFunction, "Function", kotlinPackageFqn);
    }

    public static final boolean isKFunction(@NotNull IrClassifierSymbol $this$isKFunction) {
        Intrinsics.checkNotNullParameter($this$isKFunction, "$this$isKFunction");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isKFunction, "KFunction", kotlinReflectionPackageFqn);
    }

    public static final boolean isKSuspendFunction(@NotNull IrClassifierSymbol $this$isKSuspendFunction) {
        Intrinsics.checkNotNullParameter($this$isKSuspendFunction, "$this$isKSuspendFunction");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isKSuspendFunction, "KSuspendFunction", kotlinReflectionPackageFqn);
    }

    private static final boolean isClassWithNamePrefix(IrClassifierSymbol $this$isClassWithNamePrefix, String prefix, FqName packageFqName) {
        IrSymbolOwner irSymbolOwner = $this$isClassWithNamePrefix.getOwner();
        if (irSymbolOwner == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
        }
        IrDeclarationWithName declaration2 = (IrDeclarationWithName)((Object)irSymbolOwner);
        String string2 = declaration2.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "declaration.name.asString()");
        String name = string2;
        if (!StringsKt.startsWith$default(name, prefix, false, 2, null)) {
            return false;
        }
        IrDeclarationParent irDeclarationParent = declaration2.getParent();
        if (!(irDeclarationParent instanceof IrPackageFragment)) {
            irDeclarationParent = null;
        }
        IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
        if (irPackageFragment == null) {
            return false;
        }
        IrPackageFragment parent2 = irPackageFragment;
        return Intrinsics.areEqual(parent2.getFqName(), packageFqName);
    }

    @NotNull
    public static final List<IrType> superTypes(@NotNull IrType $this$superTypes) {
        Intrinsics.checkNotNullParameter($this$superTypes, "$this$superTypes");
        Object object = IrTypesKt.getClassifierOrNull($this$superTypes);
        if (object == null || (object = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.superTypes((IrClassifierSymbol)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull IrType $this$isFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter($this$isFunctionTypeOrSubtype, "$this$isFunctionTypeOrSubtype");
        Collection collection = CollectionsKt.listOf($this$isFunctionTypeOrSubtype);
        Object object = isFunctionTypeOrSubtype.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new IrTypeUtilsKt$sam$org_jetbrains_kotlin_utils_DFS_Neighbors$0(function1);
        }
        Boolean bl = DFS.ifAny(collection, (DFS.Neighbors)object, isFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(bl, "DFS.ifAny(listOf(this), \u2026ypes, IrType::isFunction)");
        return bl;
    }

    public static final boolean isSuspendFunctionTypeOrSubtype(@NotNull IrType $this$isSuspendFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunctionTypeOrSubtype, "$this$isSuspendFunctionTypeOrSubtype");
        Collection collection = CollectionsKt.listOf($this$isSuspendFunctionTypeOrSubtype);
        Object object = isSuspendFunctionTypeOrSubtype.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new IrTypeUtilsKt$sam$org_jetbrains_kotlin_utils_DFS_Neighbors$0(function1);
        }
        Boolean bl = DFS.ifAny(collection, (DFS.Neighbors)object, isSuspendFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(bl, "DFS.ifAny(listOf(this), \u2026rType::isSuspendFunction)");
        return bl;
    }

    public static final boolean isTypeParameter(@NotNull IrType $this$isTypeParameter) {
        Intrinsics.checkNotNullParameter($this$isTypeParameter, "$this$isTypeParameter");
        return IrTypesKt.getClassifierOrNull($this$isTypeParameter) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isInterface(@NotNull IrType $this$isInterface) {
        Intrinsics.checkNotNullParameter($this$isInterface, "$this$isInterface");
        Object object = IrTypesKt.getClassOrNull($this$isInterface);
        return (object != null && (object = (IrClass)object.getOwner()) != null ? ((IrClass)object).getKind() : null) == ClassKind.INTERFACE;
    }

    public static final boolean isFunctionOrKFunction(@NotNull IrType $this$isFunctionOrKFunction) {
        Intrinsics.checkNotNullParameter($this$isFunctionOrKFunction, "$this$isFunctionOrKFunction");
        return IrTypeUtilsKt.isFunction($this$isFunctionOrKFunction) || IrTypeUtilsKt.isKFunction($this$isFunctionOrKFunction);
    }

    public static final boolean isSuspendFunctionOrKFunction(@NotNull IrType $this$isSuspendFunctionOrKFunction) {
        Intrinsics.checkNotNullParameter($this$isSuspendFunctionOrKFunction, "$this$isSuspendFunctionOrKFunction");
        return IrTypeUtilsKt.isSuspendFunction($this$isSuspendFunctionOrKFunction) || IrTypeUtilsKt.isKSuspendFunction($this$isSuspendFunctionOrKFunction);
    }

    public static final boolean isThrowable(@NotNull IrType $this$isThrowable) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isThrowable, "$this$isThrowable");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isThrowable;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            if (!(irClassifierSymbol instanceof IrClassSymbol)) {
                irClassifierSymbol = null;
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(name.asString(), "Throwable")) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    if (!(irDeclarationParent instanceof IrPackageFragment)) {
                        irDeclarationParent = null;
                    }
                    IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual(parent$iv.getFqName(), IrTypeUtilsKt.getKotlinPackageFqn());
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isUnsigned(@NotNull IrType $this$isUnsigned) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isUnsigned, "$this$isUnsigned");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isUnsigned;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            if (!(irClassifierSymbol instanceof IrClassSymbol)) {
                irClassifierSymbol = null;
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!UnsignedTypes.INSTANCE.isShortNameOfUnsignedType(name)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    if (!(irDeclarationParent instanceof IrPackageFragment)) {
                        irDeclarationParent = null;
                    }
                    IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual(parent$iv.getFqName(), IrTypeUtilsKt.getKotlinPackageFqn());
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isPrimitiveArray, "$this$isPrimitiveArray");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isPrimitiveArray;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            if (!(irClassifierSymbol instanceof IrClassSymbol)) {
                irClassifierSymbol = null;
            }
            IrClassSymbol irClassSymbol = (IrClassSymbol)irClassifierSymbol;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name it = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!StandardNames.FqNames.primitiveArrayTypeShortNames.contains(it)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    if (!(irDeclarationParent instanceof IrPackageFragment)) {
                        irDeclarationParent = null;
                    }
                    IrPackageFragment irPackageFragment = (IrPackageFragment)irDeclarationParent;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual(parent$iv.getFqName(), IrTypeUtilsKt.getKotlinPackageFqn());
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final PrimitiveType getPrimitiveArrayElementType(@NotNull IrType $this$getPrimitiveArrayElementType) {
        PrimitiveType primitiveType;
        Intrinsics.checkNotNullParameter($this$getPrimitiveArrayElementType, "$this$getPrimitiveArrayElementType");
        IrType irType = $this$getPrimitiveArrayElementType;
        if (!(irType instanceof IrSimpleType)) {
            irType = null;
        }
        IrSimpleType irSimpleType = (IrSimpleType)irType;
        if (irSimpleType != null) {
            Object object;
            IrSimpleType irSimpleType2 = irSimpleType;
            boolean bl = false;
            boolean bl2 = false;
            IrSimpleType it = irSimpleType2;
            boolean bl3 = false;
            IrSymbolOwner irSymbolOwner = it.getClassifier().getOwner();
            if (!(irSymbolOwner instanceof IrClass)) {
                irSymbolOwner = null;
            }
            if ((object = (IrClass)irSymbolOwner) != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null && (object = ((FqName)object).toUnsafe()) != null) {
                Object object2 = object;
                boolean bl4 = false;
                boolean bl5 = false;
                Object fqn = object2;
                boolean bl6 = false;
                primitiveType = StandardNames.FqNames.arrayClassFqNameToPrimitiveType.get(fqn);
            } else {
                primitiveType = null;
            }
        } else {
            primitiveType = null;
        }
        return primitiveType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType substitute(@NotNull IrType $this$substitute, @NotNull List<? extends IrTypeParameter> params, @NotNull List<? extends IrType> arguments2) {
        Collection<IrTypeParameterSymbol> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($this$substitute, "$this$substitute");
        Intrinsics.checkNotNullParameter(params, "params");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Iterable iterable = params;
        IrType irType = $this$substitute;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrTypeParameterSymbol irTypeParameterSymbol = (IrTypeParameterSymbol)it.getSymbol();
            collection.add(irTypeParameterSymbol);
        }
        collection = (List)destination$iv$iv;
        return IrTypeUtilsKt.substitute(irType, MapsKt.toMap(CollectionsKt.zip((Iterable)collection, (Iterable)arguments2)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType substitute(@NotNull IrType $this$substitute, @NotNull Map<IrTypeParameterSymbol, ? extends IrType> substitutionMap) {
        void $this$mapTo$iv$iv;
        IrConstructorCall irConstructorCall;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter($this$substitute, "$this$substitute");
        Intrinsics.checkNotNullParameter(substitutionMap, "substitutionMap");
        if (!($this$substitute instanceof IrSimpleType)) {
            return $this$substitute;
        }
        Object object = substitutionMap;
        IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$substitute).getClassifier();
        boolean bl = false;
        IrType irType = object.get(irClassifierSymbol);
        if (irType != null) {
            object = irType;
            boolean bl2 = false;
            bl = false;
            Object it = object;
            boolean bl3 = false;
            return it;
        }
        Iterable $this$map$iv = ((IrSimpleType)$this$substitute).getArguments();
        boolean $i$f$map = false;
        Iterable it = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it2;
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            irConstructorCall = it2 instanceof IrTypeProjection ? (IrTypeArgument)IrSimpleTypeImplKt.makeTypeProjection(IrTypeUtilsKt.substitute(((IrTypeProjection)it2).getType(), substitutionMap), ((IrTypeProjection)it2).getVariance()) : it2;
            collection.add(irConstructorCall);
        }
        List newArguments2 = (List)destination$iv$iv;
        Iterable $this$map$iv2 = $this$substitute.getAnnotations();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p2;
            void p1;
            void it3;
            IrConstructorCall bl4 = (IrConstructorCall)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl5 = false;
            IrElement $this$deepCopyWithSymbols$iv = (IrElement)it3;
            IrDeclarationParent initialParent$iv = null;
            boolean $i$f$deepCopyWithSymbols = false;
            DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
            IrElementVisitorVoidKt.acceptVoid($this$deepCopyWithSymbols$iv, symbolRemapper$iv);
            DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper(symbolRemapper$iv);
            TypeRemapper typeRemapper = typeRemapper$iv;
            SymbolRemapper symbolRemapper = symbolRemapper$iv;
            IrElement irElement = $this$deepCopyWithSymbols$iv;
            DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p1, (TypeRemapper)p2);
            IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(irElement.transform(deepCopyIrTreeWithSymbols, null), initialParent$iv);
            if (irElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConstructorCall");
            }
            irConstructorCall = (IrConstructorCall)((IrElement)((IrConstructorCall)irElement2));
            collection.add(irConstructorCall);
        }
        List newAnnotations = (List)destination$iv$iv2;
        return new IrSimpleTypeImpl(((IrSimpleType)$this$substitute).getClassifier(), ((IrSimpleType)$this$substitute).getHasQuestionMark(), newArguments2, newAnnotations, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IrSimpleType> getImmediateSupertypes(IrClass irClass2) {
        void $this$mapTo$iv$iv;
        IrType it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        List<IrType> originalSupertypes = irClass2.getSuperTypes();
        Iterable $this$mapNotNull$iv = IrUtilsKt.getDefaultType(irClass2).getArguments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrType irType;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrTypeArgument it2 = (IrTypeArgument)element$iv$iv;
            boolean bl2 = false;
            IrTypeArgument irTypeArgument = it2;
            if (!(irTypeArgument instanceof IrTypeProjection)) {
                irTypeArgument = null;
            }
            IrTypeProjection irTypeProjection = (IrTypeProjection)irTypeArgument;
            if ((irTypeProjection != null ? irTypeProjection.getType() : null) == null) continue;
            irType = irType;
            boolean bl3 = false;
            boolean bl4 = false;
            IrType it$iv$iv = irType;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List args = (List)destination$iv$iv;
        Iterable $this$filter$iv = originalSupertypes;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrType)element$iv$iv;
            boolean bl = false;
            if (!(IrTypesKt.getClassOrNull(it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void superType;
            it = (IrType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)superType);
            Intrinsics.checkNotNull(irClassSymbol);
            IrType irType = IrTypeUtilsKt.substitute((IrType)superType, ((IrClass)irClassSymbol.getOwner()).getTypeParameters(), args);
            if (irType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            }
            IrSimpleType irSimpleType = (IrSimpleType)irType;
            collection.add(irSimpleType);
        }
        return (List)destination$iv$iv;
    }

    private static final void collectAllSupertypes(IrClass irClass2, Set<IrSimpleType> result2) {
        List<IrSimpleType> immediateSupertypes = IrTypeUtilsKt.getImmediateSupertypes(irClass2);
        result2.addAll((Collection<IrSimpleType>)immediateSupertypes);
        for (IrSimpleType supertype2 : immediateSupertypes) {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(supertype2);
            Intrinsics.checkNotNull(irClassSymbol);
            IrTypeUtilsKt.collectAllSupertypes((IrClass)irClassSymbol.getOwner(), result2);
        }
    }

    @NotNull
    public static final Set<IrSimpleType> getAllSupertypes(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        HashSet result2 = new HashSet();
        IrTypeUtilsKt.collectAllSupertypes(irClass2, result2);
        return result2;
    }

    static {
        FqName fqName2 = FqName.fromSegments(CollectionsKt.listOf("kotlin"));
        Intrinsics.checkNotNullExpressionValue(fqName2, "FqName.fromSegments(listOf(\"kotlin\"))");
        kotlinPackageFqn = fqName2;
        FqName fqName3 = kotlinPackageFqn.child(Name.identifier("reflect"));
        Intrinsics.checkNotNullExpressionValue(fqName3, "kotlinPackageFqn.child(Name.identifier(\"reflect\"))");
        kotlinReflectionPackageFqn = fqName3;
        FqName fqName4 = kotlinPackageFqn.child(Name.identifier("coroutines"));
        Intrinsics.checkNotNullExpressionValue(fqName4, "kotlinPackageFqn.child(N\u2026identifier(\"coroutines\"))");
        kotlinCoroutinesPackageFqn = fqName4;
    }
}

