/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.error.PSystemError;

public abstract class SingleLineCommand2<S extends Diagram>
implements Command<S> {
    private final IRegex pattern;
    private final boolean doTrim;

    public SingleLineCommand2(IRegex pattern) {
        this(true, pattern);
    }

    public SingleLineCommand2(boolean doTrim, IRegex pattern) {
        this.doTrim = doTrim;
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        this.pattern = pattern;
    }

    public boolean syntaxWithFinalBracket() {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.pattern.getClass().getName()};
    }

    private String myTrim(StringLocated s) {
        if (this.doTrim) {
            return s.getTrimmed().getString();
        }
        return s.getString();
    }

    private StringLocated myTrim2(StringLocated s) {
        if (this.doTrim) {
            return s.getTrimmed();
        }
        return s;
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        if (lines.size() == 2 && this.syntaxWithFinalBracket()) {
            return this.isValidBracket(lines);
        }
        if (lines.size() != 1) {
            return CommandControl.NOT_OK;
        }
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        StringLocated line2 = this.myTrim2(lines.getFirst());
        if (this.syntaxWithFinalBracket() && !line2.getString().endsWith("{")) {
            String vline = lines.getAt(0).getString() + " {";
            if (this.isValid(BlocLines.singleString(vline)) == CommandControl.OK) {
                return CommandControl.OK_PARTIAL;
            }
            return CommandControl.NOT_OK;
        }
        boolean result = this.pattern.match(line2);
        if (result) {
            this.actionIfCommandValid();
        }
        return result ? CommandControl.OK : CommandControl.NOT_OK;
    }

    private CommandControl isValidBracket(BlocLines lines) {
        assert (lines.size() == 2);
        assert (this.syntaxWithFinalBracket());
        if (!this.myTrim(lines.getAt(1)).equals("{")) {
            return CommandControl.NOT_OK;
        }
        String vline = lines.getAt(0).getString() + " {";
        return this.isValid(BlocLines.singleString(vline));
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    @Override
    public final CommandExecutionResult execute(S system, BlocLines lines) {
        if (this.syntaxWithFinalBracket() && lines.size() == 2) {
            assert (this.myTrim(lines.getAt(1)).equals("{"));
            lines = BlocLines.singleString(lines.getFirst().getString() + " {");
        }
        if (lines.size() != 1) {
            throw new IllegalArgumentException();
        }
        StringLocated first = lines.getFirst();
        String line = this.myTrim(first);
        if (this.isForbidden(line)) {
            return CommandExecutionResult.error("Syntax error: " + line);
        }
        RegexResult arg = this.pattern.matcher(line);
        if (arg == null) {
            return CommandExecutionResult.error("Cannot parse line " + line);
        }
        if (system instanceof PSystemError) {
            return CommandExecutionResult.error("PSystemError cannot be cast");
        }
        return this.executeArg(system, first.getLocation(), arg);
    }

    protected boolean isForbidden(CharSequence line) {
        return false;
    }

    protected abstract CommandExecutionResult executeArg(S var1, LineLocation var2, RegexResult var3);
}

