/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.StringCompressorNone;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends AbstractPSystem {
    private static final int COLS = 6;
    private static final int FREE_LINES = 6;
    public static final String DONORS = "6wyC0AmFkBap0wp4H6CjU-RENbb-8cPf4i7oFA4uiOZJNK3y0UwT7lSRwI-YAxltJJEYrckJSWPHVH3qW7UtXVQXzBy-27EYV0Z-tGWU80D4ITH6ZIpt9Djjcof3Il3lEr_v9UWTth51ehbAgiMHwq-_8GFlEsFpx3I-UFLeWZO2FmRsrVcVQ_NQ7kb2GV9veXHAkanefoODi_-N3j9O0j_0itRHbhPsqaY72koem6DV-ULhvyEZoQeOMOeKGIka8D0RCmHoqdk3RFH1uPVw8RJPN64fovb076seHzVNQnFRHWpVAF61m0sn81E1EP1op2oYo7FJZG9N10w-MSp6MagEF9c4O1vQo9i_r9CIZvHdJeUB0iyZG23mD0gGj4O1JJXRSXYGEP8j4fQuwi9nOmwFm_AKUYGDdoOMF1RK0jGGv7_G1PqMQtmqETlLO4lgQP9xjqxKdn6FSsrMz5MN9WdpjVRIR2AkCMM9L6CRdwEzvX60kwLMZlWo-XZa2EhzvbM8rOyMa1-17ge9I_9dsGyMeY2gRTY7tdLsdpnc4Gx8a6bY7RoBBQ-fN-WITLQGP0LOvE_ChmkRu84jT2NaOU09BNCkwtm2avPMxnSz6jRk4wunYzshuvxeQ5XA__sg3pE3uW0jb9W5tMbWK4RJAbvi80AxXHuFk2cGAw7SNPTYzt6HFl8J06zIUj0LDaY24CylIcuwX8Y6TEr9iGAOU4gfYmBV0WjsROAkHfL-UbcjzZXTBTENZGdtIHiyhpKOGt5CHwalp7Ul2hSmDAj6itgpzYxc55p9nq5UzPx5kGhWqiAxueDh_f41UQPNHaGQJLVVjk4VcPjL66QXvzoiIdTLFxXvwF21krZKnOmoUSXKq7YGY9hwbU2d9SFVOiYg_DMDyWvMf-km46P6FBYzDBcW9aSKkAQp71OR1CognIjEYONh2TQmw6Isi2aYprZT3ndoE-2Ji5Gp2qq0kuQx0C_8FGhauRn7LYshroPqBY17DXFqfGLJBOMAzBL01emrwUcqHcn_Mc01MzfZTAnmA7pPH6kL6nIO0gQRa7xX81Bb3T4IlQX98e3_-NENUlAv3kBupXW-6GUIFIGXe0f5TzY9qbEw7js6iLwZxzTBkVa8_lnhZpOv1UsUdoOGhOFayS-401pbAFJWQU2loISdxrvOanMSYmnNBbPwF92mO1ZlxA8kNcR4xiHakPfSj8hyKERVubguc1nYGugBVb3HOab9BpUhGIMsVVXTXuiSAFubgfH4SbchpcGa-0HcSUwEVRLXgDig6X11TLGce7VNRwTPxXfpla9Iqt0PaE-toAcaHMZ1cfhQ-qAWMupzlIdxAK-B_sH4Fx7MwkEg7W87ERhSBgBXcn58EwOdCLmat110lppdX0TklkaXBwe5fM5ftGmxJh12VeMNy4B27jluW2BBgpIht923RY5xeHge3oYg2Hx8mA93roGMb78y84LIOCxPCZABb8CsuBcU0N2A0llxUmt2gHFDBsZMtfvHIEPYpCru1X4VpiyWOPCfcnyvi2_BNBPwHMwY5kcm0z-ExpXV_uYwUX218X1bIV2YBjBXndopD6mgvZTrtCUbDcycty2bQEkKWUqoazq0cm4bdWH0xA2WGiKhylDyOCivYVnxlp4LDcl2KsOyim00";

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        UDrawable result = this.getGraphicStrings();
        HColor backcolor = HColorUtils.WHITE;
        ImageParameter imageParameter = new ImageParameter(new ColorMapperIdentity(), false, null, 1.0, this.getMetadata(), null, ClockwiseTopRightBottomLeft.none(), backcolor);
        ImageBuilder imageBuilder = ImageBuilder.build(imageParameter);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private UDrawable getGraphicStrings() throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 6, 6);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(UTranslate.dy(header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(UTranslate.dx(x)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(new PixelImage(PSystemVersion.getPlantumlImage(), AffineTransformType.TYPE_BILINEAR));
                ug.apply(new UTranslate(lastX, y - (double)logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Transcoder t = TranscoderImpl.utf8(new AsciiEncoder(), new StringCompressorNone(), new CompressionBrotli());
        try {
            String s = t.decode(DONORS).replace('*', '.');
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                lines.add(st.nextToken());
            }
        }
        catch (NoPlantumlCompressionException e) {
            e.printStackTrace();
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

