/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.ActorStyle;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ComponentRoseActor
extends AbstractTextualComponent {
    private final TextBlock stickman;
    private final boolean head;

    public ComponentRoseActor(ActorStyle actorStyle, Style style, Style stereo, SymbolContext biColor, FontConfiguration font, Display stringsToDisplay, boolean head, ISkinSimple spriteContainer, UFont fontForStereotype, HColor htmlColorForStereotype) {
        super(style, stereo, LineBreakStrategy.NONE, stringsToDisplay, font, HorizontalAlignment.CENTER, 3, 3, 0, spriteContainer, false, fontForStereotype, htmlColorForStereotype);
        this.head = head;
        if (UseStyle.useBetaStyle()) {
            biColor = style.getSymbolContext(this.getIHtmlColorSet());
        }
        this.stickman = actorStyle.getTextBlock(biColor);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        double delta = (this.getPreferredWidth(stringBounder) - dimStickman.getWidth()) / 2.0;
        if (this.head) {
            textBlock.drawU(ug.apply(new UTranslate(this.getTextMiddlePostion(stringBounder), dimStickman.getHeight())));
            ug = ug.apply(UTranslate.dx(delta));
        } else {
            textBlock.drawU(ug.apply(UTranslate.dx(this.getTextMiddlePostion(stringBounder))));
            ug = ug.apply(new UTranslate(delta, this.getTextHeight(stringBounder)));
        }
        this.stickman.drawU(ug);
    }

    private double getTextMiddlePostion(StringBounder stringBounder) {
        return (this.getPreferredWidth(stringBounder) - this.getTextWidth(stringBounder)) / 2.0;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        return dimStickman.getHeight() + this.getTextHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        Dimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        return Math.max(dimStickman.getWidth(), this.getTextWidth(stringBounder));
    }
}

