/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.AbstractAction;
import org.protege.editor.core.FileUtils;
import org.protege.editor.core.ui.util.UIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowFileAction
extends AbstractAction {
    private final Logger logger = LoggerFactory.getLogger(ShowFileAction.class);
    private URI physicalURI;

    public ShowFileAction(URI physicalURI) {
        super("Show file...");
        this.physicalURI = physicalURI;
        if (!UIUtil.isLocalFile((URI)physicalURI)) {
            throw new IllegalArgumentException("URI must be a file URI!");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            FileUtils.showFile((File)new File(this.physicalURI));
        }
        catch (IOException ex) {
            this.logger.error("An error occurred when attempting to show a file in the operating system.", (Throwable)ex);
        }
    }
}

