/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.internal.storage.dfs.DfsPackKey;
import org.eclipse.jgit.internal.storage.pack.PackOutputStream;

final class DfsBlock {
    final DfsPackKey pack;
    final long start;
    final long end;
    private final byte[] block;

    DfsBlock(DfsPackKey p, long pos, byte[] buf) {
        this.pack = p;
        this.start = pos;
        this.end = pos + (long)buf.length;
        this.block = buf;
    }

    int size() {
        return this.block.length;
    }

    boolean contains(DfsPackKey want, long pos) {
        return this.pack == want && this.start <= pos && pos < this.end;
    }

    int copy(long pos, byte[] dstbuf, int dstoff, int cnt) {
        int ptr = (int)(pos - this.start);
        return this.copy(ptr, dstbuf, dstoff, cnt);
    }

    int copy(int p, byte[] b, int o, int n) {
        n = Math.min(this.block.length - p, n);
        System.arraycopy(this.block, p, b, o, n);
        return n;
    }

    int setInput(long pos, Inflater inf) throws DataFormatException {
        int ptr = (int)(pos - this.start);
        int cnt = this.block.length - ptr;
        if (cnt <= 0) {
            throw new DataFormatException(cnt + " bytes to inflate: at pos=" + pos + "; block.start=" + this.start + "; ptr=" + ptr + "; block.length=" + this.block.length);
        }
        inf.setInput(this.block, ptr, cnt);
        return cnt;
    }

    void crc32(CRC32 out, long pos, int cnt) {
        int ptr = (int)(pos - this.start);
        out.update(this.block, ptr, cnt);
    }

    void write(PackOutputStream out, long pos, int cnt) throws IOException {
        out.write(this.block, (int)(pos - this.start), cnt);
    }

    void check(Inflater inf, byte[] tmp, long pos, int cnt) throws DataFormatException {
        inf.setInput(this.block, (int)(pos - this.start), cnt);
        while (inf.inflate(tmp, 0, tmp.length) > 0) {
        }
    }
}

