/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.templates.ui;

import java.awt.Panel;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.templates.ui.Bundle;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class RenameTemplatePanel
extends Panel {
    private Set<String> otherFileNames;
    private boolean isLicense = false;
    private DialogDescriptor dd;
    private NotificationLineSupport notificationLineSupport;
    private JLabel displayNameLabel;
    private JTextField displayNameTextField;
    private JLabel fileNameLabel;
    private JTextField fileNameTextField;

    public RenameTemplatePanel(boolean isUserFile) {
        this.initComponents();
        this.fileNameTextField.setEditable(isUserFile);
        this.fileNameTextField.getDocument().addDocumentListener(new NameDocumentListener());
    }

    private void initComponents() {
        this.displayNameLabel = new JLabel();
        this.displayNameTextField = new JTextField();
        this.fileNameLabel = new JLabel();
        this.fileNameTextField = new JTextField();
        this.displayNameLabel.setLabelFor(this.displayNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.displayNameLabel, (String)NbBundle.getMessage(RenameTemplatePanel.class, (String)"RenameTemplatePanel.displayNameLabel.text"));
        this.fileNameLabel.setLabelFor(this.fileNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileNameLabel, (String)NbBundle.getMessage(RenameTemplatePanel.class, (String)"RenameTemplatePanel.fileNameLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayNameLabel).addComponent(this.fileNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileNameTextField, -1, 204, Short.MAX_VALUE).addComponent(this.displayNameTextField, -1, 204, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.displayNameLabel).addComponent(this.displayNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameLabel).addComponent(this.fileNameTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    void setFileName(String name) {
        this.fileNameTextField.setText(name);
    }

    void setFileDisplayName(String name) {
        this.displayNameTextField.setText(name);
    }

    String getFileName() {
        return this.fileNameTextField.getText();
    }

    String getFileDisplayName() {
        return this.displayNameTextField.getText();
    }

    void setIsLicense(boolean isLicense) {
        this.isLicense = isLicense;
    }

    void setOtherFileNames(Set<String> otherFileNames) {
        this.otherFileNames = otherFileNames;
    }

    void setDescriptor(DialogDescriptor dd) {
        this.dd = dd;
        this.notificationLineSupport = dd.createNotificationLineSupport();
    }

    private void checkName() {
        boolean clash;
        String name = this.fileNameTextField.getText();
        boolean bl = clash = this.otherFileNames != null && this.otherFileNames.contains(name);
        if (clash) {
            this.notificationLineSupport.setErrorMessage(Bundle.Err_FileNameExists());
        } else {
            boolean bl2 = clash = this.isLicense && RenameTemplatePanel.checkLicenseClash(name);
            if (clash) {
                this.notificationLineSupport.setErrorMessage(Bundle.RenameTemplatePanel_license_warning_text("license-", ".txt"));
            } else {
                this.notificationLineSupport.clearMessages();
            }
        }
        this.dd.setValid(!clash);
    }

    private static boolean checkLicenseClash(String name) {
        return !name.startsWith("license-") || !name.endsWith(".txt");
    }

    private class NameDocumentListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            RenameTemplatePanel.this.checkName();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            RenameTemplatePanel.this.checkName();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            RenameTemplatePanel.this.checkName();
        }
    }
}

