/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.tools;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.NbBundle;

public class MouseSelectionPopupPanel
extends JPanel {
    private ChangeListener changeListener;
    private JSlider diameterSlider;
    private JLabel labelDiameter;
    private JLabel labelValue;
    private JCheckBox proportionnalZoomCheckbox;
    private BindingGroup bindingGroup;

    public MouseSelectionPopupPanel() {
        this.initComponents();
        this.diameterSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (!source.getValueIsAdjusting()) {
                    MouseSelectionPopupPanel.this.fireChangeEvent(source);
                }
            }
        });
        this.proportionnalZoomCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MouseSelectionPopupPanel.this.fireChangeEvent(MouseSelectionPopupPanel.this.proportionnalZoomCheckbox);
            }
        });
    }

    public boolean isProportionnalToZoom() {
        return this.proportionnalZoomCheckbox.isSelected();
    }

    public void setProportionnalToZoom(boolean proportionnalToZoom) {
        this.proportionnalZoomCheckbox.setSelected(proportionnalToZoom);
    }

    public int getDiameter() {
        return this.diameterSlider.getValue();
    }

    public void setDiameter(int diameter) {
        this.diameterSlider.setValue(diameter);
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    private void fireChangeEvent(Object source) {
        if (this.changeListener != null) {
            ChangeEvent changeEvent = new ChangeEvent(source);
            this.changeListener.stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.labelDiameter = new JLabel();
        this.diameterSlider = new JSlider();
        this.labelValue = new JLabel();
        this.proportionnalZoomCheckbox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.labelDiameter.setText(NbBundle.getMessage(MouseSelectionPopupPanel.class, (String)"MouseSelectionPopupPanel.labelDiameter.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(6, 5, 8, 0);
        this.add((Component)this.labelDiameter, gridBagConstraints);
        this.diameterSlider.setMaximum(1000);
        this.diameterSlider.setMinimum(1);
        this.diameterSlider.setValue(1);
        this.diameterSlider.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.diameterSlider, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.diameterSlider, (Property)ELProperty.create((String)"${value}"), (Object)this.labelValue, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 24;
        gridBagConstraints.insets = new Insets(6, 0, 8, 5);
        this.add((Component)this.labelValue, gridBagConstraints);
        this.proportionnalZoomCheckbox.setText(NbBundle.getMessage(MouseSelectionPopupPanel.class, (String)"MouseSelectionPopupPanel.proportionnalZoomCheckbox.text"));
        this.proportionnalZoomCheckbox.setFocusable(false);
        this.proportionnalZoomCheckbox.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 5, 0);
        this.add((Component)this.proportionnalZoomCheckbox, gridBagConstraints);
        this.bindingGroup.bind();
    }
}

