/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DescriptorLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.SerializationException;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.lang.UrlClassLoader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginManagerCore {
    public static final PluginId CORE_ID = PluginId.getId("com.intellij");
    public static final PluginId JAVA_PLUGIN_ID = PluginId.getId("com.intellij.java");
    private static final PluginId JAVA_MODULE_ID = PluginId.getId("com.intellij.modules.java");
    private static final PluginId ALL_MODULES_MARKER = PluginId.getId("com.intellij.modules.all");
    private static final PluginId SPECIAL_IDEA_PLUGIN_ID = PluginId.getId("IDEA CORE");
    private static volatile Set<PluginId> ourDisabledPlugins;
    static volatile List<IdeaPluginDescriptorImpl> ourLoadedPlugins;
    public static volatile boolean isUnitTestMode;
    private static BuildNumber ourBuildNumber;
    @Nullable
    private static Runnable disabledPluginListener;

    @Nullable
    @ApiStatus.Internal
    public static String getPluginsCompatibleBuild() {
        return System.getProperty("idea.plugins.compatible.build");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<PluginId> disabledPlugins) {
        Path file2;
        if (configPath == null) {
            PluginManagerCore.$$$reportNull$$$0(6);
        }
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        if (!Files.isRegularFile(file2 = Paths.get(configPath, "disabled_plugins.txt"), new LinkOption[0])) {
            return;
        }
        List<String> requiredPlugins = StringUtil.split(System.getProperty("idea.required.plugins.id", ""), ",");
        try {
            boolean updateDisablePluginsList = false;
            try (BufferedReader reader = Files.newBufferedReader(file2);){
                String id;
                while ((id = reader.readLine()) != null) {
                    if (!requiredPlugins.contains(id = id.trim()) && !ApplicationInfoImpl.getShadowInstance().isEssentialPlugin(id)) {
                        disabledPlugins.add(PluginId.getId(id));
                        continue;
                    }
                    updateDisablePluginsList = true;
                }
            }
            finally {
                if (updateDisablePluginsList) {
                    PluginManagerCore.savePluginsList(disabledPlugins, file2, false);
                    PluginManagerCore.fireEditDisablePlugins();
                }
            }
        }
        catch (IOException e) {
            PluginManagerCore.getLogger().info("Unable to load disabled plugins list from " + file2, e);
        }
    }

    public static void dontLoadDisabledPlugins() {
        ourDisabledPlugins = Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static Set<PluginId> getDisabledIds() {
        Set<PluginId> result2 = ourDisabledPlugins;
        if (result2 != null) {
            Set<PluginId> set = result2;
            if (set == null) {
                PluginManagerCore.$$$reportNull$$$0(8);
            }
            return set;
        }
        if (System.getProperty("idea.ignore.disabled.plugins") != null) {
            Set<PluginId> set = Collections.emptySet();
            if (set == null) {
                PluginManagerCore.$$$reportNull$$$0(9);
            }
            return set;
        }
        Class<PluginManagerCore> clazz = PluginManagerCore.class;
        synchronized (PluginManagerCore.class) {
            block10: {
                result2 = ourDisabledPlugins;
                if (result2 == null) break block10;
                Set<PluginId> set = result2;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (set == null) {
                    PluginManagerCore.$$$reportNull$$$0(10);
                }
                return set;
            }
            result2 = new LinkedHashSet<PluginId>();
            PluginManagerCore.loadDisabledPlugins(PathManager.getConfigPath(), result2);
            ourDisabledPlugins = result2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Set<PluginId> set = result2;
            if (set == null) {
                PluginManagerCore.$$$reportNull$$$0(11);
            }
            return set;
        }
    }

    @NotNull
    public static Set<PluginId> disabledPlugins() {
        Set<PluginId> set = Collections.unmodifiableSet(PluginManagerCore.getDisabledIds());
        if (set == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        return set;
    }

    private static void fireEditDisablePlugins() {
        if (disabledPluginListener != null) {
            disabledPluginListener.run();
        }
    }

    public static void savePluginsList(@NotNull Collection<PluginId> ids, @NotNull Path file2, boolean append2) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(19);
        }
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(20);
        }
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = append2 ? Files.newBufferedWriter(file2, StandardOpenOption.APPEND, StandardOpenOption.CREATE) : Files.newBufferedWriter(file2, new OpenOption[0]);){
            PluginManagerCore.writePluginsList(ids, writer);
        }
    }

    public static void writePluginsList(@NotNull Collection<PluginId> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(21);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        ArrayList<PluginId> sortedIds = new ArrayList<PluginId>(ids);
        sortedIds.sort(null);
        String separator = LineSeparator.getSystemLineSeparator().getSeparatorString();
        for (PluginId id : sortedIds) {
            writer.write(id.getIdString());
            writer.write(separator);
        }
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className2) {
        PluginId id;
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(34);
        }
        return (id = PluginManagerCore.getPluginOrPlatformByClassName(className2)) == null || CORE_ID == id ? null : id;
    }

    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className2) {
        PluginDescriptor result2;
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(35);
        }
        return (result2 = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className2)) == null ? null : result2.getPluginId();
    }

    @Nullable
    @ApiStatus.Internal
    public static PluginDescriptor getPluginDescriptorOrPlatformByClassName(@NotNull String className2) {
        List<IdeaPluginDescriptorImpl> loadedPlugins;
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        if ((loadedPlugins = ourLoadedPlugins) == null || className2.startsWith("java.") || className2.startsWith("javax.") || className2.startsWith("kotlin.") || className2.startsWith("groovy.")) {
            return null;
        }
        PluginDescriptor result2 = null;
        for (IdeaPluginDescriptorImpl o : loadedPlugins) {
            ClassLoader classLoader = o.getPluginClassLoader();
            if (classLoader == null || !PluginManagerCore.hasLoadedClass(className2, classLoader)) continue;
            result2 = o;
            break;
        }
        if (result2 == null) {
            return null;
        }
        if (result2.getPluginId() != CORE_ID || className2.startsWith("com.jetbrains.") || className2.startsWith("org.jetbrains.") || className2.startsWith("com.intellij.") || className2.startsWith("org.intellij.") || className2.startsWith("com.android.") || className2.startsWith("git4idea.") || className2.startsWith("org.angularjs.")) {
            return result2;
        }
        String root2 = PathManager.getResourceRoot(result2.getPluginClassLoader(), "/" + className2.replace('.', '/') + ".class");
        if (root2 == null) {
            return null;
        }
        for (IdeaPluginDescriptorImpl o : loadedPlugins) {
            Path path2;
            if (!o.getUseIdeaClassLoader() || !root2.startsWith(FileUtilRt.toSystemIndependentName((path2 = o.getPluginPath()).toString()))) continue;
            result2 = o;
            break;
        }
        return result2;
    }

    private static boolean hasLoadedClass(@NotNull String className2, @NotNull ClassLoader loader) {
        if (className2 == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(38);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className2);
        }
        Class<?> aClass2 = loader.getClass();
        if (PluginManagerCore.isInstanceofUrlClassLoader(aClass2)) {
            try {
                return (Boolean)aClass2.getMethod("hasLoadedClass", String.class).invoke((Object)loader, className2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isInstanceofUrlClassLoader(Class<?> aClass2) {
        String urlClassLoaderName = UrlClassLoader.class.getName();
        while (aClass2 != null) {
            if (aClass2.getName().equals(urlClassLoaderName)) {
                return true;
            }
            aClass2 = aClass2.getSuperclass();
        }
        return false;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromDir(@NotNull Path file2, @NotNull String descriptorRelativePath, @Nullable Path pluginPath, @NotNull DescriptorLoadingContext context2) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        if (descriptorRelativePath == null) {
            PluginManagerCore.$$$reportNull$$$0(59);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        Path descriptorFile = file2.resolve(descriptorRelativePath);
        try {
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(pluginPath == null ? file2 : pluginPath, context2.isBundled);
            Element element = JDOMUtil.load(descriptorFile, context2.parentContext.getXmlFactory());
            descriptor2.readExternal(element, descriptorFile.getParent(), context2.pathResolver, context2, descriptor2);
            return descriptor2;
        }
        catch (NoSuchFileException e) {
            return null;
        }
        catch (SerializationException | IOException | JDOMException e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            context2.parentContext.result.reportCannotLoad(context2.parentContext, file2, e);
        }
        catch (Throwable e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            context2.parentContext.getLogger().warn("Cannot load " + descriptorFile, e);
        }
        return null;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl loadDescriptorFromJar(@NotNull Path file2, @NotNull String fileName, @NotNull PathBasedJdomXIncluder.PathResolver<?> pathResolver, @NotNull DescriptorLoadingContext context2, @Nullable Path pluginPath) {
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        if (pathResolver == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        if (context2 == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        SafeJdomFactory factory2 = context2.parentContext.getXmlFactory();
        try {
            Element element;
            Path metaInf = context2.open(file2).getPath("/META-INF", new String[0]);
            try {
                element = JDOMUtil.load(metaInf.resolve(fileName), factory2);
            }
            catch (NoSuchFileException ignore) {
                return null;
            }
            IdeaPluginDescriptorImpl descriptor2 = new IdeaPluginDescriptorImpl(pluginPath == null ? file2 : pluginPath, context2.isBundled);
            if (descriptor2.readExternal(element, metaInf, pathResolver, context2, descriptor2)) {
                descriptor2.jarFiles = Collections.singletonList(descriptor2.getPluginPath());
            }
            return descriptor2;
        }
        catch (InvalidDataException | SerializationException e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            context2.parentContext.result.reportCannotLoad(context2.parentContext, file2, e);
        }
        catch (Throwable e) {
            if (context2.isEssential) {
                ExceptionUtil.rethrow(e);
            }
            context2.parentContext.getLogger().info("Cannot load " + file2 + "!/META-INF/" + fileName, e);
        }
        return null;
    }

    @NotNull
    static BuildNumber getBuildNumber() {
        BuildNumber result2 = ourBuildNumber;
        if (result2 == null) {
            result2 = BuildNumber.fromString(PluginManagerCore.getPluginsCompatibleBuild());
            if (result2 == null) {
                if (isUnitTestMode) {
                    result2 = BuildNumber.currentVersion();
                } else {
                    try {
                        result2 = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException ignore) {
                        result2 = BuildNumber.currentVersion();
                    }
                }
            }
            ourBuildNumber = result2;
        }
        BuildNumber buildNumber = result2;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(118);
        }
        return buildNumber;
    }

    @Nullable
    static String isIncompatible(@NotNull BuildNumber buildNumber, @Nullable String sinceBuild, @Nullable String untilBuild) {
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(126);
        }
        try {
            BuildNumber untilBuildNumber;
            BuildNumber sinceBuildNumber;
            String message2 = null;
            BuildNumber buildNumber2 = sinceBuildNumber = sinceBuild == null ? null : BuildNumber.fromString(sinceBuild, null, null);
            if (sinceBuildNumber != null && sinceBuildNumber.compareTo(buildNumber) > 0) {
                message2 = "since build " + sinceBuildNumber + " > " + buildNumber;
            }
            BuildNumber buildNumber3 = untilBuildNumber = untilBuild == null ? null : BuildNumber.fromString(untilBuild, null, null);
            if (untilBuildNumber != null && untilBuildNumber.compareTo(buildNumber) < 0) {
                message2 = message2 == null ? "" : message2 + ", ";
                message2 = message2 + "until build " + untilBuildNumber + " < " + buildNumber;
            }
            return message2;
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().error(e);
            return "version check failed";
        }
    }

    public static void registerExtensionPointAndExtensions(@NotNull Path pluginRoot2, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor2;
        if (pluginRoot2 == null) {
            PluginManagerCore.$$$reportNull$$$0(147);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(148);
        }
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(149);
        }
        DescriptorListLoadingContext parentContext = DescriptorListLoadingContext.createSingleDescriptorContext(PluginManagerCore.disabledPlugins());
        try (DescriptorLoadingContext context2 = new DescriptorLoadingContext(parentContext, true, true, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);){
            descriptor2 = Files.isDirectory(pluginRoot2, new LinkOption[0]) ? PluginManagerCore.loadDescriptorFromDir(pluginRoot2, "META-INF/" + fileName, null, context2) : PluginManagerCore.loadDescriptorFromJar(pluginRoot2, fileName, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER, context2, null);
        }
        if (descriptor2 != null) {
            descriptor2.registerExtensionPoints((ExtensionsAreaImpl)area, ApplicationManager.getApplication());
            descriptor2.registerExtensions((ExtensionsAreaImpl)area, ApplicationManager.getApplication(), false);
        } else {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot2);
        }
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(150);
        }
        return logger;
    }

    static {
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 44: 
            case 85: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 117: 
            case 118: 
            case 134: 
            case 136: 
            case 146: 
            case 150: 
            case 161: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 44: 
            case 85: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 117: 
            case 118: 
            case 134: 
            case 136: 
            case 146: 
            case 150: 
            case 161: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 44: 
            case 85: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 117: 
            case 118: 
            case 134: 
            case 136: 
            case 146: 
            case 150: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 6: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 7: 
            case 27: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 13: 
            case 14: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 15: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 114: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 137: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 19: 
            case 21: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 20: 
            case 45: 
            case 58: 
            case 61: 
            case 65: 
            case 67: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 115: 
            case 138: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 38: 
            case 84: 
            case 88: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlLoaderBuilder";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoaders";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 48: 
            case 57: 
            case 83: 
            case 121: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 53: 
            case 55: 
            case 119: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDescriptorMap";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorRelativePath";
                break;
            }
            case 60: 
            case 64: 
            case 71: 
            case 74: 
            case 79: 
            case 87: 
            case 101: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 62: 
            case 66: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentContext";
                break;
            }
            case 70: 
            case 73: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathName";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDir";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesInLibUnderPluginDir";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledIds";
                break;
            }
            case 81: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledRequiredIds";
                break;
            }
            case 82: 
            case 110: 
            case 113: 
            case 120: 
            case 127: 
            case 139: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 86: 
            case 89: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingContext";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreClassLoader";
                break;
            }
            case 109: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledPlugins";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedDescriptor";
                break;
            }
            case 112: 
            case 116: 
            case 152: 
            case 154: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 129: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 131: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedIds";
                break;
            }
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 153: 
            case 156: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 155: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToMap";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProcessed";
                break;
            }
            case 162: 
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 164: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIds";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "disabledPlugins";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginClassLoader";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToFile";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUncachedDescriptors";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrScheduleLoading";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPluginRawList";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "initPlugins";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDescriptors";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrlClassLoaderBuilder";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumber";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopologicallySorted";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPluginIdMap";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableName";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnlyEnabledPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledPluginListener";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 44: 
            case 85: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 117: 
            case 118: 
            case 134: 
            case 136: 
            case 146: 
            case 150: 
            case 161: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doSetPlugins";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadDisabledPlugins";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsList";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "trySaveDisabledPlugins";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createPluginException";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorOrPlatformByClassName";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitDependency";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassLoader";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "localFileToUrl";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "logPlugins";
                break;
            }
            case 48: 
            case 49: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "prepareLoadingPluginsErrorMessage";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingError";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getFirstDisabledDependency";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findErrorForPlugin";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createPluginIdGraph";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkPluginCycles";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDir";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromJar";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptor";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromFileOrDir";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromDirAndNormalize";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "putMoreLikelyPluginJarsFirst";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "fileNameIsLikeVersionedLibraryName";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromDir";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromClassPath";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "computePlatformPluginUrlAndCollectPluginUrls";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "collectPluginFilesInClassPath";
                break;
            }
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromResource";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "urlToFile";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorsFromProperty";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "initPlugins";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfigs";
                break;
            }
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalDescriptors";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "isOptional";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "initClassLoader";
                break;
            }
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "disableIncompatiblePlugins";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "checkEssentialPluginsAreAvailable";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "initializePlugins";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "configureClassLoaders";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getTopologicallySorted";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "buildPluginIdMap";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "checkAndPut";
                break;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "computePluginEnabled";
                break;
            }
            case 147: 
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "findPluginByModuleDependency";
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "processAllDependencies";
                break;
            }
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatedBundledPlugin";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 44: 
            case 85: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 117: 
            case 118: 
            case 134: 
            case 136: 
            case 146: 
            case 150: 
            case 161: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

