/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.AbstractVariableRemapper;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionWithCopy;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\fH\u0002J\u000e\u0010\r\u001a\u0004\u0018\u00010\f*\u00020\u000eH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\fH\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\fH\u0002J\"\u0010\u0013\u001a\u00020\f*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0002J\u001c\u0010\u0013\u001a\u00020\f*\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/IfNullExpressionsFusionLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "copyIfTrivial", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getElseBranchResultOrNull", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "isTrivial", "", "matchIfNullExpr", "Lorg/jetbrains/kotlin/backend/common/lower/IfNullExpressionsFusionLowering$IfNullExpr;", "remap", "from", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "to", "Lkotlin/Lazy;", "IfNullExpr", "Transformer", "ir.backend.common"})
public final class IfNullExpressionsFusionLowering
implements FileLoweringPass {
    private final CommonBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new Transformer(irFile));
    }

    private final IfNullExpr matchIfNullExpr(IrExpression $this$matchIfNullExpr) {
        if (!($this$matchIfNullExpr instanceof IrBlock)) {
            return null;
        }
        if (((IrBlock)$this$matchIfNullExpr).getStatements().size() != 2) {
            return null;
        }
        IrStatement irStatement = ((IrBlock)$this$matchIfNullExpr).getStatements().get(0);
        if (!(irStatement instanceof IrVariable)) {
            irStatement = null;
        }
        IrVariable irVariable2 = (IrVariable)irStatement;
        if (irVariable2 == null) {
            return null;
        }
        IrVariable subjectVar = irVariable2;
        if (subjectVar.isVar()) {
            return null;
        }
        if (subjectVar.getInitializer() == null) {
            return null;
        }
        IrStatement irStatement2 = ((IrBlock)$this$matchIfNullExpr).getStatements().get(1);
        if (!(irStatement2 instanceof IrWhen)) {
            irStatement2 = null;
        }
        IrWhen irWhen = (IrWhen)irStatement2;
        if (irWhen == null) {
            return null;
        }
        IrWhen whenExpr = irWhen;
        if (whenExpr.getBranches().size() != 2) {
            return null;
        }
        IrBranch branch0 = whenExpr.getBranches().get(0);
        IrExpression irExpression = branch0.getCondition();
        if (!(irExpression instanceof IrCall)) {
            irExpression = null;
        }
        IrCall irCall = (IrCall)irExpression;
        if (irCall == null) {
            return null;
        }
        IrCall condition0 = irCall;
        if (Intrinsics.areEqual(condition0.getSymbol(), this.context.getIrBuiltIns().getEqeqSymbol()) ^ true) {
            return null;
        }
        IrExpression irExpression2 = condition0.getValueArgument(0);
        if (!(irExpression2 instanceof IrGetValue)) {
            irExpression2 = null;
        }
        IrGetValue irGetValue = (IrGetValue)irExpression2;
        if (irGetValue == null) {
            return null;
        }
        IrGetValue arg0 = irGetValue;
        if (Intrinsics.areEqual(arg0.getSymbol(), (IrVariableSymbol)subjectVar.getSymbol()) ^ true) {
            return null;
        }
        IrExpression irExpression3 = condition0.getValueArgument(1);
        if (!(irExpression3 instanceof IrConst)) {
            irExpression3 = null;
        }
        IrConst irConst = (IrConst)irExpression3;
        if (irConst == null) {
            return null;
        }
        IrConst arg1 = irConst;
        if (arg1.getValue() != null) {
            return null;
        }
        IrExpression irExpression4 = this.getElseBranchResultOrNull(whenExpr.getBranches().get(1));
        if (irExpression4 == null) {
            return null;
        }
        IrExpression elseResult = irExpression4;
        return new IfNullExpr(whenExpr.getType(), subjectVar, branch0.getResult(), elseResult);
    }

    private final IrExpression getElseBranchResultOrNull(IrBranch $this$getElseBranchResultOrNull) {
        IrExpression branchCondition = $this$getElseBranchResultOrNull.getCondition();
        return branchCondition instanceof IrConst && Intrinsics.areEqual(((IrConst)branchCondition).getValue(), true) ? $this$getElseBranchResultOrNull.getResult() : null;
    }

    private final boolean isTrivial(IrExpression $this$isTrivial) {
        return $this$isTrivial instanceof IrExpressionWithCopy;
    }

    private final IrExpression copyIfTrivial(IrExpression $this$copyIfTrivial) {
        return $this$copyIfTrivial instanceof IrExpressionWithCopy ? ((IrExpressionWithCopy)((Object)$this$copyIfTrivial)).copy() : $this$copyIfTrivial;
    }

    private final IrExpression remap(IrExpression $this$remap, IrVariable from, Lazy<? extends IrVariable> to) {
        return this.copyIfTrivial($this$remap).transform((IrElementTransformer)new AbstractVariableRemapper(from, to){
            final /* synthetic */ IrVariable $from;
            final /* synthetic */ Lazy $to;

            @Nullable
            protected IrValueDeclaration remapVariable(@NotNull IrValueDeclaration value2) {
                Intrinsics.checkNotNullParameter(value2, "value");
                return Intrinsics.areEqual(value2.getSymbol(), (IrVariableSymbol)this.$from.getSymbol()) ? (IrVariable)this.$to.getValue() : null;
            }
            {
                this.$from = $captured_local_variable$0;
                this.$to = $captured_local_variable$1;
            }
        }, (Object)null);
    }

    private final IrExpression remap(IrExpression $this$remap, IrVariable from, IrExpression to) {
        IrExpression irExpression;
        if ($this$remap instanceof IrGetValue && Intrinsics.areEqual(((IrGetValue)$this$remap).getSymbol(), (IrVariableSymbol)from.getSymbol())) {
            irExpression = to;
        } else if ($this$remap instanceof IrTypeOperatorCall) {
            irExpression = new IrTypeOperatorCallImpl($this$remap.getStartOffset(), $this$remap.getEndOffset(), $this$remap.getType(), ((IrTypeOperatorCall)$this$remap).getOperator(), ((IrTypeOperatorCall)$this$remap).getTypeOperand(), this.remap(((IrTypeOperatorCall)$this$remap).getArgument(), from, to));
        } else {
            IrDeclarationParent irDeclarationParent = from.getParent();
            if (irDeclarationParent == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            }
            IrBuilderWithScope $this$irBlock$iv = LowerUtilsKt.createIrBuilder(this.context, ((IrSymbolOwner)((Object)irDeclarationParent)).getSymbol(), $this$remap.getStartOffset(), $this$remap.getEndOffset());
            int startOffset$iv = $this$irBlock$iv.getStartOffset();
            int endOffset$iv = $this$irBlock$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            IrBlockBuilder $this$irBlock = this_$iv$iv;
            boolean bl = false;
            $this$irBlock.unaryPlus(this.remap($this$remap, from, LazyKt.lazy((Function0)new Function0<IrVariable>($this$irBlock, this, $this$remap, from, to){
                final /* synthetic */ IrBlockBuilder $this_irBlock;
                final /* synthetic */ IfNullExpressionsFusionLowering this$0;
                final /* synthetic */ IrExpression $this_remap$inlined;
                final /* synthetic */ IrVariable $from$inlined;
                final /* synthetic */ IrExpression $to$inlined;
                {
                    this.$this_irBlock = irBlockBuilder;
                    this.this$0 = ifNullExpressionsFusionLowering;
                    this.$this_remap$inlined = irExpression;
                    this.$from$inlined = irVariable2;
                    this.$to$inlined = irExpression2;
                    super(0);
                }

                @NotNull
                public final IrVariable invoke() {
                    return IrBuildersKt.createTmpVariable$default(this.$this_irBlock, this.$to$inlined, null, false, null, null, 30, null);
                }
            })));
            IrContainerExpression irContainerExpression = this_$iv$iv.doBuild();
            boolean bl2 = false;
            boolean bl3 = false;
            IrContainerExpression it = irContainerExpression;
            boolean bl4 = false;
            irExpression = (IrExpression)CollectionsKt.singleOrNull(it.getStatements());
            if (irExpression == null) {
                irExpression = it;
            }
        }
        return irExpression;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public IfNullExpressionsFusionLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\u0006*\u00020\bH\u0002J#\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0012J\f\u0010\u0013\u001a\u00020\u000e*\u00020\u0014H\u0002J#\u0010\u0015\u001a\u00020\u0006*\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/IfNullExpressionsFusionLowering$Transformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "currentFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/backend/common/lower/IfNullExpressionsFusionLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "createIrBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "Lorg/jetbrains/kotlin/backend/common/lower/IfNullExpressionsFusionLowering$IfNullExpr;", "fuseIfNull", "isNull", "", "knownVariableSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrVariableSymbol;", "knownVariableIsNull", "(Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/symbols/IrVariableSymbol;Z)Ljava/lang/Boolean;", "isStableCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "substitute", "subject", "knownNullability", "(Lorg/jetbrains/kotlin/backend/common/lower/IfNullExpressionsFusionLowering$IfNullExpr;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Ljava/lang/Boolean;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.backend.common"})
    private final class Transformer
    extends IrElementTransformerVoid {
        private final IrFile currentFile;

        @Override
        @NotNull
        public IrExpression visitBlock(@NotNull IrBlock expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            return this.visitExpression(this.fuseIfNull(expression2));
        }

        private final IrExpression fuseIfNull(IrBlock $this$fuseIfNull) {
            IfNullExpr ifNullExpr = IfNullExpressionsFusionLowering.this.matchIfNullExpr($this$fuseIfNull);
            if (ifNullExpr == null) {
                return $this$fuseIfNull;
            }
            IfNullExpr outer = ifNullExpr;
            if (Intrinsics.areEqual(outer.getSubjectVar().getOrigin(), IrDeclarationOrigin.IR_TEMPORARY_VARIABLE.INSTANCE) ^ true) {
                return $this$fuseIfNull;
            }
            Object object = outer.getSubjectVar().getInitializer();
            if (object == null || (object = IfNullExpressionsFusionLowering.this.matchIfNullExpr((IrExpression)object)) == null) {
                return $this$fuseIfNull;
            }
            Object inner = object;
            Boolean innerKeepsNull = this.isNull(((IfNullExpr)inner).getIfNullExpr(), (IrVariableSymbol)((IfNullExpr)inner).getSubjectVar().getSymbol(), true);
            Boolean innerDiscardsNonNull = this.isNull(((IfNullExpr)inner).getIfNotNullExpr(), (IrVariableSymbol)((IfNullExpr)inner).getSubjectVar().getSymbol(), false);
            if (!IfNullExpressionsFusionLowering.this.isTrivial(outer.getIfNotNullExpr()) && Intrinsics.areEqual(innerKeepsNull, true) ^ true && Intrinsics.areEqual(innerDiscardsNonNull, true) ^ true || !IfNullExpressionsFusionLowering.this.isTrivial(outer.getIfNullExpr()) && Intrinsics.areEqual(innerKeepsNull, false) ^ true && Intrinsics.areEqual(innerDiscardsNonNull, false) ^ true) {
                return $this$fuseIfNull;
            }
            IrBuilderWithScope $this$irBlock$iv = this.createIrBuilder((IfNullExpr)inner);
            int startOffset$iv = $this$irBlock$iv.getStartOffset();
            int endOffset$iv = $this$irBlock$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            IrBlockBuilder $this$irBlock = this_$iv$iv;
            boolean bl = false;
            IrExpression ifNull2 = this.substitute(outer, ((IfNullExpr)inner).getIfNullExpr(), innerKeepsNull);
            IrExpression ifNotNull2 = this.substitute(outer, ((IfNullExpr)inner).getIfNotNullExpr(), innerDiscardsNonNull);
            $this$irBlock.unaryPlus(((IfNullExpr)inner).getSubjectVar());
            $this$irBlock.unaryPlus(ExpressionHelpersKt.irIfNull($this$irBlock, outer.getType(), ExpressionHelpersKt.irGet($this$irBlock, ((IfNullExpr)inner).getSubjectVar()), ifNull2, ifNotNull2));
            return this_$iv$iv.doBuild();
        }

        private final IrExpression substitute(IfNullExpr $this$substitute, IrExpression subject, Boolean knownNullability) {
            IrExpression irExpression;
            Boolean bl = knownNullability;
            if (bl == null) {
                IrBuilderWithScope $this$irBlock$iv = this.createIrBuilder($this$substitute);
                int startOffset$iv = $this$irBlock$iv.getStartOffset();
                int endOffset$iv = $this$irBlock$iv.getEndOffset();
                IrStatementOrigin origin$iv = null;
                IrType resultType$iv = null;
                boolean $i$f$irBlock = false;
                IrBlockBuilder this_$iv$iv = new IrBlockBuilder($this$irBlock$iv.getContext(), $this$irBlock$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                boolean $i$f$block = false;
                IrBlockBuilder $this$irBlock = this_$iv$iv;
                boolean bl2 = false;
                IrVariable tmp = IrBuildersKt.createTmpVariable$default($this$irBlock, subject, null, false, null, null, 30, null);
                IrExpression ifNull2 = IfNullExpressionsFusionLowering.this.remap($this$substitute.getIfNullExpr(), $this$substitute.getSubjectVar(), LazyKt.lazy((Function0)new Function0<IrVariable>(tmp){
                    final /* synthetic */ IrVariable $tmp;

                    @NotNull
                    public final IrVariable invoke() {
                        return this.$tmp;
                    }
                    {
                        this.$tmp = irVariable2;
                        super(0);
                    }
                }));
                IrExpression ifNotNull2 = IfNullExpressionsFusionLowering.this.remap($this$substitute.getIfNotNullExpr(), $this$substitute.getSubjectVar(), LazyKt.lazy((Function0)new Function0<IrVariable>(tmp){
                    final /* synthetic */ IrVariable $tmp;

                    @NotNull
                    public final IrVariable invoke() {
                        return this.$tmp;
                    }
                    {
                        this.$tmp = irVariable2;
                        super(0);
                    }
                }));
                $this$irBlock.unaryPlus(ExpressionHelpersKt.irIfNull($this$irBlock, $this$substitute.getType(), ExpressionHelpersKt.irGet($this$irBlock, tmp), ifNull2, ifNotNull2));
                irExpression = this_$iv$iv.doBuild();
            } else {
                irExpression = Intrinsics.areEqual(bl, true) ? IfNullExpressionsFusionLowering.this.remap($this$substitute.getIfNullExpr(), $this$substitute.getSubjectVar(), subject) : IfNullExpressionsFusionLowering.this.remap($this$substitute.getIfNotNullExpr(), $this$substitute.getSubjectVar(), subject);
            }
            return irExpression;
        }

        private final DeclarationIrBuilder createIrBuilder(IfNullExpr $this$createIrBuilder) {
            IrDeclarationParent irDeclarationParent = $this$createIrBuilder.getSubjectVar().getParent();
            if (irDeclarationParent == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
            }
            return LowerUtilsKt.createIrBuilder(IfNullExpressionsFusionLowering.this.getContext(), ((IrSymbolOwner)((Object)irDeclarationParent)).getSymbol(), $this$createIrBuilder.getSubjectVar().getStartOffset(), $this$createIrBuilder.getSubjectVar().getEndOffset());
        }

        private final Boolean isNull(IrExpression $this$isNull, IrVariableSymbol knownVariableSymbol, boolean knownVariableIsNull) {
            IrExpression irExpression = $this$isNull;
            if (irExpression instanceof IrConst) {
                return ((IrConst)$this$isNull).getValue() == null;
            }
            if (irExpression instanceof IrGetValue) {
                if (Intrinsics.areEqual(((IrGetValue)$this$isNull).getSymbol(), knownVariableSymbol)) {
                    return knownVariableIsNull;
                }
                if (!IrTypeUtilsKt.isNullable($this$isNull.getType())) {
                    return false;
                }
            } else {
                if (irExpression instanceof IrConstructorCall || irExpression instanceof IrGetSingletonValue || irExpression instanceof IrFunctionExpression || irExpression instanceof IrCallableReference || irExpression instanceof IrClassReference || irExpression instanceof IrGetClass) {
                    return false;
                }
                if (irExpression instanceof IrCall && !IrTypeUtilsKt.isNullable($this$isNull.getType()) && this.isStableCall((IrCall)$this$isNull)) {
                    return false;
                }
            }
            return null;
        }

        private final boolean isStableCall(IrCall $this$isStableCall) {
            return Intrinsics.areEqual(IrUtilsKt.getFileOrNull((IrDeclaration)$this$isStableCall.getSymbol().getOwner()), this.currentFile);
        }

        public Transformer(IrFile currentFile) {
            Intrinsics.checkNotNullParameter(currentFile, "currentFile");
            this.currentFile = currentFile;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/IfNullExpressionsFusionLowering$IfNullExpr;", "", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "subjectVar", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "ifNullExpr", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ifNotNullExpr", "(Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/declarations/IrVariable;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getIfNotNullExpr", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getIfNullExpr", "getSubjectVar", "()Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "ir.backend.common"})
    private static final class IfNullExpr {
        private final IrType type;
        private final IrVariable subjectVar;
        private final IrExpression ifNullExpr;
        private final IrExpression ifNotNullExpr;

        @NotNull
        public final IrType getType() {
            return this.type;
        }

        @NotNull
        public final IrVariable getSubjectVar() {
            return this.subjectVar;
        }

        @NotNull
        public final IrExpression getIfNullExpr() {
            return this.ifNullExpr;
        }

        @NotNull
        public final IrExpression getIfNotNullExpr() {
            return this.ifNotNullExpr;
        }

        public IfNullExpr(@NotNull IrType type2, @NotNull IrVariable subjectVar, @NotNull IrExpression ifNullExpr, @NotNull IrExpression ifNotNullExpr) {
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(subjectVar, "subjectVar");
            Intrinsics.checkNotNullParameter(ifNullExpr, "ifNullExpr");
            Intrinsics.checkNotNullParameter(ifNotNullExpr, "ifNotNullExpr");
            this.type = type2;
            this.subjectVar = subjectVar;
            this.ifNullExpr = ifNullExpr;
            this.ifNotNullExpr = ifNotNullExpr;
        }
    }
}

