/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ReferencingToUnderscoreNamedParameterOfCatchBlockChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ReferencingToUnderscoreNamedParameterOfCatchBlockChecker
implements CallChecker {
    @NotNull
    public static final ReferencingToUnderscoreNamedParameterOfCatchBlockChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        if (!(descriptor2 instanceof LocalVariableDescriptor) || !DescriptorUtilsKt.isUnderscoreNamed((VariableDescriptor)descriptor2)) {
            return;
        }
        SourceElement sourceElement = ((LocalVariableDescriptor)descriptor2).getSource();
        if (!(sourceElement instanceof KotlinSourceElement)) {
            sourceElement = null;
        }
        KotlinSourceElement kotlinSourceElement = (KotlinSourceElement)sourceElement;
        if (kotlinSourceElement == null) {
            return;
        }
        KotlinSourceElement sourceElement2 = kotlinSourceElement;
        KtElement ktElement = sourceElement2.getPsi();
        if (!(ktElement instanceof KtParameter)) {
            ktElement = null;
        }
        KtParameter ktParameter = (KtParameter)ktElement;
        if (ktParameter == null) {
            return;
        }
        KtParameter ktParameter2 = ktParameter;
        if (ktParameter2.isCatchParameter()) {
            BindingTrace bindingTrace = context2.getTrace();
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.RESOLVED_TO_UNDERSCORE_NAMED_CATCH_PARAMETER.on(reportOn);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, "Errors.RESOLVED_TO_UNDER\u2026CH_PARAMETER.on(reportOn)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }

    private ReferencingToUnderscoreNamedParameterOfCatchBlockChecker() {
    }

    static {
        ReferencingToUnderscoreNamedParameterOfCatchBlockChecker referencingToUnderscoreNamedParameterOfCatchBlockChecker;
        INSTANCE = referencingToUnderscoreNamedParameterOfCatchBlockChecker = new ReferencingToUnderscoreNamedParameterOfCatchBlockChecker();
    }
}

