/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.map;

import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.map.WorldRegion;
import net.osmand.util.Algorithms;
import net.osmand.util.MapAlgorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class OsmandRegions {
    public static final String MAP_TYPE = "region_map";
    public static final String FIELD_DOWNLOAD_NAME = "download_name";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_NAME_EN = "name:en";
    public static final String FIELD_REGION_PARENT_NAME = "region_parent_name";
    public static final String FIELD_REGION_FULL_NAME = "region_full_name";
    public static final String FIELD_LANG = "region_lang";
    public static final String FIELD_METRIC = "region_metric";
    public static final String FIELD_ROAD_SIGNS = "region_road_signs";
    public static final String FIELD_LEFT_HAND_DRIVING = "region_left_hand_navigation";
    public static final String FIELD_WIKI_LINK = "region_wiki_link";
    public static final String FIELD_POPULATION = "region_population";
    private BinaryMapIndexReader reader;
    private String locale = "en";
    private static final Log LOG = PlatformUtil.getLog(OsmandRegions.class);
    WorldRegion worldRegion = new WorldRegion("world");
    Map<String, WorldRegion> fullNamesToRegionData = new HashMap<String, WorldRegion>();
    Map<String, String> downloadNamesToFullNames = new HashMap<String, String>();
    Map<String, LinkedList<BinaryMapDataObject>> countriesByDownloadName = new HashMap<String, LinkedList<BinaryMapDataObject>>();
    QuadTree<String> quadTree;
    MapIndexFields mapIndexFields;
    RegionTranslation translator;

    public void setTranslator(RegionTranslation translator) {
        this.translator = translator;
    }

    public void prepareFile(String fileName) throws IOException {
        this.reader = new BinaryMapIndexReader(new RandomAccessFile(fileName, "r"), new File(fileName));
        final LinkedHashMap parentRelations = new LinkedHashMap();
        ResultMatcher<BinaryMapDataObject> resultMatcher = new ResultMatcher<BinaryMapDataObject>(){

            @Override
            public boolean publish(BinaryMapDataObject object) {
                OsmandRegions.this.initTypes(object);
                int[] types = object.getTypes();
                for (int i = 0; i < types.length; ++i) {
                    BinaryMapIndexReader.TagValuePair tp = object.getMapIndex().decodeType(types[i]);
                    if (!"boundary".equals(tp.value)) continue;
                    return false;
                }
                WorldRegion rd = OsmandRegions.this.initRegionData(parentRelations, object);
                if (rd == null) {
                    return false;
                }
                if (rd.regionDownloadName != null) {
                    OsmandRegions.this.downloadNamesToFullNames.put(rd.regionDownloadName, rd.regionFullName);
                }
                OsmandRegions.this.fullNamesToRegionData.put(rd.regionFullName, rd);
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
        this.iterateOverAllObjects(resultMatcher);
        for (Map.Entry e : parentRelations.entrySet()) {
            String fullName = (String)e.getKey();
            String parentFullName = (String)e.getValue();
            WorldRegion rd = this.fullNamesToRegionData.get(fullName);
            WorldRegion parent = this.fullNamesToRegionData.get(parentFullName);
            if (parent == null || rd == null) continue;
            parent.addSubregion(rd);
        }
        this.structureWorldRegions(new ArrayList<WorldRegion>(this.fullNamesToRegionData.values()));
    }

    public boolean containsCountry(String name) {
        return this.countriesByDownloadName.containsKey(name);
    }

    public String getLocaleName(String downloadName, boolean includingParent) {
        String lc = downloadName.toLowerCase();
        if (this.downloadNamesToFullNames.containsKey(lc)) {
            String fullName = this.downloadNamesToFullNames.get(lc);
            return this.getLocaleNameByFullName(fullName, includingParent);
        }
        return downloadName.replace('_', ' ');
    }

    public String getLocaleNameByFullName(String fullName, boolean includingParent) {
        WorldRegion rd = this.fullNamesToRegionData.get(fullName);
        if (rd == null) {
            return fullName.replace('_', ' ');
        }
        if (includingParent && rd.getSuperregion() != null && rd.getSuperregion().getSuperregion() != null) {
            WorldRegion parentParent = rd.getSuperregion().getSuperregion();
            WorldRegion parent = rd.getSuperregion();
            if (parentParent.getRegionId().equals("world") && !parent.getRegionId().equals("russia")) {
                return rd.getLocaleName();
            }
            if (parentParent.getRegionId().equals("russia")) {
                return parentParent.getLocaleName() + " " + rd.getLocaleName();
            }
            if (parentParent.getRegionId().equals("japan_asia")) {
                return parentParent.getLocaleName() + " " + rd.getLocaleName();
            }
            return parent.getLocaleName() + " " + rd.getLocaleName();
        }
        return rd.getLocaleName();
    }

    public WorldRegion getWorldRegion() {
        return this.worldRegion;
    }

    public boolean isInitialized() {
        return this.reader != null;
    }

    public boolean contain(BinaryMapDataObject bo, int tx, int ty) {
        int t = 0;
        for (int i = 1; i < bo.getPointsLength(); ++i) {
            int fx = MapAlgorithms.ray_intersect_x(bo.getPoint31XTile(i - 1), bo.getPoint31YTile(i - 1), bo.getPoint31XTile(i), bo.getPoint31YTile(i), ty);
            if (Integer.MIN_VALUE == fx || tx < fx) continue;
            ++t;
        }
        return t % 2 == 1;
    }

    public boolean intersect(BinaryMapDataObject bo, int lx, int ty, int rx, int by) {
        if (this.contain(bo, lx, ty)) {
            return true;
        }
        if (bo.getPointsLength() == 0) {
            return false;
        }
        if (bo.getPoint31XTile(0) >= lx && bo.getPoint31XTile(0) <= rx && bo.getPoint31YTile(0) >= ty && bo.getPoint31YTile(0) <= by) {
            return true;
        }
        for (int i = 1; i < bo.getPointsLength(); ++i) {
            long in;
            int px = bo.getPoint31XTile(i - 1);
            int x = bo.getPoint31XTile(i);
            int py = bo.getPoint31YTile(i - 1);
            int y = bo.getPoint31YTile(i);
            if (x < lx && px < lx || x > rx && px > rx || y > by && py > by || y < ty && py < ty || (in = MapAlgorithms.calculateIntersection(px, py, x, y, lx, rx, by, ty)) == -1L) continue;
            return true;
        }
        return false;
    }

    private List<BinaryMapDataObject> getCountries(int tile31x, int tile31y) {
        HashSet<String> set = new HashSet<String>(this.quadTree.queryInBox(new QuadRect(tile31x, tile31y, tile31x, tile31y), new ArrayList()));
        ArrayList<BinaryMapDataObject> result = new ArrayList<BinaryMapDataObject>();
        for (String cname : set) {
            BinaryMapDataObject container = null;
            int count = 0;
            for (BinaryMapDataObject bo : this.countriesByDownloadName.get(cname)) {
                if (!this.contain(bo, tile31x, tile31y)) continue;
                ++count;
                container = bo;
                break;
            }
            if (count % 2 != 1) continue;
            result.add(container);
        }
        return result;
    }

    public List<BinaryMapDataObject> query(int tile31x, int tile31y) throws IOException {
        if (this.quadTree != null) {
            return this.getCountries(tile31x, tile31y);
        }
        return this.queryNoInit(tile31x, tile31y);
    }

    private synchronized List<BinaryMapDataObject> queryNoInit(final int tile31x, final int tile31y) throws IOException {
        final ArrayList<BinaryMapDataObject> result = new ArrayList<BinaryMapDataObject>();
        BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> sr = BinaryMapIndexReader.buildSearchRequest(tile31x, tile31x, tile31y, tile31y, 5, new BinaryMapIndexReader.SearchFilter(){

            @Override
            public boolean accept(TIntArrayList types, BinaryMapIndexReader.MapIndex index) {
                return true;
            }
        }, new ResultMatcher<BinaryMapDataObject>(){

            @Override
            public boolean publish(BinaryMapDataObject object) {
                if (object.getPointsLength() < 1) {
                    return false;
                }
                OsmandRegions.this.initTypes(object);
                if (OsmandRegions.this.contain(object, tile31x, tile31y)) {
                    result.add(object);
                }
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
        if (this.reader != null) {
            this.reader.searchMapIndex(sr);
        }
        return result;
    }

    public synchronized List<BinaryMapDataObject> queryBbox(int lx, int rx, int ty, int by) throws IOException {
        final ArrayList<BinaryMapDataObject> result = new ArrayList<BinaryMapDataObject>();
        BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> sr = BinaryMapIndexReader.buildSearchRequest(lx, rx, ty, by, 5, new BinaryMapIndexReader.SearchFilter(){

            @Override
            public boolean accept(TIntArrayList types, BinaryMapIndexReader.MapIndex index) {
                return true;
            }
        }, new ResultMatcher<BinaryMapDataObject>(){

            @Override
            public boolean publish(BinaryMapDataObject object) {
                if (object.getPointsLength() < 1) {
                    return false;
                }
                OsmandRegions.this.initTypes(object);
                result.add(object);
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        });
        sr.log = false;
        if (this.reader != null) {
            this.reader.searchMapIndex(sr);
        }
        return result;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public WorldRegion getRegionData(String fullname) {
        return this.fullNamesToRegionData.get(fullname);
    }

    public WorldRegion getRegionDataByDownloadName(String downloadName) {
        return this.getRegionData(this.downloadNamesToFullNames.get(downloadName.toLowerCase()));
    }

    public String getDownloadName(BinaryMapDataObject o) {
        return this.mapIndexFields.get(this.mapIndexFields.downloadNameType, o);
    }

    public String getFullName(BinaryMapDataObject o) {
        return this.mapIndexFields.get(this.mapIndexFields.fullNameType, o);
    }

    public List<WorldRegion> getAllRegionData() {
        return new ArrayList<WorldRegion>(this.fullNamesToRegionData.values());
    }

    private WorldRegion initRegionData(Map<String, String> parentRelations, BinaryMapDataObject object) {
        String regionDownloadName = this.mapIndexFields.get(this.mapIndexFields.downloadNameType, object);
        String regionFullName = this.mapIndexFields.get(this.mapIndexFields.fullNameType, object);
        if (Algorithms.isEmpty(regionFullName)) {
            return null;
        }
        WorldRegion rd = new WorldRegion(regionFullName, regionDownloadName);
        double cx = 0.0;
        double cy = 0.0;
        for (int i = 0; i < object.getPointsLength(); ++i) {
            cx += (double)object.getPoint31XTile(i);
            cy += (double)object.getPoint31YTile(i);
        }
        if (object.getPointsLength() > 0) {
            rd.regionCenter = new LatLon(MapUtils.get31LatitudeY((int)(cy /= (double)object.getPointsLength())), MapUtils.get31LongitudeX((int)(cx /= (double)object.getPointsLength())));
        }
        rd.regionParentFullName = this.mapIndexFields.get(this.mapIndexFields.parentFullName, object);
        if (!Algorithms.isEmpty(rd.regionParentFullName)) {
            parentRelations.put(rd.regionFullName, rd.regionParentFullName);
        }
        rd.regionName = this.mapIndexFields.get(this.mapIndexFields.nameType, object);
        rd.regionNameLocale = this.mapIndexFields.get(this.mapIndexFields.nameLocaleType, object);
        rd.regionNameEn = this.mapIndexFields.get(this.mapIndexFields.nameEnType, object);
        rd.params.regionLang = this.mapIndexFields.get(this.mapIndexFields.langType, object);
        rd.params.regionLeftHandDriving = this.mapIndexFields.get(this.mapIndexFields.leftHandDrivingType, object);
        rd.params.regionMetric = this.mapIndexFields.get(this.mapIndexFields.metricType, object);
        rd.params.regionRoadSigns = this.mapIndexFields.get(this.mapIndexFields.roadSignsType, object);
        rd.params.wikiLink = this.mapIndexFields.get(this.mapIndexFields.wikiLinkType, object);
        rd.params.population = this.mapIndexFields.get(this.mapIndexFields.populationType, object);
        rd.regionSearchText = this.getSearchIndex(object);
        rd.regionMapDownload = this.isDownloadOfType(object, MAP_TYPE);
        return rd;
    }

    private String getSearchIndex(BinaryMapDataObject object) {
        BinaryMapIndexReader.MapIndex mi = object.getMapIndex();
        TIntObjectIterator it = object.getObjectNames().iterator();
        StringBuilder ind = new StringBuilder();
        while (it.hasNext()) {
            String vl;
            it.advance();
            BinaryMapIndexReader.TagValuePair tp = mi.decodeType(it.key());
            if (!tp.tag.startsWith(FIELD_NAME) && !tp.tag.equals("key_name") || ind.indexOf(vl = ((String)it.value()).toLowerCase()) != -1) continue;
            ind.append(" ").append(vl);
        }
        return ind.toString();
    }

    public boolean isDownloadOfType(BinaryMapDataObject object, String type) {
        int[] addtypes = object.getAdditionalTypes();
        for (int i = 0; i < addtypes.length; ++i) {
            BinaryMapIndexReader.TagValuePair tp = object.getMapIndex().decodeType(addtypes[i]);
            if (!type.equals(tp.tag) || !"yes".equals(tp.value)) continue;
            return true;
        }
        return false;
    }

    public Map<String, LinkedList<BinaryMapDataObject>> cacheAllCountries() throws IOException {
        this.quadTree = new QuadTree(new QuadRect(0.0, 0.0, 2.147483647E9, 2.147483647E9), 8, 0.55f);
        ResultMatcher<BinaryMapDataObject> resultMatcher = new ResultMatcher<BinaryMapDataObject>(){

            @Override
            public boolean publish(BinaryMapDataObject object) {
                if (object.getPointsLength() < 1) {
                    return false;
                }
                OsmandRegions.this.initTypes(object);
                String nm = OsmandRegions.this.mapIndexFields.get(OsmandRegions.this.mapIndexFields.downloadNameType, object);
                if (!OsmandRegions.this.countriesByDownloadName.containsKey(nm)) {
                    LinkedList<BinaryMapDataObject> ls = new LinkedList<BinaryMapDataObject>();
                    OsmandRegions.this.countriesByDownloadName.put(nm, ls);
                    ls.add(object);
                } else {
                    OsmandRegions.this.countriesByDownloadName.get(nm).add(object);
                }
                int maxx = object.getPoint31XTile(0);
                int maxy = object.getPoint31YTile(0);
                int minx = maxx;
                int miny = maxy;
                for (int i = 1; i < object.getPointsLength(); ++i) {
                    int x = object.getPoint31XTile(i);
                    int y = object.getPoint31YTile(i);
                    if (y < miny) {
                        miny = y;
                    } else if (y > maxy) {
                        maxy = y;
                    }
                    if (x < minx) {
                        minx = x;
                        continue;
                    }
                    if (x <= maxx) continue;
                    maxx = x;
                }
                OsmandRegions.this.quadTree.insert(nm, new QuadRect(minx, miny, maxx, maxy));
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
        this.iterateOverAllObjects(resultMatcher);
        return this.countriesByDownloadName;
    }

    private synchronized void iterateOverAllObjects(ResultMatcher<BinaryMapDataObject> resultMatcher) throws IOException {
        BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> sr = BinaryMapIndexReader.buildSearchRequest(0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, 5, new BinaryMapIndexReader.SearchFilter(){

            @Override
            public boolean accept(TIntArrayList types, BinaryMapIndexReader.MapIndex index) {
                return true;
            }
        }, resultMatcher);
        if (this.reader != null) {
            this.reader.searchMapIndex(sr);
        }
    }

    private void initTypes(BinaryMapDataObject object) {
        if (this.mapIndexFields == null) {
            this.mapIndexFields = new MapIndexFields();
            this.mapIndexFields.downloadNameType = object.getMapIndex().getRule(FIELD_DOWNLOAD_NAME, null);
            this.mapIndexFields.nameType = object.getMapIndex().getRule(FIELD_NAME, null);
            this.mapIndexFields.nameEnType = object.getMapIndex().getRule(FIELD_NAME_EN, null);
            this.mapIndexFields.nameLocaleType = object.getMapIndex().getRule("name:" + this.locale, null);
            this.mapIndexFields.parentFullName = object.getMapIndex().getRule(FIELD_REGION_PARENT_NAME, null);
            this.mapIndexFields.fullNameType = object.getMapIndex().getRule(FIELD_REGION_FULL_NAME, null);
            this.mapIndexFields.langType = object.getMapIndex().getRule(FIELD_LANG, null);
            this.mapIndexFields.metricType = object.getMapIndex().getRule(FIELD_METRIC, null);
            this.mapIndexFields.leftHandDrivingType = object.getMapIndex().getRule(FIELD_LEFT_HAND_DRIVING, null);
            this.mapIndexFields.roadSignsType = object.getMapIndex().getRule(FIELD_ROAD_SIGNS, null);
            this.mapIndexFields.wikiLinkType = object.getMapIndex().getRule(FIELD_WIKI_LINK, null);
            this.mapIndexFields.populationType = object.getMapIndex().getRule(FIELD_POPULATION, null);
            this.mapIndexFields.nameType = object.getMapIndex().getRule(FIELD_NAME, null);
        }
    }

    private static void testCountry(OsmandRegions or, double lat, double lon, String ... test) throws IOException {
        long t = System.currentTimeMillis();
        List<BinaryMapDataObject> cs = or.query(MapUtils.get31TileNumberX(lon), MapUtils.get31TileNumberY(lat));
        TreeSet<String> expected = new TreeSet<String>(Arrays.asList(test));
        TreeSet<String> found = new TreeSet<String>();
        for (BinaryMapDataObject b : cs) {
            String nm = b.getNameByType(or.mapIndexFields.nameEnType);
            if (nm == null) {
                nm = b.getName();
            }
            if (!or.isDownloadOfType(b, MAP_TYPE)) continue;
            found.add(nm.toLowerCase());
        }
        if (!found.equals(expected)) {
            throw new IllegalStateException(" Expected " + expected + " but was " + found);
        }
        System.out.println("Found " + expected + " in " + (System.currentTimeMillis() - t) + " ms");
    }

    public static void main(String[] args) throws IOException {
        OsmandRegions or = new OsmandRegions();
        or.prepareFile("/Users/victorshcherb/osmand/repos/resources/countries-info/regions.ocbf");
        LinkedList<WorldRegion> lst = new LinkedList<WorldRegion>();
        lst.add(or.getWorldRegion());
        while (!lst.isEmpty()) {
            WorldRegion wd = (WorldRegion)lst.pollFirst();
            System.out.println((wd.superregion == null ? "" : wd.superregion.getLocaleName()) + " " + wd.getLocaleName() + " " + wd.getRegionDownloadName());
        }
        or.cacheAllCountries();
        OsmandRegions.testCountry(or, 52.1, 4.92, "the netherlands", "utrecht");
        OsmandRegions.testCountry(or, 52.15, 7.5, "north rhine-westphalia");
        OsmandRegions.testCountry(or, 28.8056, 29.9858, "egypt");
        OsmandRegions.testCountry(or, 35.7521, 139.7887, "japan");
        OsmandRegions.testCountry(or, 46.5145, 102.258, "mongolia");
        OsmandRegions.testCountry(or, 62.54, 43.36, "arkhangelsk oblast", "northwestern federal district");
    }

    private void initWorldRegion(WorldRegion world, String id2) {
        WorldRegion rg = new WorldRegion(id2);
        rg.regionParentFullName = world.regionFullName;
        if (this.translator != null) {
            rg.regionName = this.translator.getTranslation(id2);
        }
        world.addSubregion(rg);
    }

    public void structureWorldRegions(List<WorldRegion> loadedItems) {
        if (loadedItems.size() == 0) {
            return;
        }
        WorldRegion world = new WorldRegion("world");
        this.initWorldRegion(world, "africa");
        this.initWorldRegion(world, "asia");
        this.initWorldRegion(world, "centralamerica");
        this.initWorldRegion(world, "europe");
        this.initWorldRegion(world, "northamerica");
        this.initWorldRegion(world, "russia");
        this.initWorldRegion(world, "southamerica");
        this.initWorldRegion(world, "australia-oceania");
        Iterator<WorldRegion> it = loadedItems.iterator();
        while (it.hasNext()) {
            WorldRegion region = it.next();
            if (region.superregion == null) {
                boolean found = false;
                for (WorldRegion worldSubregion : world.subregions) {
                    if (!worldSubregion.getRegionId().equalsIgnoreCase(region.regionFullName)) continue;
                    for (WorldRegion rg : region.subregions) {
                        worldSubregion.addSubregion(rg);
                    }
                    found = true;
                    break;
                }
                if (found) {
                    it.remove();
                    continue;
                }
                if (!region.getRegionId().contains("basemap")) continue;
                it.remove();
                continue;
            }
            it.remove();
        }
        Comparator<WorldRegion> nameComparator = new Comparator<WorldRegion>(){

            @Override
            public int compare(WorldRegion w1, WorldRegion w2) {
                return w1.getLocaleName().compareTo(w2.getLocaleName());
            }
        };
        this.sortSubregions(world, nameComparator);
        this.worldRegion = world;
        if (loadedItems.size() > 0) {
            LOG.warn((Object)("Found orphaned regions: " + loadedItems.size()));
            for (WorldRegion regionId : loadedItems) {
                LOG.warn((Object)("FullName = " + regionId.regionFullName + " parent=" + regionId.regionParentFullName));
            }
        }
    }

    private void sortSubregions(WorldRegion region, Comparator<WorldRegion> comparator) {
        Collections.sort(region.subregions, comparator);
        for (WorldRegion r : region.subregions) {
            if (r.subregions.size() <= 0) continue;
            this.sortSubregions(r, comparator);
        }
    }

    public static interface RegionTranslation {
        public String getTranslation(String var1);
    }

    private class MapIndexFields {
        Integer parentFullName = null;
        Integer fullNameType = null;
        Integer downloadNameType = null;
        Integer nameEnType = null;
        Integer nameType = null;
        Integer nameLocaleType = null;
        Integer langType = null;
        Integer metricType = null;
        Integer leftHandDrivingType = null;
        Integer roadSignsType = null;
        Integer wikiLinkType = null;
        Integer populationType = null;

        private MapIndexFields() {
        }

        public String get(Integer tp, BinaryMapDataObject object) {
            if (tp == null) {
                return null;
            }
            return object.getNameByType(tp);
        }
    }
}

