/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class GZipFileDocumentTarget
implements OWLOntologyDocumentTarget {
    @Nonnull
    private final File out;
    private OutputStream outputStream;

    public GZipFileDocumentTarget(@Nonnull File os) {
        this.out = os;
    }

    @Override
    public boolean isWriterAvailable() {
        return this.isOutputStreamAvailable();
    }

    @Override
    @Nonnull
    public Writer getWriter() {
        if (!this.isWriterAvailable()) {
            throw new UnsupportedOperationException("writer not available; check with isWriterAvailable() first.");
        }
        return new OutputStreamWriter(this.getOutputStream());
    }

    @Override
    public boolean isOutputStreamAvailable() {
        return true;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            try {
                this.outputStream = new GZIPOutputStream(new FileOutputStream(this.out));
            }
            catch (FileNotFoundException e) {
                throw new OWLRuntimeException(e);
            }
            catch (IOException e) {
                throw new OWLRuntimeException(e);
            }
        }
        return OWLAPIPreconditions.verifyNotNull(this.outputStream);
    }

    @Override
    public boolean isDocumentIRIAvailable() {
        return true;
    }

    @Override
    public IRI getDocumentIRI() {
        return IRI.create(this.out);
    }
}

