/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.ontology.OntologyPreferences;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyPreferencesPanel
extends OWLPreferencesPanel {
    private static final Logger logger = LoggerFactory.getLogger(OntologyPreferencesPanel.class);
    private JTextField textField;
    private JCheckBox yearCheckBox;
    private JCheckBox monthCheckBox;
    private JCheckBox dayCheckBox;
    private JTextComponent previewLabel;

    public void applyChanges() {
        OntologyPreferences prefs = OntologyPreferences.getInstance();
        try {
            prefs.setBaseURI(new URI(this.textField.getText()));
            prefs.setIncludeYear(this.yearCheckBox.isSelected());
            prefs.setIncludeMonth(this.monthCheckBox.isSelected());
            prefs.setIncludeDay(this.dayCheckBox.isSelected());
        }
        catch (URISyntaxException e) {
            UIHelper uiHelper = new UIHelper(this.getOWLEditorKit());
            uiHelper.showOptionPane("Error", "Couldn't set base URI: " + e.getMessage(), 0, 0);
        }
    }

    public void initialise() throws Exception {
        PreferencesLayoutPanel panel = new PreferencesLayoutPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "North");
        OntologyPreferences prefs = OntologyPreferences.getInstance();
        panel.addGroup("Default ontology IRI base");
        this.textField = new JTextField(prefs.getBaseURI().toString(), 40);
        panel.addGroupComponent((JComponent)this.textField);
        this.yearCheckBox = new JCheckBox("Include year", prefs.isIncludeYear());
        panel.addGroupComponent((JComponent)this.yearCheckBox);
        this.monthCheckBox = new JCheckBox("Include month", prefs.isIncludeMonth());
        panel.addGroupComponent((JComponent)this.monthCheckBox);
        this.dayCheckBox = new JCheckBox("Include day", prefs.isIncludeDay());
        panel.addGroupComponent((JComponent)this.dayCheckBox);
        this.yearCheckBox.addActionListener(e -> this.updateState());
        this.monthCheckBox.addActionListener(e -> this.updateState());
        this.updateState();
    }

    private void updateState() {
        if (this.yearCheckBox.isSelected()) {
            this.monthCheckBox.setEnabled(true);
        } else {
            this.monthCheckBox.setSelected(false);
            this.monthCheckBox.setEnabled(false);
        }
        if (this.monthCheckBox.isSelected()) {
            this.dayCheckBox.setEnabled(true);
        } else {
            this.dayCheckBox.setSelected(false);
            this.dayCheckBox.setEnabled(false);
        }
    }

    public void dispose() {
    }

    public static void showDialog(Component parent) {
        try {
            OntologyPreferencesPanel panel = new OntologyPreferencesPanel();
            panel.setup("Ontology URI Preferences", null);
            panel.initialise();
            panel.setPreferredSize(new Dimension(600, 300));
            int ret = JOptionPane.showConfirmDialog(parent, (Object)panel, "Default Ontology URI Base", 2, -1);
            if (ret == 0) {
                panel.applyChanges();
            }
        }
        catch (Exception e) {
            logger.error("An error occurred whilst trying to display the Ontology Preferences Panel", (Throwable)e);
        }
    }
}

