/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.camera;

import org.sunflow.SunflowAPI;
import org.sunflow.core.CameraLens;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;

public class ThinLens
implements CameraLens {
    private float au;
    private float av;
    private float aspect = 1.0f;
    private float fov = 90.0f;
    private float shiftX;
    private float shiftY;
    private float focusDistance = 1.0f;
    private float lensRadius = 0.0f;
    private int lensSides = 0;
    private float lensRotation = 0.0f;
    private float lensRotationRadians = 0.0f;

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.fov = parameterList.getFloat("fov", this.fov);
        this.aspect = parameterList.getFloat("aspect", this.aspect);
        this.shiftX = parameterList.getFloat("shift.x", this.shiftX);
        this.shiftY = parameterList.getFloat("shift.y", this.shiftY);
        this.focusDistance = parameterList.getFloat("focus.distance", this.focusDistance);
        this.lensRadius = parameterList.getFloat("lens.radius", this.lensRadius);
        this.lensSides = parameterList.getInt("lens.sides", this.lensSides);
        this.lensRotation = parameterList.getFloat("lens.rotation", this.lensRotation);
        this.update();
        return true;
    }

    private void update() {
        this.au = (float)Math.tan(Math.toRadians(this.fov * 0.5f)) * this.focusDistance;
        this.av = this.au / this.aspect;
        this.lensRotationRadians = (float)Math.toRadians(this.lensRotation);
    }

    public Ray getRay(float f, float f2, int n, int n2, double d, double d2, double d3) {
        float f3;
        float f4;
        float f5;
        float f6;
        float f7 = this.shiftX * this.focusDistance - this.au + 2.0f * this.au * f / ((float)n - 1.0f);
        float f8 = this.shiftY * this.focusDistance - this.av + 2.0f * this.av * f2 / ((float)n2 - 1.0f);
        if (this.lensSides < 3) {
            double d4;
            double d5;
            double d6 = 2.0 * d - 1.0;
            double d7 = 2.0 * d2 - 1.0;
            if (d6 > -d7) {
                if (d6 > d7) {
                    d5 = d6;
                    d4 = 0.7853981633974483 * d7 / d6;
                } else {
                    d5 = d7;
                    d4 = 0.7853981633974483 * (2.0 - d6 / d7);
                }
            } else if (d6 < d7) {
                d5 = -d6;
                d4 = 0.7853981633974483 * (4.0 + d7 / d6);
            } else {
                d5 = -d7;
                d4 = d7 != 0.0 ? 0.7853981633974483 * (6.0 - d6 / d7) : 0.0;
            }
            f6 = (float)(Math.cos(d4) * (d5 *= (double)this.lensRadius));
            f5 = (float)(Math.sin(d4) * d5);
        } else {
            float f9 = (int)(d2 *= (double)this.lensSides);
            f4 = (float)d2 - f9;
            float f10 = (float)Math.sqrt(d);
            f3 = (float)((double)f9 * Math.PI * 2.0 / (double)this.lensSides + (double)this.lensRotationRadians);
            float f11 = (float)((double)(f9 + 1.0f) * Math.PI * 2.0 / (double)this.lensSides + (double)this.lensRotationRadians);
            f6 = (float)((Math.cos(f3) * (double)(1.0f - f4) + Math.cos(f11) * (double)f4) * (double)f10);
            f5 = (float)((Math.sin(f3) * (double)(1.0f - f4) + Math.sin(f11) * (double)f4) * (double)f10);
            f6 *= this.lensRadius;
            f5 *= this.lensRadius;
        }
        float f12 = 0.0f;
        f4 = f7;
        float f13 = f8;
        f3 = -this.focusDistance;
        return new Ray(f6, f5, f12, f4 - f6, f13 - f5, f3 - f12);
    }
}

