// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from STM32F072x.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/STMicro

// +build stm32,stm32f072x

// STM32F072x
//

package stm32

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "STM32F072x"
)

// Interrupt numbers.
const (
	IRQ_WWDG_IRQ                = 0  // Window watchdog
	IRQ_PVD_IRQ                 = 1  // External interrupt/event controller
	IRQ_RTC_IRQ                 = 2  // Real-time clock
	IRQ_FLASH_IRQ               = 3  // Flash
	IRQ_RCC_CRS_IRQ             = 4  // Reset and clock control // Clock recovery system
	IRQ_EXTI0_1_IRQ             = 5  // External interrupt/event controller
	IRQ_EXTI2_3_IRQ             = 6  // External interrupt/event controller
	IRQ_EXTI4_15_IRQ            = 7  // External interrupt/event controller
	IRQ_TSC_IRQ                 = 8  // Touch sensing controller
	IRQ_DMA_CH1_IRQ             = 9  // DMA controller
	IRQ_DMA_CH2_3_IRQ           = 10 // DMA controller
	IRQ_DMA_CH4_5_6_7_IRQ       = 11 // DMA controller
	IRQ_ADC_COMP_IRQ            = 12 // Analog-to-digital converter // Comparator
	IRQ_TIM1_BRK_UP_TRG_COM_IRQ = 13 // Advanced-timers
	IRQ_TIM1_CC_IRQ             = 14 // Advanced-timers
	IRQ_TIM2_IRQ                = 15 // General-purpose-timers
	IRQ_TIM3_IRQ                = 16 //
	IRQ_TIM6_DAC_IRQ            = 17 // Digital-to-analog converter // Basic-timers
	IRQ_TIM7_IRQ                = 18 //
	IRQ_TIM14_IRQ               = 19 // General-purpose-timers
	IRQ_TIM15_IRQ               = 20 // General-purpose-timers
	IRQ_TIM16_IRQ               = 21 // General-purpose-timers
	IRQ_TIM17_IRQ               = 22 //
	IRQ_I2C1_IRQ                = 23 // Inter-integrated circuit
	IRQ_I2C2_IRQ                = 24 //
	IRQ_SPI1_IRQ                = 25 // Serial peripheral interface
	IRQ_SPI2_IRQ                = 26 //
	IRQ_USART1_IRQ              = 27 // Universal synchronous asynchronous receiver transmitter
	IRQ_USART2_IRQ              = 28 //
	IRQ_USART3_4_IRQ            = 29 //
	IRQ_CEC_CAN_IRQ             = 30 // HDMI-CEC controller // Controller area network
	IRQ_USB                     = 31 // Universal serial bus full-speed device interface
	IRQ_max                     = 31 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_WWDG_IRQ, "WWDG_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_PVD_IRQ, "PVD_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_RTC_IRQ, "RTC_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_FLASH_IRQ, "FLASH_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_RCC_CRS_IRQ, "RCC_CRS_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI0_1_IRQ, "EXTI0_1_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI2_3_IRQ, "EXTI2_3_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_EXTI4_15_IRQ, "EXTI4_15_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TSC_IRQ, "TSC_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA_CH1_IRQ, "DMA_CH1_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA_CH2_3_IRQ, "DMA_CH2_3_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_DMA_CH4_5_6_7_IRQ, "DMA_CH4_5_6_7_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_ADC_COMP_IRQ, "ADC_COMP_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_BRK_UP_TRG_COM_IRQ, "TIM1_BRK_UP_TRG_COM_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM1_CC_IRQ, "TIM1_CC_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM2_IRQ, "TIM2_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM3_IRQ, "TIM3_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM6_DAC_IRQ, "TIM6_DAC_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM7_IRQ, "TIM7_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM14_IRQ, "TIM14_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM15_IRQ, "TIM15_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM16_IRQ, "TIM16_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_TIM17_IRQ, "TIM17_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_I2C1_IRQ, "I2C1_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_I2C2_IRQ, "I2C2_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_SPI1_IRQ, "SPI1_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_SPI2_IRQ, "SPI2_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_USART1_IRQ, "USART1_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_USART2_IRQ, "USART2_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_USART3_4_IRQ, "USART3_4_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_CEC_CAN_IRQ, "CEC_CAN_IRQ_IRQHandler")
	_ = interrupt.Register(IRQ_USB, "USB_IRQHandler")
)

// Peripherals.
var (
	CRC    = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))    // cyclic redundancy check calculation unit
	GPIOF  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001400)))   // General-purpose I/Os
	GPIOA  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000000)))   // General-purpose I/Os
	SPI1   = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))    // Serial peripheral interface
	DAC    = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))    // Digital-to-analog converter
	PWR    = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))    // Power control
	I2C1   = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))    // Inter-integrated circuit
	IWDG   = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))   // Independent watchdog
	WWDG   = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))   // Window watchdog
	TIM1   = (*TIM_Type)(unsafe.Pointer(uintptr(0x40012c00)))    // Advanced-timers
	TIM2   = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))    // General-purpose-timers
	TIM14  = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))    // General-purpose-timers
	TIM6   = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))    // Basic-timers
	EXTI   = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))   // External interrupt/event controller
	NVIC   = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))   // Nested Vectored Interrupt Controller
	DMA    = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))    // DMA controller
	RCC    = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))    // Reset and clock control
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000))) // System configuration controller
	ADC    = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))    // Analog-to-digital converter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))  // Universal synchronous asynchronous receiver transmitter
	COMP   = (*COMP_Type)(unsafe.Pointer(uintptr(0x4001001c)))   // Comparator
	RTC    = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))    // Real-time clock
	TIM15  = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))    // General-purpose-timers
	TIM16  = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))    // General-purpose-timers
	TSC    = (*TSC_Type)(unsafe.Pointer(uintptr(0x40024000)))    // Touch sensing controller
	CEC    = (*CEC_Type)(unsafe.Pointer(uintptr(0x40007800)))    // HDMI-CEC controller
	Flash  = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))  // Flash
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0x40015800))) // Debug support
	USB    = (*USB_Type)(unsafe.Pointer(uintptr(0x40005c00)))    // Universal serial bus full-speed device interface
	CRS    = (*CRS_Type)(unsafe.Pointer(uintptr(0x40006c00)))    // Clock recovery system
	CAN    = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))    // Controller area network
	GPIOD  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000c00)))   // General-purpose I/Os
	GPIOC  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000800)))   // General-purpose I/Os
	GPIOB  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000400)))   // General-purpose I/Os
	GPIOE  = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001000)))   // General-purpose I/Os
	SPI2   = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))    // Serial peripheral interface
	I2C2   = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))    // Inter-integrated circuit
	TIM3   = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))    // General-purpose-timers
	TIM7   = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))    // Basic-timers
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))  // Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))  // Universal synchronous asynchronous receiver transmitter
	USART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))  // Universal synchronous asynchronous receiver transmitter
	TIM17  = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))    // General-purpose-timers
)

// cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	INIT volatile.Register32 // 0xC
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	_       [24]byte
	DOR1    volatile.Register32 // 0x2C
	_       [4]byte
	SR      volatile.Register32 // 0x34
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER volatile.Register32 // 0x0
	_    [124]byte
	ICER volatile.Register32 // 0x80
	_    [124]byte
	ISPR volatile.Register32 // 0x100
	_    [124]byte
	ICPR volatile.Register32 // 0x180
	_    [380]byte
	IPR0 volatile.Register32 // 0x300
	IPR1 volatile.Register32 // 0x304
	IPR2 volatile.Register32 // 0x308
	IPR3 volatile.Register32 // 0x30C
	IPR4 volatile.Register32 // 0x310
	IPR5 volatile.Register32 // 0x314
	IPR6 volatile.Register32 // 0x318
	IPR7 volatile.Register32 // 0x31C
}

// DMA controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
}

// Reset and clock control
type RCC_Type struct {
	CR       volatile.Register32 // 0x0
	CFGR     volatile.Register32 // 0x4
	CIR      volatile.Register32 // 0x8
	APB2RSTR volatile.Register32 // 0xC
	APB1RSTR volatile.Register32 // 0x10
	AHBENR   volatile.Register32 // 0x14
	APB2ENR  volatile.Register32 // 0x18
	APB1ENR  volatile.Register32 // 0x1C
	BDCR     volatile.Register32 // 0x20
	CSR      volatile.Register32 // 0x24
	AHBRSTR  volatile.Register32 // 0x28
	CFGR2    volatile.Register32 // 0x2C
	CFGR3    volatile.Register32 // 0x30
	CR2      volatile.Register32 // 0x34
}

// System configuration controller
type SYSCFG_Type struct {
	CFGR1   volatile.Register32 // 0x0
	_       [4]byte
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	CFGR2   volatile.Register32 // 0x18
}

// Analog-to-digital converter
type ADC_Type struct {
	ISR    volatile.Register32 // 0x0
	IER    volatile.Register32 // 0x4
	CR     volatile.Register32 // 0x8
	CFGR1  volatile.Register32 // 0xC
	CFGR2  volatile.Register32 // 0x10
	SMPR   volatile.Register32 // 0x14
	_      [8]byte
	TR     volatile.Register32 // 0x20
	_      [4]byte
	CHSELR volatile.Register32 // 0x28
	_      [20]byte
	DR     volatile.Register32 // 0x40
	_      [708]byte
	CCR    volatile.Register32 // 0x308
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// Comparator
type COMP_Type struct {
	CSR volatile.Register32 // 0x0
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	_        [8]byte
	ALRMAR   volatile.Register32 // 0x1C
	_        [4]byte
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAFCR    volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	_        [8]byte
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
}

// Touch sensing controller
type TSC_Type struct {
	CR     volatile.Register32 // 0x0
	IER    volatile.Register32 // 0x4
	ICR    volatile.Register32 // 0x8
	ISR    volatile.Register32 // 0xC
	IOHCR  volatile.Register32 // 0x10
	_      [4]byte
	IOASCR volatile.Register32 // 0x18
	_      [4]byte
	IOSCR  volatile.Register32 // 0x20
	_      [4]byte
	IOCCR  volatile.Register32 // 0x28
	_      [4]byte
	IOGCSR volatile.Register32 // 0x30
	IOG1CR volatile.Register32 // 0x34
	IOG2CR volatile.Register32 // 0x38
	IOG3CR volatile.Register32 // 0x3C
	IOG4CR volatile.Register32 // 0x40
	IOG5CR volatile.Register32 // 0x44
	IOG6CR volatile.Register32 // 0x48
}

// HDMI-CEC controller
type CEC_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	TXDR volatile.Register32 // 0x8
	RXDR volatile.Register32 // 0xC
	ISR  volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
}

// Flash
type Flash_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	AR      volatile.Register32 // 0x14
	_       [4]byte
	OBR     volatile.Register32 // 0x1C
	WRPR    volatile.Register32 // 0x20
}

// Debug support
type DBGMCU_Type struct {
	IDCODE volatile.Register32 // 0x0
	CR     volatile.Register32 // 0x4
	APBLFZ volatile.Register32 // 0x8
	APBHFZ volatile.Register32 // 0xC
}

// Universal serial bus full-speed device interface
type USB_Type struct {
	EP0R   volatile.Register32 // 0x0
	EP1R   volatile.Register32 // 0x4
	EP2R   volatile.Register32 // 0x8
	EP3R   volatile.Register32 // 0xC
	EP4R   volatile.Register32 // 0x10
	EP5R   volatile.Register32 // 0x14
	EP6R   volatile.Register32 // 0x18
	EP7R   volatile.Register32 // 0x1C
	_      [32]byte
	CNTR   volatile.Register32 // 0x40
	ISTR   volatile.Register32 // 0x44
	FNR    volatile.Register32 // 0x48
	DADDR  volatile.Register32 // 0x4C
	BTABLE volatile.Register32 // 0x50
	LPMCSR volatile.Register32 // 0x54
	BCDR   volatile.Register32 // 0x58
}

// Clock recovery system
type CRS_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	ISR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
}

// Controller area network
type CAN_Type struct {
	CAN_MCR   volatile.Register32 // 0x0
	CAN_MSR   volatile.Register32 // 0x4
	CAN_TSR   volatile.Register32 // 0x8
	CAN_RF0R  volatile.Register32 // 0xC
	CAN_RF1R  volatile.Register32 // 0x10
	CAN_IER   volatile.Register32 // 0x14
	CAN_ESR   volatile.Register32 // 0x18
	CAN_BTR   volatile.Register32 // 0x1C
	_         [352]byte
	CAN_TI0R  volatile.Register32 // 0x180
	CAN_TDT0R volatile.Register32 // 0x184
	CAN_TDL0R volatile.Register32 // 0x188
	CAN_TDH0R volatile.Register32 // 0x18C
	CAN_TI1R  volatile.Register32 // 0x190
	CAN_TDT1R volatile.Register32 // 0x194
	CAN_TDL1R volatile.Register32 // 0x198
	CAN_TDH1R volatile.Register32 // 0x19C
	CAN_TI2R  volatile.Register32 // 0x1A0
	CAN_TDT2R volatile.Register32 // 0x1A4
	CAN_TDL2R volatile.Register32 // 0x1A8
	CAN_TDH2R volatile.Register32 // 0x1AC
	CAN_RI0R  volatile.Register32 // 0x1B0
	CAN_RDT0R volatile.Register32 // 0x1B4
	CAN_RDL0R volatile.Register32 // 0x1B8
	CAN_RDH0R volatile.Register32 // 0x1BC
	CAN_RI1R  volatile.Register32 // 0x1C0
	CAN_RDT1R volatile.Register32 // 0x1C4
	CAN_RDL1R volatile.Register32 // 0x1C8
	CAN_RDH1R volatile.Register32 // 0x1CC
	_         [48]byte
	CAN_FMR   volatile.Register32 // 0x200
	CAN_FM1R  volatile.Register32 // 0x204
	_         [4]byte
	CAN_FS1R  volatile.Register32 // 0x20C
	_         [4]byte
	CAN_FFA1R volatile.Register32 // 0x214
	_         [4]byte
	CAN_FA1R  volatile.Register32 // 0x21C
	_         [32]byte
	F0R1      volatile.Register32 // 0x240
	F0R2      volatile.Register32 // 0x244
	F1R1      volatile.Register32 // 0x248
	F1R2      volatile.Register32 // 0x24C
	F2R1      volatile.Register32 // 0x250
	F2R2      volatile.Register32 // 0x254
	F3R1      volatile.Register32 // 0x258
	F3R2      volatile.Register32 // 0x25C
	F4R1      volatile.Register32 // 0x260
	F4R2      volatile.Register32 // 0x264
	F5R1      volatile.Register32 // 0x268
	F5R2      volatile.Register32 // 0x26C
	F6R1      volatile.Register32 // 0x270
	F6R2      volatile.Register32 // 0x274
	F7R1      volatile.Register32 // 0x278
	F7R2      volatile.Register32 // 0x27C
	F8R1      volatile.Register32 // 0x280
	F8R2      volatile.Register32 // 0x284
	F9R1      volatile.Register32 // 0x288
	F9R2      volatile.Register32 // 0x28C
	F10R1     volatile.Register32 // 0x290
	F10R2     volatile.Register32 // 0x294
	F11R1     volatile.Register32 // 0x298
	F11R2     volatile.Register32 // 0x29C
	F12R1     volatile.Register32 // 0x2A0
	F12R2     volatile.Register32 // 0x2A4
	F13R1     volatile.Register32 // 0x2A8
	F13R2     volatile.Register32 // 0x2AC
	F14R1     volatile.Register32 // 0x2B0
	F14R2     volatile.Register32 // 0x2B4
	F15R1     volatile.Register32 // 0x2B8
	F15R2     volatile.Register32 // 0x2BC
	F16R1     volatile.Register32 // 0x2C0
	F16R2     volatile.Register32 // 0x2C4
	F17R1     volatile.Register32 // 0x2C8
	F17R2     volatile.Register32 // 0x2CC
	F18R1     volatile.Register32 // 0x2D0
	F18R2     volatile.Register32 // 0x2D4
	F19R1     volatile.Register32 // 0x2D8
	F19R2     volatile.Register32 // 0x2DC
	F20R1     volatile.Register32 // 0x2E0
	F20R2     volatile.Register32 // 0x2E4
	F21R1     volatile.Register32 // 0x2E8
	F21R2     volatile.Register32 // 0x2EC
	F22R1     volatile.Register32 // 0x2F0
	F22R2     volatile.Register32 // 0x2F4
	F23R1     volatile.Register32 // 0x2F8
	F23R2     volatile.Register32 // 0x2FC
	F24R1     volatile.Register32 // 0x300
	F24R2     volatile.Register32 // 0x304
	F25R1     volatile.Register32 // 0x308
	F25R2     volatile.Register32 // 0x30C
	F26R1     volatile.Register32 // 0x310
	F26R2     volatile.Register32 // 0x314
	F27R1     volatile.Register32 // 0x318
	F27R2     volatile.Register32 // 0x31C
}

// Bitfields for CRC: cyclic redundancy check calculation unit
const (
	// DR: Data register
	CRC_DR_DR_Pos = 0x0        // Position of DR field.
	CRC_DR_DR_Msk = 0xffffffff // Bit mask of DR field.

	// IDR: Independent data register
	CRC_IDR_IDR_Pos = 0x0  // Position of IDR field.
	CRC_IDR_IDR_Msk = 0xff // Bit mask of IDR field.

	// CR: Control register
	CRC_CR_RESET_Pos   = 0x0  // Position of RESET field.
	CRC_CR_RESET_Msk   = 0x1  // Bit mask of RESET field.
	CRC_CR_RESET       = 0x1  // Bit RESET.
	CRC_CR_REV_IN_Pos  = 0x5  // Position of REV_IN field.
	CRC_CR_REV_IN_Msk  = 0x60 // Bit mask of REV_IN field.
	CRC_CR_REV_OUT_Pos = 0x7  // Position of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80 // Bit mask of REV_OUT field.
	CRC_CR_REV_OUT     = 0x80 // Bit REV_OUT.

	// INIT: Initial CRC value
	CRC_INIT_INIT_Pos = 0x0        // Position of INIT field.
	CRC_INIT_INIT_Msk = 0xffffffff // Bit mask of INIT field.
)

// Bitfields for GPIOF: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	GPIO_MODER_MODER15_Pos = 0x1e       // Position of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000 // Bit mask of MODER15 field.
	GPIO_MODER_MODER14_Pos = 0x1c       // Position of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000 // Bit mask of MODER14 field.
	GPIO_MODER_MODER13_Pos = 0x1a       // Position of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000  // Bit mask of MODER13 field.
	GPIO_MODER_MODER12_Pos = 0x18       // Position of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000  // Bit mask of MODER12 field.
	GPIO_MODER_MODER11_Pos = 0x16       // Position of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000   // Bit mask of MODER11 field.
	GPIO_MODER_MODER10_Pos = 0x14       // Position of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000   // Bit mask of MODER10 field.
	GPIO_MODER_MODER9_Pos  = 0x12       // Position of MODER9 field.
	GPIO_MODER_MODER9_Msk  = 0xc0000    // Bit mask of MODER9 field.
	GPIO_MODER_MODER8_Pos  = 0x10       // Position of MODER8 field.
	GPIO_MODER_MODER8_Msk  = 0x30000    // Bit mask of MODER8 field.
	GPIO_MODER_MODER7_Pos  = 0xe        // Position of MODER7 field.
	GPIO_MODER_MODER7_Msk  = 0xc000     // Bit mask of MODER7 field.
	GPIO_MODER_MODER6_Pos  = 0xc        // Position of MODER6 field.
	GPIO_MODER_MODER6_Msk  = 0x3000     // Bit mask of MODER6 field.
	GPIO_MODER_MODER5_Pos  = 0xa        // Position of MODER5 field.
	GPIO_MODER_MODER5_Msk  = 0xc00      // Bit mask of MODER5 field.
	GPIO_MODER_MODER4_Pos  = 0x8        // Position of MODER4 field.
	GPIO_MODER_MODER4_Msk  = 0x300      // Bit mask of MODER4 field.
	GPIO_MODER_MODER3_Pos  = 0x6        // Position of MODER3 field.
	GPIO_MODER_MODER3_Msk  = 0xc0       // Bit mask of MODER3 field.
	GPIO_MODER_MODER2_Pos  = 0x4        // Position of MODER2 field.
	GPIO_MODER_MODER2_Msk  = 0x30       // Bit mask of MODER2 field.
	GPIO_MODER_MODER1_Pos  = 0x2        // Position of MODER1 field.
	GPIO_MODER_MODER1_Msk  = 0xc        // Bit mask of MODER1 field.
	GPIO_MODER_MODER0_Pos  = 0x0        // Position of MODER0 field.
	GPIO_MODER_MODER0_Msk  = 0x3        // Bit mask of MODER0 field.

	// OTYPER: GPIO port output type register
	GPIO_OTYPER_OT15_Pos = 0xf    // Position of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000 // Bit mask of OT15 field.
	GPIO_OTYPER_OT15     = 0x8000 // Bit OT15.
	GPIO_OTYPER_OT14_Pos = 0xe    // Position of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000 // Bit mask of OT14 field.
	GPIO_OTYPER_OT14     = 0x4000 // Bit OT14.
	GPIO_OTYPER_OT13_Pos = 0xd    // Position of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000 // Bit mask of OT13 field.
	GPIO_OTYPER_OT13     = 0x2000 // Bit OT13.
	GPIO_OTYPER_OT12_Pos = 0xc    // Position of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000 // Bit mask of OT12 field.
	GPIO_OTYPER_OT12     = 0x1000 // Bit OT12.
	GPIO_OTYPER_OT11_Pos = 0xb    // Position of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800  // Bit mask of OT11 field.
	GPIO_OTYPER_OT11     = 0x800  // Bit OT11.
	GPIO_OTYPER_OT10_Pos = 0xa    // Position of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400  // Bit mask of OT10 field.
	GPIO_OTYPER_OT10     = 0x400  // Bit OT10.
	GPIO_OTYPER_OT9_Pos  = 0x9    // Position of OT9 field.
	GPIO_OTYPER_OT9_Msk  = 0x200  // Bit mask of OT9 field.
	GPIO_OTYPER_OT9      = 0x200  // Bit OT9.
	GPIO_OTYPER_OT8_Pos  = 0x8    // Position of OT8 field.
	GPIO_OTYPER_OT8_Msk  = 0x100  // Bit mask of OT8 field.
	GPIO_OTYPER_OT8      = 0x100  // Bit OT8.
	GPIO_OTYPER_OT7_Pos  = 0x7    // Position of OT7 field.
	GPIO_OTYPER_OT7_Msk  = 0x80   // Bit mask of OT7 field.
	GPIO_OTYPER_OT7      = 0x80   // Bit OT7.
	GPIO_OTYPER_OT6_Pos  = 0x6    // Position of OT6 field.
	GPIO_OTYPER_OT6_Msk  = 0x40   // Bit mask of OT6 field.
	GPIO_OTYPER_OT6      = 0x40   // Bit OT6.
	GPIO_OTYPER_OT5_Pos  = 0x5    // Position of OT5 field.
	GPIO_OTYPER_OT5_Msk  = 0x20   // Bit mask of OT5 field.
	GPIO_OTYPER_OT5      = 0x20   // Bit OT5.
	GPIO_OTYPER_OT4_Pos  = 0x4    // Position of OT4 field.
	GPIO_OTYPER_OT4_Msk  = 0x10   // Bit mask of OT4 field.
	GPIO_OTYPER_OT4      = 0x10   // Bit OT4.
	GPIO_OTYPER_OT3_Pos  = 0x3    // Position of OT3 field.
	GPIO_OTYPER_OT3_Msk  = 0x8    // Bit mask of OT3 field.
	GPIO_OTYPER_OT3      = 0x8    // Bit OT3.
	GPIO_OTYPER_OT2_Pos  = 0x2    // Position of OT2 field.
	GPIO_OTYPER_OT2_Msk  = 0x4    // Bit mask of OT2 field.
	GPIO_OTYPER_OT2      = 0x4    // Bit OT2.
	GPIO_OTYPER_OT1_Pos  = 0x1    // Position of OT1 field.
	GPIO_OTYPER_OT1_Msk  = 0x2    // Bit mask of OT1 field.
	GPIO_OTYPER_OT1      = 0x2    // Bit OT1.
	GPIO_OTYPER_OT0_Pos  = 0x0    // Position of OT0 field.
	GPIO_OTYPER_OT0_Msk  = 0x1    // Bit mask of OT0 field.
	GPIO_OTYPER_OT0      = 0x1    // Bit OT0.

	// OSPEEDR: GPIO port output speed           register
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e       // Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000 // Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c       // Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000 // Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a       // Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000  // Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18       // Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000  // Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16       // Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000   // Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14       // Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000   // Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos  = 0x12       // Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk  = 0xc0000    // Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos  = 0x10       // Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk  = 0x30000    // Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos  = 0xe        // Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk  = 0xc000     // Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos  = 0xc        // Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk  = 0x3000     // Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos  = 0xa        // Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk  = 0xc00      // Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos  = 0x8        // Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk  = 0x300      // Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos  = 0x6        // Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk  = 0xc0       // Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos  = 0x4        // Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk  = 0x30       // Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos  = 0x2        // Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk  = 0xc        // Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos  = 0x0        // Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk  = 0x3        // Bit mask of OSPEEDR0 field.

	// PUPDR: GPIO port pull-up/pull-down           register
	GPIO_PUPDR_PUPDR15_Pos = 0x1e       // Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000 // Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c       // Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000 // Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a       // Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000  // Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18       // Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000  // Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16       // Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000   // Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14       // Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000   // Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR9_Pos  = 0x12       // Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk  = 0xc0000    // Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR8_Pos  = 0x10       // Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk  = 0x30000    // Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR7_Pos  = 0xe        // Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk  = 0xc000     // Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR6_Pos  = 0xc        // Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk  = 0x3000     // Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR5_Pos  = 0xa        // Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk  = 0xc00      // Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR4_Pos  = 0x8        // Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk  = 0x300      // Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR3_Pos  = 0x6        // Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk  = 0xc0       // Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR2_Pos  = 0x4        // Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk  = 0x30       // Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR1_Pos  = 0x2        // Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk  = 0xc        // Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR0_Pos  = 0x0        // Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk  = 0x3        // Bit mask of PUPDR0 field.

	// IDR: GPIO port input data register
	GPIO_IDR_IDR15_Pos = 0xf    // Position of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000 // Bit mask of IDR15 field.
	GPIO_IDR_IDR15     = 0x8000 // Bit IDR15.
	GPIO_IDR_IDR14_Pos = 0xe    // Position of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000 // Bit mask of IDR14 field.
	GPIO_IDR_IDR14     = 0x4000 // Bit IDR14.
	GPIO_IDR_IDR13_Pos = 0xd    // Position of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000 // Bit mask of IDR13 field.
	GPIO_IDR_IDR13     = 0x2000 // Bit IDR13.
	GPIO_IDR_IDR12_Pos = 0xc    // Position of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000 // Bit mask of IDR12 field.
	GPIO_IDR_IDR12     = 0x1000 // Bit IDR12.
	GPIO_IDR_IDR11_Pos = 0xb    // Position of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800  // Bit mask of IDR11 field.
	GPIO_IDR_IDR11     = 0x800  // Bit IDR11.
	GPIO_IDR_IDR10_Pos = 0xa    // Position of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400  // Bit mask of IDR10 field.
	GPIO_IDR_IDR10     = 0x400  // Bit IDR10.
	GPIO_IDR_IDR9_Pos  = 0x9    // Position of IDR9 field.
	GPIO_IDR_IDR9_Msk  = 0x200  // Bit mask of IDR9 field.
	GPIO_IDR_IDR9      = 0x200  // Bit IDR9.
	GPIO_IDR_IDR8_Pos  = 0x8    // Position of IDR8 field.
	GPIO_IDR_IDR8_Msk  = 0x100  // Bit mask of IDR8 field.
	GPIO_IDR_IDR8      = 0x100  // Bit IDR8.
	GPIO_IDR_IDR7_Pos  = 0x7    // Position of IDR7 field.
	GPIO_IDR_IDR7_Msk  = 0x80   // Bit mask of IDR7 field.
	GPIO_IDR_IDR7      = 0x80   // Bit IDR7.
	GPIO_IDR_IDR6_Pos  = 0x6    // Position of IDR6 field.
	GPIO_IDR_IDR6_Msk  = 0x40   // Bit mask of IDR6 field.
	GPIO_IDR_IDR6      = 0x40   // Bit IDR6.
	GPIO_IDR_IDR5_Pos  = 0x5    // Position of IDR5 field.
	GPIO_IDR_IDR5_Msk  = 0x20   // Bit mask of IDR5 field.
	GPIO_IDR_IDR5      = 0x20   // Bit IDR5.
	GPIO_IDR_IDR4_Pos  = 0x4    // Position of IDR4 field.
	GPIO_IDR_IDR4_Msk  = 0x10   // Bit mask of IDR4 field.
	GPIO_IDR_IDR4      = 0x10   // Bit IDR4.
	GPIO_IDR_IDR3_Pos  = 0x3    // Position of IDR3 field.
	GPIO_IDR_IDR3_Msk  = 0x8    // Bit mask of IDR3 field.
	GPIO_IDR_IDR3      = 0x8    // Bit IDR3.
	GPIO_IDR_IDR2_Pos  = 0x2    // Position of IDR2 field.
	GPIO_IDR_IDR2_Msk  = 0x4    // Bit mask of IDR2 field.
	GPIO_IDR_IDR2      = 0x4    // Bit IDR2.
	GPIO_IDR_IDR1_Pos  = 0x1    // Position of IDR1 field.
	GPIO_IDR_IDR1_Msk  = 0x2    // Bit mask of IDR1 field.
	GPIO_IDR_IDR1      = 0x2    // Bit IDR1.
	GPIO_IDR_IDR0_Pos  = 0x0    // Position of IDR0 field.
	GPIO_IDR_IDR0_Msk  = 0x1    // Bit mask of IDR0 field.
	GPIO_IDR_IDR0      = 0x1    // Bit IDR0.

	// ODR: GPIO port output data register
	GPIO_ODR_ODR15_Pos = 0xf    // Position of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000 // Bit mask of ODR15 field.
	GPIO_ODR_ODR15     = 0x8000 // Bit ODR15.
	GPIO_ODR_ODR14_Pos = 0xe    // Position of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000 // Bit mask of ODR14 field.
	GPIO_ODR_ODR14     = 0x4000 // Bit ODR14.
	GPIO_ODR_ODR13_Pos = 0xd    // Position of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000 // Bit mask of ODR13 field.
	GPIO_ODR_ODR13     = 0x2000 // Bit ODR13.
	GPIO_ODR_ODR12_Pos = 0xc    // Position of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000 // Bit mask of ODR12 field.
	GPIO_ODR_ODR12     = 0x1000 // Bit ODR12.
	GPIO_ODR_ODR11_Pos = 0xb    // Position of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800  // Bit mask of ODR11 field.
	GPIO_ODR_ODR11     = 0x800  // Bit ODR11.
	GPIO_ODR_ODR10_Pos = 0xa    // Position of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400  // Bit mask of ODR10 field.
	GPIO_ODR_ODR10     = 0x400  // Bit ODR10.
	GPIO_ODR_ODR9_Pos  = 0x9    // Position of ODR9 field.
	GPIO_ODR_ODR9_Msk  = 0x200  // Bit mask of ODR9 field.
	GPIO_ODR_ODR9      = 0x200  // Bit ODR9.
	GPIO_ODR_ODR8_Pos  = 0x8    // Position of ODR8 field.
	GPIO_ODR_ODR8_Msk  = 0x100  // Bit mask of ODR8 field.
	GPIO_ODR_ODR8      = 0x100  // Bit ODR8.
	GPIO_ODR_ODR7_Pos  = 0x7    // Position of ODR7 field.
	GPIO_ODR_ODR7_Msk  = 0x80   // Bit mask of ODR7 field.
	GPIO_ODR_ODR7      = 0x80   // Bit ODR7.
	GPIO_ODR_ODR6_Pos  = 0x6    // Position of ODR6 field.
	GPIO_ODR_ODR6_Msk  = 0x40   // Bit mask of ODR6 field.
	GPIO_ODR_ODR6      = 0x40   // Bit ODR6.
	GPIO_ODR_ODR5_Pos  = 0x5    // Position of ODR5 field.
	GPIO_ODR_ODR5_Msk  = 0x20   // Bit mask of ODR5 field.
	GPIO_ODR_ODR5      = 0x20   // Bit ODR5.
	GPIO_ODR_ODR4_Pos  = 0x4    // Position of ODR4 field.
	GPIO_ODR_ODR4_Msk  = 0x10   // Bit mask of ODR4 field.
	GPIO_ODR_ODR4      = 0x10   // Bit ODR4.
	GPIO_ODR_ODR3_Pos  = 0x3    // Position of ODR3 field.
	GPIO_ODR_ODR3_Msk  = 0x8    // Bit mask of ODR3 field.
	GPIO_ODR_ODR3      = 0x8    // Bit ODR3.
	GPIO_ODR_ODR2_Pos  = 0x2    // Position of ODR2 field.
	GPIO_ODR_ODR2_Msk  = 0x4    // Bit mask of ODR2 field.
	GPIO_ODR_ODR2      = 0x4    // Bit ODR2.
	GPIO_ODR_ODR1_Pos  = 0x1    // Position of ODR1 field.
	GPIO_ODR_ODR1_Msk  = 0x2    // Bit mask of ODR1 field.
	GPIO_ODR_ODR1      = 0x2    // Bit ODR1.
	GPIO_ODR_ODR0_Pos  = 0x0    // Position of ODR0 field.
	GPIO_ODR_ODR0_Msk  = 0x1    // Bit mask of ODR0 field.
	GPIO_ODR_ODR0      = 0x1    // Bit ODR0.

	// BSRR: GPIO port bit set/reset           register
	GPIO_BSRR_BR15_Pos = 0x1f       // Position of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000 // Bit mask of BR15 field.
	GPIO_BSRR_BR15     = 0x80000000 // Bit BR15.
	GPIO_BSRR_BR14_Pos = 0x1e       // Position of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000 // Bit mask of BR14 field.
	GPIO_BSRR_BR14     = 0x40000000 // Bit BR14.
	GPIO_BSRR_BR13_Pos = 0x1d       // Position of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000 // Bit mask of BR13 field.
	GPIO_BSRR_BR13     = 0x20000000 // Bit BR13.
	GPIO_BSRR_BR12_Pos = 0x1c       // Position of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000 // Bit mask of BR12 field.
	GPIO_BSRR_BR12     = 0x10000000 // Bit BR12.
	GPIO_BSRR_BR11_Pos = 0x1b       // Position of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000  // Bit mask of BR11 field.
	GPIO_BSRR_BR11     = 0x8000000  // Bit BR11.
	GPIO_BSRR_BR10_Pos = 0x1a       // Position of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000  // Bit mask of BR10 field.
	GPIO_BSRR_BR10     = 0x4000000  // Bit BR10.
	GPIO_BSRR_BR9_Pos  = 0x19       // Position of BR9 field.
	GPIO_BSRR_BR9_Msk  = 0x2000000  // Bit mask of BR9 field.
	GPIO_BSRR_BR9      = 0x2000000  // Bit BR9.
	GPIO_BSRR_BR8_Pos  = 0x18       // Position of BR8 field.
	GPIO_BSRR_BR8_Msk  = 0x1000000  // Bit mask of BR8 field.
	GPIO_BSRR_BR8      = 0x1000000  // Bit BR8.
	GPIO_BSRR_BR7_Pos  = 0x17       // Position of BR7 field.
	GPIO_BSRR_BR7_Msk  = 0x800000   // Bit mask of BR7 field.
	GPIO_BSRR_BR7      = 0x800000   // Bit BR7.
	GPIO_BSRR_BR6_Pos  = 0x16       // Position of BR6 field.
	GPIO_BSRR_BR6_Msk  = 0x400000   // Bit mask of BR6 field.
	GPIO_BSRR_BR6      = 0x400000   // Bit BR6.
	GPIO_BSRR_BR5_Pos  = 0x15       // Position of BR5 field.
	GPIO_BSRR_BR5_Msk  = 0x200000   // Bit mask of BR5 field.
	GPIO_BSRR_BR5      = 0x200000   // Bit BR5.
	GPIO_BSRR_BR4_Pos  = 0x14       // Position of BR4 field.
	GPIO_BSRR_BR4_Msk  = 0x100000   // Bit mask of BR4 field.
	GPIO_BSRR_BR4      = 0x100000   // Bit BR4.
	GPIO_BSRR_BR3_Pos  = 0x13       // Position of BR3 field.
	GPIO_BSRR_BR3_Msk  = 0x80000    // Bit mask of BR3 field.
	GPIO_BSRR_BR3      = 0x80000    // Bit BR3.
	GPIO_BSRR_BR2_Pos  = 0x12       // Position of BR2 field.
	GPIO_BSRR_BR2_Msk  = 0x40000    // Bit mask of BR2 field.
	GPIO_BSRR_BR2      = 0x40000    // Bit BR2.
	GPIO_BSRR_BR1_Pos  = 0x11       // Position of BR1 field.
	GPIO_BSRR_BR1_Msk  = 0x20000    // Bit mask of BR1 field.
	GPIO_BSRR_BR1      = 0x20000    // Bit BR1.
	GPIO_BSRR_BR0_Pos  = 0x10       // Position of BR0 field.
	GPIO_BSRR_BR0_Msk  = 0x10000    // Bit mask of BR0 field.
	GPIO_BSRR_BR0      = 0x10000    // Bit BR0.
	GPIO_BSRR_BS15_Pos = 0xf        // Position of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000     // Bit mask of BS15 field.
	GPIO_BSRR_BS15     = 0x8000     // Bit BS15.
	GPIO_BSRR_BS14_Pos = 0xe        // Position of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000     // Bit mask of BS14 field.
	GPIO_BSRR_BS14     = 0x4000     // Bit BS14.
	GPIO_BSRR_BS13_Pos = 0xd        // Position of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000     // Bit mask of BS13 field.
	GPIO_BSRR_BS13     = 0x2000     // Bit BS13.
	GPIO_BSRR_BS12_Pos = 0xc        // Position of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000     // Bit mask of BS12 field.
	GPIO_BSRR_BS12     = 0x1000     // Bit BS12.
	GPIO_BSRR_BS11_Pos = 0xb        // Position of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800      // Bit mask of BS11 field.
	GPIO_BSRR_BS11     = 0x800      // Bit BS11.
	GPIO_BSRR_BS10_Pos = 0xa        // Position of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400      // Bit mask of BS10 field.
	GPIO_BSRR_BS10     = 0x400      // Bit BS10.
	GPIO_BSRR_BS9_Pos  = 0x9        // Position of BS9 field.
	GPIO_BSRR_BS9_Msk  = 0x200      // Bit mask of BS9 field.
	GPIO_BSRR_BS9      = 0x200      // Bit BS9.
	GPIO_BSRR_BS8_Pos  = 0x8        // Position of BS8 field.
	GPIO_BSRR_BS8_Msk  = 0x100      // Bit mask of BS8 field.
	GPIO_BSRR_BS8      = 0x100      // Bit BS8.
	GPIO_BSRR_BS7_Pos  = 0x7        // Position of BS7 field.
	GPIO_BSRR_BS7_Msk  = 0x80       // Bit mask of BS7 field.
	GPIO_BSRR_BS7      = 0x80       // Bit BS7.
	GPIO_BSRR_BS6_Pos  = 0x6        // Position of BS6 field.
	GPIO_BSRR_BS6_Msk  = 0x40       // Bit mask of BS6 field.
	GPIO_BSRR_BS6      = 0x40       // Bit BS6.
	GPIO_BSRR_BS5_Pos  = 0x5        // Position of BS5 field.
	GPIO_BSRR_BS5_Msk  = 0x20       // Bit mask of BS5 field.
	GPIO_BSRR_BS5      = 0x20       // Bit BS5.
	GPIO_BSRR_BS4_Pos  = 0x4        // Position of BS4 field.
	GPIO_BSRR_BS4_Msk  = 0x10       // Bit mask of BS4 field.
	GPIO_BSRR_BS4      = 0x10       // Bit BS4.
	GPIO_BSRR_BS3_Pos  = 0x3        // Position of BS3 field.
	GPIO_BSRR_BS3_Msk  = 0x8        // Bit mask of BS3 field.
	GPIO_BSRR_BS3      = 0x8        // Bit BS3.
	GPIO_BSRR_BS2_Pos  = 0x2        // Position of BS2 field.
	GPIO_BSRR_BS2_Msk  = 0x4        // Bit mask of BS2 field.
	GPIO_BSRR_BS2      = 0x4        // Bit BS2.
	GPIO_BSRR_BS1_Pos  = 0x1        // Position of BS1 field.
	GPIO_BSRR_BS1_Msk  = 0x2        // Bit mask of BS1 field.
	GPIO_BSRR_BS1      = 0x2        // Bit BS1.
	GPIO_BSRR_BS0_Pos  = 0x0        // Position of BS0 field.
	GPIO_BSRR_BS0_Msk  = 0x1        // Bit mask of BS0 field.
	GPIO_BSRR_BS0      = 0x1        // Bit BS0.

	// LCKR: GPIO port configuration lock           register
	GPIO_LCKR_LCKK_Pos  = 0x10    // Position of LCKK field.
	GPIO_LCKR_LCKK_Msk  = 0x10000 // Bit mask of LCKK field.
	GPIO_LCKR_LCKK      = 0x10000 // Bit LCKK.
	GPIO_LCKR_LCK15_Pos = 0xf     // Position of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000  // Bit mask of LCK15 field.
	GPIO_LCKR_LCK15     = 0x8000  // Bit LCK15.
	GPIO_LCKR_LCK14_Pos = 0xe     // Position of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000  // Bit mask of LCK14 field.
	GPIO_LCKR_LCK14     = 0x4000  // Bit LCK14.
	GPIO_LCKR_LCK13_Pos = 0xd     // Position of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000  // Bit mask of LCK13 field.
	GPIO_LCKR_LCK13     = 0x2000  // Bit LCK13.
	GPIO_LCKR_LCK12_Pos = 0xc     // Position of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000  // Bit mask of LCK12 field.
	GPIO_LCKR_LCK12     = 0x1000  // Bit LCK12.
	GPIO_LCKR_LCK11_Pos = 0xb     // Position of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800   // Bit mask of LCK11 field.
	GPIO_LCKR_LCK11     = 0x800   // Bit LCK11.
	GPIO_LCKR_LCK10_Pos = 0xa     // Position of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400   // Bit mask of LCK10 field.
	GPIO_LCKR_LCK10     = 0x400   // Bit LCK10.
	GPIO_LCKR_LCK9_Pos  = 0x9     // Position of LCK9 field.
	GPIO_LCKR_LCK9_Msk  = 0x200   // Bit mask of LCK9 field.
	GPIO_LCKR_LCK9      = 0x200   // Bit LCK9.
	GPIO_LCKR_LCK8_Pos  = 0x8     // Position of LCK8 field.
	GPIO_LCKR_LCK8_Msk  = 0x100   // Bit mask of LCK8 field.
	GPIO_LCKR_LCK8      = 0x100   // Bit LCK8.
	GPIO_LCKR_LCK7_Pos  = 0x7     // Position of LCK7 field.
	GPIO_LCKR_LCK7_Msk  = 0x80    // Bit mask of LCK7 field.
	GPIO_LCKR_LCK7      = 0x80    // Bit LCK7.
	GPIO_LCKR_LCK6_Pos  = 0x6     // Position of LCK6 field.
	GPIO_LCKR_LCK6_Msk  = 0x40    // Bit mask of LCK6 field.
	GPIO_LCKR_LCK6      = 0x40    // Bit LCK6.
	GPIO_LCKR_LCK5_Pos  = 0x5     // Position of LCK5 field.
	GPIO_LCKR_LCK5_Msk  = 0x20    // Bit mask of LCK5 field.
	GPIO_LCKR_LCK5      = 0x20    // Bit LCK5.
	GPIO_LCKR_LCK4_Pos  = 0x4     // Position of LCK4 field.
	GPIO_LCKR_LCK4_Msk  = 0x10    // Bit mask of LCK4 field.
	GPIO_LCKR_LCK4      = 0x10    // Bit LCK4.
	GPIO_LCKR_LCK3_Pos  = 0x3     // Position of LCK3 field.
	GPIO_LCKR_LCK3_Msk  = 0x8     // Bit mask of LCK3 field.
	GPIO_LCKR_LCK3      = 0x8     // Bit LCK3.
	GPIO_LCKR_LCK2_Pos  = 0x2     // Position of LCK2 field.
	GPIO_LCKR_LCK2_Msk  = 0x4     // Bit mask of LCK2 field.
	GPIO_LCKR_LCK2      = 0x4     // Bit LCK2.
	GPIO_LCKR_LCK1_Pos  = 0x1     // Position of LCK1 field.
	GPIO_LCKR_LCK1_Msk  = 0x2     // Bit mask of LCK1 field.
	GPIO_LCKR_LCK1      = 0x2     // Bit LCK1.
	GPIO_LCKR_LCK0_Pos  = 0x0     // Position of LCK0 field.
	GPIO_LCKR_LCK0_Msk  = 0x1     // Bit mask of LCK0 field.
	GPIO_LCKR_LCK0      = 0x1     // Bit LCK0.

	// AFRL: GPIO alternate function low           register
	GPIO_AFRL_AFRL7_Pos = 0x1c       // Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000 // Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL6_Pos = 0x18       // Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000  // Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL5_Pos = 0x14       // Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000   // Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL4_Pos = 0x10       // Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000    // Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL3_Pos = 0xc        // Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000     // Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL2_Pos = 0x8        // Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00      // Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL1_Pos = 0x4        // Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0       // Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL0_Pos = 0x0        // Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf        // Bit mask of AFRL0 field.

	// AFRH: GPIO alternate function high           register
	GPIO_AFRH_AFRH15_Pos = 0x1c       // Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000 // Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH14_Pos = 0x18       // Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000  // Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH13_Pos = 0x14       // Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000   // Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH12_Pos = 0x10       // Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000    // Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH11_Pos = 0xc        // Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000     // Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH10_Pos = 0x8        // Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00      // Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH9_Pos  = 0x4        // Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk  = 0xf0       // Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH8_Pos  = 0x0        // Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk  = 0xf        // Bit mask of AFRH8 field.

	// BRR: Port bit reset register
	GPIO_BRR_BR0_Pos  = 0x0    // Position of BR0 field.
	GPIO_BRR_BR0_Msk  = 0x1    // Bit mask of BR0 field.
	GPIO_BRR_BR0      = 0x1    // Bit BR0.
	GPIO_BRR_BR1_Pos  = 0x1    // Position of BR1 field.
	GPIO_BRR_BR1_Msk  = 0x2    // Bit mask of BR1 field.
	GPIO_BRR_BR1      = 0x2    // Bit BR1.
	GPIO_BRR_BR2_Pos  = 0x2    // Position of BR2 field.
	GPIO_BRR_BR2_Msk  = 0x4    // Bit mask of BR2 field.
	GPIO_BRR_BR2      = 0x4    // Bit BR2.
	GPIO_BRR_BR3_Pos  = 0x3    // Position of BR3 field.
	GPIO_BRR_BR3_Msk  = 0x8    // Bit mask of BR3 field.
	GPIO_BRR_BR3      = 0x8    // Bit BR3.
	GPIO_BRR_BR4_Pos  = 0x4    // Position of BR4 field.
	GPIO_BRR_BR4_Msk  = 0x10   // Bit mask of BR4 field.
	GPIO_BRR_BR4      = 0x10   // Bit BR4.
	GPIO_BRR_BR5_Pos  = 0x5    // Position of BR5 field.
	GPIO_BRR_BR5_Msk  = 0x20   // Bit mask of BR5 field.
	GPIO_BRR_BR5      = 0x20   // Bit BR5.
	GPIO_BRR_BR6_Pos  = 0x6    // Position of BR6 field.
	GPIO_BRR_BR6_Msk  = 0x40   // Bit mask of BR6 field.
	GPIO_BRR_BR6      = 0x40   // Bit BR6.
	GPIO_BRR_BR7_Pos  = 0x7    // Position of BR7 field.
	GPIO_BRR_BR7_Msk  = 0x80   // Bit mask of BR7 field.
	GPIO_BRR_BR7      = 0x80   // Bit BR7.
	GPIO_BRR_BR8_Pos  = 0x8    // Position of BR8 field.
	GPIO_BRR_BR8_Msk  = 0x100  // Bit mask of BR8 field.
	GPIO_BRR_BR8      = 0x100  // Bit BR8.
	GPIO_BRR_BR9_Pos  = 0x9    // Position of BR9 field.
	GPIO_BRR_BR9_Msk  = 0x200  // Bit mask of BR9 field.
	GPIO_BRR_BR9      = 0x200  // Bit BR9.
	GPIO_BRR_BR10_Pos = 0xa    // Position of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400  // Bit mask of BR10 field.
	GPIO_BRR_BR10     = 0x400  // Bit BR10.
	GPIO_BRR_BR11_Pos = 0xb    // Position of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800  // Bit mask of BR11 field.
	GPIO_BRR_BR11     = 0x800  // Bit BR11.
	GPIO_BRR_BR12_Pos = 0xc    // Position of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000 // Bit mask of BR12 field.
	GPIO_BRR_BR12     = 0x1000 // Bit BR12.
	GPIO_BRR_BR13_Pos = 0xd    // Position of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000 // Bit mask of BR13 field.
	GPIO_BRR_BR13     = 0x2000 // Bit BR13.
	GPIO_BRR_BR14_Pos = 0xe    // Position of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000 // Bit mask of BR14 field.
	GPIO_BRR_BR14     = 0x4000 // Bit BR14.
	GPIO_BRR_BR15_Pos = 0xf    // Position of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000 // Bit mask of BR15 field.
	GPIO_BRR_BR15     = 0x8000 // Bit BR15.
)

// Bitfields for SPI1: Serial peripheral interface
const (
	// CR1: control register 1
	SPI_CR1_BIDIMODE_Pos = 0xf    // Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000 // Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE     = 0x8000 // Bit BIDIMODE.
	SPI_CR1_BIDIOE_Pos   = 0xe    // Position of BIDIOE field.
	SPI_CR1_BIDIOE_Msk   = 0x4000 // Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE       = 0x4000 // Bit BIDIOE.
	SPI_CR1_CRCEN_Pos    = 0xd    // Position of CRCEN field.
	SPI_CR1_CRCEN_Msk    = 0x2000 // Bit mask of CRCEN field.
	SPI_CR1_CRCEN        = 0x2000 // Bit CRCEN.
	SPI_CR1_CRCNEXT_Pos  = 0xc    // Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk  = 0x1000 // Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT      = 0x1000 // Bit CRCNEXT.
	SPI_CR1_DFF_Pos      = 0xb    // Position of DFF field.
	SPI_CR1_DFF_Msk      = 0x800  // Bit mask of DFF field.
	SPI_CR1_DFF          = 0x800  // Bit DFF.
	SPI_CR1_RXONLY_Pos   = 0xa    // Position of RXONLY field.
	SPI_CR1_RXONLY_Msk   = 0x400  // Bit mask of RXONLY field.
	SPI_CR1_RXONLY       = 0x400  // Bit RXONLY.
	SPI_CR1_SSM_Pos      = 0x9    // Position of SSM field.
	SPI_CR1_SSM_Msk      = 0x200  // Bit mask of SSM field.
	SPI_CR1_SSM          = 0x200  // Bit SSM.
	SPI_CR1_SSI_Pos      = 0x8    // Position of SSI field.
	SPI_CR1_SSI_Msk      = 0x100  // Bit mask of SSI field.
	SPI_CR1_SSI          = 0x100  // Bit SSI.
	SPI_CR1_LSBFIRST_Pos = 0x7    // Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80   // Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST     = 0x80   // Bit LSBFIRST.
	SPI_CR1_SPE_Pos      = 0x6    // Position of SPE field.
	SPI_CR1_SPE_Msk      = 0x40   // Bit mask of SPE field.
	SPI_CR1_SPE          = 0x40   // Bit SPE.
	SPI_CR1_BR_Pos       = 0x3    // Position of BR field.
	SPI_CR1_BR_Msk       = 0x38   // Bit mask of BR field.
	SPI_CR1_MSTR_Pos     = 0x2    // Position of MSTR field.
	SPI_CR1_MSTR_Msk     = 0x4    // Bit mask of MSTR field.
	SPI_CR1_MSTR         = 0x4    // Bit MSTR.
	SPI_CR1_CPOL_Pos     = 0x1    // Position of CPOL field.
	SPI_CR1_CPOL_Msk     = 0x2    // Bit mask of CPOL field.
	SPI_CR1_CPOL         = 0x2    // Bit CPOL.
	SPI_CR1_CPHA_Pos     = 0x0    // Position of CPHA field.
	SPI_CR1_CPHA_Msk     = 0x1    // Bit mask of CPHA field.
	SPI_CR1_CPHA         = 0x1    // Bit CPHA.

	// CR2: control register 2
	SPI_CR2_RXDMAEN_Pos = 0x0    // Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1    // Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN     = 0x1    // Bit RXDMAEN.
	SPI_CR2_TXDMAEN_Pos = 0x1    // Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2    // Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN     = 0x2    // Bit TXDMAEN.
	SPI_CR2_SSOE_Pos    = 0x2    // Position of SSOE field.
	SPI_CR2_SSOE_Msk    = 0x4    // Bit mask of SSOE field.
	SPI_CR2_SSOE        = 0x4    // Bit SSOE.
	SPI_CR2_NSSP_Pos    = 0x3    // Position of NSSP field.
	SPI_CR2_NSSP_Msk    = 0x8    // Bit mask of NSSP field.
	SPI_CR2_NSSP        = 0x8    // Bit NSSP.
	SPI_CR2_FRF_Pos     = 0x4    // Position of FRF field.
	SPI_CR2_FRF_Msk     = 0x10   // Bit mask of FRF field.
	SPI_CR2_FRF         = 0x10   // Bit FRF.
	SPI_CR2_ERRIE_Pos   = 0x5    // Position of ERRIE field.
	SPI_CR2_ERRIE_Msk   = 0x20   // Bit mask of ERRIE field.
	SPI_CR2_ERRIE       = 0x20   // Bit ERRIE.
	SPI_CR2_RXNEIE_Pos  = 0x6    // Position of RXNEIE field.
	SPI_CR2_RXNEIE_Msk  = 0x40   // Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE      = 0x40   // Bit RXNEIE.
	SPI_CR2_TXEIE_Pos   = 0x7    // Position of TXEIE field.
	SPI_CR2_TXEIE_Msk   = 0x80   // Bit mask of TXEIE field.
	SPI_CR2_TXEIE       = 0x80   // Bit TXEIE.
	SPI_CR2_DS_Pos      = 0x8    // Position of DS field.
	SPI_CR2_DS_Msk      = 0xf00  // Bit mask of DS field.
	SPI_CR2_FRXTH_Pos   = 0xc    // Position of FRXTH field.
	SPI_CR2_FRXTH_Msk   = 0x1000 // Bit mask of FRXTH field.
	SPI_CR2_FRXTH       = 0x1000 // Bit FRXTH.
	SPI_CR2_LDMA_RX_Pos = 0xd    // Position of LDMA_RX field.
	SPI_CR2_LDMA_RX_Msk = 0x2000 // Bit mask of LDMA_RX field.
	SPI_CR2_LDMA_RX     = 0x2000 // Bit LDMA_RX.
	SPI_CR2_LDMA_TX_Pos = 0xe    // Position of LDMA_TX field.
	SPI_CR2_LDMA_TX_Msk = 0x4000 // Bit mask of LDMA_TX field.
	SPI_CR2_LDMA_TX     = 0x4000 // Bit LDMA_TX.

	// SR: status register
	SPI_SR_RXNE_Pos   = 0x0    // Position of RXNE field.
	SPI_SR_RXNE_Msk   = 0x1    // Bit mask of RXNE field.
	SPI_SR_RXNE       = 0x1    // Bit RXNE.
	SPI_SR_TXE_Pos    = 0x1    // Position of TXE field.
	SPI_SR_TXE_Msk    = 0x2    // Bit mask of TXE field.
	SPI_SR_TXE        = 0x2    // Bit TXE.
	SPI_SR_CHSIDE_Pos = 0x2    // Position of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4    // Bit mask of CHSIDE field.
	SPI_SR_CHSIDE     = 0x4    // Bit CHSIDE.
	SPI_SR_UDR_Pos    = 0x3    // Position of UDR field.
	SPI_SR_UDR_Msk    = 0x8    // Bit mask of UDR field.
	SPI_SR_UDR        = 0x8    // Bit UDR.
	SPI_SR_CRCERR_Pos = 0x4    // Position of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10   // Bit mask of CRCERR field.
	SPI_SR_CRCERR     = 0x10   // Bit CRCERR.
	SPI_SR_MODF_Pos   = 0x5    // Position of MODF field.
	SPI_SR_MODF_Msk   = 0x20   // Bit mask of MODF field.
	SPI_SR_MODF       = 0x20   // Bit MODF.
	SPI_SR_OVR_Pos    = 0x6    // Position of OVR field.
	SPI_SR_OVR_Msk    = 0x40   // Bit mask of OVR field.
	SPI_SR_OVR        = 0x40   // Bit OVR.
	SPI_SR_BSY_Pos    = 0x7    // Position of BSY field.
	SPI_SR_BSY_Msk    = 0x80   // Bit mask of BSY field.
	SPI_SR_BSY        = 0x80   // Bit BSY.
	SPI_SR_TIFRFE_Pos = 0x8    // Position of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100  // Bit mask of TIFRFE field.
	SPI_SR_TIFRFE     = 0x100  // Bit TIFRFE.
	SPI_SR_FRLVL_Pos  = 0x9    // Position of FRLVL field.
	SPI_SR_FRLVL_Msk  = 0x600  // Bit mask of FRLVL field.
	SPI_SR_FTLVL_Pos  = 0xb    // Position of FTLVL field.
	SPI_SR_FTLVL_Msk  = 0x1800 // Bit mask of FTLVL field.

	// DR: data register
	SPI_DR_DR_Pos = 0x0    // Position of DR field.
	SPI_DR_DR_Msk = 0xffff // Bit mask of DR field.

	// CRCPR: CRC polynomial register
	SPI_CRCPR_CRCPOLY_Pos = 0x0    // Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff // Bit mask of CRCPOLY field.

	// RXCRCR: RX CRC register
	SPI_RXCRCR_RxCRC_Pos = 0x0    // Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff // Bit mask of RxCRC field.

	// TXCRCR: TX CRC register
	SPI_TXCRCR_TxCRC_Pos = 0x0    // Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff // Bit mask of TxCRC field.

	// I2SCFGR: I2S configuration register
	SPI_I2SCFGR_I2SMOD_Pos  = 0xb   // Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk  = 0x800 // Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD      = 0x800 // Bit I2SMOD.
	SPI_I2SCFGR_I2SE_Pos    = 0xa   // Position of I2SE field.
	SPI_I2SCFGR_I2SE_Msk    = 0x400 // Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE        = 0x400 // Bit I2SE.
	SPI_I2SCFGR_I2SCFG_Pos  = 0x8   // Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk  = 0x300 // Bit mask of I2SCFG field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7   // Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80  // Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC     = 0x80  // Bit PCMSYNC.
	SPI_I2SCFGR_I2SSTD_Pos  = 0x4   // Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk  = 0x30  // Bit mask of I2SSTD field.
	SPI_I2SCFGR_CKPOL_Pos   = 0x3   // Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk   = 0x8   // Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL       = 0x8   // Bit CKPOL.
	SPI_I2SCFGR_DATLEN_Pos  = 0x1   // Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk  = 0x6   // Bit mask of DATLEN field.
	SPI_I2SCFGR_CHLEN_Pos   = 0x0   // Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk   = 0x1   // Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN       = 0x1   // Bit CHLEN.

	// I2SPR: I2S prescaler register
	SPI_I2SPR_MCKOE_Pos  = 0x9   // Position of MCKOE field.
	SPI_I2SPR_MCKOE_Msk  = 0x200 // Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE      = 0x200 // Bit MCKOE.
	SPI_I2SPR_ODD_Pos    = 0x8   // Position of ODD field.
	SPI_I2SPR_ODD_Msk    = 0x100 // Bit mask of ODD field.
	SPI_I2SPR_ODD        = 0x100 // Bit ODD.
	SPI_I2SPR_I2SDIV_Pos = 0x0   // Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff  // Bit mask of I2SDIV field.
)

// Bitfields for DAC: Digital-to-analog converter
const (
	// CR: control register
	DAC_CR_EN1_Pos       = 0x0    // Position of EN1 field.
	DAC_CR_EN1_Msk       = 0x1    // Bit mask of EN1 field.
	DAC_CR_EN1           = 0x1    // Bit EN1.
	DAC_CR_BOFF1_Pos     = 0x1    // Position of BOFF1 field.
	DAC_CR_BOFF1_Msk     = 0x2    // Bit mask of BOFF1 field.
	DAC_CR_BOFF1         = 0x2    // Bit BOFF1.
	DAC_CR_TEN1_Pos      = 0x2    // Position of TEN1 field.
	DAC_CR_TEN1_Msk      = 0x4    // Bit mask of TEN1 field.
	DAC_CR_TEN1          = 0x4    // Bit TEN1.
	DAC_CR_TSEL10_Pos    = 0x3    // Position of TSEL10 field.
	DAC_CR_TSEL10_Msk    = 0x8    // Bit mask of TSEL10 field.
	DAC_CR_TSEL10        = 0x8    // Bit TSEL10.
	DAC_CR_TSEL11_Pos    = 0x4    // Position of TSEL11 field.
	DAC_CR_TSEL11_Msk    = 0x10   // Bit mask of TSEL11 field.
	DAC_CR_TSEL11        = 0x10   // Bit TSEL11.
	DAC_CR_TSEL12_Pos    = 0x5    // Position of TSEL12 field.
	DAC_CR_TSEL12_Msk    = 0x20   // Bit mask of TSEL12 field.
	DAC_CR_TSEL12        = 0x20   // Bit TSEL12.
	DAC_CR_DMAEN1_Pos    = 0xc    // Position of DMAEN1 field.
	DAC_CR_DMAEN1_Msk    = 0x1000 // Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1        = 0x1000 // Bit DMAEN1.
	DAC_CR_DMAUDRIE1_Pos = 0xd    // Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000 // Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1     = 0x2000 // Bit DMAUDRIE1.

	// SWTRIGR: software trigger register
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0 // Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1 // Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1     = 0x1 // Bit SWTRIG1.

	// DHR12R1: channel1 12-bit right-aligned data holding           register
	DAC_DHR12R1_DACC1DHR_Pos = 0x0   // Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff // Bit mask of DACC1DHR field.

	// DHR12L1: channel1 12-bit left aligned data holding           register
	DAC_DHR12L1_DACC1DHR_Pos = 0x4    // Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0 // Bit mask of DACC1DHR field.

	// DHR8R1: channel1 8-bit right aligned data holding           register
	DAC_DHR8R1_DACC1DHR_Pos = 0x0  // Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff // Bit mask of DACC1DHR field.

	// DOR1: channel1 data output register
	DAC_DOR1_DACC1DOR_Pos = 0x0   // Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff // Bit mask of DACC1DOR field.

	// SR: status register
	DAC_SR_DMAUDR2_Pos = 0x1d       // Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000 // Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2     = 0x20000000 // Bit DMAUDR2.
	DAC_SR_DMAUDR1_Pos = 0xd        // Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000     // Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1     = 0x2000     // Bit DMAUDR1.
)

// Bitfields for PWR: Power control
const (
	// CR: power control register
	PWR_CR_FPDS_Pos = 0x9   // Position of FPDS field.
	PWR_CR_FPDS_Msk = 0x200 // Bit mask of FPDS field.
	PWR_CR_FPDS     = 0x200 // Bit FPDS.
	PWR_CR_DBP_Pos  = 0x8   // Position of DBP field.
	PWR_CR_DBP_Msk  = 0x100 // Bit mask of DBP field.
	PWR_CR_DBP      = 0x100 // Bit DBP.
	PWR_CR_PLS_Pos  = 0x5   // Position of PLS field.
	PWR_CR_PLS_Msk  = 0xe0  // Bit mask of PLS field.
	PWR_CR_PVDE_Pos = 0x4   // Position of PVDE field.
	PWR_CR_PVDE_Msk = 0x10  // Bit mask of PVDE field.
	PWR_CR_PVDE     = 0x10  // Bit PVDE.
	PWR_CR_CSBF_Pos = 0x3   // Position of CSBF field.
	PWR_CR_CSBF_Msk = 0x8   // Bit mask of CSBF field.
	PWR_CR_CSBF     = 0x8   // Bit CSBF.
	PWR_CR_CWUF_Pos = 0x2   // Position of CWUF field.
	PWR_CR_CWUF_Msk = 0x4   // Bit mask of CWUF field.
	PWR_CR_CWUF     = 0x4   // Bit CWUF.
	PWR_CR_PDDS_Pos = 0x1   // Position of PDDS field.
	PWR_CR_PDDS_Msk = 0x2   // Bit mask of PDDS field.
	PWR_CR_PDDS     = 0x2   // Bit PDDS.
	PWR_CR_LPDS_Pos = 0x0   // Position of LPDS field.
	PWR_CR_LPDS_Msk = 0x1   // Bit mask of LPDS field.
	PWR_CR_LPDS     = 0x1   // Bit LPDS.

	// CSR: power control/status register
	PWR_CSR_BRE_Pos  = 0x9   // Position of BRE field.
	PWR_CSR_BRE_Msk  = 0x200 // Bit mask of BRE field.
	PWR_CSR_BRE      = 0x200 // Bit BRE.
	PWR_CSR_EWUP_Pos = 0x8   // Position of EWUP field.
	PWR_CSR_EWUP_Msk = 0x100 // Bit mask of EWUP field.
	PWR_CSR_EWUP     = 0x100 // Bit EWUP.
	PWR_CSR_BRR_Pos  = 0x3   // Position of BRR field.
	PWR_CSR_BRR_Msk  = 0x8   // Bit mask of BRR field.
	PWR_CSR_BRR      = 0x8   // Bit BRR.
	PWR_CSR_PVDO_Pos = 0x2   // Position of PVDO field.
	PWR_CSR_PVDO_Msk = 0x4   // Bit mask of PVDO field.
	PWR_CSR_PVDO     = 0x4   // Bit PVDO.
	PWR_CSR_SBF_Pos  = 0x1   // Position of SBF field.
	PWR_CSR_SBF_Msk  = 0x2   // Bit mask of SBF field.
	PWR_CSR_SBF      = 0x2   // Bit SBF.
	PWR_CSR_WUF_Pos  = 0x0   // Position of WUF field.
	PWR_CSR_WUF_Msk  = 0x1   // Bit mask of WUF field.
	PWR_CSR_WUF      = 0x1   // Bit WUF.
)

// Bitfields for I2C1: Inter-integrated circuit
const (
	// CR1: Control register 1
	I2C_CR1_PE_Pos        = 0x0      // Position of PE field.
	I2C_CR1_PE_Msk        = 0x1      // Bit mask of PE field.
	I2C_CR1_PE            = 0x1      // Bit PE.
	I2C_CR1_TXIE_Pos      = 0x1      // Position of TXIE field.
	I2C_CR1_TXIE_Msk      = 0x2      // Bit mask of TXIE field.
	I2C_CR1_TXIE          = 0x2      // Bit TXIE.
	I2C_CR1_RXIE_Pos      = 0x2      // Position of RXIE field.
	I2C_CR1_RXIE_Msk      = 0x4      // Bit mask of RXIE field.
	I2C_CR1_RXIE          = 0x4      // Bit RXIE.
	I2C_CR1_ADDRIE_Pos    = 0x3      // Position of ADDRIE field.
	I2C_CR1_ADDRIE_Msk    = 0x8      // Bit mask of ADDRIE field.
	I2C_CR1_ADDRIE        = 0x8      // Bit ADDRIE.
	I2C_CR1_NACKIE_Pos    = 0x4      // Position of NACKIE field.
	I2C_CR1_NACKIE_Msk    = 0x10     // Bit mask of NACKIE field.
	I2C_CR1_NACKIE        = 0x10     // Bit NACKIE.
	I2C_CR1_STOPIE_Pos    = 0x5      // Position of STOPIE field.
	I2C_CR1_STOPIE_Msk    = 0x20     // Bit mask of STOPIE field.
	I2C_CR1_STOPIE        = 0x20     // Bit STOPIE.
	I2C_CR1_TCIE_Pos      = 0x6      // Position of TCIE field.
	I2C_CR1_TCIE_Msk      = 0x40     // Bit mask of TCIE field.
	I2C_CR1_TCIE          = 0x40     // Bit TCIE.
	I2C_CR1_ERRIE_Pos     = 0x7      // Position of ERRIE field.
	I2C_CR1_ERRIE_Msk     = 0x80     // Bit mask of ERRIE field.
	I2C_CR1_ERRIE         = 0x80     // Bit ERRIE.
	I2C_CR1_DNF_Pos       = 0x8      // Position of DNF field.
	I2C_CR1_DNF_Msk       = 0xf00    // Bit mask of DNF field.
	I2C_CR1_ANFOFF_Pos    = 0xc      // Position of ANFOFF field.
	I2C_CR1_ANFOFF_Msk    = 0x1000   // Bit mask of ANFOFF field.
	I2C_CR1_ANFOFF        = 0x1000   // Bit ANFOFF.
	I2C_CR1_SWRST_Pos     = 0xd      // Position of SWRST field.
	I2C_CR1_SWRST_Msk     = 0x2000   // Bit mask of SWRST field.
	I2C_CR1_SWRST         = 0x2000   // Bit SWRST.
	I2C_CR1_TXDMAEN_Pos   = 0xe      // Position of TXDMAEN field.
	I2C_CR1_TXDMAEN_Msk   = 0x4000   // Bit mask of TXDMAEN field.
	I2C_CR1_TXDMAEN       = 0x4000   // Bit TXDMAEN.
	I2C_CR1_RXDMAEN_Pos   = 0xf      // Position of RXDMAEN field.
	I2C_CR1_RXDMAEN_Msk   = 0x8000   // Bit mask of RXDMAEN field.
	I2C_CR1_RXDMAEN       = 0x8000   // Bit RXDMAEN.
	I2C_CR1_SBC_Pos       = 0x10     // Position of SBC field.
	I2C_CR1_SBC_Msk       = 0x10000  // Bit mask of SBC field.
	I2C_CR1_SBC           = 0x10000  // Bit SBC.
	I2C_CR1_NOSTRETCH_Pos = 0x11     // Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x20000  // Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH     = 0x20000  // Bit NOSTRETCH.
	I2C_CR1_WUPEN_Pos     = 0x12     // Position of WUPEN field.
	I2C_CR1_WUPEN_Msk     = 0x40000  // Bit mask of WUPEN field.
	I2C_CR1_WUPEN         = 0x40000  // Bit WUPEN.
	I2C_CR1_GCEN_Pos      = 0x13     // Position of GCEN field.
	I2C_CR1_GCEN_Msk      = 0x80000  // Bit mask of GCEN field.
	I2C_CR1_GCEN          = 0x80000  // Bit GCEN.
	I2C_CR1_SMBHEN_Pos    = 0x14     // Position of SMBHEN field.
	I2C_CR1_SMBHEN_Msk    = 0x100000 // Bit mask of SMBHEN field.
	I2C_CR1_SMBHEN        = 0x100000 // Bit SMBHEN.
	I2C_CR1_SMBDEN_Pos    = 0x15     // Position of SMBDEN field.
	I2C_CR1_SMBDEN_Msk    = 0x200000 // Bit mask of SMBDEN field.
	I2C_CR1_SMBDEN        = 0x200000 // Bit SMBDEN.
	I2C_CR1_ALERTEN_Pos   = 0x16     // Position of ALERTEN field.
	I2C_CR1_ALERTEN_Msk   = 0x400000 // Bit mask of ALERTEN field.
	I2C_CR1_ALERTEN       = 0x400000 // Bit ALERTEN.
	I2C_CR1_PECEN_Pos     = 0x17     // Position of PECEN field.
	I2C_CR1_PECEN_Msk     = 0x800000 // Bit mask of PECEN field.
	I2C_CR1_PECEN         = 0x800000 // Bit PECEN.

	// CR2: Control register 2
	I2C_CR2_PECBYTE_Pos = 0x1a      // Position of PECBYTE field.
	I2C_CR2_PECBYTE_Msk = 0x4000000 // Bit mask of PECBYTE field.
	I2C_CR2_PECBYTE     = 0x4000000 // Bit PECBYTE.
	I2C_CR2_AUTOEND_Pos = 0x19      // Position of AUTOEND field.
	I2C_CR2_AUTOEND_Msk = 0x2000000 // Bit mask of AUTOEND field.
	I2C_CR2_AUTOEND     = 0x2000000 // Bit AUTOEND.
	I2C_CR2_RELOAD_Pos  = 0x18      // Position of RELOAD field.
	I2C_CR2_RELOAD_Msk  = 0x1000000 // Bit mask of RELOAD field.
	I2C_CR2_RELOAD      = 0x1000000 // Bit RELOAD.
	I2C_CR2_NBYTES_Pos  = 0x10      // Position of NBYTES field.
	I2C_CR2_NBYTES_Msk  = 0xff0000  // Bit mask of NBYTES field.
	I2C_CR2_NACK_Pos    = 0xf       // Position of NACK field.
	I2C_CR2_NACK_Msk    = 0x8000    // Bit mask of NACK field.
	I2C_CR2_NACK        = 0x8000    // Bit NACK.
	I2C_CR2_STOP_Pos    = 0xe       // Position of STOP field.
	I2C_CR2_STOP_Msk    = 0x4000    // Bit mask of STOP field.
	I2C_CR2_STOP        = 0x4000    // Bit STOP.
	I2C_CR2_START_Pos   = 0xd       // Position of START field.
	I2C_CR2_START_Msk   = 0x2000    // Bit mask of START field.
	I2C_CR2_START       = 0x2000    // Bit START.
	I2C_CR2_HEAD10R_Pos = 0xc       // Position of HEAD10R field.
	I2C_CR2_HEAD10R_Msk = 0x1000    // Bit mask of HEAD10R field.
	I2C_CR2_HEAD10R     = 0x1000    // Bit HEAD10R.
	I2C_CR2_ADD10_Pos   = 0xb       // Position of ADD10 field.
	I2C_CR2_ADD10_Msk   = 0x800     // Bit mask of ADD10 field.
	I2C_CR2_ADD10       = 0x800     // Bit ADD10.
	I2C_CR2_RD_WRN_Pos  = 0xa       // Position of RD_WRN field.
	I2C_CR2_RD_WRN_Msk  = 0x400     // Bit mask of RD_WRN field.
	I2C_CR2_RD_WRN      = 0x400     // Bit RD_WRN.
	I2C_CR2_SADD8_Pos   = 0x8       // Position of SADD8 field.
	I2C_CR2_SADD8_Msk   = 0x300     // Bit mask of SADD8 field.
	I2C_CR2_SADD1_Pos   = 0x1       // Position of SADD1 field.
	I2C_CR2_SADD1_Msk   = 0xfe      // Bit mask of SADD1 field.
	I2C_CR2_SADD0_Pos   = 0x0       // Position of SADD0 field.
	I2C_CR2_SADD0_Msk   = 0x1       // Bit mask of SADD0 field.
	I2C_CR2_SADD0       = 0x1       // Bit SADD0.

	// OAR1: Own address register 1
	I2C_OAR1_OA1_0_Pos   = 0x0    // Position of OA1_0 field.
	I2C_OAR1_OA1_0_Msk   = 0x1    // Bit mask of OA1_0 field.
	I2C_OAR1_OA1_0       = 0x1    // Bit OA1_0.
	I2C_OAR1_OA1_1_Pos   = 0x1    // Position of OA1_1 field.
	I2C_OAR1_OA1_1_Msk   = 0xfe   // Bit mask of OA1_1 field.
	I2C_OAR1_OA1_8_Pos   = 0x8    // Position of OA1_8 field.
	I2C_OAR1_OA1_8_Msk   = 0x300  // Bit mask of OA1_8 field.
	I2C_OAR1_OA1MODE_Pos = 0xa    // Position of OA1MODE field.
	I2C_OAR1_OA1MODE_Msk = 0x400  // Bit mask of OA1MODE field.
	I2C_OAR1_OA1MODE     = 0x400  // Bit OA1MODE.
	I2C_OAR1_OA1EN_Pos   = 0xf    // Position of OA1EN field.
	I2C_OAR1_OA1EN_Msk   = 0x8000 // Bit mask of OA1EN field.
	I2C_OAR1_OA1EN       = 0x8000 // Bit OA1EN.

	// OAR2: Own address register 2
	I2C_OAR2_OA2_Pos    = 0x1    // Position of OA2 field.
	I2C_OAR2_OA2_Msk    = 0xfe   // Bit mask of OA2 field.
	I2C_OAR2_OA2MSK_Pos = 0x8    // Position of OA2MSK field.
	I2C_OAR2_OA2MSK_Msk = 0x700  // Bit mask of OA2MSK field.
	I2C_OAR2_OA2EN_Pos  = 0xf    // Position of OA2EN field.
	I2C_OAR2_OA2EN_Msk  = 0x8000 // Bit mask of OA2EN field.
	I2C_OAR2_OA2EN      = 0x8000 // Bit OA2EN.

	// TIMINGR: Timing register
	I2C_TIMINGR_SCLL_Pos   = 0x0        // Position of SCLL field.
	I2C_TIMINGR_SCLL_Msk   = 0xff       // Bit mask of SCLL field.
	I2C_TIMINGR_SCLH_Pos   = 0x8        // Position of SCLH field.
	I2C_TIMINGR_SCLH_Msk   = 0xff00     // Bit mask of SCLH field.
	I2C_TIMINGR_SDADEL_Pos = 0x10       // Position of SDADEL field.
	I2C_TIMINGR_SDADEL_Msk = 0xf0000    // Bit mask of SDADEL field.
	I2C_TIMINGR_SCLDEL_Pos = 0x14       // Position of SCLDEL field.
	I2C_TIMINGR_SCLDEL_Msk = 0xf00000   // Bit mask of SCLDEL field.
	I2C_TIMINGR_PRESC_Pos  = 0x1c       // Position of PRESC field.
	I2C_TIMINGR_PRESC_Msk  = 0xf0000000 // Bit mask of PRESC field.

	// TIMEOUTR: Status register 1
	I2C_TIMEOUTR_TIMEOUTA_Pos = 0x0        // Position of TIMEOUTA field.
	I2C_TIMEOUTR_TIMEOUTA_Msk = 0xfff      // Bit mask of TIMEOUTA field.
	I2C_TIMEOUTR_TIDLE_Pos    = 0xc        // Position of TIDLE field.
	I2C_TIMEOUTR_TIDLE_Msk    = 0x1000     // Bit mask of TIDLE field.
	I2C_TIMEOUTR_TIDLE        = 0x1000     // Bit TIDLE.
	I2C_TIMEOUTR_TIMOUTEN_Pos = 0xf        // Position of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN_Msk = 0x8000     // Bit mask of TIMOUTEN field.
	I2C_TIMEOUTR_TIMOUTEN     = 0x8000     // Bit TIMOUTEN.
	I2C_TIMEOUTR_TIMEOUTB_Pos = 0x10       // Position of TIMEOUTB field.
	I2C_TIMEOUTR_TIMEOUTB_Msk = 0xfff0000  // Bit mask of TIMEOUTB field.
	I2C_TIMEOUTR_TEXTEN_Pos   = 0x1f       // Position of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN_Msk   = 0x80000000 // Bit mask of TEXTEN field.
	I2C_TIMEOUTR_TEXTEN       = 0x80000000 // Bit TEXTEN.

	// ISR: Interrupt and Status register
	I2C_ISR_ADDCODE_Pos = 0x11     // Position of ADDCODE field.
	I2C_ISR_ADDCODE_Msk = 0xfe0000 // Bit mask of ADDCODE field.
	I2C_ISR_DIR_Pos     = 0x10     // Position of DIR field.
	I2C_ISR_DIR_Msk     = 0x10000  // Bit mask of DIR field.
	I2C_ISR_DIR         = 0x10000  // Bit DIR.
	I2C_ISR_BUSY_Pos    = 0xf      // Position of BUSY field.
	I2C_ISR_BUSY_Msk    = 0x8000   // Bit mask of BUSY field.
	I2C_ISR_BUSY        = 0x8000   // Bit BUSY.
	I2C_ISR_ALERT_Pos   = 0xd      // Position of ALERT field.
	I2C_ISR_ALERT_Msk   = 0x2000   // Bit mask of ALERT field.
	I2C_ISR_ALERT       = 0x2000   // Bit ALERT.
	I2C_ISR_TIMEOUT_Pos = 0xc      // Position of TIMEOUT field.
	I2C_ISR_TIMEOUT_Msk = 0x1000   // Bit mask of TIMEOUT field.
	I2C_ISR_TIMEOUT     = 0x1000   // Bit TIMEOUT.
	I2C_ISR_PECERR_Pos  = 0xb      // Position of PECERR field.
	I2C_ISR_PECERR_Msk  = 0x800    // Bit mask of PECERR field.
	I2C_ISR_PECERR      = 0x800    // Bit PECERR.
	I2C_ISR_OVR_Pos     = 0xa      // Position of OVR field.
	I2C_ISR_OVR_Msk     = 0x400    // Bit mask of OVR field.
	I2C_ISR_OVR         = 0x400    // Bit OVR.
	I2C_ISR_ARLO_Pos    = 0x9      // Position of ARLO field.
	I2C_ISR_ARLO_Msk    = 0x200    // Bit mask of ARLO field.
	I2C_ISR_ARLO        = 0x200    // Bit ARLO.
	I2C_ISR_BERR_Pos    = 0x8      // Position of BERR field.
	I2C_ISR_BERR_Msk    = 0x100    // Bit mask of BERR field.
	I2C_ISR_BERR        = 0x100    // Bit BERR.
	I2C_ISR_TCR_Pos     = 0x7      // Position of TCR field.
	I2C_ISR_TCR_Msk     = 0x80     // Bit mask of TCR field.
	I2C_ISR_TCR         = 0x80     // Bit TCR.
	I2C_ISR_TC_Pos      = 0x6      // Position of TC field.
	I2C_ISR_TC_Msk      = 0x40     // Bit mask of TC field.
	I2C_ISR_TC          = 0x40     // Bit TC.
	I2C_ISR_STOPF_Pos   = 0x5      // Position of STOPF field.
	I2C_ISR_STOPF_Msk   = 0x20     // Bit mask of STOPF field.
	I2C_ISR_STOPF       = 0x20     // Bit STOPF.
	I2C_ISR_NACKF_Pos   = 0x4      // Position of NACKF field.
	I2C_ISR_NACKF_Msk   = 0x10     // Bit mask of NACKF field.
	I2C_ISR_NACKF       = 0x10     // Bit NACKF.
	I2C_ISR_ADDR_Pos    = 0x3      // Position of ADDR field.
	I2C_ISR_ADDR_Msk    = 0x8      // Bit mask of ADDR field.
	I2C_ISR_ADDR        = 0x8      // Bit ADDR.
	I2C_ISR_RXNE_Pos    = 0x2      // Position of RXNE field.
	I2C_ISR_RXNE_Msk    = 0x4      // Bit mask of RXNE field.
	I2C_ISR_RXNE        = 0x4      // Bit RXNE.
	I2C_ISR_TXIS_Pos    = 0x1      // Position of TXIS field.
	I2C_ISR_TXIS_Msk    = 0x2      // Bit mask of TXIS field.
	I2C_ISR_TXIS        = 0x2      // Bit TXIS.
	I2C_ISR_TXE_Pos     = 0x0      // Position of TXE field.
	I2C_ISR_TXE_Msk     = 0x1      // Bit mask of TXE field.
	I2C_ISR_TXE         = 0x1      // Bit TXE.

	// ICR: Interrupt clear register
	I2C_ICR_ALERTCF_Pos  = 0xd    // Position of ALERTCF field.
	I2C_ICR_ALERTCF_Msk  = 0x2000 // Bit mask of ALERTCF field.
	I2C_ICR_ALERTCF      = 0x2000 // Bit ALERTCF.
	I2C_ICR_TIMOUTCF_Pos = 0xc    // Position of TIMOUTCF field.
	I2C_ICR_TIMOUTCF_Msk = 0x1000 // Bit mask of TIMOUTCF field.
	I2C_ICR_TIMOUTCF     = 0x1000 // Bit TIMOUTCF.
	I2C_ICR_PECCF_Pos    = 0xb    // Position of PECCF field.
	I2C_ICR_PECCF_Msk    = 0x800  // Bit mask of PECCF field.
	I2C_ICR_PECCF        = 0x800  // Bit PECCF.
	I2C_ICR_OVRCF_Pos    = 0xa    // Position of OVRCF field.
	I2C_ICR_OVRCF_Msk    = 0x400  // Bit mask of OVRCF field.
	I2C_ICR_OVRCF        = 0x400  // Bit OVRCF.
	I2C_ICR_ARLOCF_Pos   = 0x9    // Position of ARLOCF field.
	I2C_ICR_ARLOCF_Msk   = 0x200  // Bit mask of ARLOCF field.
	I2C_ICR_ARLOCF       = 0x200  // Bit ARLOCF.
	I2C_ICR_BERRCF_Pos   = 0x8    // Position of BERRCF field.
	I2C_ICR_BERRCF_Msk   = 0x100  // Bit mask of BERRCF field.
	I2C_ICR_BERRCF       = 0x100  // Bit BERRCF.
	I2C_ICR_STOPCF_Pos   = 0x5    // Position of STOPCF field.
	I2C_ICR_STOPCF_Msk   = 0x20   // Bit mask of STOPCF field.
	I2C_ICR_STOPCF       = 0x20   // Bit STOPCF.
	I2C_ICR_NACKCF_Pos   = 0x4    // Position of NACKCF field.
	I2C_ICR_NACKCF_Msk   = 0x10   // Bit mask of NACKCF field.
	I2C_ICR_NACKCF       = 0x10   // Bit NACKCF.
	I2C_ICR_ADDRCF_Pos   = 0x3    // Position of ADDRCF field.
	I2C_ICR_ADDRCF_Msk   = 0x8    // Bit mask of ADDRCF field.
	I2C_ICR_ADDRCF       = 0x8    // Bit ADDRCF.

	// PECR: PEC register
	I2C_PECR_PEC_Pos = 0x0  // Position of PEC field.
	I2C_PECR_PEC_Msk = 0xff // Bit mask of PEC field.

	// RXDR: Receive data register
	I2C_RXDR_RXDATA_Pos = 0x0  // Position of RXDATA field.
	I2C_RXDR_RXDATA_Msk = 0xff // Bit mask of RXDATA field.

	// TXDR: Transmit data register
	I2C_TXDR_TXDATA_Pos = 0x0  // Position of TXDATA field.
	I2C_TXDR_TXDATA_Msk = 0xff // Bit mask of TXDATA field.
)

// Bitfields for IWDG: Independent watchdog
const (
	// KR: Key register
	IWDG_KR_KEY_Pos = 0x0    // Position of KEY field.
	IWDG_KR_KEY_Msk = 0xffff // Bit mask of KEY field.

	// PR: Prescaler register
	IWDG_PR_PR_Pos = 0x0 // Position of PR field.
	IWDG_PR_PR_Msk = 0x7 // Bit mask of PR field.

	// RLR: Reload register
	IWDG_RLR_RL_Pos = 0x0   // Position of RL field.
	IWDG_RLR_RL_Msk = 0xfff // Bit mask of RL field.

	// SR: Status register
	IWDG_SR_PVU_Pos = 0x0 // Position of PVU field.
	IWDG_SR_PVU_Msk = 0x1 // Bit mask of PVU field.
	IWDG_SR_PVU     = 0x1 // Bit PVU.
	IWDG_SR_RVU_Pos = 0x1 // Position of RVU field.
	IWDG_SR_RVU_Msk = 0x2 // Bit mask of RVU field.
	IWDG_SR_RVU     = 0x2 // Bit RVU.
	IWDG_SR_WVU_Pos = 0x2 // Position of WVU field.
	IWDG_SR_WVU_Msk = 0x4 // Bit mask of WVU field.
	IWDG_SR_WVU     = 0x4 // Bit WVU.

	// WINR: Window register
	IWDG_WINR_WIN_Pos = 0x0   // Position of WIN field.
	IWDG_WINR_WIN_Msk = 0xfff // Bit mask of WIN field.
)

// Bitfields for WWDG: Window watchdog
const (
	// CR: Control register
	WWDG_CR_WDGA_Pos = 0x7  // Position of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80 // Bit mask of WDGA field.
	WWDG_CR_WDGA     = 0x80 // Bit WDGA.
	WWDG_CR_T_Pos    = 0x0  // Position of T field.
	WWDG_CR_T_Msk    = 0x7f // Bit mask of T field.

	// CFR: Configuration register
	WWDG_CFR_EWI_Pos   = 0x9   // Position of EWI field.
	WWDG_CFR_EWI_Msk   = 0x200 // Bit mask of EWI field.
	WWDG_CFR_EWI       = 0x200 // Bit EWI.
	WWDG_CFR_WDGTB_Pos = 0x7   // Position of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180 // Bit mask of WDGTB field.
	WWDG_CFR_W_Pos     = 0x0   // Position of W field.
	WWDG_CFR_W_Msk     = 0x7f  // Bit mask of W field.

	// SR: Status register
	WWDG_SR_EWIF_Pos = 0x0 // Position of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1 // Bit mask of EWIF field.
	WWDG_SR_EWIF     = 0x1 // Bit EWIF.
)

// Bitfields for TIM1: Advanced-timers
const (
	// CR1: control register 1
	TIM_CR1_CKD_Pos  = 0x8   // Position of CKD field.
	TIM_CR1_CKD_Msk  = 0x300 // Bit mask of CKD field.
	TIM_CR1_ARPE_Pos = 0x7   // Position of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80  // Bit mask of ARPE field.
	TIM_CR1_ARPE     = 0x80  // Bit ARPE.
	TIM_CR1_CMS_Pos  = 0x5   // Position of CMS field.
	TIM_CR1_CMS_Msk  = 0x60  // Bit mask of CMS field.
	TIM_CR1_DIR_Pos  = 0x4   // Position of DIR field.
	TIM_CR1_DIR_Msk  = 0x10  // Bit mask of DIR field.
	TIM_CR1_DIR      = 0x10  // Bit DIR.
	TIM_CR1_OPM_Pos  = 0x3   // Position of OPM field.
	TIM_CR1_OPM_Msk  = 0x8   // Bit mask of OPM field.
	TIM_CR1_OPM      = 0x8   // Bit OPM.
	TIM_CR1_URS_Pos  = 0x2   // Position of URS field.
	TIM_CR1_URS_Msk  = 0x4   // Bit mask of URS field.
	TIM_CR1_URS      = 0x4   // Bit URS.
	TIM_CR1_UDIS_Pos = 0x1   // Position of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2   // Bit mask of UDIS field.
	TIM_CR1_UDIS     = 0x2   // Bit UDIS.
	TIM_CR1_CEN_Pos  = 0x0   // Position of CEN field.
	TIM_CR1_CEN_Msk  = 0x1   // Bit mask of CEN field.
	TIM_CR1_CEN      = 0x1   // Bit CEN.

	// CR2: control register 2
	TIM_CR2_OIS4_Pos  = 0xe    // Position of OIS4 field.
	TIM_CR2_OIS4_Msk  = 0x4000 // Bit mask of OIS4 field.
	TIM_CR2_OIS4      = 0x4000 // Bit OIS4.
	TIM_CR2_OIS3N_Pos = 0xd    // Position of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000 // Bit mask of OIS3N field.
	TIM_CR2_OIS3N     = 0x2000 // Bit OIS3N.
	TIM_CR2_OIS3_Pos  = 0xc    // Position of OIS3 field.
	TIM_CR2_OIS3_Msk  = 0x1000 // Bit mask of OIS3 field.
	TIM_CR2_OIS3      = 0x1000 // Bit OIS3.
	TIM_CR2_OIS2N_Pos = 0xb    // Position of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800  // Bit mask of OIS2N field.
	TIM_CR2_OIS2N     = 0x800  // Bit OIS2N.
	TIM_CR2_OIS2_Pos  = 0xa    // Position of OIS2 field.
	TIM_CR2_OIS2_Msk  = 0x400  // Bit mask of OIS2 field.
	TIM_CR2_OIS2      = 0x400  // Bit OIS2.
	TIM_CR2_OIS1N_Pos = 0x9    // Position of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200  // Bit mask of OIS1N field.
	TIM_CR2_OIS1N     = 0x200  // Bit OIS1N.
	TIM_CR2_OIS1_Pos  = 0x8    // Position of OIS1 field.
	TIM_CR2_OIS1_Msk  = 0x100  // Bit mask of OIS1 field.
	TIM_CR2_OIS1      = 0x100  // Bit OIS1.
	TIM_CR2_TI1S_Pos  = 0x7    // Position of TI1S field.
	TIM_CR2_TI1S_Msk  = 0x80   // Bit mask of TI1S field.
	TIM_CR2_TI1S      = 0x80   // Bit TI1S.
	TIM_CR2_MMS_Pos   = 0x4    // Position of MMS field.
	TIM_CR2_MMS_Msk   = 0x70   // Bit mask of MMS field.
	TIM_CR2_CCDS_Pos  = 0x3    // Position of CCDS field.
	TIM_CR2_CCDS_Msk  = 0x8    // Bit mask of CCDS field.
	TIM_CR2_CCDS      = 0x8    // Bit CCDS.
	TIM_CR2_CCUS_Pos  = 0x2    // Position of CCUS field.
	TIM_CR2_CCUS_Msk  = 0x4    // Bit mask of CCUS field.
	TIM_CR2_CCUS      = 0x4    // Bit CCUS.
	TIM_CR2_CCPC_Pos  = 0x0    // Position of CCPC field.
	TIM_CR2_CCPC_Msk  = 0x1    // Bit mask of CCPC field.
	TIM_CR2_CCPC      = 0x1    // Bit CCPC.

	// SMCR: slave mode control register
	TIM_SMCR_ETP_Pos  = 0xf    // Position of ETP field.
	TIM_SMCR_ETP_Msk  = 0x8000 // Bit mask of ETP field.
	TIM_SMCR_ETP      = 0x8000 // Bit ETP.
	TIM_SMCR_ECE_Pos  = 0xe    // Position of ECE field.
	TIM_SMCR_ECE_Msk  = 0x4000 // Bit mask of ECE field.
	TIM_SMCR_ECE      = 0x4000 // Bit ECE.
	TIM_SMCR_ETPS_Pos = 0xc    // Position of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000 // Bit mask of ETPS field.
	TIM_SMCR_ETF_Pos  = 0x8    // Position of ETF field.
	TIM_SMCR_ETF_Msk  = 0xf00  // Bit mask of ETF field.
	TIM_SMCR_MSM_Pos  = 0x7    // Position of MSM field.
	TIM_SMCR_MSM_Msk  = 0x80   // Bit mask of MSM field.
	TIM_SMCR_MSM      = 0x80   // Bit MSM.
	TIM_SMCR_TS_Pos   = 0x4    // Position of TS field.
	TIM_SMCR_TS_Msk   = 0x70   // Bit mask of TS field.
	TIM_SMCR_SMS_Pos  = 0x0    // Position of SMS field.
	TIM_SMCR_SMS_Msk  = 0x7    // Bit mask of SMS field.

	// DIER: DMA/Interrupt enable register
	TIM_DIER_TDE_Pos   = 0xe    // Position of TDE field.
	TIM_DIER_TDE_Msk   = 0x4000 // Bit mask of TDE field.
	TIM_DIER_TDE       = 0x4000 // Bit TDE.
	TIM_DIER_COMDE_Pos = 0xd    // Position of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000 // Bit mask of COMDE field.
	TIM_DIER_COMDE     = 0x2000 // Bit COMDE.
	TIM_DIER_CC4DE_Pos = 0xc    // Position of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000 // Bit mask of CC4DE field.
	TIM_DIER_CC4DE     = 0x1000 // Bit CC4DE.
	TIM_DIER_CC3DE_Pos = 0xb    // Position of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800  // Bit mask of CC3DE field.
	TIM_DIER_CC3DE     = 0x800  // Bit CC3DE.
	TIM_DIER_CC2DE_Pos = 0xa    // Position of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400  // Bit mask of CC2DE field.
	TIM_DIER_CC2DE     = 0x400  // Bit CC2DE.
	TIM_DIER_CC1DE_Pos = 0x9    // Position of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200  // Bit mask of CC1DE field.
	TIM_DIER_CC1DE     = 0x200  // Bit CC1DE.
	TIM_DIER_UDE_Pos   = 0x8    // Position of UDE field.
	TIM_DIER_UDE_Msk   = 0x100  // Bit mask of UDE field.
	TIM_DIER_UDE       = 0x100  // Bit UDE.
	TIM_DIER_BIE_Pos   = 0x7    // Position of BIE field.
	TIM_DIER_BIE_Msk   = 0x80   // Bit mask of BIE field.
	TIM_DIER_BIE       = 0x80   // Bit BIE.
	TIM_DIER_TIE_Pos   = 0x6    // Position of TIE field.
	TIM_DIER_TIE_Msk   = 0x40   // Bit mask of TIE field.
	TIM_DIER_TIE       = 0x40   // Bit TIE.
	TIM_DIER_COMIE_Pos = 0x5    // Position of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20   // Bit mask of COMIE field.
	TIM_DIER_COMIE     = 0x20   // Bit COMIE.
	TIM_DIER_CC4IE_Pos = 0x4    // Position of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10   // Bit mask of CC4IE field.
	TIM_DIER_CC4IE     = 0x10   // Bit CC4IE.
	TIM_DIER_CC3IE_Pos = 0x3    // Position of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8    // Bit mask of CC3IE field.
	TIM_DIER_CC3IE     = 0x8    // Bit CC3IE.
	TIM_DIER_CC2IE_Pos = 0x2    // Position of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4    // Bit mask of CC2IE field.
	TIM_DIER_CC2IE     = 0x4    // Bit CC2IE.
	TIM_DIER_CC1IE_Pos = 0x1    // Position of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2    // Bit mask of CC1IE field.
	TIM_DIER_CC1IE     = 0x2    // Bit CC1IE.
	TIM_DIER_UIE_Pos   = 0x0    // Position of UIE field.
	TIM_DIER_UIE_Msk   = 0x1    // Bit mask of UIE field.
	TIM_DIER_UIE       = 0x1    // Bit UIE.

	// SR: status register
	TIM_SR_CC4OF_Pos = 0xc    // Position of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000 // Bit mask of CC4OF field.
	TIM_SR_CC4OF     = 0x1000 // Bit CC4OF.
	TIM_SR_CC3OF_Pos = 0xb    // Position of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800  // Bit mask of CC3OF field.
	TIM_SR_CC3OF     = 0x800  // Bit CC3OF.
	TIM_SR_CC2OF_Pos = 0xa    // Position of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400  // Bit mask of CC2OF field.
	TIM_SR_CC2OF     = 0x400  // Bit CC2OF.
	TIM_SR_CC1OF_Pos = 0x9    // Position of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200  // Bit mask of CC1OF field.
	TIM_SR_CC1OF     = 0x200  // Bit CC1OF.
	TIM_SR_BIF_Pos   = 0x7    // Position of BIF field.
	TIM_SR_BIF_Msk   = 0x80   // Bit mask of BIF field.
	TIM_SR_BIF       = 0x80   // Bit BIF.
	TIM_SR_TIF_Pos   = 0x6    // Position of TIF field.
	TIM_SR_TIF_Msk   = 0x40   // Bit mask of TIF field.
	TIM_SR_TIF       = 0x40   // Bit TIF.
	TIM_SR_COMIF_Pos = 0x5    // Position of COMIF field.
	TIM_SR_COMIF_Msk = 0x20   // Bit mask of COMIF field.
	TIM_SR_COMIF     = 0x20   // Bit COMIF.
	TIM_SR_CC4IF_Pos = 0x4    // Position of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10   // Bit mask of CC4IF field.
	TIM_SR_CC4IF     = 0x10   // Bit CC4IF.
	TIM_SR_CC3IF_Pos = 0x3    // Position of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8    // Bit mask of CC3IF field.
	TIM_SR_CC3IF     = 0x8    // Bit CC3IF.
	TIM_SR_CC2IF_Pos = 0x2    // Position of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4    // Bit mask of CC2IF field.
	TIM_SR_CC2IF     = 0x4    // Bit CC2IF.
	TIM_SR_CC1IF_Pos = 0x1    // Position of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2    // Bit mask of CC1IF field.
	TIM_SR_CC1IF     = 0x2    // Bit CC1IF.
	TIM_SR_UIF_Pos   = 0x0    // Position of UIF field.
	TIM_SR_UIF_Msk   = 0x1    // Bit mask of UIF field.
	TIM_SR_UIF       = 0x1    // Bit UIF.

	// EGR: event generation register
	TIM_EGR_BG_Pos   = 0x7  // Position of BG field.
	TIM_EGR_BG_Msk   = 0x80 // Bit mask of BG field.
	TIM_EGR_BG       = 0x80 // Bit BG.
	TIM_EGR_TG_Pos   = 0x6  // Position of TG field.
	TIM_EGR_TG_Msk   = 0x40 // Bit mask of TG field.
	TIM_EGR_TG       = 0x40 // Bit TG.
	TIM_EGR_COMG_Pos = 0x5  // Position of COMG field.
	TIM_EGR_COMG_Msk = 0x20 // Bit mask of COMG field.
	TIM_EGR_COMG     = 0x20 // Bit COMG.
	TIM_EGR_CC4G_Pos = 0x4  // Position of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10 // Bit mask of CC4G field.
	TIM_EGR_CC4G     = 0x10 // Bit CC4G.
	TIM_EGR_CC3G_Pos = 0x3  // Position of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8  // Bit mask of CC3G field.
	TIM_EGR_CC3G     = 0x8  // Bit CC3G.
	TIM_EGR_CC2G_Pos = 0x2  // Position of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4  // Bit mask of CC2G field.
	TIM_EGR_CC2G     = 0x4  // Bit CC2G.
	TIM_EGR_CC1G_Pos = 0x1  // Position of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2  // Bit mask of CC1G field.
	TIM_EGR_CC1G     = 0x2  // Bit CC1G.
	TIM_EGR_UG_Pos   = 0x0  // Position of UG field.
	TIM_EGR_UG_Msk   = 0x1  // Bit mask of UG field.
	TIM_EGR_UG       = 0x1  // Bit UG.

	// CCMR1_Output: capture/compare mode register (output           mode)
	TIM_CCMR1_Output_OC2CE_Pos = 0xf    // Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000 // Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE     = 0x8000 // Bit OC2CE.
	TIM_CCMR1_Output_OC2M_Pos  = 0xc    // Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk  = 0x7000 // Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb    // Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800  // Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE     = 0x800  // Bit OC2PE.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa    // Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400  // Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE     = 0x400  // Bit OC2FE.
	TIM_CCMR1_Output_CC2S_Pos  = 0x8    // Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk  = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7    // Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80   // Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE     = 0x80   // Bit OC1CE.
	TIM_CCMR1_Output_OC1M_Pos  = 0x4    // Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk  = 0x70   // Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3    // Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8    // Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE     = 0x8    // Bit OC1PE.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2    // Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4    // Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE     = 0x4    // Bit OC1FE.
	TIM_CCMR1_Output_CC1S_Pos  = 0x0    // Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk  = 0x3    // Bit mask of CC1S field.

	// CCMR1_Input: capture/compare mode register 1 (input           mode)
	TIM_CCMR1_Input_IC2F_Pos   = 0xc    // Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk   = 0xf000 // Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2PCS_Pos = 0xa    // Position of IC2PCS field.
	TIM_CCMR1_Input_IC2PCS_Msk = 0xc00  // Bit mask of IC2PCS field.
	TIM_CCMR1_Input_CC2S_Pos   = 0x8    // Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk   = 0x300  // Bit mask of CC2S field.
	TIM_CCMR1_Input_IC1F_Pos   = 0x4    // Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk   = 0xf0   // Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1PCS_Pos = 0x2    // Position of IC1PCS field.
	TIM_CCMR1_Input_IC1PCS_Msk = 0xc    // Bit mask of IC1PCS field.
	TIM_CCMR1_Input_CC1S_Pos   = 0x0    // Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk   = 0x3    // Bit mask of CC1S field.

	// CCMR2_Output: capture/compare mode register (output           mode)
	TIM_CCMR2_Output_OC4CE_Pos = 0xf    // Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000 // Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE     = 0x8000 // Bit OC4CE.
	TIM_CCMR2_Output_OC4M_Pos  = 0xc    // Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk  = 0x7000 // Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb    // Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800  // Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE     = 0x800  // Bit OC4PE.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa    // Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400  // Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE     = 0x400  // Bit OC4FE.
	TIM_CCMR2_Output_CC4S_Pos  = 0x8    // Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk  = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7    // Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80   // Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE     = 0x80   // Bit OC3CE.
	TIM_CCMR2_Output_OC3M_Pos  = 0x4    // Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk  = 0x70   // Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3    // Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8    // Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE     = 0x8    // Bit OC3PE.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2    // Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4    // Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE     = 0x4    // Bit OC3FE.
	TIM_CCMR2_Output_CC3S_Pos  = 0x0    // Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk  = 0x3    // Bit mask of CC3S field.

	// CCMR2_Input: capture/compare mode register 2 (input           mode)
	TIM_CCMR2_Input_IC4F_Pos   = 0xc    // Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk   = 0xf000 // Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa    // Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00  // Bit mask of IC4PSC field.
	TIM_CCMR2_Input_CC4S_Pos   = 0x8    // Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk   = 0x300  // Bit mask of CC4S field.
	TIM_CCMR2_Input_IC3F_Pos   = 0x4    // Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk   = 0xf0   // Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2    // Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc    // Bit mask of IC3PSC field.
	TIM_CCMR2_Input_CC3S_Pos   = 0x0    // Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk   = 0x3    // Bit mask of CC3S field.

	// CCER: capture/compare enable           register
	TIM_CCER_CC4P_Pos  = 0xd    // Position of CC4P field.
	TIM_CCER_CC4P_Msk  = 0x2000 // Bit mask of CC4P field.
	TIM_CCER_CC4P      = 0x2000 // Bit CC4P.
	TIM_CCER_CC4E_Pos  = 0xc    // Position of CC4E field.
	TIM_CCER_CC4E_Msk  = 0x1000 // Bit mask of CC4E field.
	TIM_CCER_CC4E      = 0x1000 // Bit CC4E.
	TIM_CCER_CC3NP_Pos = 0xb    // Position of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800  // Bit mask of CC3NP field.
	TIM_CCER_CC3NP     = 0x800  // Bit CC3NP.
	TIM_CCER_CC3NE_Pos = 0xa    // Position of CC3NE field.
	TIM_CCER_CC3NE_Msk = 0x400  // Bit mask of CC3NE field.
	TIM_CCER_CC3NE     = 0x400  // Bit CC3NE.
	TIM_CCER_CC3P_Pos  = 0x9    // Position of CC3P field.
	TIM_CCER_CC3P_Msk  = 0x200  // Bit mask of CC3P field.
	TIM_CCER_CC3P      = 0x200  // Bit CC3P.
	TIM_CCER_CC3E_Pos  = 0x8    // Position of CC3E field.
	TIM_CCER_CC3E_Msk  = 0x100  // Bit mask of CC3E field.
	TIM_CCER_CC3E      = 0x100  // Bit CC3E.
	TIM_CCER_CC2NP_Pos = 0x7    // Position of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80   // Bit mask of CC2NP field.
	TIM_CCER_CC2NP     = 0x80   // Bit CC2NP.
	TIM_CCER_CC2NE_Pos = 0x6    // Position of CC2NE field.
	TIM_CCER_CC2NE_Msk = 0x40   // Bit mask of CC2NE field.
	TIM_CCER_CC2NE     = 0x40   // Bit CC2NE.
	TIM_CCER_CC2P_Pos  = 0x5    // Position of CC2P field.
	TIM_CCER_CC2P_Msk  = 0x20   // Bit mask of CC2P field.
	TIM_CCER_CC2P      = 0x20   // Bit CC2P.
	TIM_CCER_CC2E_Pos  = 0x4    // Position of CC2E field.
	TIM_CCER_CC2E_Msk  = 0x10   // Bit mask of CC2E field.
	TIM_CCER_CC2E      = 0x10   // Bit CC2E.
	TIM_CCER_CC1NP_Pos = 0x3    // Position of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8    // Bit mask of CC1NP field.
	TIM_CCER_CC1NP     = 0x8    // Bit CC1NP.
	TIM_CCER_CC1NE_Pos = 0x2    // Position of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4    // Bit mask of CC1NE field.
	TIM_CCER_CC1NE     = 0x4    // Bit CC1NE.
	TIM_CCER_CC1P_Pos  = 0x1    // Position of CC1P field.
	TIM_CCER_CC1P_Msk  = 0x2    // Bit mask of CC1P field.
	TIM_CCER_CC1P      = 0x2    // Bit CC1P.
	TIM_CCER_CC1E_Pos  = 0x0    // Position of CC1E field.
	TIM_CCER_CC1E_Msk  = 0x1    // Bit mask of CC1E field.
	TIM_CCER_CC1E      = 0x1    // Bit CC1E.

	// CNT: counter
	TIM_CNT_CNT_Pos = 0x0    // Position of CNT field.
	TIM_CNT_CNT_Msk = 0xffff // Bit mask of CNT field.

	// PSC: prescaler
	TIM_PSC_PSC_Pos = 0x0    // Position of PSC field.
	TIM_PSC_PSC_Msk = 0xffff // Bit mask of PSC field.

	// ARR: auto-reload register
	TIM_ARR_ARR_Pos = 0x0    // Position of ARR field.
	TIM_ARR_ARR_Msk = 0xffff // Bit mask of ARR field.

	// RCR: repetition counter register
	TIM_RCR_REP_Pos = 0x0  // Position of REP field.
	TIM_RCR_REP_Msk = 0xff // Bit mask of REP field.

	// CCR1: capture/compare register 1
	TIM_CCR1_CCR1_Pos = 0x0    // Position of CCR1 field.
	TIM_CCR1_CCR1_Msk = 0xffff // Bit mask of CCR1 field.

	// CCR2: capture/compare register 2
	TIM_CCR2_CCR2_Pos = 0x0    // Position of CCR2 field.
	TIM_CCR2_CCR2_Msk = 0xffff // Bit mask of CCR2 field.

	// CCR3: capture/compare register 3
	TIM_CCR3_CCR3_Pos = 0x0    // Position of CCR3 field.
	TIM_CCR3_CCR3_Msk = 0xffff // Bit mask of CCR3 field.

	// CCR4: capture/compare register 4
	TIM_CCR4_CCR4_Pos = 0x0    // Position of CCR4 field.
	TIM_CCR4_CCR4_Msk = 0xffff // Bit mask of CCR4 field.

	// BDTR: break and dead-time register
	TIM_BDTR_MOE_Pos  = 0xf    // Position of MOE field.
	TIM_BDTR_MOE_Msk  = 0x8000 // Bit mask of MOE field.
	TIM_BDTR_MOE      = 0x8000 // Bit MOE.
	TIM_BDTR_AOE_Pos  = 0xe    // Position of AOE field.
	TIM_BDTR_AOE_Msk  = 0x4000 // Bit mask of AOE field.
	TIM_BDTR_AOE      = 0x4000 // Bit AOE.
	TIM_BDTR_BKP_Pos  = 0xd    // Position of BKP field.
	TIM_BDTR_BKP_Msk  = 0x2000 // Bit mask of BKP field.
	TIM_BDTR_BKP      = 0x2000 // Bit BKP.
	TIM_BDTR_BKE_Pos  = 0xc    // Position of BKE field.
	TIM_BDTR_BKE_Msk  = 0x1000 // Bit mask of BKE field.
	TIM_BDTR_BKE      = 0x1000 // Bit BKE.
	TIM_BDTR_OSSR_Pos = 0xb    // Position of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800  // Bit mask of OSSR field.
	TIM_BDTR_OSSR     = 0x800  // Bit OSSR.
	TIM_BDTR_OSSI_Pos = 0xa    // Position of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400  // Bit mask of OSSI field.
	TIM_BDTR_OSSI     = 0x400  // Bit OSSI.
	TIM_BDTR_LOCK_Pos = 0x8    // Position of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300  // Bit mask of LOCK field.
	TIM_BDTR_DTG_Pos  = 0x0    // Position of DTG field.
	TIM_BDTR_DTG_Msk  = 0xff   // Bit mask of DTG field.

	// DCR: DMA control register
	TIM_DCR_DBL_Pos = 0x8    // Position of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00 // Bit mask of DBL field.
	TIM_DCR_DBA_Pos = 0x0    // Position of DBA field.
	TIM_DCR_DBA_Msk = 0x1f   // Bit mask of DBA field.

	// DMAR: DMA address for full transfer
	TIM_DMAR_DMAB_Pos = 0x0    // Position of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff // Bit mask of DMAB field.
)

// Bitfields for EXTI: External interrupt/event controller
const (
	// IMR: Interrupt mask register           (EXTI_IMR)
	EXTI_IMR_MR0_Pos  = 0x0       // Position of MR0 field.
	EXTI_IMR_MR0_Msk  = 0x1       // Bit mask of MR0 field.
	EXTI_IMR_MR0      = 0x1       // Bit MR0.
	EXTI_IMR_MR1_Pos  = 0x1       // Position of MR1 field.
	EXTI_IMR_MR1_Msk  = 0x2       // Bit mask of MR1 field.
	EXTI_IMR_MR1      = 0x2       // Bit MR1.
	EXTI_IMR_MR2_Pos  = 0x2       // Position of MR2 field.
	EXTI_IMR_MR2_Msk  = 0x4       // Bit mask of MR2 field.
	EXTI_IMR_MR2      = 0x4       // Bit MR2.
	EXTI_IMR_MR3_Pos  = 0x3       // Position of MR3 field.
	EXTI_IMR_MR3_Msk  = 0x8       // Bit mask of MR3 field.
	EXTI_IMR_MR3      = 0x8       // Bit MR3.
	EXTI_IMR_MR4_Pos  = 0x4       // Position of MR4 field.
	EXTI_IMR_MR4_Msk  = 0x10      // Bit mask of MR4 field.
	EXTI_IMR_MR4      = 0x10      // Bit MR4.
	EXTI_IMR_MR5_Pos  = 0x5       // Position of MR5 field.
	EXTI_IMR_MR5_Msk  = 0x20      // Bit mask of MR5 field.
	EXTI_IMR_MR5      = 0x20      // Bit MR5.
	EXTI_IMR_MR6_Pos  = 0x6       // Position of MR6 field.
	EXTI_IMR_MR6_Msk  = 0x40      // Bit mask of MR6 field.
	EXTI_IMR_MR6      = 0x40      // Bit MR6.
	EXTI_IMR_MR7_Pos  = 0x7       // Position of MR7 field.
	EXTI_IMR_MR7_Msk  = 0x80      // Bit mask of MR7 field.
	EXTI_IMR_MR7      = 0x80      // Bit MR7.
	EXTI_IMR_MR8_Pos  = 0x8       // Position of MR8 field.
	EXTI_IMR_MR8_Msk  = 0x100     // Bit mask of MR8 field.
	EXTI_IMR_MR8      = 0x100     // Bit MR8.
	EXTI_IMR_MR9_Pos  = 0x9       // Position of MR9 field.
	EXTI_IMR_MR9_Msk  = 0x200     // Bit mask of MR9 field.
	EXTI_IMR_MR9      = 0x200     // Bit MR9.
	EXTI_IMR_MR10_Pos = 0xa       // Position of MR10 field.
	EXTI_IMR_MR10_Msk = 0x400     // Bit mask of MR10 field.
	EXTI_IMR_MR10     = 0x400     // Bit MR10.
	EXTI_IMR_MR11_Pos = 0xb       // Position of MR11 field.
	EXTI_IMR_MR11_Msk = 0x800     // Bit mask of MR11 field.
	EXTI_IMR_MR11     = 0x800     // Bit MR11.
	EXTI_IMR_MR12_Pos = 0xc       // Position of MR12 field.
	EXTI_IMR_MR12_Msk = 0x1000    // Bit mask of MR12 field.
	EXTI_IMR_MR12     = 0x1000    // Bit MR12.
	EXTI_IMR_MR13_Pos = 0xd       // Position of MR13 field.
	EXTI_IMR_MR13_Msk = 0x2000    // Bit mask of MR13 field.
	EXTI_IMR_MR13     = 0x2000    // Bit MR13.
	EXTI_IMR_MR14_Pos = 0xe       // Position of MR14 field.
	EXTI_IMR_MR14_Msk = 0x4000    // Bit mask of MR14 field.
	EXTI_IMR_MR14     = 0x4000    // Bit MR14.
	EXTI_IMR_MR15_Pos = 0xf       // Position of MR15 field.
	EXTI_IMR_MR15_Msk = 0x8000    // Bit mask of MR15 field.
	EXTI_IMR_MR15     = 0x8000    // Bit MR15.
	EXTI_IMR_MR16_Pos = 0x10      // Position of MR16 field.
	EXTI_IMR_MR16_Msk = 0x10000   // Bit mask of MR16 field.
	EXTI_IMR_MR16     = 0x10000   // Bit MR16.
	EXTI_IMR_MR17_Pos = 0x11      // Position of MR17 field.
	EXTI_IMR_MR17_Msk = 0x20000   // Bit mask of MR17 field.
	EXTI_IMR_MR17     = 0x20000   // Bit MR17.
	EXTI_IMR_MR18_Pos = 0x12      // Position of MR18 field.
	EXTI_IMR_MR18_Msk = 0x40000   // Bit mask of MR18 field.
	EXTI_IMR_MR18     = 0x40000   // Bit MR18.
	EXTI_IMR_MR19_Pos = 0x13      // Position of MR19 field.
	EXTI_IMR_MR19_Msk = 0x80000   // Bit mask of MR19 field.
	EXTI_IMR_MR19     = 0x80000   // Bit MR19.
	EXTI_IMR_MR20_Pos = 0x14      // Position of MR20 field.
	EXTI_IMR_MR20_Msk = 0x100000  // Bit mask of MR20 field.
	EXTI_IMR_MR20     = 0x100000  // Bit MR20.
	EXTI_IMR_MR21_Pos = 0x15      // Position of MR21 field.
	EXTI_IMR_MR21_Msk = 0x200000  // Bit mask of MR21 field.
	EXTI_IMR_MR21     = 0x200000  // Bit MR21.
	EXTI_IMR_MR22_Pos = 0x16      // Position of MR22 field.
	EXTI_IMR_MR22_Msk = 0x400000  // Bit mask of MR22 field.
	EXTI_IMR_MR22     = 0x400000  // Bit MR22.
	EXTI_IMR_MR23_Pos = 0x17      // Position of MR23 field.
	EXTI_IMR_MR23_Msk = 0x800000  // Bit mask of MR23 field.
	EXTI_IMR_MR23     = 0x800000  // Bit MR23.
	EXTI_IMR_MR24_Pos = 0x18      // Position of MR24 field.
	EXTI_IMR_MR24_Msk = 0x1000000 // Bit mask of MR24 field.
	EXTI_IMR_MR24     = 0x1000000 // Bit MR24.
	EXTI_IMR_MR25_Pos = 0x19      // Position of MR25 field.
	EXTI_IMR_MR25_Msk = 0x2000000 // Bit mask of MR25 field.
	EXTI_IMR_MR25     = 0x2000000 // Bit MR25.
	EXTI_IMR_MR26_Pos = 0x1a      // Position of MR26 field.
	EXTI_IMR_MR26_Msk = 0x4000000 // Bit mask of MR26 field.
	EXTI_IMR_MR26     = 0x4000000 // Bit MR26.
	EXTI_IMR_MR27_Pos = 0x1b      // Position of MR27 field.
	EXTI_IMR_MR27_Msk = 0x8000000 // Bit mask of MR27 field.
	EXTI_IMR_MR27     = 0x8000000 // Bit MR27.

	// EMR: Event mask register (EXTI_EMR)
	EXTI_EMR_MR0_Pos  = 0x0       // Position of MR0 field.
	EXTI_EMR_MR0_Msk  = 0x1       // Bit mask of MR0 field.
	EXTI_EMR_MR0      = 0x1       // Bit MR0.
	EXTI_EMR_MR1_Pos  = 0x1       // Position of MR1 field.
	EXTI_EMR_MR1_Msk  = 0x2       // Bit mask of MR1 field.
	EXTI_EMR_MR1      = 0x2       // Bit MR1.
	EXTI_EMR_MR2_Pos  = 0x2       // Position of MR2 field.
	EXTI_EMR_MR2_Msk  = 0x4       // Bit mask of MR2 field.
	EXTI_EMR_MR2      = 0x4       // Bit MR2.
	EXTI_EMR_MR3_Pos  = 0x3       // Position of MR3 field.
	EXTI_EMR_MR3_Msk  = 0x8       // Bit mask of MR3 field.
	EXTI_EMR_MR3      = 0x8       // Bit MR3.
	EXTI_EMR_MR4_Pos  = 0x4       // Position of MR4 field.
	EXTI_EMR_MR4_Msk  = 0x10      // Bit mask of MR4 field.
	EXTI_EMR_MR4      = 0x10      // Bit MR4.
	EXTI_EMR_MR5_Pos  = 0x5       // Position of MR5 field.
	EXTI_EMR_MR5_Msk  = 0x20      // Bit mask of MR5 field.
	EXTI_EMR_MR5      = 0x20      // Bit MR5.
	EXTI_EMR_MR6_Pos  = 0x6       // Position of MR6 field.
	EXTI_EMR_MR6_Msk  = 0x40      // Bit mask of MR6 field.
	EXTI_EMR_MR6      = 0x40      // Bit MR6.
	EXTI_EMR_MR7_Pos  = 0x7       // Position of MR7 field.
	EXTI_EMR_MR7_Msk  = 0x80      // Bit mask of MR7 field.
	EXTI_EMR_MR7      = 0x80      // Bit MR7.
	EXTI_EMR_MR8_Pos  = 0x8       // Position of MR8 field.
	EXTI_EMR_MR8_Msk  = 0x100     // Bit mask of MR8 field.
	EXTI_EMR_MR8      = 0x100     // Bit MR8.
	EXTI_EMR_MR9_Pos  = 0x9       // Position of MR9 field.
	EXTI_EMR_MR9_Msk  = 0x200     // Bit mask of MR9 field.
	EXTI_EMR_MR9      = 0x200     // Bit MR9.
	EXTI_EMR_MR10_Pos = 0xa       // Position of MR10 field.
	EXTI_EMR_MR10_Msk = 0x400     // Bit mask of MR10 field.
	EXTI_EMR_MR10     = 0x400     // Bit MR10.
	EXTI_EMR_MR11_Pos = 0xb       // Position of MR11 field.
	EXTI_EMR_MR11_Msk = 0x800     // Bit mask of MR11 field.
	EXTI_EMR_MR11     = 0x800     // Bit MR11.
	EXTI_EMR_MR12_Pos = 0xc       // Position of MR12 field.
	EXTI_EMR_MR12_Msk = 0x1000    // Bit mask of MR12 field.
	EXTI_EMR_MR12     = 0x1000    // Bit MR12.
	EXTI_EMR_MR13_Pos = 0xd       // Position of MR13 field.
	EXTI_EMR_MR13_Msk = 0x2000    // Bit mask of MR13 field.
	EXTI_EMR_MR13     = 0x2000    // Bit MR13.
	EXTI_EMR_MR14_Pos = 0xe       // Position of MR14 field.
	EXTI_EMR_MR14_Msk = 0x4000    // Bit mask of MR14 field.
	EXTI_EMR_MR14     = 0x4000    // Bit MR14.
	EXTI_EMR_MR15_Pos = 0xf       // Position of MR15 field.
	EXTI_EMR_MR15_Msk = 0x8000    // Bit mask of MR15 field.
	EXTI_EMR_MR15     = 0x8000    // Bit MR15.
	EXTI_EMR_MR16_Pos = 0x10      // Position of MR16 field.
	EXTI_EMR_MR16_Msk = 0x10000   // Bit mask of MR16 field.
	EXTI_EMR_MR16     = 0x10000   // Bit MR16.
	EXTI_EMR_MR17_Pos = 0x11      // Position of MR17 field.
	EXTI_EMR_MR17_Msk = 0x20000   // Bit mask of MR17 field.
	EXTI_EMR_MR17     = 0x20000   // Bit MR17.
	EXTI_EMR_MR18_Pos = 0x12      // Position of MR18 field.
	EXTI_EMR_MR18_Msk = 0x40000   // Bit mask of MR18 field.
	EXTI_EMR_MR18     = 0x40000   // Bit MR18.
	EXTI_EMR_MR19_Pos = 0x13      // Position of MR19 field.
	EXTI_EMR_MR19_Msk = 0x80000   // Bit mask of MR19 field.
	EXTI_EMR_MR19     = 0x80000   // Bit MR19.
	EXTI_EMR_MR20_Pos = 0x14      // Position of MR20 field.
	EXTI_EMR_MR20_Msk = 0x100000  // Bit mask of MR20 field.
	EXTI_EMR_MR20     = 0x100000  // Bit MR20.
	EXTI_EMR_MR21_Pos = 0x15      // Position of MR21 field.
	EXTI_EMR_MR21_Msk = 0x200000  // Bit mask of MR21 field.
	EXTI_EMR_MR21     = 0x200000  // Bit MR21.
	EXTI_EMR_MR22_Pos = 0x16      // Position of MR22 field.
	EXTI_EMR_MR22_Msk = 0x400000  // Bit mask of MR22 field.
	EXTI_EMR_MR22     = 0x400000  // Bit MR22.
	EXTI_EMR_MR23_Pos = 0x17      // Position of MR23 field.
	EXTI_EMR_MR23_Msk = 0x800000  // Bit mask of MR23 field.
	EXTI_EMR_MR23     = 0x800000  // Bit MR23.
	EXTI_EMR_MR24_Pos = 0x18      // Position of MR24 field.
	EXTI_EMR_MR24_Msk = 0x1000000 // Bit mask of MR24 field.
	EXTI_EMR_MR24     = 0x1000000 // Bit MR24.
	EXTI_EMR_MR25_Pos = 0x19      // Position of MR25 field.
	EXTI_EMR_MR25_Msk = 0x2000000 // Bit mask of MR25 field.
	EXTI_EMR_MR25     = 0x2000000 // Bit MR25.
	EXTI_EMR_MR26_Pos = 0x1a      // Position of MR26 field.
	EXTI_EMR_MR26_Msk = 0x4000000 // Bit mask of MR26 field.
	EXTI_EMR_MR26     = 0x4000000 // Bit MR26.
	EXTI_EMR_MR27_Pos = 0x1b      // Position of MR27 field.
	EXTI_EMR_MR27_Msk = 0x8000000 // Bit mask of MR27 field.
	EXTI_EMR_MR27     = 0x8000000 // Bit MR27.

	// RTSR: Rising Trigger selection register           (EXTI_RTSR)
	EXTI_RTSR_TR0_Pos  = 0x0     // Position of TR0 field.
	EXTI_RTSR_TR0_Msk  = 0x1     // Bit mask of TR0 field.
	EXTI_RTSR_TR0      = 0x1     // Bit TR0.
	EXTI_RTSR_TR1_Pos  = 0x1     // Position of TR1 field.
	EXTI_RTSR_TR1_Msk  = 0x2     // Bit mask of TR1 field.
	EXTI_RTSR_TR1      = 0x2     // Bit TR1.
	EXTI_RTSR_TR2_Pos  = 0x2     // Position of TR2 field.
	EXTI_RTSR_TR2_Msk  = 0x4     // Bit mask of TR2 field.
	EXTI_RTSR_TR2      = 0x4     // Bit TR2.
	EXTI_RTSR_TR3_Pos  = 0x3     // Position of TR3 field.
	EXTI_RTSR_TR3_Msk  = 0x8     // Bit mask of TR3 field.
	EXTI_RTSR_TR3      = 0x8     // Bit TR3.
	EXTI_RTSR_TR4_Pos  = 0x4     // Position of TR4 field.
	EXTI_RTSR_TR4_Msk  = 0x10    // Bit mask of TR4 field.
	EXTI_RTSR_TR4      = 0x10    // Bit TR4.
	EXTI_RTSR_TR5_Pos  = 0x5     // Position of TR5 field.
	EXTI_RTSR_TR5_Msk  = 0x20    // Bit mask of TR5 field.
	EXTI_RTSR_TR5      = 0x20    // Bit TR5.
	EXTI_RTSR_TR6_Pos  = 0x6     // Position of TR6 field.
	EXTI_RTSR_TR6_Msk  = 0x40    // Bit mask of TR6 field.
	EXTI_RTSR_TR6      = 0x40    // Bit TR6.
	EXTI_RTSR_TR7_Pos  = 0x7     // Position of TR7 field.
	EXTI_RTSR_TR7_Msk  = 0x80    // Bit mask of TR7 field.
	EXTI_RTSR_TR7      = 0x80    // Bit TR7.
	EXTI_RTSR_TR8_Pos  = 0x8     // Position of TR8 field.
	EXTI_RTSR_TR8_Msk  = 0x100   // Bit mask of TR8 field.
	EXTI_RTSR_TR8      = 0x100   // Bit TR8.
	EXTI_RTSR_TR9_Pos  = 0x9     // Position of TR9 field.
	EXTI_RTSR_TR9_Msk  = 0x200   // Bit mask of TR9 field.
	EXTI_RTSR_TR9      = 0x200   // Bit TR9.
	EXTI_RTSR_TR10_Pos = 0xa     // Position of TR10 field.
	EXTI_RTSR_TR10_Msk = 0x400   // Bit mask of TR10 field.
	EXTI_RTSR_TR10     = 0x400   // Bit TR10.
	EXTI_RTSR_TR11_Pos = 0xb     // Position of TR11 field.
	EXTI_RTSR_TR11_Msk = 0x800   // Bit mask of TR11 field.
	EXTI_RTSR_TR11     = 0x800   // Bit TR11.
	EXTI_RTSR_TR12_Pos = 0xc     // Position of TR12 field.
	EXTI_RTSR_TR12_Msk = 0x1000  // Bit mask of TR12 field.
	EXTI_RTSR_TR12     = 0x1000  // Bit TR12.
	EXTI_RTSR_TR13_Pos = 0xd     // Position of TR13 field.
	EXTI_RTSR_TR13_Msk = 0x2000  // Bit mask of TR13 field.
	EXTI_RTSR_TR13     = 0x2000  // Bit TR13.
	EXTI_RTSR_TR14_Pos = 0xe     // Position of TR14 field.
	EXTI_RTSR_TR14_Msk = 0x4000  // Bit mask of TR14 field.
	EXTI_RTSR_TR14     = 0x4000  // Bit TR14.
	EXTI_RTSR_TR15_Pos = 0xf     // Position of TR15 field.
	EXTI_RTSR_TR15_Msk = 0x8000  // Bit mask of TR15 field.
	EXTI_RTSR_TR15     = 0x8000  // Bit TR15.
	EXTI_RTSR_TR16_Pos = 0x10    // Position of TR16 field.
	EXTI_RTSR_TR16_Msk = 0x10000 // Bit mask of TR16 field.
	EXTI_RTSR_TR16     = 0x10000 // Bit TR16.
	EXTI_RTSR_TR17_Pos = 0x11    // Position of TR17 field.
	EXTI_RTSR_TR17_Msk = 0x20000 // Bit mask of TR17 field.
	EXTI_RTSR_TR17     = 0x20000 // Bit TR17.
	EXTI_RTSR_TR19_Pos = 0x13    // Position of TR19 field.
	EXTI_RTSR_TR19_Msk = 0x80000 // Bit mask of TR19 field.
	EXTI_RTSR_TR19     = 0x80000 // Bit TR19.

	// FTSR: Falling Trigger selection register           (EXTI_FTSR)
	EXTI_FTSR_TR0_Pos  = 0x0     // Position of TR0 field.
	EXTI_FTSR_TR0_Msk  = 0x1     // Bit mask of TR0 field.
	EXTI_FTSR_TR0      = 0x1     // Bit TR0.
	EXTI_FTSR_TR1_Pos  = 0x1     // Position of TR1 field.
	EXTI_FTSR_TR1_Msk  = 0x2     // Bit mask of TR1 field.
	EXTI_FTSR_TR1      = 0x2     // Bit TR1.
	EXTI_FTSR_TR2_Pos  = 0x2     // Position of TR2 field.
	EXTI_FTSR_TR2_Msk  = 0x4     // Bit mask of TR2 field.
	EXTI_FTSR_TR2      = 0x4     // Bit TR2.
	EXTI_FTSR_TR3_Pos  = 0x3     // Position of TR3 field.
	EXTI_FTSR_TR3_Msk  = 0x8     // Bit mask of TR3 field.
	EXTI_FTSR_TR3      = 0x8     // Bit TR3.
	EXTI_FTSR_TR4_Pos  = 0x4     // Position of TR4 field.
	EXTI_FTSR_TR4_Msk  = 0x10    // Bit mask of TR4 field.
	EXTI_FTSR_TR4      = 0x10    // Bit TR4.
	EXTI_FTSR_TR5_Pos  = 0x5     // Position of TR5 field.
	EXTI_FTSR_TR5_Msk  = 0x20    // Bit mask of TR5 field.
	EXTI_FTSR_TR5      = 0x20    // Bit TR5.
	EXTI_FTSR_TR6_Pos  = 0x6     // Position of TR6 field.
	EXTI_FTSR_TR6_Msk  = 0x40    // Bit mask of TR6 field.
	EXTI_FTSR_TR6      = 0x40    // Bit TR6.
	EXTI_FTSR_TR7_Pos  = 0x7     // Position of TR7 field.
	EXTI_FTSR_TR7_Msk  = 0x80    // Bit mask of TR7 field.
	EXTI_FTSR_TR7      = 0x80    // Bit TR7.
	EXTI_FTSR_TR8_Pos  = 0x8     // Position of TR8 field.
	EXTI_FTSR_TR8_Msk  = 0x100   // Bit mask of TR8 field.
	EXTI_FTSR_TR8      = 0x100   // Bit TR8.
	EXTI_FTSR_TR9_Pos  = 0x9     // Position of TR9 field.
	EXTI_FTSR_TR9_Msk  = 0x200   // Bit mask of TR9 field.
	EXTI_FTSR_TR9      = 0x200   // Bit TR9.
	EXTI_FTSR_TR10_Pos = 0xa     // Position of TR10 field.
	EXTI_FTSR_TR10_Msk = 0x400   // Bit mask of TR10 field.
	EXTI_FTSR_TR10     = 0x400   // Bit TR10.
	EXTI_FTSR_TR11_Pos = 0xb     // Position of TR11 field.
	EXTI_FTSR_TR11_Msk = 0x800   // Bit mask of TR11 field.
	EXTI_FTSR_TR11     = 0x800   // Bit TR11.
	EXTI_FTSR_TR12_Pos = 0xc     // Position of TR12 field.
	EXTI_FTSR_TR12_Msk = 0x1000  // Bit mask of TR12 field.
	EXTI_FTSR_TR12     = 0x1000  // Bit TR12.
	EXTI_FTSR_TR13_Pos = 0xd     // Position of TR13 field.
	EXTI_FTSR_TR13_Msk = 0x2000  // Bit mask of TR13 field.
	EXTI_FTSR_TR13     = 0x2000  // Bit TR13.
	EXTI_FTSR_TR14_Pos = 0xe     // Position of TR14 field.
	EXTI_FTSR_TR14_Msk = 0x4000  // Bit mask of TR14 field.
	EXTI_FTSR_TR14     = 0x4000  // Bit TR14.
	EXTI_FTSR_TR15_Pos = 0xf     // Position of TR15 field.
	EXTI_FTSR_TR15_Msk = 0x8000  // Bit mask of TR15 field.
	EXTI_FTSR_TR15     = 0x8000  // Bit TR15.
	EXTI_FTSR_TR16_Pos = 0x10    // Position of TR16 field.
	EXTI_FTSR_TR16_Msk = 0x10000 // Bit mask of TR16 field.
	EXTI_FTSR_TR16     = 0x10000 // Bit TR16.
	EXTI_FTSR_TR17_Pos = 0x11    // Position of TR17 field.
	EXTI_FTSR_TR17_Msk = 0x20000 // Bit mask of TR17 field.
	EXTI_FTSR_TR17     = 0x20000 // Bit TR17.
	EXTI_FTSR_TR19_Pos = 0x13    // Position of TR19 field.
	EXTI_FTSR_TR19_Msk = 0x80000 // Bit mask of TR19 field.
	EXTI_FTSR_TR19     = 0x80000 // Bit TR19.

	// SWIER: Software interrupt event register           (EXTI_SWIER)
	EXTI_SWIER_SWIER0_Pos  = 0x0     // Position of SWIER0 field.
	EXTI_SWIER_SWIER0_Msk  = 0x1     // Bit mask of SWIER0 field.
	EXTI_SWIER_SWIER0      = 0x1     // Bit SWIER0.
	EXTI_SWIER_SWIER1_Pos  = 0x1     // Position of SWIER1 field.
	EXTI_SWIER_SWIER1_Msk  = 0x2     // Bit mask of SWIER1 field.
	EXTI_SWIER_SWIER1      = 0x2     // Bit SWIER1.
	EXTI_SWIER_SWIER2_Pos  = 0x2     // Position of SWIER2 field.
	EXTI_SWIER_SWIER2_Msk  = 0x4     // Bit mask of SWIER2 field.
	EXTI_SWIER_SWIER2      = 0x4     // Bit SWIER2.
	EXTI_SWIER_SWIER3_Pos  = 0x3     // Position of SWIER3 field.
	EXTI_SWIER_SWIER3_Msk  = 0x8     // Bit mask of SWIER3 field.
	EXTI_SWIER_SWIER3      = 0x8     // Bit SWIER3.
	EXTI_SWIER_SWIER4_Pos  = 0x4     // Position of SWIER4 field.
	EXTI_SWIER_SWIER4_Msk  = 0x10    // Bit mask of SWIER4 field.
	EXTI_SWIER_SWIER4      = 0x10    // Bit SWIER4.
	EXTI_SWIER_SWIER5_Pos  = 0x5     // Position of SWIER5 field.
	EXTI_SWIER_SWIER5_Msk  = 0x20    // Bit mask of SWIER5 field.
	EXTI_SWIER_SWIER5      = 0x20    // Bit SWIER5.
	EXTI_SWIER_SWIER6_Pos  = 0x6     // Position of SWIER6 field.
	EXTI_SWIER_SWIER6_Msk  = 0x40    // Bit mask of SWIER6 field.
	EXTI_SWIER_SWIER6      = 0x40    // Bit SWIER6.
	EXTI_SWIER_SWIER7_Pos  = 0x7     // Position of SWIER7 field.
	EXTI_SWIER_SWIER7_Msk  = 0x80    // Bit mask of SWIER7 field.
	EXTI_SWIER_SWIER7      = 0x80    // Bit SWIER7.
	EXTI_SWIER_SWIER8_Pos  = 0x8     // Position of SWIER8 field.
	EXTI_SWIER_SWIER8_Msk  = 0x100   // Bit mask of SWIER8 field.
	EXTI_SWIER_SWIER8      = 0x100   // Bit SWIER8.
	EXTI_SWIER_SWIER9_Pos  = 0x9     // Position of SWIER9 field.
	EXTI_SWIER_SWIER9_Msk  = 0x200   // Bit mask of SWIER9 field.
	EXTI_SWIER_SWIER9      = 0x200   // Bit SWIER9.
	EXTI_SWIER_SWIER10_Pos = 0xa     // Position of SWIER10 field.
	EXTI_SWIER_SWIER10_Msk = 0x400   // Bit mask of SWIER10 field.
	EXTI_SWIER_SWIER10     = 0x400   // Bit SWIER10.
	EXTI_SWIER_SWIER11_Pos = 0xb     // Position of SWIER11 field.
	EXTI_SWIER_SWIER11_Msk = 0x800   // Bit mask of SWIER11 field.
	EXTI_SWIER_SWIER11     = 0x800   // Bit SWIER11.
	EXTI_SWIER_SWIER12_Pos = 0xc     // Position of SWIER12 field.
	EXTI_SWIER_SWIER12_Msk = 0x1000  // Bit mask of SWIER12 field.
	EXTI_SWIER_SWIER12     = 0x1000  // Bit SWIER12.
	EXTI_SWIER_SWIER13_Pos = 0xd     // Position of SWIER13 field.
	EXTI_SWIER_SWIER13_Msk = 0x2000  // Bit mask of SWIER13 field.
	EXTI_SWIER_SWIER13     = 0x2000  // Bit SWIER13.
	EXTI_SWIER_SWIER14_Pos = 0xe     // Position of SWIER14 field.
	EXTI_SWIER_SWIER14_Msk = 0x4000  // Bit mask of SWIER14 field.
	EXTI_SWIER_SWIER14     = 0x4000  // Bit SWIER14.
	EXTI_SWIER_SWIER15_Pos = 0xf     // Position of SWIER15 field.
	EXTI_SWIER_SWIER15_Msk = 0x8000  // Bit mask of SWIER15 field.
	EXTI_SWIER_SWIER15     = 0x8000  // Bit SWIER15.
	EXTI_SWIER_SWIER16_Pos = 0x10    // Position of SWIER16 field.
	EXTI_SWIER_SWIER16_Msk = 0x10000 // Bit mask of SWIER16 field.
	EXTI_SWIER_SWIER16     = 0x10000 // Bit SWIER16.
	EXTI_SWIER_SWIER17_Pos = 0x11    // Position of SWIER17 field.
	EXTI_SWIER_SWIER17_Msk = 0x20000 // Bit mask of SWIER17 field.
	EXTI_SWIER_SWIER17     = 0x20000 // Bit SWIER17.
	EXTI_SWIER_SWIER19_Pos = 0x13    // Position of SWIER19 field.
	EXTI_SWIER_SWIER19_Msk = 0x80000 // Bit mask of SWIER19 field.
	EXTI_SWIER_SWIER19     = 0x80000 // Bit SWIER19.

	// PR: Pending register (EXTI_PR)
	EXTI_PR_PR0_Pos  = 0x0     // Position of PR0 field.
	EXTI_PR_PR0_Msk  = 0x1     // Bit mask of PR0 field.
	EXTI_PR_PR0      = 0x1     // Bit PR0.
	EXTI_PR_PR1_Pos  = 0x1     // Position of PR1 field.
	EXTI_PR_PR1_Msk  = 0x2     // Bit mask of PR1 field.
	EXTI_PR_PR1      = 0x2     // Bit PR1.
	EXTI_PR_PR2_Pos  = 0x2     // Position of PR2 field.
	EXTI_PR_PR2_Msk  = 0x4     // Bit mask of PR2 field.
	EXTI_PR_PR2      = 0x4     // Bit PR2.
	EXTI_PR_PR3_Pos  = 0x3     // Position of PR3 field.
	EXTI_PR_PR3_Msk  = 0x8     // Bit mask of PR3 field.
	EXTI_PR_PR3      = 0x8     // Bit PR3.
	EXTI_PR_PR4_Pos  = 0x4     // Position of PR4 field.
	EXTI_PR_PR4_Msk  = 0x10    // Bit mask of PR4 field.
	EXTI_PR_PR4      = 0x10    // Bit PR4.
	EXTI_PR_PR5_Pos  = 0x5     // Position of PR5 field.
	EXTI_PR_PR5_Msk  = 0x20    // Bit mask of PR5 field.
	EXTI_PR_PR5      = 0x20    // Bit PR5.
	EXTI_PR_PR6_Pos  = 0x6     // Position of PR6 field.
	EXTI_PR_PR6_Msk  = 0x40    // Bit mask of PR6 field.
	EXTI_PR_PR6      = 0x40    // Bit PR6.
	EXTI_PR_PR7_Pos  = 0x7     // Position of PR7 field.
	EXTI_PR_PR7_Msk  = 0x80    // Bit mask of PR7 field.
	EXTI_PR_PR7      = 0x80    // Bit PR7.
	EXTI_PR_PR8_Pos  = 0x8     // Position of PR8 field.
	EXTI_PR_PR8_Msk  = 0x100   // Bit mask of PR8 field.
	EXTI_PR_PR8      = 0x100   // Bit PR8.
	EXTI_PR_PR9_Pos  = 0x9     // Position of PR9 field.
	EXTI_PR_PR9_Msk  = 0x200   // Bit mask of PR9 field.
	EXTI_PR_PR9      = 0x200   // Bit PR9.
	EXTI_PR_PR10_Pos = 0xa     // Position of PR10 field.
	EXTI_PR_PR10_Msk = 0x400   // Bit mask of PR10 field.
	EXTI_PR_PR10     = 0x400   // Bit PR10.
	EXTI_PR_PR11_Pos = 0xb     // Position of PR11 field.
	EXTI_PR_PR11_Msk = 0x800   // Bit mask of PR11 field.
	EXTI_PR_PR11     = 0x800   // Bit PR11.
	EXTI_PR_PR12_Pos = 0xc     // Position of PR12 field.
	EXTI_PR_PR12_Msk = 0x1000  // Bit mask of PR12 field.
	EXTI_PR_PR12     = 0x1000  // Bit PR12.
	EXTI_PR_PR13_Pos = 0xd     // Position of PR13 field.
	EXTI_PR_PR13_Msk = 0x2000  // Bit mask of PR13 field.
	EXTI_PR_PR13     = 0x2000  // Bit PR13.
	EXTI_PR_PR14_Pos = 0xe     // Position of PR14 field.
	EXTI_PR_PR14_Msk = 0x4000  // Bit mask of PR14 field.
	EXTI_PR_PR14     = 0x4000  // Bit PR14.
	EXTI_PR_PR15_Pos = 0xf     // Position of PR15 field.
	EXTI_PR_PR15_Msk = 0x8000  // Bit mask of PR15 field.
	EXTI_PR_PR15     = 0x8000  // Bit PR15.
	EXTI_PR_PR16_Pos = 0x10    // Position of PR16 field.
	EXTI_PR_PR16_Msk = 0x10000 // Bit mask of PR16 field.
	EXTI_PR_PR16     = 0x10000 // Bit PR16.
	EXTI_PR_PR17_Pos = 0x11    // Position of PR17 field.
	EXTI_PR_PR17_Msk = 0x20000 // Bit mask of PR17 field.
	EXTI_PR_PR17     = 0x20000 // Bit PR17.
	EXTI_PR_PR19_Pos = 0x13    // Position of PR19 field.
	EXTI_PR_PR19_Msk = 0x80000 // Bit mask of PR19 field.
	EXTI_PR_PR19     = 0x80000 // Bit PR19.
)

// Bitfields for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER: Interrupt Set Enable Register
	NVIC_ISER_SETENA_Pos = 0x0        // Position of SETENA field.
	NVIC_ISER_SETENA_Msk = 0xffffffff // Bit mask of SETENA field.

	// ICER: Interrupt Clear Enable           Register
	NVIC_ICER_CLRENA_Pos = 0x0        // Position of CLRENA field.
	NVIC_ICER_CLRENA_Msk = 0xffffffff // Bit mask of CLRENA field.

	// ISPR: Interrupt Set-Pending Register
	NVIC_ISPR_SETPEND_Pos = 0x0        // Position of SETPEND field.
	NVIC_ISPR_SETPEND_Msk = 0xffffffff // Bit mask of SETPEND field.

	// ICPR: Interrupt Clear-Pending           Register
	NVIC_ICPR_CLRPEND_Pos = 0x0        // Position of CLRPEND field.
	NVIC_ICPR_CLRPEND_Msk = 0xffffffff // Bit mask of CLRPEND field.

	// IPR0: Interrupt Priority Register 0
	NVIC_IPR0_PRI_00_Pos = 0x6        // Position of PRI_00 field.
	NVIC_IPR0_PRI_00_Msk = 0xc0       // Bit mask of PRI_00 field.
	NVIC_IPR0_PRI_01_Pos = 0xe        // Position of PRI_01 field.
	NVIC_IPR0_PRI_01_Msk = 0xc000     // Bit mask of PRI_01 field.
	NVIC_IPR0_PRI_02_Pos = 0x16       // Position of PRI_02 field.
	NVIC_IPR0_PRI_02_Msk = 0xc00000   // Bit mask of PRI_02 field.
	NVIC_IPR0_PRI_03_Pos = 0x1e       // Position of PRI_03 field.
	NVIC_IPR0_PRI_03_Msk = 0xc0000000 // Bit mask of PRI_03 field.

	// IPR1: Interrupt Priority Register 1
	NVIC_IPR1_PRI_40_Pos = 0x6        // Position of PRI_40 field.
	NVIC_IPR1_PRI_40_Msk = 0xc0       // Bit mask of PRI_40 field.
	NVIC_IPR1_PRI_41_Pos = 0xe        // Position of PRI_41 field.
	NVIC_IPR1_PRI_41_Msk = 0xc000     // Bit mask of PRI_41 field.
	NVIC_IPR1_PRI_42_Pos = 0x16       // Position of PRI_42 field.
	NVIC_IPR1_PRI_42_Msk = 0xc00000   // Bit mask of PRI_42 field.
	NVIC_IPR1_PRI_43_Pos = 0x1e       // Position of PRI_43 field.
	NVIC_IPR1_PRI_43_Msk = 0xc0000000 // Bit mask of PRI_43 field.

	// IPR2: Interrupt Priority Register 2
	NVIC_IPR2_PRI_80_Pos = 0x6        // Position of PRI_80 field.
	NVIC_IPR2_PRI_80_Msk = 0xc0       // Bit mask of PRI_80 field.
	NVIC_IPR2_PRI_81_Pos = 0xe        // Position of PRI_81 field.
	NVIC_IPR2_PRI_81_Msk = 0xc000     // Bit mask of PRI_81 field.
	NVIC_IPR2_PRI_82_Pos = 0x16       // Position of PRI_82 field.
	NVIC_IPR2_PRI_82_Msk = 0xc00000   // Bit mask of PRI_82 field.
	NVIC_IPR2_PRI_83_Pos = 0x1e       // Position of PRI_83 field.
	NVIC_IPR2_PRI_83_Msk = 0xc0000000 // Bit mask of PRI_83 field.

	// IPR3: Interrupt Priority Register 3
	NVIC_IPR3_PRI_120_Pos = 0x6        // Position of PRI_120 field.
	NVIC_IPR3_PRI_120_Msk = 0xc0       // Bit mask of PRI_120 field.
	NVIC_IPR3_PRI_121_Pos = 0xe        // Position of PRI_121 field.
	NVIC_IPR3_PRI_121_Msk = 0xc000     // Bit mask of PRI_121 field.
	NVIC_IPR3_PRI_122_Pos = 0x16       // Position of PRI_122 field.
	NVIC_IPR3_PRI_122_Msk = 0xc00000   // Bit mask of PRI_122 field.
	NVIC_IPR3_PRI_123_Pos = 0x1e       // Position of PRI_123 field.
	NVIC_IPR3_PRI_123_Msk = 0xc0000000 // Bit mask of PRI_123 field.

	// IPR4: Interrupt Priority Register 4
	NVIC_IPR4_PRI_160_Pos = 0x6        // Position of PRI_160 field.
	NVIC_IPR4_PRI_160_Msk = 0xc0       // Bit mask of PRI_160 field.
	NVIC_IPR4_PRI_161_Pos = 0xe        // Position of PRI_161 field.
	NVIC_IPR4_PRI_161_Msk = 0xc000     // Bit mask of PRI_161 field.
	NVIC_IPR4_PRI_162_Pos = 0x16       // Position of PRI_162 field.
	NVIC_IPR4_PRI_162_Msk = 0xc00000   // Bit mask of PRI_162 field.
	NVIC_IPR4_PRI_163_Pos = 0x1e       // Position of PRI_163 field.
	NVIC_IPR4_PRI_163_Msk = 0xc0000000 // Bit mask of PRI_163 field.

	// IPR5: Interrupt Priority Register 5
	NVIC_IPR5_PRI_200_Pos = 0x6        // Position of PRI_200 field.
	NVIC_IPR5_PRI_200_Msk = 0xc0       // Bit mask of PRI_200 field.
	NVIC_IPR5_PRI_201_Pos = 0xe        // Position of PRI_201 field.
	NVIC_IPR5_PRI_201_Msk = 0xc000     // Bit mask of PRI_201 field.
	NVIC_IPR5_PRI_202_Pos = 0x16       // Position of PRI_202 field.
	NVIC_IPR5_PRI_202_Msk = 0xc00000   // Bit mask of PRI_202 field.
	NVIC_IPR5_PRI_203_Pos = 0x1e       // Position of PRI_203 field.
	NVIC_IPR5_PRI_203_Msk = 0xc0000000 // Bit mask of PRI_203 field.

	// IPR6: Interrupt Priority Register 6
	NVIC_IPR6_PRI_240_Pos = 0x6        // Position of PRI_240 field.
	NVIC_IPR6_PRI_240_Msk = 0xc0       // Bit mask of PRI_240 field.
	NVIC_IPR6_PRI_241_Pos = 0xe        // Position of PRI_241 field.
	NVIC_IPR6_PRI_241_Msk = 0xc000     // Bit mask of PRI_241 field.
	NVIC_IPR6_PRI_242_Pos = 0x16       // Position of PRI_242 field.
	NVIC_IPR6_PRI_242_Msk = 0xc00000   // Bit mask of PRI_242 field.
	NVIC_IPR6_PRI_243_Pos = 0x1e       // Position of PRI_243 field.
	NVIC_IPR6_PRI_243_Msk = 0xc0000000 // Bit mask of PRI_243 field.

	// IPR7: Interrupt Priority Register 7
	NVIC_IPR7_PRI_280_Pos = 0x6        // Position of PRI_280 field.
	NVIC_IPR7_PRI_280_Msk = 0xc0       // Bit mask of PRI_280 field.
	NVIC_IPR7_PRI_281_Pos = 0xe        // Position of PRI_281 field.
	NVIC_IPR7_PRI_281_Msk = 0xc000     // Bit mask of PRI_281 field.
	NVIC_IPR7_PRI_282_Pos = 0x16       // Position of PRI_282 field.
	NVIC_IPR7_PRI_282_Msk = 0xc00000   // Bit mask of PRI_282 field.
	NVIC_IPR7_PRI_283_Pos = 0x1e       // Position of PRI_283 field.
	NVIC_IPR7_PRI_283_Msk = 0xc0000000 // Bit mask of PRI_283 field.
)

// Bitfields for DMA: DMA controller
const (
	// ISR: DMA interrupt status register           (DMA_ISR)
	DMA_ISR_GIF1_Pos  = 0x0       // Position of GIF1 field.
	DMA_ISR_GIF1_Msk  = 0x1       // Bit mask of GIF1 field.
	DMA_ISR_GIF1      = 0x1       // Bit GIF1.
	DMA_ISR_TCIF1_Pos = 0x1       // Position of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2       // Bit mask of TCIF1 field.
	DMA_ISR_TCIF1     = 0x2       // Bit TCIF1.
	DMA_ISR_HTIF1_Pos = 0x2       // Position of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4       // Bit mask of HTIF1 field.
	DMA_ISR_HTIF1     = 0x4       // Bit HTIF1.
	DMA_ISR_TEIF1_Pos = 0x3       // Position of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8       // Bit mask of TEIF1 field.
	DMA_ISR_TEIF1     = 0x8       // Bit TEIF1.
	DMA_ISR_GIF2_Pos  = 0x4       // Position of GIF2 field.
	DMA_ISR_GIF2_Msk  = 0x10      // Bit mask of GIF2 field.
	DMA_ISR_GIF2      = 0x10      // Bit GIF2.
	DMA_ISR_TCIF2_Pos = 0x5       // Position of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20      // Bit mask of TCIF2 field.
	DMA_ISR_TCIF2     = 0x20      // Bit TCIF2.
	DMA_ISR_HTIF2_Pos = 0x6       // Position of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40      // Bit mask of HTIF2 field.
	DMA_ISR_HTIF2     = 0x40      // Bit HTIF2.
	DMA_ISR_TEIF2_Pos = 0x7       // Position of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80      // Bit mask of TEIF2 field.
	DMA_ISR_TEIF2     = 0x80      // Bit TEIF2.
	DMA_ISR_GIF3_Pos  = 0x8       // Position of GIF3 field.
	DMA_ISR_GIF3_Msk  = 0x100     // Bit mask of GIF3 field.
	DMA_ISR_GIF3      = 0x100     // Bit GIF3.
	DMA_ISR_TCIF3_Pos = 0x9       // Position of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200     // Bit mask of TCIF3 field.
	DMA_ISR_TCIF3     = 0x200     // Bit TCIF3.
	DMA_ISR_HTIF3_Pos = 0xa       // Position of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400     // Bit mask of HTIF3 field.
	DMA_ISR_HTIF3     = 0x400     // Bit HTIF3.
	DMA_ISR_TEIF3_Pos = 0xb       // Position of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800     // Bit mask of TEIF3 field.
	DMA_ISR_TEIF3     = 0x800     // Bit TEIF3.
	DMA_ISR_GIF4_Pos  = 0xc       // Position of GIF4 field.
	DMA_ISR_GIF4_Msk  = 0x1000    // Bit mask of GIF4 field.
	DMA_ISR_GIF4      = 0x1000    // Bit GIF4.
	DMA_ISR_TCIF4_Pos = 0xd       // Position of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000    // Bit mask of TCIF4 field.
	DMA_ISR_TCIF4     = 0x2000    // Bit TCIF4.
	DMA_ISR_HTIF4_Pos = 0xe       // Position of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000    // Bit mask of HTIF4 field.
	DMA_ISR_HTIF4     = 0x4000    // Bit HTIF4.
	DMA_ISR_TEIF4_Pos = 0xf       // Position of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000    // Bit mask of TEIF4 field.
	DMA_ISR_TEIF4     = 0x8000    // Bit TEIF4.
	DMA_ISR_GIF5_Pos  = 0x10      // Position of GIF5 field.
	DMA_ISR_GIF5_Msk  = 0x10000   // Bit mask of GIF5 field.
	DMA_ISR_GIF5      = 0x10000   // Bit GIF5.
	DMA_ISR_TCIF5_Pos = 0x11      // Position of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000   // Bit mask of TCIF5 field.
	DMA_ISR_TCIF5     = 0x20000   // Bit TCIF5.
	DMA_ISR_HTIF5_Pos = 0x12      // Position of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000   // Bit mask of HTIF5 field.
	DMA_ISR_HTIF5     = 0x40000   // Bit HTIF5.
	DMA_ISR_TEIF5_Pos = 0x13      // Position of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000   // Bit mask of TEIF5 field.
	DMA_ISR_TEIF5     = 0x80000   // Bit TEIF5.
	DMA_ISR_GIF6_Pos  = 0x14      // Position of GIF6 field.
	DMA_ISR_GIF6_Msk  = 0x100000  // Bit mask of GIF6 field.
	DMA_ISR_GIF6      = 0x100000  // Bit GIF6.
	DMA_ISR_TCIF6_Pos = 0x15      // Position of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000  // Bit mask of TCIF6 field.
	DMA_ISR_TCIF6     = 0x200000  // Bit TCIF6.
	DMA_ISR_HTIF6_Pos = 0x16      // Position of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000  // Bit mask of HTIF6 field.
	DMA_ISR_HTIF6     = 0x400000  // Bit HTIF6.
	DMA_ISR_TEIF6_Pos = 0x17      // Position of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000  // Bit mask of TEIF6 field.
	DMA_ISR_TEIF6     = 0x800000  // Bit TEIF6.
	DMA_ISR_GIF7_Pos  = 0x18      // Position of GIF7 field.
	DMA_ISR_GIF7_Msk  = 0x1000000 // Bit mask of GIF7 field.
	DMA_ISR_GIF7      = 0x1000000 // Bit GIF7.
	DMA_ISR_TCIF7_Pos = 0x19      // Position of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000 // Bit mask of TCIF7 field.
	DMA_ISR_TCIF7     = 0x2000000 // Bit TCIF7.
	DMA_ISR_HTIF7_Pos = 0x1a      // Position of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000 // Bit mask of HTIF7 field.
	DMA_ISR_HTIF7     = 0x4000000 // Bit HTIF7.
	DMA_ISR_TEIF7_Pos = 0x1b      // Position of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000 // Bit mask of TEIF7 field.
	DMA_ISR_TEIF7     = 0x8000000 // Bit TEIF7.

	// IFCR: DMA interrupt flag clear register           (DMA_IFCR)
	DMA_IFCR_CGIF1_Pos  = 0x0       // Position of CGIF1 field.
	DMA_IFCR_CGIF1_Msk  = 0x1       // Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1      = 0x1       // Bit CGIF1.
	DMA_IFCR_CTCIF1_Pos = 0x1       // Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2       // Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1     = 0x2       // Bit CTCIF1.
	DMA_IFCR_CHTIF1_Pos = 0x2       // Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4       // Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1     = 0x4       // Bit CHTIF1.
	DMA_IFCR_CTEIF1_Pos = 0x3       // Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8       // Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1     = 0x8       // Bit CTEIF1.
	DMA_IFCR_CGIF2_Pos  = 0x4       // Position of CGIF2 field.
	DMA_IFCR_CGIF2_Msk  = 0x10      // Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2      = 0x10      // Bit CGIF2.
	DMA_IFCR_CTCIF2_Pos = 0x5       // Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20      // Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2     = 0x20      // Bit CTCIF2.
	DMA_IFCR_CHTIF2_Pos = 0x6       // Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40      // Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2     = 0x40      // Bit CHTIF2.
	DMA_IFCR_CTEIF2_Pos = 0x7       // Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80      // Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2     = 0x80      // Bit CTEIF2.
	DMA_IFCR_CGIF3_Pos  = 0x8       // Position of CGIF3 field.
	DMA_IFCR_CGIF3_Msk  = 0x100     // Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3      = 0x100     // Bit CGIF3.
	DMA_IFCR_CTCIF3_Pos = 0x9       // Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200     // Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3     = 0x200     // Bit CTCIF3.
	DMA_IFCR_CHTIF3_Pos = 0xa       // Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400     // Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3     = 0x400     // Bit CHTIF3.
	DMA_IFCR_CTEIF3_Pos = 0xb       // Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800     // Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3     = 0x800     // Bit CTEIF3.
	DMA_IFCR_CGIF4_Pos  = 0xc       // Position of CGIF4 field.
	DMA_IFCR_CGIF4_Msk  = 0x1000    // Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4      = 0x1000    // Bit CGIF4.
	DMA_IFCR_CTCIF4_Pos = 0xd       // Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000    // Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4     = 0x2000    // Bit CTCIF4.
	DMA_IFCR_CHTIF4_Pos = 0xe       // Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000    // Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4     = 0x4000    // Bit CHTIF4.
	DMA_IFCR_CTEIF4_Pos = 0xf       // Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000    // Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4     = 0x8000    // Bit CTEIF4.
	DMA_IFCR_CGIF5_Pos  = 0x10      // Position of CGIF5 field.
	DMA_IFCR_CGIF5_Msk  = 0x10000   // Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5      = 0x10000   // Bit CGIF5.
	DMA_IFCR_CTCIF5_Pos = 0x11      // Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000   // Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5     = 0x20000   // Bit CTCIF5.
	DMA_IFCR_CHTIF5_Pos = 0x12      // Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000   // Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5     = 0x40000   // Bit CHTIF5.
	DMA_IFCR_CTEIF5_Pos = 0x13      // Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000   // Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5     = 0x80000   // Bit CTEIF5.
	DMA_IFCR_CGIF6_Pos  = 0x14      // Position of CGIF6 field.
	DMA_IFCR_CGIF6_Msk  = 0x100000  // Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6      = 0x100000  // Bit CGIF6.
	DMA_IFCR_CTCIF6_Pos = 0x15      // Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000  // Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6     = 0x200000  // Bit CTCIF6.
	DMA_IFCR_CHTIF6_Pos = 0x16      // Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000  // Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6     = 0x400000  // Bit CHTIF6.
	DMA_IFCR_CTEIF6_Pos = 0x17      // Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000  // Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6     = 0x800000  // Bit CTEIF6.
	DMA_IFCR_CGIF7_Pos  = 0x18      // Position of CGIF7 field.
	DMA_IFCR_CGIF7_Msk  = 0x1000000 // Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7      = 0x1000000 // Bit CGIF7.
	DMA_IFCR_CTCIF7_Pos = 0x19      // Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000 // Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7     = 0x2000000 // Bit CTCIF7.
	DMA_IFCR_CHTIF7_Pos = 0x1a      // Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000 // Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7     = 0x4000000 // Bit CHTIF7.
	DMA_IFCR_CTEIF7_Pos = 0x1b      // Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000 // Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7     = 0x8000000 // Bit CTEIF7.

	// CCR1: DMA channel configuration register           (DMA_CCR)
	DMA_CCR1_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR1_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR1_EN          = 0x1    // Bit EN.
	DMA_CCR1_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR1_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR1_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR1_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR1_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR1_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR1_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR1_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR1_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR1_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR1_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR1_DIR         = 0x10   // Bit DIR.
	DMA_CCR1_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR1_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR1_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR1_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR1_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR1_PINC        = 0x40   // Bit PINC.
	DMA_CCR1_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR1_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR1_MINC        = 0x80   // Bit MINC.
	DMA_CCR1_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR1_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR1_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR1_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR1_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR1_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR1_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR1: DMA channel 1 number of data           register
	DMA_CNDTR1_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR1_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR1: DMA channel 1 peripheral address           register
	DMA_CPAR1_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR1: DMA channel 1 memory address           register
	DMA_CMAR1_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR2: DMA channel configuration register           (DMA_CCR)
	DMA_CCR2_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR2_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR2_EN          = 0x1    // Bit EN.
	DMA_CCR2_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR2_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR2_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR2_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR2_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR2_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR2_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR2_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR2_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR2_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR2_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR2_DIR         = 0x10   // Bit DIR.
	DMA_CCR2_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR2_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR2_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR2_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR2_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR2_PINC        = 0x40   // Bit PINC.
	DMA_CCR2_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR2_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR2_MINC        = 0x80   // Bit MINC.
	DMA_CCR2_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR2_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR2_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR2_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR2_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR2_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR2_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR2: DMA channel 2 number of data           register
	DMA_CNDTR2_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR2_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR2: DMA channel 2 peripheral address           register
	DMA_CPAR2_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR2: DMA channel 2 memory address           register
	DMA_CMAR2_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR3: DMA channel configuration register           (DMA_CCR)
	DMA_CCR3_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR3_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR3_EN          = 0x1    // Bit EN.
	DMA_CCR3_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR3_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR3_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR3_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR3_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR3_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR3_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR3_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR3_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR3_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR3_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR3_DIR         = 0x10   // Bit DIR.
	DMA_CCR3_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR3_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR3_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR3_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR3_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR3_PINC        = 0x40   // Bit PINC.
	DMA_CCR3_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR3_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR3_MINC        = 0x80   // Bit MINC.
	DMA_CCR3_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR3_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR3_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR3_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR3_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR3_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR3_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR3: DMA channel 3 number of data           register
	DMA_CNDTR3_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR3_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR3: DMA channel 3 peripheral address           register
	DMA_CPAR3_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR3: DMA channel 3 memory address           register
	DMA_CMAR3_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR4: DMA channel configuration register           (DMA_CCR)
	DMA_CCR4_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR4_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR4_EN          = 0x1    // Bit EN.
	DMA_CCR4_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR4_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR4_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR4_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR4_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR4_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR4_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR4_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR4_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR4_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR4_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR4_DIR         = 0x10   // Bit DIR.
	DMA_CCR4_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR4_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR4_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR4_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR4_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR4_PINC        = 0x40   // Bit PINC.
	DMA_CCR4_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR4_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR4_MINC        = 0x80   // Bit MINC.
	DMA_CCR4_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR4_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR4_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR4_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR4_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR4_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR4_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR4: DMA channel 4 number of data           register
	DMA_CNDTR4_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR4_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR4: DMA channel 4 peripheral address           register
	DMA_CPAR4_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR4: DMA channel 4 memory address           register
	DMA_CMAR4_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR5: DMA channel configuration register           (DMA_CCR)
	DMA_CCR5_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR5_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR5_EN          = 0x1    // Bit EN.
	DMA_CCR5_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR5_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR5_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR5_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR5_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR5_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR5_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR5_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR5_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR5_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR5_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR5_DIR         = 0x10   // Bit DIR.
	DMA_CCR5_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR5_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR5_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR5_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR5_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR5_PINC        = 0x40   // Bit PINC.
	DMA_CCR5_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR5_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR5_MINC        = 0x80   // Bit MINC.
	DMA_CCR5_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR5_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR5_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR5_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR5_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR5_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR5_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR5: DMA channel 5 number of data           register
	DMA_CNDTR5_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR5_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR5: DMA channel 5 peripheral address           register
	DMA_CPAR5_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR5: DMA channel 5 memory address           register
	DMA_CMAR5_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR6: DMA channel configuration register           (DMA_CCR)
	DMA_CCR6_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR6_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR6_EN          = 0x1    // Bit EN.
	DMA_CCR6_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR6_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR6_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR6_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR6_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR6_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR6_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR6_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR6_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR6_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR6_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR6_DIR         = 0x10   // Bit DIR.
	DMA_CCR6_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR6_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR6_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR6_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR6_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR6_PINC        = 0x40   // Bit PINC.
	DMA_CCR6_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR6_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR6_MINC        = 0x80   // Bit MINC.
	DMA_CCR6_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR6_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR6_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR6_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR6_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR6_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR6_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR6: DMA channel 6 number of data           register
	DMA_CNDTR6_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR6_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR6: DMA channel 6 peripheral address           register
	DMA_CPAR6_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR6: DMA channel 6 memory address           register
	DMA_CMAR6_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff // Bit mask of MA field.

	// CCR7: DMA channel configuration register           (DMA_CCR)
	DMA_CCR7_EN_Pos      = 0x0    // Position of EN field.
	DMA_CCR7_EN_Msk      = 0x1    // Bit mask of EN field.
	DMA_CCR7_EN          = 0x1    // Bit EN.
	DMA_CCR7_TCIE_Pos    = 0x1    // Position of TCIE field.
	DMA_CCR7_TCIE_Msk    = 0x2    // Bit mask of TCIE field.
	DMA_CCR7_TCIE        = 0x2    // Bit TCIE.
	DMA_CCR7_HTIE_Pos    = 0x2    // Position of HTIE field.
	DMA_CCR7_HTIE_Msk    = 0x4    // Bit mask of HTIE field.
	DMA_CCR7_HTIE        = 0x4    // Bit HTIE.
	DMA_CCR7_TEIE_Pos    = 0x3    // Position of TEIE field.
	DMA_CCR7_TEIE_Msk    = 0x8    // Bit mask of TEIE field.
	DMA_CCR7_TEIE        = 0x8    // Bit TEIE.
	DMA_CCR7_DIR_Pos     = 0x4    // Position of DIR field.
	DMA_CCR7_DIR_Msk     = 0x10   // Bit mask of DIR field.
	DMA_CCR7_DIR         = 0x10   // Bit DIR.
	DMA_CCR7_CIRC_Pos    = 0x5    // Position of CIRC field.
	DMA_CCR7_CIRC_Msk    = 0x20   // Bit mask of CIRC field.
	DMA_CCR7_CIRC        = 0x20   // Bit CIRC.
	DMA_CCR7_PINC_Pos    = 0x6    // Position of PINC field.
	DMA_CCR7_PINC_Msk    = 0x40   // Bit mask of PINC field.
	DMA_CCR7_PINC        = 0x40   // Bit PINC.
	DMA_CCR7_MINC_Pos    = 0x7    // Position of MINC field.
	DMA_CCR7_MINC_Msk    = 0x80   // Bit mask of MINC field.
	DMA_CCR7_MINC        = 0x80   // Bit MINC.
	DMA_CCR7_PSIZE_Pos   = 0x8    // Position of PSIZE field.
	DMA_CCR7_PSIZE_Msk   = 0x300  // Bit mask of PSIZE field.
	DMA_CCR7_MSIZE_Pos   = 0xa    // Position of MSIZE field.
	DMA_CCR7_MSIZE_Msk   = 0xc00  // Bit mask of MSIZE field.
	DMA_CCR7_PL_Pos      = 0xc    // Position of PL field.
	DMA_CCR7_PL_Msk      = 0x3000 // Bit mask of PL field.
	DMA_CCR7_MEM2MEM_Pos = 0xe    // Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000 // Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM     = 0x4000 // Bit MEM2MEM.

	// CNDTR7: DMA channel 7 number of data           register
	DMA_CNDTR7_NDT_Pos = 0x0    // Position of NDT field.
	DMA_CNDTR7_NDT_Msk = 0xffff // Bit mask of NDT field.

	// CPAR7: DMA channel 7 peripheral address           register
	DMA_CPAR7_PA_Pos = 0x0        // Position of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff // Bit mask of PA field.

	// CMAR7: DMA channel 7 memory address           register
	DMA_CMAR7_MA_Pos = 0x0        // Position of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff // Bit mask of MA field.
)

// Bitfields for RCC: Reset and clock control
const (
	// CR: Clock control register
	RCC_CR_HSION_Pos   = 0x0       // Position of HSION field.
	RCC_CR_HSION_Msk   = 0x1       // Bit mask of HSION field.
	RCC_CR_HSION       = 0x1       // Bit HSION.
	RCC_CR_HSIRDY_Pos  = 0x1       // Position of HSIRDY field.
	RCC_CR_HSIRDY_Msk  = 0x2       // Bit mask of HSIRDY field.
	RCC_CR_HSIRDY      = 0x2       // Bit HSIRDY.
	RCC_CR_HSITRIM_Pos = 0x3       // Position of HSITRIM field.
	RCC_CR_HSITRIM_Msk = 0xf8      // Bit mask of HSITRIM field.
	RCC_CR_HSICAL_Pos  = 0x8       // Position of HSICAL field.
	RCC_CR_HSICAL_Msk  = 0xff00    // Bit mask of HSICAL field.
	RCC_CR_HSEON_Pos   = 0x10      // Position of HSEON field.
	RCC_CR_HSEON_Msk   = 0x10000   // Bit mask of HSEON field.
	RCC_CR_HSEON       = 0x10000   // Bit HSEON.
	RCC_CR_HSERDY_Pos  = 0x11      // Position of HSERDY field.
	RCC_CR_HSERDY_Msk  = 0x20000   // Bit mask of HSERDY field.
	RCC_CR_HSERDY      = 0x20000   // Bit HSERDY.
	RCC_CR_HSEBYP_Pos  = 0x12      // Position of HSEBYP field.
	RCC_CR_HSEBYP_Msk  = 0x40000   // Bit mask of HSEBYP field.
	RCC_CR_HSEBYP      = 0x40000   // Bit HSEBYP.
	RCC_CR_CSSON_Pos   = 0x13      // Position of CSSON field.
	RCC_CR_CSSON_Msk   = 0x80000   // Bit mask of CSSON field.
	RCC_CR_CSSON       = 0x80000   // Bit CSSON.
	RCC_CR_PLLON_Pos   = 0x18      // Position of PLLON field.
	RCC_CR_PLLON_Msk   = 0x1000000 // Bit mask of PLLON field.
	RCC_CR_PLLON       = 0x1000000 // Bit PLLON.
	RCC_CR_PLLRDY_Pos  = 0x19      // Position of PLLRDY field.
	RCC_CR_PLLRDY_Msk  = 0x2000000 // Bit mask of PLLRDY field.
	RCC_CR_PLLRDY      = 0x2000000 // Bit PLLRDY.

	// CFGR: Clock configuration register           (RCC_CFGR)
	RCC_CFGR_SW_Pos       = 0x0        // Position of SW field.
	RCC_CFGR_SW_Msk       = 0x3        // Bit mask of SW field.
	RCC_CFGR_SWS_Pos      = 0x2        // Position of SWS field.
	RCC_CFGR_SWS_Msk      = 0xc        // Bit mask of SWS field.
	RCC_CFGR_HPRE_Pos     = 0x4        // Position of HPRE field.
	RCC_CFGR_HPRE_Msk     = 0xf0       // Bit mask of HPRE field.
	RCC_CFGR_PPRE_Pos     = 0x8        // Position of PPRE field.
	RCC_CFGR_PPRE_Msk     = 0x700      // Bit mask of PPRE field.
	RCC_CFGR_ADCPRE_Pos   = 0xe        // Position of ADCPRE field.
	RCC_CFGR_ADCPRE_Msk   = 0x4000     // Bit mask of ADCPRE field.
	RCC_CFGR_ADCPRE       = 0x4000     // Bit ADCPRE.
	RCC_CFGR_PLLSRC_Pos   = 0xf        // Position of PLLSRC field.
	RCC_CFGR_PLLSRC_Msk   = 0x18000    // Bit mask of PLLSRC field.
	RCC_CFGR_PLLXTPRE_Pos = 0x11       // Position of PLLXTPRE field.
	RCC_CFGR_PLLXTPRE_Msk = 0x20000    // Bit mask of PLLXTPRE field.
	RCC_CFGR_PLLXTPRE     = 0x20000    // Bit PLLXTPRE.
	RCC_CFGR_PLLMUL_Pos   = 0x12       // Position of PLLMUL field.
	RCC_CFGR_PLLMUL_Msk   = 0x3c0000   // Bit mask of PLLMUL field.
	RCC_CFGR_MCO_Pos      = 0x18       // Position of MCO field.
	RCC_CFGR_MCO_Msk      = 0x7000000  // Bit mask of MCO field.
	RCC_CFGR_MCOPRE_Pos   = 0x1c       // Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk   = 0x70000000 // Bit mask of MCOPRE field.
	RCC_CFGR_PLLNODIV_Pos = 0x1f       // Position of PLLNODIV field.
	RCC_CFGR_PLLNODIV_Msk = 0x80000000 // Bit mask of PLLNODIV field.
	RCC_CFGR_PLLNODIV     = 0x80000000 // Bit PLLNODIV.

	// CIR: Clock interrupt register           (RCC_CIR)
	RCC_CIR_LSIRDYF_Pos    = 0x0      // Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk    = 0x1      // Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF        = 0x1      // Bit LSIRDYF.
	RCC_CIR_LSERDYF_Pos    = 0x1      // Position of LSERDYF field.
	RCC_CIR_LSERDYF_Msk    = 0x2      // Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF        = 0x2      // Bit LSERDYF.
	RCC_CIR_HSIRDYF_Pos    = 0x2      // Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk    = 0x4      // Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF        = 0x4      // Bit HSIRDYF.
	RCC_CIR_HSERDYF_Pos    = 0x3      // Position of HSERDYF field.
	RCC_CIR_HSERDYF_Msk    = 0x8      // Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF        = 0x8      // Bit HSERDYF.
	RCC_CIR_PLLRDYF_Pos    = 0x4      // Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk    = 0x10     // Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF        = 0x10     // Bit PLLRDYF.
	RCC_CIR_HSI14RDYF_Pos  = 0x5      // Position of HSI14RDYF field.
	RCC_CIR_HSI14RDYF_Msk  = 0x20     // Bit mask of HSI14RDYF field.
	RCC_CIR_HSI14RDYF      = 0x20     // Bit HSI14RDYF.
	RCC_CIR_HSI48RDYF_Pos  = 0x6      // Position of HSI48RDYF field.
	RCC_CIR_HSI48RDYF_Msk  = 0x40     // Bit mask of HSI48RDYF field.
	RCC_CIR_HSI48RDYF      = 0x40     // Bit HSI48RDYF.
	RCC_CIR_CSSF_Pos       = 0x7      // Position of CSSF field.
	RCC_CIR_CSSF_Msk       = 0x80     // Bit mask of CSSF field.
	RCC_CIR_CSSF           = 0x80     // Bit CSSF.
	RCC_CIR_LSIRDYIE_Pos   = 0x8      // Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk   = 0x100    // Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE       = 0x100    // Bit LSIRDYIE.
	RCC_CIR_LSERDYIE_Pos   = 0x9      // Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk   = 0x200    // Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE       = 0x200    // Bit LSERDYIE.
	RCC_CIR_HSIRDYIE_Pos   = 0xa      // Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk   = 0x400    // Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE       = 0x400    // Bit HSIRDYIE.
	RCC_CIR_HSERDYIE_Pos   = 0xb      // Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk   = 0x800    // Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE       = 0x800    // Bit HSERDYIE.
	RCC_CIR_PLLRDYIE_Pos   = 0xc      // Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk   = 0x1000   // Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE       = 0x1000   // Bit PLLRDYIE.
	RCC_CIR_HSI14RDYE_Pos  = 0xd      // Position of HSI14RDYE field.
	RCC_CIR_HSI14RDYE_Msk  = 0x2000   // Bit mask of HSI14RDYE field.
	RCC_CIR_HSI14RDYE      = 0x2000   // Bit HSI14RDYE.
	RCC_CIR_HSI48RDYIE_Pos = 0xe      // Position of HSI48RDYIE field.
	RCC_CIR_HSI48RDYIE_Msk = 0x4000   // Bit mask of HSI48RDYIE field.
	RCC_CIR_HSI48RDYIE     = 0x4000   // Bit HSI48RDYIE.
	RCC_CIR_LSIRDYC_Pos    = 0x10     // Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk    = 0x10000  // Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC        = 0x10000  // Bit LSIRDYC.
	RCC_CIR_LSERDYC_Pos    = 0x11     // Position of LSERDYC field.
	RCC_CIR_LSERDYC_Msk    = 0x20000  // Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC        = 0x20000  // Bit LSERDYC.
	RCC_CIR_HSIRDYC_Pos    = 0x12     // Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk    = 0x40000  // Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC        = 0x40000  // Bit HSIRDYC.
	RCC_CIR_HSERDYC_Pos    = 0x13     // Position of HSERDYC field.
	RCC_CIR_HSERDYC_Msk    = 0x80000  // Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC        = 0x80000  // Bit HSERDYC.
	RCC_CIR_PLLRDYC_Pos    = 0x14     // Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk    = 0x100000 // Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC        = 0x100000 // Bit PLLRDYC.
	RCC_CIR_HSI14RDYC_Pos  = 0x15     // Position of HSI14RDYC field.
	RCC_CIR_HSI14RDYC_Msk  = 0x200000 // Bit mask of HSI14RDYC field.
	RCC_CIR_HSI14RDYC      = 0x200000 // Bit HSI14RDYC.
	RCC_CIR_HSI48RDYC_Pos  = 0x16     // Position of HSI48RDYC field.
	RCC_CIR_HSI48RDYC_Msk  = 0x400000 // Bit mask of HSI48RDYC field.
	RCC_CIR_HSI48RDYC      = 0x400000 // Bit HSI48RDYC.
	RCC_CIR_CSSC_Pos       = 0x17     // Position of CSSC field.
	RCC_CIR_CSSC_Msk       = 0x800000 // Bit mask of CSSC field.
	RCC_CIR_CSSC           = 0x800000 // Bit CSSC.

	// APB2RSTR: APB2 peripheral reset register           (RCC_APB2RSTR)
	RCC_APB2RSTR_SYSCFGRST_Pos = 0x0      // Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x1      // Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST     = 0x1      // Bit SYSCFGRST.
	RCC_APB2RSTR_ADCRST_Pos    = 0x9      // Position of ADCRST field.
	RCC_APB2RSTR_ADCRST_Msk    = 0x200    // Bit mask of ADCRST field.
	RCC_APB2RSTR_ADCRST        = 0x200    // Bit ADCRST.
	RCC_APB2RSTR_TIM1RST_Pos   = 0xb      // Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk   = 0x800    // Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST       = 0x800    // Bit TIM1RST.
	RCC_APB2RSTR_SPI1RST_Pos   = 0xc      // Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk   = 0x1000   // Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST       = 0x1000   // Bit SPI1RST.
	RCC_APB2RSTR_USART1RST_Pos = 0xe      // Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000   // Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST     = 0x4000   // Bit USART1RST.
	RCC_APB2RSTR_TIM15RST_Pos  = 0x10     // Position of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Msk  = 0x10000  // Bit mask of TIM15RST field.
	RCC_APB2RSTR_TIM15RST      = 0x10000  // Bit TIM15RST.
	RCC_APB2RSTR_TIM16RST_Pos  = 0x11     // Position of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Msk  = 0x20000  // Bit mask of TIM16RST field.
	RCC_APB2RSTR_TIM16RST      = 0x20000  // Bit TIM16RST.
	RCC_APB2RSTR_TIM17RST_Pos  = 0x12     // Position of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Msk  = 0x40000  // Bit mask of TIM17RST field.
	RCC_APB2RSTR_TIM17RST      = 0x40000  // Bit TIM17RST.
	RCC_APB2RSTR_DBGMCURST_Pos = 0x16     // Position of DBGMCURST field.
	RCC_APB2RSTR_DBGMCURST_Msk = 0x400000 // Bit mask of DBGMCURST field.
	RCC_APB2RSTR_DBGMCURST     = 0x400000 // Bit DBGMCURST.

	// APB1RSTR: APB1 peripheral reset register           (RCC_APB1RSTR)
	RCC_APB1RSTR_TIM2RST_Pos   = 0x0        // Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk   = 0x1        // Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST       = 0x1        // Bit TIM2RST.
	RCC_APB1RSTR_TIM3RST_Pos   = 0x1        // Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk   = 0x2        // Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST       = 0x2        // Bit TIM3RST.
	RCC_APB1RSTR_TIM6RST_Pos   = 0x4        // Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk   = 0x10       // Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST       = 0x10       // Bit TIM6RST.
	RCC_APB1RSTR_TIM7RST_Pos   = 0x5        // Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk   = 0x20       // Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST       = 0x20       // Bit TIM7RST.
	RCC_APB1RSTR_TIM14RST_Pos  = 0x8        // Position of TIM14RST field.
	RCC_APB1RSTR_TIM14RST_Msk  = 0x100      // Bit mask of TIM14RST field.
	RCC_APB1RSTR_TIM14RST      = 0x100      // Bit TIM14RST.
	RCC_APB1RSTR_WWDGRST_Pos   = 0xb        // Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk   = 0x800      // Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST       = 0x800      // Bit WWDGRST.
	RCC_APB1RSTR_SPI2RST_Pos   = 0xe        // Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk   = 0x4000     // Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST       = 0x4000     // Bit SPI2RST.
	RCC_APB1RSTR_USART2RST_Pos = 0x11       // Position of USART2RST field.
	RCC_APB1RSTR_USART2RST_Msk = 0x20000    // Bit mask of USART2RST field.
	RCC_APB1RSTR_USART2RST     = 0x20000    // Bit USART2RST.
	RCC_APB1RSTR_USART3RST_Pos = 0x12       // Position of USART3RST field.
	RCC_APB1RSTR_USART3RST_Msk = 0x40000    // Bit mask of USART3RST field.
	RCC_APB1RSTR_USART3RST     = 0x40000    // Bit USART3RST.
	RCC_APB1RSTR_USART4RST_Pos = 0x13       // Position of USART4RST field.
	RCC_APB1RSTR_USART4RST_Msk = 0x80000    // Bit mask of USART4RST field.
	RCC_APB1RSTR_USART4RST     = 0x80000    // Bit USART4RST.
	RCC_APB1RSTR_I2C1RST_Pos   = 0x15       // Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk   = 0x200000   // Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST       = 0x200000   // Bit I2C1RST.
	RCC_APB1RSTR_I2C2RST_Pos   = 0x16       // Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk   = 0x400000   // Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST       = 0x400000   // Bit I2C2RST.
	RCC_APB1RSTR_USBRST_Pos    = 0x17       // Position of USBRST field.
	RCC_APB1RSTR_USBRST_Msk    = 0x800000   // Bit mask of USBRST field.
	RCC_APB1RSTR_USBRST        = 0x800000   // Bit USBRST.
	RCC_APB1RSTR_CANRST_Pos    = 0x19       // Position of CANRST field.
	RCC_APB1RSTR_CANRST_Msk    = 0x2000000  // Bit mask of CANRST field.
	RCC_APB1RSTR_CANRST        = 0x2000000  // Bit CANRST.
	RCC_APB1RSTR_CRSRST_Pos    = 0x1b       // Position of CRSRST field.
	RCC_APB1RSTR_CRSRST_Msk    = 0x8000000  // Bit mask of CRSRST field.
	RCC_APB1RSTR_CRSRST        = 0x8000000  // Bit CRSRST.
	RCC_APB1RSTR_PWRRST_Pos    = 0x1c       // Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk    = 0x10000000 // Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST        = 0x10000000 // Bit PWRRST.
	RCC_APB1RSTR_DACRST_Pos    = 0x1d       // Position of DACRST field.
	RCC_APB1RSTR_DACRST_Msk    = 0x20000000 // Bit mask of DACRST field.
	RCC_APB1RSTR_DACRST        = 0x20000000 // Bit DACRST.
	RCC_APB1RSTR_CECRST_Pos    = 0x1e       // Position of CECRST field.
	RCC_APB1RSTR_CECRST_Msk    = 0x40000000 // Bit mask of CECRST field.
	RCC_APB1RSTR_CECRST        = 0x40000000 // Bit CECRST.

	// AHBENR: AHB Peripheral Clock enable register           (RCC_AHBENR)
	RCC_AHBENR_DMAEN_Pos   = 0x0       // Position of DMAEN field.
	RCC_AHBENR_DMAEN_Msk   = 0x1       // Bit mask of DMAEN field.
	RCC_AHBENR_DMAEN       = 0x1       // Bit DMAEN.
	RCC_AHBENR_SRAMEN_Pos  = 0x2       // Position of SRAMEN field.
	RCC_AHBENR_SRAMEN_Msk  = 0x4       // Bit mask of SRAMEN field.
	RCC_AHBENR_SRAMEN      = 0x4       // Bit SRAMEN.
	RCC_AHBENR_FLITFEN_Pos = 0x4       // Position of FLITFEN field.
	RCC_AHBENR_FLITFEN_Msk = 0x10      // Bit mask of FLITFEN field.
	RCC_AHBENR_FLITFEN     = 0x10      // Bit FLITFEN.
	RCC_AHBENR_CRCEN_Pos   = 0x6       // Position of CRCEN field.
	RCC_AHBENR_CRCEN_Msk   = 0x40      // Bit mask of CRCEN field.
	RCC_AHBENR_CRCEN       = 0x40      // Bit CRCEN.
	RCC_AHBENR_IOPAEN_Pos  = 0x11      // Position of IOPAEN field.
	RCC_AHBENR_IOPAEN_Msk  = 0x20000   // Bit mask of IOPAEN field.
	RCC_AHBENR_IOPAEN      = 0x20000   // Bit IOPAEN.
	RCC_AHBENR_IOPBEN_Pos  = 0x12      // Position of IOPBEN field.
	RCC_AHBENR_IOPBEN_Msk  = 0x40000   // Bit mask of IOPBEN field.
	RCC_AHBENR_IOPBEN      = 0x40000   // Bit IOPBEN.
	RCC_AHBENR_IOPCEN_Pos  = 0x13      // Position of IOPCEN field.
	RCC_AHBENR_IOPCEN_Msk  = 0x80000   // Bit mask of IOPCEN field.
	RCC_AHBENR_IOPCEN      = 0x80000   // Bit IOPCEN.
	RCC_AHBENR_IOPDEN_Pos  = 0x14      // Position of IOPDEN field.
	RCC_AHBENR_IOPDEN_Msk  = 0x100000  // Bit mask of IOPDEN field.
	RCC_AHBENR_IOPDEN      = 0x100000  // Bit IOPDEN.
	RCC_AHBENR_IOPFEN_Pos  = 0x16      // Position of IOPFEN field.
	RCC_AHBENR_IOPFEN_Msk  = 0x400000  // Bit mask of IOPFEN field.
	RCC_AHBENR_IOPFEN      = 0x400000  // Bit IOPFEN.
	RCC_AHBENR_TSCEN_Pos   = 0x18      // Position of TSCEN field.
	RCC_AHBENR_TSCEN_Msk   = 0x1000000 // Bit mask of TSCEN field.
	RCC_AHBENR_TSCEN       = 0x1000000 // Bit TSCEN.

	// APB2ENR: APB2 peripheral clock enable register           (RCC_APB2ENR)
	RCC_APB2ENR_SYSCFGEN_Pos = 0x0      // Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x1      // Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN     = 0x1      // Bit SYSCFGEN.
	RCC_APB2ENR_ADCEN_Pos    = 0x9      // Position of ADCEN field.
	RCC_APB2ENR_ADCEN_Msk    = 0x200    // Bit mask of ADCEN field.
	RCC_APB2ENR_ADCEN        = 0x200    // Bit ADCEN.
	RCC_APB2ENR_TIM1EN_Pos   = 0xb      // Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk   = 0x800    // Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN       = 0x800    // Bit TIM1EN.
	RCC_APB2ENR_SPI1EN_Pos   = 0xc      // Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk   = 0x1000   // Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN       = 0x1000   // Bit SPI1EN.
	RCC_APB2ENR_USART1EN_Pos = 0xe      // Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000   // Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN     = 0x4000   // Bit USART1EN.
	RCC_APB2ENR_TIM15EN_Pos  = 0x10     // Position of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Msk  = 0x10000  // Bit mask of TIM15EN field.
	RCC_APB2ENR_TIM15EN      = 0x10000  // Bit TIM15EN.
	RCC_APB2ENR_TIM16EN_Pos  = 0x11     // Position of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Msk  = 0x20000  // Bit mask of TIM16EN field.
	RCC_APB2ENR_TIM16EN      = 0x20000  // Bit TIM16EN.
	RCC_APB2ENR_TIM17EN_Pos  = 0x12     // Position of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Msk  = 0x40000  // Bit mask of TIM17EN field.
	RCC_APB2ENR_TIM17EN      = 0x40000  // Bit TIM17EN.
	RCC_APB2ENR_DBGMCUEN_Pos = 0x16     // Position of DBGMCUEN field.
	RCC_APB2ENR_DBGMCUEN_Msk = 0x400000 // Bit mask of DBGMCUEN field.
	RCC_APB2ENR_DBGMCUEN     = 0x400000 // Bit DBGMCUEN.

	// APB1ENR: APB1 peripheral clock enable register           (RCC_APB1ENR)
	RCC_APB1ENR_TIM2EN_Pos   = 0x0        // Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk   = 0x1        // Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN       = 0x1        // Bit TIM2EN.
	RCC_APB1ENR_TIM3EN_Pos   = 0x1        // Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk   = 0x2        // Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN       = 0x2        // Bit TIM3EN.
	RCC_APB1ENR_TIM6EN_Pos   = 0x4        // Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk   = 0x10       // Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN       = 0x10       // Bit TIM6EN.
	RCC_APB1ENR_TIM7EN_Pos   = 0x5        // Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk   = 0x20       // Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN       = 0x20       // Bit TIM7EN.
	RCC_APB1ENR_TIM14EN_Pos  = 0x8        // Position of TIM14EN field.
	RCC_APB1ENR_TIM14EN_Msk  = 0x100      // Bit mask of TIM14EN field.
	RCC_APB1ENR_TIM14EN      = 0x100      // Bit TIM14EN.
	RCC_APB1ENR_WWDGEN_Pos   = 0xb        // Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk   = 0x800      // Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN       = 0x800      // Bit WWDGEN.
	RCC_APB1ENR_SPI2EN_Pos   = 0xe        // Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk   = 0x4000     // Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN       = 0x4000     // Bit SPI2EN.
	RCC_APB1ENR_USART2EN_Pos = 0x11       // Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000    // Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN     = 0x20000    // Bit USART2EN.
	RCC_APB1ENR_USART3EN_Pos = 0x12       // Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk = 0x40000    // Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN     = 0x40000    // Bit USART3EN.
	RCC_APB1ENR_USART4EN_Pos = 0x13       // Position of USART4EN field.
	RCC_APB1ENR_USART4EN_Msk = 0x80000    // Bit mask of USART4EN field.
	RCC_APB1ENR_USART4EN     = 0x80000    // Bit USART4EN.
	RCC_APB1ENR_I2C1EN_Pos   = 0x15       // Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk   = 0x200000   // Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN       = 0x200000   // Bit I2C1EN.
	RCC_APB1ENR_I2C2EN_Pos   = 0x16       // Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk   = 0x400000   // Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN       = 0x400000   // Bit I2C2EN.
	RCC_APB1ENR_USBRST_Pos   = 0x17       // Position of USBRST field.
	RCC_APB1ENR_USBRST_Msk   = 0x800000   // Bit mask of USBRST field.
	RCC_APB1ENR_USBRST       = 0x800000   // Bit USBRST.
	RCC_APB1ENR_CANEN_Pos    = 0x19       // Position of CANEN field.
	RCC_APB1ENR_CANEN_Msk    = 0x2000000  // Bit mask of CANEN field.
	RCC_APB1ENR_CANEN        = 0x2000000  // Bit CANEN.
	RCC_APB1ENR_CRSEN_Pos    = 0x1b       // Position of CRSEN field.
	RCC_APB1ENR_CRSEN_Msk    = 0x8000000  // Bit mask of CRSEN field.
	RCC_APB1ENR_CRSEN        = 0x8000000  // Bit CRSEN.
	RCC_APB1ENR_PWREN_Pos    = 0x1c       // Position of PWREN field.
	RCC_APB1ENR_PWREN_Msk    = 0x10000000 // Bit mask of PWREN field.
	RCC_APB1ENR_PWREN        = 0x10000000 // Bit PWREN.
	RCC_APB1ENR_DACEN_Pos    = 0x1d       // Position of DACEN field.
	RCC_APB1ENR_DACEN_Msk    = 0x20000000 // Bit mask of DACEN field.
	RCC_APB1ENR_DACEN        = 0x20000000 // Bit DACEN.
	RCC_APB1ENR_CECEN_Pos    = 0x1e       // Position of CECEN field.
	RCC_APB1ENR_CECEN_Msk    = 0x40000000 // Bit mask of CECEN field.
	RCC_APB1ENR_CECEN        = 0x40000000 // Bit CECEN.

	// BDCR: Backup domain control register           (RCC_BDCR)
	RCC_BDCR_LSEON_Pos  = 0x0     // Position of LSEON field.
	RCC_BDCR_LSEON_Msk  = 0x1     // Bit mask of LSEON field.
	RCC_BDCR_LSEON      = 0x1     // Bit LSEON.
	RCC_BDCR_LSERDY_Pos = 0x1     // Position of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2     // Bit mask of LSERDY field.
	RCC_BDCR_LSERDY     = 0x2     // Bit LSERDY.
	RCC_BDCR_LSEBYP_Pos = 0x2     // Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4     // Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP     = 0x4     // Bit LSEBYP.
	RCC_BDCR_LSEDRV_Pos = 0x3     // Position of LSEDRV field.
	RCC_BDCR_LSEDRV_Msk = 0x18    // Bit mask of LSEDRV field.
	RCC_BDCR_RTCSEL_Pos = 0x8     // Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300   // Bit mask of RTCSEL field.
	RCC_BDCR_RTCEN_Pos  = 0xf     // Position of RTCEN field.
	RCC_BDCR_RTCEN_Msk  = 0x8000  // Bit mask of RTCEN field.
	RCC_BDCR_RTCEN      = 0x8000  // Bit RTCEN.
	RCC_BDCR_BDRST_Pos  = 0x10    // Position of BDRST field.
	RCC_BDCR_BDRST_Msk  = 0x10000 // Bit mask of BDRST field.
	RCC_BDCR_BDRST      = 0x10000 // Bit BDRST.

	// CSR: Control/status register           (RCC_CSR)
	RCC_CSR_LSION_Pos    = 0x0        // Position of LSION field.
	RCC_CSR_LSION_Msk    = 0x1        // Bit mask of LSION field.
	RCC_CSR_LSION        = 0x1        // Bit LSION.
	RCC_CSR_LSIRDY_Pos   = 0x1        // Position of LSIRDY field.
	RCC_CSR_LSIRDY_Msk   = 0x2        // Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY       = 0x2        // Bit LSIRDY.
	RCC_CSR_RMVF_Pos     = 0x18       // Position of RMVF field.
	RCC_CSR_RMVF_Msk     = 0x1000000  // Bit mask of RMVF field.
	RCC_CSR_RMVF         = 0x1000000  // Bit RMVF.
	RCC_CSR_OBLRSTF_Pos  = 0x19       // Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk  = 0x2000000  // Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF      = 0x2000000  // Bit OBLRSTF.
	RCC_CSR_PINRSTF_Pos  = 0x1a       // Position of PINRSTF field.
	RCC_CSR_PINRSTF_Msk  = 0x4000000  // Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF      = 0x4000000  // Bit PINRSTF.
	RCC_CSR_PORRSTF_Pos  = 0x1b       // Position of PORRSTF field.
	RCC_CSR_PORRSTF_Msk  = 0x8000000  // Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF      = 0x8000000  // Bit PORRSTF.
	RCC_CSR_SFTRSTF_Pos  = 0x1c       // Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk  = 0x10000000 // Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF      = 0x10000000 // Bit SFTRSTF.
	RCC_CSR_IWDGRSTF_Pos = 0x1d       // Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000 // Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF     = 0x20000000 // Bit IWDGRSTF.
	RCC_CSR_WWDGRSTF_Pos = 0x1e       // Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000 // Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF     = 0x40000000 // Bit WWDGRSTF.
	RCC_CSR_LPWRRSTF_Pos = 0x1f       // Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000 // Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF     = 0x80000000 // Bit LPWRRSTF.

	// AHBRSTR: AHB peripheral reset register
	RCC_AHBRSTR_IOPARST_Pos = 0x11      // Position of IOPARST field.
	RCC_AHBRSTR_IOPARST_Msk = 0x20000   // Bit mask of IOPARST field.
	RCC_AHBRSTR_IOPARST     = 0x20000   // Bit IOPARST.
	RCC_AHBRSTR_IOPBRST_Pos = 0x12      // Position of IOPBRST field.
	RCC_AHBRSTR_IOPBRST_Msk = 0x40000   // Bit mask of IOPBRST field.
	RCC_AHBRSTR_IOPBRST     = 0x40000   // Bit IOPBRST.
	RCC_AHBRSTR_IOPCRST_Pos = 0x13      // Position of IOPCRST field.
	RCC_AHBRSTR_IOPCRST_Msk = 0x80000   // Bit mask of IOPCRST field.
	RCC_AHBRSTR_IOPCRST     = 0x80000   // Bit IOPCRST.
	RCC_AHBRSTR_IOPDRST_Pos = 0x14      // Position of IOPDRST field.
	RCC_AHBRSTR_IOPDRST_Msk = 0x100000  // Bit mask of IOPDRST field.
	RCC_AHBRSTR_IOPDRST     = 0x100000  // Bit IOPDRST.
	RCC_AHBRSTR_IOPFRST_Pos = 0x16      // Position of IOPFRST field.
	RCC_AHBRSTR_IOPFRST_Msk = 0x400000  // Bit mask of IOPFRST field.
	RCC_AHBRSTR_IOPFRST     = 0x400000  // Bit IOPFRST.
	RCC_AHBRSTR_TSCRST_Pos  = 0x18      // Position of TSCRST field.
	RCC_AHBRSTR_TSCRST_Msk  = 0x1000000 // Bit mask of TSCRST field.
	RCC_AHBRSTR_TSCRST      = 0x1000000 // Bit TSCRST.

	// CFGR2: Clock configuration register 2
	RCC_CFGR2_PREDIV_Pos = 0x0 // Position of PREDIV field.
	RCC_CFGR2_PREDIV_Msk = 0xf // Bit mask of PREDIV field.

	// CFGR3: Clock configuration register 3
	RCC_CFGR3_USART1SW_Pos = 0x0     // Position of USART1SW field.
	RCC_CFGR3_USART1SW_Msk = 0x3     // Bit mask of USART1SW field.
	RCC_CFGR3_I2C1SW_Pos   = 0x4     // Position of I2C1SW field.
	RCC_CFGR3_I2C1SW_Msk   = 0x10    // Bit mask of I2C1SW field.
	RCC_CFGR3_I2C1SW       = 0x10    // Bit I2C1SW.
	RCC_CFGR3_CECSW_Pos    = 0x6     // Position of CECSW field.
	RCC_CFGR3_CECSW_Msk    = 0x40    // Bit mask of CECSW field.
	RCC_CFGR3_CECSW        = 0x40    // Bit CECSW.
	RCC_CFGR3_USBSW_Pos    = 0x7     // Position of USBSW field.
	RCC_CFGR3_USBSW_Msk    = 0x80    // Bit mask of USBSW field.
	RCC_CFGR3_USBSW        = 0x80    // Bit USBSW.
	RCC_CFGR3_ADCSW_Pos    = 0x8     // Position of ADCSW field.
	RCC_CFGR3_ADCSW_Msk    = 0x100   // Bit mask of ADCSW field.
	RCC_CFGR3_ADCSW        = 0x100   // Bit ADCSW.
	RCC_CFGR3_USART2SW_Pos = 0x10    // Position of USART2SW field.
	RCC_CFGR3_USART2SW_Msk = 0x30000 // Bit mask of USART2SW field.

	// CR2: Clock control register 2
	RCC_CR2_HSI14ON_Pos   = 0x0       // Position of HSI14ON field.
	RCC_CR2_HSI14ON_Msk   = 0x1       // Bit mask of HSI14ON field.
	RCC_CR2_HSI14ON       = 0x1       // Bit HSI14ON.
	RCC_CR2_HSI14RDY_Pos  = 0x1       // Position of HSI14RDY field.
	RCC_CR2_HSI14RDY_Msk  = 0x2       // Bit mask of HSI14RDY field.
	RCC_CR2_HSI14RDY      = 0x2       // Bit HSI14RDY.
	RCC_CR2_HSI14DIS_Pos  = 0x2       // Position of HSI14DIS field.
	RCC_CR2_HSI14DIS_Msk  = 0x4       // Bit mask of HSI14DIS field.
	RCC_CR2_HSI14DIS      = 0x4       // Bit HSI14DIS.
	RCC_CR2_HSI14TRIM_Pos = 0x3       // Position of HSI14TRIM field.
	RCC_CR2_HSI14TRIM_Msk = 0xf8      // Bit mask of HSI14TRIM field.
	RCC_CR2_HSI14CAL_Pos  = 0x8       // Position of HSI14CAL field.
	RCC_CR2_HSI14CAL_Msk  = 0xff00    // Bit mask of HSI14CAL field.
	RCC_CR2_HSI48ON_Pos   = 0x10      // Position of HSI48ON field.
	RCC_CR2_HSI48ON_Msk   = 0x10000   // Bit mask of HSI48ON field.
	RCC_CR2_HSI48ON       = 0x10000   // Bit HSI48ON.
	RCC_CR2_HSI48RDY_Pos  = 0x11      // Position of HSI48RDY field.
	RCC_CR2_HSI48RDY_Msk  = 0x20000   // Bit mask of HSI48RDY field.
	RCC_CR2_HSI48RDY      = 0x20000   // Bit HSI48RDY.
	RCC_CR2_HSI48CAL_Pos  = 0x18      // Position of HSI48CAL field.
	RCC_CR2_HSI48CAL_Msk  = 0x1000000 // Bit mask of HSI48CAL field.
	RCC_CR2_HSI48CAL      = 0x1000000 // Bit HSI48CAL.
)

// Bitfields for SYSCFG: System configuration controller
const (
	// CFGR1: configuration register 1
	SYSCFG_CFGR1_MEM_MODE_Pos          = 0x0        // Position of MEM_MODE field.
	SYSCFG_CFGR1_MEM_MODE_Msk          = 0x3        // Bit mask of MEM_MODE field.
	SYSCFG_CFGR1_ADC_DMA_RMP_Pos       = 0x8        // Position of ADC_DMA_RMP field.
	SYSCFG_CFGR1_ADC_DMA_RMP_Msk       = 0x100      // Bit mask of ADC_DMA_RMP field.
	SYSCFG_CFGR1_ADC_DMA_RMP           = 0x100      // Bit ADC_DMA_RMP.
	SYSCFG_CFGR1_USART1_TX_DMA_RMP_Pos = 0x9        // Position of USART1_TX_DMA_RMP field.
	SYSCFG_CFGR1_USART1_TX_DMA_RMP_Msk = 0x200      // Bit mask of USART1_TX_DMA_RMP field.
	SYSCFG_CFGR1_USART1_TX_DMA_RMP     = 0x200      // Bit USART1_TX_DMA_RMP.
	SYSCFG_CFGR1_USART1_RX_DMA_RMP_Pos = 0xa        // Position of USART1_RX_DMA_RMP field.
	SYSCFG_CFGR1_USART1_RX_DMA_RMP_Msk = 0x400      // Bit mask of USART1_RX_DMA_RMP field.
	SYSCFG_CFGR1_USART1_RX_DMA_RMP     = 0x400      // Bit USART1_RX_DMA_RMP.
	SYSCFG_CFGR1_TIM16_DMA_RMP_Pos     = 0xb        // Position of TIM16_DMA_RMP field.
	SYSCFG_CFGR1_TIM16_DMA_RMP_Msk     = 0x800      // Bit mask of TIM16_DMA_RMP field.
	SYSCFG_CFGR1_TIM16_DMA_RMP         = 0x800      // Bit TIM16_DMA_RMP.
	SYSCFG_CFGR1_TIM17_DMA_RMP_Pos     = 0xc        // Position of TIM17_DMA_RMP field.
	SYSCFG_CFGR1_TIM17_DMA_RMP_Msk     = 0x1000     // Bit mask of TIM17_DMA_RMP field.
	SYSCFG_CFGR1_TIM17_DMA_RMP         = 0x1000     // Bit TIM17_DMA_RMP.
	SYSCFG_CFGR1_I2C_PB6_FM_Pos        = 0x10       // Position of I2C_PB6_FM field.
	SYSCFG_CFGR1_I2C_PB6_FM_Msk        = 0x10000    // Bit mask of I2C_PB6_FM field.
	SYSCFG_CFGR1_I2C_PB6_FM            = 0x10000    // Bit I2C_PB6_FM.
	SYSCFG_CFGR1_I2C_PB7_FM_Pos        = 0x11       // Position of I2C_PB7_FM field.
	SYSCFG_CFGR1_I2C_PB7_FM_Msk        = 0x20000    // Bit mask of I2C_PB7_FM field.
	SYSCFG_CFGR1_I2C_PB7_FM            = 0x20000    // Bit I2C_PB7_FM.
	SYSCFG_CFGR1_I2C_PB8_FM_Pos        = 0x12       // Position of I2C_PB8_FM field.
	SYSCFG_CFGR1_I2C_PB8_FM_Msk        = 0x40000    // Bit mask of I2C_PB8_FM field.
	SYSCFG_CFGR1_I2C_PB8_FM            = 0x40000    // Bit I2C_PB8_FM.
	SYSCFG_CFGR1_I2C_PB9_FM_Pos        = 0x13       // Position of I2C_PB9_FM field.
	SYSCFG_CFGR1_I2C_PB9_FM_Msk        = 0x80000    // Bit mask of I2C_PB9_FM field.
	SYSCFG_CFGR1_I2C_PB9_FM            = 0x80000    // Bit I2C_PB9_FM.
	SYSCFG_CFGR1_I2C1_FM_plus_Pos      = 0x14       // Position of I2C1_FM_plus field.
	SYSCFG_CFGR1_I2C1_FM_plus_Msk      = 0x100000   // Bit mask of I2C1_FM_plus field.
	SYSCFG_CFGR1_I2C1_FM_plus          = 0x100000   // Bit I2C1_FM_plus.
	SYSCFG_CFGR1_I2C2_FM_plus_Pos      = 0x15       // Position of I2C2_FM_plus field.
	SYSCFG_CFGR1_I2C2_FM_plus_Msk      = 0x200000   // Bit mask of I2C2_FM_plus field.
	SYSCFG_CFGR1_I2C2_FM_plus          = 0x200000   // Bit I2C2_FM_plus.
	SYSCFG_CFGR1_SPI2_DMA_RMP_Pos      = 0x18       // Position of SPI2_DMA_RMP field.
	SYSCFG_CFGR1_SPI2_DMA_RMP_Msk      = 0x1000000  // Bit mask of SPI2_DMA_RMP field.
	SYSCFG_CFGR1_SPI2_DMA_RMP          = 0x1000000  // Bit SPI2_DMA_RMP.
	SYSCFG_CFGR1_USART2_DMA_RMP_Pos    = 0x19       // Position of USART2_DMA_RMP field.
	SYSCFG_CFGR1_USART2_DMA_RMP_Msk    = 0x2000000  // Bit mask of USART2_DMA_RMP field.
	SYSCFG_CFGR1_USART2_DMA_RMP        = 0x2000000  // Bit USART2_DMA_RMP.
	SYSCFG_CFGR1_USART3_DMA_RMP_Pos    = 0x1a       // Position of USART3_DMA_RMP field.
	SYSCFG_CFGR1_USART3_DMA_RMP_Msk    = 0x4000000  // Bit mask of USART3_DMA_RMP field.
	SYSCFG_CFGR1_USART3_DMA_RMP        = 0x4000000  // Bit USART3_DMA_RMP.
	SYSCFG_CFGR1_I2C1_DMA_RMP_Pos      = 0x1b       // Position of I2C1_DMA_RMP field.
	SYSCFG_CFGR1_I2C1_DMA_RMP_Msk      = 0x8000000  // Bit mask of I2C1_DMA_RMP field.
	SYSCFG_CFGR1_I2C1_DMA_RMP          = 0x8000000  // Bit I2C1_DMA_RMP.
	SYSCFG_CFGR1_TIM1_DMA_RMP_Pos      = 0x1c       // Position of TIM1_DMA_RMP field.
	SYSCFG_CFGR1_TIM1_DMA_RMP_Msk      = 0x10000000 // Bit mask of TIM1_DMA_RMP field.
	SYSCFG_CFGR1_TIM1_DMA_RMP          = 0x10000000 // Bit TIM1_DMA_RMP.
	SYSCFG_CFGR1_TIM2_DMA_RMP_Pos      = 0x1d       // Position of TIM2_DMA_RMP field.
	SYSCFG_CFGR1_TIM2_DMA_RMP_Msk      = 0x20000000 // Bit mask of TIM2_DMA_RMP field.
	SYSCFG_CFGR1_TIM2_DMA_RMP          = 0x20000000 // Bit TIM2_DMA_RMP.
	SYSCFG_CFGR1_TIM3_DMA_RMP_Pos      = 0x1e       // Position of TIM3_DMA_RMP field.
	SYSCFG_CFGR1_TIM3_DMA_RMP_Msk      = 0x40000000 // Bit mask of TIM3_DMA_RMP field.
	SYSCFG_CFGR1_TIM3_DMA_RMP          = 0x40000000 // Bit TIM3_DMA_RMP.

	// EXTICR1: external interrupt configuration register           1
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc    // Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000 // Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8    // Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00  // Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4    // Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0   // Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0    // Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf    // Bit mask of EXTI0 field.

	// EXTICR2: external interrupt configuration register           2
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc    // Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000 // Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8    // Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00  // Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4    // Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0   // Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0    // Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf    // Bit mask of EXTI4 field.

	// EXTICR3: external interrupt configuration register           3
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc    // Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000 // Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8    // Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00  // Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI9_Pos  = 0x4    // Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk  = 0xf0   // Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI8_Pos  = 0x0    // Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk  = 0xf    // Bit mask of EXTI8 field.

	// EXTICR4: external interrupt configuration register           4
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc    // Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000 // Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8    // Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00  // Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4    // Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0   // Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0    // Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf    // Bit mask of EXTI12 field.

	// CFGR2: configuration register 2
	SYSCFG_CFGR2_SRAM_PEF_Pos         = 0x8   // Position of SRAM_PEF field.
	SYSCFG_CFGR2_SRAM_PEF_Msk         = 0x100 // Bit mask of SRAM_PEF field.
	SYSCFG_CFGR2_SRAM_PEF             = 0x100 // Bit SRAM_PEF.
	SYSCFG_CFGR2_PVD_LOCK_Pos         = 0x2   // Position of PVD_LOCK field.
	SYSCFG_CFGR2_PVD_LOCK_Msk         = 0x4   // Bit mask of PVD_LOCK field.
	SYSCFG_CFGR2_PVD_LOCK             = 0x4   // Bit PVD_LOCK.
	SYSCFG_CFGR2_SRAM_PARITY_LOCK_Pos = 0x1   // Position of SRAM_PARITY_LOCK field.
	SYSCFG_CFGR2_SRAM_PARITY_LOCK_Msk = 0x2   // Bit mask of SRAM_PARITY_LOCK field.
	SYSCFG_CFGR2_SRAM_PARITY_LOCK     = 0x2   // Bit SRAM_PARITY_LOCK.
	SYSCFG_CFGR2_LOCUP_LOCK_Pos       = 0x0   // Position of LOCUP_LOCK field.
	SYSCFG_CFGR2_LOCUP_LOCK_Msk       = 0x1   // Bit mask of LOCUP_LOCK field.
	SYSCFG_CFGR2_LOCUP_LOCK           = 0x1   // Bit LOCUP_LOCK.
)

// Bitfields for ADC: Analog-to-digital converter
const (
	// ISR: interrupt and status register
	ADC_ISR_AWD_Pos   = 0x7  // Position of AWD field.
	ADC_ISR_AWD_Msk   = 0x80 // Bit mask of AWD field.
	ADC_ISR_AWD       = 0x80 // Bit AWD.
	ADC_ISR_OVR_Pos   = 0x4  // Position of OVR field.
	ADC_ISR_OVR_Msk   = 0x10 // Bit mask of OVR field.
	ADC_ISR_OVR       = 0x10 // Bit OVR.
	ADC_ISR_EOS_Pos   = 0x3  // Position of EOS field.
	ADC_ISR_EOS_Msk   = 0x8  // Bit mask of EOS field.
	ADC_ISR_EOS       = 0x8  // Bit EOS.
	ADC_ISR_EOC_Pos   = 0x2  // Position of EOC field.
	ADC_ISR_EOC_Msk   = 0x4  // Bit mask of EOC field.
	ADC_ISR_EOC       = 0x4  // Bit EOC.
	ADC_ISR_EOSMP_Pos = 0x1  // Position of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2  // Bit mask of EOSMP field.
	ADC_ISR_EOSMP     = 0x2  // Bit EOSMP.
	ADC_ISR_ADRDY_Pos = 0x0  // Position of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1  // Bit mask of ADRDY field.
	ADC_ISR_ADRDY     = 0x1  // Bit ADRDY.

	// IER: interrupt enable register
	ADC_IER_AWDIE_Pos   = 0x7  // Position of AWDIE field.
	ADC_IER_AWDIE_Msk   = 0x80 // Bit mask of AWDIE field.
	ADC_IER_AWDIE       = 0x80 // Bit AWDIE.
	ADC_IER_OVRIE_Pos   = 0x4  // Position of OVRIE field.
	ADC_IER_OVRIE_Msk   = 0x10 // Bit mask of OVRIE field.
	ADC_IER_OVRIE       = 0x10 // Bit OVRIE.
	ADC_IER_EOSIE_Pos   = 0x3  // Position of EOSIE field.
	ADC_IER_EOSIE_Msk   = 0x8  // Bit mask of EOSIE field.
	ADC_IER_EOSIE       = 0x8  // Bit EOSIE.
	ADC_IER_EOCIE_Pos   = 0x2  // Position of EOCIE field.
	ADC_IER_EOCIE_Msk   = 0x4  // Bit mask of EOCIE field.
	ADC_IER_EOCIE       = 0x4  // Bit EOCIE.
	ADC_IER_EOSMPIE_Pos = 0x1  // Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2  // Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE     = 0x2  // Bit EOSMPIE.
	ADC_IER_ADRDYIE_Pos = 0x0  // Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1  // Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE     = 0x1  // Bit ADRDYIE.

	// CR: control register
	ADC_CR_ADCAL_Pos   = 0x1f       // Position of ADCAL field.
	ADC_CR_ADCAL_Msk   = 0x80000000 // Bit mask of ADCAL field.
	ADC_CR_ADCAL       = 0x80000000 // Bit ADCAL.
	ADC_CR_ADSTP_Pos   = 0x4        // Position of ADSTP field.
	ADC_CR_ADSTP_Msk   = 0x10       // Bit mask of ADSTP field.
	ADC_CR_ADSTP       = 0x10       // Bit ADSTP.
	ADC_CR_ADSTART_Pos = 0x2        // Position of ADSTART field.
	ADC_CR_ADSTART_Msk = 0x4        // Bit mask of ADSTART field.
	ADC_CR_ADSTART     = 0x4        // Bit ADSTART.
	ADC_CR_ADDIS_Pos   = 0x1        // Position of ADDIS field.
	ADC_CR_ADDIS_Msk   = 0x2        // Bit mask of ADDIS field.
	ADC_CR_ADDIS       = 0x2        // Bit ADDIS.
	ADC_CR_ADEN_Pos    = 0x0        // Position of ADEN field.
	ADC_CR_ADEN_Msk    = 0x1        // Bit mask of ADEN field.
	ADC_CR_ADEN        = 0x1        // Bit ADEN.

	// CFGR1: configuration register 1
	ADC_CFGR1_AWDCH_Pos   = 0x1a       // Position of AWDCH field.
	ADC_CFGR1_AWDCH_Msk   = 0x7c000000 // Bit mask of AWDCH field.
	ADC_CFGR1_AWDEN_Pos   = 0x17       // Position of AWDEN field.
	ADC_CFGR1_AWDEN_Msk   = 0x800000   // Bit mask of AWDEN field.
	ADC_CFGR1_AWDEN       = 0x800000   // Bit AWDEN.
	ADC_CFGR1_AWDSGL_Pos  = 0x16       // Position of AWDSGL field.
	ADC_CFGR1_AWDSGL_Msk  = 0x400000   // Bit mask of AWDSGL field.
	ADC_CFGR1_AWDSGL      = 0x400000   // Bit AWDSGL.
	ADC_CFGR1_DISCEN_Pos  = 0x10       // Position of DISCEN field.
	ADC_CFGR1_DISCEN_Msk  = 0x10000    // Bit mask of DISCEN field.
	ADC_CFGR1_DISCEN      = 0x10000    // Bit DISCEN.
	ADC_CFGR1_AUTOFF_Pos  = 0xf        // Position of AUTOFF field.
	ADC_CFGR1_AUTOFF_Msk  = 0x8000     // Bit mask of AUTOFF field.
	ADC_CFGR1_AUTOFF      = 0x8000     // Bit AUTOFF.
	ADC_CFGR1_AUTDLY_Pos  = 0xe        // Position of AUTDLY field.
	ADC_CFGR1_AUTDLY_Msk  = 0x4000     // Bit mask of AUTDLY field.
	ADC_CFGR1_AUTDLY      = 0x4000     // Bit AUTDLY.
	ADC_CFGR1_CONT_Pos    = 0xd        // Position of CONT field.
	ADC_CFGR1_CONT_Msk    = 0x2000     // Bit mask of CONT field.
	ADC_CFGR1_CONT        = 0x2000     // Bit CONT.
	ADC_CFGR1_OVRMOD_Pos  = 0xc        // Position of OVRMOD field.
	ADC_CFGR1_OVRMOD_Msk  = 0x1000     // Bit mask of OVRMOD field.
	ADC_CFGR1_OVRMOD      = 0x1000     // Bit OVRMOD.
	ADC_CFGR1_EXTEN_Pos   = 0xa        // Position of EXTEN field.
	ADC_CFGR1_EXTEN_Msk   = 0xc00      // Bit mask of EXTEN field.
	ADC_CFGR1_EXTSEL_Pos  = 0x6        // Position of EXTSEL field.
	ADC_CFGR1_EXTSEL_Msk  = 0x1c0      // Bit mask of EXTSEL field.
	ADC_CFGR1_ALIGN_Pos   = 0x5        // Position of ALIGN field.
	ADC_CFGR1_ALIGN_Msk   = 0x20       // Bit mask of ALIGN field.
	ADC_CFGR1_ALIGN       = 0x20       // Bit ALIGN.
	ADC_CFGR1_RES_Pos     = 0x3        // Position of RES field.
	ADC_CFGR1_RES_Msk     = 0x18       // Bit mask of RES field.
	ADC_CFGR1_SCANDIR_Pos = 0x2        // Position of SCANDIR field.
	ADC_CFGR1_SCANDIR_Msk = 0x4        // Bit mask of SCANDIR field.
	ADC_CFGR1_SCANDIR     = 0x4        // Bit SCANDIR.
	ADC_CFGR1_DMACFG_Pos  = 0x1        // Position of DMACFG field.
	ADC_CFGR1_DMACFG_Msk  = 0x2        // Bit mask of DMACFG field.
	ADC_CFGR1_DMACFG      = 0x2        // Bit DMACFG.
	ADC_CFGR1_DMAEN_Pos   = 0x0        // Position of DMAEN field.
	ADC_CFGR1_DMAEN_Msk   = 0x1        // Bit mask of DMAEN field.
	ADC_CFGR1_DMAEN       = 0x1        // Bit DMAEN.

	// CFGR2: configuration register 2
	ADC_CFGR2_JITOFF_D4_Pos = 0x1f       // Position of JITOFF_D4 field.
	ADC_CFGR2_JITOFF_D4_Msk = 0x80000000 // Bit mask of JITOFF_D4 field.
	ADC_CFGR2_JITOFF_D4     = 0x80000000 // Bit JITOFF_D4.
	ADC_CFGR2_JITOFF_D2_Pos = 0x1e       // Position of JITOFF_D2 field.
	ADC_CFGR2_JITOFF_D2_Msk = 0x40000000 // Bit mask of JITOFF_D2 field.
	ADC_CFGR2_JITOFF_D2     = 0x40000000 // Bit JITOFF_D2.

	// SMPR: sampling time register
	ADC_SMPR_SMPR_Pos = 0x0 // Position of SMPR field.
	ADC_SMPR_SMPR_Msk = 0x7 // Bit mask of SMPR field.

	// TR: watchdog threshold register
	ADC_TR_HT_Pos = 0x10      // Position of HT field.
	ADC_TR_HT_Msk = 0xfff0000 // Bit mask of HT field.
	ADC_TR_LT_Pos = 0x0       // Position of LT field.
	ADC_TR_LT_Msk = 0xfff     // Bit mask of LT field.

	// CHSELR: channel selection register
	ADC_CHSELR_CHSEL18_Pos = 0x12    // Position of CHSEL18 field.
	ADC_CHSELR_CHSEL18_Msk = 0x40000 // Bit mask of CHSEL18 field.
	ADC_CHSELR_CHSEL18     = 0x40000 // Bit CHSEL18.
	ADC_CHSELR_CHSEL17_Pos = 0x11    // Position of CHSEL17 field.
	ADC_CHSELR_CHSEL17_Msk = 0x20000 // Bit mask of CHSEL17 field.
	ADC_CHSELR_CHSEL17     = 0x20000 // Bit CHSEL17.
	ADC_CHSELR_CHSEL16_Pos = 0x10    // Position of CHSEL16 field.
	ADC_CHSELR_CHSEL16_Msk = 0x10000 // Bit mask of CHSEL16 field.
	ADC_CHSELR_CHSEL16     = 0x10000 // Bit CHSEL16.
	ADC_CHSELR_CHSEL15_Pos = 0xf     // Position of CHSEL15 field.
	ADC_CHSELR_CHSEL15_Msk = 0x8000  // Bit mask of CHSEL15 field.
	ADC_CHSELR_CHSEL15     = 0x8000  // Bit CHSEL15.
	ADC_CHSELR_CHSEL14_Pos = 0xe     // Position of CHSEL14 field.
	ADC_CHSELR_CHSEL14_Msk = 0x4000  // Bit mask of CHSEL14 field.
	ADC_CHSELR_CHSEL14     = 0x4000  // Bit CHSEL14.
	ADC_CHSELR_CHSEL13_Pos = 0xd     // Position of CHSEL13 field.
	ADC_CHSELR_CHSEL13_Msk = 0x2000  // Bit mask of CHSEL13 field.
	ADC_CHSELR_CHSEL13     = 0x2000  // Bit CHSEL13.
	ADC_CHSELR_CHSEL12_Pos = 0xc     // Position of CHSEL12 field.
	ADC_CHSELR_CHSEL12_Msk = 0x1000  // Bit mask of CHSEL12 field.
	ADC_CHSELR_CHSEL12     = 0x1000  // Bit CHSEL12.
	ADC_CHSELR_CHSEL11_Pos = 0xb     // Position of CHSEL11 field.
	ADC_CHSELR_CHSEL11_Msk = 0x800   // Bit mask of CHSEL11 field.
	ADC_CHSELR_CHSEL11     = 0x800   // Bit CHSEL11.
	ADC_CHSELR_CHSEL10_Pos = 0xa     // Position of CHSEL10 field.
	ADC_CHSELR_CHSEL10_Msk = 0x400   // Bit mask of CHSEL10 field.
	ADC_CHSELR_CHSEL10     = 0x400   // Bit CHSEL10.
	ADC_CHSELR_CHSEL9_Pos  = 0x9     // Position of CHSEL9 field.
	ADC_CHSELR_CHSEL9_Msk  = 0x200   // Bit mask of CHSEL9 field.
	ADC_CHSELR_CHSEL9      = 0x200   // Bit CHSEL9.
	ADC_CHSELR_CHSEL8_Pos  = 0x8     // Position of CHSEL8 field.
	ADC_CHSELR_CHSEL8_Msk  = 0x100   // Bit mask of CHSEL8 field.
	ADC_CHSELR_CHSEL8      = 0x100   // Bit CHSEL8.
	ADC_CHSELR_CHSEL7_Pos  = 0x7     // Position of CHSEL7 field.
	ADC_CHSELR_CHSEL7_Msk  = 0x80    // Bit mask of CHSEL7 field.
	ADC_CHSELR_CHSEL7      = 0x80    // Bit CHSEL7.
	ADC_CHSELR_CHSEL6_Pos  = 0x6     // Position of CHSEL6 field.
	ADC_CHSELR_CHSEL6_Msk  = 0x40    // Bit mask of CHSEL6 field.
	ADC_CHSELR_CHSEL6      = 0x40    // Bit CHSEL6.
	ADC_CHSELR_CHSEL5_Pos  = 0x5     // Position of CHSEL5 field.
	ADC_CHSELR_CHSEL5_Msk  = 0x20    // Bit mask of CHSEL5 field.
	ADC_CHSELR_CHSEL5      = 0x20    // Bit CHSEL5.
	ADC_CHSELR_CHSEL4_Pos  = 0x4     // Position of CHSEL4 field.
	ADC_CHSELR_CHSEL4_Msk  = 0x10    // Bit mask of CHSEL4 field.
	ADC_CHSELR_CHSEL4      = 0x10    // Bit CHSEL4.
	ADC_CHSELR_CHSEL3_Pos  = 0x3     // Position of CHSEL3 field.
	ADC_CHSELR_CHSEL3_Msk  = 0x8     // Bit mask of CHSEL3 field.
	ADC_CHSELR_CHSEL3      = 0x8     // Bit CHSEL3.
	ADC_CHSELR_CHSEL2_Pos  = 0x2     // Position of CHSEL2 field.
	ADC_CHSELR_CHSEL2_Msk  = 0x4     // Bit mask of CHSEL2 field.
	ADC_CHSELR_CHSEL2      = 0x4     // Bit CHSEL2.
	ADC_CHSELR_CHSEL1_Pos  = 0x1     // Position of CHSEL1 field.
	ADC_CHSELR_CHSEL1_Msk  = 0x2     // Bit mask of CHSEL1 field.
	ADC_CHSELR_CHSEL1      = 0x2     // Bit CHSEL1.
	ADC_CHSELR_CHSEL0_Pos  = 0x0     // Position of CHSEL0 field.
	ADC_CHSELR_CHSEL0_Msk  = 0x1     // Bit mask of CHSEL0 field.
	ADC_CHSELR_CHSEL0      = 0x1     // Bit CHSEL0.

	// DR: data register
	ADC_DR_DATA_Pos = 0x0    // Position of DATA field.
	ADC_DR_DATA_Msk = 0xffff // Bit mask of DATA field.

	// CCR: common configuration register
	ADC_CCR_VBATEN_Pos = 0x18      // Position of VBATEN field.
	ADC_CCR_VBATEN_Msk = 0x1000000 // Bit mask of VBATEN field.
	ADC_CCR_VBATEN     = 0x1000000 // Bit VBATEN.
	ADC_CCR_TSEN_Pos   = 0x17      // Position of TSEN field.
	ADC_CCR_TSEN_Msk   = 0x800000  // Bit mask of TSEN field.
	ADC_CCR_TSEN       = 0x800000  // Bit TSEN.
	ADC_CCR_VREFEN_Pos = 0x16      // Position of VREFEN field.
	ADC_CCR_VREFEN_Msk = 0x400000  // Bit mask of VREFEN field.
	ADC_CCR_VREFEN     = 0x400000  // Bit VREFEN.
)

// Bitfields for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	USART_CR1_UE_Pos     = 0x0        // Position of UE field.
	USART_CR1_UE_Msk     = 0x1        // Bit mask of UE field.
	USART_CR1_UE         = 0x1        // Bit UE.
	USART_CR1_UESM_Pos   = 0x1        // Position of UESM field.
	USART_CR1_UESM_Msk   = 0x2        // Bit mask of UESM field.
	USART_CR1_UESM       = 0x2        // Bit UESM.
	USART_CR1_RE_Pos     = 0x2        // Position of RE field.
	USART_CR1_RE_Msk     = 0x4        // Bit mask of RE field.
	USART_CR1_RE         = 0x4        // Bit RE.
	USART_CR1_TE_Pos     = 0x3        // Position of TE field.
	USART_CR1_TE_Msk     = 0x8        // Bit mask of TE field.
	USART_CR1_TE         = 0x8        // Bit TE.
	USART_CR1_IDLEIE_Pos = 0x4        // Position of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10       // Bit mask of IDLEIE field.
	USART_CR1_IDLEIE     = 0x10       // Bit IDLEIE.
	USART_CR1_RXNEIE_Pos = 0x5        // Position of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20       // Bit mask of RXNEIE field.
	USART_CR1_RXNEIE     = 0x20       // Bit RXNEIE.
	USART_CR1_TCIE_Pos   = 0x6        // Position of TCIE field.
	USART_CR1_TCIE_Msk   = 0x40       // Bit mask of TCIE field.
	USART_CR1_TCIE       = 0x40       // Bit TCIE.
	USART_CR1_TXEIE_Pos  = 0x7        // Position of TXEIE field.
	USART_CR1_TXEIE_Msk  = 0x80       // Bit mask of TXEIE field.
	USART_CR1_TXEIE      = 0x80       // Bit TXEIE.
	USART_CR1_PEIE_Pos   = 0x8        // Position of PEIE field.
	USART_CR1_PEIE_Msk   = 0x100      // Bit mask of PEIE field.
	USART_CR1_PEIE       = 0x100      // Bit PEIE.
	USART_CR1_PS_Pos     = 0x9        // Position of PS field.
	USART_CR1_PS_Msk     = 0x200      // Bit mask of PS field.
	USART_CR1_PS         = 0x200      // Bit PS.
	USART_CR1_PCE_Pos    = 0xa        // Position of PCE field.
	USART_CR1_PCE_Msk    = 0x400      // Bit mask of PCE field.
	USART_CR1_PCE        = 0x400      // Bit PCE.
	USART_CR1_WAKE_Pos   = 0xb        // Position of WAKE field.
	USART_CR1_WAKE_Msk   = 0x800      // Bit mask of WAKE field.
	USART_CR1_WAKE       = 0x800      // Bit WAKE.
	USART_CR1_M_Pos      = 0xc        // Position of M field.
	USART_CR1_M_Msk      = 0x1000     // Bit mask of M field.
	USART_CR1_M          = 0x1000     // Bit M.
	USART_CR1_MME_Pos    = 0xd        // Position of MME field.
	USART_CR1_MME_Msk    = 0x2000     // Bit mask of MME field.
	USART_CR1_MME        = 0x2000     // Bit MME.
	USART_CR1_CMIE_Pos   = 0xe        // Position of CMIE field.
	USART_CR1_CMIE_Msk   = 0x4000     // Bit mask of CMIE field.
	USART_CR1_CMIE       = 0x4000     // Bit CMIE.
	USART_CR1_OVER8_Pos  = 0xf        // Position of OVER8 field.
	USART_CR1_OVER8_Msk  = 0x8000     // Bit mask of OVER8 field.
	USART_CR1_OVER8      = 0x8000     // Bit OVER8.
	USART_CR1_DEDT_Pos   = 0x10       // Position of DEDT field.
	USART_CR1_DEDT_Msk   = 0x1f0000   // Bit mask of DEDT field.
	USART_CR1_DEAT_Pos   = 0x15       // Position of DEAT field.
	USART_CR1_DEAT_Msk   = 0x3e00000  // Bit mask of DEAT field.
	USART_CR1_RTOIE_Pos  = 0x1a       // Position of RTOIE field.
	USART_CR1_RTOIE_Msk  = 0x4000000  // Bit mask of RTOIE field.
	USART_CR1_RTOIE      = 0x4000000  // Bit RTOIE.
	USART_CR1_EOBIE_Pos  = 0x1b       // Position of EOBIE field.
	USART_CR1_EOBIE_Msk  = 0x8000000  // Bit mask of EOBIE field.
	USART_CR1_EOBIE      = 0x8000000  // Bit EOBIE.
	USART_CR1_M1_Pos     = 0x1c       // Position of M1 field.
	USART_CR1_M1_Msk     = 0x10000000 // Bit mask of M1 field.
	USART_CR1_M1         = 0x10000000 // Bit M1.

	// CR2: Control register 2
	USART_CR2_ADD4_Pos     = 0x1c       // Position of ADD4 field.
	USART_CR2_ADD4_Msk     = 0xf0000000 // Bit mask of ADD4 field.
	USART_CR2_ADD0_Pos     = 0x18       // Position of ADD0 field.
	USART_CR2_ADD0_Msk     = 0xf000000  // Bit mask of ADD0 field.
	USART_CR2_RTOEN_Pos    = 0x17       // Position of RTOEN field.
	USART_CR2_RTOEN_Msk    = 0x800000   // Bit mask of RTOEN field.
	USART_CR2_RTOEN        = 0x800000   // Bit RTOEN.
	USART_CR2_ABRMOD_Pos   = 0x15       // Position of ABRMOD field.
	USART_CR2_ABRMOD_Msk   = 0x600000   // Bit mask of ABRMOD field.
	USART_CR2_ABREN_Pos    = 0x14       // Position of ABREN field.
	USART_CR2_ABREN_Msk    = 0x100000   // Bit mask of ABREN field.
	USART_CR2_ABREN        = 0x100000   // Bit ABREN.
	USART_CR2_MSBFIRST_Pos = 0x13       // Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000    // Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST     = 0x80000    // Bit MSBFIRST.
	USART_CR2_DATAINV_Pos  = 0x12       // Position of DATAINV field.
	USART_CR2_DATAINV_Msk  = 0x40000    // Bit mask of DATAINV field.
	USART_CR2_DATAINV      = 0x40000    // Bit DATAINV.
	USART_CR2_TXINV_Pos    = 0x11       // Position of TXINV field.
	USART_CR2_TXINV_Msk    = 0x20000    // Bit mask of TXINV field.
	USART_CR2_TXINV        = 0x20000    // Bit TXINV.
	USART_CR2_RXINV_Pos    = 0x10       // Position of RXINV field.
	USART_CR2_RXINV_Msk    = 0x10000    // Bit mask of RXINV field.
	USART_CR2_RXINV        = 0x10000    // Bit RXINV.
	USART_CR2_SWAP_Pos     = 0xf        // Position of SWAP field.
	USART_CR2_SWAP_Msk     = 0x8000     // Bit mask of SWAP field.
	USART_CR2_SWAP         = 0x8000     // Bit SWAP.
	USART_CR2_LINEN_Pos    = 0xe        // Position of LINEN field.
	USART_CR2_LINEN_Msk    = 0x4000     // Bit mask of LINEN field.
	USART_CR2_LINEN        = 0x4000     // Bit LINEN.
	USART_CR2_STOP_Pos     = 0xc        // Position of STOP field.
	USART_CR2_STOP_Msk     = 0x3000     // Bit mask of STOP field.
	USART_CR2_CLKEN_Pos    = 0xb        // Position of CLKEN field.
	USART_CR2_CLKEN_Msk    = 0x800      // Bit mask of CLKEN field.
	USART_CR2_CLKEN        = 0x800      // Bit CLKEN.
	USART_CR2_CPOL_Pos     = 0xa        // Position of CPOL field.
	USART_CR2_CPOL_Msk     = 0x400      // Bit mask of CPOL field.
	USART_CR2_CPOL         = 0x400      // Bit CPOL.
	USART_CR2_CPHA_Pos     = 0x9        // Position of CPHA field.
	USART_CR2_CPHA_Msk     = 0x200      // Bit mask of CPHA field.
	USART_CR2_CPHA         = 0x200      // Bit CPHA.
	USART_CR2_LBCL_Pos     = 0x8        // Position of LBCL field.
	USART_CR2_LBCL_Msk     = 0x100      // Bit mask of LBCL field.
	USART_CR2_LBCL         = 0x100      // Bit LBCL.
	USART_CR2_LBDIE_Pos    = 0x6        // Position of LBDIE field.
	USART_CR2_LBDIE_Msk    = 0x40       // Bit mask of LBDIE field.
	USART_CR2_LBDIE        = 0x40       // Bit LBDIE.
	USART_CR2_LBDL_Pos     = 0x5        // Position of LBDL field.
	USART_CR2_LBDL_Msk     = 0x20       // Bit mask of LBDL field.
	USART_CR2_LBDL         = 0x20       // Bit LBDL.
	USART_CR2_ADDM7_Pos    = 0x4        // Position of ADDM7 field.
	USART_CR2_ADDM7_Msk    = 0x10       // Bit mask of ADDM7 field.
	USART_CR2_ADDM7        = 0x10       // Bit ADDM7.

	// CR3: Control register 3
	USART_CR3_WUFIE_Pos   = 0x16     // Position of WUFIE field.
	USART_CR3_WUFIE_Msk   = 0x400000 // Bit mask of WUFIE field.
	USART_CR3_WUFIE       = 0x400000 // Bit WUFIE.
	USART_CR3_WUS_Pos     = 0x14     // Position of WUS field.
	USART_CR3_WUS_Msk     = 0x300000 // Bit mask of WUS field.
	USART_CR3_SCARCNT_Pos = 0x11     // Position of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000  // Bit mask of SCARCNT field.
	USART_CR3_DEP_Pos     = 0xf      // Position of DEP field.
	USART_CR3_DEP_Msk     = 0x8000   // Bit mask of DEP field.
	USART_CR3_DEP         = 0x8000   // Bit DEP.
	USART_CR3_DEM_Pos     = 0xe      // Position of DEM field.
	USART_CR3_DEM_Msk     = 0x4000   // Bit mask of DEM field.
	USART_CR3_DEM         = 0x4000   // Bit DEM.
	USART_CR3_DDRE_Pos    = 0xd      // Position of DDRE field.
	USART_CR3_DDRE_Msk    = 0x2000   // Bit mask of DDRE field.
	USART_CR3_DDRE        = 0x2000   // Bit DDRE.
	USART_CR3_OVRDIS_Pos  = 0xc      // Position of OVRDIS field.
	USART_CR3_OVRDIS_Msk  = 0x1000   // Bit mask of OVRDIS field.
	USART_CR3_OVRDIS      = 0x1000   // Bit OVRDIS.
	USART_CR3_ONEBIT_Pos  = 0xb      // Position of ONEBIT field.
	USART_CR3_ONEBIT_Msk  = 0x800    // Bit mask of ONEBIT field.
	USART_CR3_ONEBIT      = 0x800    // Bit ONEBIT.
	USART_CR3_CTSIE_Pos   = 0xa      // Position of CTSIE field.
	USART_CR3_CTSIE_Msk   = 0x400    // Bit mask of CTSIE field.
	USART_CR3_CTSIE       = 0x400    // Bit CTSIE.
	USART_CR3_CTSE_Pos    = 0x9      // Position of CTSE field.
	USART_CR3_CTSE_Msk    = 0x200    // Bit mask of CTSE field.
	USART_CR3_CTSE        = 0x200    // Bit CTSE.
	USART_CR3_RTSE_Pos    = 0x8      // Position of RTSE field.
	USART_CR3_RTSE_Msk    = 0x100    // Bit mask of RTSE field.
	USART_CR3_RTSE        = 0x100    // Bit RTSE.
	USART_CR3_DMAT_Pos    = 0x7      // Position of DMAT field.
	USART_CR3_DMAT_Msk    = 0x80     // Bit mask of DMAT field.
	USART_CR3_DMAT        = 0x80     // Bit DMAT.
	USART_CR3_DMAR_Pos    = 0x6      // Position of DMAR field.
	USART_CR3_DMAR_Msk    = 0x40     // Bit mask of DMAR field.
	USART_CR3_DMAR        = 0x40     // Bit DMAR.
	USART_CR3_SCEN_Pos    = 0x5      // Position of SCEN field.
	USART_CR3_SCEN_Msk    = 0x20     // Bit mask of SCEN field.
	USART_CR3_SCEN        = 0x20     // Bit SCEN.
	USART_CR3_NACK_Pos    = 0x4      // Position of NACK field.
	USART_CR3_NACK_Msk    = 0x10     // Bit mask of NACK field.
	USART_CR3_NACK        = 0x10     // Bit NACK.
	USART_CR3_HDSEL_Pos   = 0x3      // Position of HDSEL field.
	USART_CR3_HDSEL_Msk   = 0x8      // Bit mask of HDSEL field.
	USART_CR3_HDSEL       = 0x8      // Bit HDSEL.
	USART_CR3_IRLP_Pos    = 0x2      // Position of IRLP field.
	USART_CR3_IRLP_Msk    = 0x4      // Bit mask of IRLP field.
	USART_CR3_IRLP        = 0x4      // Bit IRLP.
	USART_CR3_IREN_Pos    = 0x1      // Position of IREN field.
	USART_CR3_IREN_Msk    = 0x2      // Bit mask of IREN field.
	USART_CR3_IREN        = 0x2      // Bit IREN.
	USART_CR3_EIE_Pos     = 0x0      // Position of EIE field.
	USART_CR3_EIE_Msk     = 0x1      // Bit mask of EIE field.
	USART_CR3_EIE         = 0x1      // Bit EIE.

	// BRR: Baud rate register
	USART_BRR_DIV_Mantissa_Pos = 0x4    // Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0 // Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Fraction_Pos = 0x0    // Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf    // Bit mask of DIV_Fraction field.

	// GTPR: Guard time and prescaler           register
	USART_GTPR_GT_Pos  = 0x8    // Position of GT field.
	USART_GTPR_GT_Msk  = 0xff00 // Bit mask of GT field.
	USART_GTPR_PSC_Pos = 0x0    // Position of PSC field.
	USART_GTPR_PSC_Msk = 0xff   // Bit mask of PSC field.

	// RTOR: Receiver timeout register
	USART_RTOR_BLEN_Pos = 0x18       // Position of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000 // Bit mask of BLEN field.
	USART_RTOR_RTO_Pos  = 0x0        // Position of RTO field.
	USART_RTOR_RTO_Msk  = 0xffffff   // Bit mask of RTO field.

	// RQR: Request register
	USART_RQR_TXFRQ_Pos = 0x4  // Position of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10 // Bit mask of TXFRQ field.
	USART_RQR_TXFRQ     = 0x10 // Bit TXFRQ.
	USART_RQR_RXFRQ_Pos = 0x3  // Position of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8  // Bit mask of RXFRQ field.
	USART_RQR_RXFRQ     = 0x8  // Bit RXFRQ.
	USART_RQR_MMRQ_Pos  = 0x2  // Position of MMRQ field.
	USART_RQR_MMRQ_Msk  = 0x4  // Bit mask of MMRQ field.
	USART_RQR_MMRQ      = 0x4  // Bit MMRQ.
	USART_RQR_SBKRQ_Pos = 0x1  // Position of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2  // Bit mask of SBKRQ field.
	USART_RQR_SBKRQ     = 0x2  // Bit SBKRQ.
	USART_RQR_ABRRQ_Pos = 0x0  // Position of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1  // Bit mask of ABRRQ field.
	USART_RQR_ABRRQ     = 0x1  // Bit ABRRQ.

	// ISR: Interrupt & status           register
	USART_ISR_REACK_Pos = 0x16     // Position of REACK field.
	USART_ISR_REACK_Msk = 0x400000 // Bit mask of REACK field.
	USART_ISR_REACK     = 0x400000 // Bit REACK.
	USART_ISR_TEACK_Pos = 0x15     // Position of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000 // Bit mask of TEACK field.
	USART_ISR_TEACK     = 0x200000 // Bit TEACK.
	USART_ISR_WUF_Pos   = 0x14     // Position of WUF field.
	USART_ISR_WUF_Msk   = 0x100000 // Bit mask of WUF field.
	USART_ISR_WUF       = 0x100000 // Bit WUF.
	USART_ISR_RWU_Pos   = 0x13     // Position of RWU field.
	USART_ISR_RWU_Msk   = 0x80000  // Bit mask of RWU field.
	USART_ISR_RWU       = 0x80000  // Bit RWU.
	USART_ISR_SBKF_Pos  = 0x12     // Position of SBKF field.
	USART_ISR_SBKF_Msk  = 0x40000  // Bit mask of SBKF field.
	USART_ISR_SBKF      = 0x40000  // Bit SBKF.
	USART_ISR_CMF_Pos   = 0x11     // Position of CMF field.
	USART_ISR_CMF_Msk   = 0x20000  // Bit mask of CMF field.
	USART_ISR_CMF       = 0x20000  // Bit CMF.
	USART_ISR_BUSY_Pos  = 0x10     // Position of BUSY field.
	USART_ISR_BUSY_Msk  = 0x10000  // Bit mask of BUSY field.
	USART_ISR_BUSY      = 0x10000  // Bit BUSY.
	USART_ISR_ABRF_Pos  = 0xf      // Position of ABRF field.
	USART_ISR_ABRF_Msk  = 0x8000   // Bit mask of ABRF field.
	USART_ISR_ABRF      = 0x8000   // Bit ABRF.
	USART_ISR_ABRE_Pos  = 0xe      // Position of ABRE field.
	USART_ISR_ABRE_Msk  = 0x4000   // Bit mask of ABRE field.
	USART_ISR_ABRE      = 0x4000   // Bit ABRE.
	USART_ISR_EOBF_Pos  = 0xc      // Position of EOBF field.
	USART_ISR_EOBF_Msk  = 0x1000   // Bit mask of EOBF field.
	USART_ISR_EOBF      = 0x1000   // Bit EOBF.
	USART_ISR_RTOF_Pos  = 0xb      // Position of RTOF field.
	USART_ISR_RTOF_Msk  = 0x800    // Bit mask of RTOF field.
	USART_ISR_RTOF      = 0x800    // Bit RTOF.
	USART_ISR_CTS_Pos   = 0xa      // Position of CTS field.
	USART_ISR_CTS_Msk   = 0x400    // Bit mask of CTS field.
	USART_ISR_CTS       = 0x400    // Bit CTS.
	USART_ISR_CTSIF_Pos = 0x9      // Position of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200    // Bit mask of CTSIF field.
	USART_ISR_CTSIF     = 0x200    // Bit CTSIF.
	USART_ISR_LBDF_Pos  = 0x8      // Position of LBDF field.
	USART_ISR_LBDF_Msk  = 0x100    // Bit mask of LBDF field.
	USART_ISR_LBDF      = 0x100    // Bit LBDF.
	USART_ISR_TXE_Pos   = 0x7      // Position of TXE field.
	USART_ISR_TXE_Msk   = 0x80     // Bit mask of TXE field.
	USART_ISR_TXE       = 0x80     // Bit TXE.
	USART_ISR_TC_Pos    = 0x6      // Position of TC field.
	USART_ISR_TC_Msk    = 0x40     // Bit mask of TC field.
	USART_ISR_TC        = 0x40     // Bit TC.
	USART_ISR_RXNE_Pos  = 0x5      // Position of RXNE field.
	USART_ISR_RXNE_Msk  = 0x20     // Bit mask of RXNE field.
	USART_ISR_RXNE      = 0x20     // Bit RXNE.
	USART_ISR_IDLE_Pos  = 0x4      // Position of IDLE field.
	USART_ISR_IDLE_Msk  = 0x10     // Bit mask of IDLE field.
	USART_ISR_IDLE      = 0x10     // Bit IDLE.
	USART_ISR_ORE_Pos   = 0x3      // Position of ORE field.
	USART_ISR_ORE_Msk   = 0x8      // Bit mask of ORE field.
	USART_ISR_ORE       = 0x8      // Bit ORE.
	USART_ISR_NF_Pos    = 0x2      // Position of NF field.
	USART_ISR_NF_Msk    = 0x4      // Bit mask of NF field.
	USART_ISR_NF        = 0x4      // Bit NF.
	USART_ISR_FE_Pos    = 0x1      // Position of FE field.
	USART_ISR_FE_Msk    = 0x2      // Bit mask of FE field.
	USART_ISR_FE        = 0x2      // Bit FE.
	USART_ISR_PE_Pos    = 0x0      // Position of PE field.
	USART_ISR_PE_Msk    = 0x1      // Bit mask of PE field.
	USART_ISR_PE        = 0x1      // Bit PE.

	// ICR: Interrupt flag clear register
	USART_ICR_WUCF_Pos   = 0x14     // Position of WUCF field.
	USART_ICR_WUCF_Msk   = 0x100000 // Bit mask of WUCF field.
	USART_ICR_WUCF       = 0x100000 // Bit WUCF.
	USART_ICR_CMCF_Pos   = 0x11     // Position of CMCF field.
	USART_ICR_CMCF_Msk   = 0x20000  // Bit mask of CMCF field.
	USART_ICR_CMCF       = 0x20000  // Bit CMCF.
	USART_ICR_EOBCF_Pos  = 0xc      // Position of EOBCF field.
	USART_ICR_EOBCF_Msk  = 0x1000   // Bit mask of EOBCF field.
	USART_ICR_EOBCF      = 0x1000   // Bit EOBCF.
	USART_ICR_RTOCF_Pos  = 0xb      // Position of RTOCF field.
	USART_ICR_RTOCF_Msk  = 0x800    // Bit mask of RTOCF field.
	USART_ICR_RTOCF      = 0x800    // Bit RTOCF.
	USART_ICR_CTSCF_Pos  = 0x9      // Position of CTSCF field.
	USART_ICR_CTSCF_Msk  = 0x200    // Bit mask of CTSCF field.
	USART_ICR_CTSCF      = 0x200    // Bit CTSCF.
	USART_ICR_LBDCF_Pos  = 0x8      // Position of LBDCF field.
	USART_ICR_LBDCF_Msk  = 0x100    // Bit mask of LBDCF field.
	USART_ICR_LBDCF      = 0x100    // Bit LBDCF.
	USART_ICR_TCCF_Pos   = 0x6      // Position of TCCF field.
	USART_ICR_TCCF_Msk   = 0x40     // Bit mask of TCCF field.
	USART_ICR_TCCF       = 0x40     // Bit TCCF.
	USART_ICR_IDLECF_Pos = 0x4      // Position of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10     // Bit mask of IDLECF field.
	USART_ICR_IDLECF     = 0x10     // Bit IDLECF.
	USART_ICR_ORECF_Pos  = 0x3      // Position of ORECF field.
	USART_ICR_ORECF_Msk  = 0x8      // Bit mask of ORECF field.
	USART_ICR_ORECF      = 0x8      // Bit ORECF.
	USART_ICR_NCF_Pos    = 0x2      // Position of NCF field.
	USART_ICR_NCF_Msk    = 0x4      // Bit mask of NCF field.
	USART_ICR_NCF        = 0x4      // Bit NCF.
	USART_ICR_FECF_Pos   = 0x1      // Position of FECF field.
	USART_ICR_FECF_Msk   = 0x2      // Bit mask of FECF field.
	USART_ICR_FECF       = 0x2      // Bit FECF.
	USART_ICR_PECF_Pos   = 0x0      // Position of PECF field.
	USART_ICR_PECF_Msk   = 0x1      // Bit mask of PECF field.
	USART_ICR_PECF       = 0x1      // Bit PECF.

	// RDR: Receive data register
	USART_RDR_RDR_Pos = 0x0   // Position of RDR field.
	USART_RDR_RDR_Msk = 0x1ff // Bit mask of RDR field.

	// TDR: Transmit data register
	USART_TDR_TDR_Pos = 0x0   // Position of TDR field.
	USART_TDR_TDR_Msk = 0x1ff // Bit mask of TDR field.
)

// Bitfields for COMP: Comparator
const (
	// CSR: control and status register
	COMP_CSR_COMP1EN_Pos       = 0x0        // Position of COMP1EN field.
	COMP_CSR_COMP1EN_Msk       = 0x1        // Bit mask of COMP1EN field.
	COMP_CSR_COMP1EN           = 0x1        // Bit COMP1EN.
	COMP_CSR_COMP1_INP_DAC_Pos = 0x1        // Position of COMP1_INP_DAC field.
	COMP_CSR_COMP1_INP_DAC_Msk = 0x2        // Bit mask of COMP1_INP_DAC field.
	COMP_CSR_COMP1_INP_DAC     = 0x2        // Bit COMP1_INP_DAC.
	COMP_CSR_COMP1MODE_Pos     = 0x2        // Position of COMP1MODE field.
	COMP_CSR_COMP1MODE_Msk     = 0xc        // Bit mask of COMP1MODE field.
	COMP_CSR_COMP1INSEL_Pos    = 0x4        // Position of COMP1INSEL field.
	COMP_CSR_COMP1INSEL_Msk    = 0x70       // Bit mask of COMP1INSEL field.
	COMP_CSR_COMP1OUTSEL_Pos   = 0x8        // Position of COMP1OUTSEL field.
	COMP_CSR_COMP1OUTSEL_Msk   = 0x700      // Bit mask of COMP1OUTSEL field.
	COMP_CSR_COMP1POL_Pos      = 0xb        // Position of COMP1POL field.
	COMP_CSR_COMP1POL_Msk      = 0x800      // Bit mask of COMP1POL field.
	COMP_CSR_COMP1POL          = 0x800      // Bit COMP1POL.
	COMP_CSR_COMP1HYST_Pos     = 0xc        // Position of COMP1HYST field.
	COMP_CSR_COMP1HYST_Msk     = 0x3000     // Bit mask of COMP1HYST field.
	COMP_CSR_COMP1OUT_Pos      = 0xe        // Position of COMP1OUT field.
	COMP_CSR_COMP1OUT_Msk      = 0x4000     // Bit mask of COMP1OUT field.
	COMP_CSR_COMP1OUT          = 0x4000     // Bit COMP1OUT.
	COMP_CSR_COMP1LOCK_Pos     = 0xf        // Position of COMP1LOCK field.
	COMP_CSR_COMP1LOCK_Msk     = 0x8000     // Bit mask of COMP1LOCK field.
	COMP_CSR_COMP1LOCK         = 0x8000     // Bit COMP1LOCK.
	COMP_CSR_COMP2EN_Pos       = 0x10       // Position of COMP2EN field.
	COMP_CSR_COMP2EN_Msk       = 0x10000    // Bit mask of COMP2EN field.
	COMP_CSR_COMP2EN           = 0x10000    // Bit COMP2EN.
	COMP_CSR_COMP2MODE_Pos     = 0x12       // Position of COMP2MODE field.
	COMP_CSR_COMP2MODE_Msk     = 0xc0000    // Bit mask of COMP2MODE field.
	COMP_CSR_COMP2INSEL_Pos    = 0x14       // Position of COMP2INSEL field.
	COMP_CSR_COMP2INSEL_Msk    = 0x700000   // Bit mask of COMP2INSEL field.
	COMP_CSR_WNDWEN_Pos        = 0x17       // Position of WNDWEN field.
	COMP_CSR_WNDWEN_Msk        = 0x800000   // Bit mask of WNDWEN field.
	COMP_CSR_WNDWEN            = 0x800000   // Bit WNDWEN.
	COMP_CSR_COMP2OUTSEL_Pos   = 0x18       // Position of COMP2OUTSEL field.
	COMP_CSR_COMP2OUTSEL_Msk   = 0x7000000  // Bit mask of COMP2OUTSEL field.
	COMP_CSR_COMP2POL_Pos      = 0x1b       // Position of COMP2POL field.
	COMP_CSR_COMP2POL_Msk      = 0x8000000  // Bit mask of COMP2POL field.
	COMP_CSR_COMP2POL          = 0x8000000  // Bit COMP2POL.
	COMP_CSR_COMP2HYST_Pos     = 0x1c       // Position of COMP2HYST field.
	COMP_CSR_COMP2HYST_Msk     = 0x30000000 // Bit mask of COMP2HYST field.
	COMP_CSR_COMP2OUT_Pos      = 0x1e       // Position of COMP2OUT field.
	COMP_CSR_COMP2OUT_Msk      = 0x40000000 // Bit mask of COMP2OUT field.
	COMP_CSR_COMP2OUT          = 0x40000000 // Bit COMP2OUT.
	COMP_CSR_COMP2LOCK_Pos     = 0x1f       // Position of COMP2LOCK field.
	COMP_CSR_COMP2LOCK_Msk     = 0x80000000 // Bit mask of COMP2LOCK field.
	COMP_CSR_COMP2LOCK         = 0x80000000 // Bit COMP2LOCK.
)

// Bitfields for RTC: Real-time clock
const (
	// TR: time register
	RTC_TR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TR_PM      = 0x400000 // Bit PM.
	RTC_TR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TR_SU_Msk  = 0xf      // Bit mask of SU field.

	// DR: date register
	RTC_DR_YT_Pos  = 0x14     // Position of YT field.
	RTC_DR_YT_Msk  = 0xf00000 // Bit mask of YT field.
	RTC_DR_YU_Pos  = 0x10     // Position of YU field.
	RTC_DR_YU_Msk  = 0xf0000  // Bit mask of YU field.
	RTC_DR_WDU_Pos = 0xd      // Position of WDU field.
	RTC_DR_WDU_Msk = 0xe000   // Bit mask of WDU field.
	RTC_DR_MT_Pos  = 0xc      // Position of MT field.
	RTC_DR_MT_Msk  = 0x1000   // Bit mask of MT field.
	RTC_DR_MT      = 0x1000   // Bit MT.
	RTC_DR_MU_Pos  = 0x8      // Position of MU field.
	RTC_DR_MU_Msk  = 0xf00    // Bit mask of MU field.
	RTC_DR_DT_Pos  = 0x4      // Position of DT field.
	RTC_DR_DT_Msk  = 0x30     // Bit mask of DT field.
	RTC_DR_DU_Pos  = 0x0      // Position of DU field.
	RTC_DR_DU_Msk  = 0xf      // Bit mask of DU field.

	// CR: control register
	RTC_CR_TSEDGE_Pos  = 0x3      // Position of TSEDGE field.
	RTC_CR_TSEDGE_Msk  = 0x8      // Bit mask of TSEDGE field.
	RTC_CR_TSEDGE      = 0x8      // Bit TSEDGE.
	RTC_CR_REFCKON_Pos = 0x4      // Position of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10     // Bit mask of REFCKON field.
	RTC_CR_REFCKON     = 0x10     // Bit REFCKON.
	RTC_CR_BYPSHAD_Pos = 0x5      // Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20     // Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD     = 0x20     // Bit BYPSHAD.
	RTC_CR_FMT_Pos     = 0x6      // Position of FMT field.
	RTC_CR_FMT_Msk     = 0x40     // Bit mask of FMT field.
	RTC_CR_FMT         = 0x40     // Bit FMT.
	RTC_CR_ALRAE_Pos   = 0x8      // Position of ALRAE field.
	RTC_CR_ALRAE_Msk   = 0x100    // Bit mask of ALRAE field.
	RTC_CR_ALRAE       = 0x100    // Bit ALRAE.
	RTC_CR_TSE_Pos     = 0xb      // Position of TSE field.
	RTC_CR_TSE_Msk     = 0x800    // Bit mask of TSE field.
	RTC_CR_TSE         = 0x800    // Bit TSE.
	RTC_CR_ALRAIE_Pos  = 0xc      // Position of ALRAIE field.
	RTC_CR_ALRAIE_Msk  = 0x1000   // Bit mask of ALRAIE field.
	RTC_CR_ALRAIE      = 0x1000   // Bit ALRAIE.
	RTC_CR_TSIE_Pos    = 0xf      // Position of TSIE field.
	RTC_CR_TSIE_Msk    = 0x8000   // Bit mask of TSIE field.
	RTC_CR_TSIE        = 0x8000   // Bit TSIE.
	RTC_CR_ADD1H_Pos   = 0x10     // Position of ADD1H field.
	RTC_CR_ADD1H_Msk   = 0x10000  // Bit mask of ADD1H field.
	RTC_CR_ADD1H       = 0x10000  // Bit ADD1H.
	RTC_CR_SUB1H_Pos   = 0x11     // Position of SUB1H field.
	RTC_CR_SUB1H_Msk   = 0x20000  // Bit mask of SUB1H field.
	RTC_CR_SUB1H       = 0x20000  // Bit SUB1H.
	RTC_CR_BKP_Pos     = 0x12     // Position of BKP field.
	RTC_CR_BKP_Msk     = 0x40000  // Bit mask of BKP field.
	RTC_CR_BKP         = 0x40000  // Bit BKP.
	RTC_CR_COSEL_Pos   = 0x13     // Position of COSEL field.
	RTC_CR_COSEL_Msk   = 0x80000  // Bit mask of COSEL field.
	RTC_CR_COSEL       = 0x80000  // Bit COSEL.
	RTC_CR_POL_Pos     = 0x14     // Position of POL field.
	RTC_CR_POL_Msk     = 0x100000 // Bit mask of POL field.
	RTC_CR_POL         = 0x100000 // Bit POL.
	RTC_CR_OSEL_Pos    = 0x15     // Position of OSEL field.
	RTC_CR_OSEL_Msk    = 0x600000 // Bit mask of OSEL field.
	RTC_CR_COE_Pos     = 0x17     // Position of COE field.
	RTC_CR_COE_Msk     = 0x800000 // Bit mask of COE field.
	RTC_CR_COE         = 0x800000 // Bit COE.

	// ISR: initialization and status           register
	RTC_ISR_ALRAWF_Pos  = 0x0     // Position of ALRAWF field.
	RTC_ISR_ALRAWF_Msk  = 0x1     // Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF      = 0x1     // Bit ALRAWF.
	RTC_ISR_SHPF_Pos    = 0x3     // Position of SHPF field.
	RTC_ISR_SHPF_Msk    = 0x8     // Bit mask of SHPF field.
	RTC_ISR_SHPF        = 0x8     // Bit SHPF.
	RTC_ISR_INITS_Pos   = 0x4     // Position of INITS field.
	RTC_ISR_INITS_Msk   = 0x10    // Bit mask of INITS field.
	RTC_ISR_INITS       = 0x10    // Bit INITS.
	RTC_ISR_RSF_Pos     = 0x5     // Position of RSF field.
	RTC_ISR_RSF_Msk     = 0x20    // Bit mask of RSF field.
	RTC_ISR_RSF         = 0x20    // Bit RSF.
	RTC_ISR_INITF_Pos   = 0x6     // Position of INITF field.
	RTC_ISR_INITF_Msk   = 0x40    // Bit mask of INITF field.
	RTC_ISR_INITF       = 0x40    // Bit INITF.
	RTC_ISR_INIT_Pos    = 0x7     // Position of INIT field.
	RTC_ISR_INIT_Msk    = 0x80    // Bit mask of INIT field.
	RTC_ISR_INIT        = 0x80    // Bit INIT.
	RTC_ISR_ALRAF_Pos   = 0x8     // Position of ALRAF field.
	RTC_ISR_ALRAF_Msk   = 0x100   // Bit mask of ALRAF field.
	RTC_ISR_ALRAF       = 0x100   // Bit ALRAF.
	RTC_ISR_TSF_Pos     = 0xb     // Position of TSF field.
	RTC_ISR_TSF_Msk     = 0x800   // Bit mask of TSF field.
	RTC_ISR_TSF         = 0x800   // Bit TSF.
	RTC_ISR_TSOVF_Pos   = 0xc     // Position of TSOVF field.
	RTC_ISR_TSOVF_Msk   = 0x1000  // Bit mask of TSOVF field.
	RTC_ISR_TSOVF       = 0x1000  // Bit TSOVF.
	RTC_ISR_TAMP1F_Pos  = 0xd     // Position of TAMP1F field.
	RTC_ISR_TAMP1F_Msk  = 0x2000  // Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F      = 0x2000  // Bit TAMP1F.
	RTC_ISR_TAMP2F_Pos  = 0xe     // Position of TAMP2F field.
	RTC_ISR_TAMP2F_Msk  = 0x4000  // Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F      = 0x4000  // Bit TAMP2F.
	RTC_ISR_RECALPF_Pos = 0x10    // Position of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000 // Bit mask of RECALPF field.
	RTC_ISR_RECALPF     = 0x10000 // Bit RECALPF.

	// PRER: prescaler register
	RTC_PRER_PREDIV_A_Pos = 0x10     // Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000 // Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_S_Pos = 0x0      // Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff   // Bit mask of PREDIV_S field.

	// ALRMAR: alarm A register
	RTC_ALRMAR_MSK4_Pos  = 0x1f       // Position of MSK4 field.
	RTC_ALRMAR_MSK4_Msk  = 0x80000000 // Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4      = 0x80000000 // Bit MSK4.
	RTC_ALRMAR_WDSEL_Pos = 0x1e       // Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000 // Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL     = 0x40000000 // Bit WDSEL.
	RTC_ALRMAR_DT_Pos    = 0x1c       // Position of DT field.
	RTC_ALRMAR_DT_Msk    = 0x30000000 // Bit mask of DT field.
	RTC_ALRMAR_DU_Pos    = 0x18       // Position of DU field.
	RTC_ALRMAR_DU_Msk    = 0xf000000  // Bit mask of DU field.
	RTC_ALRMAR_MSK3_Pos  = 0x17       // Position of MSK3 field.
	RTC_ALRMAR_MSK3_Msk  = 0x800000   // Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3      = 0x800000   // Bit MSK3.
	RTC_ALRMAR_PM_Pos    = 0x16       // Position of PM field.
	RTC_ALRMAR_PM_Msk    = 0x400000   // Bit mask of PM field.
	RTC_ALRMAR_PM        = 0x400000   // Bit PM.
	RTC_ALRMAR_HT_Pos    = 0x14       // Position of HT field.
	RTC_ALRMAR_HT_Msk    = 0x300000   // Bit mask of HT field.
	RTC_ALRMAR_HU_Pos    = 0x10       // Position of HU field.
	RTC_ALRMAR_HU_Msk    = 0xf0000    // Bit mask of HU field.
	RTC_ALRMAR_MSK2_Pos  = 0xf        // Position of MSK2 field.
	RTC_ALRMAR_MSK2_Msk  = 0x8000     // Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2      = 0x8000     // Bit MSK2.
	RTC_ALRMAR_MNT_Pos   = 0xc        // Position of MNT field.
	RTC_ALRMAR_MNT_Msk   = 0x7000     // Bit mask of MNT field.
	RTC_ALRMAR_MNU_Pos   = 0x8        // Position of MNU field.
	RTC_ALRMAR_MNU_Msk   = 0xf00      // Bit mask of MNU field.
	RTC_ALRMAR_MSK1_Pos  = 0x7        // Position of MSK1 field.
	RTC_ALRMAR_MSK1_Msk  = 0x80       // Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1      = 0x80       // Bit MSK1.
	RTC_ALRMAR_ST_Pos    = 0x4        // Position of ST field.
	RTC_ALRMAR_ST_Msk    = 0x70       // Bit mask of ST field.
	RTC_ALRMAR_SU_Pos    = 0x0        // Position of SU field.
	RTC_ALRMAR_SU_Msk    = 0xf        // Bit mask of SU field.

	// WPR: write protection register
	RTC_WPR_KEY_Pos = 0x0  // Position of KEY field.
	RTC_WPR_KEY_Msk = 0xff // Bit mask of KEY field.

	// SSR: sub second register
	RTC_SSR_SS_Pos = 0x0    // Position of SS field.
	RTC_SSR_SS_Msk = 0xffff // Bit mask of SS field.

	// SHIFTR: shift control register
	RTC_SHIFTR_ADD1S_Pos = 0x1f       // Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000 // Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S     = 0x80000000 // Bit ADD1S.
	RTC_SHIFTR_SUBFS_Pos = 0x0        // Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff     // Bit mask of SUBFS field.

	// TSTR: timestamp time register
	RTC_TSTR_PM_Pos  = 0x16     // Position of PM field.
	RTC_TSTR_PM_Msk  = 0x400000 // Bit mask of PM field.
	RTC_TSTR_PM      = 0x400000 // Bit PM.
	RTC_TSTR_HT_Pos  = 0x14     // Position of HT field.
	RTC_TSTR_HT_Msk  = 0x300000 // Bit mask of HT field.
	RTC_TSTR_HU_Pos  = 0x10     // Position of HU field.
	RTC_TSTR_HU_Msk  = 0xf0000  // Bit mask of HU field.
	RTC_TSTR_MNT_Pos = 0xc      // Position of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000   // Bit mask of MNT field.
	RTC_TSTR_MNU_Pos = 0x8      // Position of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00    // Bit mask of MNU field.
	RTC_TSTR_ST_Pos  = 0x4      // Position of ST field.
	RTC_TSTR_ST_Msk  = 0x70     // Bit mask of ST field.
	RTC_TSTR_SU_Pos  = 0x0      // Position of SU field.
	RTC_TSTR_SU_Msk  = 0xf      // Bit mask of SU field.

	// TSDR: timestamp date register
	RTC_TSDR_WDU_Pos = 0xd    // Position of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000 // Bit mask of WDU field.
	RTC_TSDR_MT_Pos  = 0xc    // Position of MT field.
	RTC_TSDR_MT_Msk  = 0x1000 // Bit mask of MT field.
	RTC_TSDR_MT      = 0x1000 // Bit MT.
	RTC_TSDR_MU_Pos  = 0x8    // Position of MU field.
	RTC_TSDR_MU_Msk  = 0xf00  // Bit mask of MU field.
	RTC_TSDR_DT_Pos  = 0x4    // Position of DT field.
	RTC_TSDR_DT_Msk  = 0x30   // Bit mask of DT field.
	RTC_TSDR_DU_Pos  = 0x0    // Position of DU field.
	RTC_TSDR_DU_Msk  = 0xf    // Bit mask of DU field.

	// TSSSR: time-stamp sub second register
	RTC_TSSSR_SS_Pos = 0x0    // Position of SS field.
	RTC_TSSSR_SS_Msk = 0xffff // Bit mask of SS field.

	// CALR: calibration register
	RTC_CALR_CALP_Pos   = 0xf    // Position of CALP field.
	RTC_CALR_CALP_Msk   = 0x8000 // Bit mask of CALP field.
	RTC_CALR_CALP       = 0x8000 // Bit CALP.
	RTC_CALR_CALW8_Pos  = 0xe    // Position of CALW8 field.
	RTC_CALR_CALW8_Msk  = 0x4000 // Bit mask of CALW8 field.
	RTC_CALR_CALW8      = 0x4000 // Bit CALW8.
	RTC_CALR_CALW16_Pos = 0xd    // Position of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000 // Bit mask of CALW16 field.
	RTC_CALR_CALW16     = 0x2000 // Bit CALW16.
	RTC_CALR_CALM_Pos   = 0x0    // Position of CALM field.
	RTC_CALR_CALM_Msk   = 0x1ff  // Bit mask of CALM field.

	// TAFCR: tamper and alternate function configuration           register
	RTC_TAFCR_PC15MODE_Pos   = 0x17     // Position of PC15MODE field.
	RTC_TAFCR_PC15MODE_Msk   = 0x800000 // Bit mask of PC15MODE field.
	RTC_TAFCR_PC15MODE       = 0x800000 // Bit PC15MODE.
	RTC_TAFCR_PC15VALUE_Pos  = 0x16     // Position of PC15VALUE field.
	RTC_TAFCR_PC15VALUE_Msk  = 0x400000 // Bit mask of PC15VALUE field.
	RTC_TAFCR_PC15VALUE      = 0x400000 // Bit PC15VALUE.
	RTC_TAFCR_PC14MODE_Pos   = 0x15     // Position of PC14MODE field.
	RTC_TAFCR_PC14MODE_Msk   = 0x200000 // Bit mask of PC14MODE field.
	RTC_TAFCR_PC14MODE       = 0x200000 // Bit PC14MODE.
	RTC_TAFCR_PC14VALUE_Pos  = 0x14     // Position of PC14VALUE field.
	RTC_TAFCR_PC14VALUE_Msk  = 0x100000 // Bit mask of PC14VALUE field.
	RTC_TAFCR_PC14VALUE      = 0x100000 // Bit PC14VALUE.
	RTC_TAFCR_PC13MODE_Pos   = 0x13     // Position of PC13MODE field.
	RTC_TAFCR_PC13MODE_Msk   = 0x80000  // Bit mask of PC13MODE field.
	RTC_TAFCR_PC13MODE       = 0x80000  // Bit PC13MODE.
	RTC_TAFCR_PC13VALUE_Pos  = 0x12     // Position of PC13VALUE field.
	RTC_TAFCR_PC13VALUE_Msk  = 0x40000  // Bit mask of PC13VALUE field.
	RTC_TAFCR_PC13VALUE      = 0x40000  // Bit PC13VALUE.
	RTC_TAFCR_TAMP_PUDIS_Pos = 0xf      // Position of TAMP_PUDIS field.
	RTC_TAFCR_TAMP_PUDIS_Msk = 0x8000   // Bit mask of TAMP_PUDIS field.
	RTC_TAFCR_TAMP_PUDIS     = 0x8000   // Bit TAMP_PUDIS.
	RTC_TAFCR_TAMP_PRCH_Pos  = 0xd      // Position of TAMP_PRCH field.
	RTC_TAFCR_TAMP_PRCH_Msk  = 0x6000   // Bit mask of TAMP_PRCH field.
	RTC_TAFCR_TAMPFLT_Pos    = 0xb      // Position of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Msk    = 0x1800   // Bit mask of TAMPFLT field.
	RTC_TAFCR_TAMPFREQ_Pos   = 0x8      // Position of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Msk   = 0x700    // Bit mask of TAMPFREQ field.
	RTC_TAFCR_TAMPTS_Pos     = 0x7      // Position of TAMPTS field.
	RTC_TAFCR_TAMPTS_Msk     = 0x80     // Bit mask of TAMPTS field.
	RTC_TAFCR_TAMPTS         = 0x80     // Bit TAMPTS.
	RTC_TAFCR_TAMP2_TRG_Pos  = 0x4      // Position of TAMP2_TRG field.
	RTC_TAFCR_TAMP2_TRG_Msk  = 0x10     // Bit mask of TAMP2_TRG field.
	RTC_TAFCR_TAMP2_TRG      = 0x10     // Bit TAMP2_TRG.
	RTC_TAFCR_TAMP2E_Pos     = 0x3      // Position of TAMP2E field.
	RTC_TAFCR_TAMP2E_Msk     = 0x8      // Bit mask of TAMP2E field.
	RTC_TAFCR_TAMP2E         = 0x8      // Bit TAMP2E.
	RTC_TAFCR_TAMPIE_Pos     = 0x2      // Position of TAMPIE field.
	RTC_TAFCR_TAMPIE_Msk     = 0x4      // Bit mask of TAMPIE field.
	RTC_TAFCR_TAMPIE         = 0x4      // Bit TAMPIE.
	RTC_TAFCR_TAMP1TRG_Pos   = 0x1      // Position of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG_Msk   = 0x2      // Bit mask of TAMP1TRG field.
	RTC_TAFCR_TAMP1TRG       = 0x2      // Bit TAMP1TRG.
	RTC_TAFCR_TAMP1E_Pos     = 0x0      // Position of TAMP1E field.
	RTC_TAFCR_TAMP1E_Msk     = 0x1      // Bit mask of TAMP1E field.
	RTC_TAFCR_TAMP1E         = 0x1      // Bit TAMP1E.

	// ALRMASSR: alarm A sub second register
	RTC_ALRMASSR_MASKSS_Pos = 0x18      // Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000 // Bit mask of MASKSS field.
	RTC_ALRMASSR_SS_Pos     = 0x0       // Position of SS field.
	RTC_ALRMASSR_SS_Msk     = 0x7fff    // Bit mask of SS field.

	// BKP0R: backup register
	RTC_BKP0R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP0R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP1R: backup register
	RTC_BKP1R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP1R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP2R: backup register
	RTC_BKP2R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP2R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP3R: backup register
	RTC_BKP3R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP3R_BKP_Msk = 0xffffffff // Bit mask of BKP field.

	// BKP4R: backup register
	RTC_BKP4R_BKP_Pos = 0x0        // Position of BKP field.
	RTC_BKP4R_BKP_Msk = 0xffffffff // Bit mask of BKP field.
)

// Bitfields for TSC: Touch sensing controller
const (
	// CR: control register
	TSC_CR_CTPH_Pos    = 0x1c       // Position of CTPH field.
	TSC_CR_CTPH_Msk    = 0xf0000000 // Bit mask of CTPH field.
	TSC_CR_CTPL_Pos    = 0x18       // Position of CTPL field.
	TSC_CR_CTPL_Msk    = 0xf000000  // Bit mask of CTPL field.
	TSC_CR_SSD_Pos     = 0x11       // Position of SSD field.
	TSC_CR_SSD_Msk     = 0xfe0000   // Bit mask of SSD field.
	TSC_CR_SSE_Pos     = 0x10       // Position of SSE field.
	TSC_CR_SSE_Msk     = 0x10000    // Bit mask of SSE field.
	TSC_CR_SSE         = 0x10000    // Bit SSE.
	TSC_CR_SSPSC_Pos   = 0xf        // Position of SSPSC field.
	TSC_CR_SSPSC_Msk   = 0x8000     // Bit mask of SSPSC field.
	TSC_CR_SSPSC       = 0x8000     // Bit SSPSC.
	TSC_CR_PGPSC_Pos   = 0xc        // Position of PGPSC field.
	TSC_CR_PGPSC_Msk   = 0x7000     // Bit mask of PGPSC field.
	TSC_CR_MCV_Pos     = 0x5        // Position of MCV field.
	TSC_CR_MCV_Msk     = 0xe0       // Bit mask of MCV field.
	TSC_CR_IODEF_Pos   = 0x4        // Position of IODEF field.
	TSC_CR_IODEF_Msk   = 0x10       // Bit mask of IODEF field.
	TSC_CR_IODEF       = 0x10       // Bit IODEF.
	TSC_CR_SYNCPOL_Pos = 0x3        // Position of SYNCPOL field.
	TSC_CR_SYNCPOL_Msk = 0x8        // Bit mask of SYNCPOL field.
	TSC_CR_SYNCPOL     = 0x8        // Bit SYNCPOL.
	TSC_CR_AM_Pos      = 0x2        // Position of AM field.
	TSC_CR_AM_Msk      = 0x4        // Bit mask of AM field.
	TSC_CR_AM          = 0x4        // Bit AM.
	TSC_CR_START_Pos   = 0x1        // Position of START field.
	TSC_CR_START_Msk   = 0x2        // Bit mask of START field.
	TSC_CR_START       = 0x2        // Bit START.
	TSC_CR_TSCE_Pos    = 0x0        // Position of TSCE field.
	TSC_CR_TSCE_Msk    = 0x1        // Bit mask of TSCE field.
	TSC_CR_TSCE        = 0x1        // Bit TSCE.

	// IER: interrupt enable register
	TSC_IER_MCEIE_Pos = 0x1 // Position of MCEIE field.
	TSC_IER_MCEIE_Msk = 0x2 // Bit mask of MCEIE field.
	TSC_IER_MCEIE     = 0x2 // Bit MCEIE.
	TSC_IER_EOAIE_Pos = 0x0 // Position of EOAIE field.
	TSC_IER_EOAIE_Msk = 0x1 // Bit mask of EOAIE field.
	TSC_IER_EOAIE     = 0x1 // Bit EOAIE.

	// ICR: interrupt clear register
	TSC_ICR_MCEIC_Pos = 0x1 // Position of MCEIC field.
	TSC_ICR_MCEIC_Msk = 0x2 // Bit mask of MCEIC field.
	TSC_ICR_MCEIC     = 0x2 // Bit MCEIC.
	TSC_ICR_EOAIC_Pos = 0x0 // Position of EOAIC field.
	TSC_ICR_EOAIC_Msk = 0x1 // Bit mask of EOAIC field.
	TSC_ICR_EOAIC     = 0x1 // Bit EOAIC.

	// ISR: interrupt status register
	TSC_ISR_MCEF_Pos = 0x1 // Position of MCEF field.
	TSC_ISR_MCEF_Msk = 0x2 // Bit mask of MCEF field.
	TSC_ISR_MCEF     = 0x2 // Bit MCEF.
	TSC_ISR_EOAF_Pos = 0x0 // Position of EOAF field.
	TSC_ISR_EOAF_Msk = 0x1 // Bit mask of EOAF field.
	TSC_ISR_EOAF     = 0x1 // Bit EOAF.

	// IOHCR: I/O hysteresis control           register
	TSC_IOHCR_G6_IO4_Pos = 0x17     // Position of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Msk = 0x800000 // Bit mask of G6_IO4 field.
	TSC_IOHCR_G6_IO4     = 0x800000 // Bit G6_IO4.
	TSC_IOHCR_G6_IO3_Pos = 0x16     // Position of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Msk = 0x400000 // Bit mask of G6_IO3 field.
	TSC_IOHCR_G6_IO3     = 0x400000 // Bit G6_IO3.
	TSC_IOHCR_G6_IO2_Pos = 0x15     // Position of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Msk = 0x200000 // Bit mask of G6_IO2 field.
	TSC_IOHCR_G6_IO2     = 0x200000 // Bit G6_IO2.
	TSC_IOHCR_G6_IO1_Pos = 0x14     // Position of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Msk = 0x100000 // Bit mask of G6_IO1 field.
	TSC_IOHCR_G6_IO1     = 0x100000 // Bit G6_IO1.
	TSC_IOHCR_G5_IO4_Pos = 0x13     // Position of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Msk = 0x80000  // Bit mask of G5_IO4 field.
	TSC_IOHCR_G5_IO4     = 0x80000  // Bit G5_IO4.
	TSC_IOHCR_G5_IO3_Pos = 0x12     // Position of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Msk = 0x40000  // Bit mask of G5_IO3 field.
	TSC_IOHCR_G5_IO3     = 0x40000  // Bit G5_IO3.
	TSC_IOHCR_G5_IO2_Pos = 0x11     // Position of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Msk = 0x20000  // Bit mask of G5_IO2 field.
	TSC_IOHCR_G5_IO2     = 0x20000  // Bit G5_IO2.
	TSC_IOHCR_G5_IO1_Pos = 0x10     // Position of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Msk = 0x10000  // Bit mask of G5_IO1 field.
	TSC_IOHCR_G5_IO1     = 0x10000  // Bit G5_IO1.
	TSC_IOHCR_G4_IO4_Pos = 0xf      // Position of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Msk = 0x8000   // Bit mask of G4_IO4 field.
	TSC_IOHCR_G4_IO4     = 0x8000   // Bit G4_IO4.
	TSC_IOHCR_G4_IO3_Pos = 0xe      // Position of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Msk = 0x4000   // Bit mask of G4_IO3 field.
	TSC_IOHCR_G4_IO3     = 0x4000   // Bit G4_IO3.
	TSC_IOHCR_G4_IO2_Pos = 0xd      // Position of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Msk = 0x2000   // Bit mask of G4_IO2 field.
	TSC_IOHCR_G4_IO2     = 0x2000   // Bit G4_IO2.
	TSC_IOHCR_G4_IO1_Pos = 0xc      // Position of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Msk = 0x1000   // Bit mask of G4_IO1 field.
	TSC_IOHCR_G4_IO1     = 0x1000   // Bit G4_IO1.
	TSC_IOHCR_G3_IO4_Pos = 0xb      // Position of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Msk = 0x800    // Bit mask of G3_IO4 field.
	TSC_IOHCR_G3_IO4     = 0x800    // Bit G3_IO4.
	TSC_IOHCR_G3_IO3_Pos = 0xa      // Position of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Msk = 0x400    // Bit mask of G3_IO3 field.
	TSC_IOHCR_G3_IO3     = 0x400    // Bit G3_IO3.
	TSC_IOHCR_G3_IO2_Pos = 0x9      // Position of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Msk = 0x200    // Bit mask of G3_IO2 field.
	TSC_IOHCR_G3_IO2     = 0x200    // Bit G3_IO2.
	TSC_IOHCR_G3_IO1_Pos = 0x8      // Position of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Msk = 0x100    // Bit mask of G3_IO1 field.
	TSC_IOHCR_G3_IO1     = 0x100    // Bit G3_IO1.
	TSC_IOHCR_G2_IO4_Pos = 0x7      // Position of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Msk = 0x80     // Bit mask of G2_IO4 field.
	TSC_IOHCR_G2_IO4     = 0x80     // Bit G2_IO4.
	TSC_IOHCR_G2_IO3_Pos = 0x6      // Position of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Msk = 0x40     // Bit mask of G2_IO3 field.
	TSC_IOHCR_G2_IO3     = 0x40     // Bit G2_IO3.
	TSC_IOHCR_G2_IO2_Pos = 0x5      // Position of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Msk = 0x20     // Bit mask of G2_IO2 field.
	TSC_IOHCR_G2_IO2     = 0x20     // Bit G2_IO2.
	TSC_IOHCR_G2_IO1_Pos = 0x4      // Position of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Msk = 0x10     // Bit mask of G2_IO1 field.
	TSC_IOHCR_G2_IO1     = 0x10     // Bit G2_IO1.
	TSC_IOHCR_G1_IO4_Pos = 0x3      // Position of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Msk = 0x8      // Bit mask of G1_IO4 field.
	TSC_IOHCR_G1_IO4     = 0x8      // Bit G1_IO4.
	TSC_IOHCR_G1_IO3_Pos = 0x2      // Position of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Msk = 0x4      // Bit mask of G1_IO3 field.
	TSC_IOHCR_G1_IO3     = 0x4      // Bit G1_IO3.
	TSC_IOHCR_G1_IO2_Pos = 0x1      // Position of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Msk = 0x2      // Bit mask of G1_IO2 field.
	TSC_IOHCR_G1_IO2     = 0x2      // Bit G1_IO2.
	TSC_IOHCR_G1_IO1_Pos = 0x0      // Position of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Msk = 0x1      // Bit mask of G1_IO1 field.
	TSC_IOHCR_G1_IO1     = 0x1      // Bit G1_IO1.

	// IOASCR: I/O analog switch control           register
	TSC_IOASCR_G6_IO4_Pos = 0x17     // Position of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Msk = 0x800000 // Bit mask of G6_IO4 field.
	TSC_IOASCR_G6_IO4     = 0x800000 // Bit G6_IO4.
	TSC_IOASCR_G6_IO3_Pos = 0x16     // Position of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Msk = 0x400000 // Bit mask of G6_IO3 field.
	TSC_IOASCR_G6_IO3     = 0x400000 // Bit G6_IO3.
	TSC_IOASCR_G6_IO2_Pos = 0x15     // Position of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Msk = 0x200000 // Bit mask of G6_IO2 field.
	TSC_IOASCR_G6_IO2     = 0x200000 // Bit G6_IO2.
	TSC_IOASCR_G6_IO1_Pos = 0x14     // Position of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Msk = 0x100000 // Bit mask of G6_IO1 field.
	TSC_IOASCR_G6_IO1     = 0x100000 // Bit G6_IO1.
	TSC_IOASCR_G5_IO4_Pos = 0x13     // Position of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Msk = 0x80000  // Bit mask of G5_IO4 field.
	TSC_IOASCR_G5_IO4     = 0x80000  // Bit G5_IO4.
	TSC_IOASCR_G5_IO3_Pos = 0x12     // Position of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Msk = 0x40000  // Bit mask of G5_IO3 field.
	TSC_IOASCR_G5_IO3     = 0x40000  // Bit G5_IO3.
	TSC_IOASCR_G5_IO2_Pos = 0x11     // Position of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Msk = 0x20000  // Bit mask of G5_IO2 field.
	TSC_IOASCR_G5_IO2     = 0x20000  // Bit G5_IO2.
	TSC_IOASCR_G5_IO1_Pos = 0x10     // Position of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Msk = 0x10000  // Bit mask of G5_IO1 field.
	TSC_IOASCR_G5_IO1     = 0x10000  // Bit G5_IO1.
	TSC_IOASCR_G4_IO4_Pos = 0xf      // Position of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Msk = 0x8000   // Bit mask of G4_IO4 field.
	TSC_IOASCR_G4_IO4     = 0x8000   // Bit G4_IO4.
	TSC_IOASCR_G4_IO3_Pos = 0xe      // Position of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Msk = 0x4000   // Bit mask of G4_IO3 field.
	TSC_IOASCR_G4_IO3     = 0x4000   // Bit G4_IO3.
	TSC_IOASCR_G4_IO2_Pos = 0xd      // Position of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Msk = 0x2000   // Bit mask of G4_IO2 field.
	TSC_IOASCR_G4_IO2     = 0x2000   // Bit G4_IO2.
	TSC_IOASCR_G4_IO1_Pos = 0xc      // Position of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Msk = 0x1000   // Bit mask of G4_IO1 field.
	TSC_IOASCR_G4_IO1     = 0x1000   // Bit G4_IO1.
	TSC_IOASCR_G3_IO4_Pos = 0xb      // Position of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Msk = 0x800    // Bit mask of G3_IO4 field.
	TSC_IOASCR_G3_IO4     = 0x800    // Bit G3_IO4.
	TSC_IOASCR_G3_IO3_Pos = 0xa      // Position of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Msk = 0x400    // Bit mask of G3_IO3 field.
	TSC_IOASCR_G3_IO3     = 0x400    // Bit G3_IO3.
	TSC_IOASCR_G3_IO2_Pos = 0x9      // Position of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Msk = 0x200    // Bit mask of G3_IO2 field.
	TSC_IOASCR_G3_IO2     = 0x200    // Bit G3_IO2.
	TSC_IOASCR_G3_IO1_Pos = 0x8      // Position of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Msk = 0x100    // Bit mask of G3_IO1 field.
	TSC_IOASCR_G3_IO1     = 0x100    // Bit G3_IO1.
	TSC_IOASCR_G2_IO4_Pos = 0x7      // Position of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Msk = 0x80     // Bit mask of G2_IO4 field.
	TSC_IOASCR_G2_IO4     = 0x80     // Bit G2_IO4.
	TSC_IOASCR_G2_IO3_Pos = 0x6      // Position of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Msk = 0x40     // Bit mask of G2_IO3 field.
	TSC_IOASCR_G2_IO3     = 0x40     // Bit G2_IO3.
	TSC_IOASCR_G2_IO2_Pos = 0x5      // Position of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Msk = 0x20     // Bit mask of G2_IO2 field.
	TSC_IOASCR_G2_IO2     = 0x20     // Bit G2_IO2.
	TSC_IOASCR_G2_IO1_Pos = 0x4      // Position of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Msk = 0x10     // Bit mask of G2_IO1 field.
	TSC_IOASCR_G2_IO1     = 0x10     // Bit G2_IO1.
	TSC_IOASCR_G1_IO4_Pos = 0x3      // Position of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Msk = 0x8      // Bit mask of G1_IO4 field.
	TSC_IOASCR_G1_IO4     = 0x8      // Bit G1_IO4.
	TSC_IOASCR_G1_IO3_Pos = 0x2      // Position of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Msk = 0x4      // Bit mask of G1_IO3 field.
	TSC_IOASCR_G1_IO3     = 0x4      // Bit G1_IO3.
	TSC_IOASCR_G1_IO2_Pos = 0x1      // Position of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Msk = 0x2      // Bit mask of G1_IO2 field.
	TSC_IOASCR_G1_IO2     = 0x2      // Bit G1_IO2.
	TSC_IOASCR_G1_IO1_Pos = 0x0      // Position of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Msk = 0x1      // Bit mask of G1_IO1 field.
	TSC_IOASCR_G1_IO1     = 0x1      // Bit G1_IO1.

	// IOSCR: I/O sampling control register
	TSC_IOSCR_G6_IO4_Pos = 0x17     // Position of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Msk = 0x800000 // Bit mask of G6_IO4 field.
	TSC_IOSCR_G6_IO4     = 0x800000 // Bit G6_IO4.
	TSC_IOSCR_G6_IO3_Pos = 0x16     // Position of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Msk = 0x400000 // Bit mask of G6_IO3 field.
	TSC_IOSCR_G6_IO3     = 0x400000 // Bit G6_IO3.
	TSC_IOSCR_G6_IO2_Pos = 0x15     // Position of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Msk = 0x200000 // Bit mask of G6_IO2 field.
	TSC_IOSCR_G6_IO2     = 0x200000 // Bit G6_IO2.
	TSC_IOSCR_G6_IO1_Pos = 0x14     // Position of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Msk = 0x100000 // Bit mask of G6_IO1 field.
	TSC_IOSCR_G6_IO1     = 0x100000 // Bit G6_IO1.
	TSC_IOSCR_G5_IO4_Pos = 0x13     // Position of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Msk = 0x80000  // Bit mask of G5_IO4 field.
	TSC_IOSCR_G5_IO4     = 0x80000  // Bit G5_IO4.
	TSC_IOSCR_G5_IO3_Pos = 0x12     // Position of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Msk = 0x40000  // Bit mask of G5_IO3 field.
	TSC_IOSCR_G5_IO3     = 0x40000  // Bit G5_IO3.
	TSC_IOSCR_G5_IO2_Pos = 0x11     // Position of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Msk = 0x20000  // Bit mask of G5_IO2 field.
	TSC_IOSCR_G5_IO2     = 0x20000  // Bit G5_IO2.
	TSC_IOSCR_G5_IO1_Pos = 0x10     // Position of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Msk = 0x10000  // Bit mask of G5_IO1 field.
	TSC_IOSCR_G5_IO1     = 0x10000  // Bit G5_IO1.
	TSC_IOSCR_G4_IO4_Pos = 0xf      // Position of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Msk = 0x8000   // Bit mask of G4_IO4 field.
	TSC_IOSCR_G4_IO4     = 0x8000   // Bit G4_IO4.
	TSC_IOSCR_G4_IO3_Pos = 0xe      // Position of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Msk = 0x4000   // Bit mask of G4_IO3 field.
	TSC_IOSCR_G4_IO3     = 0x4000   // Bit G4_IO3.
	TSC_IOSCR_G4_IO2_Pos = 0xd      // Position of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Msk = 0x2000   // Bit mask of G4_IO2 field.
	TSC_IOSCR_G4_IO2     = 0x2000   // Bit G4_IO2.
	TSC_IOSCR_G4_IO1_Pos = 0xc      // Position of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Msk = 0x1000   // Bit mask of G4_IO1 field.
	TSC_IOSCR_G4_IO1     = 0x1000   // Bit G4_IO1.
	TSC_IOSCR_G3_IO4_Pos = 0xb      // Position of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Msk = 0x800    // Bit mask of G3_IO4 field.
	TSC_IOSCR_G3_IO4     = 0x800    // Bit G3_IO4.
	TSC_IOSCR_G3_IO3_Pos = 0xa      // Position of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Msk = 0x400    // Bit mask of G3_IO3 field.
	TSC_IOSCR_G3_IO3     = 0x400    // Bit G3_IO3.
	TSC_IOSCR_G3_IO2_Pos = 0x9      // Position of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Msk = 0x200    // Bit mask of G3_IO2 field.
	TSC_IOSCR_G3_IO2     = 0x200    // Bit G3_IO2.
	TSC_IOSCR_G3_IO1_Pos = 0x8      // Position of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Msk = 0x100    // Bit mask of G3_IO1 field.
	TSC_IOSCR_G3_IO1     = 0x100    // Bit G3_IO1.
	TSC_IOSCR_G2_IO4_Pos = 0x7      // Position of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Msk = 0x80     // Bit mask of G2_IO4 field.
	TSC_IOSCR_G2_IO4     = 0x80     // Bit G2_IO4.
	TSC_IOSCR_G2_IO3_Pos = 0x6      // Position of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Msk = 0x40     // Bit mask of G2_IO3 field.
	TSC_IOSCR_G2_IO3     = 0x40     // Bit G2_IO3.
	TSC_IOSCR_G2_IO2_Pos = 0x5      // Position of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Msk = 0x20     // Bit mask of G2_IO2 field.
	TSC_IOSCR_G2_IO2     = 0x20     // Bit G2_IO2.
	TSC_IOSCR_G2_IO1_Pos = 0x4      // Position of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Msk = 0x10     // Bit mask of G2_IO1 field.
	TSC_IOSCR_G2_IO1     = 0x10     // Bit G2_IO1.
	TSC_IOSCR_G1_IO4_Pos = 0x3      // Position of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Msk = 0x8      // Bit mask of G1_IO4 field.
	TSC_IOSCR_G1_IO4     = 0x8      // Bit G1_IO4.
	TSC_IOSCR_G1_IO3_Pos = 0x2      // Position of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Msk = 0x4      // Bit mask of G1_IO3 field.
	TSC_IOSCR_G1_IO3     = 0x4      // Bit G1_IO3.
	TSC_IOSCR_G1_IO2_Pos = 0x1      // Position of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Msk = 0x2      // Bit mask of G1_IO2 field.
	TSC_IOSCR_G1_IO2     = 0x2      // Bit G1_IO2.
	TSC_IOSCR_G1_IO1_Pos = 0x0      // Position of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Msk = 0x1      // Bit mask of G1_IO1 field.
	TSC_IOSCR_G1_IO1     = 0x1      // Bit G1_IO1.

	// IOCCR: I/O channel control register
	TSC_IOCCR_G6_IO4_Pos = 0x17     // Position of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Msk = 0x800000 // Bit mask of G6_IO4 field.
	TSC_IOCCR_G6_IO4     = 0x800000 // Bit G6_IO4.
	TSC_IOCCR_G6_IO3_Pos = 0x16     // Position of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Msk = 0x400000 // Bit mask of G6_IO3 field.
	TSC_IOCCR_G6_IO3     = 0x400000 // Bit G6_IO3.
	TSC_IOCCR_G6_IO2_Pos = 0x15     // Position of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Msk = 0x200000 // Bit mask of G6_IO2 field.
	TSC_IOCCR_G6_IO2     = 0x200000 // Bit G6_IO2.
	TSC_IOCCR_G6_IO1_Pos = 0x14     // Position of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Msk = 0x100000 // Bit mask of G6_IO1 field.
	TSC_IOCCR_G6_IO1     = 0x100000 // Bit G6_IO1.
	TSC_IOCCR_G5_IO4_Pos = 0x13     // Position of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Msk = 0x80000  // Bit mask of G5_IO4 field.
	TSC_IOCCR_G5_IO4     = 0x80000  // Bit G5_IO4.
	TSC_IOCCR_G5_IO3_Pos = 0x12     // Position of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Msk = 0x40000  // Bit mask of G5_IO3 field.
	TSC_IOCCR_G5_IO3     = 0x40000  // Bit G5_IO3.
	TSC_IOCCR_G5_IO2_Pos = 0x11     // Position of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Msk = 0x20000  // Bit mask of G5_IO2 field.
	TSC_IOCCR_G5_IO2     = 0x20000  // Bit G5_IO2.
	TSC_IOCCR_G5_IO1_Pos = 0x10     // Position of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Msk = 0x10000  // Bit mask of G5_IO1 field.
	TSC_IOCCR_G5_IO1     = 0x10000  // Bit G5_IO1.
	TSC_IOCCR_G4_IO4_Pos = 0xf      // Position of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Msk = 0x8000   // Bit mask of G4_IO4 field.
	TSC_IOCCR_G4_IO4     = 0x8000   // Bit G4_IO4.
	TSC_IOCCR_G4_IO3_Pos = 0xe      // Position of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Msk = 0x4000   // Bit mask of G4_IO3 field.
	TSC_IOCCR_G4_IO3     = 0x4000   // Bit G4_IO3.
	TSC_IOCCR_G4_IO2_Pos = 0xd      // Position of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Msk = 0x2000   // Bit mask of G4_IO2 field.
	TSC_IOCCR_G4_IO2     = 0x2000   // Bit G4_IO2.
	TSC_IOCCR_G4_IO1_Pos = 0xc      // Position of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Msk = 0x1000   // Bit mask of G4_IO1 field.
	TSC_IOCCR_G4_IO1     = 0x1000   // Bit G4_IO1.
	TSC_IOCCR_G3_IO4_Pos = 0xb      // Position of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Msk = 0x800    // Bit mask of G3_IO4 field.
	TSC_IOCCR_G3_IO4     = 0x800    // Bit G3_IO4.
	TSC_IOCCR_G3_IO3_Pos = 0xa      // Position of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Msk = 0x400    // Bit mask of G3_IO3 field.
	TSC_IOCCR_G3_IO3     = 0x400    // Bit G3_IO3.
	TSC_IOCCR_G3_IO2_Pos = 0x9      // Position of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Msk = 0x200    // Bit mask of G3_IO2 field.
	TSC_IOCCR_G3_IO2     = 0x200    // Bit G3_IO2.
	TSC_IOCCR_G3_IO1_Pos = 0x8      // Position of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Msk = 0x100    // Bit mask of G3_IO1 field.
	TSC_IOCCR_G3_IO1     = 0x100    // Bit G3_IO1.
	TSC_IOCCR_G2_IO4_Pos = 0x7      // Position of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Msk = 0x80     // Bit mask of G2_IO4 field.
	TSC_IOCCR_G2_IO4     = 0x80     // Bit G2_IO4.
	TSC_IOCCR_G2_IO3_Pos = 0x6      // Position of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Msk = 0x40     // Bit mask of G2_IO3 field.
	TSC_IOCCR_G2_IO3     = 0x40     // Bit G2_IO3.
	TSC_IOCCR_G2_IO2_Pos = 0x5      // Position of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Msk = 0x20     // Bit mask of G2_IO2 field.
	TSC_IOCCR_G2_IO2     = 0x20     // Bit G2_IO2.
	TSC_IOCCR_G2_IO1_Pos = 0x4      // Position of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Msk = 0x10     // Bit mask of G2_IO1 field.
	TSC_IOCCR_G2_IO1     = 0x10     // Bit G2_IO1.
	TSC_IOCCR_G1_IO4_Pos = 0x3      // Position of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Msk = 0x8      // Bit mask of G1_IO4 field.
	TSC_IOCCR_G1_IO4     = 0x8      // Bit G1_IO4.
	TSC_IOCCR_G1_IO3_Pos = 0x2      // Position of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Msk = 0x4      // Bit mask of G1_IO3 field.
	TSC_IOCCR_G1_IO3     = 0x4      // Bit G1_IO3.
	TSC_IOCCR_G1_IO2_Pos = 0x1      // Position of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Msk = 0x2      // Bit mask of G1_IO2 field.
	TSC_IOCCR_G1_IO2     = 0x2      // Bit G1_IO2.
	TSC_IOCCR_G1_IO1_Pos = 0x0      // Position of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Msk = 0x1      // Bit mask of G1_IO1 field.
	TSC_IOCCR_G1_IO1     = 0x1      // Bit G1_IO1.

	// IOGCSR: I/O group control status           register
	TSC_IOGCSR_G8S_Pos = 0x17     // Position of G8S field.
	TSC_IOGCSR_G8S_Msk = 0x800000 // Bit mask of G8S field.
	TSC_IOGCSR_G8S     = 0x800000 // Bit G8S.
	TSC_IOGCSR_G7S_Pos = 0x16     // Position of G7S field.
	TSC_IOGCSR_G7S_Msk = 0x400000 // Bit mask of G7S field.
	TSC_IOGCSR_G7S     = 0x400000 // Bit G7S.
	TSC_IOGCSR_G6S_Pos = 0x15     // Position of G6S field.
	TSC_IOGCSR_G6S_Msk = 0x200000 // Bit mask of G6S field.
	TSC_IOGCSR_G6S     = 0x200000 // Bit G6S.
	TSC_IOGCSR_G5S_Pos = 0x14     // Position of G5S field.
	TSC_IOGCSR_G5S_Msk = 0x100000 // Bit mask of G5S field.
	TSC_IOGCSR_G5S     = 0x100000 // Bit G5S.
	TSC_IOGCSR_G4S_Pos = 0x13     // Position of G4S field.
	TSC_IOGCSR_G4S_Msk = 0x80000  // Bit mask of G4S field.
	TSC_IOGCSR_G4S     = 0x80000  // Bit G4S.
	TSC_IOGCSR_G3S_Pos = 0x12     // Position of G3S field.
	TSC_IOGCSR_G3S_Msk = 0x40000  // Bit mask of G3S field.
	TSC_IOGCSR_G3S     = 0x40000  // Bit G3S.
	TSC_IOGCSR_G2S_Pos = 0x11     // Position of G2S field.
	TSC_IOGCSR_G2S_Msk = 0x20000  // Bit mask of G2S field.
	TSC_IOGCSR_G2S     = 0x20000  // Bit G2S.
	TSC_IOGCSR_G1S_Pos = 0x10     // Position of G1S field.
	TSC_IOGCSR_G1S_Msk = 0x10000  // Bit mask of G1S field.
	TSC_IOGCSR_G1S     = 0x10000  // Bit G1S.
	TSC_IOGCSR_G8E_Pos = 0x7      // Position of G8E field.
	TSC_IOGCSR_G8E_Msk = 0x80     // Bit mask of G8E field.
	TSC_IOGCSR_G8E     = 0x80     // Bit G8E.
	TSC_IOGCSR_G7E_Pos = 0x6      // Position of G7E field.
	TSC_IOGCSR_G7E_Msk = 0x40     // Bit mask of G7E field.
	TSC_IOGCSR_G7E     = 0x40     // Bit G7E.
	TSC_IOGCSR_G6E_Pos = 0x5      // Position of G6E field.
	TSC_IOGCSR_G6E_Msk = 0x20     // Bit mask of G6E field.
	TSC_IOGCSR_G6E     = 0x20     // Bit G6E.
	TSC_IOGCSR_G5E_Pos = 0x4      // Position of G5E field.
	TSC_IOGCSR_G5E_Msk = 0x10     // Bit mask of G5E field.
	TSC_IOGCSR_G5E     = 0x10     // Bit G5E.
	TSC_IOGCSR_G4E_Pos = 0x3      // Position of G4E field.
	TSC_IOGCSR_G4E_Msk = 0x8      // Bit mask of G4E field.
	TSC_IOGCSR_G4E     = 0x8      // Bit G4E.
	TSC_IOGCSR_G3E_Pos = 0x2      // Position of G3E field.
	TSC_IOGCSR_G3E_Msk = 0x4      // Bit mask of G3E field.
	TSC_IOGCSR_G3E     = 0x4      // Bit G3E.
	TSC_IOGCSR_G2E_Pos = 0x1      // Position of G2E field.
	TSC_IOGCSR_G2E_Msk = 0x2      // Bit mask of G2E field.
	TSC_IOGCSR_G2E     = 0x2      // Bit G2E.
	TSC_IOGCSR_G1E_Pos = 0x0      // Position of G1E field.
	TSC_IOGCSR_G1E_Msk = 0x1      // Bit mask of G1E field.
	TSC_IOGCSR_G1E     = 0x1      // Bit G1E.

	// IOG1CR: I/O group x counter register
	TSC_IOG1CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG1CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG2CR: I/O group x counter register
	TSC_IOG2CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG2CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG3CR: I/O group x counter register
	TSC_IOG3CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG3CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG4CR: I/O group x counter register
	TSC_IOG4CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG4CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG5CR: I/O group x counter register
	TSC_IOG5CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG5CR_CNT_Msk = 0x3fff // Bit mask of CNT field.

	// IOG6CR: I/O group x counter register
	TSC_IOG6CR_CNT_Pos = 0x0    // Position of CNT field.
	TSC_IOG6CR_CNT_Msk = 0x3fff // Bit mask of CNT field.
)

// Bitfields for CEC: HDMI-CEC controller
const (
	// CR: control register
	CEC_CR_TXEOM_Pos = 0x2 // Position of TXEOM field.
	CEC_CR_TXEOM_Msk = 0x4 // Bit mask of TXEOM field.
	CEC_CR_TXEOM     = 0x4 // Bit TXEOM.
	CEC_CR_TXSOM_Pos = 0x1 // Position of TXSOM field.
	CEC_CR_TXSOM_Msk = 0x2 // Bit mask of TXSOM field.
	CEC_CR_TXSOM     = 0x2 // Bit TXSOM.
	CEC_CR_CECEN_Pos = 0x0 // Position of CECEN field.
	CEC_CR_CECEN_Msk = 0x1 // Bit mask of CECEN field.
	CEC_CR_CECEN     = 0x1 // Bit CECEN.

	// CFGR: configuration register
	CEC_CFGR_LBPEGEN_Pos = 0xb   // Position of LBPEGEN field.
	CEC_CFGR_LBPEGEN_Msk = 0x800 // Bit mask of LBPEGEN field.
	CEC_CFGR_LBPEGEN     = 0x800 // Bit LBPEGEN.
	CEC_CFGR_BREGEN_Pos  = 0xa   // Position of BREGEN field.
	CEC_CFGR_BREGEN_Msk  = 0x400 // Bit mask of BREGEN field.
	CEC_CFGR_BREGEN      = 0x400 // Bit BREGEN.
	CEC_CFGR_BRESTP_Pos  = 0x9   // Position of BRESTP field.
	CEC_CFGR_BRESTP_Msk  = 0x200 // Bit mask of BRESTP field.
	CEC_CFGR_BRESTP      = 0x200 // Bit BRESTP.
	CEC_CFGR_RXTOL_Pos   = 0x8   // Position of RXTOL field.
	CEC_CFGR_RXTOL_Msk   = 0x100 // Bit mask of RXTOL field.
	CEC_CFGR_RXTOL       = 0x100 // Bit RXTOL.
	CEC_CFGR_SFT_Pos     = 0x5   // Position of SFT field.
	CEC_CFGR_SFT_Msk     = 0xe0  // Bit mask of SFT field.
	CEC_CFGR_LSTN_Pos    = 0x4   // Position of LSTN field.
	CEC_CFGR_LSTN_Msk    = 0x10  // Bit mask of LSTN field.
	CEC_CFGR_LSTN        = 0x10  // Bit LSTN.
	CEC_CFGR_OAR_Pos     = 0x0   // Position of OAR field.
	CEC_CFGR_OAR_Msk     = 0xf   // Bit mask of OAR field.

	// TXDR: Tx data register
	CEC_TXDR_TXD_Pos = 0x0  // Position of TXD field.
	CEC_TXDR_TXD_Msk = 0xff // Bit mask of TXD field.

	// RXDR: Rx Data Register
	CEC_RXDR_RXDR_Pos = 0x0  // Position of RXDR field.
	CEC_RXDR_RXDR_Msk = 0xff // Bit mask of RXDR field.

	// ISR: Interrupt and Status Register
	CEC_ISR_TXACKE_Pos = 0xc    // Position of TXACKE field.
	CEC_ISR_TXACKE_Msk = 0x1000 // Bit mask of TXACKE field.
	CEC_ISR_TXACKE     = 0x1000 // Bit TXACKE.
	CEC_ISR_TXERR_Pos  = 0xb    // Position of TXERR field.
	CEC_ISR_TXERR_Msk  = 0x800  // Bit mask of TXERR field.
	CEC_ISR_TXERR      = 0x800  // Bit TXERR.
	CEC_ISR_TXUDR_Pos  = 0xa    // Position of TXUDR field.
	CEC_ISR_TXUDR_Msk  = 0x400  // Bit mask of TXUDR field.
	CEC_ISR_TXUDR      = 0x400  // Bit TXUDR.
	CEC_ISR_TXEND_Pos  = 0x9    // Position of TXEND field.
	CEC_ISR_TXEND_Msk  = 0x200  // Bit mask of TXEND field.
	CEC_ISR_TXEND      = 0x200  // Bit TXEND.
	CEC_ISR_TXBR_Pos   = 0x8    // Position of TXBR field.
	CEC_ISR_TXBR_Msk   = 0x100  // Bit mask of TXBR field.
	CEC_ISR_TXBR       = 0x100  // Bit TXBR.
	CEC_ISR_ARBLST_Pos = 0x7    // Position of ARBLST field.
	CEC_ISR_ARBLST_Msk = 0x80   // Bit mask of ARBLST field.
	CEC_ISR_ARBLST     = 0x80   // Bit ARBLST.
	CEC_ISR_RXACKE_Pos = 0x6    // Position of RXACKE field.
	CEC_ISR_RXACKE_Msk = 0x40   // Bit mask of RXACKE field.
	CEC_ISR_RXACKE     = 0x40   // Bit RXACKE.
	CEC_ISR_LBPE_Pos   = 0x5    // Position of LBPE field.
	CEC_ISR_LBPE_Msk   = 0x20   // Bit mask of LBPE field.
	CEC_ISR_LBPE       = 0x20   // Bit LBPE.
	CEC_ISR_SBPE_Pos   = 0x4    // Position of SBPE field.
	CEC_ISR_SBPE_Msk   = 0x10   // Bit mask of SBPE field.
	CEC_ISR_SBPE       = 0x10   // Bit SBPE.
	CEC_ISR_BRE_Pos    = 0x3    // Position of BRE field.
	CEC_ISR_BRE_Msk    = 0x8    // Bit mask of BRE field.
	CEC_ISR_BRE        = 0x8    // Bit BRE.
	CEC_ISR_RXOVR_Pos  = 0x2    // Position of RXOVR field.
	CEC_ISR_RXOVR_Msk  = 0x4    // Bit mask of RXOVR field.
	CEC_ISR_RXOVR      = 0x4    // Bit RXOVR.
	CEC_ISR_RXEND_Pos  = 0x1    // Position of RXEND field.
	CEC_ISR_RXEND_Msk  = 0x2    // Bit mask of RXEND field.
	CEC_ISR_RXEND      = 0x2    // Bit RXEND.
	CEC_ISR_RXBR_Pos   = 0x0    // Position of RXBR field.
	CEC_ISR_RXBR_Msk   = 0x1    // Bit mask of RXBR field.
	CEC_ISR_RXBR       = 0x1    // Bit RXBR.

	// IER: interrupt enable register
	CEC_IER_TXACKIE_Pos  = 0xc    // Position of TXACKIE field.
	CEC_IER_TXACKIE_Msk  = 0x1000 // Bit mask of TXACKIE field.
	CEC_IER_TXACKIE      = 0x1000 // Bit TXACKIE.
	CEC_IER_TXERRIE_Pos  = 0xb    // Position of TXERRIE field.
	CEC_IER_TXERRIE_Msk  = 0x800  // Bit mask of TXERRIE field.
	CEC_IER_TXERRIE      = 0x800  // Bit TXERRIE.
	CEC_IER_TXUDRIE_Pos  = 0xa    // Position of TXUDRIE field.
	CEC_IER_TXUDRIE_Msk  = 0x400  // Bit mask of TXUDRIE field.
	CEC_IER_TXUDRIE      = 0x400  // Bit TXUDRIE.
	CEC_IER_TXENDIE_Pos  = 0x9    // Position of TXENDIE field.
	CEC_IER_TXENDIE_Msk  = 0x200  // Bit mask of TXENDIE field.
	CEC_IER_TXENDIE      = 0x200  // Bit TXENDIE.
	CEC_IER_TXBRIE_Pos   = 0x8    // Position of TXBRIE field.
	CEC_IER_TXBRIE_Msk   = 0x100  // Bit mask of TXBRIE field.
	CEC_IER_TXBRIE       = 0x100  // Bit TXBRIE.
	CEC_IER_ARBLSTIE_Pos = 0x7    // Position of ARBLSTIE field.
	CEC_IER_ARBLSTIE_Msk = 0x80   // Bit mask of ARBLSTIE field.
	CEC_IER_ARBLSTIE     = 0x80   // Bit ARBLSTIE.
	CEC_IER_RXACKIE_Pos  = 0x6    // Position of RXACKIE field.
	CEC_IER_RXACKIE_Msk  = 0x40   // Bit mask of RXACKIE field.
	CEC_IER_RXACKIE      = 0x40   // Bit RXACKIE.
	CEC_IER_LBPEIE_Pos   = 0x5    // Position of LBPEIE field.
	CEC_IER_LBPEIE_Msk   = 0x20   // Bit mask of LBPEIE field.
	CEC_IER_LBPEIE       = 0x20   // Bit LBPEIE.
	CEC_IER_SBPEIE_Pos   = 0x4    // Position of SBPEIE field.
	CEC_IER_SBPEIE_Msk   = 0x10   // Bit mask of SBPEIE field.
	CEC_IER_SBPEIE       = 0x10   // Bit SBPEIE.
	CEC_IER_BREIE_Pos    = 0x3    // Position of BREIE field.
	CEC_IER_BREIE_Msk    = 0x8    // Bit mask of BREIE field.
	CEC_IER_BREIE        = 0x8    // Bit BREIE.
	CEC_IER_RXOVRIE_Pos  = 0x2    // Position of RXOVRIE field.
	CEC_IER_RXOVRIE_Msk  = 0x4    // Bit mask of RXOVRIE field.
	CEC_IER_RXOVRIE      = 0x4    // Bit RXOVRIE.
	CEC_IER_RXENDIE_Pos  = 0x1    // Position of RXENDIE field.
	CEC_IER_RXENDIE_Msk  = 0x2    // Bit mask of RXENDIE field.
	CEC_IER_RXENDIE      = 0x2    // Bit RXENDIE.
	CEC_IER_RXBRIE_Pos   = 0x0    // Position of RXBRIE field.
	CEC_IER_RXBRIE_Msk   = 0x1    // Bit mask of RXBRIE field.
	CEC_IER_RXBRIE       = 0x1    // Bit RXBRIE.
)

// Bitfields for Flash: Flash
const (
	// ACR: Flash access control register
	Flash_ACR_LATENCY_Pos = 0x0  // Position of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0x7  // Bit mask of LATENCY field.
	Flash_ACR_PRFTBE_Pos  = 0x4  // Position of PRFTBE field.
	Flash_ACR_PRFTBE_Msk  = 0x10 // Bit mask of PRFTBE field.
	Flash_ACR_PRFTBE      = 0x10 // Bit PRFTBE.
	Flash_ACR_PRFTBS_Pos  = 0x5  // Position of PRFTBS field.
	Flash_ACR_PRFTBS_Msk  = 0x20 // Bit mask of PRFTBS field.
	Flash_ACR_PRFTBS      = 0x20 // Bit PRFTBS.

	// KEYR: Flash key register
	Flash_KEYR_FKEYR_Pos = 0x0        // Position of FKEYR field.
	Flash_KEYR_FKEYR_Msk = 0xffffffff // Bit mask of FKEYR field.

	// OPTKEYR: Flash option key register
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0        // Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff // Bit mask of OPTKEYR field.

	// SR: Flash status register
	Flash_SR_EOP_Pos   = 0x5  // Position of EOP field.
	Flash_SR_EOP_Msk   = 0x20 // Bit mask of EOP field.
	Flash_SR_EOP       = 0x20 // Bit EOP.
	Flash_SR_WRPRT_Pos = 0x4  // Position of WRPRT field.
	Flash_SR_WRPRT_Msk = 0x10 // Bit mask of WRPRT field.
	Flash_SR_WRPRT     = 0x10 // Bit WRPRT.
	Flash_SR_PGERR_Pos = 0x2  // Position of PGERR field.
	Flash_SR_PGERR_Msk = 0x4  // Bit mask of PGERR field.
	Flash_SR_PGERR     = 0x4  // Bit PGERR.
	Flash_SR_BSY_Pos   = 0x0  // Position of BSY field.
	Flash_SR_BSY_Msk   = 0x1  // Bit mask of BSY field.
	Flash_SR_BSY       = 0x1  // Bit BSY.

	// CR: Flash control register
	Flash_CR_FORCE_OPTLOAD_Pos = 0xd    // Position of FORCE_OPTLOAD field.
	Flash_CR_FORCE_OPTLOAD_Msk = 0x2000 // Bit mask of FORCE_OPTLOAD field.
	Flash_CR_FORCE_OPTLOAD     = 0x2000 // Bit FORCE_OPTLOAD.
	Flash_CR_EOPIE_Pos         = 0xc    // Position of EOPIE field.
	Flash_CR_EOPIE_Msk         = 0x1000 // Bit mask of EOPIE field.
	Flash_CR_EOPIE             = 0x1000 // Bit EOPIE.
	Flash_CR_ERRIE_Pos         = 0xa    // Position of ERRIE field.
	Flash_CR_ERRIE_Msk         = 0x400  // Bit mask of ERRIE field.
	Flash_CR_ERRIE             = 0x400  // Bit ERRIE.
	Flash_CR_OPTWRE_Pos        = 0x9    // Position of OPTWRE field.
	Flash_CR_OPTWRE_Msk        = 0x200  // Bit mask of OPTWRE field.
	Flash_CR_OPTWRE            = 0x200  // Bit OPTWRE.
	Flash_CR_LOCK_Pos          = 0x7    // Position of LOCK field.
	Flash_CR_LOCK_Msk          = 0x80   // Bit mask of LOCK field.
	Flash_CR_LOCK              = 0x80   // Bit LOCK.
	Flash_CR_STRT_Pos          = 0x6    // Position of STRT field.
	Flash_CR_STRT_Msk          = 0x40   // Bit mask of STRT field.
	Flash_CR_STRT              = 0x40   // Bit STRT.
	Flash_CR_OPTER_Pos         = 0x5    // Position of OPTER field.
	Flash_CR_OPTER_Msk         = 0x20   // Bit mask of OPTER field.
	Flash_CR_OPTER             = 0x20   // Bit OPTER.
	Flash_CR_OPTPG_Pos         = 0x4    // Position of OPTPG field.
	Flash_CR_OPTPG_Msk         = 0x10   // Bit mask of OPTPG field.
	Flash_CR_OPTPG             = 0x10   // Bit OPTPG.
	Flash_CR_MER_Pos           = 0x2    // Position of MER field.
	Flash_CR_MER_Msk           = 0x4    // Bit mask of MER field.
	Flash_CR_MER               = 0x4    // Bit MER.
	Flash_CR_PER_Pos           = 0x1    // Position of PER field.
	Flash_CR_PER_Msk           = 0x2    // Bit mask of PER field.
	Flash_CR_PER               = 0x2    // Bit PER.
	Flash_CR_PG_Pos            = 0x0    // Position of PG field.
	Flash_CR_PG_Msk            = 0x1    // Bit mask of PG field.
	Flash_CR_PG                = 0x1    // Bit PG.

	// AR: Flash address register
	Flash_AR_FAR_Pos = 0x0        // Position of FAR field.
	Flash_AR_FAR_Msk = 0xffffffff // Bit mask of FAR field.

	// OBR: Option byte register
	Flash_OBR_Data1_Pos        = 0x18       // Position of Data1 field.
	Flash_OBR_Data1_Msk        = 0xff000000 // Bit mask of Data1 field.
	Flash_OBR_Data0_Pos        = 0x10       // Position of Data0 field.
	Flash_OBR_Data0_Msk        = 0xff0000   // Bit mask of Data0 field.
	Flash_OBR_VDDA_MONITOR_Pos = 0xd        // Position of VDDA_MONITOR field.
	Flash_OBR_VDDA_MONITOR_Msk = 0x2000     // Bit mask of VDDA_MONITOR field.
	Flash_OBR_VDDA_MONITOR     = 0x2000     // Bit VDDA_MONITOR.
	Flash_OBR_BOOT1_Pos        = 0xc        // Position of BOOT1 field.
	Flash_OBR_BOOT1_Msk        = 0x1000     // Bit mask of BOOT1 field.
	Flash_OBR_BOOT1            = 0x1000     // Bit BOOT1.
	Flash_OBR_NRST_STDBY_Pos   = 0xa        // Position of NRST_STDBY field.
	Flash_OBR_NRST_STDBY_Msk   = 0x400      // Bit mask of NRST_STDBY field.
	Flash_OBR_NRST_STDBY       = 0x400      // Bit NRST_STDBY.
	Flash_OBR_NRST_STOP_Pos    = 0x9        // Position of NRST_STOP field.
	Flash_OBR_NRST_STOP_Msk    = 0x200      // Bit mask of NRST_STOP field.
	Flash_OBR_NRST_STOP        = 0x200      // Bit NRST_STOP.
	Flash_OBR_WDG_SW_Pos       = 0x8        // Position of WDG_SW field.
	Flash_OBR_WDG_SW_Msk       = 0x100      // Bit mask of WDG_SW field.
	Flash_OBR_WDG_SW           = 0x100      // Bit WDG_SW.
	Flash_OBR_LEVEL2_PROT_Pos  = 0x2        // Position of LEVEL2_PROT field.
	Flash_OBR_LEVEL2_PROT_Msk  = 0x4        // Bit mask of LEVEL2_PROT field.
	Flash_OBR_LEVEL2_PROT      = 0x4        // Bit LEVEL2_PROT.
	Flash_OBR_LEVEL1_PROT_Pos  = 0x1        // Position of LEVEL1_PROT field.
	Flash_OBR_LEVEL1_PROT_Msk  = 0x2        // Bit mask of LEVEL1_PROT field.
	Flash_OBR_LEVEL1_PROT      = 0x2        // Bit LEVEL1_PROT.
	Flash_OBR_OPTERR_Pos       = 0x0        // Position of OPTERR field.
	Flash_OBR_OPTERR_Msk       = 0x1        // Bit mask of OPTERR field.
	Flash_OBR_OPTERR           = 0x1        // Bit OPTERR.

	// WRPR: Write protection register
	Flash_WRPR_WRP_Pos = 0x0        // Position of WRP field.
	Flash_WRPR_WRP_Msk = 0xffffffff // Bit mask of WRP field.
)

// Bitfields for DBGMCU: Debug support
const (
	// IDCODE: MCU Device ID Code Register
	DBGMCU_IDCODE_DEV_ID_Pos = 0x0        // Position of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Msk = 0xfff      // Bit mask of DEV_ID field.
	DBGMCU_IDCODE_DIV_ID_Pos = 0xc        // Position of DIV_ID field.
	DBGMCU_IDCODE_DIV_ID_Msk = 0xf000     // Bit mask of DIV_ID field.
	DBGMCU_IDCODE_REV_ID_Pos = 0x10       // Position of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000 // Bit mask of REV_ID field.

	// CR: Debug MCU Configuration           Register
	DBGMCU_CR_DBG_STOP_Pos    = 0x1 // Position of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Msk    = 0x2 // Bit mask of DBG_STOP field.
	DBGMCU_CR_DBG_STOP        = 0x2 // Bit DBG_STOP.
	DBGMCU_CR_DBG_STANDBY_Pos = 0x2 // Position of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Msk = 0x4 // Bit mask of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY     = 0x4 // Bit DBG_STANDBY.

	// APBLFZ: APB Low Freeze Register
	DBGMCU_APBLFZ_DBG_TIMER2_STOP_Pos    = 0x0      // Position of DBG_TIMER2_STOP field.
	DBGMCU_APBLFZ_DBG_TIMER2_STOP_Msk    = 0x1      // Bit mask of DBG_TIMER2_STOP field.
	DBGMCU_APBLFZ_DBG_TIMER2_STOP        = 0x1      // Bit DBG_TIMER2_STOP.
	DBGMCU_APBLFZ_DBG_TIMER3_STOP_Pos    = 0x1      // Position of DBG_TIMER3_STOP field.
	DBGMCU_APBLFZ_DBG_TIMER3_STOP_Msk    = 0x2      // Bit mask of DBG_TIMER3_STOP field.
	DBGMCU_APBLFZ_DBG_TIMER3_STOP        = 0x2      // Bit DBG_TIMER3_STOP.
	DBGMCU_APBLFZ_DBG_TIMER6_STOP_Pos    = 0x4      // Position of DBG_TIMER6_STOP field.
	DBGMCU_APBLFZ_DBG_TIMER6_STOP_Msk    = 0x10     // Bit mask of DBG_TIMER6_STOP field.
	DBGMCU_APBLFZ_DBG_TIMER6_STOP        = 0x10     // Bit DBG_TIMER6_STOP.
	DBGMCU_APBLFZ_DBG_TIMER14_STOP_Pos   = 0x8      // Position of DBG_TIMER14_STOP field.
	DBGMCU_APBLFZ_DBG_TIMER14_STOP_Msk   = 0x100    // Bit mask of DBG_TIMER14_STOP field.
	DBGMCU_APBLFZ_DBG_TIMER14_STOP       = 0x100    // Bit DBG_TIMER14_STOP.
	DBGMCU_APBLFZ_DBG_RTC_STOP_Pos       = 0xa      // Position of DBG_RTC_STOP field.
	DBGMCU_APBLFZ_DBG_RTC_STOP_Msk       = 0x400    // Bit mask of DBG_RTC_STOP field.
	DBGMCU_APBLFZ_DBG_RTC_STOP           = 0x400    // Bit DBG_RTC_STOP.
	DBGMCU_APBLFZ_DBG_WWDG_STOP_Pos      = 0xb      // Position of DBG_WWDG_STOP field.
	DBGMCU_APBLFZ_DBG_WWDG_STOP_Msk      = 0x800    // Bit mask of DBG_WWDG_STOP field.
	DBGMCU_APBLFZ_DBG_WWDG_STOP          = 0x800    // Bit DBG_WWDG_STOP.
	DBGMCU_APBLFZ_DBG_IWDG_STOP_Pos      = 0xc      // Position of DBG_IWDG_STOP field.
	DBGMCU_APBLFZ_DBG_IWDG_STOP_Msk      = 0x1000   // Bit mask of DBG_IWDG_STOP field.
	DBGMCU_APBLFZ_DBG_IWDG_STOP          = 0x1000   // Bit DBG_IWDG_STOP.
	DBGMCU_APBLFZ_I2C1_SMBUS_TIMEOUT_Pos = 0x15     // Position of I2C1_SMBUS_TIMEOUT field.
	DBGMCU_APBLFZ_I2C1_SMBUS_TIMEOUT_Msk = 0x200000 // Bit mask of I2C1_SMBUS_TIMEOUT field.
	DBGMCU_APBLFZ_I2C1_SMBUS_TIMEOUT     = 0x200000 // Bit I2C1_SMBUS_TIMEOUT.

	// APBHFZ: APB High Freeze Register
	DBGMCU_APBHFZ_DBG_TIMER1_STOP_Pos = 0xb     // Position of DBG_TIMER1_STOP field.
	DBGMCU_APBHFZ_DBG_TIMER1_STOP_Msk = 0x800   // Bit mask of DBG_TIMER1_STOP field.
	DBGMCU_APBHFZ_DBG_TIMER1_STOP     = 0x800   // Bit DBG_TIMER1_STOP.
	DBGMCU_APBHFZ_DBG_TIMER15_STO_Pos = 0x10    // Position of DBG_TIMER15_STO field.
	DBGMCU_APBHFZ_DBG_TIMER15_STO_Msk = 0x10000 // Bit mask of DBG_TIMER15_STO field.
	DBGMCU_APBHFZ_DBG_TIMER15_STO     = 0x10000 // Bit DBG_TIMER15_STO.
	DBGMCU_APBHFZ_DBG_TIMER16_STO_Pos = 0x11    // Position of DBG_TIMER16_STO field.
	DBGMCU_APBHFZ_DBG_TIMER16_STO_Msk = 0x20000 // Bit mask of DBG_TIMER16_STO field.
	DBGMCU_APBHFZ_DBG_TIMER16_STO     = 0x20000 // Bit DBG_TIMER16_STO.
	DBGMCU_APBHFZ_DBG_TIMER17_STO_Pos = 0x12    // Position of DBG_TIMER17_STO field.
	DBGMCU_APBHFZ_DBG_TIMER17_STO_Msk = 0x40000 // Bit mask of DBG_TIMER17_STO field.
	DBGMCU_APBHFZ_DBG_TIMER17_STO     = 0x40000 // Bit DBG_TIMER17_STO.
)

// Bitfields for USB: Universal serial bus full-speed device interface
const (
	// EP0R: endpoint 0 register
	USB_EP0R_EA_Pos      = 0x0    // Position of EA field.
	USB_EP0R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_EP0R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_EP0R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_EP0R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_EP0R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_EP0R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_EP0R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_EP0R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_EP0R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_EP0R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_EP0R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_EP0R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_EP0R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_EP0R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_EP0R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_EP0R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_EP0R_SETUP       = 0x800  // Bit SETUP.
	USB_EP0R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_EP0R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_EP0R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_EP0R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_EP0R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_EP0R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_EP0R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_EP0R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// EP1R: endpoint 1 register
	USB_EP1R_EA_Pos      = 0x0    // Position of EA field.
	USB_EP1R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_EP1R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_EP1R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_EP1R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_EP1R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_EP1R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_EP1R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_EP1R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_EP1R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_EP1R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_EP1R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_EP1R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_EP1R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_EP1R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_EP1R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_EP1R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_EP1R_SETUP       = 0x800  // Bit SETUP.
	USB_EP1R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_EP1R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_EP1R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_EP1R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_EP1R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_EP1R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_EP1R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_EP1R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// EP2R: endpoint 2 register
	USB_EP2R_EA_Pos      = 0x0    // Position of EA field.
	USB_EP2R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_EP2R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_EP2R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_EP2R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_EP2R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_EP2R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_EP2R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_EP2R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_EP2R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_EP2R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_EP2R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_EP2R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_EP2R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_EP2R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_EP2R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_EP2R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_EP2R_SETUP       = 0x800  // Bit SETUP.
	USB_EP2R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_EP2R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_EP2R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_EP2R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_EP2R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_EP2R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_EP2R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_EP2R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// EP3R: endpoint 3 register
	USB_EP3R_EA_Pos      = 0x0    // Position of EA field.
	USB_EP3R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_EP3R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_EP3R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_EP3R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_EP3R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_EP3R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_EP3R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_EP3R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_EP3R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_EP3R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_EP3R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_EP3R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_EP3R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_EP3R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_EP3R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_EP3R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_EP3R_SETUP       = 0x800  // Bit SETUP.
	USB_EP3R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_EP3R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_EP3R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_EP3R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_EP3R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_EP3R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_EP3R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_EP3R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// EP4R: endpoint 4 register
	USB_EP4R_EA_Pos      = 0x0    // Position of EA field.
	USB_EP4R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_EP4R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_EP4R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_EP4R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_EP4R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_EP4R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_EP4R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_EP4R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_EP4R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_EP4R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_EP4R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_EP4R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_EP4R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_EP4R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_EP4R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_EP4R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_EP4R_SETUP       = 0x800  // Bit SETUP.
	USB_EP4R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_EP4R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_EP4R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_EP4R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_EP4R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_EP4R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_EP4R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_EP4R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// EP5R: endpoint 5 register
	USB_EP5R_EA_Pos      = 0x0    // Position of EA field.
	USB_EP5R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_EP5R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_EP5R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_EP5R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_EP5R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_EP5R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_EP5R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_EP5R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_EP5R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_EP5R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_EP5R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_EP5R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_EP5R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_EP5R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_EP5R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_EP5R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_EP5R_SETUP       = 0x800  // Bit SETUP.
	USB_EP5R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_EP5R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_EP5R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_EP5R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_EP5R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_EP5R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_EP5R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_EP5R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// EP6R: endpoint 6 register
	USB_EP6R_EA_Pos      = 0x0    // Position of EA field.
	USB_EP6R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_EP6R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_EP6R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_EP6R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_EP6R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_EP6R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_EP6R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_EP6R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_EP6R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_EP6R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_EP6R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_EP6R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_EP6R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_EP6R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_EP6R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_EP6R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_EP6R_SETUP       = 0x800  // Bit SETUP.
	USB_EP6R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_EP6R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_EP6R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_EP6R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_EP6R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_EP6R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_EP6R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_EP6R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// EP7R: endpoint 7 register
	USB_EP7R_EA_Pos      = 0x0    // Position of EA field.
	USB_EP7R_EA_Msk      = 0xf    // Bit mask of EA field.
	USB_EP7R_STAT_TX_Pos = 0x4    // Position of STAT_TX field.
	USB_EP7R_STAT_TX_Msk = 0x30   // Bit mask of STAT_TX field.
	USB_EP7R_DTOG_TX_Pos = 0x6    // Position of DTOG_TX field.
	USB_EP7R_DTOG_TX_Msk = 0x40   // Bit mask of DTOG_TX field.
	USB_EP7R_DTOG_TX     = 0x40   // Bit DTOG_TX.
	USB_EP7R_CTR_TX_Pos  = 0x7    // Position of CTR_TX field.
	USB_EP7R_CTR_TX_Msk  = 0x80   // Bit mask of CTR_TX field.
	USB_EP7R_CTR_TX      = 0x80   // Bit CTR_TX.
	USB_EP7R_EP_KIND_Pos = 0x8    // Position of EP_KIND field.
	USB_EP7R_EP_KIND_Msk = 0x100  // Bit mask of EP_KIND field.
	USB_EP7R_EP_KIND     = 0x100  // Bit EP_KIND.
	USB_EP7R_EP_TYPE_Pos = 0x9    // Position of EP_TYPE field.
	USB_EP7R_EP_TYPE_Msk = 0x600  // Bit mask of EP_TYPE field.
	USB_EP7R_SETUP_Pos   = 0xb    // Position of SETUP field.
	USB_EP7R_SETUP_Msk   = 0x800  // Bit mask of SETUP field.
	USB_EP7R_SETUP       = 0x800  // Bit SETUP.
	USB_EP7R_STAT_RX_Pos = 0xc    // Position of STAT_RX field.
	USB_EP7R_STAT_RX_Msk = 0x3000 // Bit mask of STAT_RX field.
	USB_EP7R_DTOG_RX_Pos = 0xe    // Position of DTOG_RX field.
	USB_EP7R_DTOG_RX_Msk = 0x4000 // Bit mask of DTOG_RX field.
	USB_EP7R_DTOG_RX     = 0x4000 // Bit DTOG_RX.
	USB_EP7R_CTR_RX_Pos  = 0xf    // Position of CTR_RX field.
	USB_EP7R_CTR_RX_Msk  = 0x8000 // Bit mask of CTR_RX field.
	USB_EP7R_CTR_RX      = 0x8000 // Bit CTR_RX.

	// CNTR: control register
	USB_CNTR_FRES_Pos     = 0x0    // Position of FRES field.
	USB_CNTR_FRES_Msk     = 0x1    // Bit mask of FRES field.
	USB_CNTR_FRES         = 0x1    // Bit FRES.
	USB_CNTR_PDWN_Pos     = 0x1    // Position of PDWN field.
	USB_CNTR_PDWN_Msk     = 0x2    // Bit mask of PDWN field.
	USB_CNTR_PDWN         = 0x2    // Bit PDWN.
	USB_CNTR_LPMODE_Pos   = 0x2    // Position of LPMODE field.
	USB_CNTR_LPMODE_Msk   = 0x4    // Bit mask of LPMODE field.
	USB_CNTR_LPMODE       = 0x4    // Bit LPMODE.
	USB_CNTR_FSUSP_Pos    = 0x3    // Position of FSUSP field.
	USB_CNTR_FSUSP_Msk    = 0x8    // Bit mask of FSUSP field.
	USB_CNTR_FSUSP        = 0x8    // Bit FSUSP.
	USB_CNTR_RESUME_Pos   = 0x4    // Position of RESUME field.
	USB_CNTR_RESUME_Msk   = 0x10   // Bit mask of RESUME field.
	USB_CNTR_RESUME       = 0x10   // Bit RESUME.
	USB_CNTR_L1RESUME_Pos = 0x5    // Position of L1RESUME field.
	USB_CNTR_L1RESUME_Msk = 0x20   // Bit mask of L1RESUME field.
	USB_CNTR_L1RESUME     = 0x20   // Bit L1RESUME.
	USB_CNTR_L1REQM_Pos   = 0x7    // Position of L1REQM field.
	USB_CNTR_L1REQM_Msk   = 0x80   // Bit mask of L1REQM field.
	USB_CNTR_L1REQM       = 0x80   // Bit L1REQM.
	USB_CNTR_ESOFM_Pos    = 0x8    // Position of ESOFM field.
	USB_CNTR_ESOFM_Msk    = 0x100  // Bit mask of ESOFM field.
	USB_CNTR_ESOFM        = 0x100  // Bit ESOFM.
	USB_CNTR_SOFM_Pos     = 0x9    // Position of SOFM field.
	USB_CNTR_SOFM_Msk     = 0x200  // Bit mask of SOFM field.
	USB_CNTR_SOFM         = 0x200  // Bit SOFM.
	USB_CNTR_RESETM_Pos   = 0xa    // Position of RESETM field.
	USB_CNTR_RESETM_Msk   = 0x400  // Bit mask of RESETM field.
	USB_CNTR_RESETM       = 0x400  // Bit RESETM.
	USB_CNTR_SUSPM_Pos    = 0xb    // Position of SUSPM field.
	USB_CNTR_SUSPM_Msk    = 0x800  // Bit mask of SUSPM field.
	USB_CNTR_SUSPM        = 0x800  // Bit SUSPM.
	USB_CNTR_WKUPM_Pos    = 0xc    // Position of WKUPM field.
	USB_CNTR_WKUPM_Msk    = 0x1000 // Bit mask of WKUPM field.
	USB_CNTR_WKUPM        = 0x1000 // Bit WKUPM.
	USB_CNTR_ERRM_Pos     = 0xd    // Position of ERRM field.
	USB_CNTR_ERRM_Msk     = 0x2000 // Bit mask of ERRM field.
	USB_CNTR_ERRM         = 0x2000 // Bit ERRM.
	USB_CNTR_PMAOVRM_Pos  = 0xe    // Position of PMAOVRM field.
	USB_CNTR_PMAOVRM_Msk  = 0x4000 // Bit mask of PMAOVRM field.
	USB_CNTR_PMAOVRM      = 0x4000 // Bit PMAOVRM.
	USB_CNTR_CTRM_Pos     = 0xf    // Position of CTRM field.
	USB_CNTR_CTRM_Msk     = 0x8000 // Bit mask of CTRM field.
	USB_CNTR_CTRM         = 0x8000 // Bit CTRM.

	// ISTR: interrupt status register
	USB_ISTR_EP_ID_Pos  = 0x0    // Position of EP_ID field.
	USB_ISTR_EP_ID_Msk  = 0xf    // Bit mask of EP_ID field.
	USB_ISTR_DIR_Pos    = 0x4    // Position of DIR field.
	USB_ISTR_DIR_Msk    = 0x10   // Bit mask of DIR field.
	USB_ISTR_DIR        = 0x10   // Bit DIR.
	USB_ISTR_L1REQ_Pos  = 0x7    // Position of L1REQ field.
	USB_ISTR_L1REQ_Msk  = 0x80   // Bit mask of L1REQ field.
	USB_ISTR_L1REQ      = 0x80   // Bit L1REQ.
	USB_ISTR_ESOF_Pos   = 0x8    // Position of ESOF field.
	USB_ISTR_ESOF_Msk   = 0x100  // Bit mask of ESOF field.
	USB_ISTR_ESOF       = 0x100  // Bit ESOF.
	USB_ISTR_SOF_Pos    = 0x9    // Position of SOF field.
	USB_ISTR_SOF_Msk    = 0x200  // Bit mask of SOF field.
	USB_ISTR_SOF        = 0x200  // Bit SOF.
	USB_ISTR_RESET_Pos  = 0xa    // Position of RESET field.
	USB_ISTR_RESET_Msk  = 0x400  // Bit mask of RESET field.
	USB_ISTR_RESET      = 0x400  // Bit RESET.
	USB_ISTR_SUSP_Pos   = 0xb    // Position of SUSP field.
	USB_ISTR_SUSP_Msk   = 0x800  // Bit mask of SUSP field.
	USB_ISTR_SUSP       = 0x800  // Bit SUSP.
	USB_ISTR_WKUP_Pos   = 0xc    // Position of WKUP field.
	USB_ISTR_WKUP_Msk   = 0x1000 // Bit mask of WKUP field.
	USB_ISTR_WKUP       = 0x1000 // Bit WKUP.
	USB_ISTR_ERR_Pos    = 0xd    // Position of ERR field.
	USB_ISTR_ERR_Msk    = 0x2000 // Bit mask of ERR field.
	USB_ISTR_ERR        = 0x2000 // Bit ERR.
	USB_ISTR_PMAOVR_Pos = 0xe    // Position of PMAOVR field.
	USB_ISTR_PMAOVR_Msk = 0x4000 // Bit mask of PMAOVR field.
	USB_ISTR_PMAOVR     = 0x4000 // Bit PMAOVR.
	USB_ISTR_CTR_Pos    = 0xf    // Position of CTR field.
	USB_ISTR_CTR_Msk    = 0x8000 // Bit mask of CTR field.
	USB_ISTR_CTR        = 0x8000 // Bit CTR.

	// FNR: frame number register
	USB_FNR_FN_Pos   = 0x0    // Position of FN field.
	USB_FNR_FN_Msk   = 0x7ff  // Bit mask of FN field.
	USB_FNR_LSOF_Pos = 0xb    // Position of LSOF field.
	USB_FNR_LSOF_Msk = 0x1800 // Bit mask of LSOF field.
	USB_FNR_LCK_Pos  = 0xd    // Position of LCK field.
	USB_FNR_LCK_Msk  = 0x2000 // Bit mask of LCK field.
	USB_FNR_LCK      = 0x2000 // Bit LCK.
	USB_FNR_RXDM_Pos = 0xe    // Position of RXDM field.
	USB_FNR_RXDM_Msk = 0x4000 // Bit mask of RXDM field.
	USB_FNR_RXDM     = 0x4000 // Bit RXDM.
	USB_FNR_RXDP_Pos = 0xf    // Position of RXDP field.
	USB_FNR_RXDP_Msk = 0x8000 // Bit mask of RXDP field.
	USB_FNR_RXDP     = 0x8000 // Bit RXDP.

	// DADDR: device address
	USB_DADDR_ADD_Pos = 0x0  // Position of ADD field.
	USB_DADDR_ADD_Msk = 0x7f // Bit mask of ADD field.
	USB_DADDR_EF_Pos  = 0x7  // Position of EF field.
	USB_DADDR_EF_Msk  = 0x80 // Bit mask of EF field.
	USB_DADDR_EF      = 0x80 // Bit EF.

	// BTABLE: Buffer table address
	USB_BTABLE_BTABLE_Pos = 0x3    // Position of BTABLE field.
	USB_BTABLE_BTABLE_Msk = 0xfff8 // Bit mask of BTABLE field.

	// LPMCSR: LPM control and status           register
	USB_LPMCSR_LPMEN_Pos   = 0x0  // Position of LPMEN field.
	USB_LPMCSR_LPMEN_Msk   = 0x1  // Bit mask of LPMEN field.
	USB_LPMCSR_LPMEN       = 0x1  // Bit LPMEN.
	USB_LPMCSR_LPMACK_Pos  = 0x1  // Position of LPMACK field.
	USB_LPMCSR_LPMACK_Msk  = 0x2  // Bit mask of LPMACK field.
	USB_LPMCSR_LPMACK      = 0x2  // Bit LPMACK.
	USB_LPMCSR_REMWAKE_Pos = 0x3  // Position of REMWAKE field.
	USB_LPMCSR_REMWAKE_Msk = 0x8  // Bit mask of REMWAKE field.
	USB_LPMCSR_REMWAKE     = 0x8  // Bit REMWAKE.
	USB_LPMCSR_BESL_Pos    = 0x4  // Position of BESL field.
	USB_LPMCSR_BESL_Msk    = 0xf0 // Bit mask of BESL field.

	// BCDR: Battery charging detector
	USB_BCDR_BCDEN_Pos  = 0x0    // Position of BCDEN field.
	USB_BCDR_BCDEN_Msk  = 0x1    // Bit mask of BCDEN field.
	USB_BCDR_BCDEN      = 0x1    // Bit BCDEN.
	USB_BCDR_DCDEN_Pos  = 0x1    // Position of DCDEN field.
	USB_BCDR_DCDEN_Msk  = 0x2    // Bit mask of DCDEN field.
	USB_BCDR_DCDEN      = 0x2    // Bit DCDEN.
	USB_BCDR_PDEN_Pos   = 0x2    // Position of PDEN field.
	USB_BCDR_PDEN_Msk   = 0x4    // Bit mask of PDEN field.
	USB_BCDR_PDEN       = 0x4    // Bit PDEN.
	USB_BCDR_SDEN_Pos   = 0x3    // Position of SDEN field.
	USB_BCDR_SDEN_Msk   = 0x8    // Bit mask of SDEN field.
	USB_BCDR_SDEN       = 0x8    // Bit SDEN.
	USB_BCDR_DCDET_Pos  = 0x4    // Position of DCDET field.
	USB_BCDR_DCDET_Msk  = 0x10   // Bit mask of DCDET field.
	USB_BCDR_DCDET      = 0x10   // Bit DCDET.
	USB_BCDR_PDET_Pos   = 0x5    // Position of PDET field.
	USB_BCDR_PDET_Msk   = 0x20   // Bit mask of PDET field.
	USB_BCDR_PDET       = 0x20   // Bit PDET.
	USB_BCDR_SDET_Pos   = 0x6    // Position of SDET field.
	USB_BCDR_SDET_Msk   = 0x40   // Bit mask of SDET field.
	USB_BCDR_SDET       = 0x40   // Bit SDET.
	USB_BCDR_PS2DET_Pos = 0x7    // Position of PS2DET field.
	USB_BCDR_PS2DET_Msk = 0x80   // Bit mask of PS2DET field.
	USB_BCDR_PS2DET     = 0x80   // Bit PS2DET.
	USB_BCDR_DPPU_Pos   = 0xf    // Position of DPPU field.
	USB_BCDR_DPPU_Msk   = 0x8000 // Bit mask of DPPU field.
	USB_BCDR_DPPU       = 0x8000 // Bit DPPU.
)

// Bitfields for CRS: Clock recovery system
const (
	// CR: control register
	CRS_CR_TRIM_Pos       = 0x8    // Position of TRIM field.
	CRS_CR_TRIM_Msk       = 0x3f00 // Bit mask of TRIM field.
	CRS_CR_SWSYNC_Pos     = 0x7    // Position of SWSYNC field.
	CRS_CR_SWSYNC_Msk     = 0x80   // Bit mask of SWSYNC field.
	CRS_CR_SWSYNC         = 0x80   // Bit SWSYNC.
	CRS_CR_AUTOTRIMEN_Pos = 0x6    // Position of AUTOTRIMEN field.
	CRS_CR_AUTOTRIMEN_Msk = 0x40   // Bit mask of AUTOTRIMEN field.
	CRS_CR_AUTOTRIMEN     = 0x40   // Bit AUTOTRIMEN.
	CRS_CR_CEN_Pos        = 0x5    // Position of CEN field.
	CRS_CR_CEN_Msk        = 0x20   // Bit mask of CEN field.
	CRS_CR_CEN            = 0x20   // Bit CEN.
	CRS_CR_ESYNCIE_Pos    = 0x3    // Position of ESYNCIE field.
	CRS_CR_ESYNCIE_Msk    = 0x8    // Bit mask of ESYNCIE field.
	CRS_CR_ESYNCIE        = 0x8    // Bit ESYNCIE.
	CRS_CR_ERRIE_Pos      = 0x2    // Position of ERRIE field.
	CRS_CR_ERRIE_Msk      = 0x4    // Bit mask of ERRIE field.
	CRS_CR_ERRIE          = 0x4    // Bit ERRIE.
	CRS_CR_SYNCWARNIE_Pos = 0x1    // Position of SYNCWARNIE field.
	CRS_CR_SYNCWARNIE_Msk = 0x2    // Bit mask of SYNCWARNIE field.
	CRS_CR_SYNCWARNIE     = 0x2    // Bit SYNCWARNIE.
	CRS_CR_SYNCOKIE_Pos   = 0x0    // Position of SYNCOKIE field.
	CRS_CR_SYNCOKIE_Msk   = 0x1    // Bit mask of SYNCOKIE field.
	CRS_CR_SYNCOKIE       = 0x1    // Bit SYNCOKIE.

	// CFGR: configuration register
	CRS_CFGR_SYNCPOL_Pos = 0x1f       // Position of SYNCPOL field.
	CRS_CFGR_SYNCPOL_Msk = 0x80000000 // Bit mask of SYNCPOL field.
	CRS_CFGR_SYNCPOL     = 0x80000000 // Bit SYNCPOL.
	CRS_CFGR_SYNCSRC_Pos = 0x1c       // Position of SYNCSRC field.
	CRS_CFGR_SYNCSRC_Msk = 0x30000000 // Bit mask of SYNCSRC field.
	CRS_CFGR_SYNCDIV_Pos = 0x18       // Position of SYNCDIV field.
	CRS_CFGR_SYNCDIV_Msk = 0x7000000  // Bit mask of SYNCDIV field.
	CRS_CFGR_FELIM_Pos   = 0x10       // Position of FELIM field.
	CRS_CFGR_FELIM_Msk   = 0xff0000   // Bit mask of FELIM field.
	CRS_CFGR_RELOAD_Pos  = 0x0        // Position of RELOAD field.
	CRS_CFGR_RELOAD_Msk  = 0xffff     // Bit mask of RELOAD field.

	// ISR: interrupt and status register
	CRS_ISR_FECAP_Pos     = 0x10       // Position of FECAP field.
	CRS_ISR_FECAP_Msk     = 0xffff0000 // Bit mask of FECAP field.
	CRS_ISR_FEDIR_Pos     = 0xf        // Position of FEDIR field.
	CRS_ISR_FEDIR_Msk     = 0x8000     // Bit mask of FEDIR field.
	CRS_ISR_FEDIR         = 0x8000     // Bit FEDIR.
	CRS_ISR_TRIMOVF_Pos   = 0xa        // Position of TRIMOVF field.
	CRS_ISR_TRIMOVF_Msk   = 0x400      // Bit mask of TRIMOVF field.
	CRS_ISR_TRIMOVF       = 0x400      // Bit TRIMOVF.
	CRS_ISR_SYNCMISS_Pos  = 0x9        // Position of SYNCMISS field.
	CRS_ISR_SYNCMISS_Msk  = 0x200      // Bit mask of SYNCMISS field.
	CRS_ISR_SYNCMISS      = 0x200      // Bit SYNCMISS.
	CRS_ISR_SYNCERR_Pos   = 0x8        // Position of SYNCERR field.
	CRS_ISR_SYNCERR_Msk   = 0x100      // Bit mask of SYNCERR field.
	CRS_ISR_SYNCERR       = 0x100      // Bit SYNCERR.
	CRS_ISR_ESYNCF_Pos    = 0x3        // Position of ESYNCF field.
	CRS_ISR_ESYNCF_Msk    = 0x8        // Bit mask of ESYNCF field.
	CRS_ISR_ESYNCF        = 0x8        // Bit ESYNCF.
	CRS_ISR_ERRF_Pos      = 0x2        // Position of ERRF field.
	CRS_ISR_ERRF_Msk      = 0x4        // Bit mask of ERRF field.
	CRS_ISR_ERRF          = 0x4        // Bit ERRF.
	CRS_ISR_SYNCWARNF_Pos = 0x1        // Position of SYNCWARNF field.
	CRS_ISR_SYNCWARNF_Msk = 0x2        // Bit mask of SYNCWARNF field.
	CRS_ISR_SYNCWARNF     = 0x2        // Bit SYNCWARNF.
	CRS_ISR_SYNCOKF_Pos   = 0x0        // Position of SYNCOKF field.
	CRS_ISR_SYNCOKF_Msk   = 0x1        // Bit mask of SYNCOKF field.
	CRS_ISR_SYNCOKF       = 0x1        // Bit SYNCOKF.

	// ICR: interrupt flag clear register
	CRS_ICR_ESYNCC_Pos    = 0x3 // Position of ESYNCC field.
	CRS_ICR_ESYNCC_Msk    = 0x8 // Bit mask of ESYNCC field.
	CRS_ICR_ESYNCC        = 0x8 // Bit ESYNCC.
	CRS_ICR_ERRC_Pos      = 0x2 // Position of ERRC field.
	CRS_ICR_ERRC_Msk      = 0x4 // Bit mask of ERRC field.
	CRS_ICR_ERRC          = 0x4 // Bit ERRC.
	CRS_ICR_SYNCWARNC_Pos = 0x1 // Position of SYNCWARNC field.
	CRS_ICR_SYNCWARNC_Msk = 0x2 // Bit mask of SYNCWARNC field.
	CRS_ICR_SYNCWARNC     = 0x2 // Bit SYNCWARNC.
	CRS_ICR_SYNCOKC_Pos   = 0x0 // Position of SYNCOKC field.
	CRS_ICR_SYNCOKC_Msk   = 0x1 // Bit mask of SYNCOKC field.
	CRS_ICR_SYNCOKC       = 0x1 // Bit SYNCOKC.
)

// Bitfields for CAN: Controller area network
const (
	// CAN_MCR: CAN_MCR
	CAN_CAN_MCR_DBF_Pos   = 0x10    // Position of DBF field.
	CAN_CAN_MCR_DBF_Msk   = 0x10000 // Bit mask of DBF field.
	CAN_CAN_MCR_DBF       = 0x10000 // Bit DBF.
	CAN_CAN_MCR_RESET_Pos = 0xf     // Position of RESET field.
	CAN_CAN_MCR_RESET_Msk = 0x8000  // Bit mask of RESET field.
	CAN_CAN_MCR_RESET     = 0x8000  // Bit RESET.
	CAN_CAN_MCR_TTCM_Pos  = 0x7     // Position of TTCM field.
	CAN_CAN_MCR_TTCM_Msk  = 0x80    // Bit mask of TTCM field.
	CAN_CAN_MCR_TTCM      = 0x80    // Bit TTCM.
	CAN_CAN_MCR_ABOM_Pos  = 0x6     // Position of ABOM field.
	CAN_CAN_MCR_ABOM_Msk  = 0x40    // Bit mask of ABOM field.
	CAN_CAN_MCR_ABOM      = 0x40    // Bit ABOM.
	CAN_CAN_MCR_AWUM_Pos  = 0x5     // Position of AWUM field.
	CAN_CAN_MCR_AWUM_Msk  = 0x20    // Bit mask of AWUM field.
	CAN_CAN_MCR_AWUM      = 0x20    // Bit AWUM.
	CAN_CAN_MCR_NART_Pos  = 0x4     // Position of NART field.
	CAN_CAN_MCR_NART_Msk  = 0x10    // Bit mask of NART field.
	CAN_CAN_MCR_NART      = 0x10    // Bit NART.
	CAN_CAN_MCR_RFLM_Pos  = 0x3     // Position of RFLM field.
	CAN_CAN_MCR_RFLM_Msk  = 0x8     // Bit mask of RFLM field.
	CAN_CAN_MCR_RFLM      = 0x8     // Bit RFLM.
	CAN_CAN_MCR_TXFP_Pos  = 0x2     // Position of TXFP field.
	CAN_CAN_MCR_TXFP_Msk  = 0x4     // Bit mask of TXFP field.
	CAN_CAN_MCR_TXFP      = 0x4     // Bit TXFP.
	CAN_CAN_MCR_SLEEP_Pos = 0x1     // Position of SLEEP field.
	CAN_CAN_MCR_SLEEP_Msk = 0x2     // Bit mask of SLEEP field.
	CAN_CAN_MCR_SLEEP     = 0x2     // Bit SLEEP.
	CAN_CAN_MCR_INRQ_Pos  = 0x0     // Position of INRQ field.
	CAN_CAN_MCR_INRQ_Msk  = 0x1     // Bit mask of INRQ field.
	CAN_CAN_MCR_INRQ      = 0x1     // Bit INRQ.

	// CAN_MSR: CAN_MSR
	CAN_CAN_MSR_RX_Pos    = 0xb   // Position of RX field.
	CAN_CAN_MSR_RX_Msk    = 0x800 // Bit mask of RX field.
	CAN_CAN_MSR_RX        = 0x800 // Bit RX.
	CAN_CAN_MSR_SAMP_Pos  = 0xa   // Position of SAMP field.
	CAN_CAN_MSR_SAMP_Msk  = 0x400 // Bit mask of SAMP field.
	CAN_CAN_MSR_SAMP      = 0x400 // Bit SAMP.
	CAN_CAN_MSR_RXM_Pos   = 0x9   // Position of RXM field.
	CAN_CAN_MSR_RXM_Msk   = 0x200 // Bit mask of RXM field.
	CAN_CAN_MSR_RXM       = 0x200 // Bit RXM.
	CAN_CAN_MSR_TXM_Pos   = 0x8   // Position of TXM field.
	CAN_CAN_MSR_TXM_Msk   = 0x100 // Bit mask of TXM field.
	CAN_CAN_MSR_TXM       = 0x100 // Bit TXM.
	CAN_CAN_MSR_SLAKI_Pos = 0x4   // Position of SLAKI field.
	CAN_CAN_MSR_SLAKI_Msk = 0x10  // Bit mask of SLAKI field.
	CAN_CAN_MSR_SLAKI     = 0x10  // Bit SLAKI.
	CAN_CAN_MSR_WKUI_Pos  = 0x3   // Position of WKUI field.
	CAN_CAN_MSR_WKUI_Msk  = 0x8   // Bit mask of WKUI field.
	CAN_CAN_MSR_WKUI      = 0x8   // Bit WKUI.
	CAN_CAN_MSR_ERRI_Pos  = 0x2   // Position of ERRI field.
	CAN_CAN_MSR_ERRI_Msk  = 0x4   // Bit mask of ERRI field.
	CAN_CAN_MSR_ERRI      = 0x4   // Bit ERRI.
	CAN_CAN_MSR_SLAK_Pos  = 0x1   // Position of SLAK field.
	CAN_CAN_MSR_SLAK_Msk  = 0x2   // Bit mask of SLAK field.
	CAN_CAN_MSR_SLAK      = 0x2   // Bit SLAK.
	CAN_CAN_MSR_INAK_Pos  = 0x0   // Position of INAK field.
	CAN_CAN_MSR_INAK_Msk  = 0x1   // Bit mask of INAK field.
	CAN_CAN_MSR_INAK      = 0x1   // Bit INAK.

	// CAN_TSR: CAN_TSR
	CAN_CAN_TSR_LOW2_Pos  = 0x1f       // Position of LOW2 field.
	CAN_CAN_TSR_LOW2_Msk  = 0x80000000 // Bit mask of LOW2 field.
	CAN_CAN_TSR_LOW2      = 0x80000000 // Bit LOW2.
	CAN_CAN_TSR_LOW1_Pos  = 0x1e       // Position of LOW1 field.
	CAN_CAN_TSR_LOW1_Msk  = 0x40000000 // Bit mask of LOW1 field.
	CAN_CAN_TSR_LOW1      = 0x40000000 // Bit LOW1.
	CAN_CAN_TSR_LOW0_Pos  = 0x1d       // Position of LOW0 field.
	CAN_CAN_TSR_LOW0_Msk  = 0x20000000 // Bit mask of LOW0 field.
	CAN_CAN_TSR_LOW0      = 0x20000000 // Bit LOW0.
	CAN_CAN_TSR_TME2_Pos  = 0x1c       // Position of TME2 field.
	CAN_CAN_TSR_TME2_Msk  = 0x10000000 // Bit mask of TME2 field.
	CAN_CAN_TSR_TME2      = 0x10000000 // Bit TME2.
	CAN_CAN_TSR_TME1_Pos  = 0x1b       // Position of TME1 field.
	CAN_CAN_TSR_TME1_Msk  = 0x8000000  // Bit mask of TME1 field.
	CAN_CAN_TSR_TME1      = 0x8000000  // Bit TME1.
	CAN_CAN_TSR_TME0_Pos  = 0x1a       // Position of TME0 field.
	CAN_CAN_TSR_TME0_Msk  = 0x4000000  // Bit mask of TME0 field.
	CAN_CAN_TSR_TME0      = 0x4000000  // Bit TME0.
	CAN_CAN_TSR_CODE_Pos  = 0x18       // Position of CODE field.
	CAN_CAN_TSR_CODE_Msk  = 0x3000000  // Bit mask of CODE field.
	CAN_CAN_TSR_ABRQ2_Pos = 0x17       // Position of ABRQ2 field.
	CAN_CAN_TSR_ABRQ2_Msk = 0x800000   // Bit mask of ABRQ2 field.
	CAN_CAN_TSR_ABRQ2     = 0x800000   // Bit ABRQ2.
	CAN_CAN_TSR_TERR2_Pos = 0x13       // Position of TERR2 field.
	CAN_CAN_TSR_TERR2_Msk = 0x80000    // Bit mask of TERR2 field.
	CAN_CAN_TSR_TERR2     = 0x80000    // Bit TERR2.
	CAN_CAN_TSR_ALST2_Pos = 0x12       // Position of ALST2 field.
	CAN_CAN_TSR_ALST2_Msk = 0x40000    // Bit mask of ALST2 field.
	CAN_CAN_TSR_ALST2     = 0x40000    // Bit ALST2.
	CAN_CAN_TSR_TXOK2_Pos = 0x11       // Position of TXOK2 field.
	CAN_CAN_TSR_TXOK2_Msk = 0x20000    // Bit mask of TXOK2 field.
	CAN_CAN_TSR_TXOK2     = 0x20000    // Bit TXOK2.
	CAN_CAN_TSR_RQCP2_Pos = 0x10       // Position of RQCP2 field.
	CAN_CAN_TSR_RQCP2_Msk = 0x10000    // Bit mask of RQCP2 field.
	CAN_CAN_TSR_RQCP2     = 0x10000    // Bit RQCP2.
	CAN_CAN_TSR_ABRQ1_Pos = 0xf        // Position of ABRQ1 field.
	CAN_CAN_TSR_ABRQ1_Msk = 0x8000     // Bit mask of ABRQ1 field.
	CAN_CAN_TSR_ABRQ1     = 0x8000     // Bit ABRQ1.
	CAN_CAN_TSR_TERR1_Pos = 0xb        // Position of TERR1 field.
	CAN_CAN_TSR_TERR1_Msk = 0x800      // Bit mask of TERR1 field.
	CAN_CAN_TSR_TERR1     = 0x800      // Bit TERR1.
	CAN_CAN_TSR_ALST1_Pos = 0xa        // Position of ALST1 field.
	CAN_CAN_TSR_ALST1_Msk = 0x400      // Bit mask of ALST1 field.
	CAN_CAN_TSR_ALST1     = 0x400      // Bit ALST1.
	CAN_CAN_TSR_TXOK1_Pos = 0x9        // Position of TXOK1 field.
	CAN_CAN_TSR_TXOK1_Msk = 0x200      // Bit mask of TXOK1 field.
	CAN_CAN_TSR_TXOK1     = 0x200      // Bit TXOK1.
	CAN_CAN_TSR_RQCP1_Pos = 0x8        // Position of RQCP1 field.
	CAN_CAN_TSR_RQCP1_Msk = 0x100      // Bit mask of RQCP1 field.
	CAN_CAN_TSR_RQCP1     = 0x100      // Bit RQCP1.
	CAN_CAN_TSR_ABRQ0_Pos = 0x7        // Position of ABRQ0 field.
	CAN_CAN_TSR_ABRQ0_Msk = 0x80       // Bit mask of ABRQ0 field.
	CAN_CAN_TSR_ABRQ0     = 0x80       // Bit ABRQ0.
	CAN_CAN_TSR_TERR0_Pos = 0x3        // Position of TERR0 field.
	CAN_CAN_TSR_TERR0_Msk = 0x8        // Bit mask of TERR0 field.
	CAN_CAN_TSR_TERR0     = 0x8        // Bit TERR0.
	CAN_CAN_TSR_ALST0_Pos = 0x2        // Position of ALST0 field.
	CAN_CAN_TSR_ALST0_Msk = 0x4        // Bit mask of ALST0 field.
	CAN_CAN_TSR_ALST0     = 0x4        // Bit ALST0.
	CAN_CAN_TSR_TXOK0_Pos = 0x1        // Position of TXOK0 field.
	CAN_CAN_TSR_TXOK0_Msk = 0x2        // Bit mask of TXOK0 field.
	CAN_CAN_TSR_TXOK0     = 0x2        // Bit TXOK0.
	CAN_CAN_TSR_RQCP0_Pos = 0x0        // Position of RQCP0 field.
	CAN_CAN_TSR_RQCP0_Msk = 0x1        // Bit mask of RQCP0 field.
	CAN_CAN_TSR_RQCP0     = 0x1        // Bit RQCP0.

	// CAN_RF0R: CAN_RF0R
	CAN_CAN_RF0R_RFOM0_Pos = 0x5  // Position of RFOM0 field.
	CAN_CAN_RF0R_RFOM0_Msk = 0x20 // Bit mask of RFOM0 field.
	CAN_CAN_RF0R_RFOM0     = 0x20 // Bit RFOM0.
	CAN_CAN_RF0R_FOVR0_Pos = 0x4  // Position of FOVR0 field.
	CAN_CAN_RF0R_FOVR0_Msk = 0x10 // Bit mask of FOVR0 field.
	CAN_CAN_RF0R_FOVR0     = 0x10 // Bit FOVR0.
	CAN_CAN_RF0R_FULL0_Pos = 0x3  // Position of FULL0 field.
	CAN_CAN_RF0R_FULL0_Msk = 0x8  // Bit mask of FULL0 field.
	CAN_CAN_RF0R_FULL0     = 0x8  // Bit FULL0.
	CAN_CAN_RF0R_FMP0_Pos  = 0x0  // Position of FMP0 field.
	CAN_CAN_RF0R_FMP0_Msk  = 0x3  // Bit mask of FMP0 field.

	// CAN_RF1R: CAN_RF1R
	CAN_CAN_RF1R_RFOM1_Pos = 0x5  // Position of RFOM1 field.
	CAN_CAN_RF1R_RFOM1_Msk = 0x20 // Bit mask of RFOM1 field.
	CAN_CAN_RF1R_RFOM1     = 0x20 // Bit RFOM1.
	CAN_CAN_RF1R_FOVR1_Pos = 0x4  // Position of FOVR1 field.
	CAN_CAN_RF1R_FOVR1_Msk = 0x10 // Bit mask of FOVR1 field.
	CAN_CAN_RF1R_FOVR1     = 0x10 // Bit FOVR1.
	CAN_CAN_RF1R_FULL1_Pos = 0x3  // Position of FULL1 field.
	CAN_CAN_RF1R_FULL1_Msk = 0x8  // Bit mask of FULL1 field.
	CAN_CAN_RF1R_FULL1     = 0x8  // Bit FULL1.
	CAN_CAN_RF1R_FMP1_Pos  = 0x0  // Position of FMP1 field.
	CAN_CAN_RF1R_FMP1_Msk  = 0x3  // Bit mask of FMP1 field.

	// CAN_IER: CAN_IER
	CAN_CAN_IER_SLKIE_Pos  = 0x11    // Position of SLKIE field.
	CAN_CAN_IER_SLKIE_Msk  = 0x20000 // Bit mask of SLKIE field.
	CAN_CAN_IER_SLKIE      = 0x20000 // Bit SLKIE.
	CAN_CAN_IER_WKUIE_Pos  = 0x10    // Position of WKUIE field.
	CAN_CAN_IER_WKUIE_Msk  = 0x10000 // Bit mask of WKUIE field.
	CAN_CAN_IER_WKUIE      = 0x10000 // Bit WKUIE.
	CAN_CAN_IER_ERRIE_Pos  = 0xf     // Position of ERRIE field.
	CAN_CAN_IER_ERRIE_Msk  = 0x8000  // Bit mask of ERRIE field.
	CAN_CAN_IER_ERRIE      = 0x8000  // Bit ERRIE.
	CAN_CAN_IER_LECIE_Pos  = 0xb     // Position of LECIE field.
	CAN_CAN_IER_LECIE_Msk  = 0x800   // Bit mask of LECIE field.
	CAN_CAN_IER_LECIE      = 0x800   // Bit LECIE.
	CAN_CAN_IER_BOFIE_Pos  = 0xa     // Position of BOFIE field.
	CAN_CAN_IER_BOFIE_Msk  = 0x400   // Bit mask of BOFIE field.
	CAN_CAN_IER_BOFIE      = 0x400   // Bit BOFIE.
	CAN_CAN_IER_EPVIE_Pos  = 0x9     // Position of EPVIE field.
	CAN_CAN_IER_EPVIE_Msk  = 0x200   // Bit mask of EPVIE field.
	CAN_CAN_IER_EPVIE      = 0x200   // Bit EPVIE.
	CAN_CAN_IER_EWGIE_Pos  = 0x8     // Position of EWGIE field.
	CAN_CAN_IER_EWGIE_Msk  = 0x100   // Bit mask of EWGIE field.
	CAN_CAN_IER_EWGIE      = 0x100   // Bit EWGIE.
	CAN_CAN_IER_FOVIE1_Pos = 0x6     // Position of FOVIE1 field.
	CAN_CAN_IER_FOVIE1_Msk = 0x40    // Bit mask of FOVIE1 field.
	CAN_CAN_IER_FOVIE1     = 0x40    // Bit FOVIE1.
	CAN_CAN_IER_FFIE1_Pos  = 0x5     // Position of FFIE1 field.
	CAN_CAN_IER_FFIE1_Msk  = 0x20    // Bit mask of FFIE1 field.
	CAN_CAN_IER_FFIE1      = 0x20    // Bit FFIE1.
	CAN_CAN_IER_FMPIE1_Pos = 0x4     // Position of FMPIE1 field.
	CAN_CAN_IER_FMPIE1_Msk = 0x10    // Bit mask of FMPIE1 field.
	CAN_CAN_IER_FMPIE1     = 0x10    // Bit FMPIE1.
	CAN_CAN_IER_FOVIE0_Pos = 0x3     // Position of FOVIE0 field.
	CAN_CAN_IER_FOVIE0_Msk = 0x8     // Bit mask of FOVIE0 field.
	CAN_CAN_IER_FOVIE0     = 0x8     // Bit FOVIE0.
	CAN_CAN_IER_FFIE0_Pos  = 0x2     // Position of FFIE0 field.
	CAN_CAN_IER_FFIE0_Msk  = 0x4     // Bit mask of FFIE0 field.
	CAN_CAN_IER_FFIE0      = 0x4     // Bit FFIE0.
	CAN_CAN_IER_FMPIE0_Pos = 0x1     // Position of FMPIE0 field.
	CAN_CAN_IER_FMPIE0_Msk = 0x2     // Bit mask of FMPIE0 field.
	CAN_CAN_IER_FMPIE0     = 0x2     // Bit FMPIE0.
	CAN_CAN_IER_TMEIE_Pos  = 0x0     // Position of TMEIE field.
	CAN_CAN_IER_TMEIE_Msk  = 0x1     // Bit mask of TMEIE field.
	CAN_CAN_IER_TMEIE      = 0x1     // Bit TMEIE.

	// CAN_ESR: CAN_ESR
	CAN_CAN_ESR_REC_Pos  = 0x18       // Position of REC field.
	CAN_CAN_ESR_REC_Msk  = 0xff000000 // Bit mask of REC field.
	CAN_CAN_ESR_TEC_Pos  = 0x10       // Position of TEC field.
	CAN_CAN_ESR_TEC_Msk  = 0xff0000   // Bit mask of TEC field.
	CAN_CAN_ESR_LEC_Pos  = 0x4        // Position of LEC field.
	CAN_CAN_ESR_LEC_Msk  = 0x70       // Bit mask of LEC field.
	CAN_CAN_ESR_BOFF_Pos = 0x2        // Position of BOFF field.
	CAN_CAN_ESR_BOFF_Msk = 0x4        // Bit mask of BOFF field.
	CAN_CAN_ESR_BOFF     = 0x4        // Bit BOFF.
	CAN_CAN_ESR_EPVF_Pos = 0x1        // Position of EPVF field.
	CAN_CAN_ESR_EPVF_Msk = 0x2        // Bit mask of EPVF field.
	CAN_CAN_ESR_EPVF     = 0x2        // Bit EPVF.
	CAN_CAN_ESR_EWGF_Pos = 0x0        // Position of EWGF field.
	CAN_CAN_ESR_EWGF_Msk = 0x1        // Bit mask of EWGF field.
	CAN_CAN_ESR_EWGF     = 0x1        // Bit EWGF.

	// CAN_BTR: CAN_BTR
	CAN_CAN_BTR_SILM_Pos = 0x1f       // Position of SILM field.
	CAN_CAN_BTR_SILM_Msk = 0x80000000 // Bit mask of SILM field.
	CAN_CAN_BTR_SILM     = 0x80000000 // Bit SILM.
	CAN_CAN_BTR_LBKM_Pos = 0x1e       // Position of LBKM field.
	CAN_CAN_BTR_LBKM_Msk = 0x40000000 // Bit mask of LBKM field.
	CAN_CAN_BTR_LBKM     = 0x40000000 // Bit LBKM.
	CAN_CAN_BTR_SJW_Pos  = 0x18       // Position of SJW field.
	CAN_CAN_BTR_SJW_Msk  = 0x3000000  // Bit mask of SJW field.
	CAN_CAN_BTR_TS2_Pos  = 0x14       // Position of TS2 field.
	CAN_CAN_BTR_TS2_Msk  = 0x700000   // Bit mask of TS2 field.
	CAN_CAN_BTR_TS1_Pos  = 0x10       // Position of TS1 field.
	CAN_CAN_BTR_TS1_Msk  = 0xf0000    // Bit mask of TS1 field.
	CAN_CAN_BTR_BRP_Pos  = 0x0        // Position of BRP field.
	CAN_CAN_BTR_BRP_Msk  = 0x3ff      // Bit mask of BRP field.

	// CAN_TI0R: CAN_TI0R
	CAN_CAN_TI0R_STID_Pos = 0x15       // Position of STID field.
	CAN_CAN_TI0R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_CAN_TI0R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_CAN_TI0R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_CAN_TI0R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_CAN_TI0R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_CAN_TI0R_IDE      = 0x4        // Bit IDE.
	CAN_CAN_TI0R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_CAN_TI0R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_CAN_TI0R_RTR      = 0x2        // Bit RTR.
	CAN_CAN_TI0R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_CAN_TI0R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_CAN_TI0R_TXRQ     = 0x1        // Bit TXRQ.

	// CAN_TDT0R: CAN_TDT0R
	CAN_CAN_TDT0R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_CAN_TDT0R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_CAN_TDT0R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_CAN_TDT0R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_CAN_TDT0R_TGT      = 0x100      // Bit TGT.
	CAN_CAN_TDT0R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_CAN_TDT0R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// CAN_TDL0R: CAN_TDL0R
	CAN_CAN_TDL0R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_CAN_TDL0R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_CAN_TDL0R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_CAN_TDL0R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_CAN_TDL0R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_CAN_TDL0R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_CAN_TDL0R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_CAN_TDL0R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// CAN_TDH0R: CAN_TDH0R
	CAN_CAN_TDH0R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_CAN_TDH0R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_CAN_TDH0R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_CAN_TDH0R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_CAN_TDH0R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_CAN_TDH0R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_CAN_TDH0R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_CAN_TDH0R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// CAN_TI1R: CAN_TI1R
	CAN_CAN_TI1R_STID_Pos = 0x15       // Position of STID field.
	CAN_CAN_TI1R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_CAN_TI1R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_CAN_TI1R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_CAN_TI1R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_CAN_TI1R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_CAN_TI1R_IDE      = 0x4        // Bit IDE.
	CAN_CAN_TI1R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_CAN_TI1R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_CAN_TI1R_RTR      = 0x2        // Bit RTR.
	CAN_CAN_TI1R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_CAN_TI1R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_CAN_TI1R_TXRQ     = 0x1        // Bit TXRQ.

	// CAN_TDT1R: CAN_TDT1R
	CAN_CAN_TDT1R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_CAN_TDT1R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_CAN_TDT1R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_CAN_TDT1R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_CAN_TDT1R_TGT      = 0x100      // Bit TGT.
	CAN_CAN_TDT1R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_CAN_TDT1R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// CAN_TDL1R: CAN_TDL1R
	CAN_CAN_TDL1R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_CAN_TDL1R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_CAN_TDL1R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_CAN_TDL1R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_CAN_TDL1R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_CAN_TDL1R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_CAN_TDL1R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_CAN_TDL1R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// CAN_TDH1R: CAN_TDH1R
	CAN_CAN_TDH1R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_CAN_TDH1R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_CAN_TDH1R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_CAN_TDH1R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_CAN_TDH1R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_CAN_TDH1R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_CAN_TDH1R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_CAN_TDH1R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// CAN_TI2R: CAN_TI2R
	CAN_CAN_TI2R_STID_Pos = 0x15       // Position of STID field.
	CAN_CAN_TI2R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_CAN_TI2R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_CAN_TI2R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_CAN_TI2R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_CAN_TI2R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_CAN_TI2R_IDE      = 0x4        // Bit IDE.
	CAN_CAN_TI2R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_CAN_TI2R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_CAN_TI2R_RTR      = 0x2        // Bit RTR.
	CAN_CAN_TI2R_TXRQ_Pos = 0x0        // Position of TXRQ field.
	CAN_CAN_TI2R_TXRQ_Msk = 0x1        // Bit mask of TXRQ field.
	CAN_CAN_TI2R_TXRQ     = 0x1        // Bit TXRQ.

	// CAN_TDT2R: CAN_TDT2R
	CAN_CAN_TDT2R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_CAN_TDT2R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_CAN_TDT2R_TGT_Pos  = 0x8        // Position of TGT field.
	CAN_CAN_TDT2R_TGT_Msk  = 0x100      // Bit mask of TGT field.
	CAN_CAN_TDT2R_TGT      = 0x100      // Bit TGT.
	CAN_CAN_TDT2R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_CAN_TDT2R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// CAN_TDL2R: CAN_TDL2R
	CAN_CAN_TDL2R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_CAN_TDL2R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_CAN_TDL2R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_CAN_TDL2R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_CAN_TDL2R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_CAN_TDL2R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_CAN_TDL2R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_CAN_TDL2R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// CAN_TDH2R: CAN_TDH2R
	CAN_CAN_TDH2R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_CAN_TDH2R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_CAN_TDH2R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_CAN_TDH2R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_CAN_TDH2R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_CAN_TDH2R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_CAN_TDH2R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_CAN_TDH2R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// CAN_RI0R: CAN_RI0R
	CAN_CAN_RI0R_STID_Pos = 0x15       // Position of STID field.
	CAN_CAN_RI0R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_CAN_RI0R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_CAN_RI0R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_CAN_RI0R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_CAN_RI0R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_CAN_RI0R_IDE      = 0x4        // Bit IDE.
	CAN_CAN_RI0R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_CAN_RI0R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_CAN_RI0R_RTR      = 0x2        // Bit RTR.

	// CAN_RDT0R: CAN_RDT0R
	CAN_CAN_RDT0R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_CAN_RDT0R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_CAN_RDT0R_FMI_Pos  = 0x8        // Position of FMI field.
	CAN_CAN_RDT0R_FMI_Msk  = 0xff00     // Bit mask of FMI field.
	CAN_CAN_RDT0R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_CAN_RDT0R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// CAN_RDL0R: CAN_RDL0R
	CAN_CAN_RDL0R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_CAN_RDL0R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_CAN_RDL0R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_CAN_RDL0R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_CAN_RDL0R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_CAN_RDL0R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_CAN_RDL0R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_CAN_RDL0R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// CAN_RDH0R: CAN_RDH0R
	CAN_CAN_RDH0R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_CAN_RDH0R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_CAN_RDH0R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_CAN_RDH0R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_CAN_RDH0R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_CAN_RDH0R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_CAN_RDH0R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_CAN_RDH0R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// CAN_RI1R: CAN_RI1R
	CAN_CAN_RI1R_STID_Pos = 0x15       // Position of STID field.
	CAN_CAN_RI1R_STID_Msk = 0xffe00000 // Bit mask of STID field.
	CAN_CAN_RI1R_EXID_Pos = 0x3        // Position of EXID field.
	CAN_CAN_RI1R_EXID_Msk = 0x1ffff8   // Bit mask of EXID field.
	CAN_CAN_RI1R_IDE_Pos  = 0x2        // Position of IDE field.
	CAN_CAN_RI1R_IDE_Msk  = 0x4        // Bit mask of IDE field.
	CAN_CAN_RI1R_IDE      = 0x4        // Bit IDE.
	CAN_CAN_RI1R_RTR_Pos  = 0x1        // Position of RTR field.
	CAN_CAN_RI1R_RTR_Msk  = 0x2        // Bit mask of RTR field.
	CAN_CAN_RI1R_RTR      = 0x2        // Bit RTR.

	// CAN_RDT1R: CAN_RDT1R
	CAN_CAN_RDT1R_TIME_Pos = 0x10       // Position of TIME field.
	CAN_CAN_RDT1R_TIME_Msk = 0xffff0000 // Bit mask of TIME field.
	CAN_CAN_RDT1R_FMI_Pos  = 0x8        // Position of FMI field.
	CAN_CAN_RDT1R_FMI_Msk  = 0xff00     // Bit mask of FMI field.
	CAN_CAN_RDT1R_DLC_Pos  = 0x0        // Position of DLC field.
	CAN_CAN_RDT1R_DLC_Msk  = 0xf        // Bit mask of DLC field.

	// CAN_RDL1R: CAN_RDL1R
	CAN_CAN_RDL1R_DATA3_Pos = 0x18       // Position of DATA3 field.
	CAN_CAN_RDL1R_DATA3_Msk = 0xff000000 // Bit mask of DATA3 field.
	CAN_CAN_RDL1R_DATA2_Pos = 0x10       // Position of DATA2 field.
	CAN_CAN_RDL1R_DATA2_Msk = 0xff0000   // Bit mask of DATA2 field.
	CAN_CAN_RDL1R_DATA1_Pos = 0x8        // Position of DATA1 field.
	CAN_CAN_RDL1R_DATA1_Msk = 0xff00     // Bit mask of DATA1 field.
	CAN_CAN_RDL1R_DATA0_Pos = 0x0        // Position of DATA0 field.
	CAN_CAN_RDL1R_DATA0_Msk = 0xff       // Bit mask of DATA0 field.

	// CAN_RDH1R: CAN_RDH1R
	CAN_CAN_RDH1R_DATA7_Pos = 0x18       // Position of DATA7 field.
	CAN_CAN_RDH1R_DATA7_Msk = 0xff000000 // Bit mask of DATA7 field.
	CAN_CAN_RDH1R_DATA6_Pos = 0x10       // Position of DATA6 field.
	CAN_CAN_RDH1R_DATA6_Msk = 0xff0000   // Bit mask of DATA6 field.
	CAN_CAN_RDH1R_DATA5_Pos = 0x8        // Position of DATA5 field.
	CAN_CAN_RDH1R_DATA5_Msk = 0xff00     // Bit mask of DATA5 field.
	CAN_CAN_RDH1R_DATA4_Pos = 0x0        // Position of DATA4 field.
	CAN_CAN_RDH1R_DATA4_Msk = 0xff       // Bit mask of DATA4 field.

	// CAN_FMR: CAN_FMR
	CAN_CAN_FMR_CAN2SB_Pos = 0x8    // Position of CAN2SB field.
	CAN_CAN_FMR_CAN2SB_Msk = 0x3f00 // Bit mask of CAN2SB field.
	CAN_CAN_FMR_FINIT_Pos  = 0x0    // Position of FINIT field.
	CAN_CAN_FMR_FINIT_Msk  = 0x1    // Bit mask of FINIT field.
	CAN_CAN_FMR_FINIT      = 0x1    // Bit FINIT.

	// CAN_FM1R: CAN_FM1R
	CAN_CAN_FM1R_FBM0_Pos  = 0x0       // Position of FBM0 field.
	CAN_CAN_FM1R_FBM0_Msk  = 0x1       // Bit mask of FBM0 field.
	CAN_CAN_FM1R_FBM0      = 0x1       // Bit FBM0.
	CAN_CAN_FM1R_FBM1_Pos  = 0x1       // Position of FBM1 field.
	CAN_CAN_FM1R_FBM1_Msk  = 0x2       // Bit mask of FBM1 field.
	CAN_CAN_FM1R_FBM1      = 0x2       // Bit FBM1.
	CAN_CAN_FM1R_FBM2_Pos  = 0x2       // Position of FBM2 field.
	CAN_CAN_FM1R_FBM2_Msk  = 0x4       // Bit mask of FBM2 field.
	CAN_CAN_FM1R_FBM2      = 0x4       // Bit FBM2.
	CAN_CAN_FM1R_FBM3_Pos  = 0x3       // Position of FBM3 field.
	CAN_CAN_FM1R_FBM3_Msk  = 0x8       // Bit mask of FBM3 field.
	CAN_CAN_FM1R_FBM3      = 0x8       // Bit FBM3.
	CAN_CAN_FM1R_FBM4_Pos  = 0x4       // Position of FBM4 field.
	CAN_CAN_FM1R_FBM4_Msk  = 0x10      // Bit mask of FBM4 field.
	CAN_CAN_FM1R_FBM4      = 0x10      // Bit FBM4.
	CAN_CAN_FM1R_FBM5_Pos  = 0x5       // Position of FBM5 field.
	CAN_CAN_FM1R_FBM5_Msk  = 0x20      // Bit mask of FBM5 field.
	CAN_CAN_FM1R_FBM5      = 0x20      // Bit FBM5.
	CAN_CAN_FM1R_FBM6_Pos  = 0x6       // Position of FBM6 field.
	CAN_CAN_FM1R_FBM6_Msk  = 0x40      // Bit mask of FBM6 field.
	CAN_CAN_FM1R_FBM6      = 0x40      // Bit FBM6.
	CAN_CAN_FM1R_FBM7_Pos  = 0x7       // Position of FBM7 field.
	CAN_CAN_FM1R_FBM7_Msk  = 0x80      // Bit mask of FBM7 field.
	CAN_CAN_FM1R_FBM7      = 0x80      // Bit FBM7.
	CAN_CAN_FM1R_FBM8_Pos  = 0x8       // Position of FBM8 field.
	CAN_CAN_FM1R_FBM8_Msk  = 0x100     // Bit mask of FBM8 field.
	CAN_CAN_FM1R_FBM8      = 0x100     // Bit FBM8.
	CAN_CAN_FM1R_FBM9_Pos  = 0x9       // Position of FBM9 field.
	CAN_CAN_FM1R_FBM9_Msk  = 0x200     // Bit mask of FBM9 field.
	CAN_CAN_FM1R_FBM9      = 0x200     // Bit FBM9.
	CAN_CAN_FM1R_FBM10_Pos = 0xa       // Position of FBM10 field.
	CAN_CAN_FM1R_FBM10_Msk = 0x400     // Bit mask of FBM10 field.
	CAN_CAN_FM1R_FBM10     = 0x400     // Bit FBM10.
	CAN_CAN_FM1R_FBM11_Pos = 0xb       // Position of FBM11 field.
	CAN_CAN_FM1R_FBM11_Msk = 0x800     // Bit mask of FBM11 field.
	CAN_CAN_FM1R_FBM11     = 0x800     // Bit FBM11.
	CAN_CAN_FM1R_FBM12_Pos = 0xc       // Position of FBM12 field.
	CAN_CAN_FM1R_FBM12_Msk = 0x1000    // Bit mask of FBM12 field.
	CAN_CAN_FM1R_FBM12     = 0x1000    // Bit FBM12.
	CAN_CAN_FM1R_FBM13_Pos = 0xd       // Position of FBM13 field.
	CAN_CAN_FM1R_FBM13_Msk = 0x2000    // Bit mask of FBM13 field.
	CAN_CAN_FM1R_FBM13     = 0x2000    // Bit FBM13.
	CAN_CAN_FM1R_FBM14_Pos = 0xe       // Position of FBM14 field.
	CAN_CAN_FM1R_FBM14_Msk = 0x4000    // Bit mask of FBM14 field.
	CAN_CAN_FM1R_FBM14     = 0x4000    // Bit FBM14.
	CAN_CAN_FM1R_FBM15_Pos = 0xf       // Position of FBM15 field.
	CAN_CAN_FM1R_FBM15_Msk = 0x8000    // Bit mask of FBM15 field.
	CAN_CAN_FM1R_FBM15     = 0x8000    // Bit FBM15.
	CAN_CAN_FM1R_FBM16_Pos = 0x10      // Position of FBM16 field.
	CAN_CAN_FM1R_FBM16_Msk = 0x10000   // Bit mask of FBM16 field.
	CAN_CAN_FM1R_FBM16     = 0x10000   // Bit FBM16.
	CAN_CAN_FM1R_FBM17_Pos = 0x11      // Position of FBM17 field.
	CAN_CAN_FM1R_FBM17_Msk = 0x20000   // Bit mask of FBM17 field.
	CAN_CAN_FM1R_FBM17     = 0x20000   // Bit FBM17.
	CAN_CAN_FM1R_FBM18_Pos = 0x12      // Position of FBM18 field.
	CAN_CAN_FM1R_FBM18_Msk = 0x40000   // Bit mask of FBM18 field.
	CAN_CAN_FM1R_FBM18     = 0x40000   // Bit FBM18.
	CAN_CAN_FM1R_FBM19_Pos = 0x13      // Position of FBM19 field.
	CAN_CAN_FM1R_FBM19_Msk = 0x80000   // Bit mask of FBM19 field.
	CAN_CAN_FM1R_FBM19     = 0x80000   // Bit FBM19.
	CAN_CAN_FM1R_FBM20_Pos = 0x14      // Position of FBM20 field.
	CAN_CAN_FM1R_FBM20_Msk = 0x100000  // Bit mask of FBM20 field.
	CAN_CAN_FM1R_FBM20     = 0x100000  // Bit FBM20.
	CAN_CAN_FM1R_FBM21_Pos = 0x15      // Position of FBM21 field.
	CAN_CAN_FM1R_FBM21_Msk = 0x200000  // Bit mask of FBM21 field.
	CAN_CAN_FM1R_FBM21     = 0x200000  // Bit FBM21.
	CAN_CAN_FM1R_FBM22_Pos = 0x16      // Position of FBM22 field.
	CAN_CAN_FM1R_FBM22_Msk = 0x400000  // Bit mask of FBM22 field.
	CAN_CAN_FM1R_FBM22     = 0x400000  // Bit FBM22.
	CAN_CAN_FM1R_FBM23_Pos = 0x17      // Position of FBM23 field.
	CAN_CAN_FM1R_FBM23_Msk = 0x800000  // Bit mask of FBM23 field.
	CAN_CAN_FM1R_FBM23     = 0x800000  // Bit FBM23.
	CAN_CAN_FM1R_FBM24_Pos = 0x18      // Position of FBM24 field.
	CAN_CAN_FM1R_FBM24_Msk = 0x1000000 // Bit mask of FBM24 field.
	CAN_CAN_FM1R_FBM24     = 0x1000000 // Bit FBM24.
	CAN_CAN_FM1R_FBM25_Pos = 0x19      // Position of FBM25 field.
	CAN_CAN_FM1R_FBM25_Msk = 0x2000000 // Bit mask of FBM25 field.
	CAN_CAN_FM1R_FBM25     = 0x2000000 // Bit FBM25.
	CAN_CAN_FM1R_FBM26_Pos = 0x1a      // Position of FBM26 field.
	CAN_CAN_FM1R_FBM26_Msk = 0x4000000 // Bit mask of FBM26 field.
	CAN_CAN_FM1R_FBM26     = 0x4000000 // Bit FBM26.
	CAN_CAN_FM1R_FBM27_Pos = 0x1b      // Position of FBM27 field.
	CAN_CAN_FM1R_FBM27_Msk = 0x8000000 // Bit mask of FBM27 field.
	CAN_CAN_FM1R_FBM27     = 0x8000000 // Bit FBM27.

	// CAN_FS1R: CAN_FS1R
	CAN_CAN_FS1R_FSC0_Pos  = 0x0       // Position of FSC0 field.
	CAN_CAN_FS1R_FSC0_Msk  = 0x1       // Bit mask of FSC0 field.
	CAN_CAN_FS1R_FSC0      = 0x1       // Bit FSC0.
	CAN_CAN_FS1R_FSC1_Pos  = 0x1       // Position of FSC1 field.
	CAN_CAN_FS1R_FSC1_Msk  = 0x2       // Bit mask of FSC1 field.
	CAN_CAN_FS1R_FSC1      = 0x2       // Bit FSC1.
	CAN_CAN_FS1R_FSC2_Pos  = 0x2       // Position of FSC2 field.
	CAN_CAN_FS1R_FSC2_Msk  = 0x4       // Bit mask of FSC2 field.
	CAN_CAN_FS1R_FSC2      = 0x4       // Bit FSC2.
	CAN_CAN_FS1R_FSC3_Pos  = 0x3       // Position of FSC3 field.
	CAN_CAN_FS1R_FSC3_Msk  = 0x8       // Bit mask of FSC3 field.
	CAN_CAN_FS1R_FSC3      = 0x8       // Bit FSC3.
	CAN_CAN_FS1R_FSC4_Pos  = 0x4       // Position of FSC4 field.
	CAN_CAN_FS1R_FSC4_Msk  = 0x10      // Bit mask of FSC4 field.
	CAN_CAN_FS1R_FSC4      = 0x10      // Bit FSC4.
	CAN_CAN_FS1R_FSC5_Pos  = 0x5       // Position of FSC5 field.
	CAN_CAN_FS1R_FSC5_Msk  = 0x20      // Bit mask of FSC5 field.
	CAN_CAN_FS1R_FSC5      = 0x20      // Bit FSC5.
	CAN_CAN_FS1R_FSC6_Pos  = 0x6       // Position of FSC6 field.
	CAN_CAN_FS1R_FSC6_Msk  = 0x40      // Bit mask of FSC6 field.
	CAN_CAN_FS1R_FSC6      = 0x40      // Bit FSC6.
	CAN_CAN_FS1R_FSC7_Pos  = 0x7       // Position of FSC7 field.
	CAN_CAN_FS1R_FSC7_Msk  = 0x80      // Bit mask of FSC7 field.
	CAN_CAN_FS1R_FSC7      = 0x80      // Bit FSC7.
	CAN_CAN_FS1R_FSC8_Pos  = 0x8       // Position of FSC8 field.
	CAN_CAN_FS1R_FSC8_Msk  = 0x100     // Bit mask of FSC8 field.
	CAN_CAN_FS1R_FSC8      = 0x100     // Bit FSC8.
	CAN_CAN_FS1R_FSC9_Pos  = 0x9       // Position of FSC9 field.
	CAN_CAN_FS1R_FSC9_Msk  = 0x200     // Bit mask of FSC9 field.
	CAN_CAN_FS1R_FSC9      = 0x200     // Bit FSC9.
	CAN_CAN_FS1R_FSC10_Pos = 0xa       // Position of FSC10 field.
	CAN_CAN_FS1R_FSC10_Msk = 0x400     // Bit mask of FSC10 field.
	CAN_CAN_FS1R_FSC10     = 0x400     // Bit FSC10.
	CAN_CAN_FS1R_FSC11_Pos = 0xb       // Position of FSC11 field.
	CAN_CAN_FS1R_FSC11_Msk = 0x800     // Bit mask of FSC11 field.
	CAN_CAN_FS1R_FSC11     = 0x800     // Bit FSC11.
	CAN_CAN_FS1R_FSC12_Pos = 0xc       // Position of FSC12 field.
	CAN_CAN_FS1R_FSC12_Msk = 0x1000    // Bit mask of FSC12 field.
	CAN_CAN_FS1R_FSC12     = 0x1000    // Bit FSC12.
	CAN_CAN_FS1R_FSC13_Pos = 0xd       // Position of FSC13 field.
	CAN_CAN_FS1R_FSC13_Msk = 0x2000    // Bit mask of FSC13 field.
	CAN_CAN_FS1R_FSC13     = 0x2000    // Bit FSC13.
	CAN_CAN_FS1R_FSC14_Pos = 0xe       // Position of FSC14 field.
	CAN_CAN_FS1R_FSC14_Msk = 0x4000    // Bit mask of FSC14 field.
	CAN_CAN_FS1R_FSC14     = 0x4000    // Bit FSC14.
	CAN_CAN_FS1R_FSC15_Pos = 0xf       // Position of FSC15 field.
	CAN_CAN_FS1R_FSC15_Msk = 0x8000    // Bit mask of FSC15 field.
	CAN_CAN_FS1R_FSC15     = 0x8000    // Bit FSC15.
	CAN_CAN_FS1R_FSC16_Pos = 0x10      // Position of FSC16 field.
	CAN_CAN_FS1R_FSC16_Msk = 0x10000   // Bit mask of FSC16 field.
	CAN_CAN_FS1R_FSC16     = 0x10000   // Bit FSC16.
	CAN_CAN_FS1R_FSC17_Pos = 0x11      // Position of FSC17 field.
	CAN_CAN_FS1R_FSC17_Msk = 0x20000   // Bit mask of FSC17 field.
	CAN_CAN_FS1R_FSC17     = 0x20000   // Bit FSC17.
	CAN_CAN_FS1R_FSC18_Pos = 0x12      // Position of FSC18 field.
	CAN_CAN_FS1R_FSC18_Msk = 0x40000   // Bit mask of FSC18 field.
	CAN_CAN_FS1R_FSC18     = 0x40000   // Bit FSC18.
	CAN_CAN_FS1R_FSC19_Pos = 0x13      // Position of FSC19 field.
	CAN_CAN_FS1R_FSC19_Msk = 0x80000   // Bit mask of FSC19 field.
	CAN_CAN_FS1R_FSC19     = 0x80000   // Bit FSC19.
	CAN_CAN_FS1R_FSC20_Pos = 0x14      // Position of FSC20 field.
	CAN_CAN_FS1R_FSC20_Msk = 0x100000  // Bit mask of FSC20 field.
	CAN_CAN_FS1R_FSC20     = 0x100000  // Bit FSC20.
	CAN_CAN_FS1R_FSC21_Pos = 0x15      // Position of FSC21 field.
	CAN_CAN_FS1R_FSC21_Msk = 0x200000  // Bit mask of FSC21 field.
	CAN_CAN_FS1R_FSC21     = 0x200000  // Bit FSC21.
	CAN_CAN_FS1R_FSC22_Pos = 0x16      // Position of FSC22 field.
	CAN_CAN_FS1R_FSC22_Msk = 0x400000  // Bit mask of FSC22 field.
	CAN_CAN_FS1R_FSC22     = 0x400000  // Bit FSC22.
	CAN_CAN_FS1R_FSC23_Pos = 0x17      // Position of FSC23 field.
	CAN_CAN_FS1R_FSC23_Msk = 0x800000  // Bit mask of FSC23 field.
	CAN_CAN_FS1R_FSC23     = 0x800000  // Bit FSC23.
	CAN_CAN_FS1R_FSC24_Pos = 0x18      // Position of FSC24 field.
	CAN_CAN_FS1R_FSC24_Msk = 0x1000000 // Bit mask of FSC24 field.
	CAN_CAN_FS1R_FSC24     = 0x1000000 // Bit FSC24.
	CAN_CAN_FS1R_FSC25_Pos = 0x19      // Position of FSC25 field.
	CAN_CAN_FS1R_FSC25_Msk = 0x2000000 // Bit mask of FSC25 field.
	CAN_CAN_FS1R_FSC25     = 0x2000000 // Bit FSC25.
	CAN_CAN_FS1R_FSC26_Pos = 0x1a      // Position of FSC26 field.
	CAN_CAN_FS1R_FSC26_Msk = 0x4000000 // Bit mask of FSC26 field.
	CAN_CAN_FS1R_FSC26     = 0x4000000 // Bit FSC26.
	CAN_CAN_FS1R_FSC27_Pos = 0x1b      // Position of FSC27 field.
	CAN_CAN_FS1R_FSC27_Msk = 0x8000000 // Bit mask of FSC27 field.
	CAN_CAN_FS1R_FSC27     = 0x8000000 // Bit FSC27.

	// CAN_FFA1R: CAN_FFA1R
	CAN_CAN_FFA1R_FFA0_Pos  = 0x0       // Position of FFA0 field.
	CAN_CAN_FFA1R_FFA0_Msk  = 0x1       // Bit mask of FFA0 field.
	CAN_CAN_FFA1R_FFA0      = 0x1       // Bit FFA0.
	CAN_CAN_FFA1R_FFA1_Pos  = 0x1       // Position of FFA1 field.
	CAN_CAN_FFA1R_FFA1_Msk  = 0x2       // Bit mask of FFA1 field.
	CAN_CAN_FFA1R_FFA1      = 0x2       // Bit FFA1.
	CAN_CAN_FFA1R_FFA2_Pos  = 0x2       // Position of FFA2 field.
	CAN_CAN_FFA1R_FFA2_Msk  = 0x4       // Bit mask of FFA2 field.
	CAN_CAN_FFA1R_FFA2      = 0x4       // Bit FFA2.
	CAN_CAN_FFA1R_FFA3_Pos  = 0x3       // Position of FFA3 field.
	CAN_CAN_FFA1R_FFA3_Msk  = 0x8       // Bit mask of FFA3 field.
	CAN_CAN_FFA1R_FFA3      = 0x8       // Bit FFA3.
	CAN_CAN_FFA1R_FFA4_Pos  = 0x4       // Position of FFA4 field.
	CAN_CAN_FFA1R_FFA4_Msk  = 0x10      // Bit mask of FFA4 field.
	CAN_CAN_FFA1R_FFA4      = 0x10      // Bit FFA4.
	CAN_CAN_FFA1R_FFA5_Pos  = 0x5       // Position of FFA5 field.
	CAN_CAN_FFA1R_FFA5_Msk  = 0x20      // Bit mask of FFA5 field.
	CAN_CAN_FFA1R_FFA5      = 0x20      // Bit FFA5.
	CAN_CAN_FFA1R_FFA6_Pos  = 0x6       // Position of FFA6 field.
	CAN_CAN_FFA1R_FFA6_Msk  = 0x40      // Bit mask of FFA6 field.
	CAN_CAN_FFA1R_FFA6      = 0x40      // Bit FFA6.
	CAN_CAN_FFA1R_FFA7_Pos  = 0x7       // Position of FFA7 field.
	CAN_CAN_FFA1R_FFA7_Msk  = 0x80      // Bit mask of FFA7 field.
	CAN_CAN_FFA1R_FFA7      = 0x80      // Bit FFA7.
	CAN_CAN_FFA1R_FFA8_Pos  = 0x8       // Position of FFA8 field.
	CAN_CAN_FFA1R_FFA8_Msk  = 0x100     // Bit mask of FFA8 field.
	CAN_CAN_FFA1R_FFA8      = 0x100     // Bit FFA8.
	CAN_CAN_FFA1R_FFA9_Pos  = 0x9       // Position of FFA9 field.
	CAN_CAN_FFA1R_FFA9_Msk  = 0x200     // Bit mask of FFA9 field.
	CAN_CAN_FFA1R_FFA9      = 0x200     // Bit FFA9.
	CAN_CAN_FFA1R_FFA10_Pos = 0xa       // Position of FFA10 field.
	CAN_CAN_FFA1R_FFA10_Msk = 0x400     // Bit mask of FFA10 field.
	CAN_CAN_FFA1R_FFA10     = 0x400     // Bit FFA10.
	CAN_CAN_FFA1R_FFA11_Pos = 0xb       // Position of FFA11 field.
	CAN_CAN_FFA1R_FFA11_Msk = 0x800     // Bit mask of FFA11 field.
	CAN_CAN_FFA1R_FFA11     = 0x800     // Bit FFA11.
	CAN_CAN_FFA1R_FFA12_Pos = 0xc       // Position of FFA12 field.
	CAN_CAN_FFA1R_FFA12_Msk = 0x1000    // Bit mask of FFA12 field.
	CAN_CAN_FFA1R_FFA12     = 0x1000    // Bit FFA12.
	CAN_CAN_FFA1R_FFA13_Pos = 0xd       // Position of FFA13 field.
	CAN_CAN_FFA1R_FFA13_Msk = 0x2000    // Bit mask of FFA13 field.
	CAN_CAN_FFA1R_FFA13     = 0x2000    // Bit FFA13.
	CAN_CAN_FFA1R_FFA14_Pos = 0xe       // Position of FFA14 field.
	CAN_CAN_FFA1R_FFA14_Msk = 0x4000    // Bit mask of FFA14 field.
	CAN_CAN_FFA1R_FFA14     = 0x4000    // Bit FFA14.
	CAN_CAN_FFA1R_FFA15_Pos = 0xf       // Position of FFA15 field.
	CAN_CAN_FFA1R_FFA15_Msk = 0x8000    // Bit mask of FFA15 field.
	CAN_CAN_FFA1R_FFA15     = 0x8000    // Bit FFA15.
	CAN_CAN_FFA1R_FFA16_Pos = 0x10      // Position of FFA16 field.
	CAN_CAN_FFA1R_FFA16_Msk = 0x10000   // Bit mask of FFA16 field.
	CAN_CAN_FFA1R_FFA16     = 0x10000   // Bit FFA16.
	CAN_CAN_FFA1R_FFA17_Pos = 0x11      // Position of FFA17 field.
	CAN_CAN_FFA1R_FFA17_Msk = 0x20000   // Bit mask of FFA17 field.
	CAN_CAN_FFA1R_FFA17     = 0x20000   // Bit FFA17.
	CAN_CAN_FFA1R_FFA18_Pos = 0x12      // Position of FFA18 field.
	CAN_CAN_FFA1R_FFA18_Msk = 0x40000   // Bit mask of FFA18 field.
	CAN_CAN_FFA1R_FFA18     = 0x40000   // Bit FFA18.
	CAN_CAN_FFA1R_FFA19_Pos = 0x13      // Position of FFA19 field.
	CAN_CAN_FFA1R_FFA19_Msk = 0x80000   // Bit mask of FFA19 field.
	CAN_CAN_FFA1R_FFA19     = 0x80000   // Bit FFA19.
	CAN_CAN_FFA1R_FFA20_Pos = 0x14      // Position of FFA20 field.
	CAN_CAN_FFA1R_FFA20_Msk = 0x100000  // Bit mask of FFA20 field.
	CAN_CAN_FFA1R_FFA20     = 0x100000  // Bit FFA20.
	CAN_CAN_FFA1R_FFA21_Pos = 0x15      // Position of FFA21 field.
	CAN_CAN_FFA1R_FFA21_Msk = 0x200000  // Bit mask of FFA21 field.
	CAN_CAN_FFA1R_FFA21     = 0x200000  // Bit FFA21.
	CAN_CAN_FFA1R_FFA22_Pos = 0x16      // Position of FFA22 field.
	CAN_CAN_FFA1R_FFA22_Msk = 0x400000  // Bit mask of FFA22 field.
	CAN_CAN_FFA1R_FFA22     = 0x400000  // Bit FFA22.
	CAN_CAN_FFA1R_FFA23_Pos = 0x17      // Position of FFA23 field.
	CAN_CAN_FFA1R_FFA23_Msk = 0x800000  // Bit mask of FFA23 field.
	CAN_CAN_FFA1R_FFA23     = 0x800000  // Bit FFA23.
	CAN_CAN_FFA1R_FFA24_Pos = 0x18      // Position of FFA24 field.
	CAN_CAN_FFA1R_FFA24_Msk = 0x1000000 // Bit mask of FFA24 field.
	CAN_CAN_FFA1R_FFA24     = 0x1000000 // Bit FFA24.
	CAN_CAN_FFA1R_FFA25_Pos = 0x19      // Position of FFA25 field.
	CAN_CAN_FFA1R_FFA25_Msk = 0x2000000 // Bit mask of FFA25 field.
	CAN_CAN_FFA1R_FFA25     = 0x2000000 // Bit FFA25.
	CAN_CAN_FFA1R_FFA26_Pos = 0x1a      // Position of FFA26 field.
	CAN_CAN_FFA1R_FFA26_Msk = 0x4000000 // Bit mask of FFA26 field.
	CAN_CAN_FFA1R_FFA26     = 0x4000000 // Bit FFA26.
	CAN_CAN_FFA1R_FFA27_Pos = 0x1b      // Position of FFA27 field.
	CAN_CAN_FFA1R_FFA27_Msk = 0x8000000 // Bit mask of FFA27 field.
	CAN_CAN_FFA1R_FFA27     = 0x8000000 // Bit FFA27.

	// CAN_FA1R: CAN_FA1R
	CAN_CAN_FA1R_FACT0_Pos  = 0x0       // Position of FACT0 field.
	CAN_CAN_FA1R_FACT0_Msk  = 0x1       // Bit mask of FACT0 field.
	CAN_CAN_FA1R_FACT0      = 0x1       // Bit FACT0.
	CAN_CAN_FA1R_FACT1_Pos  = 0x1       // Position of FACT1 field.
	CAN_CAN_FA1R_FACT1_Msk  = 0x2       // Bit mask of FACT1 field.
	CAN_CAN_FA1R_FACT1      = 0x2       // Bit FACT1.
	CAN_CAN_FA1R_FACT2_Pos  = 0x2       // Position of FACT2 field.
	CAN_CAN_FA1R_FACT2_Msk  = 0x4       // Bit mask of FACT2 field.
	CAN_CAN_FA1R_FACT2      = 0x4       // Bit FACT2.
	CAN_CAN_FA1R_FACT3_Pos  = 0x3       // Position of FACT3 field.
	CAN_CAN_FA1R_FACT3_Msk  = 0x8       // Bit mask of FACT3 field.
	CAN_CAN_FA1R_FACT3      = 0x8       // Bit FACT3.
	CAN_CAN_FA1R_FACT4_Pos  = 0x4       // Position of FACT4 field.
	CAN_CAN_FA1R_FACT4_Msk  = 0x10      // Bit mask of FACT4 field.
	CAN_CAN_FA1R_FACT4      = 0x10      // Bit FACT4.
	CAN_CAN_FA1R_FACT5_Pos  = 0x5       // Position of FACT5 field.
	CAN_CAN_FA1R_FACT5_Msk  = 0x20      // Bit mask of FACT5 field.
	CAN_CAN_FA1R_FACT5      = 0x20      // Bit FACT5.
	CAN_CAN_FA1R_FACT6_Pos  = 0x6       // Position of FACT6 field.
	CAN_CAN_FA1R_FACT6_Msk  = 0x40      // Bit mask of FACT6 field.
	CAN_CAN_FA1R_FACT6      = 0x40      // Bit FACT6.
	CAN_CAN_FA1R_FACT7_Pos  = 0x7       // Position of FACT7 field.
	CAN_CAN_FA1R_FACT7_Msk  = 0x80      // Bit mask of FACT7 field.
	CAN_CAN_FA1R_FACT7      = 0x80      // Bit FACT7.
	CAN_CAN_FA1R_FACT8_Pos  = 0x8       // Position of FACT8 field.
	CAN_CAN_FA1R_FACT8_Msk  = 0x100     // Bit mask of FACT8 field.
	CAN_CAN_FA1R_FACT8      = 0x100     // Bit FACT8.
	CAN_CAN_FA1R_FACT9_Pos  = 0x9       // Position of FACT9 field.
	CAN_CAN_FA1R_FACT9_Msk  = 0x200     // Bit mask of FACT9 field.
	CAN_CAN_FA1R_FACT9      = 0x200     // Bit FACT9.
	CAN_CAN_FA1R_FACT10_Pos = 0xa       // Position of FACT10 field.
	CAN_CAN_FA1R_FACT10_Msk = 0x400     // Bit mask of FACT10 field.
	CAN_CAN_FA1R_FACT10     = 0x400     // Bit FACT10.
	CAN_CAN_FA1R_FACT11_Pos = 0xb       // Position of FACT11 field.
	CAN_CAN_FA1R_FACT11_Msk = 0x800     // Bit mask of FACT11 field.
	CAN_CAN_FA1R_FACT11     = 0x800     // Bit FACT11.
	CAN_CAN_FA1R_FACT12_Pos = 0xc       // Position of FACT12 field.
	CAN_CAN_FA1R_FACT12_Msk = 0x1000    // Bit mask of FACT12 field.
	CAN_CAN_FA1R_FACT12     = 0x1000    // Bit FACT12.
	CAN_CAN_FA1R_FACT13_Pos = 0xd       // Position of FACT13 field.
	CAN_CAN_FA1R_FACT13_Msk = 0x2000    // Bit mask of FACT13 field.
	CAN_CAN_FA1R_FACT13     = 0x2000    // Bit FACT13.
	CAN_CAN_FA1R_FACT14_Pos = 0xe       // Position of FACT14 field.
	CAN_CAN_FA1R_FACT14_Msk = 0x4000    // Bit mask of FACT14 field.
	CAN_CAN_FA1R_FACT14     = 0x4000    // Bit FACT14.
	CAN_CAN_FA1R_FACT15_Pos = 0xf       // Position of FACT15 field.
	CAN_CAN_FA1R_FACT15_Msk = 0x8000    // Bit mask of FACT15 field.
	CAN_CAN_FA1R_FACT15     = 0x8000    // Bit FACT15.
	CAN_CAN_FA1R_FACT16_Pos = 0x10      // Position of FACT16 field.
	CAN_CAN_FA1R_FACT16_Msk = 0x10000   // Bit mask of FACT16 field.
	CAN_CAN_FA1R_FACT16     = 0x10000   // Bit FACT16.
	CAN_CAN_FA1R_FACT17_Pos = 0x11      // Position of FACT17 field.
	CAN_CAN_FA1R_FACT17_Msk = 0x20000   // Bit mask of FACT17 field.
	CAN_CAN_FA1R_FACT17     = 0x20000   // Bit FACT17.
	CAN_CAN_FA1R_FACT18_Pos = 0x12      // Position of FACT18 field.
	CAN_CAN_FA1R_FACT18_Msk = 0x40000   // Bit mask of FACT18 field.
	CAN_CAN_FA1R_FACT18     = 0x40000   // Bit FACT18.
	CAN_CAN_FA1R_FACT19_Pos = 0x13      // Position of FACT19 field.
	CAN_CAN_FA1R_FACT19_Msk = 0x80000   // Bit mask of FACT19 field.
	CAN_CAN_FA1R_FACT19     = 0x80000   // Bit FACT19.
	CAN_CAN_FA1R_FACT20_Pos = 0x14      // Position of FACT20 field.
	CAN_CAN_FA1R_FACT20_Msk = 0x100000  // Bit mask of FACT20 field.
	CAN_CAN_FA1R_FACT20     = 0x100000  // Bit FACT20.
	CAN_CAN_FA1R_FACT21_Pos = 0x15      // Position of FACT21 field.
	CAN_CAN_FA1R_FACT21_Msk = 0x200000  // Bit mask of FACT21 field.
	CAN_CAN_FA1R_FACT21     = 0x200000  // Bit FACT21.
	CAN_CAN_FA1R_FACT22_Pos = 0x16      // Position of FACT22 field.
	CAN_CAN_FA1R_FACT22_Msk = 0x400000  // Bit mask of FACT22 field.
	CAN_CAN_FA1R_FACT22     = 0x400000  // Bit FACT22.
	CAN_CAN_FA1R_FACT23_Pos = 0x17      // Position of FACT23 field.
	CAN_CAN_FA1R_FACT23_Msk = 0x800000  // Bit mask of FACT23 field.
	CAN_CAN_FA1R_FACT23     = 0x800000  // Bit FACT23.
	CAN_CAN_FA1R_FACT24_Pos = 0x18      // Position of FACT24 field.
	CAN_CAN_FA1R_FACT24_Msk = 0x1000000 // Bit mask of FACT24 field.
	CAN_CAN_FA1R_FACT24     = 0x1000000 // Bit FACT24.
	CAN_CAN_FA1R_FACT25_Pos = 0x19      // Position of FACT25 field.
	CAN_CAN_FA1R_FACT25_Msk = 0x2000000 // Bit mask of FACT25 field.
	CAN_CAN_FA1R_FACT25     = 0x2000000 // Bit FACT25.
	CAN_CAN_FA1R_FACT26_Pos = 0x1a      // Position of FACT26 field.
	CAN_CAN_FA1R_FACT26_Msk = 0x4000000 // Bit mask of FACT26 field.
	CAN_CAN_FA1R_FACT26     = 0x4000000 // Bit FACT26.
	CAN_CAN_FA1R_FACT27_Pos = 0x1b      // Position of FACT27 field.
	CAN_CAN_FA1R_FACT27_Msk = 0x8000000 // Bit mask of FACT27 field.
	CAN_CAN_FA1R_FACT27     = 0x8000000 // Bit FACT27.

	// F0R1: Filter bank 0 register 1
	CAN_F0R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F0R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F0R1_FB0      = 0x1        // Bit FB0.
	CAN_F0R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F0R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F0R1_FB1      = 0x2        // Bit FB1.
	CAN_F0R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F0R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F0R1_FB2      = 0x4        // Bit FB2.
	CAN_F0R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F0R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F0R1_FB3      = 0x8        // Bit FB3.
	CAN_F0R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F0R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F0R1_FB4      = 0x10       // Bit FB4.
	CAN_F0R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F0R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F0R1_FB5      = 0x20       // Bit FB5.
	CAN_F0R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F0R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F0R1_FB6      = 0x40       // Bit FB6.
	CAN_F0R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F0R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F0R1_FB7      = 0x80       // Bit FB7.
	CAN_F0R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F0R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F0R1_FB8      = 0x100      // Bit FB8.
	CAN_F0R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F0R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F0R1_FB9      = 0x200      // Bit FB9.
	CAN_F0R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F0R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F0R1_FB10     = 0x400      // Bit FB10.
	CAN_F0R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F0R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F0R1_FB11     = 0x800      // Bit FB11.
	CAN_F0R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F0R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F0R1_FB12     = 0x1000     // Bit FB12.
	CAN_F0R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F0R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F0R1_FB13     = 0x2000     // Bit FB13.
	CAN_F0R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F0R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F0R1_FB14     = 0x4000     // Bit FB14.
	CAN_F0R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F0R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F0R1_FB15     = 0x8000     // Bit FB15.
	CAN_F0R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F0R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F0R1_FB16     = 0x10000    // Bit FB16.
	CAN_F0R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F0R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F0R1_FB17     = 0x20000    // Bit FB17.
	CAN_F0R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F0R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F0R1_FB18     = 0x40000    // Bit FB18.
	CAN_F0R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F0R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F0R1_FB19     = 0x80000    // Bit FB19.
	CAN_F0R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F0R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F0R1_FB20     = 0x100000   // Bit FB20.
	CAN_F0R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F0R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F0R1_FB21     = 0x200000   // Bit FB21.
	CAN_F0R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F0R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F0R1_FB22     = 0x400000   // Bit FB22.
	CAN_F0R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F0R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F0R1_FB23     = 0x800000   // Bit FB23.
	CAN_F0R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F0R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F0R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F0R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F0R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F0R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F0R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F0R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F0R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F0R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F0R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F0R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F0R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F0R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F0R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F0R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F0R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F0R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F0R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F0R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F0R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F0R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F0R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F0R1_FB31     = 0x80000000 // Bit FB31.

	// F0R2: Filter bank 0 register 2
	CAN_F0R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F0R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F0R2_FB0      = 0x1        // Bit FB0.
	CAN_F0R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F0R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F0R2_FB1      = 0x2        // Bit FB1.
	CAN_F0R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F0R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F0R2_FB2      = 0x4        // Bit FB2.
	CAN_F0R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F0R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F0R2_FB3      = 0x8        // Bit FB3.
	CAN_F0R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F0R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F0R2_FB4      = 0x10       // Bit FB4.
	CAN_F0R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F0R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F0R2_FB5      = 0x20       // Bit FB5.
	CAN_F0R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F0R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F0R2_FB6      = 0x40       // Bit FB6.
	CAN_F0R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F0R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F0R2_FB7      = 0x80       // Bit FB7.
	CAN_F0R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F0R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F0R2_FB8      = 0x100      // Bit FB8.
	CAN_F0R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F0R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F0R2_FB9      = 0x200      // Bit FB9.
	CAN_F0R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F0R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F0R2_FB10     = 0x400      // Bit FB10.
	CAN_F0R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F0R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F0R2_FB11     = 0x800      // Bit FB11.
	CAN_F0R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F0R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F0R2_FB12     = 0x1000     // Bit FB12.
	CAN_F0R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F0R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F0R2_FB13     = 0x2000     // Bit FB13.
	CAN_F0R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F0R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F0R2_FB14     = 0x4000     // Bit FB14.
	CAN_F0R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F0R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F0R2_FB15     = 0x8000     // Bit FB15.
	CAN_F0R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F0R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F0R2_FB16     = 0x10000    // Bit FB16.
	CAN_F0R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F0R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F0R2_FB17     = 0x20000    // Bit FB17.
	CAN_F0R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F0R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F0R2_FB18     = 0x40000    // Bit FB18.
	CAN_F0R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F0R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F0R2_FB19     = 0x80000    // Bit FB19.
	CAN_F0R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F0R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F0R2_FB20     = 0x100000   // Bit FB20.
	CAN_F0R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F0R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F0R2_FB21     = 0x200000   // Bit FB21.
	CAN_F0R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F0R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F0R2_FB22     = 0x400000   // Bit FB22.
	CAN_F0R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F0R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F0R2_FB23     = 0x800000   // Bit FB23.
	CAN_F0R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F0R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F0R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F0R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F0R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F0R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F0R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F0R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F0R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F0R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F0R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F0R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F0R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F0R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F0R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F0R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F0R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F0R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F0R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F0R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F0R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F0R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F0R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F0R2_FB31     = 0x80000000 // Bit FB31.

	// F1R1: Filter bank 1 register 1
	CAN_F1R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F1R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F1R1_FB0      = 0x1        // Bit FB0.
	CAN_F1R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F1R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F1R1_FB1      = 0x2        // Bit FB1.
	CAN_F1R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F1R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F1R1_FB2      = 0x4        // Bit FB2.
	CAN_F1R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F1R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F1R1_FB3      = 0x8        // Bit FB3.
	CAN_F1R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F1R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F1R1_FB4      = 0x10       // Bit FB4.
	CAN_F1R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F1R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F1R1_FB5      = 0x20       // Bit FB5.
	CAN_F1R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F1R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F1R1_FB6      = 0x40       // Bit FB6.
	CAN_F1R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F1R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F1R1_FB7      = 0x80       // Bit FB7.
	CAN_F1R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F1R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F1R1_FB8      = 0x100      // Bit FB8.
	CAN_F1R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F1R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F1R1_FB9      = 0x200      // Bit FB9.
	CAN_F1R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F1R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F1R1_FB10     = 0x400      // Bit FB10.
	CAN_F1R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F1R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F1R1_FB11     = 0x800      // Bit FB11.
	CAN_F1R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F1R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F1R1_FB12     = 0x1000     // Bit FB12.
	CAN_F1R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F1R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F1R1_FB13     = 0x2000     // Bit FB13.
	CAN_F1R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F1R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F1R1_FB14     = 0x4000     // Bit FB14.
	CAN_F1R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F1R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F1R1_FB15     = 0x8000     // Bit FB15.
	CAN_F1R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F1R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F1R1_FB16     = 0x10000    // Bit FB16.
	CAN_F1R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F1R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F1R1_FB17     = 0x20000    // Bit FB17.
	CAN_F1R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F1R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F1R1_FB18     = 0x40000    // Bit FB18.
	CAN_F1R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F1R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F1R1_FB19     = 0x80000    // Bit FB19.
	CAN_F1R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F1R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F1R1_FB20     = 0x100000   // Bit FB20.
	CAN_F1R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F1R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F1R1_FB21     = 0x200000   // Bit FB21.
	CAN_F1R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F1R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F1R1_FB22     = 0x400000   // Bit FB22.
	CAN_F1R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F1R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F1R1_FB23     = 0x800000   // Bit FB23.
	CAN_F1R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F1R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F1R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F1R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F1R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F1R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F1R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F1R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F1R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F1R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F1R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F1R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F1R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F1R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F1R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F1R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F1R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F1R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F1R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F1R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F1R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F1R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F1R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F1R1_FB31     = 0x80000000 // Bit FB31.

	// F1R2: Filter bank 1 register 2
	CAN_F1R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F1R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F1R2_FB0      = 0x1        // Bit FB0.
	CAN_F1R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F1R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F1R2_FB1      = 0x2        // Bit FB1.
	CAN_F1R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F1R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F1R2_FB2      = 0x4        // Bit FB2.
	CAN_F1R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F1R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F1R2_FB3      = 0x8        // Bit FB3.
	CAN_F1R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F1R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F1R2_FB4      = 0x10       // Bit FB4.
	CAN_F1R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F1R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F1R2_FB5      = 0x20       // Bit FB5.
	CAN_F1R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F1R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F1R2_FB6      = 0x40       // Bit FB6.
	CAN_F1R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F1R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F1R2_FB7      = 0x80       // Bit FB7.
	CAN_F1R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F1R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F1R2_FB8      = 0x100      // Bit FB8.
	CAN_F1R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F1R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F1R2_FB9      = 0x200      // Bit FB9.
	CAN_F1R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F1R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F1R2_FB10     = 0x400      // Bit FB10.
	CAN_F1R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F1R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F1R2_FB11     = 0x800      // Bit FB11.
	CAN_F1R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F1R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F1R2_FB12     = 0x1000     // Bit FB12.
	CAN_F1R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F1R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F1R2_FB13     = 0x2000     // Bit FB13.
	CAN_F1R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F1R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F1R2_FB14     = 0x4000     // Bit FB14.
	CAN_F1R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F1R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F1R2_FB15     = 0x8000     // Bit FB15.
	CAN_F1R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F1R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F1R2_FB16     = 0x10000    // Bit FB16.
	CAN_F1R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F1R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F1R2_FB17     = 0x20000    // Bit FB17.
	CAN_F1R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F1R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F1R2_FB18     = 0x40000    // Bit FB18.
	CAN_F1R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F1R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F1R2_FB19     = 0x80000    // Bit FB19.
	CAN_F1R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F1R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F1R2_FB20     = 0x100000   // Bit FB20.
	CAN_F1R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F1R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F1R2_FB21     = 0x200000   // Bit FB21.
	CAN_F1R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F1R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F1R2_FB22     = 0x400000   // Bit FB22.
	CAN_F1R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F1R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F1R2_FB23     = 0x800000   // Bit FB23.
	CAN_F1R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F1R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F1R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F1R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F1R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F1R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F1R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F1R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F1R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F1R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F1R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F1R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F1R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F1R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F1R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F1R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F1R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F1R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F1R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F1R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F1R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F1R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F1R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F1R2_FB31     = 0x80000000 // Bit FB31.

	// F2R1: Filter bank 2 register 1
	CAN_F2R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F2R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F2R1_FB0      = 0x1        // Bit FB0.
	CAN_F2R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F2R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F2R1_FB1      = 0x2        // Bit FB1.
	CAN_F2R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F2R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F2R1_FB2      = 0x4        // Bit FB2.
	CAN_F2R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F2R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F2R1_FB3      = 0x8        // Bit FB3.
	CAN_F2R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F2R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F2R1_FB4      = 0x10       // Bit FB4.
	CAN_F2R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F2R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F2R1_FB5      = 0x20       // Bit FB5.
	CAN_F2R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F2R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F2R1_FB6      = 0x40       // Bit FB6.
	CAN_F2R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F2R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F2R1_FB7      = 0x80       // Bit FB7.
	CAN_F2R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F2R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F2R1_FB8      = 0x100      // Bit FB8.
	CAN_F2R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F2R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F2R1_FB9      = 0x200      // Bit FB9.
	CAN_F2R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F2R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F2R1_FB10     = 0x400      // Bit FB10.
	CAN_F2R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F2R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F2R1_FB11     = 0x800      // Bit FB11.
	CAN_F2R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F2R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F2R1_FB12     = 0x1000     // Bit FB12.
	CAN_F2R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F2R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F2R1_FB13     = 0x2000     // Bit FB13.
	CAN_F2R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F2R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F2R1_FB14     = 0x4000     // Bit FB14.
	CAN_F2R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F2R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F2R1_FB15     = 0x8000     // Bit FB15.
	CAN_F2R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F2R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F2R1_FB16     = 0x10000    // Bit FB16.
	CAN_F2R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F2R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F2R1_FB17     = 0x20000    // Bit FB17.
	CAN_F2R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F2R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F2R1_FB18     = 0x40000    // Bit FB18.
	CAN_F2R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F2R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F2R1_FB19     = 0x80000    // Bit FB19.
	CAN_F2R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F2R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F2R1_FB20     = 0x100000   // Bit FB20.
	CAN_F2R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F2R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F2R1_FB21     = 0x200000   // Bit FB21.
	CAN_F2R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F2R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F2R1_FB22     = 0x400000   // Bit FB22.
	CAN_F2R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F2R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F2R1_FB23     = 0x800000   // Bit FB23.
	CAN_F2R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F2R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F2R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F2R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F2R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F2R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F2R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F2R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F2R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F2R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F2R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F2R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F2R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F2R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F2R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F2R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F2R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F2R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F2R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F2R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F2R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F2R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F2R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F2R1_FB31     = 0x80000000 // Bit FB31.

	// F2R2: Filter bank 2 register 2
	CAN_F2R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F2R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F2R2_FB0      = 0x1        // Bit FB0.
	CAN_F2R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F2R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F2R2_FB1      = 0x2        // Bit FB1.
	CAN_F2R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F2R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F2R2_FB2      = 0x4        // Bit FB2.
	CAN_F2R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F2R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F2R2_FB3      = 0x8        // Bit FB3.
	CAN_F2R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F2R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F2R2_FB4      = 0x10       // Bit FB4.
	CAN_F2R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F2R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F2R2_FB5      = 0x20       // Bit FB5.
	CAN_F2R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F2R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F2R2_FB6      = 0x40       // Bit FB6.
	CAN_F2R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F2R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F2R2_FB7      = 0x80       // Bit FB7.
	CAN_F2R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F2R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F2R2_FB8      = 0x100      // Bit FB8.
	CAN_F2R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F2R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F2R2_FB9      = 0x200      // Bit FB9.
	CAN_F2R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F2R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F2R2_FB10     = 0x400      // Bit FB10.
	CAN_F2R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F2R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F2R2_FB11     = 0x800      // Bit FB11.
	CAN_F2R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F2R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F2R2_FB12     = 0x1000     // Bit FB12.
	CAN_F2R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F2R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F2R2_FB13     = 0x2000     // Bit FB13.
	CAN_F2R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F2R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F2R2_FB14     = 0x4000     // Bit FB14.
	CAN_F2R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F2R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F2R2_FB15     = 0x8000     // Bit FB15.
	CAN_F2R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F2R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F2R2_FB16     = 0x10000    // Bit FB16.
	CAN_F2R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F2R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F2R2_FB17     = 0x20000    // Bit FB17.
	CAN_F2R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F2R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F2R2_FB18     = 0x40000    // Bit FB18.
	CAN_F2R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F2R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F2R2_FB19     = 0x80000    // Bit FB19.
	CAN_F2R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F2R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F2R2_FB20     = 0x100000   // Bit FB20.
	CAN_F2R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F2R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F2R2_FB21     = 0x200000   // Bit FB21.
	CAN_F2R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F2R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F2R2_FB22     = 0x400000   // Bit FB22.
	CAN_F2R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F2R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F2R2_FB23     = 0x800000   // Bit FB23.
	CAN_F2R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F2R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F2R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F2R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F2R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F2R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F2R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F2R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F2R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F2R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F2R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F2R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F2R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F2R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F2R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F2R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F2R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F2R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F2R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F2R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F2R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F2R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F2R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F2R2_FB31     = 0x80000000 // Bit FB31.

	// F3R1: Filter bank 3 register 1
	CAN_F3R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F3R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F3R1_FB0      = 0x1        // Bit FB0.
	CAN_F3R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F3R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F3R1_FB1      = 0x2        // Bit FB1.
	CAN_F3R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F3R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F3R1_FB2      = 0x4        // Bit FB2.
	CAN_F3R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F3R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F3R1_FB3      = 0x8        // Bit FB3.
	CAN_F3R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F3R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F3R1_FB4      = 0x10       // Bit FB4.
	CAN_F3R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F3R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F3R1_FB5      = 0x20       // Bit FB5.
	CAN_F3R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F3R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F3R1_FB6      = 0x40       // Bit FB6.
	CAN_F3R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F3R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F3R1_FB7      = 0x80       // Bit FB7.
	CAN_F3R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F3R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F3R1_FB8      = 0x100      // Bit FB8.
	CAN_F3R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F3R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F3R1_FB9      = 0x200      // Bit FB9.
	CAN_F3R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F3R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F3R1_FB10     = 0x400      // Bit FB10.
	CAN_F3R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F3R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F3R1_FB11     = 0x800      // Bit FB11.
	CAN_F3R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F3R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F3R1_FB12     = 0x1000     // Bit FB12.
	CAN_F3R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F3R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F3R1_FB13     = 0x2000     // Bit FB13.
	CAN_F3R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F3R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F3R1_FB14     = 0x4000     // Bit FB14.
	CAN_F3R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F3R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F3R1_FB15     = 0x8000     // Bit FB15.
	CAN_F3R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F3R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F3R1_FB16     = 0x10000    // Bit FB16.
	CAN_F3R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F3R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F3R1_FB17     = 0x20000    // Bit FB17.
	CAN_F3R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F3R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F3R1_FB18     = 0x40000    // Bit FB18.
	CAN_F3R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F3R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F3R1_FB19     = 0x80000    // Bit FB19.
	CAN_F3R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F3R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F3R1_FB20     = 0x100000   // Bit FB20.
	CAN_F3R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F3R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F3R1_FB21     = 0x200000   // Bit FB21.
	CAN_F3R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F3R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F3R1_FB22     = 0x400000   // Bit FB22.
	CAN_F3R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F3R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F3R1_FB23     = 0x800000   // Bit FB23.
	CAN_F3R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F3R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F3R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F3R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F3R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F3R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F3R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F3R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F3R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F3R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F3R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F3R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F3R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F3R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F3R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F3R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F3R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F3R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F3R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F3R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F3R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F3R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F3R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F3R1_FB31     = 0x80000000 // Bit FB31.

	// F3R2: Filter bank 3 register 2
	CAN_F3R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F3R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F3R2_FB0      = 0x1        // Bit FB0.
	CAN_F3R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F3R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F3R2_FB1      = 0x2        // Bit FB1.
	CAN_F3R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F3R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F3R2_FB2      = 0x4        // Bit FB2.
	CAN_F3R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F3R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F3R2_FB3      = 0x8        // Bit FB3.
	CAN_F3R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F3R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F3R2_FB4      = 0x10       // Bit FB4.
	CAN_F3R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F3R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F3R2_FB5      = 0x20       // Bit FB5.
	CAN_F3R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F3R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F3R2_FB6      = 0x40       // Bit FB6.
	CAN_F3R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F3R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F3R2_FB7      = 0x80       // Bit FB7.
	CAN_F3R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F3R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F3R2_FB8      = 0x100      // Bit FB8.
	CAN_F3R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F3R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F3R2_FB9      = 0x200      // Bit FB9.
	CAN_F3R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F3R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F3R2_FB10     = 0x400      // Bit FB10.
	CAN_F3R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F3R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F3R2_FB11     = 0x800      // Bit FB11.
	CAN_F3R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F3R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F3R2_FB12     = 0x1000     // Bit FB12.
	CAN_F3R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F3R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F3R2_FB13     = 0x2000     // Bit FB13.
	CAN_F3R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F3R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F3R2_FB14     = 0x4000     // Bit FB14.
	CAN_F3R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F3R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F3R2_FB15     = 0x8000     // Bit FB15.
	CAN_F3R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F3R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F3R2_FB16     = 0x10000    // Bit FB16.
	CAN_F3R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F3R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F3R2_FB17     = 0x20000    // Bit FB17.
	CAN_F3R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F3R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F3R2_FB18     = 0x40000    // Bit FB18.
	CAN_F3R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F3R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F3R2_FB19     = 0x80000    // Bit FB19.
	CAN_F3R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F3R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F3R2_FB20     = 0x100000   // Bit FB20.
	CAN_F3R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F3R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F3R2_FB21     = 0x200000   // Bit FB21.
	CAN_F3R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F3R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F3R2_FB22     = 0x400000   // Bit FB22.
	CAN_F3R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F3R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F3R2_FB23     = 0x800000   // Bit FB23.
	CAN_F3R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F3R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F3R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F3R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F3R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F3R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F3R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F3R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F3R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F3R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F3R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F3R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F3R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F3R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F3R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F3R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F3R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F3R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F3R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F3R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F3R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F3R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F3R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F3R2_FB31     = 0x80000000 // Bit FB31.

	// F4R1: Filter bank 4 register 1
	CAN_F4R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F4R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F4R1_FB0      = 0x1        // Bit FB0.
	CAN_F4R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F4R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F4R1_FB1      = 0x2        // Bit FB1.
	CAN_F4R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F4R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F4R1_FB2      = 0x4        // Bit FB2.
	CAN_F4R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F4R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F4R1_FB3      = 0x8        // Bit FB3.
	CAN_F4R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F4R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F4R1_FB4      = 0x10       // Bit FB4.
	CAN_F4R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F4R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F4R1_FB5      = 0x20       // Bit FB5.
	CAN_F4R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F4R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F4R1_FB6      = 0x40       // Bit FB6.
	CAN_F4R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F4R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F4R1_FB7      = 0x80       // Bit FB7.
	CAN_F4R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F4R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F4R1_FB8      = 0x100      // Bit FB8.
	CAN_F4R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F4R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F4R1_FB9      = 0x200      // Bit FB9.
	CAN_F4R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F4R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F4R1_FB10     = 0x400      // Bit FB10.
	CAN_F4R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F4R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F4R1_FB11     = 0x800      // Bit FB11.
	CAN_F4R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F4R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F4R1_FB12     = 0x1000     // Bit FB12.
	CAN_F4R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F4R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F4R1_FB13     = 0x2000     // Bit FB13.
	CAN_F4R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F4R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F4R1_FB14     = 0x4000     // Bit FB14.
	CAN_F4R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F4R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F4R1_FB15     = 0x8000     // Bit FB15.
	CAN_F4R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F4R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F4R1_FB16     = 0x10000    // Bit FB16.
	CAN_F4R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F4R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F4R1_FB17     = 0x20000    // Bit FB17.
	CAN_F4R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F4R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F4R1_FB18     = 0x40000    // Bit FB18.
	CAN_F4R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F4R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F4R1_FB19     = 0x80000    // Bit FB19.
	CAN_F4R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F4R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F4R1_FB20     = 0x100000   // Bit FB20.
	CAN_F4R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F4R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F4R1_FB21     = 0x200000   // Bit FB21.
	CAN_F4R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F4R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F4R1_FB22     = 0x400000   // Bit FB22.
	CAN_F4R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F4R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F4R1_FB23     = 0x800000   // Bit FB23.
	CAN_F4R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F4R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F4R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F4R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F4R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F4R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F4R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F4R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F4R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F4R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F4R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F4R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F4R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F4R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F4R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F4R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F4R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F4R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F4R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F4R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F4R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F4R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F4R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F4R1_FB31     = 0x80000000 // Bit FB31.

	// F4R2: Filter bank 4 register 2
	CAN_F4R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F4R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F4R2_FB0      = 0x1        // Bit FB0.
	CAN_F4R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F4R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F4R2_FB1      = 0x2        // Bit FB1.
	CAN_F4R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F4R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F4R2_FB2      = 0x4        // Bit FB2.
	CAN_F4R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F4R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F4R2_FB3      = 0x8        // Bit FB3.
	CAN_F4R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F4R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F4R2_FB4      = 0x10       // Bit FB4.
	CAN_F4R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F4R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F4R2_FB5      = 0x20       // Bit FB5.
	CAN_F4R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F4R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F4R2_FB6      = 0x40       // Bit FB6.
	CAN_F4R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F4R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F4R2_FB7      = 0x80       // Bit FB7.
	CAN_F4R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F4R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F4R2_FB8      = 0x100      // Bit FB8.
	CAN_F4R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F4R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F4R2_FB9      = 0x200      // Bit FB9.
	CAN_F4R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F4R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F4R2_FB10     = 0x400      // Bit FB10.
	CAN_F4R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F4R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F4R2_FB11     = 0x800      // Bit FB11.
	CAN_F4R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F4R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F4R2_FB12     = 0x1000     // Bit FB12.
	CAN_F4R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F4R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F4R2_FB13     = 0x2000     // Bit FB13.
	CAN_F4R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F4R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F4R2_FB14     = 0x4000     // Bit FB14.
	CAN_F4R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F4R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F4R2_FB15     = 0x8000     // Bit FB15.
	CAN_F4R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F4R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F4R2_FB16     = 0x10000    // Bit FB16.
	CAN_F4R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F4R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F4R2_FB17     = 0x20000    // Bit FB17.
	CAN_F4R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F4R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F4R2_FB18     = 0x40000    // Bit FB18.
	CAN_F4R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F4R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F4R2_FB19     = 0x80000    // Bit FB19.
	CAN_F4R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F4R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F4R2_FB20     = 0x100000   // Bit FB20.
	CAN_F4R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F4R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F4R2_FB21     = 0x200000   // Bit FB21.
	CAN_F4R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F4R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F4R2_FB22     = 0x400000   // Bit FB22.
	CAN_F4R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F4R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F4R2_FB23     = 0x800000   // Bit FB23.
	CAN_F4R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F4R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F4R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F4R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F4R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F4R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F4R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F4R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F4R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F4R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F4R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F4R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F4R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F4R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F4R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F4R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F4R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F4R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F4R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F4R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F4R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F4R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F4R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F4R2_FB31     = 0x80000000 // Bit FB31.

	// F5R1: Filter bank 5 register 1
	CAN_F5R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F5R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F5R1_FB0      = 0x1        // Bit FB0.
	CAN_F5R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F5R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F5R1_FB1      = 0x2        // Bit FB1.
	CAN_F5R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F5R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F5R1_FB2      = 0x4        // Bit FB2.
	CAN_F5R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F5R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F5R1_FB3      = 0x8        // Bit FB3.
	CAN_F5R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F5R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F5R1_FB4      = 0x10       // Bit FB4.
	CAN_F5R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F5R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F5R1_FB5      = 0x20       // Bit FB5.
	CAN_F5R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F5R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F5R1_FB6      = 0x40       // Bit FB6.
	CAN_F5R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F5R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F5R1_FB7      = 0x80       // Bit FB7.
	CAN_F5R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F5R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F5R1_FB8      = 0x100      // Bit FB8.
	CAN_F5R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F5R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F5R1_FB9      = 0x200      // Bit FB9.
	CAN_F5R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F5R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F5R1_FB10     = 0x400      // Bit FB10.
	CAN_F5R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F5R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F5R1_FB11     = 0x800      // Bit FB11.
	CAN_F5R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F5R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F5R1_FB12     = 0x1000     // Bit FB12.
	CAN_F5R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F5R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F5R1_FB13     = 0x2000     // Bit FB13.
	CAN_F5R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F5R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F5R1_FB14     = 0x4000     // Bit FB14.
	CAN_F5R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F5R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F5R1_FB15     = 0x8000     // Bit FB15.
	CAN_F5R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F5R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F5R1_FB16     = 0x10000    // Bit FB16.
	CAN_F5R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F5R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F5R1_FB17     = 0x20000    // Bit FB17.
	CAN_F5R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F5R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F5R1_FB18     = 0x40000    // Bit FB18.
	CAN_F5R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F5R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F5R1_FB19     = 0x80000    // Bit FB19.
	CAN_F5R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F5R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F5R1_FB20     = 0x100000   // Bit FB20.
	CAN_F5R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F5R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F5R1_FB21     = 0x200000   // Bit FB21.
	CAN_F5R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F5R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F5R1_FB22     = 0x400000   // Bit FB22.
	CAN_F5R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F5R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F5R1_FB23     = 0x800000   // Bit FB23.
	CAN_F5R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F5R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F5R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F5R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F5R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F5R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F5R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F5R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F5R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F5R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F5R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F5R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F5R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F5R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F5R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F5R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F5R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F5R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F5R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F5R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F5R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F5R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F5R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F5R1_FB31     = 0x80000000 // Bit FB31.

	// F5R2: Filter bank 5 register 2
	CAN_F5R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F5R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F5R2_FB0      = 0x1        // Bit FB0.
	CAN_F5R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F5R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F5R2_FB1      = 0x2        // Bit FB1.
	CAN_F5R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F5R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F5R2_FB2      = 0x4        // Bit FB2.
	CAN_F5R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F5R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F5R2_FB3      = 0x8        // Bit FB3.
	CAN_F5R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F5R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F5R2_FB4      = 0x10       // Bit FB4.
	CAN_F5R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F5R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F5R2_FB5      = 0x20       // Bit FB5.
	CAN_F5R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F5R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F5R2_FB6      = 0x40       // Bit FB6.
	CAN_F5R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F5R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F5R2_FB7      = 0x80       // Bit FB7.
	CAN_F5R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F5R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F5R2_FB8      = 0x100      // Bit FB8.
	CAN_F5R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F5R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F5R2_FB9      = 0x200      // Bit FB9.
	CAN_F5R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F5R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F5R2_FB10     = 0x400      // Bit FB10.
	CAN_F5R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F5R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F5R2_FB11     = 0x800      // Bit FB11.
	CAN_F5R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F5R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F5R2_FB12     = 0x1000     // Bit FB12.
	CAN_F5R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F5R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F5R2_FB13     = 0x2000     // Bit FB13.
	CAN_F5R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F5R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F5R2_FB14     = 0x4000     // Bit FB14.
	CAN_F5R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F5R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F5R2_FB15     = 0x8000     // Bit FB15.
	CAN_F5R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F5R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F5R2_FB16     = 0x10000    // Bit FB16.
	CAN_F5R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F5R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F5R2_FB17     = 0x20000    // Bit FB17.
	CAN_F5R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F5R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F5R2_FB18     = 0x40000    // Bit FB18.
	CAN_F5R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F5R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F5R2_FB19     = 0x80000    // Bit FB19.
	CAN_F5R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F5R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F5R2_FB20     = 0x100000   // Bit FB20.
	CAN_F5R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F5R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F5R2_FB21     = 0x200000   // Bit FB21.
	CAN_F5R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F5R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F5R2_FB22     = 0x400000   // Bit FB22.
	CAN_F5R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F5R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F5R2_FB23     = 0x800000   // Bit FB23.
	CAN_F5R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F5R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F5R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F5R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F5R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F5R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F5R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F5R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F5R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F5R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F5R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F5R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F5R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F5R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F5R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F5R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F5R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F5R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F5R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F5R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F5R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F5R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F5R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F5R2_FB31     = 0x80000000 // Bit FB31.

	// F6R1: Filter bank 6 register 1
	CAN_F6R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F6R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F6R1_FB0      = 0x1        // Bit FB0.
	CAN_F6R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F6R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F6R1_FB1      = 0x2        // Bit FB1.
	CAN_F6R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F6R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F6R1_FB2      = 0x4        // Bit FB2.
	CAN_F6R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F6R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F6R1_FB3      = 0x8        // Bit FB3.
	CAN_F6R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F6R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F6R1_FB4      = 0x10       // Bit FB4.
	CAN_F6R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F6R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F6R1_FB5      = 0x20       // Bit FB5.
	CAN_F6R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F6R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F6R1_FB6      = 0x40       // Bit FB6.
	CAN_F6R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F6R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F6R1_FB7      = 0x80       // Bit FB7.
	CAN_F6R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F6R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F6R1_FB8      = 0x100      // Bit FB8.
	CAN_F6R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F6R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F6R1_FB9      = 0x200      // Bit FB9.
	CAN_F6R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F6R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F6R1_FB10     = 0x400      // Bit FB10.
	CAN_F6R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F6R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F6R1_FB11     = 0x800      // Bit FB11.
	CAN_F6R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F6R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F6R1_FB12     = 0x1000     // Bit FB12.
	CAN_F6R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F6R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F6R1_FB13     = 0x2000     // Bit FB13.
	CAN_F6R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F6R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F6R1_FB14     = 0x4000     // Bit FB14.
	CAN_F6R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F6R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F6R1_FB15     = 0x8000     // Bit FB15.
	CAN_F6R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F6R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F6R1_FB16     = 0x10000    // Bit FB16.
	CAN_F6R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F6R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F6R1_FB17     = 0x20000    // Bit FB17.
	CAN_F6R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F6R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F6R1_FB18     = 0x40000    // Bit FB18.
	CAN_F6R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F6R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F6R1_FB19     = 0x80000    // Bit FB19.
	CAN_F6R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F6R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F6R1_FB20     = 0x100000   // Bit FB20.
	CAN_F6R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F6R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F6R1_FB21     = 0x200000   // Bit FB21.
	CAN_F6R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F6R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F6R1_FB22     = 0x400000   // Bit FB22.
	CAN_F6R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F6R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F6R1_FB23     = 0x800000   // Bit FB23.
	CAN_F6R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F6R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F6R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F6R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F6R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F6R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F6R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F6R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F6R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F6R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F6R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F6R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F6R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F6R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F6R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F6R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F6R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F6R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F6R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F6R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F6R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F6R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F6R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F6R1_FB31     = 0x80000000 // Bit FB31.

	// F6R2: Filter bank 6 register 2
	CAN_F6R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F6R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F6R2_FB0      = 0x1        // Bit FB0.
	CAN_F6R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F6R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F6R2_FB1      = 0x2        // Bit FB1.
	CAN_F6R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F6R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F6R2_FB2      = 0x4        // Bit FB2.
	CAN_F6R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F6R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F6R2_FB3      = 0x8        // Bit FB3.
	CAN_F6R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F6R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F6R2_FB4      = 0x10       // Bit FB4.
	CAN_F6R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F6R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F6R2_FB5      = 0x20       // Bit FB5.
	CAN_F6R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F6R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F6R2_FB6      = 0x40       // Bit FB6.
	CAN_F6R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F6R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F6R2_FB7      = 0x80       // Bit FB7.
	CAN_F6R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F6R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F6R2_FB8      = 0x100      // Bit FB8.
	CAN_F6R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F6R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F6R2_FB9      = 0x200      // Bit FB9.
	CAN_F6R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F6R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F6R2_FB10     = 0x400      // Bit FB10.
	CAN_F6R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F6R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F6R2_FB11     = 0x800      // Bit FB11.
	CAN_F6R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F6R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F6R2_FB12     = 0x1000     // Bit FB12.
	CAN_F6R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F6R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F6R2_FB13     = 0x2000     // Bit FB13.
	CAN_F6R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F6R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F6R2_FB14     = 0x4000     // Bit FB14.
	CAN_F6R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F6R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F6R2_FB15     = 0x8000     // Bit FB15.
	CAN_F6R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F6R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F6R2_FB16     = 0x10000    // Bit FB16.
	CAN_F6R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F6R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F6R2_FB17     = 0x20000    // Bit FB17.
	CAN_F6R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F6R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F6R2_FB18     = 0x40000    // Bit FB18.
	CAN_F6R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F6R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F6R2_FB19     = 0x80000    // Bit FB19.
	CAN_F6R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F6R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F6R2_FB20     = 0x100000   // Bit FB20.
	CAN_F6R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F6R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F6R2_FB21     = 0x200000   // Bit FB21.
	CAN_F6R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F6R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F6R2_FB22     = 0x400000   // Bit FB22.
	CAN_F6R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F6R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F6R2_FB23     = 0x800000   // Bit FB23.
	CAN_F6R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F6R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F6R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F6R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F6R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F6R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F6R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F6R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F6R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F6R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F6R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F6R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F6R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F6R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F6R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F6R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F6R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F6R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F6R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F6R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F6R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F6R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F6R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F6R2_FB31     = 0x80000000 // Bit FB31.

	// F7R1: Filter bank 7 register 1
	CAN_F7R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F7R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F7R1_FB0      = 0x1        // Bit FB0.
	CAN_F7R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F7R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F7R1_FB1      = 0x2        // Bit FB1.
	CAN_F7R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F7R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F7R1_FB2      = 0x4        // Bit FB2.
	CAN_F7R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F7R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F7R1_FB3      = 0x8        // Bit FB3.
	CAN_F7R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F7R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F7R1_FB4      = 0x10       // Bit FB4.
	CAN_F7R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F7R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F7R1_FB5      = 0x20       // Bit FB5.
	CAN_F7R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F7R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F7R1_FB6      = 0x40       // Bit FB6.
	CAN_F7R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F7R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F7R1_FB7      = 0x80       // Bit FB7.
	CAN_F7R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F7R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F7R1_FB8      = 0x100      // Bit FB8.
	CAN_F7R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F7R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F7R1_FB9      = 0x200      // Bit FB9.
	CAN_F7R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F7R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F7R1_FB10     = 0x400      // Bit FB10.
	CAN_F7R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F7R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F7R1_FB11     = 0x800      // Bit FB11.
	CAN_F7R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F7R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F7R1_FB12     = 0x1000     // Bit FB12.
	CAN_F7R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F7R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F7R1_FB13     = 0x2000     // Bit FB13.
	CAN_F7R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F7R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F7R1_FB14     = 0x4000     // Bit FB14.
	CAN_F7R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F7R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F7R1_FB15     = 0x8000     // Bit FB15.
	CAN_F7R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F7R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F7R1_FB16     = 0x10000    // Bit FB16.
	CAN_F7R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F7R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F7R1_FB17     = 0x20000    // Bit FB17.
	CAN_F7R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F7R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F7R1_FB18     = 0x40000    // Bit FB18.
	CAN_F7R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F7R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F7R1_FB19     = 0x80000    // Bit FB19.
	CAN_F7R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F7R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F7R1_FB20     = 0x100000   // Bit FB20.
	CAN_F7R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F7R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F7R1_FB21     = 0x200000   // Bit FB21.
	CAN_F7R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F7R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F7R1_FB22     = 0x400000   // Bit FB22.
	CAN_F7R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F7R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F7R1_FB23     = 0x800000   // Bit FB23.
	CAN_F7R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F7R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F7R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F7R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F7R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F7R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F7R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F7R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F7R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F7R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F7R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F7R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F7R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F7R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F7R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F7R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F7R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F7R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F7R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F7R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F7R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F7R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F7R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F7R1_FB31     = 0x80000000 // Bit FB31.

	// F7R2: Filter bank 7 register 2
	CAN_F7R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F7R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F7R2_FB0      = 0x1        // Bit FB0.
	CAN_F7R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F7R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F7R2_FB1      = 0x2        // Bit FB1.
	CAN_F7R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F7R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F7R2_FB2      = 0x4        // Bit FB2.
	CAN_F7R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F7R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F7R2_FB3      = 0x8        // Bit FB3.
	CAN_F7R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F7R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F7R2_FB4      = 0x10       // Bit FB4.
	CAN_F7R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F7R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F7R2_FB5      = 0x20       // Bit FB5.
	CAN_F7R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F7R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F7R2_FB6      = 0x40       // Bit FB6.
	CAN_F7R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F7R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F7R2_FB7      = 0x80       // Bit FB7.
	CAN_F7R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F7R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F7R2_FB8      = 0x100      // Bit FB8.
	CAN_F7R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F7R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F7R2_FB9      = 0x200      // Bit FB9.
	CAN_F7R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F7R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F7R2_FB10     = 0x400      // Bit FB10.
	CAN_F7R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F7R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F7R2_FB11     = 0x800      // Bit FB11.
	CAN_F7R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F7R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F7R2_FB12     = 0x1000     // Bit FB12.
	CAN_F7R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F7R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F7R2_FB13     = 0x2000     // Bit FB13.
	CAN_F7R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F7R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F7R2_FB14     = 0x4000     // Bit FB14.
	CAN_F7R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F7R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F7R2_FB15     = 0x8000     // Bit FB15.
	CAN_F7R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F7R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F7R2_FB16     = 0x10000    // Bit FB16.
	CAN_F7R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F7R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F7R2_FB17     = 0x20000    // Bit FB17.
	CAN_F7R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F7R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F7R2_FB18     = 0x40000    // Bit FB18.
	CAN_F7R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F7R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F7R2_FB19     = 0x80000    // Bit FB19.
	CAN_F7R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F7R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F7R2_FB20     = 0x100000   // Bit FB20.
	CAN_F7R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F7R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F7R2_FB21     = 0x200000   // Bit FB21.
	CAN_F7R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F7R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F7R2_FB22     = 0x400000   // Bit FB22.
	CAN_F7R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F7R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F7R2_FB23     = 0x800000   // Bit FB23.
	CAN_F7R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F7R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F7R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F7R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F7R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F7R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F7R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F7R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F7R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F7R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F7R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F7R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F7R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F7R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F7R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F7R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F7R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F7R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F7R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F7R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F7R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F7R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F7R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F7R2_FB31     = 0x80000000 // Bit FB31.

	// F8R1: Filter bank 8 register 1
	CAN_F8R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F8R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F8R1_FB0      = 0x1        // Bit FB0.
	CAN_F8R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F8R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F8R1_FB1      = 0x2        // Bit FB1.
	CAN_F8R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F8R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F8R1_FB2      = 0x4        // Bit FB2.
	CAN_F8R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F8R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F8R1_FB3      = 0x8        // Bit FB3.
	CAN_F8R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F8R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F8R1_FB4      = 0x10       // Bit FB4.
	CAN_F8R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F8R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F8R1_FB5      = 0x20       // Bit FB5.
	CAN_F8R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F8R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F8R1_FB6      = 0x40       // Bit FB6.
	CAN_F8R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F8R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F8R1_FB7      = 0x80       // Bit FB7.
	CAN_F8R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F8R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F8R1_FB8      = 0x100      // Bit FB8.
	CAN_F8R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F8R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F8R1_FB9      = 0x200      // Bit FB9.
	CAN_F8R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F8R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F8R1_FB10     = 0x400      // Bit FB10.
	CAN_F8R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F8R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F8R1_FB11     = 0x800      // Bit FB11.
	CAN_F8R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F8R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F8R1_FB12     = 0x1000     // Bit FB12.
	CAN_F8R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F8R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F8R1_FB13     = 0x2000     // Bit FB13.
	CAN_F8R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F8R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F8R1_FB14     = 0x4000     // Bit FB14.
	CAN_F8R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F8R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F8R1_FB15     = 0x8000     // Bit FB15.
	CAN_F8R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F8R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F8R1_FB16     = 0x10000    // Bit FB16.
	CAN_F8R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F8R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F8R1_FB17     = 0x20000    // Bit FB17.
	CAN_F8R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F8R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F8R1_FB18     = 0x40000    // Bit FB18.
	CAN_F8R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F8R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F8R1_FB19     = 0x80000    // Bit FB19.
	CAN_F8R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F8R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F8R1_FB20     = 0x100000   // Bit FB20.
	CAN_F8R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F8R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F8R1_FB21     = 0x200000   // Bit FB21.
	CAN_F8R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F8R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F8R1_FB22     = 0x400000   // Bit FB22.
	CAN_F8R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F8R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F8R1_FB23     = 0x800000   // Bit FB23.
	CAN_F8R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F8R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F8R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F8R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F8R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F8R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F8R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F8R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F8R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F8R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F8R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F8R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F8R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F8R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F8R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F8R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F8R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F8R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F8R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F8R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F8R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F8R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F8R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F8R1_FB31     = 0x80000000 // Bit FB31.

	// F8R2: Filter bank 8 register 2
	CAN_F8R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F8R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F8R2_FB0      = 0x1        // Bit FB0.
	CAN_F8R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F8R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F8R2_FB1      = 0x2        // Bit FB1.
	CAN_F8R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F8R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F8R2_FB2      = 0x4        // Bit FB2.
	CAN_F8R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F8R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F8R2_FB3      = 0x8        // Bit FB3.
	CAN_F8R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F8R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F8R2_FB4      = 0x10       // Bit FB4.
	CAN_F8R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F8R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F8R2_FB5      = 0x20       // Bit FB5.
	CAN_F8R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F8R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F8R2_FB6      = 0x40       // Bit FB6.
	CAN_F8R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F8R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F8R2_FB7      = 0x80       // Bit FB7.
	CAN_F8R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F8R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F8R2_FB8      = 0x100      // Bit FB8.
	CAN_F8R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F8R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F8R2_FB9      = 0x200      // Bit FB9.
	CAN_F8R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F8R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F8R2_FB10     = 0x400      // Bit FB10.
	CAN_F8R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F8R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F8R2_FB11     = 0x800      // Bit FB11.
	CAN_F8R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F8R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F8R2_FB12     = 0x1000     // Bit FB12.
	CAN_F8R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F8R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F8R2_FB13     = 0x2000     // Bit FB13.
	CAN_F8R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F8R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F8R2_FB14     = 0x4000     // Bit FB14.
	CAN_F8R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F8R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F8R2_FB15     = 0x8000     // Bit FB15.
	CAN_F8R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F8R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F8R2_FB16     = 0x10000    // Bit FB16.
	CAN_F8R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F8R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F8R2_FB17     = 0x20000    // Bit FB17.
	CAN_F8R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F8R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F8R2_FB18     = 0x40000    // Bit FB18.
	CAN_F8R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F8R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F8R2_FB19     = 0x80000    // Bit FB19.
	CAN_F8R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F8R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F8R2_FB20     = 0x100000   // Bit FB20.
	CAN_F8R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F8R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F8R2_FB21     = 0x200000   // Bit FB21.
	CAN_F8R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F8R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F8R2_FB22     = 0x400000   // Bit FB22.
	CAN_F8R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F8R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F8R2_FB23     = 0x800000   // Bit FB23.
	CAN_F8R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F8R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F8R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F8R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F8R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F8R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F8R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F8R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F8R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F8R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F8R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F8R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F8R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F8R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F8R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F8R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F8R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F8R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F8R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F8R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F8R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F8R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F8R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F8R2_FB31     = 0x80000000 // Bit FB31.

	// F9R1: Filter bank 9 register 1
	CAN_F9R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F9R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F9R1_FB0      = 0x1        // Bit FB0.
	CAN_F9R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F9R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F9R1_FB1      = 0x2        // Bit FB1.
	CAN_F9R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F9R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F9R1_FB2      = 0x4        // Bit FB2.
	CAN_F9R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F9R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F9R1_FB3      = 0x8        // Bit FB3.
	CAN_F9R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F9R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F9R1_FB4      = 0x10       // Bit FB4.
	CAN_F9R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F9R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F9R1_FB5      = 0x20       // Bit FB5.
	CAN_F9R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F9R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F9R1_FB6      = 0x40       // Bit FB6.
	CAN_F9R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F9R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F9R1_FB7      = 0x80       // Bit FB7.
	CAN_F9R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F9R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F9R1_FB8      = 0x100      // Bit FB8.
	CAN_F9R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F9R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F9R1_FB9      = 0x200      // Bit FB9.
	CAN_F9R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F9R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F9R1_FB10     = 0x400      // Bit FB10.
	CAN_F9R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F9R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F9R1_FB11     = 0x800      // Bit FB11.
	CAN_F9R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F9R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F9R1_FB12     = 0x1000     // Bit FB12.
	CAN_F9R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F9R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F9R1_FB13     = 0x2000     // Bit FB13.
	CAN_F9R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F9R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F9R1_FB14     = 0x4000     // Bit FB14.
	CAN_F9R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F9R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F9R1_FB15     = 0x8000     // Bit FB15.
	CAN_F9R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F9R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F9R1_FB16     = 0x10000    // Bit FB16.
	CAN_F9R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F9R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F9R1_FB17     = 0x20000    // Bit FB17.
	CAN_F9R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F9R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F9R1_FB18     = 0x40000    // Bit FB18.
	CAN_F9R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F9R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F9R1_FB19     = 0x80000    // Bit FB19.
	CAN_F9R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F9R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F9R1_FB20     = 0x100000   // Bit FB20.
	CAN_F9R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F9R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F9R1_FB21     = 0x200000   // Bit FB21.
	CAN_F9R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F9R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F9R1_FB22     = 0x400000   // Bit FB22.
	CAN_F9R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F9R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F9R1_FB23     = 0x800000   // Bit FB23.
	CAN_F9R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F9R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F9R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F9R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F9R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F9R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F9R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F9R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F9R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F9R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F9R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F9R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F9R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F9R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F9R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F9R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F9R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F9R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F9R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F9R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F9R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F9R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F9R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F9R1_FB31     = 0x80000000 // Bit FB31.

	// F9R2: Filter bank 9 register 2
	CAN_F9R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F9R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F9R2_FB0      = 0x1        // Bit FB0.
	CAN_F9R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F9R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F9R2_FB1      = 0x2        // Bit FB1.
	CAN_F9R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F9R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F9R2_FB2      = 0x4        // Bit FB2.
	CAN_F9R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F9R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F9R2_FB3      = 0x8        // Bit FB3.
	CAN_F9R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F9R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F9R2_FB4      = 0x10       // Bit FB4.
	CAN_F9R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F9R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F9R2_FB5      = 0x20       // Bit FB5.
	CAN_F9R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F9R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F9R2_FB6      = 0x40       // Bit FB6.
	CAN_F9R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F9R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F9R2_FB7      = 0x80       // Bit FB7.
	CAN_F9R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F9R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F9R2_FB8      = 0x100      // Bit FB8.
	CAN_F9R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F9R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F9R2_FB9      = 0x200      // Bit FB9.
	CAN_F9R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F9R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F9R2_FB10     = 0x400      // Bit FB10.
	CAN_F9R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F9R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F9R2_FB11     = 0x800      // Bit FB11.
	CAN_F9R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F9R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F9R2_FB12     = 0x1000     // Bit FB12.
	CAN_F9R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F9R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F9R2_FB13     = 0x2000     // Bit FB13.
	CAN_F9R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F9R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F9R2_FB14     = 0x4000     // Bit FB14.
	CAN_F9R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F9R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F9R2_FB15     = 0x8000     // Bit FB15.
	CAN_F9R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F9R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F9R2_FB16     = 0x10000    // Bit FB16.
	CAN_F9R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F9R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F9R2_FB17     = 0x20000    // Bit FB17.
	CAN_F9R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F9R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F9R2_FB18     = 0x40000    // Bit FB18.
	CAN_F9R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F9R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F9R2_FB19     = 0x80000    // Bit FB19.
	CAN_F9R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F9R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F9R2_FB20     = 0x100000   // Bit FB20.
	CAN_F9R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F9R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F9R2_FB21     = 0x200000   // Bit FB21.
	CAN_F9R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F9R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F9R2_FB22     = 0x400000   // Bit FB22.
	CAN_F9R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F9R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F9R2_FB23     = 0x800000   // Bit FB23.
	CAN_F9R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F9R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F9R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F9R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F9R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F9R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F9R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F9R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F9R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F9R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F9R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F9R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F9R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F9R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F9R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F9R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F9R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F9R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F9R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F9R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F9R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F9R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F9R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F9R2_FB31     = 0x80000000 // Bit FB31.

	// F10R1: Filter bank 10 register 1
	CAN_F10R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F10R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F10R1_FB0      = 0x1        // Bit FB0.
	CAN_F10R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F10R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F10R1_FB1      = 0x2        // Bit FB1.
	CAN_F10R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F10R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F10R1_FB2      = 0x4        // Bit FB2.
	CAN_F10R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F10R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F10R1_FB3      = 0x8        // Bit FB3.
	CAN_F10R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F10R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F10R1_FB4      = 0x10       // Bit FB4.
	CAN_F10R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F10R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F10R1_FB5      = 0x20       // Bit FB5.
	CAN_F10R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F10R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F10R1_FB6      = 0x40       // Bit FB6.
	CAN_F10R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F10R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F10R1_FB7      = 0x80       // Bit FB7.
	CAN_F10R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F10R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F10R1_FB8      = 0x100      // Bit FB8.
	CAN_F10R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F10R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F10R1_FB9      = 0x200      // Bit FB9.
	CAN_F10R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F10R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F10R1_FB10     = 0x400      // Bit FB10.
	CAN_F10R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F10R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F10R1_FB11     = 0x800      // Bit FB11.
	CAN_F10R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F10R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F10R1_FB12     = 0x1000     // Bit FB12.
	CAN_F10R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F10R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F10R1_FB13     = 0x2000     // Bit FB13.
	CAN_F10R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F10R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F10R1_FB14     = 0x4000     // Bit FB14.
	CAN_F10R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F10R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F10R1_FB15     = 0x8000     // Bit FB15.
	CAN_F10R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F10R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F10R1_FB16     = 0x10000    // Bit FB16.
	CAN_F10R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F10R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F10R1_FB17     = 0x20000    // Bit FB17.
	CAN_F10R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F10R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F10R1_FB18     = 0x40000    // Bit FB18.
	CAN_F10R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F10R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F10R1_FB19     = 0x80000    // Bit FB19.
	CAN_F10R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F10R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F10R1_FB20     = 0x100000   // Bit FB20.
	CAN_F10R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F10R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F10R1_FB21     = 0x200000   // Bit FB21.
	CAN_F10R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F10R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F10R1_FB22     = 0x400000   // Bit FB22.
	CAN_F10R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F10R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F10R1_FB23     = 0x800000   // Bit FB23.
	CAN_F10R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F10R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F10R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F10R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F10R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F10R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F10R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F10R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F10R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F10R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F10R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F10R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F10R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F10R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F10R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F10R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F10R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F10R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F10R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F10R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F10R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F10R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F10R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F10R1_FB31     = 0x80000000 // Bit FB31.

	// F10R2: Filter bank 10 register 2
	CAN_F10R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F10R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F10R2_FB0      = 0x1        // Bit FB0.
	CAN_F10R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F10R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F10R2_FB1      = 0x2        // Bit FB1.
	CAN_F10R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F10R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F10R2_FB2      = 0x4        // Bit FB2.
	CAN_F10R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F10R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F10R2_FB3      = 0x8        // Bit FB3.
	CAN_F10R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F10R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F10R2_FB4      = 0x10       // Bit FB4.
	CAN_F10R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F10R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F10R2_FB5      = 0x20       // Bit FB5.
	CAN_F10R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F10R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F10R2_FB6      = 0x40       // Bit FB6.
	CAN_F10R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F10R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F10R2_FB7      = 0x80       // Bit FB7.
	CAN_F10R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F10R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F10R2_FB8      = 0x100      // Bit FB8.
	CAN_F10R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F10R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F10R2_FB9      = 0x200      // Bit FB9.
	CAN_F10R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F10R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F10R2_FB10     = 0x400      // Bit FB10.
	CAN_F10R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F10R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F10R2_FB11     = 0x800      // Bit FB11.
	CAN_F10R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F10R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F10R2_FB12     = 0x1000     // Bit FB12.
	CAN_F10R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F10R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F10R2_FB13     = 0x2000     // Bit FB13.
	CAN_F10R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F10R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F10R2_FB14     = 0x4000     // Bit FB14.
	CAN_F10R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F10R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F10R2_FB15     = 0x8000     // Bit FB15.
	CAN_F10R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F10R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F10R2_FB16     = 0x10000    // Bit FB16.
	CAN_F10R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F10R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F10R2_FB17     = 0x20000    // Bit FB17.
	CAN_F10R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F10R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F10R2_FB18     = 0x40000    // Bit FB18.
	CAN_F10R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F10R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F10R2_FB19     = 0x80000    // Bit FB19.
	CAN_F10R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F10R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F10R2_FB20     = 0x100000   // Bit FB20.
	CAN_F10R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F10R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F10R2_FB21     = 0x200000   // Bit FB21.
	CAN_F10R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F10R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F10R2_FB22     = 0x400000   // Bit FB22.
	CAN_F10R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F10R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F10R2_FB23     = 0x800000   // Bit FB23.
	CAN_F10R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F10R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F10R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F10R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F10R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F10R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F10R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F10R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F10R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F10R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F10R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F10R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F10R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F10R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F10R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F10R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F10R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F10R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F10R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F10R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F10R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F10R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F10R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F10R2_FB31     = 0x80000000 // Bit FB31.

	// F11R1: Filter bank 11 register 1
	CAN_F11R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F11R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F11R1_FB0      = 0x1        // Bit FB0.
	CAN_F11R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F11R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F11R1_FB1      = 0x2        // Bit FB1.
	CAN_F11R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F11R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F11R1_FB2      = 0x4        // Bit FB2.
	CAN_F11R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F11R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F11R1_FB3      = 0x8        // Bit FB3.
	CAN_F11R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F11R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F11R1_FB4      = 0x10       // Bit FB4.
	CAN_F11R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F11R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F11R1_FB5      = 0x20       // Bit FB5.
	CAN_F11R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F11R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F11R1_FB6      = 0x40       // Bit FB6.
	CAN_F11R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F11R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F11R1_FB7      = 0x80       // Bit FB7.
	CAN_F11R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F11R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F11R1_FB8      = 0x100      // Bit FB8.
	CAN_F11R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F11R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F11R1_FB9      = 0x200      // Bit FB9.
	CAN_F11R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F11R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F11R1_FB10     = 0x400      // Bit FB10.
	CAN_F11R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F11R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F11R1_FB11     = 0x800      // Bit FB11.
	CAN_F11R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F11R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F11R1_FB12     = 0x1000     // Bit FB12.
	CAN_F11R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F11R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F11R1_FB13     = 0x2000     // Bit FB13.
	CAN_F11R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F11R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F11R1_FB14     = 0x4000     // Bit FB14.
	CAN_F11R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F11R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F11R1_FB15     = 0x8000     // Bit FB15.
	CAN_F11R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F11R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F11R1_FB16     = 0x10000    // Bit FB16.
	CAN_F11R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F11R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F11R1_FB17     = 0x20000    // Bit FB17.
	CAN_F11R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F11R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F11R1_FB18     = 0x40000    // Bit FB18.
	CAN_F11R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F11R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F11R1_FB19     = 0x80000    // Bit FB19.
	CAN_F11R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F11R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F11R1_FB20     = 0x100000   // Bit FB20.
	CAN_F11R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F11R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F11R1_FB21     = 0x200000   // Bit FB21.
	CAN_F11R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F11R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F11R1_FB22     = 0x400000   // Bit FB22.
	CAN_F11R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F11R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F11R1_FB23     = 0x800000   // Bit FB23.
	CAN_F11R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F11R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F11R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F11R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F11R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F11R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F11R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F11R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F11R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F11R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F11R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F11R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F11R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F11R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F11R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F11R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F11R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F11R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F11R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F11R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F11R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F11R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F11R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F11R1_FB31     = 0x80000000 // Bit FB31.

	// F11R2: Filter bank 11 register 2
	CAN_F11R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F11R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F11R2_FB0      = 0x1        // Bit FB0.
	CAN_F11R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F11R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F11R2_FB1      = 0x2        // Bit FB1.
	CAN_F11R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F11R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F11R2_FB2      = 0x4        // Bit FB2.
	CAN_F11R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F11R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F11R2_FB3      = 0x8        // Bit FB3.
	CAN_F11R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F11R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F11R2_FB4      = 0x10       // Bit FB4.
	CAN_F11R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F11R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F11R2_FB5      = 0x20       // Bit FB5.
	CAN_F11R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F11R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F11R2_FB6      = 0x40       // Bit FB6.
	CAN_F11R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F11R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F11R2_FB7      = 0x80       // Bit FB7.
	CAN_F11R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F11R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F11R2_FB8      = 0x100      // Bit FB8.
	CAN_F11R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F11R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F11R2_FB9      = 0x200      // Bit FB9.
	CAN_F11R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F11R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F11R2_FB10     = 0x400      // Bit FB10.
	CAN_F11R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F11R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F11R2_FB11     = 0x800      // Bit FB11.
	CAN_F11R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F11R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F11R2_FB12     = 0x1000     // Bit FB12.
	CAN_F11R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F11R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F11R2_FB13     = 0x2000     // Bit FB13.
	CAN_F11R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F11R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F11R2_FB14     = 0x4000     // Bit FB14.
	CAN_F11R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F11R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F11R2_FB15     = 0x8000     // Bit FB15.
	CAN_F11R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F11R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F11R2_FB16     = 0x10000    // Bit FB16.
	CAN_F11R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F11R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F11R2_FB17     = 0x20000    // Bit FB17.
	CAN_F11R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F11R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F11R2_FB18     = 0x40000    // Bit FB18.
	CAN_F11R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F11R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F11R2_FB19     = 0x80000    // Bit FB19.
	CAN_F11R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F11R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F11R2_FB20     = 0x100000   // Bit FB20.
	CAN_F11R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F11R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F11R2_FB21     = 0x200000   // Bit FB21.
	CAN_F11R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F11R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F11R2_FB22     = 0x400000   // Bit FB22.
	CAN_F11R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F11R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F11R2_FB23     = 0x800000   // Bit FB23.
	CAN_F11R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F11R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F11R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F11R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F11R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F11R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F11R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F11R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F11R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F11R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F11R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F11R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F11R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F11R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F11R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F11R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F11R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F11R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F11R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F11R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F11R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F11R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F11R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F11R2_FB31     = 0x80000000 // Bit FB31.

	// F12R1: Filter bank 4 register 1
	CAN_F12R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F12R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F12R1_FB0      = 0x1        // Bit FB0.
	CAN_F12R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F12R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F12R1_FB1      = 0x2        // Bit FB1.
	CAN_F12R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F12R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F12R1_FB2      = 0x4        // Bit FB2.
	CAN_F12R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F12R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F12R1_FB3      = 0x8        // Bit FB3.
	CAN_F12R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F12R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F12R1_FB4      = 0x10       // Bit FB4.
	CAN_F12R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F12R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F12R1_FB5      = 0x20       // Bit FB5.
	CAN_F12R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F12R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F12R1_FB6      = 0x40       // Bit FB6.
	CAN_F12R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F12R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F12R1_FB7      = 0x80       // Bit FB7.
	CAN_F12R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F12R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F12R1_FB8      = 0x100      // Bit FB8.
	CAN_F12R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F12R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F12R1_FB9      = 0x200      // Bit FB9.
	CAN_F12R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F12R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F12R1_FB10     = 0x400      // Bit FB10.
	CAN_F12R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F12R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F12R1_FB11     = 0x800      // Bit FB11.
	CAN_F12R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F12R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F12R1_FB12     = 0x1000     // Bit FB12.
	CAN_F12R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F12R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F12R1_FB13     = 0x2000     // Bit FB13.
	CAN_F12R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F12R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F12R1_FB14     = 0x4000     // Bit FB14.
	CAN_F12R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F12R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F12R1_FB15     = 0x8000     // Bit FB15.
	CAN_F12R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F12R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F12R1_FB16     = 0x10000    // Bit FB16.
	CAN_F12R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F12R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F12R1_FB17     = 0x20000    // Bit FB17.
	CAN_F12R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F12R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F12R1_FB18     = 0x40000    // Bit FB18.
	CAN_F12R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F12R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F12R1_FB19     = 0x80000    // Bit FB19.
	CAN_F12R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F12R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F12R1_FB20     = 0x100000   // Bit FB20.
	CAN_F12R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F12R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F12R1_FB21     = 0x200000   // Bit FB21.
	CAN_F12R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F12R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F12R1_FB22     = 0x400000   // Bit FB22.
	CAN_F12R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F12R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F12R1_FB23     = 0x800000   // Bit FB23.
	CAN_F12R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F12R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F12R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F12R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F12R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F12R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F12R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F12R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F12R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F12R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F12R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F12R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F12R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F12R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F12R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F12R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F12R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F12R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F12R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F12R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F12R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F12R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F12R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F12R1_FB31     = 0x80000000 // Bit FB31.

	// F12R2: Filter bank 12 register 2
	CAN_F12R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F12R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F12R2_FB0      = 0x1        // Bit FB0.
	CAN_F12R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F12R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F12R2_FB1      = 0x2        // Bit FB1.
	CAN_F12R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F12R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F12R2_FB2      = 0x4        // Bit FB2.
	CAN_F12R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F12R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F12R2_FB3      = 0x8        // Bit FB3.
	CAN_F12R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F12R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F12R2_FB4      = 0x10       // Bit FB4.
	CAN_F12R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F12R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F12R2_FB5      = 0x20       // Bit FB5.
	CAN_F12R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F12R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F12R2_FB6      = 0x40       // Bit FB6.
	CAN_F12R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F12R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F12R2_FB7      = 0x80       // Bit FB7.
	CAN_F12R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F12R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F12R2_FB8      = 0x100      // Bit FB8.
	CAN_F12R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F12R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F12R2_FB9      = 0x200      // Bit FB9.
	CAN_F12R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F12R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F12R2_FB10     = 0x400      // Bit FB10.
	CAN_F12R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F12R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F12R2_FB11     = 0x800      // Bit FB11.
	CAN_F12R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F12R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F12R2_FB12     = 0x1000     // Bit FB12.
	CAN_F12R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F12R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F12R2_FB13     = 0x2000     // Bit FB13.
	CAN_F12R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F12R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F12R2_FB14     = 0x4000     // Bit FB14.
	CAN_F12R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F12R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F12R2_FB15     = 0x8000     // Bit FB15.
	CAN_F12R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F12R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F12R2_FB16     = 0x10000    // Bit FB16.
	CAN_F12R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F12R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F12R2_FB17     = 0x20000    // Bit FB17.
	CAN_F12R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F12R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F12R2_FB18     = 0x40000    // Bit FB18.
	CAN_F12R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F12R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F12R2_FB19     = 0x80000    // Bit FB19.
	CAN_F12R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F12R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F12R2_FB20     = 0x100000   // Bit FB20.
	CAN_F12R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F12R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F12R2_FB21     = 0x200000   // Bit FB21.
	CAN_F12R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F12R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F12R2_FB22     = 0x400000   // Bit FB22.
	CAN_F12R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F12R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F12R2_FB23     = 0x800000   // Bit FB23.
	CAN_F12R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F12R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F12R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F12R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F12R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F12R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F12R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F12R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F12R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F12R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F12R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F12R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F12R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F12R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F12R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F12R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F12R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F12R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F12R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F12R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F12R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F12R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F12R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F12R2_FB31     = 0x80000000 // Bit FB31.

	// F13R1: Filter bank 13 register 1
	CAN_F13R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F13R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F13R1_FB0      = 0x1        // Bit FB0.
	CAN_F13R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F13R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F13R1_FB1      = 0x2        // Bit FB1.
	CAN_F13R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F13R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F13R1_FB2      = 0x4        // Bit FB2.
	CAN_F13R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F13R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F13R1_FB3      = 0x8        // Bit FB3.
	CAN_F13R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F13R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F13R1_FB4      = 0x10       // Bit FB4.
	CAN_F13R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F13R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F13R1_FB5      = 0x20       // Bit FB5.
	CAN_F13R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F13R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F13R1_FB6      = 0x40       // Bit FB6.
	CAN_F13R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F13R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F13R1_FB7      = 0x80       // Bit FB7.
	CAN_F13R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F13R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F13R1_FB8      = 0x100      // Bit FB8.
	CAN_F13R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F13R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F13R1_FB9      = 0x200      // Bit FB9.
	CAN_F13R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F13R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F13R1_FB10     = 0x400      // Bit FB10.
	CAN_F13R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F13R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F13R1_FB11     = 0x800      // Bit FB11.
	CAN_F13R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F13R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F13R1_FB12     = 0x1000     // Bit FB12.
	CAN_F13R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F13R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F13R1_FB13     = 0x2000     // Bit FB13.
	CAN_F13R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F13R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F13R1_FB14     = 0x4000     // Bit FB14.
	CAN_F13R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F13R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F13R1_FB15     = 0x8000     // Bit FB15.
	CAN_F13R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F13R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F13R1_FB16     = 0x10000    // Bit FB16.
	CAN_F13R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F13R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F13R1_FB17     = 0x20000    // Bit FB17.
	CAN_F13R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F13R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F13R1_FB18     = 0x40000    // Bit FB18.
	CAN_F13R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F13R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F13R1_FB19     = 0x80000    // Bit FB19.
	CAN_F13R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F13R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F13R1_FB20     = 0x100000   // Bit FB20.
	CAN_F13R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F13R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F13R1_FB21     = 0x200000   // Bit FB21.
	CAN_F13R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F13R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F13R1_FB22     = 0x400000   // Bit FB22.
	CAN_F13R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F13R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F13R1_FB23     = 0x800000   // Bit FB23.
	CAN_F13R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F13R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F13R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F13R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F13R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F13R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F13R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F13R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F13R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F13R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F13R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F13R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F13R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F13R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F13R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F13R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F13R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F13R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F13R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F13R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F13R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F13R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F13R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F13R1_FB31     = 0x80000000 // Bit FB31.

	// F13R2: Filter bank 13 register 2
	CAN_F13R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F13R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F13R2_FB0      = 0x1        // Bit FB0.
	CAN_F13R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F13R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F13R2_FB1      = 0x2        // Bit FB1.
	CAN_F13R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F13R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F13R2_FB2      = 0x4        // Bit FB2.
	CAN_F13R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F13R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F13R2_FB3      = 0x8        // Bit FB3.
	CAN_F13R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F13R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F13R2_FB4      = 0x10       // Bit FB4.
	CAN_F13R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F13R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F13R2_FB5      = 0x20       // Bit FB5.
	CAN_F13R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F13R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F13R2_FB6      = 0x40       // Bit FB6.
	CAN_F13R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F13R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F13R2_FB7      = 0x80       // Bit FB7.
	CAN_F13R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F13R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F13R2_FB8      = 0x100      // Bit FB8.
	CAN_F13R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F13R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F13R2_FB9      = 0x200      // Bit FB9.
	CAN_F13R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F13R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F13R2_FB10     = 0x400      // Bit FB10.
	CAN_F13R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F13R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F13R2_FB11     = 0x800      // Bit FB11.
	CAN_F13R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F13R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F13R2_FB12     = 0x1000     // Bit FB12.
	CAN_F13R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F13R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F13R2_FB13     = 0x2000     // Bit FB13.
	CAN_F13R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F13R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F13R2_FB14     = 0x4000     // Bit FB14.
	CAN_F13R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F13R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F13R2_FB15     = 0x8000     // Bit FB15.
	CAN_F13R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F13R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F13R2_FB16     = 0x10000    // Bit FB16.
	CAN_F13R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F13R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F13R2_FB17     = 0x20000    // Bit FB17.
	CAN_F13R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F13R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F13R2_FB18     = 0x40000    // Bit FB18.
	CAN_F13R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F13R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F13R2_FB19     = 0x80000    // Bit FB19.
	CAN_F13R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F13R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F13R2_FB20     = 0x100000   // Bit FB20.
	CAN_F13R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F13R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F13R2_FB21     = 0x200000   // Bit FB21.
	CAN_F13R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F13R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F13R2_FB22     = 0x400000   // Bit FB22.
	CAN_F13R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F13R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F13R2_FB23     = 0x800000   // Bit FB23.
	CAN_F13R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F13R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F13R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F13R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F13R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F13R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F13R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F13R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F13R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F13R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F13R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F13R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F13R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F13R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F13R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F13R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F13R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F13R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F13R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F13R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F13R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F13R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F13R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F13R2_FB31     = 0x80000000 // Bit FB31.

	// F14R1: Filter bank 14 register 1
	CAN_F14R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F14R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F14R1_FB0      = 0x1        // Bit FB0.
	CAN_F14R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F14R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F14R1_FB1      = 0x2        // Bit FB1.
	CAN_F14R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F14R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F14R1_FB2      = 0x4        // Bit FB2.
	CAN_F14R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F14R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F14R1_FB3      = 0x8        // Bit FB3.
	CAN_F14R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F14R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F14R1_FB4      = 0x10       // Bit FB4.
	CAN_F14R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F14R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F14R1_FB5      = 0x20       // Bit FB5.
	CAN_F14R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F14R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F14R1_FB6      = 0x40       // Bit FB6.
	CAN_F14R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F14R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F14R1_FB7      = 0x80       // Bit FB7.
	CAN_F14R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F14R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F14R1_FB8      = 0x100      // Bit FB8.
	CAN_F14R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F14R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F14R1_FB9      = 0x200      // Bit FB9.
	CAN_F14R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F14R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F14R1_FB10     = 0x400      // Bit FB10.
	CAN_F14R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F14R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F14R1_FB11     = 0x800      // Bit FB11.
	CAN_F14R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F14R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F14R1_FB12     = 0x1000     // Bit FB12.
	CAN_F14R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F14R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F14R1_FB13     = 0x2000     // Bit FB13.
	CAN_F14R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F14R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F14R1_FB14     = 0x4000     // Bit FB14.
	CAN_F14R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F14R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F14R1_FB15     = 0x8000     // Bit FB15.
	CAN_F14R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F14R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F14R1_FB16     = 0x10000    // Bit FB16.
	CAN_F14R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F14R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F14R1_FB17     = 0x20000    // Bit FB17.
	CAN_F14R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F14R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F14R1_FB18     = 0x40000    // Bit FB18.
	CAN_F14R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F14R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F14R1_FB19     = 0x80000    // Bit FB19.
	CAN_F14R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F14R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F14R1_FB20     = 0x100000   // Bit FB20.
	CAN_F14R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F14R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F14R1_FB21     = 0x200000   // Bit FB21.
	CAN_F14R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F14R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F14R1_FB22     = 0x400000   // Bit FB22.
	CAN_F14R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F14R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F14R1_FB23     = 0x800000   // Bit FB23.
	CAN_F14R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F14R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F14R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F14R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F14R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F14R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F14R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F14R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F14R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F14R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F14R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F14R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F14R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F14R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F14R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F14R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F14R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F14R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F14R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F14R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F14R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F14R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F14R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F14R1_FB31     = 0x80000000 // Bit FB31.

	// F14R2: Filter bank 14 register 2
	CAN_F14R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F14R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F14R2_FB0      = 0x1        // Bit FB0.
	CAN_F14R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F14R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F14R2_FB1      = 0x2        // Bit FB1.
	CAN_F14R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F14R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F14R2_FB2      = 0x4        // Bit FB2.
	CAN_F14R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F14R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F14R2_FB3      = 0x8        // Bit FB3.
	CAN_F14R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F14R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F14R2_FB4      = 0x10       // Bit FB4.
	CAN_F14R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F14R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F14R2_FB5      = 0x20       // Bit FB5.
	CAN_F14R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F14R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F14R2_FB6      = 0x40       // Bit FB6.
	CAN_F14R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F14R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F14R2_FB7      = 0x80       // Bit FB7.
	CAN_F14R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F14R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F14R2_FB8      = 0x100      // Bit FB8.
	CAN_F14R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F14R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F14R2_FB9      = 0x200      // Bit FB9.
	CAN_F14R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F14R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F14R2_FB10     = 0x400      // Bit FB10.
	CAN_F14R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F14R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F14R2_FB11     = 0x800      // Bit FB11.
	CAN_F14R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F14R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F14R2_FB12     = 0x1000     // Bit FB12.
	CAN_F14R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F14R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F14R2_FB13     = 0x2000     // Bit FB13.
	CAN_F14R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F14R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F14R2_FB14     = 0x4000     // Bit FB14.
	CAN_F14R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F14R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F14R2_FB15     = 0x8000     // Bit FB15.
	CAN_F14R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F14R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F14R2_FB16     = 0x10000    // Bit FB16.
	CAN_F14R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F14R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F14R2_FB17     = 0x20000    // Bit FB17.
	CAN_F14R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F14R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F14R2_FB18     = 0x40000    // Bit FB18.
	CAN_F14R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F14R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F14R2_FB19     = 0x80000    // Bit FB19.
	CAN_F14R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F14R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F14R2_FB20     = 0x100000   // Bit FB20.
	CAN_F14R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F14R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F14R2_FB21     = 0x200000   // Bit FB21.
	CAN_F14R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F14R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F14R2_FB22     = 0x400000   // Bit FB22.
	CAN_F14R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F14R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F14R2_FB23     = 0x800000   // Bit FB23.
	CAN_F14R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F14R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F14R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F14R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F14R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F14R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F14R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F14R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F14R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F14R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F14R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F14R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F14R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F14R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F14R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F14R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F14R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F14R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F14R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F14R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F14R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F14R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F14R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F14R2_FB31     = 0x80000000 // Bit FB31.

	// F15R1: Filter bank 15 register 1
	CAN_F15R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F15R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F15R1_FB0      = 0x1        // Bit FB0.
	CAN_F15R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F15R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F15R1_FB1      = 0x2        // Bit FB1.
	CAN_F15R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F15R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F15R1_FB2      = 0x4        // Bit FB2.
	CAN_F15R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F15R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F15R1_FB3      = 0x8        // Bit FB3.
	CAN_F15R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F15R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F15R1_FB4      = 0x10       // Bit FB4.
	CAN_F15R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F15R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F15R1_FB5      = 0x20       // Bit FB5.
	CAN_F15R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F15R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F15R1_FB6      = 0x40       // Bit FB6.
	CAN_F15R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F15R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F15R1_FB7      = 0x80       // Bit FB7.
	CAN_F15R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F15R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F15R1_FB8      = 0x100      // Bit FB8.
	CAN_F15R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F15R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F15R1_FB9      = 0x200      // Bit FB9.
	CAN_F15R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F15R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F15R1_FB10     = 0x400      // Bit FB10.
	CAN_F15R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F15R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F15R1_FB11     = 0x800      // Bit FB11.
	CAN_F15R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F15R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F15R1_FB12     = 0x1000     // Bit FB12.
	CAN_F15R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F15R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F15R1_FB13     = 0x2000     // Bit FB13.
	CAN_F15R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F15R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F15R1_FB14     = 0x4000     // Bit FB14.
	CAN_F15R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F15R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F15R1_FB15     = 0x8000     // Bit FB15.
	CAN_F15R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F15R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F15R1_FB16     = 0x10000    // Bit FB16.
	CAN_F15R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F15R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F15R1_FB17     = 0x20000    // Bit FB17.
	CAN_F15R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F15R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F15R1_FB18     = 0x40000    // Bit FB18.
	CAN_F15R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F15R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F15R1_FB19     = 0x80000    // Bit FB19.
	CAN_F15R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F15R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F15R1_FB20     = 0x100000   // Bit FB20.
	CAN_F15R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F15R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F15R1_FB21     = 0x200000   // Bit FB21.
	CAN_F15R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F15R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F15R1_FB22     = 0x400000   // Bit FB22.
	CAN_F15R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F15R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F15R1_FB23     = 0x800000   // Bit FB23.
	CAN_F15R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F15R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F15R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F15R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F15R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F15R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F15R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F15R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F15R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F15R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F15R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F15R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F15R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F15R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F15R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F15R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F15R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F15R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F15R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F15R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F15R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F15R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F15R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F15R1_FB31     = 0x80000000 // Bit FB31.

	// F15R2: Filter bank 15 register 2
	CAN_F15R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F15R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F15R2_FB0      = 0x1        // Bit FB0.
	CAN_F15R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F15R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F15R2_FB1      = 0x2        // Bit FB1.
	CAN_F15R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F15R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F15R2_FB2      = 0x4        // Bit FB2.
	CAN_F15R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F15R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F15R2_FB3      = 0x8        // Bit FB3.
	CAN_F15R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F15R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F15R2_FB4      = 0x10       // Bit FB4.
	CAN_F15R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F15R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F15R2_FB5      = 0x20       // Bit FB5.
	CAN_F15R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F15R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F15R2_FB6      = 0x40       // Bit FB6.
	CAN_F15R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F15R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F15R2_FB7      = 0x80       // Bit FB7.
	CAN_F15R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F15R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F15R2_FB8      = 0x100      // Bit FB8.
	CAN_F15R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F15R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F15R2_FB9      = 0x200      // Bit FB9.
	CAN_F15R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F15R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F15R2_FB10     = 0x400      // Bit FB10.
	CAN_F15R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F15R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F15R2_FB11     = 0x800      // Bit FB11.
	CAN_F15R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F15R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F15R2_FB12     = 0x1000     // Bit FB12.
	CAN_F15R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F15R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F15R2_FB13     = 0x2000     // Bit FB13.
	CAN_F15R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F15R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F15R2_FB14     = 0x4000     // Bit FB14.
	CAN_F15R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F15R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F15R2_FB15     = 0x8000     // Bit FB15.
	CAN_F15R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F15R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F15R2_FB16     = 0x10000    // Bit FB16.
	CAN_F15R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F15R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F15R2_FB17     = 0x20000    // Bit FB17.
	CAN_F15R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F15R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F15R2_FB18     = 0x40000    // Bit FB18.
	CAN_F15R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F15R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F15R2_FB19     = 0x80000    // Bit FB19.
	CAN_F15R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F15R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F15R2_FB20     = 0x100000   // Bit FB20.
	CAN_F15R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F15R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F15R2_FB21     = 0x200000   // Bit FB21.
	CAN_F15R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F15R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F15R2_FB22     = 0x400000   // Bit FB22.
	CAN_F15R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F15R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F15R2_FB23     = 0x800000   // Bit FB23.
	CAN_F15R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F15R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F15R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F15R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F15R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F15R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F15R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F15R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F15R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F15R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F15R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F15R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F15R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F15R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F15R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F15R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F15R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F15R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F15R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F15R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F15R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F15R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F15R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F15R2_FB31     = 0x80000000 // Bit FB31.

	// F16R1: Filter bank 16 register 1
	CAN_F16R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F16R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F16R1_FB0      = 0x1        // Bit FB0.
	CAN_F16R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F16R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F16R1_FB1      = 0x2        // Bit FB1.
	CAN_F16R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F16R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F16R1_FB2      = 0x4        // Bit FB2.
	CAN_F16R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F16R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F16R1_FB3      = 0x8        // Bit FB3.
	CAN_F16R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F16R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F16R1_FB4      = 0x10       // Bit FB4.
	CAN_F16R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F16R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F16R1_FB5      = 0x20       // Bit FB5.
	CAN_F16R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F16R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F16R1_FB6      = 0x40       // Bit FB6.
	CAN_F16R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F16R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F16R1_FB7      = 0x80       // Bit FB7.
	CAN_F16R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F16R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F16R1_FB8      = 0x100      // Bit FB8.
	CAN_F16R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F16R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F16R1_FB9      = 0x200      // Bit FB9.
	CAN_F16R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F16R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F16R1_FB10     = 0x400      // Bit FB10.
	CAN_F16R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F16R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F16R1_FB11     = 0x800      // Bit FB11.
	CAN_F16R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F16R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F16R1_FB12     = 0x1000     // Bit FB12.
	CAN_F16R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F16R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F16R1_FB13     = 0x2000     // Bit FB13.
	CAN_F16R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F16R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F16R1_FB14     = 0x4000     // Bit FB14.
	CAN_F16R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F16R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F16R1_FB15     = 0x8000     // Bit FB15.
	CAN_F16R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F16R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F16R1_FB16     = 0x10000    // Bit FB16.
	CAN_F16R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F16R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F16R1_FB17     = 0x20000    // Bit FB17.
	CAN_F16R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F16R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F16R1_FB18     = 0x40000    // Bit FB18.
	CAN_F16R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F16R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F16R1_FB19     = 0x80000    // Bit FB19.
	CAN_F16R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F16R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F16R1_FB20     = 0x100000   // Bit FB20.
	CAN_F16R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F16R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F16R1_FB21     = 0x200000   // Bit FB21.
	CAN_F16R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F16R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F16R1_FB22     = 0x400000   // Bit FB22.
	CAN_F16R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F16R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F16R1_FB23     = 0x800000   // Bit FB23.
	CAN_F16R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F16R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F16R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F16R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F16R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F16R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F16R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F16R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F16R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F16R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F16R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F16R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F16R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F16R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F16R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F16R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F16R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F16R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F16R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F16R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F16R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F16R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F16R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F16R1_FB31     = 0x80000000 // Bit FB31.

	// F16R2: Filter bank 16 register 2
	CAN_F16R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F16R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F16R2_FB0      = 0x1        // Bit FB0.
	CAN_F16R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F16R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F16R2_FB1      = 0x2        // Bit FB1.
	CAN_F16R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F16R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F16R2_FB2      = 0x4        // Bit FB2.
	CAN_F16R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F16R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F16R2_FB3      = 0x8        // Bit FB3.
	CAN_F16R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F16R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F16R2_FB4      = 0x10       // Bit FB4.
	CAN_F16R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F16R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F16R2_FB5      = 0x20       // Bit FB5.
	CAN_F16R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F16R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F16R2_FB6      = 0x40       // Bit FB6.
	CAN_F16R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F16R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F16R2_FB7      = 0x80       // Bit FB7.
	CAN_F16R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F16R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F16R2_FB8      = 0x100      // Bit FB8.
	CAN_F16R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F16R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F16R2_FB9      = 0x200      // Bit FB9.
	CAN_F16R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F16R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F16R2_FB10     = 0x400      // Bit FB10.
	CAN_F16R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F16R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F16R2_FB11     = 0x800      // Bit FB11.
	CAN_F16R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F16R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F16R2_FB12     = 0x1000     // Bit FB12.
	CAN_F16R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F16R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F16R2_FB13     = 0x2000     // Bit FB13.
	CAN_F16R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F16R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F16R2_FB14     = 0x4000     // Bit FB14.
	CAN_F16R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F16R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F16R2_FB15     = 0x8000     // Bit FB15.
	CAN_F16R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F16R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F16R2_FB16     = 0x10000    // Bit FB16.
	CAN_F16R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F16R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F16R2_FB17     = 0x20000    // Bit FB17.
	CAN_F16R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F16R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F16R2_FB18     = 0x40000    // Bit FB18.
	CAN_F16R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F16R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F16R2_FB19     = 0x80000    // Bit FB19.
	CAN_F16R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F16R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F16R2_FB20     = 0x100000   // Bit FB20.
	CAN_F16R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F16R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F16R2_FB21     = 0x200000   // Bit FB21.
	CAN_F16R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F16R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F16R2_FB22     = 0x400000   // Bit FB22.
	CAN_F16R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F16R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F16R2_FB23     = 0x800000   // Bit FB23.
	CAN_F16R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F16R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F16R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F16R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F16R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F16R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F16R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F16R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F16R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F16R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F16R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F16R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F16R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F16R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F16R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F16R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F16R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F16R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F16R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F16R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F16R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F16R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F16R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F16R2_FB31     = 0x80000000 // Bit FB31.

	// F17R1: Filter bank 17 register 1
	CAN_F17R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F17R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F17R1_FB0      = 0x1        // Bit FB0.
	CAN_F17R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F17R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F17R1_FB1      = 0x2        // Bit FB1.
	CAN_F17R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F17R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F17R1_FB2      = 0x4        // Bit FB2.
	CAN_F17R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F17R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F17R1_FB3      = 0x8        // Bit FB3.
	CAN_F17R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F17R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F17R1_FB4      = 0x10       // Bit FB4.
	CAN_F17R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F17R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F17R1_FB5      = 0x20       // Bit FB5.
	CAN_F17R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F17R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F17R1_FB6      = 0x40       // Bit FB6.
	CAN_F17R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F17R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F17R1_FB7      = 0x80       // Bit FB7.
	CAN_F17R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F17R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F17R1_FB8      = 0x100      // Bit FB8.
	CAN_F17R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F17R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F17R1_FB9      = 0x200      // Bit FB9.
	CAN_F17R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F17R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F17R1_FB10     = 0x400      // Bit FB10.
	CAN_F17R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F17R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F17R1_FB11     = 0x800      // Bit FB11.
	CAN_F17R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F17R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F17R1_FB12     = 0x1000     // Bit FB12.
	CAN_F17R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F17R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F17R1_FB13     = 0x2000     // Bit FB13.
	CAN_F17R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F17R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F17R1_FB14     = 0x4000     // Bit FB14.
	CAN_F17R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F17R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F17R1_FB15     = 0x8000     // Bit FB15.
	CAN_F17R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F17R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F17R1_FB16     = 0x10000    // Bit FB16.
	CAN_F17R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F17R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F17R1_FB17     = 0x20000    // Bit FB17.
	CAN_F17R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F17R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F17R1_FB18     = 0x40000    // Bit FB18.
	CAN_F17R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F17R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F17R1_FB19     = 0x80000    // Bit FB19.
	CAN_F17R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F17R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F17R1_FB20     = 0x100000   // Bit FB20.
	CAN_F17R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F17R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F17R1_FB21     = 0x200000   // Bit FB21.
	CAN_F17R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F17R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F17R1_FB22     = 0x400000   // Bit FB22.
	CAN_F17R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F17R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F17R1_FB23     = 0x800000   // Bit FB23.
	CAN_F17R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F17R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F17R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F17R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F17R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F17R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F17R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F17R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F17R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F17R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F17R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F17R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F17R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F17R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F17R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F17R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F17R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F17R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F17R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F17R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F17R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F17R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F17R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F17R1_FB31     = 0x80000000 // Bit FB31.

	// F17R2: Filter bank 17 register 2
	CAN_F17R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F17R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F17R2_FB0      = 0x1        // Bit FB0.
	CAN_F17R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F17R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F17R2_FB1      = 0x2        // Bit FB1.
	CAN_F17R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F17R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F17R2_FB2      = 0x4        // Bit FB2.
	CAN_F17R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F17R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F17R2_FB3      = 0x8        // Bit FB3.
	CAN_F17R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F17R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F17R2_FB4      = 0x10       // Bit FB4.
	CAN_F17R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F17R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F17R2_FB5      = 0x20       // Bit FB5.
	CAN_F17R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F17R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F17R2_FB6      = 0x40       // Bit FB6.
	CAN_F17R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F17R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F17R2_FB7      = 0x80       // Bit FB7.
	CAN_F17R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F17R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F17R2_FB8      = 0x100      // Bit FB8.
	CAN_F17R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F17R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F17R2_FB9      = 0x200      // Bit FB9.
	CAN_F17R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F17R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F17R2_FB10     = 0x400      // Bit FB10.
	CAN_F17R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F17R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F17R2_FB11     = 0x800      // Bit FB11.
	CAN_F17R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F17R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F17R2_FB12     = 0x1000     // Bit FB12.
	CAN_F17R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F17R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F17R2_FB13     = 0x2000     // Bit FB13.
	CAN_F17R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F17R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F17R2_FB14     = 0x4000     // Bit FB14.
	CAN_F17R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F17R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F17R2_FB15     = 0x8000     // Bit FB15.
	CAN_F17R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F17R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F17R2_FB16     = 0x10000    // Bit FB16.
	CAN_F17R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F17R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F17R2_FB17     = 0x20000    // Bit FB17.
	CAN_F17R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F17R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F17R2_FB18     = 0x40000    // Bit FB18.
	CAN_F17R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F17R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F17R2_FB19     = 0x80000    // Bit FB19.
	CAN_F17R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F17R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F17R2_FB20     = 0x100000   // Bit FB20.
	CAN_F17R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F17R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F17R2_FB21     = 0x200000   // Bit FB21.
	CAN_F17R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F17R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F17R2_FB22     = 0x400000   // Bit FB22.
	CAN_F17R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F17R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F17R2_FB23     = 0x800000   // Bit FB23.
	CAN_F17R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F17R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F17R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F17R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F17R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F17R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F17R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F17R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F17R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F17R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F17R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F17R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F17R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F17R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F17R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F17R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F17R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F17R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F17R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F17R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F17R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F17R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F17R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F17R2_FB31     = 0x80000000 // Bit FB31.

	// F18R1: Filter bank 18 register 1
	CAN_F18R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F18R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F18R1_FB0      = 0x1        // Bit FB0.
	CAN_F18R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F18R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F18R1_FB1      = 0x2        // Bit FB1.
	CAN_F18R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F18R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F18R1_FB2      = 0x4        // Bit FB2.
	CAN_F18R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F18R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F18R1_FB3      = 0x8        // Bit FB3.
	CAN_F18R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F18R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F18R1_FB4      = 0x10       // Bit FB4.
	CAN_F18R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F18R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F18R1_FB5      = 0x20       // Bit FB5.
	CAN_F18R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F18R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F18R1_FB6      = 0x40       // Bit FB6.
	CAN_F18R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F18R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F18R1_FB7      = 0x80       // Bit FB7.
	CAN_F18R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F18R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F18R1_FB8      = 0x100      // Bit FB8.
	CAN_F18R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F18R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F18R1_FB9      = 0x200      // Bit FB9.
	CAN_F18R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F18R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F18R1_FB10     = 0x400      // Bit FB10.
	CAN_F18R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F18R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F18R1_FB11     = 0x800      // Bit FB11.
	CAN_F18R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F18R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F18R1_FB12     = 0x1000     // Bit FB12.
	CAN_F18R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F18R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F18R1_FB13     = 0x2000     // Bit FB13.
	CAN_F18R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F18R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F18R1_FB14     = 0x4000     // Bit FB14.
	CAN_F18R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F18R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F18R1_FB15     = 0x8000     // Bit FB15.
	CAN_F18R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F18R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F18R1_FB16     = 0x10000    // Bit FB16.
	CAN_F18R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F18R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F18R1_FB17     = 0x20000    // Bit FB17.
	CAN_F18R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F18R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F18R1_FB18     = 0x40000    // Bit FB18.
	CAN_F18R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F18R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F18R1_FB19     = 0x80000    // Bit FB19.
	CAN_F18R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F18R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F18R1_FB20     = 0x100000   // Bit FB20.
	CAN_F18R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F18R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F18R1_FB21     = 0x200000   // Bit FB21.
	CAN_F18R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F18R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F18R1_FB22     = 0x400000   // Bit FB22.
	CAN_F18R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F18R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F18R1_FB23     = 0x800000   // Bit FB23.
	CAN_F18R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F18R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F18R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F18R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F18R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F18R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F18R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F18R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F18R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F18R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F18R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F18R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F18R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F18R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F18R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F18R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F18R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F18R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F18R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F18R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F18R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F18R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F18R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F18R1_FB31     = 0x80000000 // Bit FB31.

	// F18R2: Filter bank 18 register 2
	CAN_F18R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F18R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F18R2_FB0      = 0x1        // Bit FB0.
	CAN_F18R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F18R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F18R2_FB1      = 0x2        // Bit FB1.
	CAN_F18R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F18R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F18R2_FB2      = 0x4        // Bit FB2.
	CAN_F18R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F18R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F18R2_FB3      = 0x8        // Bit FB3.
	CAN_F18R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F18R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F18R2_FB4      = 0x10       // Bit FB4.
	CAN_F18R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F18R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F18R2_FB5      = 0x20       // Bit FB5.
	CAN_F18R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F18R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F18R2_FB6      = 0x40       // Bit FB6.
	CAN_F18R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F18R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F18R2_FB7      = 0x80       // Bit FB7.
	CAN_F18R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F18R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F18R2_FB8      = 0x100      // Bit FB8.
	CAN_F18R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F18R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F18R2_FB9      = 0x200      // Bit FB9.
	CAN_F18R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F18R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F18R2_FB10     = 0x400      // Bit FB10.
	CAN_F18R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F18R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F18R2_FB11     = 0x800      // Bit FB11.
	CAN_F18R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F18R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F18R2_FB12     = 0x1000     // Bit FB12.
	CAN_F18R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F18R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F18R2_FB13     = 0x2000     // Bit FB13.
	CAN_F18R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F18R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F18R2_FB14     = 0x4000     // Bit FB14.
	CAN_F18R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F18R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F18R2_FB15     = 0x8000     // Bit FB15.
	CAN_F18R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F18R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F18R2_FB16     = 0x10000    // Bit FB16.
	CAN_F18R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F18R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F18R2_FB17     = 0x20000    // Bit FB17.
	CAN_F18R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F18R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F18R2_FB18     = 0x40000    // Bit FB18.
	CAN_F18R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F18R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F18R2_FB19     = 0x80000    // Bit FB19.
	CAN_F18R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F18R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F18R2_FB20     = 0x100000   // Bit FB20.
	CAN_F18R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F18R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F18R2_FB21     = 0x200000   // Bit FB21.
	CAN_F18R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F18R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F18R2_FB22     = 0x400000   // Bit FB22.
	CAN_F18R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F18R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F18R2_FB23     = 0x800000   // Bit FB23.
	CAN_F18R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F18R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F18R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F18R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F18R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F18R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F18R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F18R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F18R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F18R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F18R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F18R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F18R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F18R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F18R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F18R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F18R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F18R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F18R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F18R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F18R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F18R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F18R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F18R2_FB31     = 0x80000000 // Bit FB31.

	// F19R1: Filter bank 19 register 1
	CAN_F19R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F19R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F19R1_FB0      = 0x1        // Bit FB0.
	CAN_F19R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F19R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F19R1_FB1      = 0x2        // Bit FB1.
	CAN_F19R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F19R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F19R1_FB2      = 0x4        // Bit FB2.
	CAN_F19R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F19R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F19R1_FB3      = 0x8        // Bit FB3.
	CAN_F19R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F19R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F19R1_FB4      = 0x10       // Bit FB4.
	CAN_F19R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F19R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F19R1_FB5      = 0x20       // Bit FB5.
	CAN_F19R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F19R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F19R1_FB6      = 0x40       // Bit FB6.
	CAN_F19R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F19R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F19R1_FB7      = 0x80       // Bit FB7.
	CAN_F19R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F19R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F19R1_FB8      = 0x100      // Bit FB8.
	CAN_F19R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F19R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F19R1_FB9      = 0x200      // Bit FB9.
	CAN_F19R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F19R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F19R1_FB10     = 0x400      // Bit FB10.
	CAN_F19R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F19R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F19R1_FB11     = 0x800      // Bit FB11.
	CAN_F19R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F19R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F19R1_FB12     = 0x1000     // Bit FB12.
	CAN_F19R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F19R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F19R1_FB13     = 0x2000     // Bit FB13.
	CAN_F19R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F19R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F19R1_FB14     = 0x4000     // Bit FB14.
	CAN_F19R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F19R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F19R1_FB15     = 0x8000     // Bit FB15.
	CAN_F19R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F19R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F19R1_FB16     = 0x10000    // Bit FB16.
	CAN_F19R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F19R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F19R1_FB17     = 0x20000    // Bit FB17.
	CAN_F19R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F19R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F19R1_FB18     = 0x40000    // Bit FB18.
	CAN_F19R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F19R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F19R1_FB19     = 0x80000    // Bit FB19.
	CAN_F19R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F19R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F19R1_FB20     = 0x100000   // Bit FB20.
	CAN_F19R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F19R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F19R1_FB21     = 0x200000   // Bit FB21.
	CAN_F19R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F19R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F19R1_FB22     = 0x400000   // Bit FB22.
	CAN_F19R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F19R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F19R1_FB23     = 0x800000   // Bit FB23.
	CAN_F19R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F19R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F19R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F19R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F19R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F19R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F19R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F19R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F19R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F19R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F19R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F19R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F19R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F19R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F19R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F19R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F19R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F19R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F19R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F19R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F19R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F19R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F19R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F19R1_FB31     = 0x80000000 // Bit FB31.

	// F19R2: Filter bank 19 register 2
	CAN_F19R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F19R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F19R2_FB0      = 0x1        // Bit FB0.
	CAN_F19R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F19R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F19R2_FB1      = 0x2        // Bit FB1.
	CAN_F19R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F19R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F19R2_FB2      = 0x4        // Bit FB2.
	CAN_F19R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F19R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F19R2_FB3      = 0x8        // Bit FB3.
	CAN_F19R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F19R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F19R2_FB4      = 0x10       // Bit FB4.
	CAN_F19R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F19R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F19R2_FB5      = 0x20       // Bit FB5.
	CAN_F19R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F19R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F19R2_FB6      = 0x40       // Bit FB6.
	CAN_F19R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F19R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F19R2_FB7      = 0x80       // Bit FB7.
	CAN_F19R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F19R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F19R2_FB8      = 0x100      // Bit FB8.
	CAN_F19R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F19R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F19R2_FB9      = 0x200      // Bit FB9.
	CAN_F19R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F19R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F19R2_FB10     = 0x400      // Bit FB10.
	CAN_F19R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F19R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F19R2_FB11     = 0x800      // Bit FB11.
	CAN_F19R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F19R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F19R2_FB12     = 0x1000     // Bit FB12.
	CAN_F19R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F19R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F19R2_FB13     = 0x2000     // Bit FB13.
	CAN_F19R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F19R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F19R2_FB14     = 0x4000     // Bit FB14.
	CAN_F19R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F19R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F19R2_FB15     = 0x8000     // Bit FB15.
	CAN_F19R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F19R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F19R2_FB16     = 0x10000    // Bit FB16.
	CAN_F19R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F19R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F19R2_FB17     = 0x20000    // Bit FB17.
	CAN_F19R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F19R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F19R2_FB18     = 0x40000    // Bit FB18.
	CAN_F19R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F19R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F19R2_FB19     = 0x80000    // Bit FB19.
	CAN_F19R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F19R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F19R2_FB20     = 0x100000   // Bit FB20.
	CAN_F19R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F19R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F19R2_FB21     = 0x200000   // Bit FB21.
	CAN_F19R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F19R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F19R2_FB22     = 0x400000   // Bit FB22.
	CAN_F19R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F19R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F19R2_FB23     = 0x800000   // Bit FB23.
	CAN_F19R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F19R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F19R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F19R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F19R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F19R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F19R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F19R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F19R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F19R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F19R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F19R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F19R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F19R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F19R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F19R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F19R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F19R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F19R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F19R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F19R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F19R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F19R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F19R2_FB31     = 0x80000000 // Bit FB31.

	// F20R1: Filter bank 20 register 1
	CAN_F20R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F20R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F20R1_FB0      = 0x1        // Bit FB0.
	CAN_F20R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F20R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F20R1_FB1      = 0x2        // Bit FB1.
	CAN_F20R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F20R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F20R1_FB2      = 0x4        // Bit FB2.
	CAN_F20R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F20R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F20R1_FB3      = 0x8        // Bit FB3.
	CAN_F20R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F20R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F20R1_FB4      = 0x10       // Bit FB4.
	CAN_F20R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F20R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F20R1_FB5      = 0x20       // Bit FB5.
	CAN_F20R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F20R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F20R1_FB6      = 0x40       // Bit FB6.
	CAN_F20R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F20R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F20R1_FB7      = 0x80       // Bit FB7.
	CAN_F20R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F20R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F20R1_FB8      = 0x100      // Bit FB8.
	CAN_F20R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F20R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F20R1_FB9      = 0x200      // Bit FB9.
	CAN_F20R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F20R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F20R1_FB10     = 0x400      // Bit FB10.
	CAN_F20R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F20R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F20R1_FB11     = 0x800      // Bit FB11.
	CAN_F20R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F20R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F20R1_FB12     = 0x1000     // Bit FB12.
	CAN_F20R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F20R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F20R1_FB13     = 0x2000     // Bit FB13.
	CAN_F20R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F20R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F20R1_FB14     = 0x4000     // Bit FB14.
	CAN_F20R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F20R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F20R1_FB15     = 0x8000     // Bit FB15.
	CAN_F20R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F20R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F20R1_FB16     = 0x10000    // Bit FB16.
	CAN_F20R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F20R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F20R1_FB17     = 0x20000    // Bit FB17.
	CAN_F20R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F20R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F20R1_FB18     = 0x40000    // Bit FB18.
	CAN_F20R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F20R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F20R1_FB19     = 0x80000    // Bit FB19.
	CAN_F20R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F20R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F20R1_FB20     = 0x100000   // Bit FB20.
	CAN_F20R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F20R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F20R1_FB21     = 0x200000   // Bit FB21.
	CAN_F20R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F20R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F20R1_FB22     = 0x400000   // Bit FB22.
	CAN_F20R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F20R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F20R1_FB23     = 0x800000   // Bit FB23.
	CAN_F20R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F20R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F20R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F20R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F20R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F20R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F20R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F20R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F20R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F20R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F20R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F20R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F20R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F20R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F20R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F20R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F20R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F20R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F20R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F20R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F20R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F20R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F20R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F20R1_FB31     = 0x80000000 // Bit FB31.

	// F20R2: Filter bank 20 register 2
	CAN_F20R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F20R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F20R2_FB0      = 0x1        // Bit FB0.
	CAN_F20R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F20R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F20R2_FB1      = 0x2        // Bit FB1.
	CAN_F20R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F20R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F20R2_FB2      = 0x4        // Bit FB2.
	CAN_F20R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F20R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F20R2_FB3      = 0x8        // Bit FB3.
	CAN_F20R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F20R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F20R2_FB4      = 0x10       // Bit FB4.
	CAN_F20R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F20R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F20R2_FB5      = 0x20       // Bit FB5.
	CAN_F20R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F20R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F20R2_FB6      = 0x40       // Bit FB6.
	CAN_F20R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F20R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F20R2_FB7      = 0x80       // Bit FB7.
	CAN_F20R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F20R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F20R2_FB8      = 0x100      // Bit FB8.
	CAN_F20R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F20R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F20R2_FB9      = 0x200      // Bit FB9.
	CAN_F20R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F20R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F20R2_FB10     = 0x400      // Bit FB10.
	CAN_F20R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F20R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F20R2_FB11     = 0x800      // Bit FB11.
	CAN_F20R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F20R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F20R2_FB12     = 0x1000     // Bit FB12.
	CAN_F20R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F20R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F20R2_FB13     = 0x2000     // Bit FB13.
	CAN_F20R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F20R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F20R2_FB14     = 0x4000     // Bit FB14.
	CAN_F20R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F20R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F20R2_FB15     = 0x8000     // Bit FB15.
	CAN_F20R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F20R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F20R2_FB16     = 0x10000    // Bit FB16.
	CAN_F20R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F20R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F20R2_FB17     = 0x20000    // Bit FB17.
	CAN_F20R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F20R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F20R2_FB18     = 0x40000    // Bit FB18.
	CAN_F20R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F20R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F20R2_FB19     = 0x80000    // Bit FB19.
	CAN_F20R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F20R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F20R2_FB20     = 0x100000   // Bit FB20.
	CAN_F20R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F20R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F20R2_FB21     = 0x200000   // Bit FB21.
	CAN_F20R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F20R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F20R2_FB22     = 0x400000   // Bit FB22.
	CAN_F20R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F20R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F20R2_FB23     = 0x800000   // Bit FB23.
	CAN_F20R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F20R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F20R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F20R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F20R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F20R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F20R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F20R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F20R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F20R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F20R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F20R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F20R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F20R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F20R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F20R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F20R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F20R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F20R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F20R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F20R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F20R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F20R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F20R2_FB31     = 0x80000000 // Bit FB31.

	// F21R1: Filter bank 21 register 1
	CAN_F21R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F21R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F21R1_FB0      = 0x1        // Bit FB0.
	CAN_F21R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F21R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F21R1_FB1      = 0x2        // Bit FB1.
	CAN_F21R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F21R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F21R1_FB2      = 0x4        // Bit FB2.
	CAN_F21R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F21R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F21R1_FB3      = 0x8        // Bit FB3.
	CAN_F21R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F21R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F21R1_FB4      = 0x10       // Bit FB4.
	CAN_F21R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F21R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F21R1_FB5      = 0x20       // Bit FB5.
	CAN_F21R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F21R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F21R1_FB6      = 0x40       // Bit FB6.
	CAN_F21R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F21R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F21R1_FB7      = 0x80       // Bit FB7.
	CAN_F21R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F21R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F21R1_FB8      = 0x100      // Bit FB8.
	CAN_F21R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F21R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F21R1_FB9      = 0x200      // Bit FB9.
	CAN_F21R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F21R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F21R1_FB10     = 0x400      // Bit FB10.
	CAN_F21R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F21R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F21R1_FB11     = 0x800      // Bit FB11.
	CAN_F21R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F21R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F21R1_FB12     = 0x1000     // Bit FB12.
	CAN_F21R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F21R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F21R1_FB13     = 0x2000     // Bit FB13.
	CAN_F21R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F21R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F21R1_FB14     = 0x4000     // Bit FB14.
	CAN_F21R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F21R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F21R1_FB15     = 0x8000     // Bit FB15.
	CAN_F21R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F21R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F21R1_FB16     = 0x10000    // Bit FB16.
	CAN_F21R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F21R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F21R1_FB17     = 0x20000    // Bit FB17.
	CAN_F21R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F21R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F21R1_FB18     = 0x40000    // Bit FB18.
	CAN_F21R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F21R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F21R1_FB19     = 0x80000    // Bit FB19.
	CAN_F21R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F21R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F21R1_FB20     = 0x100000   // Bit FB20.
	CAN_F21R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F21R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F21R1_FB21     = 0x200000   // Bit FB21.
	CAN_F21R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F21R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F21R1_FB22     = 0x400000   // Bit FB22.
	CAN_F21R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F21R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F21R1_FB23     = 0x800000   // Bit FB23.
	CAN_F21R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F21R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F21R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F21R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F21R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F21R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F21R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F21R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F21R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F21R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F21R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F21R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F21R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F21R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F21R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F21R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F21R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F21R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F21R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F21R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F21R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F21R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F21R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F21R1_FB31     = 0x80000000 // Bit FB31.

	// F21R2: Filter bank 21 register 2
	CAN_F21R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F21R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F21R2_FB0      = 0x1        // Bit FB0.
	CAN_F21R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F21R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F21R2_FB1      = 0x2        // Bit FB1.
	CAN_F21R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F21R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F21R2_FB2      = 0x4        // Bit FB2.
	CAN_F21R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F21R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F21R2_FB3      = 0x8        // Bit FB3.
	CAN_F21R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F21R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F21R2_FB4      = 0x10       // Bit FB4.
	CAN_F21R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F21R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F21R2_FB5      = 0x20       // Bit FB5.
	CAN_F21R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F21R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F21R2_FB6      = 0x40       // Bit FB6.
	CAN_F21R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F21R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F21R2_FB7      = 0x80       // Bit FB7.
	CAN_F21R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F21R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F21R2_FB8      = 0x100      // Bit FB8.
	CAN_F21R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F21R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F21R2_FB9      = 0x200      // Bit FB9.
	CAN_F21R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F21R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F21R2_FB10     = 0x400      // Bit FB10.
	CAN_F21R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F21R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F21R2_FB11     = 0x800      // Bit FB11.
	CAN_F21R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F21R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F21R2_FB12     = 0x1000     // Bit FB12.
	CAN_F21R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F21R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F21R2_FB13     = 0x2000     // Bit FB13.
	CAN_F21R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F21R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F21R2_FB14     = 0x4000     // Bit FB14.
	CAN_F21R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F21R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F21R2_FB15     = 0x8000     // Bit FB15.
	CAN_F21R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F21R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F21R2_FB16     = 0x10000    // Bit FB16.
	CAN_F21R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F21R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F21R2_FB17     = 0x20000    // Bit FB17.
	CAN_F21R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F21R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F21R2_FB18     = 0x40000    // Bit FB18.
	CAN_F21R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F21R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F21R2_FB19     = 0x80000    // Bit FB19.
	CAN_F21R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F21R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F21R2_FB20     = 0x100000   // Bit FB20.
	CAN_F21R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F21R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F21R2_FB21     = 0x200000   // Bit FB21.
	CAN_F21R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F21R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F21R2_FB22     = 0x400000   // Bit FB22.
	CAN_F21R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F21R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F21R2_FB23     = 0x800000   // Bit FB23.
	CAN_F21R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F21R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F21R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F21R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F21R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F21R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F21R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F21R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F21R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F21R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F21R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F21R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F21R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F21R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F21R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F21R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F21R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F21R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F21R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F21R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F21R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F21R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F21R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F21R2_FB31     = 0x80000000 // Bit FB31.

	// F22R1: Filter bank 22 register 1
	CAN_F22R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F22R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F22R1_FB0      = 0x1        // Bit FB0.
	CAN_F22R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F22R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F22R1_FB1      = 0x2        // Bit FB1.
	CAN_F22R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F22R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F22R1_FB2      = 0x4        // Bit FB2.
	CAN_F22R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F22R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F22R1_FB3      = 0x8        // Bit FB3.
	CAN_F22R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F22R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F22R1_FB4      = 0x10       // Bit FB4.
	CAN_F22R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F22R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F22R1_FB5      = 0x20       // Bit FB5.
	CAN_F22R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F22R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F22R1_FB6      = 0x40       // Bit FB6.
	CAN_F22R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F22R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F22R1_FB7      = 0x80       // Bit FB7.
	CAN_F22R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F22R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F22R1_FB8      = 0x100      // Bit FB8.
	CAN_F22R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F22R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F22R1_FB9      = 0x200      // Bit FB9.
	CAN_F22R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F22R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F22R1_FB10     = 0x400      // Bit FB10.
	CAN_F22R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F22R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F22R1_FB11     = 0x800      // Bit FB11.
	CAN_F22R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F22R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F22R1_FB12     = 0x1000     // Bit FB12.
	CAN_F22R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F22R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F22R1_FB13     = 0x2000     // Bit FB13.
	CAN_F22R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F22R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F22R1_FB14     = 0x4000     // Bit FB14.
	CAN_F22R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F22R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F22R1_FB15     = 0x8000     // Bit FB15.
	CAN_F22R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F22R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F22R1_FB16     = 0x10000    // Bit FB16.
	CAN_F22R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F22R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F22R1_FB17     = 0x20000    // Bit FB17.
	CAN_F22R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F22R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F22R1_FB18     = 0x40000    // Bit FB18.
	CAN_F22R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F22R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F22R1_FB19     = 0x80000    // Bit FB19.
	CAN_F22R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F22R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F22R1_FB20     = 0x100000   // Bit FB20.
	CAN_F22R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F22R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F22R1_FB21     = 0x200000   // Bit FB21.
	CAN_F22R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F22R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F22R1_FB22     = 0x400000   // Bit FB22.
	CAN_F22R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F22R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F22R1_FB23     = 0x800000   // Bit FB23.
	CAN_F22R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F22R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F22R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F22R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F22R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F22R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F22R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F22R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F22R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F22R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F22R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F22R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F22R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F22R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F22R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F22R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F22R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F22R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F22R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F22R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F22R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F22R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F22R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F22R1_FB31     = 0x80000000 // Bit FB31.

	// F22R2: Filter bank 22 register 2
	CAN_F22R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F22R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F22R2_FB0      = 0x1        // Bit FB0.
	CAN_F22R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F22R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F22R2_FB1      = 0x2        // Bit FB1.
	CAN_F22R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F22R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F22R2_FB2      = 0x4        // Bit FB2.
	CAN_F22R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F22R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F22R2_FB3      = 0x8        // Bit FB3.
	CAN_F22R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F22R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F22R2_FB4      = 0x10       // Bit FB4.
	CAN_F22R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F22R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F22R2_FB5      = 0x20       // Bit FB5.
	CAN_F22R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F22R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F22R2_FB6      = 0x40       // Bit FB6.
	CAN_F22R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F22R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F22R2_FB7      = 0x80       // Bit FB7.
	CAN_F22R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F22R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F22R2_FB8      = 0x100      // Bit FB8.
	CAN_F22R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F22R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F22R2_FB9      = 0x200      // Bit FB9.
	CAN_F22R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F22R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F22R2_FB10     = 0x400      // Bit FB10.
	CAN_F22R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F22R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F22R2_FB11     = 0x800      // Bit FB11.
	CAN_F22R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F22R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F22R2_FB12     = 0x1000     // Bit FB12.
	CAN_F22R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F22R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F22R2_FB13     = 0x2000     // Bit FB13.
	CAN_F22R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F22R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F22R2_FB14     = 0x4000     // Bit FB14.
	CAN_F22R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F22R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F22R2_FB15     = 0x8000     // Bit FB15.
	CAN_F22R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F22R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F22R2_FB16     = 0x10000    // Bit FB16.
	CAN_F22R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F22R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F22R2_FB17     = 0x20000    // Bit FB17.
	CAN_F22R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F22R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F22R2_FB18     = 0x40000    // Bit FB18.
	CAN_F22R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F22R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F22R2_FB19     = 0x80000    // Bit FB19.
	CAN_F22R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F22R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F22R2_FB20     = 0x100000   // Bit FB20.
	CAN_F22R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F22R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F22R2_FB21     = 0x200000   // Bit FB21.
	CAN_F22R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F22R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F22R2_FB22     = 0x400000   // Bit FB22.
	CAN_F22R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F22R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F22R2_FB23     = 0x800000   // Bit FB23.
	CAN_F22R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F22R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F22R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F22R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F22R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F22R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F22R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F22R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F22R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F22R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F22R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F22R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F22R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F22R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F22R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F22R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F22R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F22R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F22R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F22R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F22R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F22R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F22R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F22R2_FB31     = 0x80000000 // Bit FB31.

	// F23R1: Filter bank 23 register 1
	CAN_F23R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F23R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F23R1_FB0      = 0x1        // Bit FB0.
	CAN_F23R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F23R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F23R1_FB1      = 0x2        // Bit FB1.
	CAN_F23R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F23R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F23R1_FB2      = 0x4        // Bit FB2.
	CAN_F23R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F23R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F23R1_FB3      = 0x8        // Bit FB3.
	CAN_F23R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F23R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F23R1_FB4      = 0x10       // Bit FB4.
	CAN_F23R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F23R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F23R1_FB5      = 0x20       // Bit FB5.
	CAN_F23R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F23R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F23R1_FB6      = 0x40       // Bit FB6.
	CAN_F23R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F23R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F23R1_FB7      = 0x80       // Bit FB7.
	CAN_F23R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F23R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F23R1_FB8      = 0x100      // Bit FB8.
	CAN_F23R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F23R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F23R1_FB9      = 0x200      // Bit FB9.
	CAN_F23R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F23R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F23R1_FB10     = 0x400      // Bit FB10.
	CAN_F23R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F23R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F23R1_FB11     = 0x800      // Bit FB11.
	CAN_F23R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F23R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F23R1_FB12     = 0x1000     // Bit FB12.
	CAN_F23R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F23R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F23R1_FB13     = 0x2000     // Bit FB13.
	CAN_F23R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F23R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F23R1_FB14     = 0x4000     // Bit FB14.
	CAN_F23R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F23R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F23R1_FB15     = 0x8000     // Bit FB15.
	CAN_F23R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F23R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F23R1_FB16     = 0x10000    // Bit FB16.
	CAN_F23R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F23R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F23R1_FB17     = 0x20000    // Bit FB17.
	CAN_F23R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F23R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F23R1_FB18     = 0x40000    // Bit FB18.
	CAN_F23R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F23R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F23R1_FB19     = 0x80000    // Bit FB19.
	CAN_F23R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F23R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F23R1_FB20     = 0x100000   // Bit FB20.
	CAN_F23R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F23R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F23R1_FB21     = 0x200000   // Bit FB21.
	CAN_F23R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F23R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F23R1_FB22     = 0x400000   // Bit FB22.
	CAN_F23R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F23R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F23R1_FB23     = 0x800000   // Bit FB23.
	CAN_F23R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F23R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F23R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F23R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F23R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F23R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F23R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F23R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F23R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F23R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F23R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F23R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F23R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F23R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F23R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F23R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F23R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F23R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F23R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F23R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F23R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F23R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F23R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F23R1_FB31     = 0x80000000 // Bit FB31.

	// F23R2: Filter bank 23 register 2
	CAN_F23R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F23R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F23R2_FB0      = 0x1        // Bit FB0.
	CAN_F23R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F23R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F23R2_FB1      = 0x2        // Bit FB1.
	CAN_F23R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F23R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F23R2_FB2      = 0x4        // Bit FB2.
	CAN_F23R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F23R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F23R2_FB3      = 0x8        // Bit FB3.
	CAN_F23R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F23R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F23R2_FB4      = 0x10       // Bit FB4.
	CAN_F23R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F23R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F23R2_FB5      = 0x20       // Bit FB5.
	CAN_F23R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F23R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F23R2_FB6      = 0x40       // Bit FB6.
	CAN_F23R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F23R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F23R2_FB7      = 0x80       // Bit FB7.
	CAN_F23R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F23R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F23R2_FB8      = 0x100      // Bit FB8.
	CAN_F23R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F23R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F23R2_FB9      = 0x200      // Bit FB9.
	CAN_F23R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F23R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F23R2_FB10     = 0x400      // Bit FB10.
	CAN_F23R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F23R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F23R2_FB11     = 0x800      // Bit FB11.
	CAN_F23R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F23R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F23R2_FB12     = 0x1000     // Bit FB12.
	CAN_F23R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F23R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F23R2_FB13     = 0x2000     // Bit FB13.
	CAN_F23R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F23R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F23R2_FB14     = 0x4000     // Bit FB14.
	CAN_F23R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F23R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F23R2_FB15     = 0x8000     // Bit FB15.
	CAN_F23R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F23R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F23R2_FB16     = 0x10000    // Bit FB16.
	CAN_F23R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F23R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F23R2_FB17     = 0x20000    // Bit FB17.
	CAN_F23R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F23R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F23R2_FB18     = 0x40000    // Bit FB18.
	CAN_F23R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F23R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F23R2_FB19     = 0x80000    // Bit FB19.
	CAN_F23R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F23R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F23R2_FB20     = 0x100000   // Bit FB20.
	CAN_F23R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F23R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F23R2_FB21     = 0x200000   // Bit FB21.
	CAN_F23R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F23R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F23R2_FB22     = 0x400000   // Bit FB22.
	CAN_F23R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F23R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F23R2_FB23     = 0x800000   // Bit FB23.
	CAN_F23R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F23R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F23R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F23R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F23R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F23R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F23R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F23R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F23R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F23R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F23R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F23R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F23R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F23R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F23R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F23R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F23R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F23R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F23R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F23R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F23R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F23R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F23R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F23R2_FB31     = 0x80000000 // Bit FB31.

	// F24R1: Filter bank 24 register 1
	CAN_F24R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F24R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F24R1_FB0      = 0x1        // Bit FB0.
	CAN_F24R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F24R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F24R1_FB1      = 0x2        // Bit FB1.
	CAN_F24R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F24R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F24R1_FB2      = 0x4        // Bit FB2.
	CAN_F24R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F24R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F24R1_FB3      = 0x8        // Bit FB3.
	CAN_F24R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F24R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F24R1_FB4      = 0x10       // Bit FB4.
	CAN_F24R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F24R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F24R1_FB5      = 0x20       // Bit FB5.
	CAN_F24R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F24R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F24R1_FB6      = 0x40       // Bit FB6.
	CAN_F24R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F24R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F24R1_FB7      = 0x80       // Bit FB7.
	CAN_F24R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F24R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F24R1_FB8      = 0x100      // Bit FB8.
	CAN_F24R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F24R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F24R1_FB9      = 0x200      // Bit FB9.
	CAN_F24R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F24R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F24R1_FB10     = 0x400      // Bit FB10.
	CAN_F24R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F24R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F24R1_FB11     = 0x800      // Bit FB11.
	CAN_F24R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F24R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F24R1_FB12     = 0x1000     // Bit FB12.
	CAN_F24R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F24R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F24R1_FB13     = 0x2000     // Bit FB13.
	CAN_F24R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F24R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F24R1_FB14     = 0x4000     // Bit FB14.
	CAN_F24R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F24R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F24R1_FB15     = 0x8000     // Bit FB15.
	CAN_F24R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F24R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F24R1_FB16     = 0x10000    // Bit FB16.
	CAN_F24R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F24R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F24R1_FB17     = 0x20000    // Bit FB17.
	CAN_F24R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F24R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F24R1_FB18     = 0x40000    // Bit FB18.
	CAN_F24R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F24R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F24R1_FB19     = 0x80000    // Bit FB19.
	CAN_F24R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F24R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F24R1_FB20     = 0x100000   // Bit FB20.
	CAN_F24R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F24R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F24R1_FB21     = 0x200000   // Bit FB21.
	CAN_F24R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F24R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F24R1_FB22     = 0x400000   // Bit FB22.
	CAN_F24R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F24R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F24R1_FB23     = 0x800000   // Bit FB23.
	CAN_F24R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F24R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F24R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F24R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F24R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F24R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F24R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F24R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F24R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F24R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F24R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F24R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F24R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F24R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F24R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F24R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F24R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F24R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F24R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F24R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F24R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F24R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F24R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F24R1_FB31     = 0x80000000 // Bit FB31.

	// F24R2: Filter bank 24 register 2
	CAN_F24R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F24R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F24R2_FB0      = 0x1        // Bit FB0.
	CAN_F24R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F24R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F24R2_FB1      = 0x2        // Bit FB1.
	CAN_F24R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F24R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F24R2_FB2      = 0x4        // Bit FB2.
	CAN_F24R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F24R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F24R2_FB3      = 0x8        // Bit FB3.
	CAN_F24R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F24R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F24R2_FB4      = 0x10       // Bit FB4.
	CAN_F24R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F24R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F24R2_FB5      = 0x20       // Bit FB5.
	CAN_F24R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F24R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F24R2_FB6      = 0x40       // Bit FB6.
	CAN_F24R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F24R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F24R2_FB7      = 0x80       // Bit FB7.
	CAN_F24R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F24R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F24R2_FB8      = 0x100      // Bit FB8.
	CAN_F24R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F24R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F24R2_FB9      = 0x200      // Bit FB9.
	CAN_F24R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F24R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F24R2_FB10     = 0x400      // Bit FB10.
	CAN_F24R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F24R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F24R2_FB11     = 0x800      // Bit FB11.
	CAN_F24R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F24R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F24R2_FB12     = 0x1000     // Bit FB12.
	CAN_F24R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F24R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F24R2_FB13     = 0x2000     // Bit FB13.
	CAN_F24R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F24R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F24R2_FB14     = 0x4000     // Bit FB14.
	CAN_F24R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F24R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F24R2_FB15     = 0x8000     // Bit FB15.
	CAN_F24R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F24R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F24R2_FB16     = 0x10000    // Bit FB16.
	CAN_F24R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F24R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F24R2_FB17     = 0x20000    // Bit FB17.
	CAN_F24R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F24R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F24R2_FB18     = 0x40000    // Bit FB18.
	CAN_F24R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F24R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F24R2_FB19     = 0x80000    // Bit FB19.
	CAN_F24R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F24R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F24R2_FB20     = 0x100000   // Bit FB20.
	CAN_F24R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F24R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F24R2_FB21     = 0x200000   // Bit FB21.
	CAN_F24R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F24R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F24R2_FB22     = 0x400000   // Bit FB22.
	CAN_F24R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F24R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F24R2_FB23     = 0x800000   // Bit FB23.
	CAN_F24R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F24R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F24R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F24R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F24R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F24R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F24R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F24R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F24R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F24R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F24R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F24R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F24R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F24R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F24R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F24R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F24R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F24R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F24R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F24R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F24R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F24R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F24R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F24R2_FB31     = 0x80000000 // Bit FB31.

	// F25R1: Filter bank 25 register 1
	CAN_F25R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F25R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F25R1_FB0      = 0x1        // Bit FB0.
	CAN_F25R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F25R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F25R1_FB1      = 0x2        // Bit FB1.
	CAN_F25R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F25R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F25R1_FB2      = 0x4        // Bit FB2.
	CAN_F25R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F25R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F25R1_FB3      = 0x8        // Bit FB3.
	CAN_F25R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F25R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F25R1_FB4      = 0x10       // Bit FB4.
	CAN_F25R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F25R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F25R1_FB5      = 0x20       // Bit FB5.
	CAN_F25R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F25R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F25R1_FB6      = 0x40       // Bit FB6.
	CAN_F25R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F25R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F25R1_FB7      = 0x80       // Bit FB7.
	CAN_F25R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F25R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F25R1_FB8      = 0x100      // Bit FB8.
	CAN_F25R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F25R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F25R1_FB9      = 0x200      // Bit FB9.
	CAN_F25R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F25R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F25R1_FB10     = 0x400      // Bit FB10.
	CAN_F25R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F25R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F25R1_FB11     = 0x800      // Bit FB11.
	CAN_F25R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F25R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F25R1_FB12     = 0x1000     // Bit FB12.
	CAN_F25R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F25R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F25R1_FB13     = 0x2000     // Bit FB13.
	CAN_F25R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F25R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F25R1_FB14     = 0x4000     // Bit FB14.
	CAN_F25R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F25R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F25R1_FB15     = 0x8000     // Bit FB15.
	CAN_F25R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F25R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F25R1_FB16     = 0x10000    // Bit FB16.
	CAN_F25R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F25R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F25R1_FB17     = 0x20000    // Bit FB17.
	CAN_F25R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F25R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F25R1_FB18     = 0x40000    // Bit FB18.
	CAN_F25R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F25R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F25R1_FB19     = 0x80000    // Bit FB19.
	CAN_F25R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F25R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F25R1_FB20     = 0x100000   // Bit FB20.
	CAN_F25R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F25R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F25R1_FB21     = 0x200000   // Bit FB21.
	CAN_F25R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F25R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F25R1_FB22     = 0x400000   // Bit FB22.
	CAN_F25R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F25R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F25R1_FB23     = 0x800000   // Bit FB23.
	CAN_F25R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F25R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F25R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F25R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F25R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F25R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F25R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F25R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F25R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F25R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F25R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F25R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F25R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F25R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F25R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F25R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F25R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F25R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F25R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F25R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F25R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F25R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F25R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F25R1_FB31     = 0x80000000 // Bit FB31.

	// F25R2: Filter bank 25 register 2
	CAN_F25R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F25R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F25R2_FB0      = 0x1        // Bit FB0.
	CAN_F25R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F25R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F25R2_FB1      = 0x2        // Bit FB1.
	CAN_F25R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F25R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F25R2_FB2      = 0x4        // Bit FB2.
	CAN_F25R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F25R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F25R2_FB3      = 0x8        // Bit FB3.
	CAN_F25R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F25R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F25R2_FB4      = 0x10       // Bit FB4.
	CAN_F25R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F25R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F25R2_FB5      = 0x20       // Bit FB5.
	CAN_F25R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F25R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F25R2_FB6      = 0x40       // Bit FB6.
	CAN_F25R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F25R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F25R2_FB7      = 0x80       // Bit FB7.
	CAN_F25R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F25R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F25R2_FB8      = 0x100      // Bit FB8.
	CAN_F25R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F25R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F25R2_FB9      = 0x200      // Bit FB9.
	CAN_F25R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F25R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F25R2_FB10     = 0x400      // Bit FB10.
	CAN_F25R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F25R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F25R2_FB11     = 0x800      // Bit FB11.
	CAN_F25R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F25R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F25R2_FB12     = 0x1000     // Bit FB12.
	CAN_F25R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F25R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F25R2_FB13     = 0x2000     // Bit FB13.
	CAN_F25R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F25R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F25R2_FB14     = 0x4000     // Bit FB14.
	CAN_F25R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F25R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F25R2_FB15     = 0x8000     // Bit FB15.
	CAN_F25R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F25R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F25R2_FB16     = 0x10000    // Bit FB16.
	CAN_F25R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F25R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F25R2_FB17     = 0x20000    // Bit FB17.
	CAN_F25R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F25R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F25R2_FB18     = 0x40000    // Bit FB18.
	CAN_F25R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F25R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F25R2_FB19     = 0x80000    // Bit FB19.
	CAN_F25R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F25R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F25R2_FB20     = 0x100000   // Bit FB20.
	CAN_F25R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F25R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F25R2_FB21     = 0x200000   // Bit FB21.
	CAN_F25R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F25R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F25R2_FB22     = 0x400000   // Bit FB22.
	CAN_F25R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F25R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F25R2_FB23     = 0x800000   // Bit FB23.
	CAN_F25R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F25R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F25R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F25R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F25R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F25R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F25R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F25R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F25R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F25R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F25R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F25R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F25R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F25R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F25R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F25R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F25R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F25R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F25R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F25R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F25R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F25R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F25R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F25R2_FB31     = 0x80000000 // Bit FB31.

	// F26R1: Filter bank 26 register 1
	CAN_F26R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F26R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F26R1_FB0      = 0x1        // Bit FB0.
	CAN_F26R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F26R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F26R1_FB1      = 0x2        // Bit FB1.
	CAN_F26R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F26R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F26R1_FB2      = 0x4        // Bit FB2.
	CAN_F26R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F26R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F26R1_FB3      = 0x8        // Bit FB3.
	CAN_F26R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F26R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F26R1_FB4      = 0x10       // Bit FB4.
	CAN_F26R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F26R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F26R1_FB5      = 0x20       // Bit FB5.
	CAN_F26R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F26R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F26R1_FB6      = 0x40       // Bit FB6.
	CAN_F26R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F26R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F26R1_FB7      = 0x80       // Bit FB7.
	CAN_F26R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F26R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F26R1_FB8      = 0x100      // Bit FB8.
	CAN_F26R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F26R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F26R1_FB9      = 0x200      // Bit FB9.
	CAN_F26R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F26R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F26R1_FB10     = 0x400      // Bit FB10.
	CAN_F26R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F26R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F26R1_FB11     = 0x800      // Bit FB11.
	CAN_F26R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F26R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F26R1_FB12     = 0x1000     // Bit FB12.
	CAN_F26R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F26R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F26R1_FB13     = 0x2000     // Bit FB13.
	CAN_F26R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F26R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F26R1_FB14     = 0x4000     // Bit FB14.
	CAN_F26R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F26R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F26R1_FB15     = 0x8000     // Bit FB15.
	CAN_F26R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F26R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F26R1_FB16     = 0x10000    // Bit FB16.
	CAN_F26R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F26R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F26R1_FB17     = 0x20000    // Bit FB17.
	CAN_F26R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F26R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F26R1_FB18     = 0x40000    // Bit FB18.
	CAN_F26R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F26R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F26R1_FB19     = 0x80000    // Bit FB19.
	CAN_F26R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F26R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F26R1_FB20     = 0x100000   // Bit FB20.
	CAN_F26R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F26R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F26R1_FB21     = 0x200000   // Bit FB21.
	CAN_F26R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F26R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F26R1_FB22     = 0x400000   // Bit FB22.
	CAN_F26R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F26R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F26R1_FB23     = 0x800000   // Bit FB23.
	CAN_F26R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F26R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F26R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F26R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F26R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F26R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F26R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F26R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F26R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F26R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F26R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F26R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F26R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F26R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F26R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F26R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F26R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F26R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F26R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F26R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F26R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F26R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F26R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F26R1_FB31     = 0x80000000 // Bit FB31.

	// F26R2: Filter bank 26 register 2
	CAN_F26R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F26R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F26R2_FB0      = 0x1        // Bit FB0.
	CAN_F26R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F26R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F26R2_FB1      = 0x2        // Bit FB1.
	CAN_F26R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F26R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F26R2_FB2      = 0x4        // Bit FB2.
	CAN_F26R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F26R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F26R2_FB3      = 0x8        // Bit FB3.
	CAN_F26R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F26R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F26R2_FB4      = 0x10       // Bit FB4.
	CAN_F26R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F26R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F26R2_FB5      = 0x20       // Bit FB5.
	CAN_F26R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F26R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F26R2_FB6      = 0x40       // Bit FB6.
	CAN_F26R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F26R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F26R2_FB7      = 0x80       // Bit FB7.
	CAN_F26R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F26R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F26R2_FB8      = 0x100      // Bit FB8.
	CAN_F26R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F26R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F26R2_FB9      = 0x200      // Bit FB9.
	CAN_F26R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F26R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F26R2_FB10     = 0x400      // Bit FB10.
	CAN_F26R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F26R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F26R2_FB11     = 0x800      // Bit FB11.
	CAN_F26R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F26R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F26R2_FB12     = 0x1000     // Bit FB12.
	CAN_F26R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F26R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F26R2_FB13     = 0x2000     // Bit FB13.
	CAN_F26R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F26R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F26R2_FB14     = 0x4000     // Bit FB14.
	CAN_F26R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F26R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F26R2_FB15     = 0x8000     // Bit FB15.
	CAN_F26R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F26R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F26R2_FB16     = 0x10000    // Bit FB16.
	CAN_F26R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F26R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F26R2_FB17     = 0x20000    // Bit FB17.
	CAN_F26R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F26R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F26R2_FB18     = 0x40000    // Bit FB18.
	CAN_F26R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F26R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F26R2_FB19     = 0x80000    // Bit FB19.
	CAN_F26R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F26R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F26R2_FB20     = 0x100000   // Bit FB20.
	CAN_F26R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F26R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F26R2_FB21     = 0x200000   // Bit FB21.
	CAN_F26R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F26R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F26R2_FB22     = 0x400000   // Bit FB22.
	CAN_F26R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F26R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F26R2_FB23     = 0x800000   // Bit FB23.
	CAN_F26R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F26R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F26R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F26R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F26R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F26R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F26R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F26R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F26R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F26R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F26R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F26R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F26R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F26R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F26R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F26R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F26R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F26R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F26R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F26R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F26R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F26R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F26R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F26R2_FB31     = 0x80000000 // Bit FB31.

	// F27R1: Filter bank 27 register 1
	CAN_F27R1_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F27R1_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F27R1_FB0      = 0x1        // Bit FB0.
	CAN_F27R1_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F27R1_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F27R1_FB1      = 0x2        // Bit FB1.
	CAN_F27R1_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F27R1_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F27R1_FB2      = 0x4        // Bit FB2.
	CAN_F27R1_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F27R1_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F27R1_FB3      = 0x8        // Bit FB3.
	CAN_F27R1_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F27R1_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F27R1_FB4      = 0x10       // Bit FB4.
	CAN_F27R1_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F27R1_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F27R1_FB5      = 0x20       // Bit FB5.
	CAN_F27R1_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F27R1_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F27R1_FB6      = 0x40       // Bit FB6.
	CAN_F27R1_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F27R1_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F27R1_FB7      = 0x80       // Bit FB7.
	CAN_F27R1_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F27R1_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F27R1_FB8      = 0x100      // Bit FB8.
	CAN_F27R1_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F27R1_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F27R1_FB9      = 0x200      // Bit FB9.
	CAN_F27R1_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F27R1_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F27R1_FB10     = 0x400      // Bit FB10.
	CAN_F27R1_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F27R1_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F27R1_FB11     = 0x800      // Bit FB11.
	CAN_F27R1_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F27R1_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F27R1_FB12     = 0x1000     // Bit FB12.
	CAN_F27R1_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F27R1_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F27R1_FB13     = 0x2000     // Bit FB13.
	CAN_F27R1_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F27R1_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F27R1_FB14     = 0x4000     // Bit FB14.
	CAN_F27R1_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F27R1_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F27R1_FB15     = 0x8000     // Bit FB15.
	CAN_F27R1_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F27R1_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F27R1_FB16     = 0x10000    // Bit FB16.
	CAN_F27R1_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F27R1_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F27R1_FB17     = 0x20000    // Bit FB17.
	CAN_F27R1_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F27R1_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F27R1_FB18     = 0x40000    // Bit FB18.
	CAN_F27R1_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F27R1_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F27R1_FB19     = 0x80000    // Bit FB19.
	CAN_F27R1_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F27R1_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F27R1_FB20     = 0x100000   // Bit FB20.
	CAN_F27R1_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F27R1_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F27R1_FB21     = 0x200000   // Bit FB21.
	CAN_F27R1_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F27R1_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F27R1_FB22     = 0x400000   // Bit FB22.
	CAN_F27R1_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F27R1_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F27R1_FB23     = 0x800000   // Bit FB23.
	CAN_F27R1_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F27R1_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F27R1_FB24     = 0x1000000  // Bit FB24.
	CAN_F27R1_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F27R1_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F27R1_FB25     = 0x2000000  // Bit FB25.
	CAN_F27R1_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F27R1_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F27R1_FB26     = 0x4000000  // Bit FB26.
	CAN_F27R1_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F27R1_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F27R1_FB27     = 0x8000000  // Bit FB27.
	CAN_F27R1_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F27R1_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F27R1_FB28     = 0x10000000 // Bit FB28.
	CAN_F27R1_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F27R1_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F27R1_FB29     = 0x20000000 // Bit FB29.
	CAN_F27R1_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F27R1_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F27R1_FB30     = 0x40000000 // Bit FB30.
	CAN_F27R1_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F27R1_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F27R1_FB31     = 0x80000000 // Bit FB31.

	// F27R2: Filter bank 27 register 2
	CAN_F27R2_FB0_Pos  = 0x0        // Position of FB0 field.
	CAN_F27R2_FB0_Msk  = 0x1        // Bit mask of FB0 field.
	CAN_F27R2_FB0      = 0x1        // Bit FB0.
	CAN_F27R2_FB1_Pos  = 0x1        // Position of FB1 field.
	CAN_F27R2_FB1_Msk  = 0x2        // Bit mask of FB1 field.
	CAN_F27R2_FB1      = 0x2        // Bit FB1.
	CAN_F27R2_FB2_Pos  = 0x2        // Position of FB2 field.
	CAN_F27R2_FB2_Msk  = 0x4        // Bit mask of FB2 field.
	CAN_F27R2_FB2      = 0x4        // Bit FB2.
	CAN_F27R2_FB3_Pos  = 0x3        // Position of FB3 field.
	CAN_F27R2_FB3_Msk  = 0x8        // Bit mask of FB3 field.
	CAN_F27R2_FB3      = 0x8        // Bit FB3.
	CAN_F27R2_FB4_Pos  = 0x4        // Position of FB4 field.
	CAN_F27R2_FB4_Msk  = 0x10       // Bit mask of FB4 field.
	CAN_F27R2_FB4      = 0x10       // Bit FB4.
	CAN_F27R2_FB5_Pos  = 0x5        // Position of FB5 field.
	CAN_F27R2_FB5_Msk  = 0x20       // Bit mask of FB5 field.
	CAN_F27R2_FB5      = 0x20       // Bit FB5.
	CAN_F27R2_FB6_Pos  = 0x6        // Position of FB6 field.
	CAN_F27R2_FB6_Msk  = 0x40       // Bit mask of FB6 field.
	CAN_F27R2_FB6      = 0x40       // Bit FB6.
	CAN_F27R2_FB7_Pos  = 0x7        // Position of FB7 field.
	CAN_F27R2_FB7_Msk  = 0x80       // Bit mask of FB7 field.
	CAN_F27R2_FB7      = 0x80       // Bit FB7.
	CAN_F27R2_FB8_Pos  = 0x8        // Position of FB8 field.
	CAN_F27R2_FB8_Msk  = 0x100      // Bit mask of FB8 field.
	CAN_F27R2_FB8      = 0x100      // Bit FB8.
	CAN_F27R2_FB9_Pos  = 0x9        // Position of FB9 field.
	CAN_F27R2_FB9_Msk  = 0x200      // Bit mask of FB9 field.
	CAN_F27R2_FB9      = 0x200      // Bit FB9.
	CAN_F27R2_FB10_Pos = 0xa        // Position of FB10 field.
	CAN_F27R2_FB10_Msk = 0x400      // Bit mask of FB10 field.
	CAN_F27R2_FB10     = 0x400      // Bit FB10.
	CAN_F27R2_FB11_Pos = 0xb        // Position of FB11 field.
	CAN_F27R2_FB11_Msk = 0x800      // Bit mask of FB11 field.
	CAN_F27R2_FB11     = 0x800      // Bit FB11.
	CAN_F27R2_FB12_Pos = 0xc        // Position of FB12 field.
	CAN_F27R2_FB12_Msk = 0x1000     // Bit mask of FB12 field.
	CAN_F27R2_FB12     = 0x1000     // Bit FB12.
	CAN_F27R2_FB13_Pos = 0xd        // Position of FB13 field.
	CAN_F27R2_FB13_Msk = 0x2000     // Bit mask of FB13 field.
	CAN_F27R2_FB13     = 0x2000     // Bit FB13.
	CAN_F27R2_FB14_Pos = 0xe        // Position of FB14 field.
	CAN_F27R2_FB14_Msk = 0x4000     // Bit mask of FB14 field.
	CAN_F27R2_FB14     = 0x4000     // Bit FB14.
	CAN_F27R2_FB15_Pos = 0xf        // Position of FB15 field.
	CAN_F27R2_FB15_Msk = 0x8000     // Bit mask of FB15 field.
	CAN_F27R2_FB15     = 0x8000     // Bit FB15.
	CAN_F27R2_FB16_Pos = 0x10       // Position of FB16 field.
	CAN_F27R2_FB16_Msk = 0x10000    // Bit mask of FB16 field.
	CAN_F27R2_FB16     = 0x10000    // Bit FB16.
	CAN_F27R2_FB17_Pos = 0x11       // Position of FB17 field.
	CAN_F27R2_FB17_Msk = 0x20000    // Bit mask of FB17 field.
	CAN_F27R2_FB17     = 0x20000    // Bit FB17.
	CAN_F27R2_FB18_Pos = 0x12       // Position of FB18 field.
	CAN_F27R2_FB18_Msk = 0x40000    // Bit mask of FB18 field.
	CAN_F27R2_FB18     = 0x40000    // Bit FB18.
	CAN_F27R2_FB19_Pos = 0x13       // Position of FB19 field.
	CAN_F27R2_FB19_Msk = 0x80000    // Bit mask of FB19 field.
	CAN_F27R2_FB19     = 0x80000    // Bit FB19.
	CAN_F27R2_FB20_Pos = 0x14       // Position of FB20 field.
	CAN_F27R2_FB20_Msk = 0x100000   // Bit mask of FB20 field.
	CAN_F27R2_FB20     = 0x100000   // Bit FB20.
	CAN_F27R2_FB21_Pos = 0x15       // Position of FB21 field.
	CAN_F27R2_FB21_Msk = 0x200000   // Bit mask of FB21 field.
	CAN_F27R2_FB21     = 0x200000   // Bit FB21.
	CAN_F27R2_FB22_Pos = 0x16       // Position of FB22 field.
	CAN_F27R2_FB22_Msk = 0x400000   // Bit mask of FB22 field.
	CAN_F27R2_FB22     = 0x400000   // Bit FB22.
	CAN_F27R2_FB23_Pos = 0x17       // Position of FB23 field.
	CAN_F27R2_FB23_Msk = 0x800000   // Bit mask of FB23 field.
	CAN_F27R2_FB23     = 0x800000   // Bit FB23.
	CAN_F27R2_FB24_Pos = 0x18       // Position of FB24 field.
	CAN_F27R2_FB24_Msk = 0x1000000  // Bit mask of FB24 field.
	CAN_F27R2_FB24     = 0x1000000  // Bit FB24.
	CAN_F27R2_FB25_Pos = 0x19       // Position of FB25 field.
	CAN_F27R2_FB25_Msk = 0x2000000  // Bit mask of FB25 field.
	CAN_F27R2_FB25     = 0x2000000  // Bit FB25.
	CAN_F27R2_FB26_Pos = 0x1a       // Position of FB26 field.
	CAN_F27R2_FB26_Msk = 0x4000000  // Bit mask of FB26 field.
	CAN_F27R2_FB26     = 0x4000000  // Bit FB26.
	CAN_F27R2_FB27_Pos = 0x1b       // Position of FB27 field.
	CAN_F27R2_FB27_Msk = 0x8000000  // Bit mask of FB27 field.
	CAN_F27R2_FB27     = 0x8000000  // Bit FB27.
	CAN_F27R2_FB28_Pos = 0x1c       // Position of FB28 field.
	CAN_F27R2_FB28_Msk = 0x10000000 // Bit mask of FB28 field.
	CAN_F27R2_FB28     = 0x10000000 // Bit FB28.
	CAN_F27R2_FB29_Pos = 0x1d       // Position of FB29 field.
	CAN_F27R2_FB29_Msk = 0x20000000 // Bit mask of FB29 field.
	CAN_F27R2_FB29     = 0x20000000 // Bit FB29.
	CAN_F27R2_FB30_Pos = 0x1e       // Position of FB30 field.
	CAN_F27R2_FB30_Msk = 0x40000000 // Bit mask of FB30 field.
	CAN_F27R2_FB30     = 0x40000000 // Bit FB30.
	CAN_F27R2_FB31_Pos = 0x1f       // Position of FB31 field.
	CAN_F27R2_FB31_Msk = 0x80000000 // Bit mask of FB31 field.
	CAN_F27R2_FB31     = 0x80000000 // Bit FB31.
)
