/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;

class Es6TemplateLiterals {
    private static final String TEMPLATELIT_VAR = "$jscomp$templatelit$";
    private final AstFactory astFactory;
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;

    Es6TemplateLiterals(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.registry = compiler.getTypeRegistry();
    }

    void visitTemplateLiteral(NodeTraversal t, Node n) {
        int length = n.getChildCount();
        if (length == 0) {
            n.replaceWith(this.astFactory.createString("\"\""));
        } else {
            Node first = n.removeFirstChild();
            Preconditions.checkState(first.isTemplateLitString() && first.getCookedString() != null);
            Node firstStr = this.astFactory.createString(first.getCookedString());
            if (length == 1) {
                n.replaceWith(firstStr);
            } else {
                Node add = Es6ToEs3Util.withType(IR.add(firstStr, n.removeFirstChild().removeFirstChild()), n.getJSType());
                for (int i = 2; i < length; ++i) {
                    Node child = n.removeFirstChild();
                    if (child.isTemplateLitString()) {
                        Preconditions.checkState(child.getCookedString() != null);
                        if (child.getCookedString().isEmpty()) continue;
                        if (i == 2 && first.getCookedString().isEmpty()) {
                            add = add.getSecondChild().detach();
                        }
                    }
                    add = Es6ToEs3Util.withType(IR.add(add, child.isTemplateLitString() ? this.astFactory.createString(child.getCookedString()) : child.removeFirstChild()), n.getJSType());
                }
                n.replaceWith(add.useSourceInfoIfMissingFromForTree(n));
            }
        }
        t.reportCodeChange();
    }

    void visitTaggedTemplateLiteral(NodeTraversal t, Node n, boolean addTypes) {
        Node callTemplateTagArgCreator;
        JSType stringType = Es6ToEs3Util.createType(addTypes, this.registry, JSTypeNative.STRING_TYPE);
        JSType arrayType = Es6ToEs3Util.createGenericType(addTypes, this.registry, JSTypeNative.ARRAY_TYPE, stringType);
        JSType templateArrayType = Es6ToEs3Util.createType(addTypes, this.registry, JSTypeNative.I_TEMPLATE_ARRAY_TYPE);
        Node templateLit = n.getLastChild();
        Node cooked = this.createCookedStringArray(templateLit, templateArrayType);
        Node siteObject = Es6ToEs3Util.withType(cooked, templateArrayType);
        if (Es6TemplateLiterals.cookedAndRawStringsSame(templateLit)) {
            callTemplateTagArgCreator = this.astFactory.createCall(this.astFactory.createQName(t.getScope(), "$jscomp.createTemplateTagFirstArg"), siteObject.cloneTree());
        } else {
            Node raw = this.createRawStringArray(templateLit, arrayType);
            callTemplateTagArgCreator = this.astFactory.createCall(this.astFactory.createQName(t.getScope(), "$jscomp.createTemplateTagFirstArgWithRaw"), siteObject.cloneTree(), raw);
        }
        JSDocInfoBuilder jsDocInfoBuilder = new JSDocInfoBuilder(false);
        jsDocInfoBuilder.recordNoInline();
        JSDocInfo info = jsDocInfoBuilder.build();
        CompilerInput input = t.getInput();
        String uniqueId = this.compiler.getUniqueIdSupplier().getUniqueId(input);
        Node tagFnFirstArgDeclaration = this.astFactory.createSingleVarNameDeclaration(TEMPLATELIT_VAR + uniqueId, callTemplateTagArgCreator).setJSDocInfo(info).useSourceInfoIfMissingFromForTree(n);
        Node insertionPoint = Es6TemplateLiterals.findInsertionPoint(n);
        insertionPoint.getParent().addChildBefore(tagFnFirstArgDeclaration, insertionPoint);
        t.reportCodeChange(tagFnFirstArgDeclaration);
        Node tagFnFirstArg = tagFnFirstArgDeclaration.getFirstChild().cloneNode();
        Node call = Es6ToEs3Util.withType(IR.call(n.removeFirstChild(), tagFnFirstArg), n.getJSType());
        for (Node child = templateLit.getFirstChild(); child != null; child = child.getNext()) {
            if (child.isTemplateLitString()) continue;
            call.addChildToBack(child.removeFirstChild());
        }
        call.useSourceInfoIfMissingFromForTree(templateLit);
        call.putBooleanProp(Node.FREE_CALL, !call.getFirstChild().isGetProp());
        n.replaceWith(call);
        t.reportCodeChange();
    }

    private Node createRawStringArray(Node n, JSType arrayType) {
        Node array = Es6ToEs3Util.withType(IR.arraylit(new Node[0]), arrayType);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isTemplateLitString()) continue;
            array.addChildToBack(this.astFactory.createString(child.getRawString()));
        }
        return array;
    }

    private static Node findInsertionPoint(Node n) {
        Node insertionPoint = n;
        Node insertionParent = Preconditions.checkNotNull(insertionPoint.getParent(), n);
        while (!insertionParent.isScript()) {
            insertionPoint = insertionParent;
            insertionParent = Preconditions.checkNotNull(insertionPoint.getParent(), insertionPoint);
        }
        Preconditions.checkState(insertionParent.isScript(), insertionParent);
        return insertionPoint;
    }

    private Node createCookedStringArray(Node n, JSType templateArrayType) {
        Node array = Es6ToEs3Util.withType(IR.arraylit(new Node[0]), templateArrayType);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isTemplateLitString()) continue;
            if (child.getCookedString() != null) {
                array.addChildToBack(this.astFactory.createString(child.getCookedString()));
                continue;
            }
            array.addChildToBack(this.astFactory.createVoid(this.astFactory.createNumber(0.0)));
        }
        return array;
    }

    private static boolean cookedAndRawStringsSame(Node n) {
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isTemplateLitString() || child.getCookedString() != null && child.getCookedString().equals(child.getRawString())) continue;
            return false;
        }
        return true;
    }
}

