/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.ArrayList;

public class FunctionParamBuilder {
    private final JSTypeRegistry registry;
    private final ArrayList<FunctionType.Parameter> parameters = new ArrayList();

    public FunctionParamBuilder(JSTypeRegistry registry) {
        this.registry = registry;
    }

    public boolean addRequiredParams(JSType ... types) {
        if (this.hasOptionalOrVarArgs()) {
            return false;
        }
        for (JSType type : types) {
            this.newParameter(type, false, false);
        }
        return true;
    }

    public boolean addOptionalParams(JSType ... types) {
        if (this.hasVarArgs()) {
            return false;
        }
        for (JSType type : types) {
            this.newParameter(this.registry.createOptionalType(type), true, false);
        }
        return true;
    }

    public boolean addVarArgs(JSType type) {
        if (this.hasVarArgs()) {
            return false;
        }
        this.newParameter(type, false, true);
        return true;
    }

    public void newParameterFrom(FunctionType.Parameter n) {
        this.newParameter(n.getJSType(), n.isOptional(), n.isVariadic());
    }

    public void newOptionalParameterFrom(FunctionType.Parameter p) {
        boolean isOptional = p.isOptional() || !p.isVariadic();
        this.newParameter(p.getJSType(), isOptional, p.isVariadic());
    }

    private void newParameter(JSType type, boolean isOptional, boolean isVariadic) {
        FunctionType.Parameter parameter = FunctionType.Parameter.create(type, isOptional, isVariadic);
        this.parameters.add(parameter);
    }

    private boolean hasOptionalOrVarArgs() {
        if (this.parameters.isEmpty()) {
            return false;
        }
        FunctionType.Parameter lastParam = Iterables.getLast(this.parameters);
        return lastParam.isOptional() || lastParam.isVariadic();
    }

    public boolean hasVarArgs() {
        return !this.parameters.isEmpty() && Iterables.getLast(this.parameters).isVariadic();
    }

    public ImmutableList<FunctionType.Parameter> build() {
        return ImmutableList.copyOf(this.parameters);
    }
}

