/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.solr.analytics.AnalyticsExpression;
import org.apache.solr.analytics.facet.AbstractSolrQueryFacet;
import org.apache.solr.analytics.facet.AnalyticsFacet;
import org.apache.solr.analytics.facet.QueryFacet;
import org.apache.solr.analytics.facet.RangeFacet;
import org.apache.solr.analytics.facet.StreamingFacet;
import org.apache.solr.analytics.facet.ValueFacet;
import org.apache.solr.analytics.function.ExpressionCalculator;
import org.apache.solr.analytics.function.ReductionCollectionManager;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.Filter;

public class AnalyticsGroupingManager {
    private final String name;
    private final ReductionCollectionManager reductionCollectionManager;
    private final Collection<AnalyticsExpression> topLevelExpressions;
    private final ExpressionCalculator expressionCalculator;
    private final Map<String, AnalyticsFacet> facets;
    private boolean hasStreamingFacets;

    public AnalyticsGroupingManager(String name, ReductionCollectionManager reductionCollectionManager, Collection<AnalyticsExpression> topLevelExpressions) {
        this.name = name;
        this.reductionCollectionManager = reductionCollectionManager;
        this.topLevelExpressions = topLevelExpressions;
        this.expressionCalculator = new ExpressionCalculator(topLevelExpressions);
        this.facets = new HashMap<String, AnalyticsFacet>();
    }

    public boolean getStreamingFacets(Consumer<StreamingFacet> cons) {
        this.hasStreamingFacets = false;
        this.facets.forEach((name, facet) -> {
            if (facet instanceof StreamingFacet) {
                cons.accept((StreamingFacet)((Object)facet));
                this.hasStreamingFacets = true;
            }
        });
        return this.hasStreamingFacets;
    }

    public void getFacetExecuters(Filter filter, SolrQueryRequest queryRequest, Consumer<AbstractSolrQueryFacet.FacetValueQueryExecuter> cons) {
        this.facets.forEach((name, facet) -> {
            if (facet instanceof AbstractSolrQueryFacet) {
                ((AbstractSolrQueryFacet)facet).createFacetValueExecuters(filter, queryRequest, cons);
            }
        });
    }

    public void addFacet(AnalyticsFacet facet) {
        facet.setExpressionCalculator(this.expressionCalculator);
        facet.setReductionCollectionManager(this.reductionCollectionManager);
        this.facets.put(facet.getName(), facet);
    }

    public void importShardData(DataInput input) throws IOException {
        this.reductionCollectionManager.setShardInput(input);
        int sz = input.readInt();
        for (int i = 0; i < sz; ++i) {
            this.facets.get(input.readUTF()).importShardData(input);
        }
    }

    public void exportShardData(DataOutput output) throws IOException {
        this.reductionCollectionManager.setShardOutput(output);
        output.writeInt(this.facets.size());
        for (Map.Entry<String, AnalyticsFacet> facet : this.facets.entrySet()) {
            output.writeUTF(facet.getKey());
            facet.getValue().exportShardData(output);
        }
    }

    public ReductionCollectionManager getReductionManager() {
        return this.reductionCollectionManager;
    }

    public Map<String, Object> createResponse() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        this.facets.forEach((name, facet) -> response.put((String)name, facet.createResponse()));
        return response;
    }

    public NamedList<Object> createOldResponse(Map<String, Object> overallResults) {
        NamedList response = new NamedList();
        this.topLevelExpressions.forEach(expression -> response.add(expression.getName(), overallResults.get(this.name + expression.getName())));
        NamedList fieldFacetResults = new NamedList();
        NamedList rangeFacetResults = new NamedList();
        NamedList queryFacetResults = new NamedList();
        this.facets.forEach((name, facet) -> {
            if (facet instanceof ValueFacet) {
                fieldFacetResults.add(name, facet.createOldResponse());
            } else if (facet instanceof RangeFacet) {
                rangeFacetResults.add(name, facet.createOldResponse());
            } else if (facet instanceof QueryFacet) {
                queryFacetResults.add(name, facet.createOldResponse());
            }
        });
        if (fieldFacetResults.size() > 0) {
            response.add("fieldFacets", (Object)fieldFacetResults);
        }
        if (rangeFacetResults.size() > 0) {
            response.add("rangeFacets", (Object)rangeFacetResults);
        }
        if (queryFacetResults.size() > 0) {
            response.add("queryFacets", (Object)queryFacetResults);
        }
        return response;
    }

    public String getName() {
        return this.name;
    }
}

