/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class Modularity
implements Statistics,
LongTask {
    public static final String MODULARITY_CLASS = "modularity_class";
    private ProgressTicket progress;
    private boolean isCanceled;
    private CommunityStructure structure;
    private double modularity;
    private double modularityResolution;
    private boolean isRandomized = false;
    private boolean useWeight = true;
    private double resolution = 1.0;

    public void setRandom(boolean isRandomized) {
        this.isRandomized = isRandomized;
    }

    public boolean getRandom() {
        return this.isRandomized;
    }

    public void setUseWeight(boolean useWeight) {
        this.useWeight = useWeight;
    }

    public boolean getUseWeight() {
        return this.useWeight;
    }

    public void setResolution(double resolution) {
        this.resolution = resolution;
    }

    public double getResolution() {
        return this.resolution;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public void execute(GraphModel graphModel) {
        UndirectedGraph graph = graphModel.getUndirectedGraphVisible();
        this.execute((Graph)graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Graph graph) {
        this.isCanceled = false;
        graph.readLock();
        try {
            this.structure = new CommunityStructure(graph);
            int[] comStructure = new int[graph.getNodeCount()];
            if (graph.getNodeCount() > 0) {
                HashMap<String, Double> computedModularityMetrics = this.computeModularity(graph, this.structure, comStructure, this.resolution, this.isRandomized, this.useWeight);
                this.modularity = computedModularityMetrics.get("modularity");
                this.modularityResolution = computedModularityMetrics.get("modularityResolution");
            } else {
                this.modularity = 0.0;
                this.modularityResolution = 0.0;
            }
            this.saveValues(comStructure, graph, this.structure);
        }
        finally {
            graph.readUnlock();
        }
    }

    protected HashMap<String, Double> computeModularity(Graph graph, CommunityStructure theStructure, int[] comStructure, double currentResolution, boolean randomized, boolean weighted) {
        this.isCanceled = false;
        Progress.start((ProgressTicket)this.progress);
        Random rand = new Random();
        double totalWeight = theStructure.graphWeightSum;
        double[] nodeDegrees = (double[])theStructure.weights.clone();
        HashMap<String, Double> results = new HashMap<String, Double>();
        if (this.isCanceled) {
            return results;
        }
        boolean someChange = true;
        while (someChange) {
            someChange = false;
            boolean localChange = true;
            while (localChange) {
                localChange = false;
                int start = 0;
                if (randomized) {
                    start = Math.abs(rand.nextInt()) % theStructure.N;
                }
                int step = 0;
                int i = start;
                while (step < theStructure.N) {
                    ++step;
                    Community bestCommunity = this.updateBestCommunity(theStructure, i, currentResolution);
                    if (theStructure.nodeCommunities[i] != bestCommunity && bestCommunity != null) {
                        theStructure.moveNodeTo(i, bestCommunity);
                        localChange = true;
                    }
                    if (this.isCanceled) {
                        return results;
                    }
                    i = (i + 1) % theStructure.N;
                }
                boolean bl = someChange = localChange || someChange;
                if (!this.isCanceled) continue;
                return results;
            }
            if (!someChange) continue;
            theStructure.zoomOut();
        }
        this.fillComStructure(graph, theStructure, comStructure);
        double[] degreeCount = this.fillDegreeCount(graph, theStructure, comStructure, nodeDegrees, weighted);
        double computedModularity = this.finalQ(comStructure, degreeCount, graph, theStructure, totalWeight, 1.0, weighted);
        double computedModularityResolution = this.finalQ(comStructure, degreeCount, graph, theStructure, totalWeight, currentResolution, weighted);
        results.put("modularity", computedModularity);
        results.put("modularityResolution", computedModularityResolution);
        return results;
    }

    private Community updateBestCommunity(CommunityStructure theStructure, int node_id, double currentResolution) {
        double best = 0.0;
        Community bestCommunity = null;
        Set<Community> iter = theStructure.nodeConnectionsWeight[node_id].keySet();
        for (Community com : iter) {
            double qValue = this.q(node_id, com, theStructure, currentResolution);
            if (!(qValue > best)) continue;
            best = qValue;
            bestCommunity = com;
        }
        return bestCommunity;
    }

    private int[] fillComStructure(Graph graph, CommunityStructure theStructure, int[] comStructure) {
        int count = 0;
        for (Community com : theStructure.communities) {
            for (Integer node : com.nodes) {
                Community hidden = theStructure.invMap.get(node);
                for (Integer nodeInt : hidden.nodes) {
                    comStructure[nodeInt.intValue()] = count;
                }
            }
            ++count;
        }
        return comStructure;
    }

    private double[] fillDegreeCount(Graph graph, CommunityStructure theStructure, int[] comStructure, double[] nodeDegrees, boolean weighted) {
        double[] degreeCount = new double[theStructure.communities.size()];
        for (Node node : graph.getNodes()) {
            int index = theStructure.map.get(node);
            if (weighted) {
                int n = comStructure[index];
                degreeCount[n] = degreeCount[n] + nodeDegrees[index];
                continue;
            }
            int n = comStructure[index];
            degreeCount[n] = degreeCount[n] + (double)graph.getDegree(node);
        }
        return degreeCount;
    }

    private double finalQ(int[] struct, double[] degrees, Graph graph, CommunityStructure theStructure, double totalWeight, double usedResolution, boolean weighted) {
        double res = 0.0;
        double[] internal = new double[degrees.length];
        for (Node n : graph.getNodes()) {
            int n_index = theStructure.map.get(n);
            for (Edge edge : graph.getEdges(n)) {
                int neigh_index;
                Node neighbor = graph.getOpposite(n, edge);
                if (n == neighbor || struct[neigh_index = theStructure.map.get(neighbor).intValue()] != struct[n_index]) continue;
                if (weighted) {
                    int n2 = struct[neigh_index];
                    internal[n2] = internal[n2] + edge.getWeight(graph.getView());
                    continue;
                }
                int n3 = struct[neigh_index];
                internal[n3] = internal[n3] + 1.0;
            }
        }
        for (int i = 0; i < degrees.length; ++i) {
            int n = i;
            internal[n] = internal[n] / 2.0;
            res += usedResolution * (internal[i] / totalWeight) - Math.pow(degrees[i] / (2.0 * totalWeight), 2.0);
        }
        return res;
    }

    private void saveValues(int[] struct, Graph graph, CommunityStructure theStructure) {
        Table nodeTable = graph.getModel().getNodeTable();
        Column modCol = nodeTable.getColumn(MODULARITY_CLASS);
        if (modCol == null) {
            modCol = nodeTable.addColumn(MODULARITY_CLASS, "Modularity Class", Integer.class, (Object)0);
        }
        for (Node n : graph.getNodes()) {
            int n_index = theStructure.map.get(n);
            n.setAttribute(modCol, (Object)struct[n_index]);
        }
    }

    public double getModularity() {
        return this.modularity;
    }

    public String getReport() {
        HashMap<Integer, Integer> sizeDist = new HashMap<Integer, Integer>();
        for (Node n : this.structure.graph.getNodes()) {
            Integer v = (Integer)n.getAttribute(MODULARITY_CLASS);
            if (!sizeDist.containsKey(v)) {
                sizeDist.put(v, 0);
            }
            sizeDist.put(v, (Integer)sizeDist.get(v) + 1);
        }
        XYSeries dSeries = ChartUtils.createXYSeries(sizeDist, "Size Distribution");
        XYSeriesCollection dataset1 = new XYSeriesCollection();
        dataset1.addSeries(dSeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Size Distribution", (String)"Modularity Class", (String)"Size (number of nodes)", (XYDataset)dataset1, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.removeLegend();
        ChartUtils.decorateChart(chart);
        ChartUtils.scaleChart(chart, dSeries, false);
        String imageFile = ChartUtils.renderChart(chart, "communities-size-distribution.png");
        DecimalFormat f = new DecimalFormat("#0.000");
        String report = "<HTML> <BODY> <h1>Modularity Report </h1> <hr><h2> Parameters: </h2>Randomize:  " + (this.isRandomized ? "On" : "Off") + "<br>Use edge weights:  " + (this.useWeight ? "On" : "Off") + "<br>Resolution:  " + this.resolution + "<br><br> <h2> Results: </h2>Modularity: " + f.format(this.modularity) + "<br>Modularity with resolution: " + f.format(this.modularityResolution) + "<br>Number of Communities: " + this.structure.communities.size() + "<br /><br />" + imageFile + "<br /><br /><h2> Algorithm: </h2>Vincent D Blondel, Jean-Loup Guillaume, Renaud Lambiotte, Etienne Lefebvre, <i>Fast unfolding of communities in large networks</i>, in Journal of Statistical Mechanics: Theory and Experiment 2008 (10), P1000<br /><br /><br /><h2> Resolution: </h2>R. Lambiotte, J.-C. Delvenne, M. Barahona <i>Laplacian Dynamics and Multiscale Modular Structure in Networks 2009<br /></BODY> </HTML>";
        return report;
    }

    private double q(int node, Community community, CommunityStructure theStructure, double currentResolution) {
        Float edgesToFloat = theStructure.nodeConnectionsWeight[node].get(community);
        double edgesTo = 0.0;
        if (edgesToFloat != null) {
            edgesTo = edgesToFloat.doubleValue();
        }
        double weightSum = community.weightSum;
        double nodeWeight = theStructure.weights[node];
        double qValue = currentResolution * edgesTo - nodeWeight * weightSum / (2.0 * theStructure.graphWeightSum);
        if (theStructure.nodeCommunities[node] == community && theStructure.nodeCommunities[node].size() > 1) {
            qValue = currentResolution * edgesTo - nodeWeight * (weightSum - nodeWeight) / (2.0 * theStructure.graphWeightSum);
        }
        if (theStructure.nodeCommunities[node] == community && theStructure.nodeCommunities[node].size() == 1) {
            qValue = 0.0;
        }
        return qValue;
    }

    class Community {
        double weightSum;
        CommunityStructure structure;
        List<Integer> nodes;
        HashMap<Community, Float> connectionsWeight;
        HashMap<Community, Integer> connectionsCount;

        public int size() {
            return this.nodes.size();
        }

        public Community(Community com) {
            this.structure = com.structure;
            this.connectionsWeight = new HashMap();
            this.connectionsCount = new HashMap();
            this.nodes = new ArrayList<Integer>();
        }

        public Community(CommunityStructure structure) {
            this.structure = structure;
            this.connectionsWeight = new HashMap();
            this.connectionsCount = new HashMap();
            this.nodes = new ArrayList<Integer>();
        }

        public void seed(int node) {
            this.nodes.add(node);
            this.weightSum += this.structure.weights[node];
        }

        public boolean add(int node) {
            this.nodes.add(node);
            this.weightSum += this.structure.weights[node];
            return true;
        }

        public boolean remove(int node) {
            boolean result = this.nodes.remove((Object)node);
            this.weightSum -= this.structure.weights[node];
            if (this.nodes.isEmpty()) {
                this.structure.communities.remove(this);
            }
            return result;
        }
    }

    class CommunityStructure {
        HashMap<Community, Float>[] nodeConnectionsWeight;
        HashMap<Community, Integer>[] nodeConnectionsCount;
        HashMap<Node, Integer> map;
        Community[] nodeCommunities;
        Graph graph;
        double[] weights;
        double graphWeightSum;
        List<ModEdge>[] topology;
        List<Community> communities;
        int N;
        HashMap<Integer, Community> invMap;

        CommunityStructure(Graph graph) {
            this.graph = graph;
            this.N = graph.getNodeCount();
            this.invMap = new HashMap();
            this.nodeConnectionsWeight = new HashMap[this.N];
            this.nodeConnectionsCount = new HashMap[this.N];
            this.nodeCommunities = new Community[this.N];
            this.map = new HashMap();
            this.topology = new ArrayList[this.N];
            this.communities = new ArrayList<Community>();
            int index = 0;
            this.weights = new double[this.N];
            NodeIterable nodesIterable = graph.getNodes();
            for (Node node : nodesIterable) {
                this.map.put(node, index);
                this.nodeCommunities[index] = new Community(this);
                this.nodeConnectionsWeight[index] = new HashMap();
                this.nodeConnectionsCount[index] = new HashMap();
                this.weights[index] = 0.0;
                this.nodeCommunities[index].seed(index);
                Community hidden = new Community(Modularity.this.structure);
                hidden.nodes.add(index);
                this.invMap.put(index, hidden);
                this.communities.add(this.nodeCommunities[index]);
                ++index;
                if (!Modularity.this.isCanceled) continue;
                nodesIterable.doBreak();
                return;
            }
            int[] edgeTypes = graph.getModel().getEdgeTypes();
            nodesIterable = graph.getNodes();
            for (Node node : nodesIterable) {
                int node_index = this.map.get(node);
                this.topology[node_index] = new ArrayList<ModEdge>();
                HashSet uniqueNeighbors = new HashSet(graph.getNeighbors(node).toCollection());
                for (Node neighbor : uniqueNeighbors) {
                    if (node == neighbor) continue;
                    int neighbor_index = this.map.get(neighbor);
                    float weight = 0.0f;
                    for (int edgeType : edgeTypes) {
                        for (Edge edge : graph.getEdges(node, neighbor, edgeType)) {
                            if (Modularity.this.useWeight) {
                                weight = (float)((double)weight + edge.getWeight(graph.getView()));
                                continue;
                            }
                            weight += 1.0f;
                        }
                    }
                    int n = node_index;
                    this.weights[n] = this.weights[n] + (double)weight;
                    ModEdge me = new ModEdge(node_index, neighbor_index, weight);
                    this.topology[node_index].add(me);
                    Community adjCom = this.nodeCommunities[neighbor_index];
                    this.nodeConnectionsWeight[node_index].put(adjCom, Float.valueOf(weight));
                    this.nodeConnectionsCount[node_index].put(adjCom, 1);
                    Community nodeCom = this.nodeCommunities[node_index];
                    nodeCom.connectionsWeight.put(adjCom, Float.valueOf(weight));
                    nodeCom.connectionsCount.put(adjCom, 1);
                    this.nodeConnectionsWeight[neighbor_index].put(nodeCom, Float.valueOf(weight));
                    this.nodeConnectionsCount[neighbor_index].put(nodeCom, 1);
                    adjCom.connectionsWeight.put(nodeCom, Float.valueOf(weight));
                    adjCom.connectionsCount.put(nodeCom, 1);
                    this.graphWeightSum += (double)weight;
                }
                if (!Modularity.this.isCanceled) continue;
                nodesIterable.doBreak();
                return;
            }
            this.graphWeightSum /= 2.0;
        }

        private void addNodeTo(int node, Community to) {
            to.add(node);
            this.nodeCommunities[node] = to;
            for (ModEdge e : this.topology[node]) {
                int neighbor = e.target;
                Float neighEdgesTo = this.nodeConnectionsWeight[neighbor].get(to);
                if (neighEdgesTo == null) {
                    this.nodeConnectionsWeight[neighbor].put(to, Float.valueOf(e.weight));
                } else {
                    this.nodeConnectionsWeight[neighbor].put(to, Float.valueOf(neighEdgesTo.floatValue() + e.weight));
                }
                Integer neighCountEdgesTo = this.nodeConnectionsCount[neighbor].get(to);
                if (neighCountEdgesTo == null) {
                    this.nodeConnectionsCount[neighbor].put(to, 1);
                } else {
                    this.nodeConnectionsCount[neighbor].put(to, neighCountEdgesTo + 1);
                }
                Community adjCom = this.nodeCommunities[neighbor];
                Float wEdgesto = adjCom.connectionsWeight.get(to);
                if (wEdgesto == null) {
                    adjCom.connectionsWeight.put(to, Float.valueOf(e.weight));
                } else {
                    adjCom.connectionsWeight.put(to, Float.valueOf(wEdgesto.floatValue() + e.weight));
                }
                Integer cEdgesto = adjCom.connectionsCount.get(to);
                if (cEdgesto == null) {
                    adjCom.connectionsCount.put(to, 1);
                } else {
                    adjCom.connectionsCount.put(to, cEdgesto + 1);
                }
                Float nodeEdgesTo = this.nodeConnectionsWeight[node].get(adjCom);
                if (nodeEdgesTo == null) {
                    this.nodeConnectionsWeight[node].put(adjCom, Float.valueOf(e.weight));
                } else {
                    this.nodeConnectionsWeight[node].put(adjCom, Float.valueOf(nodeEdgesTo.floatValue() + e.weight));
                }
                Integer nodeCountEdgesTo = this.nodeConnectionsCount[node].get(adjCom);
                if (nodeCountEdgesTo == null) {
                    this.nodeConnectionsCount[node].put(adjCom, 1);
                } else {
                    this.nodeConnectionsCount[node].put(adjCom, nodeCountEdgesTo + 1);
                }
                if (to == adjCom) continue;
                Float comEdgesto = to.connectionsWeight.get(adjCom);
                if (comEdgesto == null) {
                    to.connectionsWeight.put(adjCom, Float.valueOf(e.weight));
                } else {
                    to.connectionsWeight.put(adjCom, Float.valueOf(comEdgesto.floatValue() + e.weight));
                }
                Integer comCountEdgesto = to.connectionsCount.get(adjCom);
                if (comCountEdgesto == null) {
                    to.connectionsCount.put(adjCom, 1);
                    continue;
                }
                to.connectionsCount.put(adjCom, comCountEdgesto + 1);
            }
        }

        private void removeNodeFromItsCommunity(int node) {
            Community community = this.nodeCommunities[node];
            for (ModEdge e : this.topology[node]) {
                int neighbor = e.target;
                Float edgesTo = this.nodeConnectionsWeight[neighbor].get(community);
                Integer countEdgesTo = this.nodeConnectionsCount[neighbor].get(community);
                if (countEdgesTo - 1 == 0) {
                    this.nodeConnectionsWeight[neighbor].remove(community);
                    this.nodeConnectionsCount[neighbor].remove(community);
                } else {
                    this.nodeConnectionsWeight[neighbor].put(community, Float.valueOf(edgesTo.floatValue() - e.weight));
                    this.nodeConnectionsCount[neighbor].put(community, countEdgesTo - 1);
                }
                Community adjCom = this.nodeCommunities[neighbor];
                Float oEdgesto = adjCom.connectionsWeight.get(community);
                Integer oCountEdgesto = adjCom.connectionsCount.get(community);
                if (oCountEdgesto - 1 == 0) {
                    adjCom.connectionsWeight.remove(community);
                    adjCom.connectionsCount.remove(community);
                } else {
                    adjCom.connectionsWeight.put(community, Float.valueOf(oEdgesto.floatValue() - e.weight));
                    adjCom.connectionsCount.put(community, oCountEdgesto - 1);
                }
                if (node == neighbor) continue;
                if (adjCom != community) {
                    Float comEdgesto = community.connectionsWeight.get(adjCom);
                    Integer comCountEdgesto = community.connectionsCount.get(adjCom);
                    if (comCountEdgesto - 1 == 0) {
                        community.connectionsWeight.remove(adjCom);
                        community.connectionsCount.remove(adjCom);
                    } else {
                        community.connectionsWeight.put(adjCom, Float.valueOf(comEdgesto.floatValue() - e.weight));
                        community.connectionsCount.put(adjCom, comCountEdgesto - 1);
                    }
                }
                Float nodeEgesTo = this.nodeConnectionsWeight[node].get(adjCom);
                Integer nodeCountEgesTo = this.nodeConnectionsCount[node].get(adjCom);
                if (nodeCountEgesTo - 1 == 0) {
                    this.nodeConnectionsWeight[node].remove(adjCom);
                    this.nodeConnectionsCount[node].remove(adjCom);
                    continue;
                }
                this.nodeConnectionsWeight[node].put(adjCom, Float.valueOf(nodeEgesTo.floatValue() - e.weight));
                this.nodeConnectionsCount[node].put(adjCom, nodeCountEgesTo - 1);
            }
            community.remove(node);
        }

        private void moveNodeTo(int node, Community to) {
            this.removeNodeFromItsCommunity(node);
            this.addNodeTo(node, to);
        }

        private void zoomOut() {
            Community com;
            int i;
            int M = this.communities.size();
            ArrayList[] newTopology = new ArrayList[M];
            int index = 0;
            this.nodeCommunities = new Community[M];
            this.nodeConnectionsWeight = new HashMap[M];
            this.nodeConnectionsCount = new HashMap[M];
            HashMap<Integer, Community> newInvMap = new HashMap<Integer, Community>();
            for (i = 0; i < this.communities.size(); ++i) {
                com = this.communities.get(i);
                this.nodeConnectionsWeight[index] = new HashMap();
                this.nodeConnectionsCount[index] = new HashMap();
                newTopology[index] = new ArrayList();
                this.nodeCommunities[index] = new Community(com);
                Set<Community> iter = com.connectionsWeight.keySet();
                double weightSum = 0.0;
                Community hidden = new Community(Modularity.this.structure);
                for (Integer nodeInt : com.nodes) {
                    Community oldHidden = this.invMap.get(nodeInt);
                    hidden.nodes.addAll(oldHidden.nodes);
                }
                newInvMap.put(index, hidden);
                for (Community adjCom : iter) {
                    int target = this.communities.indexOf(adjCom);
                    float weight = com.connectionsWeight.get(adjCom).floatValue();
                    weightSum = target == index ? (weightSum += 2.0 * (double)weight) : (weightSum += (double)weight);
                    ModEdge e = new ModEdge(index, target, weight);
                    newTopology[index].add(e);
                }
                this.weights[index] = weightSum;
                this.nodeCommunities[index].seed(index);
                ++index;
            }
            this.communities.clear();
            for (i = 0; i < M; ++i) {
                com = this.nodeCommunities[i];
                this.communities.add(com);
                for (ModEdge e : newTopology[i]) {
                    this.nodeConnectionsWeight[i].put(this.nodeCommunities[e.target], Float.valueOf(e.weight));
                    this.nodeConnectionsCount[i].put(this.nodeCommunities[e.target], 1);
                    com.connectionsWeight.put(this.nodeCommunities[e.target], Float.valueOf(e.weight));
                    com.connectionsCount.put(this.nodeCommunities[e.target], 1);
                }
            }
            this.N = M;
            this.topology = newTopology;
            this.invMap = newInvMap;
        }
    }

    class ModEdge {
        int source;
        int target;
        float weight;

        public ModEdge(int s, int t, float w) {
            this.source = s;
            this.target = t;
            this.weight = w;
        }
    }
}

