/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api;

import org.netbeans.validation.api.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Problem
implements Comparable<Problem> {
    private final String message;
    private final Severity severity;

    public Problem(String message, Severity severity) {
        if (message == null) {
            throw new NullPointerException("Null message");
        }
        if (severity == null) {
            throw new NullPointerException("Null kind");
        }
        this.message = message;
        this.severity = severity;
    }

    public Severity severity() {
        return this.severity;
    }

    public boolean isWorseThan(Problem other) {
        return other == null ? true : this.compareTo(other) > 0;
    }

    public boolean isFatal() {
        return this.severity == Severity.FATAL;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public int compareTo(Problem o) {
        int ix = this.severity.ordinal();
        int oid = o.severity.ordinal();
        return ix - oid;
    }

    public boolean equals(Object o) {
        boolean result;
        if (o == this) {
            return true;
        }
        boolean bl = result = o != null && o.getClass() == Problem.class;
        if (result) {
            Problem p = (Problem)o;
            result = p.severity == this.severity && p.getMessage().equals(this.getMessage());
        }
        return result;
    }

    public String toString() {
        return this.getMessage() + "(" + (Object)((Object)this.severity()) + ")";
    }

    public int hashCode() {
        return this.message.hashCode() * (this.severity.hashCode() + 1);
    }
}

