/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.atomic.AtomicBoolean;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.AbstractConverter;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

class InternalConverter
extends AbstractConverter
implements Converter {
    private final Class<?> type;
    private final Provider<Converter> provider;
    private final AtomicBoolean calledSetConverterManager = new AtomicBoolean();
    private volatile ConverterManager converterManager;

    @Inject
    InternalConverter() {
        this.type = null;
        this.provider = null;
    }

    InternalConverter(Class<?> type, Provider<Converter> provider) {
        this.type = type;
        this.provider = provider;
    }

    @Override
    public Object convertInbound(Class<?> typeInfo, InboundVariable data) throws ConversionException {
        try {
            return this.getConverter().convertInbound(typeInfo, data);
        }
        catch (ClassCastException e) {
            throw new ConversionException(this.type, (Throwable)e);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws ConversionException {
        try {
            return this.getConverter().convertOutbound(this.type.cast(data), outctx);
        }
        catch (ClassCastException e) {
            throw new ConversionException(this.type, (Throwable)e);
        }
    }

    @Override
    public void setConverterManager(ConverterManager mgr) {
        this.converterManager = mgr;
    }

    private Converter getConverter() {
        Converter converter = (Converter)this.provider.get();
        if (this.calledSetConverterManager.compareAndSet(false, true)) {
            converter.setConverterManager(this.converterManager);
        }
        return converter;
    }
}

