/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileAssemblySimple;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.AbstractParallelFtilesBuilder;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileBlackBlock;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class ParallelBuilderMerge
extends AbstractParallelFtilesBuilder {
    public ParallelBuilderMerge(ISkinParam skinParam, StringBounder stringBounder, List<Ftile> all) {
        super(skinParam, stringBounder, all);
    }

    @Override
    protected Ftile doStep1(Ftile inner) {
        Ftile result = inner;
        ArrayList<Connection> conns = new ArrayList<Connection>();
        HColor colorBar = this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityBar);
        FtileBlackBlock black = new FtileBlackBlock(this.skinParam(), colorBar, ((Ftile)this.list99.get(0)).getSwimlaneIn());
        double x = 0.0;
        for (Ftile tmp : this.list99) {
            Rainbow def;
            FtileGeometry dim = tmp.calculateDimension(this.getStringBounder());
            if (UseStyle.useBetaStyle()) {
                Style style = this.getDefaultStyleDefinition().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
                def = Rainbow.build(style, this.skinParam().getIHtmlColorSet());
            } else {
                def = Rainbow.build(this.skinParam());
            }
            Rainbow rainbow = tmp.getInLinkRendering().getRainbow(def);
            conns.add(new ConnectionIn(black, tmp, x, rainbow));
            x += ((Dimension2D)dim).getWidth();
        }
        result = FtileUtils.addConnection(result, conns);
        black.setBlackBlockDimension(result.calculateDimension(this.getStringBounder()).getWidth(), 6.0);
        return new FtileAssemblySimple(black, result);
    }

    @Override
    protected Ftile doStep2(Ftile inner, Ftile result) {
        HColor borderColor = this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBorder);
        HColor backColor = this.getRose().getHtmlColor(this.skinParam(), ColorParam.activityDiamondBackground);
        FtileDiamond out = new FtileDiamond(this.skinParam(), backColor, borderColor, this.swimlaneOutForStep2());
        result = new FtileAssemblySimple(result, out);
        ArrayList<Connection> conns = new ArrayList<Connection>();
        UTranslate diamondTranslate = result.getTranslateFor(out, this.getStringBounder());
        int i = 0;
        double x = 0.0;
        for (Ftile tmp : this.list99) {
            Rainbow def;
            FtileGeometry dim = tmp.calculateDimension(this.getStringBounder());
            UTranslate translate0 = new UTranslate(x, 6.0);
            if (UseStyle.useBetaStyle()) {
                Style style = this.getDefaultStyleDefinition().getMergedStyle(this.skinParam().getCurrentStyleBuilder());
                def = Rainbow.build(style, this.skinParam().getIHtmlColorSet());
            } else {
                def = Rainbow.build(this.skinParam());
            }
            Rainbow rainbow = tmp.getOutLinkRendering().getRainbow(def);
            conns.add(new ConnectionHorizontalThenVertical(tmp, out, rainbow, translate0, diamondTranslate, i));
            x += ((Dimension2D)dim).getWidth();
            ++i;
        }
        return FtileUtils.addConnection(result, conns);
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final double x;
        private final Rainbow arrowColor;
        private final Display label;

        public ConnectionIn(Ftile ftile1, Ftile ftile2, double x, Rainbow arrowColor) {
            super(ftile1, ftile2);
            this.label = ftile2.getInLinkRendering().getDisplay();
            this.x = x;
            this.arrowColor = arrowColor;
        }

        @Override
        public void drawU(UGraphic ug) {
            ug = ug.apply(UTranslate.dx(this.x));
            FtileGeometry geo = this.getFtile2().calculateDimension(ParallelBuilderMerge.this.getStringBounder());
            Snake snake = Snake.create(this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake = snake.withLabel(ParallelBuilderMerge.this.getTextBlock(this.label), this.arrowHorizontalAlignment());
            }
            snake.addPoint(geo.getLeft(), 0.0);
            snake.addPoint(geo.getLeft(), geo.getInY());
            ug.draw(snake);
        }

        @Override
        public void drawTranslate(UGraphic ug, UTranslate translate1, UTranslate translate2) {
            ug = ug.apply(UTranslate.dx(this.x));
            FtileGeometry geo = this.getFtile2().calculateDimension(ParallelBuilderMerge.this.getStringBounder());
            Point2D.Double p1 = new Point2D.Double(geo.getLeft(), 0.0);
            Point2D.Double p2 = new Point2D.Double(geo.getLeft(), geo.getInY());
            Snake snake = Snake.create(this.arrowColor, Arrows.asToDown());
            if (!Display.isNull(this.label)) {
                snake = snake.withLabel(ParallelBuilderMerge.this.getTextBlock(this.label), this.arrowHorizontalAlignment());
            }
            Point2D mp1a = translate1.getTranslated(p1);
            Point2D mp2b = translate2.getTranslated(p2);
            double middle = mp1a.getY() + 4.0;
            snake.addPoint(mp1a);
            snake.addPoint(mp1a.getX(), middle);
            snake.addPoint(mp2b.getX(), middle);
            snake.addPoint(mp2b);
            ug.draw(snake);
        }
    }

    class ConnectionHorizontalThenVertical
    extends AbstractConnection {
        private final Rainbow arrowColor;
        private final UTranslate diamondTranslate;
        private final UTranslate translate0;
        private final int counter;

        public ConnectionHorizontalThenVertical(Ftile tile, Ftile diamond, Rainbow arrowColor, UTranslate translate0, UTranslate diamondTranslate, int counter) {
            super(tile, diamond);
            this.arrowColor = arrowColor;
            this.diamondTranslate = diamondTranslate;
            this.translate0 = translate0;
            this.counter = counter;
        }

        @Override
        public void drawU(UGraphic ug) {
            StringBounder stringBounder = ug.getStringBounder();
            Point2D p1 = this.getP1(stringBounder);
            Point2D p2 = this.getP2(stringBounder);
            double x1 = p1.getX();
            double y1 = p1.getY();
            double x2 = p2.getX();
            double y2 = p2.getY();
            UPolygon endDecoration = null;
            if (this.counter == 0) {
                endDecoration = Arrows.asToRight();
            } else if (this.counter == 1) {
                endDecoration = Arrows.asToLeft();
            }
            Snake snake = Snake.create(this.arrowColor, endDecoration);
            snake.addPoint(x1, y1);
            snake.addPoint(x1, y2);
            snake.addPoint(x2, y2);
            ug.draw(snake);
        }

        private Point2D getP1(StringBounder stringBounder) {
            return this.translate0.getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            Point2D result = this.diamondTranslate.getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointOut());
            FtileGeometry dim = this.getFtile2().calculateDimension(stringBounder);
            UTranslate arrival = new UTranslate();
            if (this.counter == 0) {
                arrival = new UTranslate(-((Dimension2D)dim).getWidth() / 2.0, -((Dimension2D)dim).getHeight() / 2.0);
            } else if (this.counter == 1) {
                arrival = new UTranslate(((Dimension2D)dim).getWidth() / 2.0, -((Dimension2D)dim).getHeight() / 2.0);
            }
            return arrival.getTranslated(result);
        }
    }
}

