/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineSimple;
import net.sourceforge.plantuml.preproc.StartDiagramExtractReader;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.tim.EaterException;

public class PreprocessorUtils {
    public static String withEnvironmentVariable(String s) {
        Pattern p = Pattern.compile("%(\\w+)%");
        Matcher m = p.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            String value = PreprocessorUtils.getenv(var);
            if (value == null) continue;
            m.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        m.appendTail(sb);
        s = sb.toString();
        return s;
    }

    public static String getenv(String var) {
        String env = System.getProperty(var);
        if (StringUtils.isNotEmpty(env)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(env);
        }
        String getenv = System.getenv(var);
        if (StringUtils.isNotEmpty(getenv)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(getenv);
        }
        return null;
    }

    private static InputStream getStdlibInputStream(String filename) {
        InputStream result = Stdlib.getResourceAsStream(filename);
        return result;
    }

    public static ReadLine getReaderStdlibInclude(StringLocated s, String filename) {
        Log.info("Loading sdlib " + filename);
        InputStream is = PreprocessorUtils.getStdlibInputStream(filename);
        if (is == null) {
            return null;
        }
        String description = "<" + filename + ">";
        try {
            if (StartDiagramExtractReader.containsStartDiagram(is, s, description)) {
                is = PreprocessorUtils.getStdlibInputStream(filename);
                return StartDiagramExtractReader.build(is, s, description);
            }
            is = PreprocessorUtils.getStdlibInputStream(filename);
            if (is == null) {
                return null;
            }
            return ReadLineReader.create(new InputStreamReader(is), description);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ReadLineSimple(s, e.toString());
        }
    }

    public static ReadLine getReaderIncludeUrl2(SURL url, StringLocated s, String suf, String charset) throws EaterException {
        try {
            if (StartDiagramExtractReader.containsStartDiagram(url, s, charset)) {
                return StartDiagramExtractReader.build(url, s, suf, charset);
            }
            InputStream is = url.openStream();
            if (is == null) {
                throw EaterException.located("Cannot open URL");
            }
            if (charset == null) {
                Log.info("Using default charset");
                return ReadLineReader.create(new InputStreamReader(is), url.toString(), s.getLocation());
            }
            Log.info("Using charset " + charset);
            return ReadLineReader.create(new InputStreamReader(is, charset), url.toString(), s.getLocation());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw EaterException.located("Cannot open URL " + e.getMessage());
        }
    }
}

