/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.net;

import cc.arduino.net.PACSupportMethods;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.stream.Stream;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.compress.utils.IOUtils;

public class CustomProxySelector {
    private final Map<String, String> preferences;

    public CustomProxySelector(Map<String, String> preferences) {
        this.preferences = preferences;
        this.clearPreviousAuthenticator();
    }

    public Proxy getProxyFor(URI uri) throws IOException, ScriptException, NoSuchMethodException {
        String proxyType = this.preferences.get("proxy.type");
        if (proxyType == null || proxyType.isEmpty()) {
            proxyType = "auto";
        }
        if ("none".equals(proxyType)) {
            return Proxy.NO_PROXY;
        }
        if ("auto".equals(proxyType)) {
            String pac = this.preferences.get("proxy.pac.url");
            if (pac == null || pac.isEmpty()) {
                return ProxySelector.getDefault().select(uri).get(0);
            }
            return this.pacProxy(pac, uri);
        }
        if ("manual".equals(proxyType)) {
            return this.manualProxy();
        }
        throw new IllegalStateException("Unable to understand proxy settings");
    }

    private Proxy pacProxy(String pac, URI uri) throws IOException, ScriptException, NoSuchMethodException {
        int responseCode;
        this.setAuthenticator(this.preferences.get("proxy.manual.username"), this.preferences.get("proxy.manual.password"));
        URLConnection urlConnection = new URL(pac).openConnection();
        urlConnection.connect();
        if (urlConnection instanceof HttpURLConnection && (responseCode = ((HttpURLConnection)urlConnection).getResponseCode()) != 200) {
            throw new IOException("Unable to fetch PAC file at " + pac + ". Response code is " + responseCode);
        }
        String pacScript = new String(IOUtils.toByteArray((InputStream)urlConnection.getInputStream()), Charset.forName("ASCII"));
        ScriptEngine nashorn = new ScriptEngineManager().getEngineByName("nashorn");
        nashorn.getBindings(100).put("pac", (Object)new PACSupportMethods());
        Stream.of("isPlainHostName(host)", "dnsDomainIs(host, domain)", "localHostOrDomainIs(host, hostdom)", "isResolvable(host)", "isInNet(host, pattern, mask)", "dnsResolve(host)", "myIpAddress()", "dnsDomainLevels(host)", "shExpMatch(str, shexp)").forEach(fn -> {
            try {
                nashorn.eval("function " + fn + " { return pac." + fn + "; }");
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
        });
        nashorn.eval(pacScript);
        String proxyConfigs = this.callFindProxyForURL(uri, nashorn);
        return this.makeProxyFrom(proxyConfigs);
    }

    private String callFindProxyForURL(URI uri, ScriptEngine nashorn) throws ScriptException, NoSuchMethodException {
        Invocable script = (Invocable)((Object)nashorn);
        URL url = this.toUrl(uri);
        return (String)script.invokeFunction("FindProxyForURL", url.toExternalForm(), url.getHost());
    }

    private Proxy makeProxyFrom(String proxyConfigs) {
        Proxy.Type type;
        String proxyConfig = proxyConfigs.split(";")[0];
        if (proxyConfig.startsWith("DIRECT")) {
            return Proxy.NO_PROXY;
        }
        if (proxyConfig.startsWith("PROXY")) {
            type = Proxy.Type.HTTP;
            proxyConfig = proxyConfig.replace("PROXY ", "");
        } else {
            type = Proxy.Type.SOCKS;
            proxyConfig = proxyConfig.replace("SOCKS ", "");
        }
        String[] hostPort = proxyConfig.split(":");
        return new Proxy(type, new InetSocketAddress(hostPort[0], (int)Integer.valueOf(hostPort[1])));
    }

    private URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private Proxy manualProxy() {
        this.setAuthenticator(this.preferences.get("proxy.manual.username"), this.preferences.get("proxy.manual.password"));
        Proxy.Type type = Proxy.Type.valueOf(this.preferences.get("proxy.manual.type"));
        return new Proxy(type, new InetSocketAddress(this.preferences.get("proxy.manual.hostname"), (int)Integer.valueOf(this.preferences.get("proxy.manual.port"))));
    }

    private void clearPreviousAuthenticator() {
        Authenticator.setDefault(null);
    }

    private void setAuthenticator(final String username, String password) {
        if (username == null || username.isEmpty()) {
            return;
        }
        final String actualPassword = password == null ? "" : password;
        Authenticator.setDefault(new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, actualPassword.toCharArray());
            }
        });
    }
}

