/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.swing.JFrame;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.jedit.JEditActionSet;
import org.gjt.sp.jedit.JEditBeanShellAction;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.buffer.DefaultFoldHandlerProvider;
import org.gjt.sp.jedit.buffer.DummyFoldHandler;
import org.gjt.sp.jedit.buffer.ExplicitFoldHandler;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.jedit.datatransfer.RichJEditTextTransferableService;
import org.gjt.sp.jedit.datatransfer.StringTransferableService;
import org.gjt.sp.jedit.datatransfer.TransferHandler;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.textarea.AntiAlias;
import org.gjt.sp.jedit.textarea.Gutter;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.SyntaxUtilities;

public class StandaloneTextArea
extends TextArea {
    private final IPropertyManager propertyManager;

    public StandaloneTextArea(IPropertyManager iPropertyManager) {
        super(iPropertyManager, null);
        this.propertyManager = iPropertyManager;
        this.initInputHandler();
        this.setMouseHandler(new TextAreaMouseHandler(this));
        StandaloneActionSet standaloneActionSet = new StandaloneActionSet(iPropertyManager, this, TextArea.class.getResource("textarea.actions.xml"));
        this.addActionSet(standaloneActionSet);
        standaloneActionSet.load();
        standaloneActionSet.initKeyBindings();
        if (SyntaxUtilities.propertyManager == null) {
            SyntaxUtilities.propertyManager = iPropertyManager;
        }
        this.initTextArea();
        DefaultFoldHandlerProvider defaultFoldHandlerProvider = new DefaultFoldHandlerProvider();
        FoldHandler.foldHandlerProvider = defaultFoldHandlerProvider;
        defaultFoldHandlerProvider.addFoldHandler(new ExplicitFoldHandler());
        defaultFoldHandlerProvider.addFoldHandler(new IndentFoldHandler());
        defaultFoldHandlerProvider.addFoldHandler(new DummyFoldHandler());
        JEditBuffer jEditBuffer = new JEditBuffer();
        TokenMarker tokenMarker = new TokenMarker();
        tokenMarker.addRuleSet(new ParserRuleSet("text", "MAIN"));
        jEditBuffer.setTokenMarker(tokenMarker);
        this.setBuffer(jEditBuffer);
        String string = iPropertyManager.getProperty("buffer.undoCount");
        int n = 100;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.buffer.setUndoLimit(n);
        Mode mode = new Mode("text");
        mode.setTokenMarker(tokenMarker);
        ModeProvider.instance.addMode(mode);
        KillRing.setInstance(new KillRing());
        KillRing.getInstance().propertiesChanged(100);
    }

    private void initTextArea() {
        this.initPainter();
        this.initGutter();
        this.setCaretBlinkEnabled(this.getBooleanProperty("view.caretBlink"));
        this.setElectricScroll(this.getIntegerProperty("view.electricBorders", 0));
        if (this.buffer == null) {
            return;
        }
        String string = this.propertyManager.getProperty("buffer.undoCount");
        int n = 100;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.buffer.setUndoLimit(n);
    }

    private void initGutter() {
        Gutter gutter = this.getGutter();
        gutter.setExpanded(this.getBooleanProperty("view.gutter.lineNumbers"));
        int n = this.getIntegerProperty("view.gutter.highlightInterval", 5);
        gutter.setHighlightInterval(n);
        gutter.setCurrentLineHighlightEnabled(this.getBooleanProperty("view.gutter.highlightCurrentLine"));
        gutter.setStructureHighlightEnabled(this.getBooleanProperty("view.gutter.structureHighlight"));
        gutter.setStructureHighlightColor(this.getColorProperty("view.gutter.structureHighlightColor"));
        gutter.setBackground(this.getColorProperty("view.gutter.bgColor"));
        gutter.setForeground(this.getColorProperty("view.gutter.fgColor"));
        gutter.setHighlightedForeground(this.getColorProperty("view.gutter.highlightColor"));
        gutter.setFoldColor(this.getColorProperty("view.gutter.foldColor"));
        gutter.setCurrentLineForeground(this.getColorProperty("view.gutter.currentLineColor"));
        String string = this.getProperty("view.gutter.numberAlignment");
        if ("right".equals(string)) {
            gutter.setLineNumberAlignment(4);
        } else if ("center".equals(string)) {
            gutter.setLineNumberAlignment(0);
        } else {
            gutter.setLineNumberAlignment(2);
        }
        gutter.setFont(this.getFontProperty("view.gutter.font"));
        int n2 = this.getIntegerProperty("view.gutter.borderWidth", 3);
        gutter.setBorder(n2, this.getColorProperty("view.gutter.focusBorderColor"), this.getColorProperty("view.gutter.noFocusBorderColor"), this.painter.getBackground());
    }

    private void initPainter() {
        TextAreaPainter textAreaPainter = this.getPainter();
        textAreaPainter.setBlockCaretEnabled(false);
        textAreaPainter.setFont(this.getFontProperty("view.font"));
        textAreaPainter.setStructureHighlightEnabled(this.getBooleanProperty("view.structureHighlight"));
        textAreaPainter.setStructureHighlightColor(this.getColorProperty("view.structureHighlightColor"));
        textAreaPainter.setEOLMarkersPainted(this.getBooleanProperty("view.eolMarkers"));
        String string = this.getProperty("view.eolMarkerChar");
        if (!string.isEmpty()) {
            textAreaPainter.setEOLMarkerChar(string);
        }
        textAreaPainter.setEOLMarkerColor(this.getColorProperty("view.eolMarkerColor"));
        textAreaPainter.setWrapGuidePainted(this.getBooleanProperty("view.wrapGuide"));
        textAreaPainter.setWrapGuideColor(this.getColorProperty("view.wrapGuideColor"));
        textAreaPainter.setCaretColor(this.getColorProperty("view.caretColor"));
        textAreaPainter.setSelectionColor(this.getColorProperty("view.selectionColor"));
        textAreaPainter.setMultipleSelectionColor(this.getColorProperty("view.multipleSelectionColor"));
        textAreaPainter.setBackground(this.getColorProperty("view.bgColor"));
        textAreaPainter.setForeground(this.getColorProperty("view.fgColor"));
        textAreaPainter.setBlockCaretEnabled(this.getBooleanProperty("view.blockCaret"));
        textAreaPainter.setThickCaretEnabled(this.getBooleanProperty("view.thickCaret"));
        textAreaPainter.setLineHighlightEnabled(this.getBooleanProperty("view.lineHighlight"));
        textAreaPainter.setLineHighlightColor(this.getColorProperty("view.lineHighlightColor"));
        textAreaPainter.setAntiAlias(new AntiAlias(this.getProperty("view.antiAlias")));
        textAreaPainter.setFractionalFontMetricsEnabled(this.getBooleanProperty("view.fracFontMetrics"));
        textAreaPainter.setSelectionFgColor(this.getColorProperty("view.selectionFgColor"));
        textAreaPainter.setSelectionFgColorEnabled(this.getBooleanProperty("view.selectionFg"));
        String string2 = this.getProperty("view.font");
        int n = this.getIntegerProperty("view.fontsize", 12);
        textAreaPainter.setStyles(SyntaxUtilities.loadStyles(string2, n));
        SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[4];
        for (int i = 0; i <= 3; ++i) {
            syntaxStyleArray[i] = SyntaxUtilities.parseStyle(this.getProperty("view.style.foldLine." + i), string2, n, true);
        }
        textAreaPainter.setFoldLineStyle(syntaxStyleArray);
    }

    public String getProperty(String string) {
        return this.propertyManager.getProperty(string);
    }

    private boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, false);
    }

    private boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if ("true".equals(string2) || "yes".equals(string2) || "on".equals(string2)) {
            return true;
        }
        if ("false".equals(string2) || "no".equals(string2) || "off".equals(string2)) {
            return false;
        }
        return bl;
    }

    private int getIntegerProperty(String string, int n) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private Font getFontProperty(String string) {
        return this.getFontProperty(string, null);
    }

    private Font getFontProperty(String string, Font font) {
        int n;
        int n2;
        String string2 = this.getProperty(string);
        String string3 = this.getProperty(string + "size");
        String string4 = this.getProperty(string + "style");
        if (string2 == null || string3 == null || string4 == null) {
            return font;
        }
        try {
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return font;
        }
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            return font;
        }
        return new Font(string2, n, n2);
    }

    private Color getColorProperty(String string) {
        return this.getColorProperty(string, Color.black);
    }

    private Color getColorProperty(String string, Color color) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return color;
        }
        return SyntaxUtilities.parseColor(string2, color);
    }

    @Override
    public void propertiesChanged() {
        JEditActionSet[] jEditActionSetArray;
        this.getInputHandler().removeAllKeyBindings();
        for (JEditActionSet jEditActionSet : jEditActionSetArray = this.getActionContext().getActionSets()) {
            jEditActionSet.initKeyBindings();
        }
        Chunk.propertiesChanged(this.propertyManager);
        this.initBuffer();
        this.initTextArea();
        super.propertiesChanged();
    }

    private void initBuffer() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"lineSeparator", "encodingAutodetect", "tabSize", "indentSize", "noTabs", "defaultMode", "undoCount", "wrap", "maxLineLen", "wordBreakChars", "noWordSep", "camelCasedWords", "folding", "collapseFolds"}) {
            String string2 = this.getProperty("buffer." + string);
            if (string2 == null) {
                this.buffer.unsetProperty(string);
                continue;
            }
            this.buffer.setProperty(string, string2);
        }
        this.buffer.propertiesChanged();
    }

    public static StandaloneTextArea createTextArea() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)StandaloneTextArea.loadProperties("/keymaps/jEdit_keys.props"));
        properties.putAll((Map<?, ?>)StandaloneTextArea.loadProperties("/org/gjt/sp/jedit/jedit.props"));
        StandaloneTextArea standaloneTextArea = new StandaloneTextArea(properties::getProperty);
        standaloneTextArea.getBuffer().setProperty("folding", "explicit");
        return standaloneTextArea;
    }

    private static Properties loadProperties(String string) {
        Properties properties = new Properties();
        File file = string.charAt(0) == '/' ? new File(string.substring(1)) : new File(string);
        try (InputStream inputStream = file.isFile() ? new FileInputStream(file) : TextArea.class.getResourceAsStream(string);){
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            Log.log(9, TextArea.class, iOException);
        }
        return properties;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        StandaloneTextArea standaloneTextArea = StandaloneTextArea.createTextArea();
        Mode mode = new Mode("xml");
        mode.setProperty("file", "modes/xml.xml");
        ModeProvider.instance.addMode(mode);
        standaloneTextArea.getBuffer().setMode(mode);
        jFrame.getContentPane().add(standaloneTextArea);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static {
        TransferHandler.getInstance().registerTransferableService(new RichJEditTextTransferableService());
        TransferHandler.getInstance().registerTransferableService(new StringTransferableService());
    }

    public static class StandaloneActionSet
    extends JEditActionSet<JEditBeanShellAction> {
        private final IPropertyManager iPropertyManager;
        private final TextArea textArea;

        public StandaloneActionSet(IPropertyManager iPropertyManager, TextArea textArea, URL uRL) {
            super(null, uRL);
            this.iPropertyManager = iPropertyManager;
            this.textArea = textArea;
        }

        protected JEditBeanShellAction[] getArray(int n) {
            return new JEditBeanShellAction[n];
        }

        @Override
        protected String getProperty(String string) {
            return this.iPropertyManager.getProperty(string);
        }

        @Override
        public AbstractInputHandler getInputHandler() {
            return this.textArea.getInputHandler();
        }

        @Override
        protected JEditBeanShellAction createBeanShellAction(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
            return new JEditBeanShellAction(string, string2, string3, bl, bl2, bl3);
        }
    }
}

