/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.lang.ClassLoadingLocks;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.Resource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlClassLoader
extends ClassLoader {
    private static final Set<Class<?>> ourParallelCapableLoaders;
    private static final boolean ourClassPathIndexEnabled;
    private final List<URL> myURLs;
    private final ClassPath myClassPath;
    private final ClassLoadingLocks myClassLoadingLocks;
    private final boolean myAllowBootstrapResources;
    private static final ThreadLocal<Boolean> ourSkipFindingResource;

    @NotNull
    protected ClassPath getClassPath() {
        ClassPath classPath2 = this.myClassPath;
        if (classPath2 == null) {
            UrlClassLoader.$$$reportNull$$$0(3);
        }
        return classPath2;
    }

    @Nullable
    public static URL internProtocol(@NotNull URL url) {
        String host;
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(9);
        }
        String protocol = url.getProtocol();
        boolean interned = false;
        if ("file".equals(protocol) || "jar".equals(protocol)) {
            protocol = protocol.intern();
            interned = true;
        }
        if ((host = url.getHost()) != null && host.isEmpty()) {
            host = "";
            interned = true;
        }
        try {
            if (interned) {
                url = new URL(protocol, host, url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            LoggerRt.getInstance(UrlClassLoader.class).error(e);
            return null;
        }
    }

    @NotNull
    public List<URL> getUrls() {
        List<URL> list2 = Collections.unmodifiableList(this.myURLs);
        if (list2 == null) {
            UrlClassLoader.$$$reportNull$$$0(11);
        }
        return list2;
    }

    public boolean hasLoadedClass(String name) {
        Class<?> aClass2 = this.findLoadedClass(name);
        return aClass2 != null && aClass2.getClassLoader() == this;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this._findClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    @Nullable
    protected final Class<?> _findClass(@NotNull String name) {
        Resource res2;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(12);
        }
        if ((res2 = this.getClassPath().getResource(name.replace('.', '/') + ".class")) == null) {
            return null;
        }
        try {
            return this.defineClass(name, res2);
        }
        catch (IOException e) {
            LoggerRt.getInstance(UrlClassLoader.class).error(e);
            return null;
        }
    }

    private Class<?> defineClass(@NotNull String name, @NotNull Resource res2) throws IOException {
        String pkgName;
        Package pkg;
        int i;
        if (name == null) {
            UrlClassLoader.$$$reportNull$$$0(13);
        }
        if (res2 == null) {
            UrlClassLoader.$$$reportNull$$$0(14);
        }
        if ((i = name.lastIndexOf(46)) != -1 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
            try {
                this.definePackage(pkgName, res2.getValue(Resource.Attribute.SPEC_TITLE), res2.getValue(Resource.Attribute.SPEC_VERSION), res2.getValue(Resource.Attribute.SPEC_VENDOR), res2.getValue(Resource.Attribute.IMPL_TITLE), res2.getValue(Resource.Attribute.IMPL_VERSION), res2.getValue(Resource.Attribute.IMPL_VENDOR), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        byte[] b = res2.getBytes();
        ProtectionDomain protectionDomain = res2.getProtectionDomain();
        if (protectionDomain != null) {
            return this._defineClass(name, b, protectionDomain);
        }
        protectionDomain = this.getProtectionDomain(res2.getURL());
        if (protectionDomain != null) {
            return this._defineClass(name, b, protectionDomain);
        }
        return this._defineClass(name, b);
    }

    protected ProtectionDomain getProtectionDomain(URL url) {
        return null;
    }

    protected Class<?> _defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    protected Class<?> _defineClass(String name, byte[] b, @Nullable ProtectionDomain protectionDomain) {
        return this.defineClass(name, b, 0, b.length, protectionDomain);
    }

    @Override
    public URL findResource(String name) {
        if (ourSkipFindingResource.get() != null) {
            return null;
        }
        Resource res2 = this.findResourceImpl(name);
        return res2 != null ? res2.getURL() : null;
    }

    @Nullable
    private Resource findResourceImpl(String name) {
        String n = FileUtilRt.toCanonicalPath(name, '/', false);
        Resource resource = this.getClassPath().getResource(n);
        if (resource == null && n.startsWith("/")) {
            resource = this.getClassPath().getResource(n.substring(1));
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InputStream getResourceAsStream(String name) {
        if (this.myAllowBootstrapResources) {
            ourSkipFindingResource.set(Boolean.TRUE);
            try {
                InputStream stream = super.getResourceAsStream(name);
                if (stream != null) {
                    InputStream inputStream = stream;
                    return inputStream;
                }
            }
            finally {
                ourSkipFindingResource.set(null);
            }
        }
        try {
            Resource res2 = this.findResourceImpl(name);
            return res2 != null ? res2.getInputStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.getClassPath().getResources(name);
    }

    @Override
    @NotNull
    protected Object getClassLoadingLock(String className2) {
        Object object = this.myClassLoadingLocks != null ? this.myClassLoadingLocks.getOrCreateLock(className2) : this;
        if (object == null) {
            UrlClassLoader.$$$reportNull$$$0(15);
        }
        return object;
    }

    static {
        boolean capable;
        boolean isAtLeastJava7 = !System.getProperty("java.runtime.version", "unknown").startsWith("1.6.");
        boolean ibmJvm = System.getProperty("java.vm.vendor", "unknown").toLowerCase(Locale.ENGLISH).contains("ibm");
        boolean bl = capable = isAtLeastJava7 && !ibmJvm && Boolean.parseBoolean(System.getProperty("use.parallel.class.loading", "true"));
        if (capable) {
            ourParallelCapableLoaders = Collections.synchronizedSet(new HashSet());
            try {
                Method registerAsParallelCapable = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                registerAsParallelCapable.setAccessible(true);
                if (Boolean.TRUE.equals(registerAsParallelCapable.invoke(null, new Object[0]))) {
                    ourParallelCapableLoaders.add(UrlClassLoader.class);
                }
            }
            catch (Exception exception) {}
        } else {
            ourParallelCapableLoaders = null;
        }
        ourClassPathIndexEnabled = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
        ourSkipFindingResource = new ThreadLocal();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaderClass";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrls";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarAccessLog";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoadingLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "markParallelCapable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUrlNeedsProtectionDomain";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendToClassPathForInstrumentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 15: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createClassPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "internProtocol";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "_findClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "defineClass";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface CachingCondition {
        public boolean shouldCacheData(@NotNull URL var1);
    }
}

