/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.json.serialize.local;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.json.serialize.JsonSerializer;

public class LocalJsonSerializer
implements JsonSerializer {
    protected ConverterManager converterManager = null;
    private static final Log log = LogFactory.getLog(LocalJsonSerializer.class);

    @Override
    public void toJson(Object data, Writer out) throws IOException {
        try {
            ScriptBuffer buffer = new ScriptBuffer();
            buffer.appendData(data);
            String output = ScriptBufferUtil.createOutput(buffer, this.converterManager, true);
            out.write(output);
        }
        catch (ConversionException ex) {
            log.warn((Object)("--ConversionException: class=" + ex.getConversionType().getName()), (Throwable)ex);
            ScriptBuffer buffer = new ScriptBuffer();
            buffer.appendData(ex);
            try {
                String output = ScriptBufferUtil.createOutput(buffer, this.converterManager, true);
                out.write(output);
            }
            catch (ConversionException ex1) {
                log.error((Object)("--Nested ConversionException: Is there an exception handler registered? class=" + ex.getConversionType().getName()), (Throwable)ex);
            }
        }
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }
}

