/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.ImageSelection;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.security.ImageIO;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.swing.ImageHelper;
import net.sourceforge.plantuml.swing.MainWindow2;
import net.sourceforge.plantuml.swing.ScrollablePicture;
import net.sourceforge.plantuml.swing.SimpleLine2;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.version.PSystemVersion;

class ImageWindow2
extends JFrame {
    private static final Preferences prefs = Preferences.userNodeForPackage(ImageWindow2.class);
    private static final String KEY_ZOOM_FIT = "zoomfit";
    private static final String KEY_WIDTH_FIT = "widthfit";
    private SimpleLine2 simpleLine2;
    private final JScrollPane scrollPane;
    private final JButton next = new JButton("Next");
    private final JButton copy = new JButton("Copy");
    private final JButton previous = new JButton("Previous");
    private final JCheckBox zoomFitButt = new JCheckBox("Zoom fit");
    private final JCheckBox widthFitButt = new JCheckBox("Width fit");
    private final JButton zoomMore = new JButton("+");
    private final JButton zoomLess = new JButton("-");
    private final MainWindow2 main;
    private final ListModel listModel;
    private int index;
    private int zoomFactor = 0;
    private SizeMode sizeMode = SizeMode.FULL_SIZE;
    private int startX;
    private int startY;
    private int v1;
    private int v2;

    public ImageWindow2(SimpleLine2 simpleLine, final MainWindow2 main, ListModel listModel, int index) {
        super(simpleLine.toString());
        this.setIconImage(PSystemVersion.getPlantumlSmallIcon2());
        this.simpleLine2 = simpleLine;
        this.listModel = listModel;
        this.index = index;
        this.main = main;
        JPanel north = new JPanel();
        north.add(this.previous);
        north.add(this.copy);
        north.add(this.next);
        north.add(this.zoomFitButt);
        north.add(this.widthFitButt);
        north.add(this.zoomMore);
        north.add(this.zoomLess);
        this.copy.setFocusable(false);
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageWindow2.this.copy();
            }
        });
        this.next.setFocusable(false);
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageWindow2.this.next();
            }
        });
        this.previous.setFocusable(false);
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageWindow2.this.previous();
            }
        });
        this.zoomFitButt.setFocusable(false);
        this.zoomFitButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageWindow2.this.widthFitButt.setSelected(false);
                ImageWindow2.this.zoomFit();
            }
        });
        this.widthFitButt.setFocusable(false);
        this.widthFitButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageWindow2.this.zoomFitButt.setSelected(false);
                ImageWindow2.this.zoomFit();
            }
        });
        this.zoomMore.setFocusable(false);
        this.zoomMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageWindow2.this.zoomFactor++;
                ImageWindow2.this.refreshImage(false);
            }
        });
        this.zoomLess.setFocusable(false);
        this.zoomLess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageWindow2.this.zoomFactor--;
                ImageWindow2.this.refreshImage(false);
            }
        });
        this.scrollPane = new JScrollPane(this.buildScrollablePicture());
        this.getContentPane().add((Component)north, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setSize(640, 400);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                main.closing(ImageWindow2.this);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                ImageWindow2.this.refreshImage(false);
            }
        });
        boolean zoomChecked = prefs.getBoolean(KEY_ZOOM_FIT, false);
        this.zoomFitButt.setSelected(zoomChecked);
        if (zoomChecked) {
            this.sizeMode = SizeMode.ZOOM_FIT;
        }
        boolean widthZoomChecked = prefs.getBoolean(KEY_WIDTH_FIT, false);
        this.widthFitButt.setSelected(widthZoomChecked);
        if (widthZoomChecked) {
            this.sizeMode = SizeMode.WIDTH_FIT;
        }
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.isControlDown() && evt.getKeyCode() == 39) {
                    ImageWindow2.this.next();
                } else if (evt.isControlDown() && evt.getKeyCode() == 37) {
                    ImageWindow2.this.previous();
                } else if (evt.isAltDown() && evt.getKeyCode() == 39) {
                    ImageWindow2.this.next();
                } else if (evt.isAltDown() && evt.getKeyCode() == 37) {
                    ImageWindow2.this.previous();
                } else if (evt.getKeyCode() == 39) {
                    ImageWindow2.this.imageRight();
                } else if (evt.getKeyCode() == 37) {
                    ImageWindow2.this.imageLeft();
                } else if (evt.getKeyCode() == 40) {
                    ImageWindow2.this.imageDown();
                } else if (evt.getKeyCode() == 38) {
                    ImageWindow2.this.imageUp();
                } else if (evt.getKeyCode() == 67) {
                    ImageWindow2.this.copy();
                } else if (evt.getKeyCode() == 90) {
                    ImageWindow2.this.zoomFitButt.setSelected(!ImageWindow2.this.zoomFitButt.isSelected());
                    ImageWindow2.this.zoomFit();
                }
            }
        });
    }

    private void next() {
        ++this.index;
        this.updateSimpleLine();
    }

    private void previous() {
        --this.index;
        this.updateSimpleLine();
    }

    private void imageDown() {
        JScrollBar bar = this.scrollPane.getVerticalScrollBar();
        bar.setValue(bar.getValue() + bar.getBlockIncrement());
    }

    private void imageUp() {
        JScrollBar bar = this.scrollPane.getVerticalScrollBar();
        bar.setValue(bar.getValue() - bar.getBlockIncrement());
    }

    private void imageLeft() {
        JScrollBar bar = this.scrollPane.getHorizontalScrollBar();
        bar.setValue(bar.getValue() - bar.getBlockIncrement());
    }

    private void imageRight() {
        JScrollBar bar = this.scrollPane.getHorizontalScrollBar();
        bar.setValue(bar.getValue() + bar.getBlockIncrement());
    }

    private void zoomFit() {
        boolean selectedZoom = this.zoomFitButt.isSelected();
        boolean selectedWidth = this.widthFitButt.isSelected();
        prefs.putBoolean(KEY_ZOOM_FIT, selectedZoom);
        prefs.putBoolean(KEY_WIDTH_FIT, selectedWidth);
        this.zoomFactor = 0;
        this.sizeMode = selectedZoom ? SizeMode.ZOOM_FIT : (selectedWidth ? SizeMode.WIDTH_FIT : SizeMode.FULL_SIZE);
        this.refreshImage(false);
    }

    private void updateSimpleLine() {
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index > this.listModel.getSize() - 1) {
            this.index = this.listModel.getSize() - 1;
        }
        this.simpleLine2 = (SimpleLine2)this.listModel.getElementAt(this.index);
        this.setTitle(this.simpleLine2.toString());
        this.refreshImage(false);
    }

    private void refreshSimpleLine() {
        for (SimpleLine2 line : this.main.getCurrentDirectoryListing2()) {
            if (!line.getFile().equals(this.simpleLine2.getFile())) continue;
            this.simpleLine2 = line;
            this.setTitle(this.simpleLine2.toString());
        }
    }

    private ScrollablePicture buildScrollablePicture() {
        GeneratedImage generatedImage = this.simpleLine2.getGeneratedImage();
        if (generatedImage == null) {
            return null;
        }
        File png = generatedImage.getPngFile();
        BufferedImage image = null;
        try {
            Dimension newImgDim;
            Dimension imageDim;
            image = ImageIO.read(new SFile(png.getAbsolutePath()));
            if (this.sizeMode == SizeMode.ZOOM_FIT) {
                imageDim = new Dimension(image.getWidth(), image.getHeight());
                newImgDim = ImageHelper.getScaledDimension(imageDim, this.scrollPane.getViewport().getSize());
                image = ImageHelper.getScaledInstance(image, newImgDim, this.getHints(), true);
            } else if (this.sizeMode == SizeMode.WIDTH_FIT) {
                imageDim = new Dimension(image.getWidth(), image.getHeight());
                newImgDim = ImageHelper.getScaledDimensionWidthFit(imageDim, this.scrollPane.getViewport().getSize());
                image = ImageHelper.getScaledInstance(image, newImgDim, this.getHints(), false);
            } else if (this.zoomFactor != 0) {
                imageDim = new Dimension(image.getWidth(), image.getHeight());
                newImgDim = ImageHelper.getScaledDimension(imageDim, this.getZoom());
                image = ImageHelper.getScaledInstance(image, newImgDim, this.getHints(), false);
            }
        }
        catch (IOException ex) {
            String msg = "Error reading file: " + ex.toString();
            IEntityImage error = GraphicStrings.createForError(Arrays.asList(msg), false);
            HColor backcolor = error.getBackcolor();
            ImageParameter imageParameter = new ImageParameter(new ColorMapperIdentity(), false, null, 1.0, null, null, ClockwiseTopRightBottomLeft.none(), backcolor);
            ImageBuilder imageBuilder = ImageBuilder.build(imageParameter);
            imageBuilder.setUDrawable(error);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                imageBuilder.writeImageTOBEMOVED(new FileFormatOption(FileFormat.PNG), 42L, baos);
                baos.close();
                image = ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ImageIcon imageIcon = new ImageIcon(image, this.simpleLine2.toString());
        ScrollablePicture scrollablePicture = new ScrollablePicture(imageIcon, 1);
        scrollablePicture.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                super.mousePressed(me);
                ImageWindow2.this.startX = me.getX();
                ImageWindow2.this.startY = me.getY();
            }
        });
        scrollablePicture.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                super.mouseDragged(me);
                int diffX = me.getX() - ImageWindow2.this.startX;
                int diffY = me.getY() - ImageWindow2.this.startY;
                JScrollBar hbar = ImageWindow2.this.scrollPane.getHorizontalScrollBar();
                hbar.setValue(hbar.getValue() - diffX);
                JScrollBar vbar = ImageWindow2.this.scrollPane.getVerticalScrollBar();
                vbar.setValue(vbar.getValue() - diffY);
            }
        });
        return scrollablePicture;
    }

    private RenderingHints getHints() {
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return hints;
    }

    private double getZoom() {
        return Math.pow(1.1, this.zoomFactor);
    }

    private void copy() {
        GeneratedImage generatedImage = this.simpleLine2.getGeneratedImage();
        if (generatedImage == null) {
            return;
        }
        File png = generatedImage.getPngFile();
        Image image = Toolkit.getDefaultToolkit().createImage(png.getAbsolutePath());
        ImageSelection imgSel = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imgSel, null);
    }

    public SimpleLine2 getSimpleLine() {
        return this.simpleLine2;
    }

    public void refreshImage(boolean external) {
        final JScrollBar bar1 = this.scrollPane.getVerticalScrollBar();
        final JScrollBar bar2 = this.scrollPane.getHorizontalScrollBar();
        if (external && !this.isError()) {
            this.v1 = bar1.getValue();
            this.v2 = bar2.getValue();
        }
        this.scrollPane.setViewportView(this.buildScrollablePicture());
        this.force();
        if (external) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageWindow2.this.refreshSimpleLine();
                    if (!ImageWindow2.this.isError()) {
                        bar1.setValue(ImageWindow2.this.v1);
                        bar2.setValue(ImageWindow2.this.v2);
                    }
                }
            });
        }
    }

    private boolean isError() {
        return this.simpleLine2.getGeneratedImage() != null && this.simpleLine2.getGeneratedImage().lineErrorRaw() != -1;
    }

    private void force() {
        this.repaint();
    }

    private static enum SizeMode {
        FULL_SIZE,
        ZOOM_FIT,
        WIDTH_FIT;

    }
}

