/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.general.actions;

import java.awt.Component;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.ui.utils.ColumnTitleValidator;
import org.gephi.ui.utils.SupportedColumnTypeWrapper;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class AddColumnUI
extends JPanel {
    private static final String COLUMN_TYPE_SAVED_PREFERENCES = "AddColumnUI_type";
    private Table table;
    private JButton okButton;
    private JLabel descriptionLabel;
    private JLabel titleLabel;
    private JTextField titleTextField;
    private JComboBox typeComboBox;
    private JLabel typeLabel;

    public AddColumnUI() {
        this.initComponents();
        this.titleTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddColumnUI.this.refreshOkButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddColumnUI.this.refreshOkButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AddColumnUI.this.refreshOkButton();
            }
        });
    }

    public void unSetup() {
        NbPreferences.forModule(AddColumnUI.class).putInt(COLUMN_TYPE_SAVED_PREFERENCES, this.typeComboBox.getSelectedIndex());
    }

    public String getDisplayName() {
        return NbBundle.getMessage(AddColumnUI.class, (String)"AddColumnUI.title");
    }

    public void setup(Mode mode) {
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel();
        switch (mode) {
            case NODES_TABLE: {
                this.descriptionLabel.setText(NbBundle.getMessage(AddColumnUI.class, (String)"AddColumnUI.descriptionLabel.text.nodes"));
                this.table = graphModel.getNodeTable();
                break;
            }
            case EDGES_TABLE: {
                this.descriptionLabel.setText(NbBundle.getMessage(AddColumnUI.class, (String)"AddColumnUI.descriptionLabel.text.edges"));
                this.table = graphModel.getEdgeTable();
            }
        }
        List supportedTypesWrappers = SupportedColumnTypeWrapper.buildOrderedSupportedTypesList((GraphModel)graphModel);
        for (SupportedColumnTypeWrapper supportedColumnTypeWrapper : supportedTypesWrappers) {
            this.typeComboBox.addItem(supportedColumnTypeWrapper);
        }
        int savedType = NbPreferences.forModule(AddColumnUI.class).getInt(COLUMN_TYPE_SAVED_PREFERENCES, -1);
        if (savedType != -1 && savedType < this.typeComboBox.getItemCount()) {
            this.typeComboBox.setSelectedIndex(savedType);
        } else {
            this.typeComboBox.setSelectedItem(new SupportedColumnTypeWrapper(String.class));
        }
    }

    public void execute() {
        ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).addAttributeColumn(this.table, this.titleTextField.getText(), ((SupportedColumnTypeWrapper)this.typeComboBox.getSelectedItem()).getType());
    }

    public void setOkButton(JButton okButton) {
        this.okButton = okButton;
        this.refreshOkButton();
    }

    private void refreshOkButton() {
        String title = this.titleTextField.getText();
        if (this.okButton != null) {
            this.okButton.setEnabled(title != null && !title.isEmpty() && !this.table.hasColumn(title));
        }
    }

    public static ValidationPanel createValidationPanel(AddColumnUI innerPanel) {
        ValidationPanel validationPanel = new ValidationPanel();
        if (innerPanel == null) {
            innerPanel = new AddColumnUI();
        }
        validationPanel.setInnerComponent((Component)innerPanel);
        ValidationGroup group = validationPanel.getValidationGroup();
        group.add((JTextComponent)innerPanel.titleTextField, new Validator[]{new ColumnTitleValidator(innerPanel.table)});
        return validationPanel;
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.titleTextField = new JTextField();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.descriptionLabel.setHorizontalAlignment(0);
        this.descriptionLabel.setText(null);
        this.titleLabel.setText(NbBundle.getMessage(AddColumnUI.class, (String)"AddColumnUI.titleLabel.text"));
        this.titleTextField.setText(NbBundle.getMessage(AddColumnUI.class, (String)"AddColumnUI.titleTextField.text"));
        this.typeLabel.setText(NbBundle.getMessage(AddColumnUI.class, (String)"AddColumnUI.typeLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, -1, 299, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleTextField, -1, 203, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.typeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.typeComboBox, 0, 199, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.descriptionLabel, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.titleTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.typeComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public static enum Mode {
        NODES_TABLE,
        EDGES_TABLE;

    }
}

