/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NullableLazyValue<T> {
    private boolean myComputed;
    @Nullable
    private T myValue;

    @Nullable
    protected abstract T compute();

    @Nullable
    public T getValue() {
        T value2 = this.myValue;
        if (!this.myComputed) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value2 = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value2;
                this.myComputed = true;
            }
        }
        return value2;
    }

    @NotNull
    public static <T> NullableLazyValue<T> createValue(final @NotNull Factory<? extends T> value2) {
        if (value2 == null) {
            NullableLazyValue.$$$reportNull$$$0(0);
        }
        return new NullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value2.create();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/NullableLazyValue", "createValue"));
    }
}

