/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import com.intellij.core.CoreJavaDirectoryService;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.model.ModelBranchImpl;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.file.PsiPackageBase;
import com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageImpl
extends PsiPackageBase
implements Queryable,
PsiPackage {
    private static final Logger LOG = Logger.getInstance(PsiPackageImpl.class);
    private volatile CachedValue<PsiModifierList> myAnnotationList;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectoriesWithLibSources;
    private volatile SoftReference<Map<String, PsiClass[]>> myClassCache;
    private volatile SoftReference<Map<GlobalSearchScope, Map<String, PsiClass[]>>> myDumbModeFullCache;
    private volatile SoftReference<Map<Pair<GlobalSearchScope, String>, PsiClass[]>> myDumbModePartialCache;

    public PsiPackageImpl(PsiManager manager, String qualifiedName) {
        super(manager, qualifiedName);
    }

    @Override
    protected Collection<PsiDirectory> getAllDirectories(boolean includeLibrarySources) {
        if (includeLibrarySources) {
            if (this.myDirectoriesWithLibSources == null) {
                this.myDirectoriesWithLibSources = this.createCachedDirectories(true);
            }
            return this.myDirectoriesWithLibSources.getValue();
        }
        if (this.myDirectories == null) {
            this.myDirectories = this.createCachedDirectories(false);
        }
        return this.myDirectories.getValue();
    }

    @NotNull
    private CachedValue<Collection<PsiDirectory>> createCachedDirectories(boolean includeLibrarySources) {
        CachedValue<Collection<PsiDirectory>> cachedValue2 = CachedValuesManager.getManager(this.getProject()).createCachedValue(() -> {
            ArrayList result2 = new ArrayList();
            Processor processor2 = Processors.cancelableCollectProcessor(result2);
            this.getFacade().processPackageDirectories(this, this.allScope(), processor2, includeLibrarySources);
            return CachedValueProvider.Result.create(result2, PsiPackageImplementationHelper.getInstance().getDirectoryCachedValueDependencies(this));
        }, false);
        if (cachedValue2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(0);
        }
        return cachedValue2;
    }

    @Override
    protected PsiPackageImpl findPackage(String qName) {
        return (PsiPackageImpl)this.getFacade().findPackage(qName);
    }

    @Override
    public void handleQualifiedNameChange(@NotNull String newQualifiedName) {
        if (newQualifiedName == null) {
            PsiPackageImpl.$$$reportNull$$$0(1);
        }
        PsiPackageImplementationHelper.getInstance().handleQualifiedNameChange(this, newQualifiedName);
    }

    @Override
    public VirtualFile @NotNull [] occursInPackagePrefixes() {
        VirtualFile[] virtualFileArray = PsiPackageImplementationHelper.getInstance().occursInPackagePrefixes(this);
        if (virtualFileArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(2);
        }
        return virtualFileArray;
    }

    @Override
    public PsiPackageImpl getParentPackage() {
        return (PsiPackageImpl)super.getParentPackage();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            PsiPackageImpl.$$$reportNull$$$0(3);
        }
        return javaLanguage;
    }

    @Override
    public boolean isValid() {
        return !this.getProject().isDisposed() && (PsiPackageImplementationHelper.getInstance().packagePrefixExists(this) || !this.getAllDirectories(true).isEmpty());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(4);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitPackage(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiPackage:" + this.getQualifiedName();
    }

    @Override
    public PsiClass @NotNull [] getClasses() {
        PsiClass[] psiClassArray = this.getClasses(this.allScope());
        if (psiClassArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(5);
        }
        return psiClassArray;
    }

    @NotNull
    protected GlobalSearchScope allScope() {
        GlobalSearchScope globalSearchScope = PsiPackageImplementationHelper.getInstance().adjustAllScope(this, GlobalSearchScope.allScope(this.getProject()));
        if (globalSearchScope == null) {
            PsiPackageImpl.$$$reportNull$$$0(6);
        }
        return globalSearchScope;
    }

    @Override
    public PsiClass @NotNull [] getClasses(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(7);
        }
        PsiClass[] psiClassArray = this.getFacade().getClasses(this, scope2);
        if (psiClassArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(8);
        }
        return psiClassArray;
    }

    @Override
    public PsiFile @NotNull [] getFiles(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(9);
        }
        PsiFile[] psiFileArray = this.getFacade().getPackageFiles(this, scope2);
        if (psiFileArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(10);
        }
        return psiFileArray;
    }

    @Override
    @Nullable
    public PsiModifierList getAnnotationList() {
        if (this.myAnnotationList == null) {
            this.myAnnotationList = CachedValuesManager.getManager(this.getProject()).createCachedValue(new PackageAnnotationValueProvider(), false);
        }
        return this.myAnnotationList.getValue();
    }

    @Override
    public PsiPackage @NotNull [] getSubPackages() {
        PsiPackage[] psiPackageArray = this.getSubPackages(this.allScope());
        if (psiPackageArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(11);
        }
        return psiPackageArray;
    }

    @Override
    public PsiPackage @NotNull [] getSubPackages(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(12);
        }
        PsiPackage[] psiPackageArray = this.getFacade().getSubPackages(this, scope2);
        if (psiPackageArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(13);
        }
        return psiPackageArray;
    }

    private JavaPsiFacadeImpl getFacade() {
        return (JavaPsiFacadeImpl)JavaPsiFacade.getInstance(this.getProject());
    }

    private PsiClass @NotNull [] getCachedClassesByName(@NotNull String name, GlobalSearchScope scope2) {
        PsiClass[] classes2;
        DumbService dumbService;
        if (name == null) {
            PsiPackageImpl.$$$reportNull$$$0(14);
        }
        if ((dumbService = DumbService.getInstance(this.getProject())).isDumb() && dumbService.isAlternativeResolveEnabled()) {
            PsiClass[] psiClassArray = this.getCachedClassesInDumbMode(name, scope2);
            if (psiClassArray == null) {
                PsiPackageImpl.$$$reportNull$$$0(15);
            }
            return psiClassArray;
        }
        if (ModelBranchImpl.hasBranchedFilesInScope(scope2)) {
            PsiClass[] psiClassArray = this.findAllClasses(name, scope2);
            if (psiClassArray == null) {
                PsiPackageImpl.$$$reportNull$$$0(16);
            }
            return psiClassArray;
        }
        Map<String, PsiClass[]> map = SoftReference.dereference(this.myClassCache);
        if (map == null) {
            map = ContainerUtil.createConcurrentSoftValueMap();
            this.myClassCache = new SoftReference<ConcurrentMap<String, PsiClass[]>>((ConcurrentMap<String, PsiClass[]>)map);
        }
        if ((classes2 = map.get(name)) != null) {
            if (classes2 == null) {
                PsiPackageImpl.$$$reportNull$$$0(17);
            }
            return classes2;
        }
        classes2 = this.findAllClasses(name, new EverythingGlobalScope(this.getProject()));
        map.put(name, classes2);
        if (classes2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(18);
        }
        return classes2;
    }

    private PsiClass[] findAllClasses(@NotNull String shortName, GlobalSearchScope scope2) {
        String qName;
        if (shortName == null) {
            PsiPackageImpl.$$$reportNull$$$0(19);
        }
        String classQName = !(qName = this.getQualifiedName()).isEmpty() ? qName + "." + shortName : shortName;
        return this.getFacade().findClasses(classQName, scope2);
    }

    private PsiClass[] getCachedClassesInDumbMode(String name, GlobalSearchScope scope2) {
        PsiClass[] classes2;
        Map<String, PsiClass[]> map;
        Map<GlobalSearchScope, Map<String, PsiClass[]>> scopeMap = SoftReference.dereference(this.myDumbModeFullCache);
        if (scopeMap == null) {
            scopeMap = new ConcurrentHashMap<GlobalSearchScope, Map<String, PsiClass[]>>();
            this.myDumbModeFullCache = new SoftReference<ConcurrentHashMap<GlobalSearchScope, Map<String, PsiClass[]>>>((ConcurrentHashMap<GlobalSearchScope, Map<String, PsiClass[]>>)scopeMap);
        }
        if ((map = scopeMap.get(scope2)) == null) {
            PsiClass[] array = this.findClassesHeuristically(name, scope2);
            if (array != null) {
                return array;
            }
            map = new HashMap<String, PsiClass[]>();
            for (PsiClass psiClass : this.getClasses(scope2)) {
                PsiClass[] psiClassArray;
                String psiClassName = psiClass.getName();
                if (psiClassName == null) continue;
                PsiClass[] existing = map.get(psiClassName);
                if (existing == null) {
                    PsiClass[] psiClassArray2 = new PsiClass[1];
                    psiClassArray = psiClassArray2;
                    psiClassArray2[0] = psiClass;
                } else {
                    psiClassArray = ArrayUtil.append(existing, psiClass);
                }
                map.put(psiClassName, psiClassArray);
            }
            scopeMap.put(scope2, map);
        }
        return (classes2 = map.get(name)) == null ? PsiClass.EMPTY_ARRAY : classes2;
    }

    private PsiClass @Nullable [] findClassesHeuristically(String name, GlobalSearchScope scope2) {
        PsiClass[] result2;
        if (this.findSubPackageByName(name) != null) {
            return PsiClass.EMPTY_ARRAY;
        }
        Map<Pair<GlobalSearchScope, String>, PsiClass[]> partial = SoftReference.dereference(this.myDumbModePartialCache);
        if (partial == null) {
            partial = new ConcurrentHashMap<Pair<GlobalSearchScope, String>, PsiClass[]>();
            this.myDumbModePartialCache = new SoftReference<ConcurrentHashMap<Pair<GlobalSearchScope, String>, PsiClass[]>>((ConcurrentHashMap<Pair<GlobalSearchScope, String>, PsiClass[]>)partial);
        }
        if ((result2 = partial.get(Pair.create(scope2, name))) == null) {
            ArrayList<PsiClass> fastClasses = new ArrayList<PsiClass>();
            for (PsiDirectory directory : this.getDirectories(scope2)) {
                PsiClass[] classes2;
                List<PsiFile> sameNamed = ContainerUtil.filter(directory.getFiles(), file2 -> file2.getName().contains(name));
                for (PsiClass aClass2 : classes2 = CoreJavaDirectoryService.getPsiClasses(directory, sameNamed.toArray(PsiFile.EMPTY_ARRAY))) {
                    if (!name.equals(aClass2.getName())) continue;
                    fastClasses.add(aClass2);
                }
            }
            if (!fastClasses.isEmpty()) {
                result2 = fastClasses.toArray(PsiClass.EMPTY_ARRAY);
                partial.put(Pair.create(scope2, name), result2);
            }
        }
        return result2;
    }

    @Override
    public boolean containsClassNamed(@NotNull String name) {
        if (name == null) {
            PsiPackageImpl.$$$reportNull$$$0(20);
        }
        return this.getCachedClassesByName(name, new EverythingGlobalScope(this.getProject())).length > 0;
    }

    @Override
    public PsiClass @NotNull [] findClassByShortName(@NotNull String name, @NotNull GlobalSearchScope scope2) {
        PsiClass[] allClasses;
        if (name == null) {
            PsiPackageImpl.$$$reportNull$$$0(21);
        }
        if (scope2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(22);
        }
        if ((allClasses = this.getCachedClassesByName(name, scope2)).length == 0) {
            if (allClasses == null) {
                PsiPackageImpl.$$$reportNull$$$0(23);
            }
            return allClasses;
        }
        if (allClasses.length == 1) {
            PsiClass[] psiClassArray = PsiSearchScopeUtil.isInScope(scope2, (PsiElement)allClasses[0]) ? (PsiClass[])allClasses.clone() : PsiClass.EMPTY_ARRAY;
            if (psiClassArray == null) {
                PsiPackageImpl.$$$reportNull$$$0(24);
            }
            return psiClassArray;
        }
        PsiClass[] psiClassArray = ((StreamEx)((StreamEx)StreamEx.of(allClasses).filter(aClass2 -> PsiSearchScopeUtil.isInScope(scope2, (PsiElement)aClass2))).sorted(PsiClassUtil.createScopeComparator(scope2).thenComparing(c -> c.getQualifiedName(), Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(c -> {
            PsiFile file2 = c.getContainingFile();
            return file2 instanceof PsiJavaFile ? ((PsiJavaFile)file2).getPackageName() : "";
        }))).toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiPackageImpl.$$$reportNull$$$0(25);
        }
        return psiClassArray;
    }

    @Nullable
    private PsiPackage findSubPackageByName(@NotNull String name) {
        String qName;
        if (name == null) {
            PsiPackageImpl.$$$reportNull$$$0(26);
        }
        String subpackageQName = (qName = this.getQualifiedName()).isEmpty() ? name : qName + "." + name;
        return this.getFacade().findPackage(subpackageQName);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        String providedName;
        if (processor2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(27);
        }
        if (state == null) {
            PsiPackageImpl.$$$reportNull$$$0(28);
        }
        if (place == null) {
            PsiPackageImpl.$$$reportNull$$$0(29);
        }
        GlobalSearchScope scope2 = place.getResolveScope();
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor2.getHint(ElementClassHint.KEY);
        Condition<String> nameCondition = processor2.getHint(JavaCompletionHints.NAME_FILTER);
        NameHint providedNameHint = processor2.getHint(NameHint.KEY);
        String string2 = providedName = providedNameHint == null ? null : providedNameHint.getName(state);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiClass[] classes2;
            if (providedName != null) {
                classes2 = this.findClassByShortName(providedName, scope2);
                if (classes2.length == 0 && PsiUtil.isInsideJavadocComment(place)) {
                    classes2 = this.findClassByShortName(providedName, this.allScope());
                }
                if (!PsiPackageImpl.processClasses(processor2, state, classes2, Conditions.alwaysTrue())) {
                    return false;
                }
            } else {
                classes2 = this.getClasses(scope2);
                if (classes2.length == 0 && PsiUtil.isInsideJavadocComment(place)) {
                    classes2 = this.getClasses(this.allScope());
                }
                if (!PsiPackageImpl.processClasses(processor2, state, classes2, nameCondition != null ? nameCondition : Conditions.alwaysTrue())) {
                    return false;
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE)) {
            if (providedName != null) {
                PsiPackage aPackage = this.findSubPackageByName(providedName);
                if (aPackage != null && !processor2.execute(aPackage, state)) {
                    return false;
                }
            } else {
                PsiPackage[] packs;
                for (PsiPackage pack : packs = this.getSubPackages(scope2)) {
                    String packageName = pack.getName();
                    if (packageName == null || !PsiNameHelper.getInstance(this.getProject()).isIdentifier(packageName, PsiUtil.getLanguageLevel(this)) || processor2.execute(pack, state)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processClasses(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiClass @NotNull [] classes2, @NotNull Condition<? super String> nameCondition) {
        if (processor2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(30);
        }
        if (state == null) {
            PsiPackageImpl.$$$reportNull$$$0(31);
        }
        if (nameCondition == null) {
            PsiPackageImpl.$$$reportNull$$$0(32);
        }
        if (classes2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(33);
        }
        for (PsiClass aClass2 : classes2) {
            String name = aClass2.getName();
            if (name == null || !nameCondition.value(name)) continue;
            try {
                if (processor2.execute(aClass2, state)) continue;
                return false;
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        return true;
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiPackageImplementationHelper.getInstance().navigate(this, requestFocus);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayHaveContentInScope(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            PsiPackageImpl.$$$reportNull$$$0(34);
        }
        if (this.getDirectories(scope2).length > 0) return true;
        if (this.getClasses(scope2).length > 0) return true;
        if (!ContainerUtil.exists(this.occursInPackagePrefixes(), scope2::contains)) return false;
        return true;
    }

    @Override
    @Nullable
    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            PsiPackageImpl.$$$reportNull$$$0(35);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/PsiPackageImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newQualifiedName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 22: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameCondition";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedDirectories";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/PsiPackageImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "occursInPackagePrefixes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "allScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedClassesByName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassByShortName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleQualifiedNameChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCachedClassesByName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findAllClasses";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "containsClassNamed";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findClassByShortName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findSubPackageByName";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processClasses";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveContentInScope";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class PackageAnnotationValueProvider
    implements CachedValueProvider<PsiModifierList> {
        private PackageAnnotationValueProvider() {
        }

        @Override
        public CachedValueProvider.Result<PsiModifierList> compute() {
            ArrayList modifiers2 = new ArrayList();
            for (PsiDirectory psiDirectory : PsiPackageImpl.this.getDirectories()) {
                PsiFile file2 = psiDirectory.findFile("package-info.java");
                PsiPackageStatement stmt = file2 == null ? null : PsiTreeUtil.getChildOfType(file2, PsiPackageStatement.class);
                PsiModifierList modifierList2 = stmt == null ? null : stmt.getAnnotationList();
                ContainerUtil.addIfNotNull(modifiers2, modifierList2);
            }
            for (NavigatablePsiElement navigatablePsiElement : PsiPackageImpl.this.getFacade().findClasses(PsiPackageImpl.this.getQualifiedName() + ".package-info", PsiPackageImpl.this.allScope())) {
                ContainerUtil.addIfNotNull(modifiers2, navigatablePsiElement.getModifierList());
            }
            PsiCompositeModifierList result2 = modifiers2.isEmpty() ? null : new PsiCompositeModifierList(PsiPackageImpl.this.getManager(), modifiers2);
            return new CachedValueProvider.Result<PsiModifierList>(result2, PsiModificationTracker.MODIFICATION_COUNT);
        }
    }
}

