/*
   SPDX-FileCopyrightText: 2017-2020 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#ifndef RECIPIENTSPICKERWIDGET_H
#define RECIPIENTSPICKERWIDGET_H

#include <QWidget>
#include "akonadi-contact_export.h"
class QAbstractItemModel;
class QTreeView;
namespace Akonadi {
class EmailAddressSelectionWidget;
class AKONADI_CONTACT_EXPORT RecipientsPickerWidget : public QWidget
{
    Q_OBJECT
public:
    explicit RecipientsPickerWidget(bool onlyShowEmailWithAddress, QAbstractItemModel *model, QWidget *parent = nullptr);
    ~RecipientsPickerWidget();
    Q_REQUIRED_RESULT QTreeView *view() const;

    Q_REQUIRED_RESULT Akonadi::EmailAddressSelectionWidget *emailAddressSelectionWidget() const;
private:
    Akonadi::EmailAddressSelectionWidget *mView = nullptr;
};
}

#endif // RECIPIENTSPICKERWIDGET_H
